/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetaxcertificate;

import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;

public class LStBHelper {
    private static final BigDecimal ZERO2 = BigDecimal.valueOf(0L, 2);

    public static BigDecimal toScale2(BigDecimal bigDecimal) {
        return BigDecimalMapper.isZeroOrNull((BigDecimal)bigDecimal) ? ZERO2 : bigDecimal.setScale(2, RoundingMode.HALF_UP);
    }

    public static BigDecimal toScale(int scale, BigDecimal bigDecimal) {
        return BigDecimalMapper.isZeroOrNull((BigDecimal)bigDecimal) ? BigDecimal.ZERO.setScale(scale, RoundingMode.HALF_UP) : bigDecimal.setScale(scale, RoundingMode.HALF_UP);
    }

    public static String toCurrencyFormat(BigDecimal bigDecimal) {
        Object result = BigDecimalMapper.toString((BigDecimal)LStBHelper.toScale2(bigDecimal)).replace('.', ',');
        int length = ((String)result).length();
        if (((String)result).charAt(0) == '-') {
            --length;
        }
        if (length >= 7 && length < 10) {
            String temp1 = ((String)result).substring(0, ((String)result).length() - 6);
            String temp2 = ((String)result).substring(((String)result).length() - 6);
            result = temp1 + "." + temp2;
        } else if (length >= 10) {
            String temp1 = ((String)result).substring(0, ((String)result).length() - 9);
            String temp2 = ((String)result).substring(((String)result).length() - 9, ((String)result).length() - 6);
            String temp3 = ((String)result).substring(((String)result).length() - 6);
            result = temp1 + "." + temp2 + "." + temp3;
        }
        return result;
    }

    public static String toCurrencyFormatCentEuroSeparated(BigDecimal value) {
        String temp2;
        Object temp1;
        Object temp;
        int length;
        boolean isNegative;
        boolean bl = isNegative = (value = LStBHelper.toScale2(value)).signum() == -1;
        if (isNegative) {
            value = value.multiply(new BigDecimal(-1));
        }
        if ((length = ((String)(temp = BigDecimalMapper.toString((BigDecimal)value))).length()) == 4 && ((String)temp).equals("0.00")) {
            return "";
        }
        temp = ((String)temp).replace('.', ',');
        if (length >= 7 && length < 10) {
            temp1 = ((String)temp).substring(0, length - 6);
            temp2 = ((String)temp).substring(length - 6, length);
            temp = (String)temp1 + "." + temp2;
        }
        if (length >= 10) {
            temp1 = ((String)temp).substring(0, length - 9);
            temp2 = ((String)temp).substring(length - 9, length - 6);
            String temp3 = ((String)temp).substring(length - 6, length);
            temp = (String)temp1 + "." + temp2 + "." + temp3;
        }
        length = ((String)temp).length();
        temp1 = ((String)temp).substring(0, length - 3);
        if (isNegative) {
            temp1 = "-" + (String)temp1;
        }
        temp2 = ((String)temp).substring(length - 2, length);
        temp = (String)temp1 + "   " + temp2;
        return temp;
    }

    public static Map<String, Object> createParameters(int year, boolean besondereLStB, boolean internalUse, Date actualDate) {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put("internalUse", internalUse ? "Interner Gebrauch" : "");
        parameters.put("staticText_Header", besondereLStB ? "Besondere Lohnsteuerbescheinigung f\u00fcr das Kalenderjahr" : "Ausdruck der elektronischen Lohnsteuerbescheinigung f\u00fcr");
        parameters.put("staticText_SubHeader", besondereLStB ? "Auf Verlangen dem Arbeitnehmer aush\u00e4ndigen, sonst bis zum 31. Dezember " + (year + 1) + " dem Finanzamt der Betriebsst\u00e4tte einsenden" : (internalUse ? "Nachstehende Daten wurden nicht maschinell an die Finanzverwaltung \u00fcbertragen." : "Nachstehende Daten wurden maschinell an die Finanzverwaltung \u00fcbertragen."));
        parameters.put("staticText_personnelnumber", "Personalnummer:");
        parameters.put("staticText_dateOfBirth", "Geburtsdatum:");
        parameters.put("staticText_taxOffice", "Finanzamt, an das die Lohnsteuer abgef\u00fchrt wurde ");
        parameters.put("staticText_taxOffice_bracket", "(Name und vierstellige Nr.)");
        parameters.put("staticText_employer", besondereLStB ? "Arbeitgeber" : "Anschrift und Steuernummer des Arbeitgebers:");
        parameters.put("staticText_ActualDateString", DateMapper.toDDMMYYYYPointSeparationString((Date)actualDate));
        parameters.put("staticText_number_1", "Bescheinigungszeitraum");
        parameters.put("staticText_number_2A", "Zeitr\u00e4ume ohne Anspruch auf Arbeitslohn");
        if (year == 2022) {
            parameters.put("staticText_number_2B", "Gro\u00dfbuchstaben (E, S, M, F, FR)");
        } else if (year >= 2017) {
            parameters.put("staticText_number_2B", "Gro\u00dfbuchstaben (S, M, F, FR)");
        } else {
            parameters.put("staticText_number_2B", "Gro\u00dfbuchstaben (S, M, F)");
        }
        parameters.put("staticText_number_3", "Bruttoarbeitslohn einschl. Sachbez\u00fcge ohne 9. und 10.");
        parameters.put("staticText_number_4", "Einbehaltene Lohnsteuer von 3.");
        parameters.put("staticText_number_5", "Einbehaltener Solidarit\u00e4tszuschlag von 3.");
        parameters.put("staticText_number_6", "Einbehaltene Kirchensteuer des Arbeitnehmers von 3.");
        parameters.put("staticText_number_7", "Einbehaltene Kirchensteuer des Ehegatten/Lebenspartners von 3. (nur bei Konfessionsverschiedenheit)");
        parameters.put("staticText_number_8", "In 3. enthaltene Versorgungsbez\u00fcge");
        parameters.put("staticText_number_9", "Erm\u00e4\u00dfigt besteuerte Versorgungsbez\u00fcge f\u00fcr mehrere Kalenderjahre");
        parameters.put("staticText_number_10", "Erm\u00e4\u00dfigt besteuerter Arbeitslohn f\u00fcr mehrere Kalenderjahre (ohne 9.) und erm\u00e4\u00dfigt besteuerte Entsch\u00e4digungen");
        parameters.put("staticText_number_11", "Einbehaltene Lohnsteuer von 9. und 10.");
        parameters.put("staticText_number_12", "Einbehaltener Solidarit\u00e4tszuschlag von 9. und 10.");
        parameters.put("staticText_number_13", "Einbehaltene Kirchensteuer des Arbeitnehmers von 9. und 10.");
        parameters.put("staticText_number_14", "Einbehaltene Kirchensteuer des Ehegatten/Lebenspartners von 9. und 10. (nur bei Konfessionsverschiedenheit)");
        parameters.put("staticText_number_15", "(Saison-)Kurzarbeitergeld, Zuschuss zum Mutterschaftsgeld, Verdienstausfallentsch\u00e4digung (Infektionsschutzgesetz), Aufstockungsbetrag und Altersteilzeitzuschlag");
        parameters.put("staticText_number_16", "Steuerfreier Arbeitslohn nach");
        parameters.put("staticText_number_16_up", "a) Doppelbesteuerungsabkommen (DBA)");
        parameters.put("staticText_number_16_down", "b) Auslandst\u00e4tigkeitserlass");
        parameters.put("staticText_number_17", year <= 2019 ? "Steuerfreie Arbeitgeberleistungen f\u00fcr Fahrten zwischen Wohnung und erster T\u00e4tigkeitsst\u00e4tte" : "Steuerfreie Arbeitgeberleistungen, die auf die Entfernungspauschale anzurechnen sind");
        parameters.put("staticText_number_18", year <= 2020 ? "Pauschal besteuerte Arbeitgeberleistungen f\u00fcr Fahrten zwischen Wohnung und erster T\u00e4tigkeitsst\u00e4tte" : "Pauschal mit 15 % besteuerte Arbeitgeberleistungen f\u00fcr Fahrten zwischen Wohnung und erster T\u00e4tigkeitsst\u00e4tte");
        parameters.put("staticText_number_19", "Steuerpflichtige Entsch\u00e4digungen und Arbeitslohn f\u00fcr mehrere Kalenderjahre, die nicht erm\u00e4\u00dfigt besteuert wurden - in 3. enthalten");
        parameters.put("staticText_number_20", "Steuerfreie Verpflegungszusch\u00fcsse bei Ausw\u00e4rtst\u00e4tigkeit");
        parameters.put("staticText_number_21", "Steuerfreie Arbeitgeberleistungen bei doppelter Haushaltsf\u00fchrung");
        parameters.put("staticText_number_22", "Arbeitgeber-\nanteil/\n-zuschuss");
        parameters.put("staticText_number_22a", "a) zur gesetzlichen Rentenversicherung");
        parameters.put("staticText_number_22b", "b) an berufsst\u00e4ndische Versorgungseinrichtungen");
        parameters.put("staticText_number_23", "Arbeitnehmer-\nanteil");
        parameters.put("staticText_number_23a", "a) zur gesetzlichen Rentenversicherung");
        parameters.put("staticText_number_23b", "b) an berufsst\u00e4ndische Versorgungseinrichtungen");
        parameters.put("staticText_number_24", "Steuerfreie\nArbeitgeber-\nzusch\u00fcsse");
        parameters.put("staticText_number_24a", "a) zur gesetzlichen Krankenversicherung");
        parameters.put("staticText_number_24b", "b) zur privaten Krankenversicherung");
        parameters.put("staticText_number_24c", "c) zur gesetzlichen Pflegeversicherung");
        parameters.put("staticText_number_25", "Arbeitnehmerbeitr\u00e4ge zur gesetzlichen Krankenversicherung");
        parameters.put("staticText_number_26", "Arbeitnehmerbeitr\u00e4ge zur sozialen Pflegeversicherung");
        parameters.put("staticText_number_27", "Arbeitnehmerbeitr\u00e4ge zur Arbeitslosenversicherung");
        parameters.put("staticText_number_28", "Beitr\u00e4ge zur privaten Kranken- und Pflege-Pflichtversicherung \noder Mindestvorsorgepauschale");
        parameters.put("staticText_number_29", "Bemessungsgrundlage f\u00fcr den Versorgungsfreibetrag zu 8.");
        parameters.put("staticText_number_30", "Ma\u00dfgebendes Kalenderjahr des Versorgungsbeginns zu 8. und/oder 9.");
        parameters.put("staticText_number_31", "Zu 8. bei unterj\u00e4hriger Zahlung: Erster und letzter Monat, f\u00fcr den Versorgungsbez\u00fcge gezahlt wurden");
        parameters.put("staticText_number_32", "Sterbegeld; Kapitalauszahlungen/Abfindungen und Nachzahlungen von Versorgungsbez\u00fcgen - in 3. und 8. enthalten");
        parameters.put("staticText_number_33", "Ausgezahltes Kindergeld");
        parameters.put("staticText_number_34", "Freibetrag DBA T\u00fcrkei");
        parameters.put("staticText_wageTaxReductionTitle", besondereLStB ? "Dem Lohnsteuerabzug wurden zugrunde gelegt:" : "Dem Lohnsteuerabzug wurde zugrunde gelegt:");
        parameters.put("staticText_identNr", "Identifikationsnummer:");
        if (besondereLStB) {
            parameters.put("staticText_WageTaxOfficeCertificate", "Bescheinigung des Finanzamtes");
            parameters.put("staticText_WageTaxOffice", "Finanzamt");
            parameters.put("staticText_LocationDate", "Ort, Datum");
            parameters.put("staticText_EmployerAdress", "Anschrift der Betriebsst\u00e4tte (Stra\u00dfe, Hausnummer und Ort)");
            parameters.put("staticText_StampSignature", "(Stempel/Unterschrift)");
            parameters.put("staticText_Employee", "Arbeitnehmer");
            parameters.put("staticText_X", "X");
            parameters.put("staticText_shown", "Vorgelegen hat:");
            parameters.put("staticText_PersonInChargeTelefone", "Telefon");
        } else {
            parameters.put("staticText_etin", "eTIN:");
            parameters.put("staticText_employerTaxNumber", "Steuernummer des Arbeitgebers:");
        }
        return parameters;
    }
}

