/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetax.mapper;

import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.BusinessDomainException;
import com.varial.serverbase.mapper.ExceptionMapper;

public class WTExceptionMapper {
    private static final String CLASS_GENERAL = "PYLohnsteueranmeldung";
    private static final String reportAbortMessage = "Reportdatei wurde nicht erzeugt.\n";
    private static final int USER_EMAIL_MISSED = 1005;
    private static final int USER_PHONE_MISSED = 1006;
    private static final int NO_DIFFERENCES_IN_THE_EPP = 1007;
    @Errors
    private static final ErrorList mErrorList = new ErrorList("PYLohnsteueranmeldung", new ErrorMessage[]{new ErrorMessage(1005, "Keine E-Mail-Adresse in den Benutzereinstellungen. E-Mail-Adresse und Telefonnummer sind zur Daten\u00fcbertragung erforderlich."), new ErrorMessage(1006, "Keine Telefonnummer in den Benutzereinstellungen. E-Mail-Adresse und Telefonnummer sind zur Daten\u00fcbertragung erforderlich."), new ErrorMessage(1007, "Es wird keine berichtigte Lohnsteueranmeldung \u00fcbermittelt, da es in der Energiepreispauschale keine Differenzen zum Vormonat gibt.")});

    private static BusinessDomainException makeBusinessDomainException(int errornr, String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)errornr, (String)(reportAbortMessage + mErrorList.getDefaultString(errornr) + message));
    }

    public static BusinessDomainException makeUserEmailMissedDomainException() {
        return WTExceptionMapper.makeBusinessDomainException(1005, "");
    }

    public static BusinessDomainException makeUserPhoneMissedDomainException() {
        return WTExceptionMapper.makeBusinessDomainException(1006, "");
    }

    public static BusinessDomainException makeNoDifferencesInTheEPPDomainException() {
        return WTExceptionMapper.makeBusinessDomainException(1007, "");
    }
}

