/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetax;

import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.reports.library.ReportEmployeesHandlingHelper;
import com.varial.personnel.domain.reports.wagetax.WageTaxEmployeeBean;
import com.varial.personnel.domain.reports.wagetax.WageTaxReportDataSource;
import com.varial.personnel.domain.reports.wagetax.WageTaxSetFederalstateChurchTax2019;
import com.varial.personnel.domain.reports.wagetax.WageTaxSetFederalstateChurchTaxBean;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.serverbase.basictypes.VDate;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WageTaxValuePositonFactory2019 {
    private WageTaxEmployeeBean mEWT;
    private Date mEmployeeEffectiveDate;
    private Date mEffectiveDateEPP;
    private Date mEmployeeStartDate;
    private Date mEmployeeEndDate;
    private String FIELD_z_25_text = "";
    private String FIELD_z_26_text = "";
    private String FIELD_z_27_text = "";
    private String FIELD_z_28_text = "";
    private String FIELD_z_29_text = "";
    private String FIELD_z_30_text = "";
    private String FIELD_z_31_text = "";
    private String FIELD_z_32_text = "";
    private String FIELD_z_25_short_text = "";
    private String FIELD_z_26_short_text = "";
    private String FIELD_z_27_short_text = "";
    private String FIELD_z_28_short_text = "";
    private String FIELD_z_29_short_text = "";
    private String FIELD_z_30_short_text = "";
    private String FIELD_z_31_short_text = "";
    private String FIELD_z_32_short_text = "";
    private String FIELD_z_25_nr = "";
    private String FIELD_z_26_nr = "";
    private String FIELD_z_27_nr = "";
    private String FIELD_z_28_nr = "";
    private String FIELD_z_29_nr = "";
    private String FIELD_z_30_nr = "";
    private String FIELD_z_31_nr = "";
    private String FIELD_z_32_nr = "";
    private BigDecimal steuerPflichtigesBrutto = BigDecimal.ZERO;
    private BigDecimal FIELD_LSt = BigDecimal.ZERO;
    private BigDecimal FIELD_pausch_ohne37 = BigDecimal.ZERO;
    private BigDecimal FIELD_pausch_nach37 = BigDecimal.ZERO;
    private BigDecimal FIELD_KG = BigDecimal.ZERO;
    private final BigDecimal FIELD_kuerzung_besatzungsmitglieder_handelschiffen = BigDecimal.ZERO;
    private BigDecimal FIELD_foerderbetragBAV = BigDecimal.ZERO;
    private BigDecimal FIELD_energiepreispauschale = BigDecimal.ZERO;
    private BigDecimal FIELD_verbleib = BigDecimal.ZERO;
    private BigDecimal FIELD_SolZ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_25 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_26 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_27 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_28 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_29 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_30 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_31 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_32 = BigDecimal.ZERO;
    private BigDecimal FIELD_gesamt = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_lst_zwi_su = BigDecimal.ZERO;
    private BigDecimal FIELD_erst_soli_zwi_su = BigDecimal.ZERO;
    private final List<String> mFoerderungBAVList = new LinkedList<String>();
    private boolean mMitEEP = false;
    private BigDecimal mEPPAktuellerMonat = BigDecimal.ZERO;
    private BigDecimal mEPPVormonatMonat = BigDecimal.ZERO;
    private List<ValuepositionContainer> mValuePositionli;

    public void run(WageTaxReportDataSource wageTaxReportDataSource, WageTaxEmployeeBean eWT, String[] valueTypeNumbers, boolean mitEEP) {
        this.mEWT = eWT;
        this.mEmployeeEffectiveDate = eWT.getEmployeeEffectiveDate();
        this.mEffectiveDateEPP = wageTaxReportDataSource.getEffectiveDateEPP();
        this.mEmployeeStartDate = eWT.getEmployeeStartDate();
        this.mEmployeeEndDate = eWT.getEmployeeEndDate();
        this.mValuePositionli = ReportEmployeesHandlingHelper.getValuePositionsLi((String)eWT.getOidEmployee(), (String[])valueTypeNumbers, (Date)this.mEmployeeEffectiveDate, (Date)this.mEmployeeStartDate, (Date)this.mEmployeeEndDate);
        this.mMitEEP = mitEEP;
        this.distinguishWageTaxValues();
        this.setData();
        this.setWageTaxEmployeeBeanValues();
    }

    private void setWageTaxEmployeeBeanValues() {
        this.mEWT.setWageTaxEmployeeBeanValuesAb2018(this.steuerPflichtigesBrutto, this.FIELD_LSt, this.FIELD_pausch_ohne37, this.FIELD_KG, this.FIELD_pausch_nach37, this.FIELD_kuerzung_besatzungsmitglieder_handelschiffen, this.FIELD_foerderbetragBAV, this.FIELD_energiepreispauschale, this.FIELD_verbleib, this.FIELD_SolZ, this.FIELD_z_25, this.FIELD_z_26, this.FIELD_z_27, this.FIELD_z_28, this.FIELD_z_29, this.FIELD_z_30, this.FIELD_z_31, this.FIELD_z_32, BigDecimal.ZERO, this.FIELD_gesamt, this.FIELD_z_25_text, this.FIELD_z_26_text, this.FIELD_z_27_text, this.FIELD_z_28_text, this.FIELD_z_29_text, this.FIELD_z_30_text, this.FIELD_z_31_text, this.FIELD_z_32_text, "", this.FIELD_z_25_short_text, this.FIELD_z_26_short_text, this.FIELD_z_27_short_text, this.FIELD_z_28_short_text, this.FIELD_z_29_short_text, this.FIELD_z_30_short_text, this.FIELD_z_31_short_text, this.FIELD_z_32_short_text, "", this.FIELD_z_25_nr, this.FIELD_z_26_nr, this.FIELD_z_27_nr, this.FIELD_z_28_nr, this.FIELD_z_29_nr, this.FIELD_z_30_nr, this.FIELD_z_31_nr, this.FIELD_z_32_nr, "");
    }

    private void distinguishWageTaxValues() {
        if (this.mEWT.getLicense().equals("AK") && this.mEWT.getCalculateEmployeeKammerBeitrag()) {
            this.getValuesKammerBeitrag();
        } else {
            this.getWageTaxValuePostionEmployeeBean();
        }
    }

    private void setData() {
        this.FIELD_verbleib = this.FIELD_verbleib.add(this.FIELD_LSt).add(this.FIELD_pausch_ohne37).add(this.FIELD_pausch_nach37).subtract(this.FIELD_KG).subtract(this.FIELD_foerderbetragBAV).subtract(this.FIELD_energiepreispauschale);
        this.FIELD_gesamt = BigDecimal.ZERO;
        this.FIELD_gesamt = this.FIELD_gesamt.add(this.FIELD_LSt).add(this.FIELD_pausch_ohne37).add(this.FIELD_SolZ).add(this.FIELD_pausch_nach37).add(this.FIELD_z_25).add(this.FIELD_z_26).add(this.FIELD_z_27).add(this.FIELD_z_28).add(this.FIELD_z_29).add(this.FIELD_z_30).add(this.FIELD_z_31).add(this.FIELD_z_32).subtract(this.FIELD_KG).subtract(this.FIELD_foerderbetragBAV).subtract(this.FIELD_energiepreispauschale).setScale(2, RoundingMode.UP);
    }

    private void setChurchTaxFields(WageTaxSetFederalstateChurchTax2019 wTSetFSChurchTax) {
        this.FIELD_z_25_text = wTSetFSChurchTax.getFIELD_z_25_text();
        this.FIELD_z_25_short_text = wTSetFSChurchTax.getFIELD_z_25_short_text();
        this.FIELD_z_25_nr = wTSetFSChurchTax.getFIELD_z_25_nr();
        this.FIELD_z_26_text = wTSetFSChurchTax.getFIELD_z_26_text();
        this.FIELD_z_26_short_text = wTSetFSChurchTax.getFIELD_z_26_short_text();
        this.FIELD_z_26_nr = wTSetFSChurchTax.getFIELD_z_26_nr();
        this.FIELD_z_27_text = wTSetFSChurchTax.getFIELD_z_27_text();
        this.FIELD_z_27_short_text = wTSetFSChurchTax.getFIELD_z_27_short_text();
        this.FIELD_z_27_nr = wTSetFSChurchTax.getFIELD_z_27_nr();
        this.FIELD_z_28_text = wTSetFSChurchTax.getFIELD_z_28_text();
        this.FIELD_z_28_short_text = wTSetFSChurchTax.getFIELD_z_28_short_text();
        this.FIELD_z_28_nr = wTSetFSChurchTax.getFIELD_z_28_nr();
        this.FIELD_z_29_text = wTSetFSChurchTax.getFIELD_z_29_text();
        this.FIELD_z_29_short_text = wTSetFSChurchTax.getFIELD_z_29_short_text();
        this.FIELD_z_29_nr = wTSetFSChurchTax.getFIELD_z_29_nr();
        this.FIELD_z_30_text = wTSetFSChurchTax.getFIELD_z_30_text();
        this.FIELD_z_30_short_text = wTSetFSChurchTax.getFIELD_z_30_short_text();
        this.FIELD_z_30_nr = wTSetFSChurchTax.getFIELD_z_30_nr();
        this.FIELD_z_31_text = wTSetFSChurchTax.getFIELD_z_31_text();
        this.FIELD_z_31_short_text = wTSetFSChurchTax.getFIELD_z_31_short_text();
        this.FIELD_z_31_nr = wTSetFSChurchTax.getFIELD_z_31_nr();
        this.FIELD_z_32_text = wTSetFSChurchTax.getFIELD_z_32_text();
        this.FIELD_z_32_short_text = wTSetFSChurchTax.getFIELD_z_32_short_text();
        this.FIELD_z_32_nr = wTSetFSChurchTax.getFIELD_z_32_nr();
        this.FIELD_z_25 = this.FIELD_z_25.add(wTSetFSChurchTax.getFIELD_z_25());
        this.FIELD_z_26 = this.FIELD_z_26.add(wTSetFSChurchTax.getFIELD_z_26());
        this.FIELD_z_27 = this.FIELD_z_27.add(wTSetFSChurchTax.getFIELD_z_27());
        this.FIELD_z_28 = this.FIELD_z_28.add(wTSetFSChurchTax.getFIELD_z_28());
        this.FIELD_z_29 = this.FIELD_z_29.add(wTSetFSChurchTax.getFIELD_z_29());
        this.FIELD_z_30 = this.FIELD_z_30.add(wTSetFSChurchTax.getFIELD_z_30());
        this.FIELD_z_31 = this.FIELD_z_31.add(wTSetFSChurchTax.getFIELD_z_31());
        this.FIELD_z_32 = this.FIELD_z_32.add(wTSetFSChurchTax.getFIELD_z_32());
    }

    private void setChruchTaxLSTJAFields(WageTaxSetFederalstateChurchTax2019 wTSetFSChurchTax) {
        WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = wTSetFSChurchTax.getMWTSFChurchTaxBean();
        if (wTSFChurchTaxBean != null) {
            this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
            this.FIELD_z_26 = this.FIELD_z_26.add(wTSFChurchTaxBean.getZ_26());
            this.FIELD_z_27 = this.FIELD_z_27.add(wTSFChurchTaxBean.getZ_27());
            this.FIELD_z_28 = this.FIELD_z_28.add(wTSFChurchTaxBean.getZ_28());
            this.FIELD_z_29 = this.FIELD_z_29.add(wTSFChurchTaxBean.getZ_29());
            this.FIELD_z_30 = this.FIELD_z_30.add(wTSFChurchTaxBean.getZ_30());
            this.FIELD_z_31 = this.FIELD_z_31.add(wTSFChurchTaxBean.getZ_31());
            this.FIELD_z_32 = this.FIELD_z_32.add(wTSFChurchTaxBean.getZ_32());
        }
    }

    private void getTaxLSTJA() {
        this.FIELD_LSt = this.FIELD_LSt.add(this.FIELD_erst_lst_zwi_su);
        this.FIELD_SolZ = this.FIELD_SolZ.add(this.FIELD_erst_soli_zwi_su);
    }

    private void getValuesKammerBeitrag() {
        WageTaxSetFederalstateChurchTax2019 wageTaxSetFederalstateChurchTax2019 = new WageTaxSetFederalstateChurchTax2019(this.mEWT, this.mValuePositionli);
        wageTaxSetFederalstateChurchTax2019.runForChrchTaxKammerBeitrag();
        this.setChurchTaxFields(wageTaxSetFederalstateChurchTax2019);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getLSTJAValues() {
        Iterator<ValuepositionContainer> valuePositionit = this.mValuePositionli.iterator();
        block9: while (valuePositionit.hasNext()) {
            ValuepositionContainer valuepositionContainer = valuePositionit.next();
            switch (valuepositionContainer.valuetypenumber) {
                case 760100: 
                case 760110: 
                case 760450: 
                case 760460: {
                    Date beginDate = new VDate(this.mEmployeeStartDate).getDate();
                    Date endDate = new VDate(this.mEmployeeEndDate).getDate();
                    if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeEndDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeStartDate)) continue block9;
                    beginDate = DateHelper.after((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeStartDate) ? valuepositionContainer.validfrom : this.mEmployeeStartDate;
                    endDate = DateHelper.before((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeEndDate) ? valuepositionContainer.validuntil : this.mEmployeeEndDate;
                    endDate = DateHelper.getLastDayOfMonth((Date)endDate);
                    switch (valuepositionContainer.valuetypenumber) {
                        case 760450: {
                            if (new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                            this.FIELD_erst_lst_zwi_su = this.FIELD_erst_lst_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 760100: {
                            if (new VDate(beginDate).getMonth() != 11) break;
                            this.FIELD_erst_lst_zwi_su = this.FIELD_erst_lst_zwi_su.subtract(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 760460: {
                            if (new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                            this.FIELD_erst_soli_zwi_su = this.FIELD_erst_soli_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 760110: {
                            if (new VDate(beginDate).getMonth() != 11) break;
                            this.FIELD_erst_soli_zwi_su = this.FIELD_erst_soli_zwi_su.subtract(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        }
                    }
                    continue block9;
                }
            }
        }
        return;
    }

    private void getWageTaxValuePostionEmployeeBean() {
        WageTaxSetFederalstateChurchTax2019 wageTaxSetFederalstateChurchTax2019 = new WageTaxSetFederalstateChurchTax2019(this.mEWT, this.mValuePositionli);
        wageTaxSetFederalstateChurchTax2019.runForChrchTax();
        if (new VDate(this.mEmployeeStartDate).getMonth() == 11) {
            this.getLSTJAValues();
            this.getTaxLSTJA();
            this.setChruchTaxLSTJAFields(wageTaxSetFederalstateChurchTax2019);
        }
        this.getTax();
        this.setChurchTaxFields(wageTaxSetFederalstateChurchTax2019);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getTax() {
        block12: for (ValuepositionContainer valuepositionContainer : this.mValuePositionli) {
            switch (valuepositionContainer.valuetypenumber) {
                case 110000: 
                case 220050: 
                case 223050: 
                case 710510: 
                case 710520: 
                case 728300: 
                case 728800: 
                case 760500: 
                case 760600: {
                    Date beginDate = new VDate(this.mEmployeeStartDate).getDate();
                    Date endDate = new VDate(this.mEmployeeEndDate).getDate();
                    if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeEndDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeStartDate)) break;
                    beginDate = DateHelper.after((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeStartDate) ? valuepositionContainer.validfrom : this.mEmployeeStartDate;
                    endDate = DateHelper.before((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeEndDate) ? valuepositionContainer.validuntil : this.mEmployeeEndDate;
                    endDate = DateHelper.getLastDayOfMonth((Date)endDate);
                    beginDate = DateHelper.getFirstDayOfMonth((Date)beginDate);
                    switch (valuepositionContainer.valuetypenumber) {
                        case 220050: {
                            this.FIELD_LSt = this.FIELD_LSt.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 760500: {
                            this.FIELD_KG = this.FIELD_KG.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 760600: {
                            this.FIELD_foerderbetragBAV = this.FIELD_foerderbetragBAV.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            if (this.mFoerderungBAVList.contains(valuepositionContainer.oidemployee)) break;
                            this.mFoerderungBAVList.add(valuepositionContainer.oidemployee);
                            break;
                        }
                        case 710510: {
                            this.FIELD_pausch_ohne37 = this.FIELD_pausch_ohne37.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 223050: 
                        case 710520: {
                            this.FIELD_SolZ = this.FIELD_SolZ.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 110000: {
                            this.steuerPflichtigesBrutto = this.steuerPflichtigesBrutto.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 728300: 
                        case 728800: {
                            this.FIELD_pausch_nach37 = this.FIELD_pausch_nach37.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            this.FIELD_pausch_ohne37 = this.FIELD_pausch_ohne37.subtract(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        }
                    }
                    continue block12;
                }
            }
        }
        if (this.mMitEEP) {
            this.checkEPP(this.mEWT.getOidEmployee());
        }
    }

    private void checkEPP(String oidEmployee) {
        this.mEPPVormonatMonat = this.getEPP(oidEmployee, DateHelper.addMonths((Date)this.mEffectiveDateEPP, (int)-1));
        this.FIELD_energiepreispauschale = this.mEPPAktuellerMonat = this.getEPP(oidEmployee, this.mEffectiveDateEPP);
    }

    public BigDecimal getEPPVormonatMonat() {
        return this.mEPPVormonatMonat;
    }

    public BigDecimal getEPPAktuellerMonat() {
        return this.mEPPAktuellerMonat;
    }

    private BigDecimal getEPP(String oidEmployee, Date effectiveDate) {
        Date validFromDate = new VDate(2022, 7, 1).getDate();
        Date validUntilDate = new VDate(2022, 11, 31).getDate();
        BigDecimal epp = BigDecimal.ZERO;
        while (DateHelper.before((Date)validFromDate, (Date)validUntilDate)) {
            List vpList = ReportEmployeesHandlingHelper.getValuePositionsLi((String)oidEmployee, (String[])new String[]{"102590"}, (Date)effectiveDate, (Date)validFromDate, (Date)DateHelper.getLastDayOfMonth((Date)validFromDate));
            for (ValuepositionContainer vpContainer : vpList) {
                if (vpList == null) continue;
                epp = epp.add(vpContainer.results);
            }
            validFromDate = DateHelper.addMonths((Date)validFromDate, (int)1);
        }
        return epp;
    }

    private static final int getDiffInMonths(Date endDate, Date startDate) {
        return PDateHelper.getDiffInMonths((Date)endDate, (Date)startDate);
    }
}

