/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetax;

import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.reports.library.ReportEmployeesHandlingHelper;
import com.varial.personnel.domain.reports.wagetax.WageTaxEmployeeBean;
import com.varial.personnel.domain.reports.wagetax.WageTaxReportDataSource;
import com.varial.personnel.domain.reports.wagetax.WageTaxSetFederalstateChurchTax2010;
import com.varial.personnel.domain.reports.wagetax.WageTaxSetFederalstateChurchTaxBean;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.serverbase.basictypes.VDate;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class WageTaxValuePositonFactory2010 {
    private WageTaxEmployeeBean mEWT;
    private Date mEmployeeEffectiveDate;
    private Date mEmployeeStartDate;
    private Date mEmployeeEndDate;
    private String FIELD_z_20_text = "";
    private String FIELD_z_24_text = "";
    private String FIELD_z_25_text = "";
    private String FIELD_z_26_text = "";
    private String FIELD_z_27_text = "";
    private String FIELD_z_28_text = "";
    private String FIELD_z_29_text = "";
    private String FIELD_z_30_text = "";
    private String FIELD_z_31_text = "";
    private String FIELD_z_20_short_text = "";
    private String FIELD_z_24_short_text = "";
    private String FIELD_z_25_short_text = "";
    private String FIELD_z_26_short_text = "";
    private String FIELD_z_27_short_text = "";
    private String FIELD_z_28_short_text = "";
    private String FIELD_z_29_short_text = "";
    private String FIELD_z_30_short_text = "";
    private String FIELD_z_31_short_text = "";
    private String FIELD_z_20_nr = "";
    private String FIELD_z_24_nr = "";
    private String FIELD_z_25_nr = "";
    private String FIELD_z_26_nr = "";
    private String FIELD_z_27_nr = "";
    private String FIELD_z_28_nr = "";
    private String FIELD_z_29_nr = "";
    private String FIELD_z_30_nr = "";
    private String FIELD_z_31_nr = "";
    private BigDecimal steuerPflichtigesBrutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_LSt = BigDecimal.valueOf(0L, 2);
    private BigDecimal zeile18_2006 = BigDecimal.valueOf(0L, 2);
    private final BigDecimal FIELD_KG = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_20 = BigDecimal.valueOf(0L, 2);
    private final BigDecimal FIELD_kuerzung_besatzungsmitglieder_handelschiffen = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_verbleib = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_SolZ = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_24 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_25 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_26 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_27 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_28 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_29 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_30 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_31 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_gesamt = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_erst_lst_zwi_su = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_erst_soli_zwi_su = BigDecimal.valueOf(0L, 2);
    private List<ValuepositionContainer> mValuePositionli;

    public void run(WageTaxReportDataSource wageTaxReportDataSource, WageTaxEmployeeBean eWT, String[] valueTypeNumbers) {
        this.mEWT = eWT;
        this.mEmployeeEffectiveDate = eWT.getEmployeeEffectiveDate();
        this.mEmployeeStartDate = eWT.getEmployeeStartDate();
        this.mEmployeeEndDate = eWT.getEmployeeEndDate();
        this.mValuePositionli = ReportEmployeesHandlingHelper.getValuePositionsLi((String)eWT.getOidEmployee(), (String[])valueTypeNumbers, (Date)this.mEmployeeEffectiveDate, (Date)this.mEmployeeStartDate, (Date)this.mEmployeeEndDate);
        this.distinguishWageTaxValues();
        this.setData();
        this.setWageTaxEmployeeBeanValues();
    }

    private void setWageTaxEmployeeBeanValues() {
        this.mEWT.setWageTaxEmployeeBeanValues(this.steuerPflichtigesBrutto, this.FIELD_LSt, this.zeile18_2006, this.FIELD_KG, this.FIELD_z_20, this.FIELD_kuerzung_besatzungsmitglieder_handelschiffen, BigDecimal.valueOf(0L, 2), this.FIELD_verbleib, this.FIELD_SolZ, this.FIELD_z_24, this.FIELD_z_25, this.FIELD_z_26, this.FIELD_z_27, this.FIELD_z_28, this.FIELD_z_29, this.FIELD_z_30, this.FIELD_z_31, this.FIELD_gesamt, BigDecimal.valueOf(0L, 2), BigDecimal.valueOf(0L, 2), this.FIELD_z_20_text, this.FIELD_z_24_text, this.FIELD_z_25_text, this.FIELD_z_26_text, this.FIELD_z_27_text, this.FIELD_z_28_text, this.FIELD_z_29_text, this.FIELD_z_30_text, this.FIELD_z_31_text, this.FIELD_z_20_short_text, this.FIELD_z_24_short_text, this.FIELD_z_25_short_text, this.FIELD_z_26_short_text, this.FIELD_z_27_short_text, this.FIELD_z_28_short_text, this.FIELD_z_29_short_text, this.FIELD_z_30_short_text, this.FIELD_z_31_short_text, this.FIELD_z_20_nr, this.FIELD_z_24_nr, this.FIELD_z_25_nr, this.FIELD_z_26_nr, this.FIELD_z_27_nr, this.FIELD_z_28_nr, this.FIELD_z_29_nr, this.FIELD_z_30_nr, this.FIELD_z_31_nr);
    }

    private void distinguishWageTaxValues() {
        if (this.mEWT.getLicense().equals("AK") && this.mEWT.getCalculateEmployeeKammerBeitrag()) {
            this.getValuesKammerBeitrag();
        } else {
            this.getWageTaxValuePostionEmployeeBean();
        }
    }

    private void setData() {
        this.FIELD_verbleib = this.FIELD_verbleib.add(this.FIELD_LSt).add(this.zeile18_2006).add(this.FIELD_z_20);
        this.FIELD_gesamt = BigDecimal.valueOf(0L, 2);
        this.FIELD_gesamt = this.FIELD_gesamt.add(this.FIELD_LSt).add(this.zeile18_2006).add(this.FIELD_SolZ).add(this.FIELD_z_20).add(this.FIELD_z_24).add(this.FIELD_z_25).add(this.FIELD_z_26).add(this.FIELD_z_27).add(this.FIELD_z_28).add(this.FIELD_z_29).add(this.FIELD_z_30).add(this.FIELD_z_31).setScale(2, RoundingMode.UP);
    }

    private void setChurchTaxFields(WageTaxSetFederalstateChurchTax2010 wTSetFSChurchTax2010) {
        this.FIELD_z_20_text = "";
        this.FIELD_z_20_short_text = "Kindergeld";
        this.FIELD_z_20_nr = "43";
        this.FIELD_z_24_text = wTSetFSChurchTax2010.getFIELD_z_24_text();
        this.FIELD_z_24_short_text = wTSetFSChurchTax2010.getFIELD_z_24_short_text();
        this.FIELD_z_24_nr = wTSetFSChurchTax2010.getFIELD_z_24_nr();
        this.FIELD_z_25_text = wTSetFSChurchTax2010.getFIELD_z_25_text();
        this.FIELD_z_25_short_text = wTSetFSChurchTax2010.getFIELD_z_25_short_text();
        this.FIELD_z_25_nr = wTSetFSChurchTax2010.getFIELD_z_25_nr();
        this.FIELD_z_26_text = wTSetFSChurchTax2010.getFIELD_z_26_text();
        this.FIELD_z_26_short_text = wTSetFSChurchTax2010.getFIELD_z_26_short_text();
        this.FIELD_z_26_nr = wTSetFSChurchTax2010.getFIELD_z_26_nr();
        this.FIELD_z_27_text = wTSetFSChurchTax2010.getFIELD_z_27_text();
        this.FIELD_z_27_short_text = wTSetFSChurchTax2010.getFIELD_z_27_short_text();
        this.FIELD_z_27_nr = wTSetFSChurchTax2010.getFIELD_z_27_nr();
        this.FIELD_z_28_text = wTSetFSChurchTax2010.getFIELD_z_28_text();
        this.FIELD_z_28_short_text = wTSetFSChurchTax2010.getFIELD_z_28_short_text();
        this.FIELD_z_28_nr = wTSetFSChurchTax2010.getFIELD_z_28_nr();
        this.FIELD_z_29_text = wTSetFSChurchTax2010.getFIELD_z_29_text();
        this.FIELD_z_29_short_text = wTSetFSChurchTax2010.getFIELD_z_29_short_text();
        this.FIELD_z_29_nr = wTSetFSChurchTax2010.getFIELD_z_29_nr();
        this.FIELD_z_30_text = wTSetFSChurchTax2010.getFIELD_z_30_text();
        this.FIELD_z_30_short_text = wTSetFSChurchTax2010.getFIELD_z_30_short_text();
        this.FIELD_z_30_nr = wTSetFSChurchTax2010.getFIELD_z_30_nr();
        this.FIELD_z_31_text = wTSetFSChurchTax2010.getFIELD_z_31_text();
        this.FIELD_z_31_short_text = wTSetFSChurchTax2010.getFIELD_z_31_short_text();
        this.FIELD_z_31_nr = wTSetFSChurchTax2010.getFIELD_z_31_nr();
        this.FIELD_z_24 = this.FIELD_z_24.add(wTSetFSChurchTax2010.getFIELD_z_24());
        this.FIELD_z_25 = this.FIELD_z_25.add(wTSetFSChurchTax2010.getFIELD_z_25());
        this.FIELD_z_26 = this.FIELD_z_26.add(wTSetFSChurchTax2010.getFIELD_z_26());
        this.FIELD_z_27 = this.FIELD_z_27.add(wTSetFSChurchTax2010.getFIELD_z_27());
        this.FIELD_z_28 = this.FIELD_z_28.add(wTSetFSChurchTax2010.getFIELD_z_28());
        this.FIELD_z_29 = this.FIELD_z_29.add(wTSetFSChurchTax2010.getFIELD_z_29());
        this.FIELD_z_30 = this.FIELD_z_30.add(wTSetFSChurchTax2010.getFIELD_z_30());
        this.FIELD_z_31 = this.FIELD_z_31.add(wTSetFSChurchTax2010.getFIELD_z_31());
    }

    private void setChruchTaxLSTJAFields(WageTaxSetFederalstateChurchTax2010 wTSetFSChurchTax2010) {
        WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = wTSetFSChurchTax2010.getMWTSFChurchTaxBean();
        if (wTSFChurchTaxBean != null) {
            this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
            this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
            this.FIELD_z_26 = this.FIELD_z_26.add(wTSFChurchTaxBean.getZ_26());
            this.FIELD_z_27 = this.FIELD_z_27.add(wTSFChurchTaxBean.getZ_27());
            this.FIELD_z_28 = this.FIELD_z_28.add(wTSFChurchTaxBean.getZ_28());
            this.FIELD_z_29 = this.FIELD_z_29.add(wTSFChurchTaxBean.getZ_29());
            this.FIELD_z_30 = this.FIELD_z_30.add(wTSFChurchTaxBean.getZ_30());
            this.FIELD_z_31 = this.FIELD_z_31.add(wTSFChurchTaxBean.getZ_31());
        }
    }

    private void getTaxLSTJA() {
        this.FIELD_LSt = this.FIELD_LSt.add(this.FIELD_erst_lst_zwi_su);
        this.FIELD_SolZ = this.FIELD_SolZ.add(this.FIELD_erst_soli_zwi_su);
    }

    private void getValuesKammerBeitrag() {
        WageTaxSetFederalstateChurchTax2010 wageTaxSetFederalstateChurchTax2010 = new WageTaxSetFederalstateChurchTax2010(this.mEWT, this.mValuePositionli);
        wageTaxSetFederalstateChurchTax2010.runForChrchTaxKammerBeitrag();
        this.setChurchTaxFields(wageTaxSetFederalstateChurchTax2010);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getLSTJAValues() {
        Iterator<ValuepositionContainer> valuePositionit = this.mValuePositionli.iterator();
        block11: while (valuePositionit.hasNext()) {
            ValuepositionContainer valuepositionContainer = valuePositionit.next();
            switch (valuepositionContainer.valuetypenumber) {
                case 760100: 
                case 760110: 
                case 760400: 
                case 760410: 
                case 760450: 
                case 760460: {
                    Date beginDate = new VDate(this.mEmployeeStartDate).getDate();
                    Date endDate = new VDate(this.mEmployeeEndDate).getDate();
                    if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeEndDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeStartDate)) continue block11;
                    beginDate = DateHelper.after((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeStartDate) ? valuepositionContainer.validfrom : this.mEmployeeStartDate;
                    endDate = DateHelper.before((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeEndDate) ? valuepositionContainer.validuntil : this.mEmployeeEndDate;
                    endDate = DateHelper.getLastDayOfMonth((Date)endDate);
                    switch (valuepositionContainer.valuetypenumber) {
                        case 760400: {
                            if (!DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                            this.FIELD_erst_lst_zwi_su = this.FIELD_erst_lst_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 760450: {
                            if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                            this.FIELD_erst_lst_zwi_su = this.FIELD_erst_lst_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 760100: {
                            if (new VDate(beginDate).getMonth() != 11) break;
                            this.FIELD_erst_lst_zwi_su = this.FIELD_erst_lst_zwi_su.subtract(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 760410: {
                            if (!DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                            this.FIELD_erst_soli_zwi_su = this.FIELD_erst_soli_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 760460: {
                            if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                            this.FIELD_erst_soli_zwi_su = this.FIELD_erst_soli_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break;
                        }
                        case 760110: {
                            if (new VDate(beginDate).getMonth() != 11) break;
                            this.FIELD_erst_soli_zwi_su = this.FIELD_erst_soli_zwi_su.subtract(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        }
                    }
                    continue block11;
                }
            }
        }
        return;
    }

    private void getWageTaxValuePostionEmployeeBean() {
        WageTaxSetFederalstateChurchTax2010 wageTaxSetFederalstateChurchTax2010 = new WageTaxSetFederalstateChurchTax2010(this.mEWT, this.mValuePositionli);
        wageTaxSetFederalstateChurchTax2010.runForChrchTax();
        if (new VDate(this.mEmployeeStartDate).getMonth() == 11) {
            this.getLSTJAValues();
            this.getTaxLSTJA();
            this.setChruchTaxLSTJAFields(wageTaxSetFederalstateChurchTax2010);
        }
        this.getTax();
        this.setChurchTaxFields(wageTaxSetFederalstateChurchTax2010);
    }

    private void getTax() {
        for (ValuepositionContainer valuepositionContainer : this.mValuePositionli) {
            block0 : switch (valuepositionContainer.valuetypenumber) {
                case 110000: 
                case 220050: 
                case 223050: 
                case 710510: 
                case 710520: 
                case 728300: 
                case 728800: {
                    Date beginDate = new VDate(this.mEmployeeStartDate).getDate();
                    Date endDate = new VDate(this.mEmployeeEndDate).getDate();
                    if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeEndDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeStartDate)) break;
                    beginDate = DateHelper.after((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeStartDate) ? valuepositionContainer.validfrom : this.mEmployeeStartDate;
                    endDate = DateHelper.before((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeEndDate) ? valuepositionContainer.validuntil : this.mEmployeeEndDate;
                    endDate = DateHelper.getLastDayOfMonth((Date)endDate);
                    beginDate = DateHelper.getFirstDayOfMonth((Date)beginDate);
                    switch (valuepositionContainer.valuetypenumber) {
                        case 220050: {
                            this.FIELD_LSt = this.FIELD_LSt.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break block0;
                        }
                        case 710510: {
                            this.zeile18_2006 = this.zeile18_2006.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break block0;
                        }
                        case 223050: 
                        case 710520: {
                            this.FIELD_SolZ = this.FIELD_SolZ.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break block0;
                        }
                        case 110000: {
                            this.steuerPflichtigesBrutto = this.steuerPflichtigesBrutto.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break block0;
                        }
                        case 728300: 
                        case 728800: {
                            this.FIELD_z_20 = this.FIELD_z_20.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            this.zeile18_2006 = this.zeile18_2006.subtract(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory2010.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        }
                    }
                }
            }
        }
    }

    private static final int getDiffInMonths(Date endDate, Date startDate) {
        return PDateHelper.getDiffInMonths((Date)endDate, (Date)startDate);
    }
}

