/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetax;

import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.reports.library.ReportEmployeesHandlingHelper;
import com.varial.personnel.domain.reports.wagetax.WageTaxEmployeeBean;
import com.varial.personnel.domain.reports.wagetax.WageTaxReportDataSource;
import com.varial.personnel.domain.reports.wagetax.WageTaxSetFederalstateChurchTax;
import com.varial.personnel.domain.reports.wagetax.WageTaxSetFederalstateChurchTaxBean;
import com.varial.personnel.domain.reports.wagetaxperemployee.WageTaxPerEmployeeBean;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.persistency.employee.tax.ITaxDao;
import com.varial.personnel.persistency.employee.tax.TaxContainer;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;

public class WageTaxValuePositonFactory {
    private static ITaxDao daoTax = (ITaxDao)UtilitiesManager.getApplicationContext().getBean("taxDao");
    private WageTaxEmployeeBean mEWT;
    private WageTaxReportDataSource mWageTaxReportDataSource;
    private Date mEmployeeEffectiveDate;
    private Date mEmployeeStartDate;
    private Date mEmployeeEndDate;
    private int mFederalState;
    private List<ValuepositionContainer> mValuePositionli;
    private String mFirstFilterKammerBeitragOidPlant = "";
    private String FIELD_z_20_text = "";
    private String FIELD_z_24_text = "";
    private String FIELD_z_25_text = "";
    private String FIELD_z_26_text = "";
    private String FIELD_z_27_text = "";
    private String FIELD_z_28_text = "";
    private String FIELD_z_29_text = "";
    private String FIELD_z_30_text = "";
    private String FIELD_z_31_text = "";
    private String FIELD_z_20_short_text = "";
    private String FIELD_z_24_short_text = "";
    private String FIELD_z_25_short_text = "";
    private String FIELD_z_26_short_text = "";
    private String FIELD_z_27_short_text = "";
    private String FIELD_z_28_short_text = "";
    private String FIELD_z_29_short_text = "";
    private String FIELD_z_30_short_text = "";
    private String FIELD_z_31_short_text = "";
    private String FIELD_z_20_nr = "";
    private String FIELD_z_24_nr = "";
    private String FIELD_z_25_nr = "";
    private String FIELD_z_26_nr = "";
    private String FIELD_z_27_nr = "";
    private String FIELD_z_28_nr = "";
    private String FIELD_z_29_nr = "";
    private String FIELD_z_30_nr = "";
    private String FIELD_z_31_nr = "";
    private BigDecimal steuerPflichtigesBrutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_LSt = BigDecimal.valueOf(0L, 2);
    private final BigDecimal zeile18_2006 = BigDecimal.valueOf(0L, 2);
    private final BigDecimal FIELD_KG = BigDecimal.valueOf(0L, 2);
    private final BigDecimal FIELD_z_20 = BigDecimal.valueOf(0L, 2);
    private final BigDecimal FIELD_kuerzung_besatzungsmitglieder_handelschiffen = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_verbleib = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_SolZ = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_24 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_25 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_26 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_27 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_28 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_29 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_z_30 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_gesamt = BigDecimal.valueOf(0L, 2);
    private BigDecimal kiStPauschVereinfachtEV2006 = BigDecimal.valueOf(0L, 2);
    private BigDecimal kiStPauschVereinfachtRK2006 = BigDecimal.valueOf(0L, 2);
    private int employeeLSTJA_aschluss = 0;
    private BigDecimal FIELD_erst_lst_zwi_su = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_erst_soli_zwi_su = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_erst_kist_zwi_su = BigDecimal.valueOf(0L, 2);
    private BigDecimal mSplitlumpsumct = BigDecimal.valueOf(0L, 2);

    public void run(WageTaxReportDataSource wageTaxReportDataSource, WageTaxEmployeeBean eWT, String[] valueTypeNumbers, String firstFilterKammerBeitragOidPlant) {
        this.mEWT = eWT;
        this.mWageTaxReportDataSource = wageTaxReportDataSource;
        this.mEmployeeEffectiveDate = eWT.getEmployeeEffectiveDate();
        this.mEmployeeStartDate = eWT.getEmployeeStartDate();
        this.mEmployeeEndDate = eWT.getEmployeeEndDate();
        this.mFederalState = eWT.getEmployerFstateregionKey();
        this.mSplitlumpsumct = eWT.getEmployerSplitlumpsumct();
        this.mFirstFilterKammerBeitragOidPlant = firstFilterKammerBeitragOidPlant;
        this.mValuePositionli = ReportEmployeesHandlingHelper.getValuePositionsLi((String)eWT.getOidEmployee(), (String[])valueTypeNumbers, (Date)this.mEmployeeEffectiveDate, (Date)this.mEmployeeStartDate, (Date)this.mEmployeeEndDate);
        this.distinguishWageTaxValues();
        this.setData();
        this.setWageTaxEmployeeBeanValues();
    }

    private void setWageTaxEmployeeBeanValues() {
        this.mEWT.setWageTaxEmployeeBeanValues(this.steuerPflichtigesBrutto, this.FIELD_LSt, this.zeile18_2006, this.FIELD_KG, this.FIELD_z_20, this.FIELD_kuerzung_besatzungsmitglieder_handelschiffen, BigDecimal.valueOf(0L, 2), this.FIELD_verbleib, this.FIELD_SolZ, this.FIELD_z_24, this.FIELD_z_25, this.FIELD_z_26, this.FIELD_z_27, this.FIELD_z_28, this.FIELD_z_29, this.FIELD_z_30, BigDecimal.valueOf(0L, 2), this.FIELD_gesamt, this.kiStPauschVereinfachtEV2006, this.kiStPauschVereinfachtRK2006, this.FIELD_z_20_text, this.FIELD_z_24_text, this.FIELD_z_25_text, this.FIELD_z_26_text, this.FIELD_z_27_text, this.FIELD_z_28_text, this.FIELD_z_29_text, this.FIELD_z_30_text, this.FIELD_z_31_text, this.FIELD_z_20_short_text, this.FIELD_z_24_short_text, this.FIELD_z_25_short_text, this.FIELD_z_26_short_text, this.FIELD_z_27_short_text, this.FIELD_z_28_short_text, this.FIELD_z_29_short_text, this.FIELD_z_30_short_text, this.FIELD_z_31_short_text, this.FIELD_z_20_nr, this.FIELD_z_24_nr, this.FIELD_z_25_nr, this.FIELD_z_26_nr, this.FIELD_z_27_nr, this.FIELD_z_28_nr, this.FIELD_z_29_nr, this.FIELD_z_30_nr, this.FIELD_z_31_nr);
    }

    private void distinguishWageTaxValues() {
        if (this.mEWT.getLicense().equals("AK") && this.mEWT.getCalculateEmployeeKammerBeitrag() && !StringMapper.isNullString((String)this.mFirstFilterKammerBeitragOidPlant)) {
            this.getValuesKammerBeitragHM();
        } else {
            this.getWageTaxValuePostionEmployeeBean();
        }
    }

    private void setData() {
        this.FIELD_verbleib = this.FIELD_verbleib.add(this.FIELD_LSt).add(this.zeile18_2006);
        this.FIELD_gesamt = BigDecimal.valueOf(0L, 2);
        this.FIELD_gesamt = this.FIELD_gesamt.add(this.FIELD_LSt).add(this.zeile18_2006).add(this.FIELD_SolZ).add(this.FIELD_z_20).add(this.FIELD_z_24).add(this.FIELD_z_25).add(this.FIELD_z_26).add(this.FIELD_z_27).add(this.FIELD_z_28).add(this.FIELD_z_29).add(this.FIELD_z_30).setScale(2, RoundingMode.UP);
    }

    private PersistencyDataSet getTaxDataSet() {
        PersistencyDataSet taxDatas;
        Conjunction filterStructs = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEWT.getOidEmployee()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfYear((Date)this.mEmployeeStartDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)DateHelper.getLastDayOfYear((Date)this.mEmployeeStartDate)))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfYear((Date)this.mEmployeeStartDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)this.mEmployeeStartDate)))});
        Order[] sortierungStruct = new Order[]{Order.asc((String)"validfrom")};
        try {
            taxDatas = daoTax.getDataSet(sortierungStruct, (Criterion)filterStructs);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return taxDatas;
    }

    private int getReligionszugehoerigkeitAN() {
        PersistencyDataSet taxDatas = this.getTaxDataSet();
        if (taxDatas != null) {
            while (taxDatas.hasNext()) {
                TaxContainer taxContainer = (TaxContainer)taxDatas.getNext();
                if (taxContainer.churchtaxee == 0) continue;
                return taxContainer.churchtaxee;
            }
        }
        return 0;
    }

    private int getReligionszugehoerigkeitEG() {
        PersistencyDataSet taxDatas = this.getTaxDataSet();
        if (taxDatas != null) {
            while (taxDatas.hasNext()) {
                TaxContainer taxContainer = (TaxContainer)taxDatas.getNext();
                if (taxContainer.churchtaxspouse == 0) continue;
                return taxContainer.churchtaxspouse;
            }
        }
        return 0;
    }

    private void getChruchTaxLSTJA() {
        int churchtaxee = this.mEWT.getEmployeeChurchtaxee();
        int churchtaxspouse = this.mEWT.getEmployeeChurchtaxspouse();
        this.FIELD_LSt = this.FIELD_LSt.add(this.FIELD_erst_lst_zwi_su);
        this.FIELD_SolZ = this.FIELD_SolZ.add(this.FIELD_erst_soli_zwi_su);
        if (!BigDecimalMapper.isZero((BigDecimal)this.FIELD_erst_kist_zwi_su)) {
            if (churchtaxee == 0) {
                churchtaxee = this.getReligionszugehoerigkeitAN();
            }
            if (churchtaxspouse == 0) {
                churchtaxspouse = this.getReligionszugehoerigkeitEG();
            }
            switch (this.mFederalState) {
                case 1: {
                    if (DateHelper.before((Date)this.mEWT.getEmployeeStartDate(), (Date)new VDate(2008, 0, 1).getDate())) {
                        WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxGlobal((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                        this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                        this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                        break;
                    }
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxSH((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    this.FIELD_z_26 = this.FIELD_z_26.add(wTSFChurchTaxBean.getZ_26());
                    break;
                }
                case 2: {
                    if (DateHelper.before((Date)this.mEWT.getEmployeeStartDate(), (Date)new VDate(2006, 0, 1).getDate())) {
                        WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxGlobal((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                        this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                        this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                        break;
                    }
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxHH((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    this.FIELD_z_26 = this.FIELD_z_26.add(wTSFChurchTaxBean.getZ_26());
                    break;
                }
                case 3: {
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxNI((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    this.FIELD_z_26 = this.FIELD_z_26.add(wTSFChurchTaxBean.getZ_26());
                    this.FIELD_z_27 = this.FIELD_z_27.add(wTSFChurchTaxBean.getZ_27());
                    break;
                }
                case 4: {
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxHB((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    break;
                }
                case 5: {
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxNRW((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    this.FIELD_z_26 = this.FIELD_z_26.add(wTSFChurchTaxBean.getZ_26());
                    this.FIELD_z_27 = this.FIELD_z_27.add(wTSFChurchTaxBean.getZ_27());
                    break;
                }
                case 6: {
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxHE((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    this.FIELD_z_26 = this.FIELD_z_26.add(wTSFChurchTaxBean.getZ_26());
                    this.FIELD_z_27 = this.FIELD_z_27.add(wTSFChurchTaxBean.getZ_27());
                    this.FIELD_z_28 = this.FIELD_z_28.add(wTSFChurchTaxBean.getZ_28());
                    this.FIELD_z_29 = this.FIELD_z_29.add(wTSFChurchTaxBean.getZ_29());
                    this.FIELD_z_30 = this.FIELD_z_30.add(wTSFChurchTaxBean.getZ_30());
                    break;
                }
                case 7: {
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxRP((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    this.FIELD_z_26 = this.FIELD_z_26.add(wTSFChurchTaxBean.getZ_26());
                    this.FIELD_z_27 = this.FIELD_z_27.add(wTSFChurchTaxBean.getZ_27());
                    this.FIELD_z_28 = this.FIELD_z_28.add(wTSFChurchTaxBean.getZ_28());
                    this.FIELD_z_29 = this.FIELD_z_29.add(wTSFChurchTaxBean.getZ_29());
                    this.FIELD_z_30 = this.FIELD_z_30.add(wTSFChurchTaxBean.getZ_30());
                    break;
                }
                case 8: {
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxBW((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    this.FIELD_z_26 = this.FIELD_z_26.add(wTSFChurchTaxBean.getZ_26());
                    this.FIELD_z_27 = this.FIELD_z_27.add(wTSFChurchTaxBean.getZ_27());
                    this.FIELD_z_28 = this.FIELD_z_28.add(wTSFChurchTaxBean.getZ_28());
                    this.FIELD_z_29 = this.FIELD_z_29.add(wTSFChurchTaxBean.getZ_29());
                    break;
                }
                case 9: {
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxBY((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    this.FIELD_z_27 = this.FIELD_z_27.add(wTSFChurchTaxBean.getZ_27());
                    break;
                }
                case 10: {
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxSL((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    this.FIELD_z_26 = this.FIELD_z_26.add(wTSFChurchTaxBean.getZ_26());
                    this.FIELD_z_27 = this.FIELD_z_27.add(wTSFChurchTaxBean.getZ_27());
                    break;
                }
                case 11: 
                case 12: {
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxBE((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    this.FIELD_z_26 = this.FIELD_z_26.add(wTSFChurchTaxBean.getZ_26());
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxGlobal((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                    break;
                }
                case 17: {
                    if (DateHelper.before((Date)this.mEmployeeStartDate, (Date)new VDate(2005, 0, 1).getDate())) {
                        WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxTH((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                        this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                        this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                        break;
                    }
                    WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = WageTaxSetFederalstateChurchTax.getLSTJAChurchTaxGlobal((BigDecimal)this.FIELD_erst_kist_zwi_su, (int)churchtaxee, (int)churchtaxspouse);
                    this.FIELD_z_24 = this.FIELD_z_24.add(wTSFChurchTaxBean.getZ_24());
                    this.FIELD_z_25 = this.FIELD_z_25.add(wTSFChurchTaxBean.getZ_25());
                }
            }
        }
    }

    private void getDataChurchTaxHB(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesHB(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        switch (valuepositionContainer.valuetypenumber) {
            case 226050: {
                this.getDataChurchTaxHB(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                break;
            }
            case 227050: {
                this.getDataChurchTaxHB(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                break;
            }
            case 250510: {
                this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                break;
            }
            case 710610: {
                BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                break;
            }
            case 710620: {
                if (eWT.getEmployeeChurchtaxspouse() == 0) {
                    this.getDataChurchTaxHB(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                this.getDataChurchTaxHB(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                this.getDataChurchTaxHB(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
            }
        }
    }

    private void getDataChurchTaxNI(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesNI(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        switch (valuepositionContainer.valuetypenumber) {
            case 226050: {
                this.getDataChurchTaxNI(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                break;
            }
            case 227050: {
                this.getDataChurchTaxNI(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                break;
            }
            case 710610: {
                BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                BigDecimal forField_z_26 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                BigDecimal forField_z_27 = field_value.subtract(forField_z_26);
                this.FIELD_z_26 = this.FIELD_z_26.add(forField_z_26);
                this.FIELD_z_27 = this.FIELD_z_27.add(forField_z_27);
                this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_26);
                this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_27);
                break;
            }
            case 710620: {
                if (eWT.getEmployeeChurchtaxspouse() == 0) {
                    this.getDataChurchTaxNI(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                this.getDataChurchTaxNI(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                this.getDataChurchTaxNI(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
            }
        }
    }

    private void getDataChurchTaxNRW(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 16: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 16: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 16: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesNRW(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        switch (valuepositionContainer.valuetypenumber) {
            case 226050: {
                this.getDataChurchTaxNRW(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                break;
            }
            case 227050: {
                this.getDataChurchTaxNRW(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                break;
            }
            case 710610: {
                BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                break;
            }
            case 710620: {
                if (eWT.getEmployeeChurchtaxspouse() == 0) {
                    this.getDataChurchTaxNRW(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                this.getDataChurchTaxNRW(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                this.getDataChurchTaxNRW(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
            }
        }
    }

    private void getDataChurchTaxHE(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_30 = this.FIELD_z_30.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 10: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 11: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 13: {
                        this.FIELD_z_29 = this.FIELD_z_29.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 14: {
                        this.FIELD_z_28 = this.FIELD_z_28.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_30 = this.FIELD_z_30.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 10: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 11: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 13: {
                        this.FIELD_z_29 = this.FIELD_z_29.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 14: {
                        this.FIELD_z_28 = this.FIELD_z_28.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_30 = this.FIELD_z_30.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 10: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 11: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 13: {
                        this.FIELD_z_29 = this.FIELD_z_29.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 14: {
                        this.FIELD_z_28 = this.FIELD_z_28.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesHE(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        switch (valuepositionContainer.valuetypenumber) {
            case 226050: {
                this.getDataChurchTaxHE(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                break;
            }
            case 227050: {
                this.getDataChurchTaxHE(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                break;
            }
            case 710610: {
                BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                break;
            }
            case 710620: {
                if (eWT.getEmployeeChurchtaxspouse() == 0) {
                    this.getDataChurchTaxHE(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                this.getDataChurchTaxHE(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                this.getDataChurchTaxHE(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
            }
        }
    }

    private void getDataChurchTaxRP(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_30 = this.FIELD_z_30.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 7: {
                        this.FIELD_z_29 = this.FIELD_z_29.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 9: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 10: {
                        this.FIELD_z_28 = this.FIELD_z_28.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 14: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_30 = this.FIELD_z_30.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 7: {
                        this.FIELD_z_29 = this.FIELD_z_29.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 9: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 10: {
                        this.FIELD_z_28 = this.FIELD_z_28.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 14: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_30 = this.FIELD_z_30.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 7: {
                        this.FIELD_z_29 = this.FIELD_z_29.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 9: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 10: {
                        this.FIELD_z_28 = this.FIELD_z_28.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 14: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesRP(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        switch (valuepositionContainer.valuetypenumber) {
            case 226050: {
                this.getDataChurchTaxRP(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                break;
            }
            case 227050: {
                this.getDataChurchTaxRP(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                break;
            }
            case 710610: {
                BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                break;
            }
            case 710620: {
                if (eWT.getEmployeeChurchtaxspouse() == 0) {
                    this.getDataChurchTaxRP(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                this.getDataChurchTaxRP(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                this.getDataChurchTaxRP(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
            }
        }
    }

    private void getDataChurchTaxBW(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_29 = this.FIELD_z_29.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 8: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 12: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 15: {
                        this.FIELD_z_28 = this.FIELD_z_28.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_29 = this.FIELD_z_29.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 8: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 12: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 15: {
                        this.FIELD_z_28 = this.FIELD_z_28.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_29 = this.FIELD_z_29.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 8: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 12: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 15: {
                        this.FIELD_z_28 = this.FIELD_z_28.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesBW(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        switch (valuepositionContainer.valuetypenumber) {
            case 226050: {
                this.getDataChurchTaxBW(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                break;
            }
            case 227050: {
                this.getDataChurchTaxBW(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                break;
            }
            case 710610: {
                BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                break;
            }
            case 710620: {
                if (eWT.getEmployeeChurchtaxspouse() == 0) {
                    this.getDataChurchTaxBW(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                this.getDataChurchTaxBW(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                this.getDataChurchTaxBW(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
            }
        }
    }

    private void getDataChurchTaxBY(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 17: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 17: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 17: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesBY(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        switch (valuepositionContainer.valuetypenumber) {
            case 226050: {
                this.getDataChurchTaxBY(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                break;
            }
            case 227050: {
                this.getDataChurchTaxBY(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                break;
            }
            case 710610: {
                BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                break;
            }
            case 710620: {
                if (eWT.getEmployeeChurchtaxspouse() == 0) {
                    this.getDataChurchTaxBY(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                this.getDataChurchTaxBY(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                this.getDataChurchTaxBY(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
            }
        }
    }

    private void getDataChurchTaxSL(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 13: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 13: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_27 = this.FIELD_z_27.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 13: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesSL(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        switch (valuepositionContainer.valuetypenumber) {
            case 226050: {
                this.getDataChurchTaxSL(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                break;
            }
            case 227050: {
                this.getDataChurchTaxSL(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                break;
            }
            case 250610: {
                this.FIELD_z_28 = this.FIELD_z_28.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                break;
            }
            case 710610: {
                BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                break;
            }
            case 710620: {
                if (eWT.getEmployeeChurchtaxee() == 0) {
                    this.getDataChurchTaxSL(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                this.getDataChurchTaxSL(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                this.getDataChurchTaxSL(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
            }
        }
    }

    private void getDataChurchTaxBE(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 3: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesBE(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        switch (valuepositionContainer.valuetypenumber) {
            case 226050: {
                this.getDataChurchTaxBE(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                break;
            }
            case 227050: {
                this.getDataChurchTaxBE(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                break;
            }
            case 710610: {
                BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                break;
            }
            case 710620: {
                if (eWT.getEmployeeChurchtaxspouse() == 0) {
                    this.getDataChurchTaxBE(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                this.getDataChurchTaxBE(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                this.getDataChurchTaxBE(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
            }
        }
    }

    private void getDataChurchTaxGlobal(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 4: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 5: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 4: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 5: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 4: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 5: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                }
            }
        }
    }

    private void getDataChurchTaxTH(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 0: {
                        break block0;
                    }
                    case 1: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesTH(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        if (DateHelper.before((Date)endDate, (Date)new VDate(2005, 0, 1).getDate())) {
            this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
            this.FIELD_z_20_short_text = "BergPr";
            this.FIELD_z_20_nr = "46";
            this.FIELD_z_24_text = "Evangelische Kirchensteuer - ev";
            this.FIELD_z_24_short_text = "ev";
            this.FIELD_z_24_nr = "61";
            this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
            this.FIELD_z_25_short_text = "rk";
            this.FIELD_z_25_nr = "62";
            switch (valuepositionContainer.valuetypenumber) {
                case 226050: {
                    this.getDataChurchTaxTH(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                    break;
                }
                case 227050: {
                    this.getDataChurchTaxTH(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                    break;
                }
                case 710610: {
                    BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                    BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                    BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                    this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                    this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                    this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                    this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                    break;
                }
                case 710620: {
                    if (eWT.getEmployeeChurchtaxee() == 0) {
                        this.getDataChurchTaxTH(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                    }
                    if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                    this.getDataChurchTaxTH(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                    this.getDataChurchTaxTH(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
                }
            }
        } else {
            switch (valuepositionContainer.valuetypenumber) {
                case 226050: {
                    this.getDataChurchTaxGlobal(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                    break;
                }
                case 227050: {
                    this.getDataChurchTaxGlobal(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                    break;
                }
                case 710610: {
                    BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                    BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                    BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                    this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                    this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                    this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                    this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                    break;
                }
                case 710620: {
                    if (eWT.getEmployeeChurchtaxspouse() == 0) {
                        this.getDataChurchTaxGlobal(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                    }
                    if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                    this.getDataChurchTaxGlobal(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                    this.getDataChurchTaxGlobal(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesDefault(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        switch (valuepositionContainer.valuetypenumber) {
            case 226050: {
                this.getDataChurchTaxGlobal(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                break;
            }
            case 227050: {
                this.getDataChurchTaxGlobal(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                break;
            }
            case 710610: {
                BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                break;
            }
            case 710620: {
                if (eWT.getEmployeeChurchtaxspouse() == 0) {
                    this.getDataChurchTaxGlobal(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                this.getDataChurchTaxGlobal(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                this.getDataChurchTaxGlobal(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
            }
        }
    }

    private void getDataChurchTaxHH(ValuepositionContainer valuepositionContainer, int churchtax, Date beginDate, Date endDate, int typeOfAddition) {
        block0 : switch (typeOfAddition) {
            case 0: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                    case 16: 
                    case 18: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                    case 16: 
                    case 18: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP));
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        this.FIELD_z_24 = this.FIELD_z_24.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 2: {
                        this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                    case 16: 
                    case 18: {
                        this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))).divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                        break block0;
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesHH(WageTaxPerEmployeeBean eWT, ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        switch (valuepositionContainer.valuetypenumber) {
            case 226050: {
                this.getDataChurchTaxHH(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                break;
            }
            case 227050: {
                this.getDataChurchTaxHH(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 0);
                break;
            }
            case 710610: {
                BigDecimal field_value = valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                BigDecimal splitlumpsumct = this.mSplitlumpsumct.movePointLeft(2);
                BigDecimal forField_z_25 = field_value.multiply(splitlumpsumct).setScale(2, RoundingMode.HALF_UP);
                BigDecimal forField_z_24 = field_value.subtract(forField_z_25);
                this.FIELD_z_25 = this.FIELD_z_25.add(forField_z_25);
                this.FIELD_z_24 = this.FIELD_z_24.add(forField_z_24);
                this.kiStPauschVereinfachtEV2006 = this.kiStPauschVereinfachtEV2006.add(forField_z_24);
                this.kiStPauschVereinfachtRK2006 = this.kiStPauschVereinfachtRK2006.add(forField_z_25);
                break;
            }
            case 710620: {
                if (eWT.getEmployeeChurchtaxspouse() == 0) {
                    this.getDataChurchTaxHH(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 0);
                }
                if (eWT.getEmployeeChurchtaxspouse() == 0) break;
                this.getDataChurchTaxHH(valuepositionContainer, eWT.getEmployeeChurchtaxee(), beginDate, endDate, 1);
                this.getDataChurchTaxHH(valuepositionContainer, eWT.getEmployeeChurchtaxspouse(), beginDate, endDate, 2);
            }
        }
    }

    private void getFederalStateWageTaxValuesArbeitsKammerSL(ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "Evangelische Kirchensteuer";
        this.FIELD_z_24_short_text = "ev";
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "Israelitische Kultussteuer";
        this.FIELD_z_26_short_text = "is";
        this.FIELD_z_26_nr = "64";
        this.FIELD_z_27_text = "Altkatholische Kirchensteuer";
        this.FIELD_z_27_short_text = "ak";
        this.FIELD_z_27_nr = "63";
        this.FIELD_z_28_text = "Beitr\u00e4ge zur Arbeitskammer";
        this.FIELD_z_28_short_text = "Arb.-kammer";
        this.FIELD_z_28_nr = "70";
        switch (valuepositionContainer.valuetypenumber) {
            case 250610: {
                this.FIELD_z_28 = this.FIELD_z_28.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
            }
        }
    }

    private void getFederalStateWageTaxValuesArbeitsKammerHB(ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "Evangelische Kirchensteuer - ev";
        this.FIELD_z_24_short_text = "ev";
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "Beitr\u00e4ge zur Arbeitnehmerkammer";
        this.FIELD_z_26_short_text = "AK";
        this.FIELD_z_26_nr = "68";
        switch (valuepositionContainer.valuetypenumber) {
            case 250510: {
                this.FIELD_z_26 = this.FIELD_z_26.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
            }
        }
    }

    private void getValuesKammerBeitragHM() {
        for (ValuepositionContainer valuepositionContainer : this.mValuePositionli) {
            block0 : switch (valuepositionContainer.valuetypenumber) {
                case 250510: 
                case 250610: {
                    Date beginDate = new VDate(this.mEmployeeStartDate).getDate();
                    Date endDate = new VDate(this.mEmployeeEndDate).getDate();
                    if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeEndDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeStartDate)) break;
                    beginDate = DateHelper.after((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeStartDate) ? valuepositionContainer.validfrom : this.mEmployeeStartDate;
                    endDate = DateHelper.before((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeEndDate) ? valuepositionContainer.validuntil : this.mEmployeeEndDate;
                    endDate = DateHelper.getLastDayOfMonth((Date)endDate);
                    switch (this.mFederalState) {
                        case 4: {
                            this.getFederalStateWageTaxValuesArbeitsKammerHB(valuepositionContainer, beginDate, endDate);
                            break block0;
                        }
                        case 10: {
                            this.getFederalStateWageTaxValuesArbeitsKammerSL(valuepositionContainer, beginDate, endDate);
                        }
                    }
                }
            }
        }
    }

    private void getLSTJAValues() {
        for (ValuepositionContainer valuepositionContainer : this.mValuePositionli) {
            Date beginDate = new VDate(this.mEmployeeStartDate).getDate();
            Date endDate = new VDate(this.mEmployeeEndDate).getDate();
            if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeEndDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeStartDate)) continue;
            beginDate = DateHelper.after((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeStartDate) ? valuepositionContainer.validfrom : this.mEmployeeStartDate;
            endDate = DateHelper.before((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeEndDate) ? valuepositionContainer.validuntil : this.mEmployeeEndDate;
            endDate = DateHelper.getLastDayOfMonth((Date)endDate);
            switch (valuepositionContainer.valuetypenumber) {
                case 760400: {
                    if (!DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                    this.FIELD_erst_lst_zwi_su = this.FIELD_erst_lst_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                    break;
                }
                case 760450: {
                    if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                    this.FIELD_erst_lst_zwi_su = this.FIELD_erst_lst_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                    break;
                }
                case 760100: {
                    if (new VDate(beginDate).getMonth() != 11) break;
                    this.FIELD_erst_lst_zwi_su = this.FIELD_erst_lst_zwi_su.subtract(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                    break;
                }
                case 760410: {
                    if (!DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                    this.FIELD_erst_soli_zwi_su = this.FIELD_erst_soli_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                    break;
                }
                case 760460: {
                    if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                    this.FIELD_erst_soli_zwi_su = this.FIELD_erst_soli_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                    break;
                }
                case 760110: {
                    if (new VDate(beginDate).getMonth() != 11) break;
                    this.FIELD_erst_soli_zwi_su = this.FIELD_erst_soli_zwi_su.subtract(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                    break;
                }
                case 760420: 
                case 760430: {
                    if (!DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                    this.FIELD_erst_kist_zwi_su = this.FIELD_erst_kist_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                    break;
                }
                case 760470: 
                case 760480: {
                    if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuepositionContainer.category != 22) break;
                    this.FIELD_erst_kist_zwi_su = this.FIELD_erst_kist_zwi_su.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                    break;
                }
                case 760120: 
                case 760130: {
                    if (new VDate(beginDate).getMonth() != 11) break;
                    this.FIELD_erst_kist_zwi_su = this.FIELD_erst_kist_zwi_su.subtract(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                    break;
                }
                case 760010: {
                    this.employeeLSTJA_aschluss = valuepositionContainer.factor1.intValue();
                }
            }
        }
    }

    private void getWageTaxValuePostionEmployeeBean() {
        if (DateHelper.afterOrEqual((Date)this.mWageTaxReportDataSource.getForValidDate(), (Date)new VDate(2007, 0, 1).getDate())) {
            this.setChurchTaxExpressions2007();
        } else {
            this.setChurchTaxExpressions();
        }
        if (new VDate(this.mEmployeeStartDate).getMonth() == 11) {
            this.getLSTJAValues();
            if (this.employeeLSTJA_aschluss == 0) {
                this.getChruchTaxLSTJA();
            } else {
                this.FIELD_erst_lst_zwi_su = BigDecimal.valueOf(0L, 2);
                this.FIELD_erst_soli_zwi_su = BigDecimal.valueOf(0L, 2);
                this.FIELD_erst_kist_zwi_su = BigDecimal.valueOf(0L, 2);
            }
        }
        for (ValuepositionContainer valuepositionContainer : this.mValuePositionli) {
            block0 : switch (valuepositionContainer.valuetypenumber) {
                case 110000: 
                case 220050: 
                case 223050: 
                case 226050: 
                case 227050: 
                case 710510: 
                case 710520: 
                case 710610: 
                case 710620: {
                    Date beginDate = new VDate(this.mEmployeeStartDate).getDate();
                    Date endDate = new VDate(this.mEmployeeEndDate).getDate();
                    if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeEndDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeStartDate)) break;
                    beginDate = DateHelper.after((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeStartDate) ? valuepositionContainer.validfrom : this.mEmployeeStartDate;
                    endDate = DateHelper.before((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeEndDate) ? valuepositionContainer.validuntil : this.mEmployeeEndDate;
                    endDate = DateHelper.getLastDayOfMonth((Date)endDate);
                    switch (valuepositionContainer.valuetypenumber) {
                        case 220050: 
                        case 710510: {
                            this.FIELD_LSt = this.FIELD_LSt.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break block0;
                        }
                        case 223050: 
                        case 710520: {
                            this.FIELD_SolZ = this.FIELD_SolZ.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break block0;
                        }
                        case 110000: {
                            this.steuerPflichtigesBrutto = this.steuerPflichtigesBrutto.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxValuePositonFactory.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break block0;
                        }
                        case 226050: 
                        case 227050: 
                        case 710610: 
                        case 710620: {
                            switch (this.mFederalState) {
                                case 3: {
                                    this.getFederalStateWageTaxValuesNI(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    break block0;
                                }
                                case 4: {
                                    this.getFederalStateWageTaxValuesHB(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    break block0;
                                }
                                case 5: {
                                    this.getFederalStateWageTaxValuesNRW(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    break block0;
                                }
                                case 6: {
                                    this.getFederalStateWageTaxValuesHE(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    break block0;
                                }
                                case 7: {
                                    this.getFederalStateWageTaxValuesRP(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    break block0;
                                }
                                case 8: {
                                    this.getFederalStateWageTaxValuesBW(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    break block0;
                                }
                                case 9: {
                                    this.getFederalStateWageTaxValuesBY(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    break block0;
                                }
                                case 10: {
                                    this.getFederalStateWageTaxValuesSL(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    break block0;
                                }
                                case 11: 
                                case 12: {
                                    this.getFederalStateWageTaxValuesBE(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    break block0;
                                }
                                case 17: {
                                    this.getFederalStateWageTaxValuesTH(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    break block0;
                                }
                                case 1: 
                                case 13: 
                                case 14: 
                                case 15: 
                                case 16: {
                                    this.getFederalStateWageTaxValuesDefault(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    break block0;
                                }
                                case 2: {
                                    if (DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate())) {
                                        this.getFederalStateWageTaxValuesDefault(this.mEWT, valuepositionContainer, beginDate, endDate);
                                    }
                                    if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate())) break block0;
                                    this.getFederalStateWageTaxValuesHH(this.mEWT, valuepositionContainer, beginDate, endDate);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void setFederalStateChurchTaxExpressionNI() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24 = BigDecimal.valueOf(0L, 2);
        this.FIELD_z_24_text = "";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "-";
        this.FIELD_z_25 = BigDecimal.valueOf(0L, 2);
        this.FIELD_z_25_text = "";
        this.FIELD_z_25_short_text = "";
        this.FIELD_z_25_nr = "-";
        this.FIELD_z_26_text = "Kirchensteuer - lt/rf (ev)";
        this.FIELD_z_26_short_text = "lt/rf (ev)";
        this.FIELD_z_26_nr = "76";
        this.FIELD_z_27_text = "Kirchensteuer - rk/ak";
        this.FIELD_z_27_short_text = "rk/ak";
        this.FIELD_z_27_nr = "77";
    }

    private void setFederalStateChurchTaxExpressionHB() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "Evangelische Kirchensteuer - ev";
        this.FIELD_z_24_short_text = "ev";
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "Beitr\u00e4ge zur Arbeitnehmerkammer";
        this.FIELD_z_26_short_text = "AK";
        this.FIELD_z_26_nr = "68";
    }

    private void setFederalStateChurchTaxExpressionNRW() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "Evangelische Kirchensteuer - ev/lt/rf/fr";
        this.FIELD_z_24_short_text = "ev/lt/rf/fr";
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "J\u00fcdische Kultussteuer - jd";
        this.FIELD_z_26_short_text = "jd";
        this.FIELD_z_26_nr = "64";
        this.FIELD_z_27_text = "Altkatholische Kirchensteuer - ak";
        this.FIELD_z_27_short_text = "ak";
        this.FIELD_z_27_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionHE() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        if (DateHelper.before((Date)this.mEmployeeStartDate, (Date)new VDate(2006, 0, 1).getDate())) {
            this.FIELD_z_24_text = "Evangelische Kirchensteuer - ev";
            this.FIELD_z_24_short_text = "ev";
        } else {
            this.FIELD_z_24_text = "Evangelische Kirchensteuer - ev (lt/rf/fr)";
            this.FIELD_z_24_short_text = "ev (lt/rf/fr)";
        }
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "Freireligi\u00f6se Gemeinde Offenbach/M. - fs";
        this.FIELD_z_26_short_text = "fs";
        this.FIELD_z_26_nr = "66";
        this.FIELD_z_27_text = "Freireligi\u00f6se Gemeinde Mainz - fm";
        this.FIELD_z_27_short_text = "fm";
        this.FIELD_z_27_nr = "65";
        this.FIELD_z_28_text = "Israelitische Kultussteuer Frankfurt - is";
        this.FIELD_z_28_short_text = "is";
        this.FIELD_z_28_nr = "64";
        this.FIELD_z_29_text = "Israelitische Kultussteuer der kultusberechtigten Gemeinden - il";
        this.FIELD_z_29_short_text = "il";
        this.FIELD_z_29_nr = "74";
        this.FIELD_z_30_text = "Altkatholische Kirchensteuer - ak";
        this.FIELD_z_30_short_text = "ak";
        this.FIELD_z_30_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionRP() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "Evangelische Kirchensteuer - ev";
        this.FIELD_z_24_short_text = "ev";
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "J\u00fcdische Kultussteuer - is";
        this.FIELD_z_26_short_text = "is";
        this.FIELD_z_26_nr = "64";
        this.FIELD_z_27_text = "Freireligi\u00f6se Landesgemeinde Pfalz - fg";
        this.FIELD_z_27_short_text = "fg";
        this.FIELD_z_27_nr = "68";
        this.FIELD_z_28_text = "Freireligi\u00f6se Gemeinde Mainz - fm";
        this.FIELD_z_28_short_text = "fm";
        this.FIELD_z_28_nr = "65";
        this.FIELD_z_29_text = "Freie Religionsgemeinschaft Alzey - fa";
        this.FIELD_z_29_short_text = "fa";
        this.FIELD_z_29_nr = "72";
        this.FIELD_z_30_text = "Altkatholische Kirchensteuer - ak";
        this.FIELD_z_30_short_text = "ak";
        this.FIELD_z_30_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionBW() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "Evangelische Kirchensteuer - ev";
        this.FIELD_z_24_short_text = "ev";
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "Kirchensteuer der Israelitischen Relgionsgemeinschaft Baden - ib";
        this.FIELD_z_26_short_text = "ib";
        this.FIELD_z_26_nr = "78";
        this.FIELD_z_27_text = "Kirchensteuer der Freireligi\u00f6sen Landesgemeinde Baden - fb";
        this.FIELD_z_27_short_text = "fb";
        this.FIELD_z_27_nr = "67";
        this.FIELD_z_28_text = "Kirchensteuer der Israelitischen Relgionsgemeinschaft W\u00fcttembergs - iw";
        this.FIELD_z_28_short_text = "iw";
        this.FIELD_z_28_nr = "73";
        this.FIELD_z_29_text = "Altkatholische Kirchensteuer - ak";
        this.FIELD_z_29_short_text = "ak";
        this.FIELD_z_29_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionBY() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "Evangelische Kirchensteuer";
        this.FIELD_z_24_short_text = "ev";
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "Israelitische Bekenntnissteuer";
        this.FIELD_z_26_short_text = "is";
        this.FIELD_z_26_nr = "64";
        this.FIELD_z_27_text = "Altkatholische Kirchensteuer";
        this.FIELD_z_27_short_text = "ak";
        this.FIELD_z_27_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionSL() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "Evangelische Kirchensteuer";
        this.FIELD_z_24_short_text = "ev";
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "Israelitische Kultussteuer";
        this.FIELD_z_26_short_text = "is";
        this.FIELD_z_26_nr = "64";
        this.FIELD_z_27_text = "Altkatholische Kirchensteuer";
        this.FIELD_z_27_short_text = "ak";
        this.FIELD_z_27_nr = "63";
        this.FIELD_z_28_text = "Beitr\u00e4ge zur Arbeitskammer";
        this.FIELD_z_28_short_text = "Arb.-kammer";
        this.FIELD_z_28_nr = "70";
    }

    private void setFederalStateChurchTaxExpressionBE() {
        this.FIELD_z_20_text = "";
        this.FIELD_z_20_nr = "-";
        this.FIELD_z_24_text = "Evangelische Kirchensteuer - ev";
        this.FIELD_z_24_short_text = "ev";
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "Altkatholische Kirchensteuer - ak";
        this.FIELD_z_26_short_text = "ak";
        this.FIELD_z_26_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionDefault() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "Evangelische Kirchensteuer";
        this.FIELD_z_24_short_text = "ev";
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-katholische Kirchensteuer";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "";
        this.FIELD_z_26_short_text = "";
        this.FIELD_z_26_nr = "";
        this.FIELD_z_27_text = "";
        this.FIELD_z_27_short_text = "";
        this.FIELD_z_27_nr = "";
    }

    private void setFederalStateChurchTaxExpressionHH() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "Evangelische Kirchensteuer";
        this.FIELD_z_24_short_text = "ev";
        this.FIELD_z_24_nr = "61";
        this.FIELD_z_25_text = "R\u00f6misch-Katholische Kirchensteuer";
        this.FIELD_z_25_short_text = "rk";
        this.FIELD_z_25_nr = "62";
        this.FIELD_z_26_text = "J\u00fcdische Kultussteuer - jh";
        this.FIELD_z_26_short_text = "jh";
        this.FIELD_z_26_nr = "64";
        this.FIELD_z_27_text = "";
        this.FIELD_z_27_short_text = "";
        this.FIELD_z_27_nr = "";
    }

    private void setFederalStateChurchTaxExpressionNI2007() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "47";
        this.FIELD_z_25 = BigDecimal.valueOf(0L, 2);
        this.FIELD_z_25_text = "";
        this.FIELD_z_25_short_text = "";
        this.FIELD_z_25_nr = "-";
        this.FIELD_z_26 = BigDecimal.valueOf(0L, 2);
        this.FIELD_z_26_text = "";
        this.FIELD_z_26_short_text = "";
        this.FIELD_z_26_nr = "-";
        this.FIELD_z_27_text = "Kirchensteuer - lt/rf (ev)";
        this.FIELD_z_27_short_text = "lt/rf (ev)";
        this.FIELD_z_27_nr = "76";
        this.FIELD_z_28_text = "Kirchensteuer - rk/ak";
        this.FIELD_z_28_short_text = "rk/ak";
        this.FIELD_z_28_nr = "77";
    }

    private void setFederalStateChurchTaxExpressionHB2007() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "47";
        this.FIELD_z_25_text = "Evangelische Kirchensteuer - ev";
        this.FIELD_z_25_short_text = "ev";
        this.FIELD_z_25_nr = "61";
        this.FIELD_z_26_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_26_short_text = "rk";
        this.FIELD_z_26_nr = "62";
        this.FIELD_z_27_text = "Beitr\u00e4ge zur Arbeitnehmerkammer";
        this.FIELD_z_27_short_text = "AK";
        this.FIELD_z_27_nr = "68";
    }

    private void setFederalStateChurchTaxExpressionNRW2007() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "47";
        this.FIELD_z_25_text = "Evangelische Kirchensteuer - ev/lt/rf/fr";
        this.FIELD_z_25_short_text = "ev/lt/rf/fr";
        this.FIELD_z_25_nr = "61";
        this.FIELD_z_26_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_26_short_text = "rk";
        this.FIELD_z_26_nr = "62";
        this.FIELD_z_27_text = "J\u00fcdische Kultussteuer - jd";
        this.FIELD_z_27_short_text = "jd";
        this.FIELD_z_27_nr = "64";
        this.FIELD_z_28_text = "Altkatholische Kirchensteuer - ak";
        this.FIELD_z_28_short_text = "ak";
        this.FIELD_z_28_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionHE2007() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "47";
        this.FIELD_z_25_text = "Evangelische Kirchensteuer - ev (lt/rf/fr)";
        this.FIELD_z_25_short_text = "ev (lt/rf/fr)";
        this.FIELD_z_25_nr = "61";
        this.FIELD_z_26_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_26_short_text = "rk";
        this.FIELD_z_26_nr = "62";
        this.FIELD_z_27_text = "Freireligi\u00f6se Gemeinde Offenbach/M. - fs";
        this.FIELD_z_27_short_text = "fs";
        this.FIELD_z_27_nr = "66";
        this.FIELD_z_28_text = "Freireligi\u00f6se Gemeinde Mainz - fm";
        this.FIELD_z_28_short_text = "fm";
        this.FIELD_z_28_nr = "65";
        this.FIELD_z_29_text = "Israelitische Kultussteuer Frankfurt - is";
        this.FIELD_z_29_short_text = "is";
        this.FIELD_z_29_nr = "64";
        this.FIELD_z_30_text = "Israelitische Kultussteuer der kultusberechtigten Gemeinden - il";
        this.FIELD_z_30_short_text = "il";
        this.FIELD_z_30_nr = "74";
        this.FIELD_z_31_text = "Altkatholische Kirchensteuer - ak";
        this.FIELD_z_31_short_text = "ak";
        this.FIELD_z_31_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionRP2007() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "47";
        this.FIELD_z_25_text = "Evangelische Kirchensteuer - ev";
        this.FIELD_z_25_short_text = "ev";
        this.FIELD_z_25_nr = "61";
        this.FIELD_z_26_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_26_short_text = "rk";
        this.FIELD_z_26_nr = "62";
        this.FIELD_z_27_text = "J\u00fcdische Kultussteuer - is";
        this.FIELD_z_27_short_text = "is";
        this.FIELD_z_27_nr = "64";
        this.FIELD_z_28_text = "Freireligi\u00f6se Landesgemeinde Pfalz - fg";
        this.FIELD_z_28_short_text = "fg";
        this.FIELD_z_28_nr = "68";
        this.FIELD_z_29_text = "Freireligi\u00f6se Gemeinde Mainz - fm";
        this.FIELD_z_29_short_text = "fm";
        this.FIELD_z_29_nr = "65";
        this.FIELD_z_30_text = "Freie Religionsgemeinschaft Alzey - fa";
        this.FIELD_z_30_short_text = "fa";
        this.FIELD_z_30_nr = "72";
        this.FIELD_z_31_text = "Altkatholische Kirchensteuer - ak";
        this.FIELD_z_31_short_text = "ak";
        this.FIELD_z_31_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionBW2007() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "47";
        this.FIELD_z_25_text = "Evangelische Kirchensteuer - ev";
        this.FIELD_z_25_short_text = "ev";
        this.FIELD_z_25_nr = "61";
        this.FIELD_z_26_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_26_short_text = "rk";
        this.FIELD_z_26_nr = "62";
        this.FIELD_z_27_text = "Kirchensteuer der Israelitischen Relgionsgemeinschaft Baden - ib";
        this.FIELD_z_27_short_text = "ib";
        this.FIELD_z_27_nr = "78";
        this.FIELD_z_28_text = "Kirchensteuer der Freireligi\u00f6sen Landesgemeinde Baden - fb";
        this.FIELD_z_28_short_text = "fb";
        this.FIELD_z_28_nr = "67";
        this.FIELD_z_29_text = "Kirchensteuer der Israelitischen Relgionsgemeinschaft W\u00fcttembergs - iw";
        this.FIELD_z_29_short_text = "iw";
        this.FIELD_z_29_nr = "73";
        this.FIELD_z_30_text = "Altkatholische Kirchensteuer - ak";
        this.FIELD_z_30_short_text = "ak";
        this.FIELD_z_30_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionBY2007() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "47";
        this.FIELD_z_25_text = "Evangelische Kirchensteuer";
        this.FIELD_z_25_short_text = "ev";
        this.FIELD_z_25_nr = "61";
        this.FIELD_z_26_text = "R\u00f6misch-Katholische Kirchensteuer";
        this.FIELD_z_26_short_text = "rk";
        this.FIELD_z_26_nr = "62";
        this.FIELD_z_27_text = "Israelitische Bekenntnissteuer";
        this.FIELD_z_27_short_text = "is";
        this.FIELD_z_27_nr = "64";
        this.FIELD_z_28_text = "Altkatholische Kirchensteuer";
        this.FIELD_z_28_short_text = "ak";
        this.FIELD_z_28_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionSL2007() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "47";
        this.FIELD_z_25_text = "Evangelische Kirchensteuer";
        this.FIELD_z_25_short_text = "ev";
        this.FIELD_z_25_nr = "61";
        this.FIELD_z_26_text = "R\u00f6misch-Katholische Kirchensteuer";
        this.FIELD_z_26_short_text = "rk";
        this.FIELD_z_26_nr = "62";
        this.FIELD_z_27_text = "Israelitische Kultussteuer";
        this.FIELD_z_27_short_text = "is";
        this.FIELD_z_27_nr = "64";
        this.FIELD_z_28_text = "Altkatholische Kirchensteuer";
        this.FIELD_z_28_short_text = "ak";
        this.FIELD_z_28_nr = "63";
        this.FIELD_z_29_text = "Beitr\u00e4ge zur Arbeitskammer";
        this.FIELD_z_29_short_text = "Arb.-kammer";
        this.FIELD_z_29_nr = "70";
    }

    private void setFederalStateChurchTaxExpressionBE2007() {
        this.FIELD_z_20_text = "";
        this.FIELD_z_20_nr = "-";
        this.FIELD_z_24_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "47";
        this.FIELD_z_25_text = "Evangelische Kirchensteuer - ev";
        this.FIELD_z_25_short_text = "ev";
        this.FIELD_z_25_nr = "61";
        this.FIELD_z_26_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_26_short_text = "rk";
        this.FIELD_z_26_nr = "62";
        this.FIELD_z_27_text = "Altkatholische Kirchensteuer - ak";
        this.FIELD_z_27_short_text = "ak";
        this.FIELD_z_27_nr = "63";
    }

    private void setFederalStateChurchTaxExpressionHH2007() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "47";
        this.FIELD_z_25_text = "Evangelische Kirchensteuer";
        this.FIELD_z_25_short_text = "ev";
        this.FIELD_z_25_nr = "61";
        this.FIELD_z_26_text = "R\u00f6misch-Katholische Kirchensteuer";
        this.FIELD_z_26_short_text = "rk";
        this.FIELD_z_26_nr = "62";
        this.FIELD_z_27_text = "J\u00fcdische Kultussteuer - jh";
        this.FIELD_z_27_short_text = "jh";
        this.FIELD_z_27_nr = "64";
        this.FIELD_z_28_text = "";
        this.FIELD_z_28_short_text = "";
        this.FIELD_z_28_nr = "";
    }

    private void setFederalStateChurchTaxExpressionDefault2007() {
        this.FIELD_z_20_text = "abz\u00fcglich an Arbeitnehmer ausgezahlte Bergmannspr\u00e4mien";
        this.FIELD_z_20_short_text = "BergPr";
        this.FIELD_z_20_nr = "46";
        this.FIELD_z_24_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_24_short_text = "";
        this.FIELD_z_24_nr = "47";
        this.FIELD_z_25_text = "Evangelische Kirchensteuer";
        this.FIELD_z_25_short_text = "ev";
        this.FIELD_z_25_nr = "61";
        this.FIELD_z_26_text = "R\u00f6misch-katholische Kirchensteuer";
        this.FIELD_z_26_short_text = "rk";
        this.FIELD_z_26_nr = "62";
        this.FIELD_z_27_text = "";
        this.FIELD_z_27_short_text = "";
        this.FIELD_z_27_nr = "";
        this.FIELD_z_28_text = "";
        this.FIELD_z_28_short_text = "";
        this.FIELD_z_28_nr = "";
    }

    private void setChurchTaxExpressions() {
        switch (this.mFederalState) {
            case 3: {
                this.setFederalStateChurchTaxExpressionNI();
                break;
            }
            case 4: {
                this.setFederalStateChurchTaxExpressionHB();
                break;
            }
            case 5: {
                this.setFederalStateChurchTaxExpressionNRW();
                break;
            }
            case 6: {
                this.setFederalStateChurchTaxExpressionHE();
                break;
            }
            case 7: {
                this.setFederalStateChurchTaxExpressionRP();
                break;
            }
            case 8: {
                this.setFederalStateChurchTaxExpressionBW();
                break;
            }
            case 9: {
                this.setFederalStateChurchTaxExpressionBY();
                break;
            }
            case 10: {
                this.setFederalStateChurchTaxExpressionSL();
                break;
            }
            case 11: 
            case 12: {
                this.setFederalStateChurchTaxExpressionBE();
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.setFederalStateChurchTaxExpressionDefault();
                break;
            }
            case 2: {
                this.setFederalStateChurchTaxExpressionHH();
            }
        }
    }

    private void setChurchTaxExpressions2007() {
        switch (this.mFederalState) {
            case 3: {
                this.setFederalStateChurchTaxExpressionNI2007();
                break;
            }
            case 4: {
                this.setFederalStateChurchTaxExpressionHB2007();
                break;
            }
            case 5: {
                this.setFederalStateChurchTaxExpressionNRW2007();
                break;
            }
            case 6: {
                this.setFederalStateChurchTaxExpressionHE2007();
                break;
            }
            case 7: {
                this.setFederalStateChurchTaxExpressionRP2007();
                break;
            }
            case 8: {
                this.setFederalStateChurchTaxExpressionBW2007();
                break;
            }
            case 9: {
                this.setFederalStateChurchTaxExpressionBY2007();
                break;
            }
            case 10: {
                this.setFederalStateChurchTaxExpressionSL2007();
                break;
            }
            case 11: 
            case 12: {
                this.setFederalStateChurchTaxExpressionBE2007();
                break;
            }
            case 1: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.setFederalStateChurchTaxExpressionDefault2007();
                break;
            }
            case 2: {
                this.setFederalStateChurchTaxExpressionHH2007();
            }
        }
    }

    private static final int getDiffInMonths(Date endDate, Date startDate) {
        return PDateHelper.getDiffInMonths((Date)endDate, (Date)startDate);
    }
}

