/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetax;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.CompanyPlantPostalAddress;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.pcompany.account.CompanyAccount;
import com.varial.personnel.domain.pcompany.account.CompanyAccountTP;
import com.varial.personnel.domain.pcompany.foundations.SpecificEnum;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.reportdatatransfer.ReportDataTransfer;
import com.varial.personnel.domain.reports.reportdatatransfer.mapper.ReportDataTransferExceptionMapper;
import com.varial.personnel.domain.reports.wagetax.RetroActiveTreatmentEnum;
import com.varial.personnel.domain.reports.wagetax.WageTaxEmployeeBean;
import com.varial.personnel.domain.reports.wagetax.WageTaxHelper;
import com.varial.personnel.domain.reports.wagetax.WageTaxPayment;
import com.varial.personnel.domain.reports.wagetax.WageTaxPaymentBean;
import com.varial.personnel.domain.reports.wagetax.WageTaxReportBean;
import com.varial.personnel.domain.reports.wagetax.WageTaxValuePositonFactory;
import com.varial.personnel.domain.reports.wagetax.WageTaxValuePositonFactory2007;
import com.varial.personnel.domain.reports.wagetax.WageTaxValuePositonFactory2009;
import com.varial.personnel.domain.reports.wagetax.WageTaxValuePositonFactory2010;
import com.varial.personnel.domain.reports.wagetax.WageTaxValuePositonFactory2012;
import com.varial.personnel.domain.reports.wagetax.WageTaxValuePositonFactory2015;
import com.varial.personnel.domain.reports.wagetax.WageTaxValuePositonFactory2018;
import com.varial.personnel.domain.reports.wagetax.WageTaxValuePositonFactory2019;
import com.varial.personnel.domain.reports.wagetax.mapper.WTExceptionMapper;
import com.varial.personnel.domain.reports.wagetaxperemployee.WageTaxPerEmployeeReportDataSource;
import com.varial.personnel.domain.reports.wagetaxperemployee.WageTaxPerEmployeeReportSortComparator;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallback;
import com.varial.serverbase.query.PutDataException;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class WageTaxReportDataSource
extends WageTaxPerEmployeeReportDataSource {
    private final List<WageTaxPaymentBean> mWageTaxPaymentList = new LinkedList<WageTaxPaymentBean>();
    private final String mNameForPayment;
    private String FIELD_anmeldezeitraum_monat_bez;
    private String FIELD_finanzamt_strasse_nr;
    private String FIELD_finanzamt_plz_ort;
    private String FIELD_arbeitgeber_strasse_nr;
    private String FIELD_arbeitgeber_plz_ort;
    private String FIELD_berichtigte_anmeldung;
    private String FIELD_anmeldezeitraum_jahr_kurz;
    private String FIELD_anmeldezeitraum_jahr_lang;
    private String FIELD_anmeldezeitraum_monat_zahl;
    private String FIELD_erstattungsbetrag = "";
    private String FIELD_einzugsermaechtigung = "";
    private int mAnzahlLStA = 1;
    private BigDecimal FIELD_LSt = BigDecimal.ZERO;
    private BigDecimal zeile18_2007 = BigDecimal.ZERO;
    private BigDecimal FIELD_KG = BigDecimal.ZERO;
    private BigDecimal FIELD_z_20 = BigDecimal.ZERO;
    private BigDecimal FIELD_kuerzung_besatzungsmitglieder_handelschiffen = BigDecimal.ZERO;
    private BigDecimal FIELD_foerderbetragBAV = BigDecimal.ZERO;
    private BigDecimal FIELD_energiepreispauschale = BigDecimal.ZERO;
    private BigDecimal FIELD_verbleib = BigDecimal.ZERO;
    private BigDecimal FIELD_SolZ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_24 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_25 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_26 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_27 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_28 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_29 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_30 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_31 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_32 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_33 = BigDecimal.ZERO;
    private BigDecimal FIELD_gesamt = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_LSt = BigDecimal.ZERO;
    private BigDecimal mPaymentZeile18_2007 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_KG = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_z_20 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_kuerzung_besatzungsmitglieder_handelschiffen = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_foerderbetragBAV = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_energiepreispauschale = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_verbleib = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_SolZ = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_z_24 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_z_25 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_z_26 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_z_27 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_z_28 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_z_29 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_z_30 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_z_31 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_z_32 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_z_33 = BigDecimal.ZERO;
    private BigDecimal mPaymentFIELD_gesamt = BigDecimal.ZERO;
    private final List<WageTaxReportBean> mWageTaxCollection = new LinkedList<WageTaxReportBean>();
    private final List<WageTaxReportBean> mWageTaxCollection2007 = new LinkedList<WageTaxReportBean>();
    private final List<WageTaxReportBean> mWageTaxCollection2009 = new LinkedList<WageTaxReportBean>();
    private final List<WageTaxReportBean> mWageTaxCollection2018 = new LinkedList<WageTaxReportBean>();
    private final List<WageTaxReportBean> mWageTaxCollection2019 = new LinkedList<WageTaxReportBean>();
    private final List<String> mWageTaxEmployeeBAVLi = new LinkedList<String>();
    private String LSTA_MERKER;
    private String FIELD_EmployerStateDescription = "";
    private String mEncoding = "";
    private String mFileList = "";
    private int mFileListLength = 0;
    private ReportDataTransfer mReportDataTransfer;

    public WageTaxReportDataSource(AllCallback callback, ISpecialAccessPersistencyContext sapc, ReportFirstFilterStruct firstFilter, ReportSecondFilterStruct[] secondFilters, ReportThirdFilterStruct thirdFilter, ReportSortStruct[] sorts, Date forEffectiveDate, Date forValidDate, String name, boolean payment, boolean dataTransfer, boolean internalUse, boolean cancelationCollectionOrder, boolean computationAmountRefunded, RetroActiveTreatmentEnum retroActiveType, List<String> errorList, ProgressBarUpdater progressBar) throws BusinessDomainException, PutDataException {
        super(callback, sapc, firstFilter, secondFilters, thirdFilter, sorts, forEffectiveDate, forValidDate, payment, dataTransfer, internalUse, retroActiveType, errorList, progressBar);
        this.mNameForPayment = name;
        this.FIELD_einzugsermaechtigung = cancelationCollectionOrder ? "1" : "";
        this.FIELD_erstattungsbetrag = computationAmountRefunded ? "1" : "";
        SpecificEnum spec = this.mReportValues.getPCompanyFoundations(this.mCurrentOidPCompany, this.mForEffectiveDate, this.mForValidDate).getSpecific();
        if (this.mUsePerfidia) {
            switch (spec.value()) {
                case 1: {
                    this.LSTA_MERKER = "700000001";
                    break;
                }
                default: {
                    this.LSTA_MERKER = "000000000";
                }
            }
            try {
                boolean goOn = true;
                while (goOn) {
                    goOn = this.next();
                }
            }
            catch (JRException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    protected void initWageTaxReportDataSourceWork(boolean usePerfidia, String perfidiaPath) throws BusinessDomainException {
        if ((this.mPayment || usePerfidia) && !DateHelper.equal((Date)this.mForEffectiveDate, (Date)this.mForValidDate)) {
            throw ReportDataTransferExceptionMapper.makeNotTheSameDateForDatatransferOrPayment();
        }
        if (usePerfidia) {
            String sendQuePath = "\\ofd\\sendq\\";
            String wageTaxReportFilePrefix = "elsta0_";
            this.mReportDataTransfer = new ReportDataTransfer(perfidiaPath, "\\ofd\\sendq\\", "elsta0_", true);
        }
    }

    @Override
    protected void sortEmployeeBeans() throws BusinessDomainException {
        if ((this.mPayment || this.mUsePerfidia) && this.mBerichtigungEPP && BigDecimalMapper.compareTo((BigDecimal)this.mEPPAktuellerMonat, (BigDecimal)this.mEPPVormonatMonat) == 0) {
            throw WTExceptionMapper.makeNoDifferencesInTheEPPDomainException();
        }
        if (this.mIsSuperiorForConsolidation) {
            this.changeEmployer(this.mWageTaxEmployeesBeanLi);
        }
        int[] intArray = new int[]{0, 2, 1, 3};
        Collections.sort(this.mWageTaxEmployeesBeanLi, new WageTaxPerEmployeeReportSortComparator(intArray));
    }

    private void changeEmployer(List<WageTaxEmployeeBean> wageTaxEmployeesBeanLi) throws BusinessDomainException {
        String employerLongDescription = this.mReportValues.getCompanyLongDescription(this.mPCompanyForConsolidation.getObjectid(), this.mForEffectiveDate, this.mListEndDate);
        CompanyPlantPostalAddress companyPlantPostalAddress = this.mReportValues.getCompanyPostalAdress(this.mPCompanyForConsolidation.getObjectid(), this.mForEffectiveDate, this.mListEndDate, true);
        for (WageTaxEmployeeBean wageTaxEmployeeBean : wageTaxEmployeesBeanLi) {
            if (wageTaxEmployeeBean == null) continue;
            wageTaxEmployeeBean.setEmployerOid(this.mPCompanyForConsolidation.getObjectid());
            wageTaxEmployeeBean.setEmployerLongDescription(employerLongDescription);
            wageTaxEmployeeBean.setEmployerKey(this.mPCompanyForConsolidation.getPCompanyKey());
            wageTaxEmployeeBean.setEmployerStreetAndNumber(companyPlantPostalAddress.getStreet());
            wageTaxEmployeeBean.setEmployerPostalcode(companyPlantPostalAddress.getPostalCode());
            wageTaxEmployeeBean.setEmployerCity(companyPlantPostalAddress.getCity());
        }
    }

    @Override
    protected void getOverSteuerungsModulEmployeeBeans(List<EmployeeForReport> employeesLi) throws BusinessDomainException, PutDataException {
        this.mProgressBar.setTotal(employeesLi.size());
        for (EmployeeForReport currentEmployee : employeesLi) {
            Employment employeeTaxContainer;
            if (!this.handleRegistrationPeriodSettings(currentEmployee.getTaxOffice())) continue;
            Date currentEmployeeValidFromDate = DateHelper.getFirstDayOfMonth((Date)this.mListFirstDate);
            Date currentEmployeeValidUntilDate = DateHelper.getLastDayOfMonth((Date)this.mListFirstDate);
            Date effectiveDate = currentEmployeeValidFromDate;
            this.mProgressBar.update(currentEmployee.getPCompanyKey() + " / " + currentEmployee.getPersonnelNumber());
            boolean useEmployee = false;
            Date dateOfWithDrawal = currentEmployee.getDateOfWithDrawal();
            if (this.mBerichtigungEPP && dateOfWithDrawal != null && DateHelper.before((Date)dateOfWithDrawal, (Date)currentEmployeeValidFromDate)) {
                employeeTaxContainer = this.mReportValues.getEmployeeEmploymentTP(currentEmployee.getOidEmployee(), this.mEffectiveDateEPP, this.mEffectiveDateEPP);
                dateOfWithDrawal = employeeTaxContainer.getDateOfWithDrawal();
            }
            while (DateHelper.before((Date)currentEmployeeValidFromDate, (Date)this.mListEndDate)) {
                if (dateOfWithDrawal != null) {
                    if (DateHelper.before((Date)dateOfWithDrawal, (Date)currentEmployeeValidFromDate)) {
                        if (this.hasCalculationbasics(currentEmployee.getOidEmployee(), effectiveDate, currentEmployeeValidFromDate)) {
                            useEmployee = true;
                        }
                    } else {
                        useEmployee = true;
                    }
                } else {
                    useEmployee = true;
                }
                if (useEmployee) {
                    employeeTaxContainer = this.mReportValues.getEmployeeTaxContainer(currentEmployee.getOidEmployee(), effectiveDate, currentEmployeeValidFromDate);
                    if (!this.mBerichtigungEPP && employeeTaxContainer == null) {
                        if (this.mInternalUse) {
                            String employerDescription = this.mReportValues.getCompanyLongDescription(currentEmployee.getOidPCompany(), effectiveDate, currentEmployeeValidFromDate);
                            this.mErrorReportFactory.addErrorMessageEmployeeToEmployer(currentEmployee.getOidPCompany(), employerDescription, 1, "1* G\u00fcltig f\u00fcr: " + DateMapper.toDDMMYYYYPointSeparationString((Date)currentEmployeeValidFromDate), currentEmployee, currentEmployeeValidFromDate);
                        }
                        currentEmployeeValidFromDate = DateHelper.tomorrow((Date)currentEmployeeValidUntilDate);
                        currentEmployeeValidUntilDate = DateHelper.getLastDayOfMonth((Date)currentEmployeeValidFromDate);
                        effectiveDate = currentEmployeeValidFromDate;
                        continue;
                    }
                    int index = this.mWageTaxPerEmployeeHelper.getRunIndex(currentEmployee, effectiveDate, currentEmployeeValidUntilDate);
                    this.mHatKammerbeitrag = index == 2;
                    for (int i = 1; i <= index; ++i) {
                        this.mSecondRun = i == 2;
                        this.getEmployeeBeans(currentEmployee, effectiveDate, currentEmployeeValidFromDate, currentEmployeeValidUntilDate);
                    }
                }
                currentEmployeeValidFromDate = DateHelper.tomorrow((Date)currentEmployeeValidUntilDate);
                currentEmployeeValidUntilDate = DateHelper.getLastDayOfMonth((Date)currentEmployeeValidFromDate);
                effectiveDate = currentEmployeeValidFromDate;
            }
        }
    }

    @Override
    protected void checkForJournalisationEinzelnachweis(WageTaxEmployeeBean eWT) {
    }

    private String writeLstAVorlaufSatz() throws BusinessDomainException {
        if (this.mUser == null || StringMapper.isNullString((String)this.mUser.getEmail())) {
            throw WTExceptionMapper.makeUserEmailMissedDomainException();
        }
        if (this.mUser == null || StringMapper.isNullString((String)this.mUser.getPhone())) {
            throw WTExceptionMapper.makeUserPhoneMissedDomainException();
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"VOSZ", (int)4));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)"01", (int)2));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)this.LSTA_MERKER, (int)9));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)"20260", (int)5));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"Varial World Edition Personalwirtschaft", (int)50));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mVersion, (int)50));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.FIELD_arbeitgeber_bezeichnung, (int)60));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.FIELD_arbeitgeber_strasse_nr, (int)33));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEWT.getEmployerPostalcode(), (int)10));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEWT.getEmployerCity(), (int)34));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.FIELD_EmployerStateDescription, (int)30));
        String user = "";
        String email = "";
        String telefonnummer = "";
        if (!StringMapper.isNullString((String)this.mEWT.getEmail()) && !StringMapper.isNullString((String)this.mEWT.getTelefonnummer())) {
            user = "Sachbearbeiter/in";
            email = this.mEWT.getEmail();
            telefonnummer = this.mEWT.getTelefonnummer();
        } else if (this.mUser != null) {
            user = this.mUser.getName();
            email = this.mUser.getEmail();
            telefonnummer = this.mUser.getPhone();
        }
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)(this.mUser != null ? this.mUser.getName() : ""), (int)30));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)(this.mUser != null ? this.mUser.getPhone() : ""), (int)20));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)(this.mUser != null ? this.mUser.getEmail() : ""), (int)64));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.FIELD_arbeitgeber_bezeichnung, (int)60));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.FIELD_arbeitgeber_strasse_nr, (int)33));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEWT.getEmployerPostalcode(), (int)10));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEWT.getEmployerCity(), (int)34));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.FIELD_EmployerStateDescription, (int)30));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)user, (int)30));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)telefonnummer, (int)20));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)email, (int)64));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)this.mEncoding, (int)2));
        String fileContent = ReportDataTransfer.reduceToSize((String)this.FIELD_pcompany_plant_key, (int)20) + " / " + DateMapper.toYYYYString((Date)this.mField_monat_jahr) + "." + DateMapper.toDDMMYYYYString((Date)this.mField_monat_jahr).substring(2, 4);
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)fileContent, (int)30));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)1334));
        return strBuffer.toString();
    }

    private String writeLstANachlaufSatz() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append('\n');
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"NCSZ", (int)4));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)"01", (int)2));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)"1", (int)4));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)2038));
        return strBuffer.toString();
    }

    private String writeLstASatz() throws BusinessDomainException {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append('\n');
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"LSTASZ", (int)6));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)"01", (int)2));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)this.mEWT.getEmployerTaxOfficeNumber(), (int)4));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)(this.FIELD_jahr + "01"), (int)6));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.FIELD_pcompany_plant_key, (int)20));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.FIELD_arbeitgeber_bezeichnung, (int)45));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.FIELD_arbeitgeber_strasse_nr, (int)30));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEWT.getEmployerPostalcode(), (int)12));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEWT.getEmployerCity(), (int)30));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)DateMapper.toYYYYMMDDString((Date)new Date()), (int)8));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)this.FIELD_jahr, (int)4));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)this.FIELD_anmeldezeitraum_monat_zahl, (int)2));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)(this.mEWT.getEmployerTaxOfficeNumber() + "0" + this.mEWT.getEmployerPartElsterTaxNumber()), (int)13));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"20260", (int)95));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)this.FIELD_berichtigte_anmeldung, (int)1));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)(StringMapper.isNullString((String)this.FIELD_einzugsermaechtigung) ? "0" : "1"), (int)1));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)(StringMapper.isNullString((String)this.FIELD_erstattungsbetrag) ? "0" : "1"), (int)1));
        strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_kuerzung_besatzungsmitglieder_handelschiffen, (int)2, (int)12));
        strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_LSt, (int)2, (int)12));
        strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_KG, (int)2, (int)12));
        strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_20, (int)2, (int)12));
        strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_verbleib, (int)2, (int)12));
        strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_SolZ, (int)2, (int)12));
        if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2019, 0, 1).getDate())) {
            switch (this.mEWT.getEmployerFstateregionKey()) {
                case 1: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 2: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 3: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    this.appenDefaultKZStringBuffer(1, strBuffer);
                    break;
                }
                case 4: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(5, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(7, strBuffer);
                    break;
                }
                case 5: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 6: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_32, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(5, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_31, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    break;
                }
                case 7: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_32, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(2, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(1, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_31, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(5, strBuffer);
                    break;
                }
                case 8: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_31, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    break;
                }
                case 9: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 10: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(4, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(6, strBuffer);
                    break;
                }
                case 11: 
                case 12: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(12, strBuffer);
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(13, strBuffer);
                }
            }
        } else if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2018, 0, 1).getDate())) {
            switch (this.mEWT.getEmployerFstateregionKey()) {
                case 1: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 2: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 3: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    this.appenDefaultKZStringBuffer(1, strBuffer);
                    break;
                }
                case 4: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(5, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(7, strBuffer);
                    break;
                }
                case 5: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 6: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_33, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_31, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(5, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_32, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    break;
                }
                case 7: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_33, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_31, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(2, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(1, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_32, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(5, strBuffer);
                    break;
                }
                case 8: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_32, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_31, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    break;
                }
                case 9: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 10: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(4, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_31, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(6, strBuffer);
                    break;
                }
                case 11: 
                case 12: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(12, strBuffer);
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(13, strBuffer);
                }
            }
        } else {
            switch (this.mEWT.getEmployerFstateregionKey()) {
                case 1: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 2: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(1, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 3: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    this.appenDefaultKZStringBuffer(1, strBuffer);
                    break;
                }
                case 4: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(5, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(7, strBuffer);
                    break;
                }
                case 5: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 6: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_31, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(5, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    break;
                }
                case 7: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_31, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(2, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(1, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(5, strBuffer);
                    break;
                }
                case 8: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_30, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(3, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    break;
                }
                case 9: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(11, strBuffer);
                    break;
                }
                case 10: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_28, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(4, strBuffer);
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_29, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(6, strBuffer);
                    break;
                }
                case 11: 
                case 12: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_27, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(12, strBuffer);
                    break;
                }
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
                    strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
                    this.appenDefaultKZStringBuffer(13, strBuffer);
                }
            }
        }
        strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_gesamt, (int)2, (int)12));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)Integer.toString(this.FIELD_zahl_an), (int)7));
        strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.zeile18_2007, (int)2, (int)12));
        if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2019, 0, 1).getDate())) {
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_25, (int)2, (int)12));
        } else if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2018, 0, 1).getDate())) {
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_26, (int)2, (int)12));
        } else {
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_24, (int)2, (int)12));
        }
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)224));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)"00000", (int)5));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)44));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)"00000", (int)5));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)454));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)"00000", (int)5));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)44));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)"00000", (int)5));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)90));
        strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_z_20, (int)2, (int)12));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)"0", (int)1));
        strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)180));
        strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_foerderbetragBAV, (int)2, (int)12));
        strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)Integer.toString(this.FIELD_zahl_an_bav), (int)7));
        if (DateHelper.before((Date)this.mForValidDate, (Date)new VDate(2019, 0, 1).getDate())) {
            strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)385));
        } else if (DateHelper.before((Date)this.mForValidDate, (Date)new VDate(2021, 0, 1).getDate())) {
            strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)this.mEWT.getEmployerFamilyFundKey(), (int)9));
            strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)376));
        } else {
            strBuffer.append(ReportDataTransfer.makeToNeededNumberLength((String)this.mEWT.getEmployerFamilyFundKey(), (int)9));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)this.FIELD_energiepreispauschale, (int)2, (int)12));
            strBuffer.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)28));
        }
        return strBuffer.toString();
    }

    private void appenDefaultKZStringBuffer(int count, StringBuffer strBuffer) {
        for (int i = 0; i < count; ++i) {
            strBuffer.append(ReportDataTransfer.getDezimalString((Object)BigDecimal.ZERO, (int)2, (int)12));
        }
    }

    @Override
    protected boolean areFieldsValuesZero(WageTaxEmployeeBean wTEBean) {
        if (wTEBean.getEmployeeTaxacation() == 5) {
            return false;
        }
        return BigDecimalMapper.isZero((BigDecimal)wTEBean.getSteuerPflichtigesBrutto()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_LSt()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_SolZ()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_foerderbetragBAV()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_verbleib()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_KG()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_kuerz_besatz_handels()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_z_24()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_z_25()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_z_26()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_z_27()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_z_28()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_z_29()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_z_30()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_z_31()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_z_32()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_z_33()) && BigDecimalMapper.isZero((BigDecimal)wTEBean.getFIELD_Energiepreispauschale());
    }

    @Override
    protected void setWageTaxPerEmployeePCompany(WageTaxEmployeeBean eWT) throws BusinessDomainException {
        super.setWageTaxPerEmployeePCompany(eWT);
        try {
            CompanyPlantPostalAddress companyPlantPostalAddress = this.mReportValues.getCompanyPostalAdress(eWT.getOidPCompany(), this.mForEffectiveDate, this.mListEndDate);
            eWT.setPCompanyStreetAndNumber(companyPlantPostalAddress.getStreet());
            eWT.setPCompanyPostalcode(companyPlantPostalAddress.getPostalCode());
            eWT.setPCompanyCity(companyPlantPostalAddress.getCity());
            PostalAddress companyTaxOfficePostalAdress = this.mReportValues.getCompanyTaxOfficeAdress(eWT.getOidPCompany(), this.mForEffectiveDate, this.mListEndDate);
            if (companyTaxOfficePostalAdress != null) {
                eWT.setPCompanyTaxOfficeStreetAndNumber(companyTaxOfficePostalAdress.getStreet());
                eWT.setPCompanyTaxOfficePostalcodeAndCity(companyTaxOfficePostalAdress.getPostalCode() + " " + companyTaxOfficePostalAdress.getCity());
            }
        }
        catch (BusinessDomainException e) {
            BusinessDomainException dE = e;
            String employerDescription = this.mReportValues.getCompanyLongDescription(eWT.getOidPCompany(), this.mForEffectiveDate, this.mListEndDate);
            this.mErrorReportFactory.addErrorMessageToEmployer(eWT.getOidPCompany(), employerDescription, dE.getErrorNumber(), this.mForEffectiveDate, this.mListEndDate, dE.getMessage());
        }
        eWT.setEmployerStreetAndNumber(eWT.getPCompanyStreetAndNumber());
        eWT.setEmployerPostalcode(eWT.getPCompanyPostalcode());
        eWT.setEmployerCity(eWT.getPCompanyCity());
        eWT.setEmployerTaxOfficeStreetAndNumber(eWT.getPCompanyTaxOfficeStreetAndNumber());
        eWT.setEmployerTaxOfficePostalcodeAndCity(eWT.getPCompanyTaxOfficePostalcodeAndCity());
        if (this.mUsePerfidia) {
            int bundesland = StringMapper.isNullString((String)eWT.getPcompanyTaxOfficeNumber()) ? 0 : Integer.parseInt(eWT.getPcompanyTaxOfficeNumber().substring(0, 2));
            String employerPartElsterTaxNumber = ReportDataTransfer.getEmployerPartElsterTaxNumber((String)eWT.getEmployerTaxNumber(), (int)bundesland);
            eWT.setEmployerPartElsterTaxNumber(employerPartElsterTaxNumber);
            eWT.setPcompanyFederalStateLongDescription(this.mReportValues.getCompanyFederalStateLongDescription(eWT.getOidPCompany(), this.mForEffectiveDate, this.mListEndDate));
            eWT.setEmployerFederalStateLongDescription(eWT.getPcompanyFederalStateLongDescription());
        }
    }

    @Override
    protected void getDataFor(WageTaxEmployeeBean eWT, boolean kommtAusRR) throws BusinessDomainException {
        if (this.mBerichtigungEPP || eWT.getValuePositionliCount() != 0L) {
            this.distinguishWageTaxValues(eWT, kommtAusRR);
        }
        if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2019, 0, 1).getDate())) {
            Date gueltigAb = new VDate(2022, 7, 1).getDate();
            Date gueltigBis = new VDate(2022, 7, 31).getDate();
            Date monatVon = DateHelper.getFirstDayOfMonth((Date)this.mVersatzMonat);
            Date monatVBis = DateHelper.getLastDayOfMonth((Date)this.mVersatzMonat);
            switch (this.mAnmeldezeitraum.value()) {
                case 1: {
                    gueltigAb = new VDate(2022, 8, 1).getDate();
                    gueltigBis = new VDate(2022, 8, 30).getDate();
                    monatVon = eWT.getEmployeeStartDate();
                    monatVBis = eWT.getEmployeeEndDate();
                    break;
                }
                case 2: {
                    gueltigAb = new VDate(2022, 11, 1).getDate();
                    gueltigBis = new VDate(2022, 11, 31).getDate();
                    monatVon = eWT.getEmployeeStartDate();
                    monatVBis = eWT.getEmployeeEndDate();
                }
            }
            boolean mitEEP = false;
            if (!kommtAusRR && DateHelper.afterOrEqual((Date)this.mVersatzMonat, (Date)gueltigAb) && DateHelper.beforeOrEqual((Date)this.mVersatzMonat, (Date)gueltigBis) && DateHelper.equal((Date)monatVon, (Date)new VDate(2022, 7, 1).getDate()) && DateHelper.equal((Date)monatVBis, (Date)new VDate(2022, 7, 31).getDate())) {
                mitEEP = true;
            }
            WageTaxValuePositonFactory2019 wageTaxValuePositonFactory2019 = new WageTaxValuePositonFactory2019();
            wageTaxValuePositonFactory2019.run(this, eWT, mValueTypeNumbers, mitEEP);
            this.mEPPAktuellerMonat = this.mEPPAktuellerMonat.add(wageTaxValuePositonFactory2019.getEPPAktuellerMonat());
            this.mEPPVormonatMonat = this.mEPPVormonatMonat.add(wageTaxValuePositonFactory2019.getEPPVormonatMonat());
        } else if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2018, 0, 1).getDate())) {
            WageTaxValuePositonFactory2018 wageTaxValuePositonFactory2018 = new WageTaxValuePositonFactory2018();
            wageTaxValuePositonFactory2018.run(this, eWT, mValueTypeNumbers);
        } else if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2015, 0, 1).getDate())) {
            WageTaxValuePositonFactory2015 wageTaxValuePositonFactory2015 = new WageTaxValuePositonFactory2015();
            wageTaxValuePositonFactory2015.run(this, eWT, mValueTypeNumbers);
        } else if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2012, 0, 1).getDate())) {
            WageTaxValuePositonFactory2012 wageTaxValuePositonFactory2012 = new WageTaxValuePositonFactory2012();
            wageTaxValuePositonFactory2012.run(this, eWT, mValueTypeNumbers);
        } else if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2010, 0, 1).getDate())) {
            WageTaxValuePositonFactory2010 wageTaxValuePositonFactory2010 = new WageTaxValuePositonFactory2010();
            wageTaxValuePositonFactory2010.run(this, eWT, mValueTypeNumbers);
        } else if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2009, 0, 1).getDate())) {
            WageTaxValuePositonFactory2009 wageTaxValuePositonFactory2009 = new WageTaxValuePositonFactory2009();
            wageTaxValuePositonFactory2009.run(this, eWT, mValueTypeNumbers, this.mFirstFilterKammerBeitragOidPlant);
        } else if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2007, 0, 1).getDate())) {
            WageTaxValuePositonFactory2007 wageTaxValuePositonFactory2007 = new WageTaxValuePositonFactory2007();
            wageTaxValuePositonFactory2007.run(this, eWT, mValueTypeNumbers, this.mFirstFilterKammerBeitragOidPlant);
        } else {
            WageTaxValuePositonFactory wageTaxValuePositonFactory = new WageTaxValuePositonFactory();
            wageTaxValuePositonFactory.run(this, eWT, mValueTypeNumbers, this.mFirstFilterKammerBeitragOidPlant);
        }
    }

    private void createCollectionBean() {
        WageTaxReportBean wageTaxReportBean = new WageTaxReportBean(this.FIELD_jahr, this.FIELD_steuernummer, this.FIELD_anmeldezeitraum_monat_bez, this.FIELD_finanzamt_bezeichnung, this.FIELD_finanzamt_strasse_nr, this.FIELD_finanzamt_plz_ort, this.FIELD_pcompany_plant_key, this.FIELD_arbeitgeber_bezeichnung, this.FIELD_arbeitgeber_strasse_nr, this.FIELD_arbeitgeber_plz_ort, this.FIELD_berichtigte_anmeldung, this.FIELD_erstattungsbetrag, this.FIELD_einzugsermaechtigung, this.FIELD_anmeldezeitraum_jahr_kurz, this.FIELD_anmeldezeitraum_jahr_lang, StringMapper.fillUpWithZero((String)Integer.toString(new VDate(this.mForValidDate).getMonth() + 1), (int)2), this.mEWT.getFIELD_pausch_nach37_text(), this.mEWT.getFIELD_z_24_text(), this.mEWT.getFIELD_z_25_text(), this.mEWT.getFIELD_z_26_text(), this.mEWT.getFIELD_z_27_text(), this.mEWT.getFIELD_z_28_text(), this.mEWT.getFIELD_z_29_text(), this.mEWT.getFIELD_z_30_text(), this.mEWT.getFIELD_z_31_text(), this.mEWT.getFIELD_z_32_text(), this.mEWT.getFIELD_z_33_text(), Integer.toString(this.FIELD_zahl_an), Integer.toString(this.FIELD_zahl_an_bav), ReportHelper.toCurrencyFormat((Object)this.FIELD_LSt), ReportHelper.toCurrencyFormat((Object)this.zeile18_2007), ReportHelper.toCurrencyFormat((Object)this.FIELD_KG), ReportHelper.toCurrencyFormat((Object)this.FIELD_z_20), ReportHelper.toCurrencyFormat((Object)this.FIELD_kuerzung_besatzungsmitglieder_handelschiffen), ReportHelper.toCurrencyFormat((Object)this.FIELD_foerderbetragBAV), ReportHelper.toCurrencyFormat((Object)this.FIELD_energiepreispauschale), ReportHelper.toCurrencyFormat((Object)this.FIELD_verbleib), ReportHelper.toCurrencyFormat((Object)this.FIELD_SolZ), ReportHelper.toCurrencyFormat((Object)this.FIELD_z_24), ReportHelper.toCurrencyFormat((Object)this.FIELD_z_25), ReportHelper.toCurrencyFormat((Object)this.FIELD_z_26), ReportHelper.toCurrencyFormat((Object)this.FIELD_z_27), ReportHelper.toCurrencyFormat((Object)this.FIELD_z_28), ReportHelper.toCurrencyFormat((Object)this.FIELD_z_29), ReportHelper.toCurrencyFormat((Object)this.FIELD_z_30), ReportHelper.toCurrencyFormat((Object)this.FIELD_z_31), ReportHelper.toCurrencyFormat((Object)this.FIELD_z_32), ReportHelper.toCurrencyFormat((Object)this.FIELD_z_33), ReportHelper.toCurrencyFormat((Object)this.FIELD_gesamt), this.mEWT.getFIELD_pausch_nach37_nr(), this.mEWT.getFIELD_z_24_nr(), this.mEWT.getFIELD_z_25_nr(), this.mEWT.getFIELD_z_26_nr(), this.mEWT.getFIELD_z_27_nr(), this.mEWT.getFIELD_z_28_nr(), this.mEWT.getFIELD_z_29_nr(), this.mEWT.getFIELD_z_30_nr(), this.mEWT.getFIELD_z_31_nr(), this.mEWT.getFIELD_z_32_nr(), this.mEWT.getFIELD_z_33_nr(), this.mStaticText_internalUse, this.mEWT.getTelefonnummer(), this.mEWT.getEmail());
        if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2019, 0, 1).getDate())) {
            this.mWageTaxCollection2019.clear();
            this.mWageTaxCollection2019.add(wageTaxReportBean);
        } else if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2018, 0, 1).getDate())) {
            this.mWageTaxCollection2018.add(wageTaxReportBean);
            this.mWageTaxCollection2018.clear();
        } else if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2009, 0, 1).getDate())) {
            this.mWageTaxCollection2009.clear();
            this.mWageTaxCollection2009.add(wageTaxReportBean);
        } else if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2007, 0, 1).getDate())) {
            this.mWageTaxCollection2007.clear();
            this.mWageTaxCollection2007.add(wageTaxReportBean);
        } else {
            this.mWageTaxCollection.clear();
            this.mWageTaxCollection.add(wageTaxReportBean);
        }
    }

    @Override
    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put("Parameter_User", this.mUserString);
        return parameters;
    }

    private BufferedWriter initNewFile() throws BusinessDomainException {
        int fileNum = 0;
        fileNum = this.mReportDataTransfer.getWageTaxFileNumber();
        OutputStreamWriter outSW = this.mReportDataTransfer.getOutputStreamWriter(fileNum);
        this.mEncoding = this.mReportDataTransfer.getEncodingNumeric(outSW.getEncoding());
        return new BufferedWriter(outSW);
    }

    private void perfidiaCreateFile() throws IOException {
        BufferedWriter dateiEinschreiben = null;
        try {
            dateiEinschreiben = this.initNewFile();
            String vorlaufInputString = this.writeLstAVorlaufSatz();
            dateiEinschreiben.write(vorlaufInputString);
            String LstACompanySatz = this.writeLstASatz();
            dateiEinschreiben.write(LstACompanySatz);
            String LstANachlaufSatz = this.writeLstANachlaufSatz();
            dateiEinschreiben.write(LstANachlaufSatz);
            dateiEinschreiben.close();
            this.mReportDataTransfer.setValue();
            this.mFileList = this.mFileList + this.mReportDataTransfer.getCreatedFilePath() + "\n";
            ++this.mFileListLength;
        }
        catch (RuntimeException t) {
            if (dateiEinschreiben != null) {
                dateiEinschreiben.close();
                this.mReportDataTransfer.getFFile().delete();
            }
            throw t;
        }
        catch (Exception t) {
            if (dateiEinschreiben != null) {
                dateiEinschreiben.close();
                this.mReportDataTransfer.getFFile().delete();
            }
            throw new IllegalStateException(t);
        }
    }

    private void addSumm() {
        this.FIELD_LSt = this.FIELD_LSt.add(this.mEWT.getFIELD_LSt());
        this.zeile18_2007 = this.zeile18_2007.add(this.mEWT.getFIELD_pausch_ohne37());
        this.FIELD_KG = this.FIELD_KG.add(this.mEWT.getFIELD_KG());
        this.FIELD_z_20 = this.FIELD_z_20.add(this.mEWT.getFIELD_pausch_nach37());
        this.FIELD_kuerzung_besatzungsmitglieder_handelschiffen = this.FIELD_kuerzung_besatzungsmitglieder_handelschiffen.add(this.mEWT.getFIELD_kuerz_besatz_handels());
        this.FIELD_foerderbetragBAV = this.FIELD_foerderbetragBAV.add(this.mEWT.getFIELD_foerderbetragBAV());
        this.FIELD_energiepreispauschale = this.FIELD_energiepreispauschale.add(this.mEWT.getFIELD_Energiepreispauschale());
        this.FIELD_verbleib = this.FIELD_verbleib.add(this.mEWT.getFIELD_verbleib());
        this.FIELD_SolZ = this.FIELD_SolZ.add(this.mEWT.getFIELD_SolZ());
        this.FIELD_gesamt = this.FIELD_gesamt.add(this.mEWT.getFIELD_gesamt());
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mEWT.getFIELD_foerderbetragBAV()) && !this.mWageTaxEmployeeBAVLi.contains(this.mEWT.getOidEmployee())) {
            this.mWageTaxEmployeeBAVLi.add(this.mEWT.getOidEmployee());
        }
        this.FIELD_z_24 = this.FIELD_z_24.add(this.mEWT.getFIELD_z_24());
        this.FIELD_z_25 = this.FIELD_z_25.add(this.mEWT.getFIELD_z_25());
        this.FIELD_z_26 = this.FIELD_z_26.add(this.mEWT.getFIELD_z_26());
        this.FIELD_z_27 = this.FIELD_z_27.add(this.mEWT.getFIELD_z_27());
        this.FIELD_z_28 = this.FIELD_z_28.add(this.mEWT.getFIELD_z_28());
        this.FIELD_z_29 = this.FIELD_z_29.add(this.mEWT.getFIELD_z_29());
        this.FIELD_z_30 = this.FIELD_z_30.add(this.mEWT.getFIELD_z_30());
        this.FIELD_z_31 = this.FIELD_z_31.add(this.mEWT.getFIELD_z_31());
        if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2007, 0, 1).getDate())) {
            this.FIELD_z_32 = this.FIELD_z_32.add(this.mEWT.getFIELD_z_32());
            this.FIELD_z_33 = this.FIELD_z_33.add(this.mEWT.getFIELD_z_33());
        }
    }

    private void setLStAFields() throws BusinessDomainException {
        this.FIELD_berichtigte_anmeldung = this.mBerichtigungEPP ? "1" : "";
        this.addPaymentFields();
        if (this.mPayment) {
            this.beginnPayment();
        }
        this.FIELD_anmeldezeitraum_monat_bez = this.mEWT.getAnmeldezeitraumMonatBez();
        this.FIELD_anmeldezeitraum_jahr_kurz = DateMapper.toYYYYString((Date)this.mForValidDate).substring(2, 4);
        this.FIELD_anmeldezeitraum_jahr_lang = DateMapper.toYYYYString((Date)this.mForValidDate);
        this.FIELD_anmeldezeitraum_monat_zahl = this.mEWT.getAnmeldezeitraumMonatZahl();
        this.FIELD_steuernummer = this.mEWT.getEmployerTaxNumber();
        this.FIELD_finanzamt_bezeichnung = this.mEWT.getEmployerTaxOfficeLongDescription();
        this.FIELD_finanzamt_strasse_nr = this.mEWT.getEmployerTaxOfficeStreetAndNumber();
        this.FIELD_finanzamt_plz_ort = this.mEWT.getEmployerTaxOfficePostalcodeAndCity();
        this.FIELD_pcompany_plant_key = this.mEWT.getEmployerKey();
        this.FIELD_arbeitgeber_bezeichnung = this.mEWT.getEmployerLongDescription();
        this.FIELD_arbeitgeber_strasse_nr = this.mEWT.getEmployerStreetAndNumber();
        this.FIELD_arbeitgeber_plz_ort = this.mEWT.getEmployerPostalcode() + " " + this.mEWT.getEmployerCity();
        this.FIELD_EmployerStateDescription = this.mEWT.getEmployerFederalStateLongDescription();
        List employeeList = (List)this.mEmployeePersonnelNumberHM.get(this.mEWT.getEmployerTaxNumber());
        this.FIELD_zahl_an = employeeList != null ? employeeList.size() : 0;
        this.FIELD_zahl_an_bav = this.mWageTaxEmployeeBAVLi.size();
        this.mWageTaxEmployeeBAVLi.clear();
        if (!this.mInternalUse && DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2019, 0, 1).getDate()) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_KG) && StringMapper.isNullString((String)this.mEWT.getEmployerFamilyFundKey())) {
            throw ReportExceptionMapper.makeFamilyfundkeyIsMissing();
        }
    }

    @Override
    protected void resetDataSumme() {
        this.FIELD_steuernummer = "";
        this.FIELD_anmeldezeitraum_monat_bez = "";
        this.mEmployerFinanzamtBezeichnung = "";
        this.FIELD_finanzamt_strasse_nr = "";
        this.FIELD_finanzamt_plz_ort = "";
        this.FIELD_arbeitgeber_bezeichnung = "";
        this.FIELD_arbeitgeber_strasse_nr = "";
        this.FIELD_arbeitgeber_plz_ort = "";
        this.FIELD_berichtigte_anmeldung = "";
        this.FIELD_anmeldezeitraum_jahr_kurz = "";
        this.FIELD_anmeldezeitraum_jahr_lang = "";
        this.FIELD_anmeldezeitraum_monat_zahl = "";
        this.FIELD_EmployerStateDescription = "";
        this.FIELD_LSt = BigDecimal.ZERO;
        this.zeile18_2007 = BigDecimal.ZERO;
        this.FIELD_KG = BigDecimal.ZERO;
        this.FIELD_z_20 = BigDecimal.ZERO;
        this.FIELD_kuerzung_besatzungsmitglieder_handelschiffen = BigDecimal.ZERO;
        this.FIELD_foerderbetragBAV = BigDecimal.ZERO;
        this.FIELD_energiepreispauschale = BigDecimal.ZERO;
        this.FIELD_verbleib = BigDecimal.ZERO;
        this.FIELD_SolZ = BigDecimal.ZERO;
        this.FIELD_z_24 = BigDecimal.ZERO;
        this.FIELD_z_25 = BigDecimal.ZERO;
        this.FIELD_z_26 = BigDecimal.ZERO;
        this.FIELD_z_27 = BigDecimal.ZERO;
        this.FIELD_z_28 = BigDecimal.ZERO;
        this.FIELD_z_29 = BigDecimal.ZERO;
        this.FIELD_z_30 = BigDecimal.ZERO;
        this.FIELD_z_31 = BigDecimal.ZERO;
        this.FIELD_z_32 = BigDecimal.ZERO;
        this.FIELD_z_33 = BigDecimal.ZERO;
        this.FIELD_gesamt = BigDecimal.ZERO;
    }

    private void makePayment() throws BusinessDomainException {
        WageTaxPayment wageTaxPayment = (WageTaxPayment)UtilitiesManager.getBean((String)"wageTaxPayment", WageTaxPayment.class);
        wageTaxPayment.setForValidDate(this.mForValidDate);
        wageTaxPayment.setMonatJahr(this.mField_monat_jahr);
        wageTaxPayment.setOidPCompany(this.mEWT.getOidPCompanyForSettings());
        wageTaxPayment.setName(this.mNameForPayment);
        wageTaxPayment.setWageTaxPaymenList(this.mWageTaxPaymentList);
        wageTaxPayment.startWorking();
    }

    @Override
    protected boolean isChangeBetweenBeans() {
        if (this.mEWTNext == null) {
            this.setErrorEmployeersList(this.mEWT.getOidPCompany());
            return true;
        }
        return !StringMapper.equal((String)(this.mEWT.getEmployerKey() + this.mEWT.getEmployerTaxNumber()), (String)(this.mEWTNext.getEmployerKey() + this.mEWTNext.getEmployerTaxNumber()));
    }

    private void resetPaymentFields() {
        this.mPaymentFIELD_LSt = BigDecimal.ZERO;
        this.mPaymentZeile18_2007 = BigDecimal.ZERO;
        this.mPaymentFIELD_KG = BigDecimal.ZERO;
        this.mPaymentFIELD_z_20 = BigDecimal.ZERO;
        this.mPaymentFIELD_kuerzung_besatzungsmitglieder_handelschiffen = BigDecimal.ZERO;
        this.mPaymentFIELD_foerderbetragBAV = BigDecimal.ZERO;
        this.mPaymentFIELD_energiepreispauschale = BigDecimal.ZERO;
        this.mPaymentFIELD_verbleib = BigDecimal.ZERO;
        this.mPaymentFIELD_SolZ = BigDecimal.ZERO;
        this.mPaymentFIELD_z_24 = BigDecimal.ZERO;
        this.mPaymentFIELD_z_25 = BigDecimal.ZERO;
        this.mPaymentFIELD_z_26 = BigDecimal.ZERO;
        this.mPaymentFIELD_z_27 = BigDecimal.ZERO;
        this.mPaymentFIELD_z_28 = BigDecimal.ZERO;
        this.mPaymentFIELD_z_29 = BigDecimal.ZERO;
        this.mPaymentFIELD_z_30 = BigDecimal.ZERO;
        this.mPaymentFIELD_z_31 = BigDecimal.ZERO;
        this.mPaymentFIELD_z_32 = BigDecimal.ZERO;
        this.mPaymentFIELD_z_33 = BigDecimal.ZERO;
        this.mPaymentFIELD_gesamt = BigDecimal.ZERO;
    }

    private void addPaymentFields() {
        this.mPaymentFIELD_LSt = this.mPaymentFIELD_LSt.add(this.FIELD_LSt);
        this.mPaymentZeile18_2007 = this.mPaymentZeile18_2007.add(this.zeile18_2007);
        this.mPaymentFIELD_KG = this.mPaymentFIELD_KG.add(this.FIELD_KG);
        this.mPaymentFIELD_z_20 = this.mPaymentFIELD_z_20.add(this.FIELD_z_20);
        this.mPaymentFIELD_kuerzung_besatzungsmitglieder_handelschiffen = this.mPaymentFIELD_kuerzung_besatzungsmitglieder_handelschiffen.add(this.FIELD_kuerzung_besatzungsmitglieder_handelschiffen);
        this.mPaymentFIELD_foerderbetragBAV = this.mPaymentFIELD_foerderbetragBAV.add(this.FIELD_foerderbetragBAV);
        this.mPaymentFIELD_energiepreispauschale = this.mPaymentFIELD_energiepreispauschale.add(this.FIELD_energiepreispauschale);
        this.mPaymentFIELD_verbleib = this.mPaymentFIELD_verbleib.add(this.FIELD_verbleib);
        this.mPaymentFIELD_SolZ = this.mPaymentFIELD_SolZ.add(this.FIELD_SolZ);
        this.mPaymentFIELD_z_24 = this.mPaymentFIELD_z_24.add(this.FIELD_z_24);
        this.mPaymentFIELD_z_25 = this.mPaymentFIELD_z_25.add(this.FIELD_z_25);
        this.mPaymentFIELD_z_26 = this.mPaymentFIELD_z_26.add(this.FIELD_z_26);
        this.mPaymentFIELD_z_27 = this.mPaymentFIELD_z_27.add(this.FIELD_z_27);
        this.mPaymentFIELD_z_28 = this.mPaymentFIELD_z_28.add(this.FIELD_z_28);
        this.mPaymentFIELD_z_29 = this.mPaymentFIELD_z_29.add(this.FIELD_z_29);
        this.mPaymentFIELD_z_30 = this.mPaymentFIELD_z_30.add(this.FIELD_z_30);
        this.mPaymentFIELD_z_31 = this.mPaymentFIELD_z_31.add(this.FIELD_z_31);
        this.mPaymentFIELD_z_32 = this.mPaymentFIELD_z_32.add(this.FIELD_z_32);
        this.mPaymentFIELD_z_33 = this.mPaymentFIELD_z_33.add(this.FIELD_z_33);
        this.mPaymentFIELD_gesamt = this.mPaymentFIELD_gesamt.add(this.FIELD_gesamt);
    }

    @Override
    public boolean next() throws JRException {
        try {
            this.resetDataSumme();
            if (this.mWageTaxEmployeesBeanLi.size() > 0) {
                while (this.getHasNext()) {
                    boolean leaveNaxt;
                    this.mEWT = this.mEWTNext;
                    this.mEWTNext = null;
                    if (this.mEmployeeWageTaxEFRit.hasNext()) {
                        this.mEWTNext = (WageTaxEmployeeBean)((Object)this.mEmployeeWageTaxEFRit.next());
                    }
                    if (leaveNaxt = this.isChangeBetweenBeans()) {
                        this.addSumm();
                        this.setLStAFields();
                        if (this.mUsePerfidia) {
                            this.perfidiaCreateFile();
                        }
                        this.createCollectionBean();
                        return true;
                    }
                    this.addSumm();
                }
                if (this.mFileListLength > 0) {
                    this.setException("Es wurden " + this.mFileListLength + " Dateien erzeugt und nach Perfidia \u00fcbergeben.(siehe Details)", "Folgende Dateien wurden erzeugt:\n" + this.mFileList);
                }
                if (this.mPayment && !this.mWageTaxPaymentList.isEmpty()) {
                    this.makePayment();
                }
            } else if (this.mErrorReportFactory.isFilled()) {
                this.setErrorEmployeersList();
                this.mErrorReportFactory.reset();
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
    }

    private void beginnPayment() throws BusinessDomainException {
        if (BigDecimalMapper.compareTo((BigDecimal)this.mPaymentFIELD_gesamt, (BigDecimal)BigDecimal.ZERO) > 0) {
            BigDecimal kiSt = this.mPaymentFIELD_z_24.add(this.mPaymentFIELD_z_25).add(this.mPaymentFIELD_z_26).add(this.mPaymentFIELD_z_27).add(this.mPaymentFIELD_z_28).add(this.mPaymentFIELD_z_29).add(this.mPaymentFIELD_z_30).add(this.mPaymentFIELD_z_31).add(this.mPaymentFIELD_z_32).add(this.mPaymentFIELD_z_33);
            BigDecimal lst = this.mPaymentFIELD_LSt.add(this.mPaymentZeile18_2007);
            BigDecimal solz = this.mPaymentFIELD_SolZ;
            BigDecimal gesamt = this.mPaymentFIELD_gesamt;
            CompanyAccountTP standardBankAccountTP = CompanyAccount.getStandardBankAccountTP((String)this.mEePCompany.getObjectid(), (Date)this.mForEffectiveDate, (Date)this.mForValidDate);
            WageTaxHelper wageTaxHelper = (WageTaxHelper)UtilitiesManager.getBean((String)"wageTaxHelper", WageTaxHelper.class);
            WageTaxPaymentBean wageTaxPaymentBean = wageTaxHelper.getWageTaxPaymentBean(this.mEWT, standardBankAccountTP, this.mForEffectiveDate, this.mForValidDate, lst, solz, kiSt, gesamt, this.mReportValues);
            if (wageTaxPaymentBean != null) {
                this.mWageTaxPaymentList.add(wageTaxPaymentBean);
            }
        }
        this.resetPaymentFields();
    }

    @Override
    public Object getFieldValue(JRField field) throws JRException {
        String fieldName = field.getName();
        if (fieldName.equals("subreport_wage_tax_bean_2006")) {
            if (this.mWageTaxCollection != null) {
                this.mAnzahlLStA += this.mWageTaxCollection.size();
            }
            return this.mWageTaxCollection;
        }
        if (fieldName.equals("subreport_wage_tax_bean_2007")) {
            if (this.mWageTaxCollection != null) {
                this.mAnzahlLStA += this.mWageTaxCollection2007.size();
            }
            return this.mWageTaxCollection2007;
        }
        if (fieldName.equals("subreport_wage_tax_bean_2009")) {
            if (this.mWageTaxCollection != null) {
                this.mAnzahlLStA += this.mWageTaxCollection2009.size();
            }
            return this.mWageTaxCollection2009;
        }
        if (fieldName.equals("subreport_wage_tax_bean_2018")) {
            if (this.mWageTaxCollection != null) {
                this.mAnzahlLStA += this.mWageTaxCollection2018.size();
            }
            return this.mWageTaxCollection2018;
        }
        if (fieldName.equals("subreport_wage_tax_bean_2019")) {
            if (DateHelper.before((Date)this.mVersatzMonat, (Date)new VDate(2022, 7, 1).getDate())) {
                if (this.mWageTaxCollection != null) {
                    this.mAnzahlLStA += this.mWageTaxCollection2019.size();
                }
                return this.mWageTaxCollection2019;
            }
            return new LinkedList();
        }
        if (fieldName.equals("subreport_wage_tax_bean_2022")) {
            if (DateHelper.afterOrEqual((Date)this.mVersatzMonat, (Date)new VDate(2022, 7, 1).getDate())) {
                if (this.mWageTaxCollection != null) {
                    this.mAnzahlLStA += this.mWageTaxCollection2019.size();
                }
                return this.mWageTaxCollection2019;
            }
            return new LinkedList();
        }
        if (fieldName.equals("subreport_error_employer_bean")) {
            return this.mWageTaxErrorLi;
        }
        return null;
    }
}

