/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.statementofearnings;

import com.infor.igf.core.util.StringUtil;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.pcompany.settings.CorrectionEnum;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.statementofearnings.StatementOfEarningsCache;
import com.varial.personnel.domain.reports.statementofearnings.StatementOfEarningsQueries;
import com.varial.personnel.domain.reports.statementofearnings.StatementOfEarningsReportDataSource;
import com.varial.personnel.domain.reports.statementofearnings.beans.StatementOfEarningsResultBean;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.typeofvalue.ValueTypeTP;
import com.varial.personnel.domain.typeofvalue.basictypes.CompressionEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.FontEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.PrintEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.Truncation;
import com.varial.personnel.domain.typeofvalue.basictypes.TruncationEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.TruncationScaleEnum;
import com.varial.personnel.isoft.domain.reports.statementofearnings.StatementOfEarningsIndividual;
import com.varial.personnel.persistency.typeofValue.valuetypesall.ValuetypesallContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class StatementOfEarningsValuePositionDataSource
implements JRDataSource {
    private final StatementOfEarningsReportDataSource mMainDataSource;
    private final Iterator<StatementOfEarningsResultBean> mVPIterator;
    private final StatementOfEarningsCache mCache;
    private final StatementOfEarningsQueries mQueries;
    private final Date mForEffectiveDate;
    private final Date mForValidDate;
    private final Date mBeginMonthDate;
    private final Date mEndMonthDate;
    private final Date mReturnCalculationDate;
    private final boolean mChangeDescription;
    private final String FIELD_RUECKFRAGEN_AN;
    private final boolean mReturnCalculation;
    private final CorrectionEnum mCorrectionsoe;
    private String FIELD_WERTARTNR;
    private String FIELD_BEZEICHNUNG;
    private String FIELD_BESCHREIBUNG;
    private String FIELD_BRUTTO_EINORDNUNG;
    private String FIELD_STEUER_EINORDNUNG;
    private String FIELD_SV_EINORDNUNG;
    private String FIELD_KST;
    private String FIELD_JAHRESMENGE;
    private String FIELD_FAKTOR1;
    private BigDecimal FIELD_FAKTOR2;
    private String FIELD_PROZENTSATZ;
    private BigDecimal FIELD_JAHRESBETRAG;
    private BigDecimal FIELD_RESULTAT;
    private String FIELD_RECHENZEICHEN;
    private FontEnum FIELD_FONT_TYPE;
    private String FIELD_BEZ_KST;
    private String FIELD_FELD1;
    private String FIELD_FELD2;
    private String FIELD_FELD3;
    private String FIELD_FELD4;
    private String FIELD_FELD5;
    private String FIELD_JAHR;
    private int x = 0;
    private int y = -1;
    private int z = 0;
    private Date mTempValidUntil;
    private String mTempOidVT = "000000";

    public StatementOfEarningsValuePositionDataSource(StatementOfEarningsReportDataSource mainDataSource, Iterator<StatementOfEarningsResultBean> vpIterator) {
        this.mMainDataSource = mainDataSource;
        this.mCache = mainDataSource.mCache;
        this.mQueries = mainDataSource.mQueries;
        this.mForEffectiveDate = mainDataSource.mForEffectiveDate;
        this.mForValidDate = mainDataSource.mForValidDate;
        this.mBeginMonthDate = mainDataSource.mBeginMonthDate;
        this.mEndMonthDate = mainDataSource.mEndMonthDate;
        this.mChangeDescription = mainDataSource.mChangeDescription;
        this.FIELD_RUECKFRAGEN_AN = mainDataSource.FIELD_RUECKFRAGEN_AN;
        this.mReturnCalculationDate = mainDataSource.mReturnCalculationDate;
        this.mReturnCalculation = mainDataSource.mReturnCalculation;
        this.mCorrectionsoe = mainDataSource.mCorrectionsoe;
        this.mVPIterator = vpIterator;
        if (mainDataSource.mCorrectionsoe == CorrectionEnum.CE_KORREKTUR_VERDIENSTNACHWEISE_EINZEILIG && mainDataSource.mReturnCalculation) {
            this.FIELD_FELD1 = "Faktor";
            this.FIELD_FELD2 = "Storno Betrag";
            this.FIELD_FELD3 = "Neu Betrag";
            this.FIELD_FELD4 = "Storno Menge";
            this.FIELD_FELD5 = "Neu Menge";
        } else {
            this.FIELD_FELD1 = "Faktor";
            this.FIELD_FELD2 = "Betrag " + StatementOfEarningsReportDataSource.toYYYY((Date)this.mEndMonthDate);
            this.FIELD_FELD3 = "Betrag";
            this.FIELD_FELD4 = "Menge " + StatementOfEarningsReportDataSource.toYYYY((Date)this.mEndMonthDate);
            this.FIELD_FELD5 = "Menge";
        }
    }

    public boolean next() throws JRException {
        ++this.x;
        this.FIELD_FONT_TYPE = FontEnum.FE_normal;
        this.FIELD_PROZENTSATZ = "";
        if (this.x == 1) {
            this.y = -1;
            this.z = 0;
            this.mTempValidUntil = VDate.getDateMax();
            this.FIELD_WERTARTNR = "";
            this.FIELD_BEZEICHNUNG = "Abrechnung " + StatementOfEarningsReportDataSource.toMMdotYYYY((Date)this.mEndMonthDate);
            this.FIELD_BESCHREIBUNG = "";
            this.FIELD_JAHR = StatementOfEarningsReportDataSource.toYYYY((Date)this.mEndMonthDate);
            this.FIELD_BEZ_KST = "KSt";
            this.FIELD_BRUTTO_EINORDNUNG = "";
            this.FIELD_STEUER_EINORDNUNG = "";
            this.FIELD_SV_EINORDNUNG = "";
            this.FIELD_FAKTOR1 = "";
            this.FIELD_FAKTOR2 = null;
            this.FIELD_RESULTAT = null;
            this.FIELD_JAHRESBETRAG = null;
            this.FIELD_JAHRESMENGE = "";
            this.FIELD_PROZENTSATZ = "";
            this.FIELD_KST = "";
            this.FIELD_RECHENZEICHEN = "";
            this.FIELD_FONT_TYPE = FontEnum.FE_normal_fett;
            return true;
        }
        if (!this.mVPIterator.hasNext() && this.y + 1 <= this.x) {
            return false;
        }
        try {
            StatementOfEarningsResultBean soeResultBean = new StatementOfEarningsResultBean();
            soeResultBean.setValidUntil(VDate.getDateMax());
            if (this.mVPIterator.hasNext() || this.y + 1 > this.x) {
                BigDecimal sumResult = null;
                BigDecimal sumFactor1 = null;
                if (this.y + 1 <= this.x) {
                    soeResultBean = this.mVPIterator.next();
                    sumResult = StatementOfEarningsReportDataSource.ZERO_CURRENCY;
                    sumFactor1 = StatementOfEarningsReportDataSource.ZERO_CURRENCY;
                }
                if (DateHelper.before((Date)soeResultBean.getValidUntil(), (Date)this.mBeginMonthDate) && DateHelper.before((Date)soeResultBean.getValidUntil(), (Date)this.mTempValidUntil) && this.mCorrectionsoe == CorrectionEnum.CE_KORREKTUR_ZUSAMMENFASSUNG) {
                    this.y = this.x + 2;
                    this.z = 1;
                    this.FIELD_WERTARTNR = "";
                    this.FIELD_BEZEICHNUNG = "";
                    this.FIELD_BESCHREIBUNG = "";
                    this.FIELD_FAKTOR1 = "";
                    this.FIELD_FAKTOR2 = null;
                    this.FIELD_RESULTAT = null;
                    this.FIELD_JAHRESBETRAG = null;
                    this.FIELD_JAHRESMENGE = "";
                    this.FIELD_PROZENTSATZ = "";
                    this.FIELD_KST = "";
                    this.FIELD_RECHENZEICHEN = "";
                    this.FIELD_BRUTTO_EINORDNUNG = "";
                    this.FIELD_STEUER_EINORDNUNG = "";
                    this.FIELD_SV_EINORDNUNG = "";
                }
                if (this.z == 1 && this.y - this.x == 1 && soeResultBean.getValidFrom() != null) {
                    this.FIELD_WERTARTNR = "";
                    this.FIELD_BEZEICHNUNG = "R\u00fcckrechnung " + StatementOfEarningsReportDataSource.toMMdotYYYY((Date)soeResultBean.getValidFrom());
                    this.FIELD_BESCHREIBUNG = "";
                    this.FIELD_JAHR = StatementOfEarningsReportDataSource.toYYYY((Date)soeResultBean.getValidFrom());
                    this.FIELD_BEZ_KST = "";
                    this.FIELD_FONT_TYPE = FontEnum.FE_normal_fett;
                    this.FIELD_BRUTTO_EINORDNUNG = "";
                    this.FIELD_STEUER_EINORDNUNG = "";
                    this.FIELD_SV_EINORDNUNG = "";
                }
                if (this.y <= this.x) {
                    if (soeResultBean.getValueTypeNumber() >= 0) {
                        String factorDes;
                        this.FIELD_KST = "";
                        this.FIELD_FAKTOR1 = "";
                        this.FIELD_FAKTOR2 = null;
                        this.FIELD_JAHRESMENGE = "";
                        this.FIELD_JAHRESBETRAG = null;
                        this.FIELD_PROZENTSATZ = "";
                        this.FIELD_FONT_TYPE = soeResultBean.getFontOnSoe();
                        this.FIELD_WERTARTNR = "";
                        this.FIELD_BEZEICHNUNG = "";
                        this.FIELD_BESCHREIBUNG = "";
                        this.FIELD_BRUTTO_EINORDNUNG = "";
                        this.FIELD_STEUER_EINORDNUNG = "";
                        this.FIELD_SV_EINORDNUNG = "";
                        if (soeResultBean.getValueTypeNumber() != 0 && soeResultBean.isPrintDescription()) {
                            this.FIELD_WERTARTNR = Integer.toString(soeResultBean.getValueTypeNumber());
                            this.FIELD_BESCHREIBUNG = soeResultBean.getDescription();
                            if (soeResultBean.getValueTypeNumber() > 100000) {
                                this.FIELD_BEZEICHNUNG = this.mChangeDescription ? this.getChangeDescription(soeResultBean.getValueTypeNumber()) : soeResultBean.getShortDescription();
                            } else {
                                this.FIELD_BEZEICHNUNG = soeResultBean.getCompressionOnSoe() == CompressionEnum.COME_Verdichtung_auf_Wertartengruppe || soeResultBean.getIsInfo() || this.isReportVersionKnott() ? soeResultBean.getShortDescription() : Integer.toString(soeResultBean.getValueTypeNumber()) + " " + soeResultBean.getShortDescription();
                                if (!soeResultBean.getIsInfo()) {
                                    this.FIELD_BRUTTO_EINORDNUNG = soeResultBean.getBruttoEinordnung();
                                    this.FIELD_STEUER_EINORDNUNG = soeResultBean.getSteuerEinordnung();
                                    this.FIELD_SV_EINORDNUNG = soeResultBean.getSvEinordnung();
                                }
                            }
                        }
                        if (this.mReturnCalculation) {
                            if (soeResultBean.getValueTypeNumber() != 882110) {
                                if (!(soeResultBean.getPrintOnSoEFactor2() != PrintEnum.PE_Monatswert_und_Jahreswert && soeResultBean.getPrintOnSoEFactor2() != PrintEnum.PE_nur_Monatswert || BigDecimalMapper.isZeroOrNull((BigDecimal)soeResultBean.getFactor2()))) {
                                    this.FIELD_FAKTOR2 = this.getTruncationFactor2(soeResultBean.getOidValueType(), soeResultBean.getFactor2());
                                }
                                if (this.mCorrectionsoe != CorrectionEnum.CE_KORREKTUR_VERDIENSTNACHWEISE_EINZEILIG) {
                                    this.FIELD_KST = soeResultBean.getParentname();
                                }
                                if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)soeResultBean.getFactor1()) || soeResultBean.getPrintOnSoEFactor1() != PrintEnum.PE_Monatswert_und_Jahreswert && soeResultBean.getPrintOnSoEFactor1() != PrintEnum.PE_nur_Monatswert)) {
                                    factorDes = this.getFactor1Einheit(soeResultBean);
                                    BigDecimal faktor1 = soeResultBean.getValueTypeNumber() < 100000 && soeResultBean.getValueTypeNumber() > 0 ? this.getTruncationFactor1(soeResultBean.getOidValueType(), soeResultBean.getFactor1()) : soeResultBean.getFactor1().setScale(2, RoundingMode.HALF_UP);
                                    this.FIELD_FAKTOR1 = StatementOfEarningsValuePositionDataSource.toString(faktor1) + " " + factorDes;
                                }
                                if (this.printPercentageOnSOE(soeResultBean.getValueTypeNumber())) {
                                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)soeResultBean.getPercentage())) {
                                        this.FIELD_PROZENTSATZ = soeResultBean.getValueTypeNumber() < 100000 ? StatementOfEarningsReportDataSource.toPercent((BigDecimal)soeResultBean.getPercentage(), (int)3) : StatementOfEarningsReportDataSource.toPercent((BigDecimal)soeResultBean.getPercentage(), (int)4);
                                    } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)soeResultBean.getPerformfactor())) {
                                        this.FIELD_PROZENTSATZ = StatementOfEarningsReportDataSource.toPercent((BigDecimal)soeResultBean.getPerformfactor(), (int)5);
                                    }
                                }
                            }
                        } else {
                            if ((soeResultBean.getPercentage() != null || soeResultBean.getPerformfactor() != null) && this.printPercentageOnSOE(soeResultBean.getValueTypeNumber())) {
                                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)soeResultBean.getPercentage())) {
                                    this.FIELD_PROZENTSATZ = soeResultBean.getValueTypeNumber() < 100000 ? StatementOfEarningsReportDataSource.toPercent((BigDecimal)soeResultBean.getPercentage(), (int)3) : StatementOfEarningsReportDataSource.toPercent((BigDecimal)soeResultBean.getPercentage(), (int)4);
                                } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)soeResultBean.getPerformfactor())) {
                                    this.FIELD_PROZENTSATZ = StatementOfEarningsReportDataSource.toPercent((BigDecimal)soeResultBean.getPerformfactor(), (int)5);
                                }
                            }
                            if (soeResultBean.getValueTypeNumber() < 100000 && !StringMapper.isNullString((String)soeResultBean.getOidCostCenter())) {
                                this.FIELD_KST = this.mQueries.queryCostCenterAllContainer((String)soeResultBean.getOidCostCenter(), (Date)this.mForValidDate, (Date)this.mForValidDate).costcenterkey;
                            }
                            if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)soeResultBean.getFactor1()) || soeResultBean.getPrintOnSoEFactor1() != PrintEnum.PE_Monatswert_und_Jahreswert && soeResultBean.getPrintOnSoEFactor1() != PrintEnum.PE_nur_Monatswert)) {
                                factorDes = this.getFactor1Einheit(soeResultBean);
                                BigDecimal factor1 = soeResultBean.getValueTypeNumber() < 100000 && soeResultBean.getValueTypeNumber() > 0 ? this.getTruncationFactor1(soeResultBean.getOidValueType(), soeResultBean.getFactor1()) : soeResultBean.getFactor1().setScale(2, RoundingMode.HALF_UP);
                                this.FIELD_FAKTOR1 = StatementOfEarningsValuePositionDataSource.toString(factor1) + " " + factorDes;
                            }
                            if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)soeResultBean.getFactor2()) || soeResultBean.getPrintOnSoEFactor2() != PrintEnum.PE_Monatswert_und_Jahreswert && soeResultBean.getPrintOnSoEFactor2() != PrintEnum.PE_nur_Monatswert)) {
                                this.FIELD_FAKTOR2 = this.getTruncationFactor2(soeResultBean.getOidValueType(), soeResultBean.getFactor2());
                            }
                            if (soeResultBean.getPrintOnSoEResult() == PrintEnum.PE_Monatswert_und_Jahreswert || soeResultBean.getPrintOnSoEResult() == PrintEnum.PE_nur_Jahreswert || soeResultBean.getPrintOnSoEFactor1() == PrintEnum.PE_Monatswert_und_Jahreswert || soeResultBean.getPrintOnSoEFactor1() == PrintEnum.PE_nur_Jahreswert) {
                                if (StringMapper.compareTo((String)this.mTempOidVT, (String)soeResultBean.getOidValueType()) != 0) {
                                    sumResult = soeResultBean.getSumResult();
                                    sumFactor1 = soeResultBean.getSumFactor1();
                                }
                                this.mTempOidVT = soeResultBean.getOidValueType();
                            }
                            if (this.z == 0) {
                                if (!(soeResultBean.getPrintOnSoEFactor1() != PrintEnum.PE_Monatswert_und_Jahreswert && soeResultBean.getPrintOnSoEFactor1() != PrintEnum.PE_nur_Jahreswert || BigDecimalMapper.isZeroOrNull((BigDecimal)sumFactor1))) {
                                    factorDes = this.getFactor1Einheit(soeResultBean);
                                    BigDecimal jahresmenge = soeResultBean.getValueTypeNumber() < 100000 ? this.getTruncationFactor1(soeResultBean.getOidValueType(), sumFactor1) : sumFactor1.setScale(2, RoundingMode.HALF_UP);
                                    this.FIELD_JAHRESMENGE = StatementOfEarningsValuePositionDataSource.toString(jahresmenge) + " " + factorDes;
                                }
                                if (!(soeResultBean.getPrintOnSoEResult() != PrintEnum.PE_Monatswert_und_Jahreswert && soeResultBean.getPrintOnSoEResult() != PrintEnum.PE_nur_Jahreswert || BigDecimalMapper.isZeroOrNull((BigDecimal)sumResult))) {
                                    this.FIELD_JAHRESBETRAG = sumResult;
                                }
                            }
                        }
                        if (soeResultBean.getPrintOnSoEResult() == PrintEnum.PE_Monatswert_und_Jahreswert || soeResultBean.getPrintOnSoEResult() == PrintEnum.PE_nur_Monatswert) {
                            this.FIELD_RESULTAT = soeResultBean.getResult();
                            if (soeResultBean.isRC()) {
                                this.FIELD_JAHRESBETRAG = soeResultBean.getSumResult();
                                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)soeResultBean.getSumFactor1())) {
                                    factorDes = this.getFactor1Einheit(soeResultBean);
                                    this.FIELD_JAHRESMENGE = BigDecimalMapper.isZeroOrNull((BigDecimal)soeResultBean.getSumFactor1()) ? "" : StatementOfEarningsValuePositionDataSource.toString(soeResultBean.getSumFactor1(), 2) + " " + factorDes;
                                }
                            }
                        } else {
                            this.FIELD_RESULTAT = soeResultBean.getValueTypeNumber() == 882000 ? soeResultBean.getResult() : null;
                        }
                        this.FIELD_RECHENZEICHEN = soeResultBean.getRechenzeichen();
                    } else if (soeResultBean.getValueTypeNumber() == -1) {
                        String endeRR = StatementOfEarningsReportDataSource.toMMdotYYYY((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate)));
                        String anfangRR = StatementOfEarningsReportDataSource.toMMdotYYYY((Date)DateHelper.getFirstDayOfMonth((Date)this.mReturnCalculationDate));
                        this.FIELD_BEZEICHNUNG = "R\u00fcckrechnung  " + anfangRR + " - " + endeRR;
                        this.FIELD_BRUTTO_EINORDNUNG = "";
                        this.FIELD_STEUER_EINORDNUNG = "";
                        this.FIELD_SV_EINORDNUNG = "";
                        this.FIELD_KST = "";
                        this.FIELD_JAHRESMENGE = "";
                        this.FIELD_FAKTOR1 = "";
                        this.FIELD_FAKTOR2 = null;
                        this.FIELD_JAHRESBETRAG = null;
                        this.FIELD_PROZENTSATZ = "";
                        this.FIELD_RESULTAT = null;
                        this.FIELD_RECHENZEICHEN = "";
                        this.FIELD_FONT_TYPE = FontEnum.FE_normal_fett;
                    }
                }
            }
            this.mTempValidUntil = soeResultBean.getValidUntil();
        }
        catch (BusinessDomainException e) {
            throw new JRException((Throwable)e);
        }
        return true;
    }

    private boolean printPercentageOnSOE(int valueTypeNumber) {
        return valueTypeNumber >= 300000 || valueTypeNumber < 100000 || valueTypeNumber == 151020 || valueTypeNumber == 151120 || valueTypeNumber == 230510 || valueTypeNumber == 230520;
    }

    private boolean isReportVersionKnott() {
        return ReportHelper.isReportVersionKnott((String)this.mMainDataSource.mReportVersion);
    }

    private String getChangeDescription(int valueTypeNumber) {
        try {
            return this.mCache.getValueTypeFoundationsByNumber(StatementOfEarningsValuePositionDataSource.getChangeDescriptionValueTypeNumber(valueTypeNumber)).getGeneral().getShortDescription();
        }
        catch (BusinessDomainException | RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static int getChangeDescriptionValueTypeNumber(int valueTypeNumber) {
        switch (valueTypeNumber) {
            case 110620: {
                return 110610;
            }
            case 220620: {
                return 220610;
            }
            case 223620: {
                return 223610;
            }
            case 226620: {
                return 226610;
            }
            case 227620: {
                return 227610;
            }
        }
        return valueTypeNumber;
    }

    private BigDecimal getTruncationFactor1(String oidValueType, BigDecimal factor1) throws BusinessDomainException {
        ValueTypeTP vttp;
        Truncation truncation;
        BigDecimal tempFactor1 = factor1;
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)tempFactor1) && (truncation = (vttp = ValueType.getValueType((String)oidValueType).getValueTypeTP(this.mForEffectiveDate, this.mForValidDate)).getFactor1().getAssignment().getTruncation()).getTruncation() != TruncationEnum.BTE_noRounding) {
            tempFactor1 = truncation.round(tempFactor1);
            tempFactor1 = StatementOfEarningsValuePositionDataSource.setScaleFromTruncation(tempFactor1, truncation.getTruncationScale());
        }
        return tempFactor1;
    }

    private BigDecimal getTruncationFactor2(String oidValueType, BigDecimal factor2) throws BusinessDomainException {
        ValueTypeTP vttp;
        Truncation truncation;
        BigDecimal tempFactor2 = factor2;
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)tempFactor2) && (truncation = (vttp = ValueType.getValueType((String)oidValueType).getValueTypeTP(this.mForEffectiveDate, this.mForValidDate)).getFactor2().getAssignment().getTruncation()).getTruncation() != TruncationEnum.BTE_noRounding) {
            tempFactor2 = truncation.round(tempFactor2);
            tempFactor2 = StatementOfEarningsValuePositionDataSource.setScaleFromTruncation(tempFactor2, truncation.getTruncationScale());
        }
        return tempFactor2;
    }

    private static BigDecimal setScaleFromTruncation(BigDecimal toRound, TruncationScaleEnum truncationScaleEnum) {
        if (toRound == null) {
            return null;
        }
        switch (truncationScaleEnum.value()) {
            case 0: {
                return StatementOfEarningsValuePositionDataSource.roundBeforeDecimalPoint(toRound, 6);
            }
            case 1: {
                return StatementOfEarningsValuePositionDataSource.roundBeforeDecimalPoint(toRound, 5);
            }
            case 2: {
                return StatementOfEarningsValuePositionDataSource.roundBeforeDecimalPoint(toRound, 4);
            }
            case 3: {
                return StatementOfEarningsValuePositionDataSource.roundBeforeDecimalPoint(toRound, 3);
            }
            case 4: {
                return StatementOfEarningsValuePositionDataSource.roundBeforeDecimalPoint(toRound, 2);
            }
            case 5: {
                return StatementOfEarningsValuePositionDataSource.roundBeforeDecimalPoint(toRound, 1);
            }
            case 6: {
                return StatementOfEarningsValuePositionDataSource.roundAfterDecimalPoint(toRound, 1);
            }
            case 7: {
                return StatementOfEarningsValuePositionDataSource.roundAfterDecimalPoint(toRound, 2);
            }
            case 8: {
                return StatementOfEarningsValuePositionDataSource.roundAfterDecimalPoint(toRound, 3);
            }
            case 9: {
                return StatementOfEarningsValuePositionDataSource.roundAfterDecimalPoint(toRound, 4);
            }
            case 10: {
                return StatementOfEarningsValuePositionDataSource.roundAfterDecimalPoint(toRound, 5);
            }
            case 11: {
                return StatementOfEarningsValuePositionDataSource.roundAfterDecimalPoint(toRound, 6);
            }
        }
        return toRound;
    }

    private static BigDecimal roundBeforeDecimalPoint(BigDecimal toRound, int position) {
        toRound = toRound.movePointLeft(position - 1);
        toRound = toRound.divide(BigDecimal.ONE, 0, RoundingMode.HALF_UP);
        return toRound.movePointRight(position - 1);
    }

    private static BigDecimal roundAfterDecimalPoint(BigDecimal toRound, int position) {
        return toRound.setScale(position, RoundingMode.HALF_UP);
    }

    private String getFactor1Einheit(StatementOfEarningsResultBean soeResultBean) {
        ValuetypesallContainer valueType = this.mCache.getValueTypeAllContainer(soeResultBean.getOidValueType());
        String valueTypeCoefficientShortDescription = valueType == null ? "" : StatementOfEarningsReportDataSource.toStringMaxLength((String)this.mCache.getVTCoefficientContainerShortDescription(valueType.oidfactor1), (int)4);
        return valueTypeCoefficientShortDescription;
    }

    private Object getFieldValue(String fieldName) {
        switch (fieldName) {
            case "wertartnr": {
                return this.FIELD_WERTARTNR;
            }
            case "bezeichnung": {
                if (!StringMapper.isNullString((String)this.FIELD_BEZEICHNUNG)) {
                    if (this.FIELD_BEZEICHNUNG.length() > 1 && this.FIELD_BEZEICHNUNG.substring(0, 2).equals("* ")) {
                        this.FIELD_BEZEICHNUNG = this.FIELD_BEZEICHNUNG.substring(2, this.FIELD_BEZEICHNUNG.length());
                    } else if (this.FIELD_BEZEICHNUNG.substring(0, 1).equals("*")) {
                        this.FIELD_BEZEICHNUNG = this.FIELD_BEZEICHNUNG.substring(1, this.FIELD_BEZEICHNUNG.length());
                    }
                }
                return this.FIELD_BEZEICHNUNG;
            }
            case "beschreibung": {
                return this.FIELD_BESCHREIBUNG;
            }
            case "brutto_einordnung": {
                return this.FIELD_BRUTTO_EINORDNUNG;
            }
            case "steuer_einordnung": {
                return this.FIELD_STEUER_EINORDNUNG;
            }
            case "sv_einordnung": {
                return this.FIELD_SV_EINORDNUNG;
            }
            case "kst": {
                return this.FIELD_KST;
            }
            case "jahresmenge": {
                return this.FIELD_JAHRESMENGE;
            }
            case "faktor1": {
                return this.FIELD_FAKTOR1;
            }
            case "faktor2": {
                return this.FIELD_FAKTOR2;
            }
            case "prozentsatz": {
                return this.FIELD_PROZENTSATZ;
            }
            case "jahresbetrag": {
                return this.FIELD_JAHRESBETRAG;
            }
            case "resultat": {
                return this.FIELD_RESULTAT;
            }
            case "rechenzeichen": {
                return this.FIELD_RECHENZEICHEN;
            }
            case "bez_kst": {
                return this.FIELD_BEZ_KST;
            }
            case "feld1": {
                return this.FIELD_FELD1;
            }
            case "feld2": {
                return this.FIELD_FELD2;
            }
            case "feld3": {
                return this.FIELD_FELD3;
            }
            case "feld4": {
                return this.FIELD_FELD4;
            }
            case "feld5": {
                return this.FIELD_FELD5;
            }
            case "jahr": {
                return this.FIELD_JAHR;
            }
            case "font_normal": {
                return this.FIELD_FONT_TYPE == FontEnum.FE_normal;
            }
            case "font_bold": {
                return this.FIELD_FONT_TYPE == FontEnum.FE_normal_fett;
            }
            case "font_italic": {
                return this.FIELD_FONT_TYPE == FontEnum.FE_kursiv;
            }
            case "font_italic_bold": {
                return this.FIELD_FONT_TYPE == FontEnum.FE_kursive_fett;
            }
            case "rueckfragen_an": {
                return this.FIELD_RUECKFRAGEN_AN;
            }
        }
        return null;
    }

    public Object getFieldValue(JRField field) throws JRException {
        String fieldName = field.getName();
        Object value = this.getFieldValue(fieldName);
        if (value instanceof BigDecimal) {
            value = StatementOfEarningsReportDataSource.toCurrencyFormat((Object)value);
        }
        if (value instanceof String) {
            value = StringUtil.toJasperString((String)((String)value));
        }
        return value;
    }

    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2011, 0, 1).getDate())) {
            parameters.put("text_entgeltbescheinigung", "Diese Bescheinigung erf\u00fcllt die Anforderungen des \u00a7 108 Abs. 3 Satz 1 der Gewerbeordnung (GewO).");
        }
        StatementOfEarningsIndividual.modifyValuePositionParameters((Map)parameters);
        return parameters;
    }

    private static String toString(BigDecimal bigDecimal) {
        return StatementOfEarningsReportDataSource.toString((BigDecimal)bigDecimal);
    }

    private static String toString(BigDecimal bigDecimal, int scale) {
        return StatementOfEarningsReportDataSource.toString((BigDecimal)bigDecimal, (int)scale);
    }
}

