/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.rvbea.receive;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.rvbea.dxar.RvbeaDxar;
import com.varial.serverbase.basictypes.VDate;
import com.varial.shared.Version;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.JRException;

public class RvbeaReceiveRequestsReportDataSource {
    private static String receiveString = "\u00dcbernahme \r\nAnforderungen rvBEA";
    private static String createString = "Erstellung \r\nBescheinigung/ Hinderungsgrund rvBEA";
    private final Iterator<RvbeaDxar> mIterator;
    private final DEUVSender mSender;
    private RvbeaDxar mDxar;
    private boolean mDxebCreated;
    private boolean mPrintEmptyReportMessage;

    public RvbeaReceiveRequestsReportDataSource(List<RvbeaDxar> dxars, DEUVSender sender) {
        this.mSender = sender;
        this.mIterator = dxars.iterator();
        this.setDxebCreated(dxars);
        this.mPrintEmptyReportMessage = !this.mIterator.hasNext();
    }

    public boolean next() throws JRException {
        boolean hasNext = this.mIterator.hasNext();
        try {
            if (hasNext) {
                this.mDxar = this.mIterator.next();
            } else {
                if (this.mPrintEmptyReportMessage) {
                    hasNext = true;
                    this.mPrintEmptyReportMessage = false;
                }
                this.mDxar = null;
            }
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
        return hasNext;
    }

    private void setDxebCreated(List<RvbeaDxar> dxars) {
        for (RvbeaDxar rvbeaDxar : dxars) {
            if (rvbeaDxar.getRvbeaDxeb() == null) continue;
            this.mDxebCreated = true;
            break;
        }
    }

    public RvbeaDxar getDxar() {
        return this.mDxar;
    }

    public boolean isDxebCreated() {
        return this.mDxebCreated;
    }

    public String getTitle() {
        if (this.mSender == null) {
            return createString;
        }
        return receiveString;
    }

    public String getEmployeeDescription() throws BusinessDomainException {
        Employee employee;
        Object result = "";
        Employee employee2 = employee = this.mDxar == null ? null : this.mDxar.getEmployee();
        if (employee != null) {
            Master master = employee.getMaster(VDate.getDateMax(), VDate.getDateMax());
            result = employee.getPersonnelnumber() + "    " + master.getSurname() + ", " + master.getFirstname();
        }
        return result;
    }

    public String getSenderName() throws BusinessDomainException {
        String name = "";
        if (this.mSender != null) {
            name = this.mSender.getDEUVSenderTP(VDate.getDateMax(), VDate.getDateMax()).getName();
        }
        return name;
    }

    public String getUser() {
        return SessionContext.getInstance().getSession().getUserCode();
    }

    public String getVersion() {
        return Version.getVersion();
    }

    public Date getDatumUhrzeit() {
        return VDate.getCurrentLocalizedDateAndTime();
    }
}

