/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.redhhcompensationreport;

import com.infor.igf.core.util.ClassLoaderUtil;
import com.infor.igf.core.util.ImageUtil;
import com.varial.base.UtilitiesManager;
import com.varial.base.callback.TransactionMode;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.CorbaExceptionMapper;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportRespectValuateEnum;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.library.IDaoHolder;
import com.varial.personnel.domain.reports.library.PlantHolder;
import com.varial.personnel.domain.reports.library.ReportFilterMapper;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.redhhcompensationreport.IRedHHListDataSource;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHCompensationReportDataSource;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHCompensationReportDataSourceAntragKrK;
import com.varial.personnel.domain.reports.redhhcompensationreport.RedHHListDataSource;
import com.varial.personnel.domain.reports.redhhcompensationreport.SelectedKugListeEnum;
import com.varial.personnel.framework.D;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.SpecialAccess;
import com.varial.personnel.servantimpl.employee.SpecialAccessPrintCommand;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallback;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.PutDataException;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedHHCompensationReportCallbackImpl
extends SpecialAccessPrintCommand<ReportFileStructCallback> {
    private static final String PREFIX = "com/varial/personnel/jasperreport/redhhcompensationreport/";
    private static String PROFILE_PREFIX = "KUG";
    private static Logger LOGGER = LoggerFactory.getLogger(RedHHCompensationReportCallbackImpl.class);
    private ReportFirstFilterStruct mFirstFilter;
    private ReportSecondFilterStruct[] mSecondFilter;
    private ReportThirdFilterStruct mThirdFilter;
    private final SelectedKugListeEnum mListType;
    private final String mUserPassword;
    private final boolean mInternalUse;
    private final boolean mProposal;
    private final boolean mMore6Month;
    private final Date mForEffectiveDate;
    private final Date mForValidDate;
    private final String mOwnerPassword;
    private final ReportSortStruct[] mSort;
    private final List<String> mErrorList;
    private final boolean mForPlantDepartment;
    private final String mPlantDepartment;
    private final List<String> createdPdfUrls;
    private final boolean mRequesterFromCompany;
    private IRedHHListDataSource listDataSource;
    private IRedHHListDataSource listKrkDataSource;

    private boolean is201501Format() {
        return DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)DateMapper.toDate((String)"2015-01-01"));
    }

    private boolean is201601Format() {
        return DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)DateMapper.toDate((String)"2016-01-01"));
    }

    private boolean is201701Format() {
        return DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)DateMapper.toDate((String)"2017-01-01"));
    }

    private boolean is201801Format() {
        return DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)DateMapper.toDate((String)"2018-01-01"));
    }

    private boolean is202003Format() {
        return DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)DateMapper.toDate((String)"2020-03-01"));
    }

    private boolean is202101Format() {
        return DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)DateMapper.toDate((String)"2021-01-01"));
    }

    private boolean is202104Format() {
        return DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)DateMapper.toDate((String)"2021-04-01"));
    }

    private boolean is202201Format() {
        return DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)DateMapper.toDate((String)"2022-01-01"));
    }

    private boolean is202204Format() {
        return DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)DateMapper.toDate((String)"2022-04-01"));
    }

    private boolean is202207Format() {
        return DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)DateMapper.toDate((String)"2022-07-01"));
    }

    private RedHHCompensationReportCallbackImpl(ReportFileStructCallback callback, AuthorizationToken token, ReportSortStruct[] sorts, SelectedKugListeEnum listType, Date forEffectiveDate, Date forValidDate, String password, boolean internalUse, boolean proposal, boolean more6Month, boolean forPlantDepartment, String plantDepartment, boolean requesterFromCompany) {
        super(token, (AllCallbackOperations)callback, TransactionMode.READONLY, SpecialAccess.mode((boolean)internalUse));
        this.mSort = sorts;
        this.mListType = listType;
        this.mForEffectiveDate = DateHelper.getLastDayOfMonth((Date)forEffectiveDate);
        this.mForValidDate = DateHelper.getLastDayOfMonth((Date)forValidDate);
        this.mUserPassword = password;
        this.mInternalUse = internalUse;
        this.mProposal = proposal;
        this.mMore6Month = more6Month;
        this.mForPlantDepartment = forPlantDepartment;
        this.mPlantDepartment = plantDepartment;
        this.mOwnerPassword = "lameb";
        this.mErrorList = new LinkedList<String>();
        this.createdPdfUrls = new LinkedList<String>();
        this.mRequesterFromCompany = requesterFromCompany;
    }

    public RedHHCompensationReportCallbackImpl(ReportFileStructCallback callback, AuthorizationToken token, ReportFirstFilterStruct firstFilter, ReportSortStruct[] sorts, SelectedKugListeEnum listType, Date forEffectiveDate, Date forValidDate, String password, boolean internalUse, boolean proposal, boolean more6Month, boolean forPlantDepartment, String plantDepartment, boolean requesterFromCompany) {
        this(callback, token, sorts, listType, forEffectiveDate, forValidDate, password, internalUse, proposal, more6Month, forPlantDepartment, plantDepartment, requesterFromCompany);
        this.mFirstFilter = firstFilter;
    }

    public RedHHCompensationReportCallbackImpl(ReportFileStructCallback callback, AuthorizationToken token, ReportSecondFilterStruct[] secondFilter, ReportSortStruct[] sorts, SelectedKugListeEnum listType, Date forEffectiveDate, Date forValidDate, String password, boolean internalUse, boolean proposal, boolean more6Month, boolean forPlantDepartment, String plantDepartment, boolean requesterFromCompany) {
        this(callback, token, sorts, listType, forEffectiveDate, forValidDate, password, internalUse, proposal, more6Month, forPlantDepartment, plantDepartment, requesterFromCompany);
        this.mSecondFilter = secondFilter;
    }

    public RedHHCompensationReportCallbackImpl(ReportFileStructCallback callback, AuthorizationToken token, ReportThirdFilterStruct thirdFilter, ReportSortStruct[] sorts, SelectedKugListeEnum listType, Date forEffectiveDate, Date forValidDate, String password, boolean internalUse, boolean proposal, boolean more6Month, boolean forPlantDepartment, String plantDepartment, boolean requesterFromCompany) {
        this(callback, token, sorts, listType, forEffectiveDate, forValidDate, password, internalUse, proposal, more6Month, forPlantDepartment, plantDepartment, requesterFromCompany);
        this.mThirdFilter = thirdFilter;
    }

    public void execute() throws BusinessDomainException, PutDataException {
        ReportHelper.reportsCheckUserValidDate((Date)this.mForEffectiveDate, (Date)this.mForValidDate, (ReportFirstFilterStruct)this.mFirstFilter, (ReportSecondFilterStruct[])this.mSecondFilter, (ReportThirdFilterStruct)this.mThirdFilter);
        List<String> plantOids = null;
        if (this.mThirdFilter != null && !StringMapper.isNullString((String)this.mThirdFilter.plantKeyFrom) && !StringMapper.isNullString((String)this.mThirdFilter.plantKeyUntil)) {
            ReportHelper reportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);
            plantOids = reportHelper.usePlantLongdescriptionForSelectionAndSort() ? ReportFilterMapper.getPlantsLongdescriptionFilter((String)this.mThirdFilter.plantKeyFrom, (String)this.mThirdFilter.plantKeyUntil, (String)this.mThirdFilter.oidPCompany) : ReportFilterMapper.getPlantsUpToFilterElements((String)this.mThirdFilter.plantKeyFrom, (String)this.mThirdFilter.plantKeyUntil, (String)"plantkey", (IDaoHolder)PlantHolder.getInstance(), (String)"oidheadcompany", (String)this.mThirdFilter.oidPCompany);
        }
        if (plantOids == null || plantOids.size() == 0) {
            plantOids = new ArrayList<String>();
            String oidPlant = null;
            if (this.mFirstFilter != null) {
                oidPlant = this.mFirstFilter.oidPlant;
            }
            plantOids.add(oidPlant);
        }
        for (String each : plantOids) {
            if (this.mFirstFilter == null && this.mThirdFilter != null && !StringMapper.isNullString((String)this.mThirdFilter.plantKeyFrom) && !StringMapper.isNullString((String)this.mThirdFilter.plantKeyUntil)) {
                this.mFirstFilter = new ReportFirstFilterStruct();
                this.mFirstFilter.oidPlant = each;
                this.mFirstFilter.oidPCompany = this.mThirdFilter.oidPCompany;
            }
            if (this.isEmploymentOffice(each)) {
                if (this.getListDataSource(each).hasSV50Mode()) {
                    this.getListDataSource(each).setSV50Mode();
                    this.addCreatedPdf(this.runListeReport(each));
                }
                if (this.getListDataSource(each).hasSV100Mode()) {
                    this.getListDataSource(each).setSV100Mode();
                    this.addCreatedPdf(this.runListeReport(each));
                }
                if (this.mProposal) {
                    this.addCreatedPdf(this.runAntragReport(each));
                }
            }
            if (this.isHealthFund(each)) {
                this.addCreatedPdf(this.runKrkListeReport(each));
                if (this.mProposal) {
                    this.addCreatedPdf(this.runKrkAntragReport(each));
                }
            }
            this.mFirstFilter = null;
            this.listDataSource = null;
            this.listKrkDataSource = null;
        }
        ((ReportFileStructCallback)this.getCallback()).putData(this.getCreatedPdfUrls());
    }

    private boolean isHealthFund(String oidPlant) {
        try {
            this.getKrkListDataSource(oidPlant);
        }
        catch (BusinessDomainException e) {
            this.addError("Abrechnungsliste f\u00fcr Krankengeld", e);
            return false;
        }
        return this.mListType == SelectedKugListeEnum.SGE_KRKListe || this.mListType == SelectedKugListeEnum.SGE_AaKrkListe;
    }

    private boolean isEmploymentOffice(String oidPlant) {
        try {
            this.getListDataSource(oidPlant);
        }
        catch (BusinessDomainException e) {
            this.addError("Kug-Abrechnungsliste", e);
            return false;
        }
        return this.mListType == SelectedKugListeEnum.SGE_AAListe || this.mListType == SelectedKugListeEnum.SGE_AaKrkListe;
    }

    private void addError(String activity, Throwable e) {
        LOGGER.debug(activity, e);
        this.mErrorList.add(activity + ", " + e.getLocalizedMessage());
    }

    private File runListeReport(String oidPlant) throws BusinessDomainException {
        if (this.is202207Format()) {
            return this.runReportToPdf(this.compileReport("Abrechnungsliste2207"), this.getListParameters(), (JRDataSource)this.getListDataSource(oidPlant));
        }
        if (this.is202204Format()) {
            return this.runReportToPdf(this.compileReport("Abrechnungsliste2204"), this.getListParameters(), (JRDataSource)this.getListDataSource(oidPlant));
        }
        if (this.is202201Format()) {
            return this.runReportToPdf(this.compileReport("Abrechnungsliste2201"), this.getListParameters(), (JRDataSource)this.getListDataSource(oidPlant));
        }
        if (this.is202104Format()) {
            return this.runReportToPdf(this.compileReport("Abrechnungsliste2104"), this.getListParameters(), (JRDataSource)this.getListDataSource(oidPlant));
        }
        if (this.is202101Format()) {
            return this.runReportToPdf(this.compileReport("Abrechnungsliste2101"), this.getListParameters(), (JRDataSource)this.getListDataSource(oidPlant));
        }
        if (this.is202003Format()) {
            return this.runReportToPdf(this.compileReport("Abrechnungsliste2003"), this.getListParametersOld(), (JRDataSource)this.getListDataSource(oidPlant));
        }
        if (this.is201801Format()) {
            return this.runReportToPdf(this.compileReport("Abrechnungsliste1801"), this.getListParametersOld(), (JRDataSource)this.getListDataSource(oidPlant));
        }
        if (this.is201701Format()) {
            return this.runReportToPdf(this.compileReport("Abrechnungsliste1701"), this.getListParametersOld(), (JRDataSource)this.getListDataSource(oidPlant));
        }
        if (this.is201601Format()) {
            return this.runReportToPdf(this.compileReport("Abrechnungsliste1601"), this.getListParametersOld(), (JRDataSource)this.getListDataSource(oidPlant));
        }
        if (this.is201501Format()) {
            return this.runReportToPdf(this.compileReport("Abrechnungsliste1501"), this.getListParametersOld(), (JRDataSource)this.getListDataSource(oidPlant));
        }
        return this.runReportToPdf(this.compileReport("Abrechnungsliste1401"), this.getListParametersOld(), (JRDataSource)this.getListDataSource(oidPlant));
    }

    private Map<String, Object> getListParameters() {
        Map<String, Object> parameters = this.createParameters();
        parameters.put("matrixcodeImage", this.getImage("Abrechnungsliste2101.png"));
        return parameters;
    }

    private Map<String, Object> getListParametersOld() {
        Map<String, Object> parameters = this.createParameters();
        parameters.put("matrixcodeImage", this.getImage("Abrechnungsliste0912.png"));
        return parameters;
    }

    private void flushDomainExceptions() {
        String[] errs = this.mErrorList.toArray(new String[this.mErrorList.size()]);
        this.mErrorList.clear();
        BusinessDomainException de = ReportExceptionMapper.makeStickyEmployeesInEmployeeForReport(errs);
        ((ReportFileStructCallback)this.getCallback()).setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de));
    }

    private File runAntragReport(String oidPlant) throws BusinessDomainException {
        if (this.is202207Format()) {
            Map<String, Object> parameters = this.createParameters();
            parameters.put("agenturImage", this.getImage("Agentur.png"));
            parameters.put("matrixcodeImage", this.getImage("Antrag2101.png"));
            return this.runReportToPdf(this.compileReport("Antrag2207"), parameters, this.getListDataSource(oidPlant).getAntragDataSource());
        }
        if (this.is202204Format()) {
            Map<String, Object> parameters = this.createParameters();
            parameters.put("agenturImage", this.getImage("Agentur.png"));
            parameters.put("matrixcodeImage", this.getImage("Antrag2101.png"));
            return this.runReportToPdf(this.compileReport("Antrag2204"), parameters, this.getListDataSource(oidPlant).getAntragDataSource());
        }
        if (this.is202104Format()) {
            Map<String, Object> parameters = this.createParameters();
            parameters.put("agenturImage", this.getImage("Agentur.png"));
            parameters.put("matrixcodeImage", this.getImage("Antrag2101.png"));
            return this.runReportToPdf(this.compileReport("Antrag2104"), parameters, this.getListDataSource(oidPlant).getAntragDataSource());
        }
        if (this.is202101Format()) {
            Map<String, Object> parameters = this.createParameters();
            parameters.put("agenturImage", this.getImage("Agentur.png"));
            parameters.put("matrixcodeImage", this.getImage("Antrag2101.png"));
            return this.runReportToPdf(this.compileReport("Antrag2101"), parameters, this.getListDataSource(oidPlant).getAntragDataSource());
        }
        if (this.is202003Format()) {
            Map<String, Object> parameters = this.createParameters();
            parameters.put("agenturImage", this.getImage("Agentur.png"));
            parameters.put("matrixcodeImage", this.getImage("Antrag0912.png"));
            return this.runReportToPdf(this.compileReport("Antrag2003"), parameters, this.getListDataSource(oidPlant).getAntragDataSource());
        }
        if (this.is201801Format()) {
            Map<String, Object> parameters = this.createParameters();
            parameters.put("agenturImage", this.getImage("Agentur.png"));
            parameters.put("matrixcodeImage", this.getImage("Antrag0912.png"));
            return this.runReportToPdf(this.compileReport("Antrag1801"), parameters, this.getListDataSource(oidPlant).getAntragDataSource());
        }
        if (this.is201701Format()) {
            Map<String, Object> parameters = this.createParameters();
            parameters.put("agenturImage", this.getImage("Agentur.png"));
            parameters.put("matrixcodeImage", this.getImage("Antrag0912.png"));
            return this.runReportToPdf(this.compileReport("Antrag1701"), parameters, this.getListDataSource(oidPlant).getAntragDataSource());
        }
        if (this.is201601Format()) {
            Map<String, Object> parameters = this.createParameters();
            parameters.put("agenturImage", this.getImage("Agentur.png"));
            parameters.put("matrixcodeImage", this.getImage("Antrag0912.png"));
            return this.runReportToPdf(this.compileReport("Antrag1601"), parameters, this.getListDataSource(oidPlant).getAntragDataSource());
        }
        if (this.is201501Format()) {
            Map<String, Object> parameters = this.createParameters();
            parameters.put("agenturImage", this.getImage("Agentur.png"));
            parameters.put("matrixcodeImage", this.getImage("Antrag0912.png"));
            return this.runReportToPdf(this.compileReport("Antrag1501"), parameters, this.getListDataSource(oidPlant).getAntragDataSource());
        }
        Map<String, Object> parameters = this.createParameters();
        parameters.put("agenturImage", this.getImage("Agentur.png"));
        parameters.put("matrixcodeImage", this.getImage("Antrag0912.png"));
        return this.runReportToPdf(this.compileReport("Antrag1401"), parameters, this.getListDataSource(oidPlant).getAntragDataSource());
    }

    private Image getImage(String name) {
        InputStream inputStream = this.getResourceAsStream(name);
        if (inputStream == null) {
            return null;
        }
        try {
            return ImageUtil.loadAwtImage((InputStream)inputStream);
        }
        catch (IOException e) {
            ExceptionMapper.printException((Throwable)e);
            return null;
        }
    }

    private InputStream getResourceAsStream(String name) {
        InputStream resourceAsStream = ClassLoaderUtil.getDefaultClassLoader().getResourceAsStream(PREFIX + name);
        if (resourceAsStream == null) {
            LOGGER.error("Could not load resource: {} from classpath: {}", (Object)name, (Object)PREFIX);
        }
        return resourceAsStream;
    }

    private Map<String, Object> createParameters() {
        return new HashMap<String, Object>();
    }

    private File runKrkListeReport(String oidPlant) throws BusinessDomainException {
        RedHHCompensationReportDataSource dataSource = (RedHHCompensationReportDataSource)this.getKrkListDataSource(oidPlant);
        Map parameters = dataSource.getParameters();
        return this.runReportToPdf(this.compileReport("RedHHCompensationReportKrankengeldliste"), parameters, (JRDataSource)dataSource);
    }

    private File runKrkAntragReport(String oidPlant) throws BusinessDomainException {
        RedHHCompensationReportDataSource lds = (RedHHCompensationReportDataSource)this.getKrkListDataSource(oidPlant);
        RedHHCompensationReportDataSourceAntragKrK dataSource = new RedHHCompensationReportDataSourceAntragKrK(this.mForEffectiveDate, this.mForValidDate, this.getOidPCompany(), lds.getMKrKAnschriftHM(), oidPlant);
        Map parameters = dataSource.getParameters();
        return this.runReportToPdf(this.compileReport("RedHHCompensationReportAntragKrk"), parameters, (JRDataSource)dataSource);
    }

    private JRDataSource getKrkListDataSource(String oidPlant) throws BusinessDomainException {
        if (this.listKrkDataSource == null) {
            this.listKrkDataSource = this.createKrkListDataSource(oidPlant);
        }
        return this.listKrkDataSource;
    }

    private IRedHHListDataSource createKrkListDataSource(String oidPlant) throws BusinessDomainException {
        return new RedHHCompensationReportDataSource((AllCallback)this.getCallback(), (ISpecialAccessPersistencyContext)this.getSpecialAccess(), this.mFirstFilter, this.mSecondFilter, this.mThirdFilter, this.mSort, this.mListType, this.mForEffectiveDate, this.mForValidDate, this.mInternalUse, true, this.mErrorList, oidPlant, this.mRequesterFromCompany);
    }

    private IRedHHListDataSource getListDataSource(String oidPlant) throws BusinessDomainException {
        if (this.listDataSource == null) {
            this.listDataSource = this.createListDataSource(oidPlant);
        }
        return this.listDataSource;
    }

    private IRedHHListDataSource createListDataSource(String oidPlant) throws BusinessDomainException {
        D.enter();
        EmployeeForReportGenerator generator = new EmployeeForReportGenerator((ISpecialAccessPersistencyContext)this.getSpecialAccess(), this.mFirstFilter, this.mSecondFilter, this.mThirdFilter, this.mSort, this.mForEffectiveDate, DateHelper.getFirstDayOfMonth((Date)this.mForValidDate), DateHelper.getLastDayOfMonth((Date)this.mForValidDate), this.mErrorList, ReportRespectValuateEnum.RRVE_Keine_Reaktion_auf_Fehler);
        RedHHListDataSource dataSource = new RedHHListDataSource(generator, this.mInternalUse, this.mMore6Month, this.mForPlantDepartment, this.mPlantDepartment, oidPlant, this.mRequesterFromCompany);
        if (!this.mErrorList.isEmpty()) {
            this.flushDomainExceptions();
        }
        if (dataSource.isEmpty()) {
            throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
        }
        D.leave();
        return dataSource;
    }

    private File runReportToPdf(JasperReport compiledDesign, Map<String, Object> parameters, JRDataSource dataSource) throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mUserPassword)) {
            return JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)compiledDesign, parameters, (JRDataSource)dataSource, (String)PROFILE_PREFIX);
        }
        return JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)compiledDesign, parameters, (JRDataSource)dataSource, (String)PROFILE_PREFIX, (String)this.mUserPassword, (String)this.mOwnerPassword);
    }

    private String getOidPCompany() throws BusinessDomainException {
        return ReportHelper.getOidPcompany((ReportFirstFilterStruct)this.mFirstFilter, (ReportSecondFilterStruct[])this.mSecondFilter, (ReportThirdFilterStruct)this.mThirdFilter);
    }

    private void addCreatedPdf(File file) {
        String url = JasperReportManager.getUrl((File)file);
        LOGGER.debug("File name: {}" + url);
        this.createdPdfUrls.add(url);
    }

    private String[] getCreatedPdfUrls() {
        return this.createdPdfUrls.toArray(new String[this.createdPdfUrls.size()]);
    }

    private JasperReport compileReport(String reportName) {
        return JasperReportCompiler.compileReport((String)(PREFIX + reportName + ".jrxml"));
    }
}

