/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.mapper;

import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.ApplicationException;
import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.reports.costingreportpre.BasisOfReportEnum;
import com.varial.personnel.domain.reports.costingreportpre.ColumnEnum;
import com.varial.personnel.domain.reports.costingreportpre.mapper.BasisOfReportEnumMapper;
import com.varial.personnel.domain.reports.costingreportpre.mapper.ColumnEnumMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.query.AllCallback;
import com.varial.serverbase.query.DatabaseExceptionStruct;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.omg.CORBA.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

public class ReportExceptionMapper {
    private static Logger LOGGER = LoggerFactory.getLogger(ReportExceptionMapper.class);
    private static final String CLASS_GENERAL = "PYReport";
    private static final String NO_REPORT_BUILD = "Report wurde nicht erzeugt !\n";
    private static final int EFFECTIVE_TIMEPOINT_IS_EMPTY = 100;
    private static final int VALID_TIMEPOINT_IS_EMPTY = 101;
    private static final int YEAR_IS_EMPTY = 102;
    public static final int NO_EMPLOYEE_FOR_THIS_ASSORTMENT = 103;
    private static final int NO_ACCOUNT_FOR_REPORT_PAYMENT = 104;
    private static final int WRONG_SORT_CRITERIA_TOO_MUCH_CHOICES_GENERAL = 105;
    private static final int WRONG_SORT_CRITERIA_NO_USE_OF_PLANTS = 106;
    private static final int WRONG_SORT_CRITERIA_TOO_MUCH_CHOICES = 107;
    private static final int WRONG_SORT_CRITERIA_NO_USE_EMPLOYEE_CIRCLE = 108;
    private static final int WRONG_SORT_CRITERIA_NO_COSTCENTER = 109;
    private static final int WRONG_SORT_CRITERIA_NO_COSTUNIT = 110;
    private static final int WRONG_SORT_CRITERIA_NO_DEPARTMENT = 111;
    private static final int WRONG_SORT_CRITERIA_NO_ORGUNIT = 112;
    private static final int WRONG_SORT_CRITERIA_NO_PERSON_IN_CHARGE1 = 113;
    private static final int WRONG_SORT_CRITERIA_NO_PERSON_IN_CHARGE2 = 114;
    private static final int WRONG_SECOND_FILTER_CRITERIA_NO_CHOICE = 115;
    private static final int NO_VALUTYPES_DEFINED_FOR_PRINTING = 118;
    private static final int NO_DEFINED_FOR_RESULT_AND_FACTOR1 = 119;
    private static final int VALID_TIMEFROM_IS_EMPTY = 120;
    private static final int VALID_TIMEUNTILL_IS_EMPTY = 121;
    private static final int NO_NOT_INTERNAL_USE_FOR_FIRST_FILTER = 122;
    private static final int NO_NOT_INTERNAL_USE_FOR_SECOND_FILTER = 123;
    private static final int NO_NOT_INTERNAL_USE_FOR_THIRD_FILTER = 124;
    private static final int NO_NOT_BSBI_USE_FOR_SECOND_FILTER = 125;
    private static final int NO_NOT_BSBI_INTERNAL_USE_FOR_THIRD_FILTER = 126;
    private static final int NO_REPEATED_BS_E_TRANSFER_FOR_KVDR = 127;
    private static final int NO_REPEATED_BS_E_TRANSFER_SERIALNUMBER = 128;
    private static final int NO_REPEATED_BS_E_TRANSFER_JOURNALIZED = 129;
    private static final int NO_NOT_BSBI_USE_FOR_FIRST_FILTER = 130;
    private static final int NO_DATA_FOR_COMPANYTAXOFFICE = 200;
    private static final int NO_DATA_FOR_PLANTTAXOFFICE = 201;
    private static final int NO_NAME_FOR_COMPANYTAXOFFICE = 202;
    private static final int NO_DATA_FOR_PLANTSETTINGS = 203;
    private static final int NO_DATA_FOR_COMPANYSETTINGS = 204;
    private static final int NO_DATA_FOR_PLANTFOUNDATIONS = 205;
    private static final int NO_DATA_FOR_COMPANYFOUNDATIONS = 206;
    private static final int NO_CUREENCY = 207;
    private static final int NO_SPLITT_LUMPSUMCT = 208;
    private static final int TAX_COMPANY_NUMBER_IS_MISSING = 210;
    private static final int TAXOFFICE_COMPANY_DESCRIPTION_IS_MISSING = 211;
    private static final int TAXOFFICE_COMPANY_NUMBER_IS_MISSING = 212;
    private static final int NO_COMPANY_POSTAL_ADRESS = 215;
    private static final int NO_COMPANY_LONGDECRIPTION = 216;
    private static final int NO_COMPANY = 217;
    private static final int COMPANYFEDERALSTATE_IS_MISSING = 218;
    private static final int TAXOFFICE_COMPANY_ADRESS_IS_MISSING = 219;
    private static final int TAX_PLANT_NUMBER_IS_MISSING = 220;
    private static final int TAXOFFICE_PLANT_DESCRIPTION_IS_MISSING = 221;
    private static final int TAXOFFICE_PLANT_NUMBER_IS_MISSING = 222;
    private static final int NO_INSURANCE_DATA_FOR_EMPLOYEES = 225;
    private static final int NO_TAX_DATA_FOR_EMPLOYEES = 226;
    private static final int MISSING_OID_COMMUNITY = 227;
    private static final int NO_PLANT_LAW_AREA = 228;
    private static final int NO_PLANT_POSTAL_ADRESS = 229;
    private static final int NO_PLANT_LONGDECRIPTION = 230;
    private static final int NO_PLANT_SHORTDECRIPTION = 231;
    private static final int NO_PLANT = 232;
    private static final int NO_PLANT_KEY = 233;
    private static final int TAX_PLANT_COMPANY_NUMBER_IS_MISSING = 234;
    private static final int PLANTFEDERALSTATE_IS_MISSING = 235;
    private static final int TAXOFFICE_PLANT_ADRESS_IS_MISSING = 236;
    private static final int NO_EECarriedForwardOfEntryYearOfCertificateOfWageTaxDeducation = 237;
    private static final int EECarriedForwardOfEntryYearOfCertificateOfWageTaxDeducationNotCorrect = 238;
    private static final int EECarriedForwardOfEntryMissingEmploymentFromOrUntil = 239;
    private static final int EMPLOYEEOFFICE_COMPANY_IS_MISSING = 310;
    private static final int EMPLOYEEOFFICE_PLANT_IS_MISSING = 320;
    private static final int NO_ACCOUNTNUMBER_FOR_HEALTHFUND = 400;
    private static final int NO_HEALTHFUND_ASSESSMENT_FOR_COMPANY_PLANT = 401;
    private static final int NO_BUNDESKNAPPSCHAFT_IN_COMPHEALTHFUND = 402;
    private static final int NO_BUNDESKNAPPSCHAFT_AS_HEALTHFUND = 403;
    private static final int NO_HEALTHFUND_IN_COMPHEALTHFUND = 404;
    private static final int NO_HEALTHFUNDTP = 405;
    private static final int NO_HEALTHFUND_BY_STDCOMPNR = 406;
    private static final int NO_DATA_FOR_STATEMENTOFCONTRIBUTIONPAIDREPORT = 501;
    private static final int NO_NAME_FOR_STATEMENTOFCONTRIBUTIONPAIDREPORT_PAYMENT = 502;
    private static final int NO_DATE_EQUAL_FOR_STATEMENTOFCONTRIBUTIONPAIDREPORT_PAYMENT = 504;
    private static final int NO_KORREKT_EMPLOYEE_LISTS_FOR_RETROACTIVE_CORRECTION_IN_STATEMENTOFCONTRIBUTIONPAIDREPORT = 505;
    private static final int WRONG_ACCOUNT_FOR_THE_NEXT_ALLOCATIONS = 601;
    private static final int MISSING_FA_FILE_PATH = 602;
    private static final int NO_ALLOCATIONS_TO_USE = 603;
    private static final int VALUETYPES_ONLY_BY_COMPANY = 604;
    private static final int STICKY_EMPLOYEE_IN_EMPLOYEE_FOR_REPORT = 701;
    private static final int EMPLOYEES_NOT_JOURNALIZED = 702;
    private static final int THIS_EMPLOYEES_ARE_JOURNALIZED_BEFORE_THIS_YEAR = 703;
    private static final int EMPLOYEE_NOT_JOURNALIZED = 704;
    private static final int NO_DATE_EQUAL_FOR_SELFSERVICE = 705;
    private static final int WRONG_VALIDDATE_FOR_SELFSERVICE = 706;
    private static final int COLUMN_NOT_ASSIGNMENTCRITERIA_OF_PCOMPANY = 801;
    private static final int COLUMN_MISSING = 802;
    private static final int REPORTNAME_MISSING = 803;
    private static final int VALUETYPE_ALREADY_EXISTS = 804;
    private static final int COLUMN_ALREADY_EXISTS = 805;
    private static final int ONLY_COSTCENTER_OR_COSTUNIT = 806;
    private static final int ONLY_ONE_TAXTYPE = 807;
    private static final int ONLY_VOR_OR_MEHRWERTSTEUER = 808;
    private static final int MULTIPLY_NO_ASSIGNMENTS = 809;
    private static final int NO_VALUETYPES_FUND = 901;
    private static final int NO_ACCOUNTS_FUND = 902;
    private static final int NO_STATVALUES_FUND = 903;
    private static final int VALUETYPE_MISSING = 950;
    private static final int COSTCENTER_MISSING_IN_COSTING = 960;
    private static final int ACCOUNT_HAS_NOT_COSTING = 970;
    private static final int ACCOUNT_HAS_COSTING = 971;
    private static final int TRANSFERED_EXPORTRATES = 1000;
    private static final int VWE_FA_NOT_IN_USE = 1001;
    private static final int VWE_CO_NOT_IN_USE = 1002;
    private static final int NO_FA_IN_USE = 1003;
    private static final int NO_ENCRYPTION_IN_ARCHIVE = 1004;
    private static final int NO_COMPANY_ACCOUNT = 1501;
    private static final int NO_EMPLOYEE_SELECTED = 1502;
    private static final int USE_SETTLEMENT_WAGETAX = 1100;
    private static final int NO_STATISTIC_VALUE_POSITIONS = 1101;
    private static final int ONLY_THIS_MONTHS_FOR_QUARTAL = 1102;
    private static final int ONLY_THIS_MONTH_FOR_YEARLY = 1103;
    private static final int NO_PERSONNELACCOUNT_FOR_HEALTHFUND = 1200;
    private static final int NO_REPORT_BEFORE_2011 = 1300;
    private static final int NO_STATISTICAL_VALUE = 1400;
    private static final int SELECTION_MISSING = 1503;
    private static final int DETAILS_MISSING = 150;
    private static final int STOCKREPORT_PROPERTY_NOT_LOAD = 1600;
    private static final int NOACCIDENTINSURANCEFOUND = 1700;
    private static final int NODATAFOUND = 1800;
    private static final int ACCOUNT_ALREADY_EXISTS = 1801;
    private static final int STATISTICALVALUE_ALREADY_EXISTS = 1802;
    private static final int ZVK_TYPEOFLIST_NOT_ALLOWED = 1803;
    private static final int COMBINATION_COLUMN_BASISOFREPORT_NOT_ALLOWED = 1804;
    private static final int FAMILYFUNDKEY_IS_MISSING = 1805;
    @Errors
    private static final ErrorList mErrorList = new ErrorList("PYReport", new ErrorMessage[]{new ErrorMessage(100, "Der Zeitpunkt der Wirksamkeit wurde nicht \u00fcbergeben"), new ErrorMessage(101, "Der Zeitpunkt der G\u00fcltigkeit wurde nicht \u00fcbergeben"), new ErrorMessage(120, "Der Zeitpunkt G\u00fcltig von wurde nicht \u00fcbergeben"), new ErrorMessage(121, "Der Zeitpunkt G\u00fcltig bis wurde nicht \u00fcbergeben"), new ErrorMessage(102, "Das Jahr wurde nicht \u00fcbergeben"), new ErrorMessage(103, "Es gibt keine Mitarbeiter zu dieser Auswahl"), new ErrorMessage(105, "Sie k\u00f6nnen maximal drei Sortierkriterien ausw\u00e4hlen"), new ErrorMessage(109, "Sortierkriterium Kostenstelle ist nicht m\u00f6glich, da in den Firmeneinstellungen nicht aktiv"), new ErrorMessage(110, "Sortierkriterium Kostentr\u00e4ger ist nicht m\u00f6glich, da in den Firmeneinstellungen nicht aktiv"), new ErrorMessage(111, "Sortierkriterium Abteilung ist nicht m\u00f6glich, da in den Firmeneinstellungen nicht aktiv"), new ErrorMessage(112, "Sortierkriterium Organisationseinheit ist nicht m\u00f6glich, da in den Firmeneinstellungen nicht aktiv"), new ErrorMessage(113, "Sortierkriterium Mitarbeiter 1 ist nicht m\u00f6glich, da in den Firmeneinstellungen nicht aktiv"), new ErrorMessage(114, "Sortierkriterium Mitarbeiter 2 ist nicht m\u00f6glich, da in den Firmeneinstellungen nicht aktiv"), new ErrorMessage(106, "Das Sortierkriterium \"Betriebsst\u00e4tte\" kann nicht verwendet werden,\nda der Eintrag \"Firma verwendet Betriebsst\u00e4tten\" in den Firmeneinstellungen nicht ausgew\u00e4hlt wurde"), new ErrorMessage(107, "Sie k\u00f6nnen nur ein Sortierkriterium, neben\n \"Mitarbeiter\"  und/oder  \"Betriebsst\u00e4tte\" (falls m\u00f6glich) ausw\u00e4hlen"), new ErrorMessage(115, "Sie haben keinen Mitarbeiter ausgew\u00e4hlt"), new ErrorMessage(104, "Es wurde kein VWE-FiBu-Konto f\u00fcr den Zahlungsverkehr angegeben"), new ErrorMessage(502, "Es wurde kein Name f\u00fcr den Zahlungsverkehr angegeben"), new ErrorMessage(501, "Es konnten kein Mitarbeiter selektiert werden"), new ErrorMessage(504, "G\u00fcltigkeits- und Sichtmonat m\u00fcssen beim Zahlungsverkehr gleich sein"), new ErrorMessage(202, "Exception nicht ausreichend in ReportExceptionMapper"), new ErrorMessage(225, "Folgende Mitarbeiter haben keine SV-Daten:\n"), new ErrorMessage(226, "Folgende/r Mitarbeiter hat/haben keine Besteuerungsdaten:\n"), new ErrorMessage(200, "Es sind keine Finanzamtsangaben f\u00fcr die Firma vorhanden oder unvollst\u00e4ndig"), new ErrorMessage(201, "Finanzamtsangaben zur Betriebsst\u00e4tte sind nicht vorhanden oder unvollst\u00e4ndig"), new ErrorMessage(229, "Adressangaben zur folgenden Betriebsst\u00e4tte sind nicht vorhanden:/n"), new ErrorMessage(230, "Betriebsst\u00e4ttenbezeichnung (lang) ist nicht vorhanden"), new ErrorMessage(231, "Betriebsst\u00e4ttenbezeichnung (Kurz) ist nicht vorhanden"), new ErrorMessage(233, "Betriebsst\u00e4tte hat keine VWE-Nr./n"), new ErrorMessage(232, "Betriebsst\u00e4tte nicht vorhanden"), new ErrorMessage(217, "Firma nicht vorhanden"), new ErrorMessage(216, "Firmenbezeichnung (lang) ist nicht vorhanden"), new ErrorMessage(215, "Adressangaben zu folgender Betriebsst\u00e4tte sind nicht vorhanden:/n"), new ErrorMessage(228, "Bundeslandbestimmung der folgenden Betriebsst\u00e4tte ist nicht m\u00f6glich:/n"), new ErrorMessage(210, "Die Finanzamtsangaben zur Firma sind unvollst\u00e4ndig, Steuernummer fehlt."), new ErrorMessage(211, "Die Finanzamtsangaben zur Firma sind unvollst\u00e4ndig, Finanzamtsbezeichnung fehlt."), new ErrorMessage(212, "Finanzamtsangaben zur Firma sind unvollst\u00e4ndig, Finanzamtsnummer fehlt."), new ErrorMessage(220, "Die Finanzamtsangaben zur Betriebsst\u00e4tte sind unvollst\u00e4ndig, Steuernummer fehlt."), new ErrorMessage(234, "Die Finanzamtsangaben zur Betriebsst\u00e4tte und Firma sind unvollst\u00e4ndig, Steuernummer fehlt."), new ErrorMessage(221, "Die Finanzamtsangaben zur Betriebsst\u00e4tte sind unvollst\u00e4ndig, Finanzamtsbezeichnung fehlt."), new ErrorMessage(222, "Die Finanzamtsangaben zur Betriebsst\u00e4tte sind unvollst\u00e4ndig, Finanzamtsnummer fehlt."), new ErrorMessage(310, "Angaben zur Agentur f\u00fcr Arbeit der Firma sind nicht vorhanden oder unvollst\u00e4ndig (Betriebsnummer)"), new ErrorMessage(320, "Angaben zur Agentur f\u00fcr Arbeit der Betriebsst\u00e4tte sind nicht vorhanden oder unvollst\u00e4ndig (Betriebsnummer)"), new ErrorMessage(400, "Die Beitragskontonummer der Firma/Betriebsst\u00e4tte bei der zugeordneten Krankenkasse ist nicht vorhanden"), new ErrorMessage(203, "Einstellungen zur Betriebsst\u00e4tte sind nicht vorhanden"), new ErrorMessage(204, "Einstellungen zur Firma sind nicht vorhanden"), new ErrorMessage(205, "Grundlagen zur Betriebsst\u00e4tte sind nicht vorhanden"), new ErrorMessage(206, "Grundlagen zur Firma sind nicht vorhanden"), new ErrorMessage(401, "Mitarbeiter nimmt am Umlageverfahren teil, aber die Umlage-Krankenkasse bei der Firma/Betriebsst\u00e4tte fehlt"), new ErrorMessage(402, "Bundesknappschaft ist nicht in der Zuordnungstabelle Firma/Krankenkasse enthalten"), new ErrorMessage(403, "Die Bundesknappschaft-Minijobzentrale ist nicht als Krankenkasse unter Globale Vorgaben/Institutionen/Krankenkassen angelegt worden"), new ErrorMessage(505, "Teillisten eines Mitarbeiters sind nicht korrekt"), new ErrorMessage(601, "Falsches FiBu-Konto zu folgenden Kontierungen vorhanden:\n\n"), new ErrorMessage(602, "Der \u00dcbergabepfad f\u00fcr die FiBU-Schnittstelle fehlt"), new ErrorMessage(701, "Unber\u00fccksichtigte Mitarbeiter (nicht ausgef\u00fchrte Berechnungsanst\u00f6\u00dfe, Scheduler, in Berechnung oder fehlerhaft):\n\n"), new ErrorMessage(801, "Die gew\u00e4hlte Spaltendefinition ist f\u00fcr diese Firma kein Zuordnungskriterium (Spalte "), new ErrorMessage(802, "Eine Spaltendefinition fehlt"), new ErrorMessage(809, "Zuordnungen d\u00fcrfen f\u00fcr eine Firma f\u00fcr Mehrfirmenverarbeitung nicht als Spalte ausgew\u00e4hlt werden"), new ErrorMessage(803, "Der Reportname fehlt"), new ErrorMessage(804, "Es ist nur eine Auswahl unterschiedlicher Wertarten zul\u00e4ssig"), new ErrorMessage(805, "Es ist nur eine Auswahl unterschiedlicher Spaltendefinitionen zul\u00e4ssig"), new ErrorMessage(901, "Zum Tabellenaufbau werden Wertarten ben\u00f6tigt.\nBitte w\u00e4hlen Sie die gew\u00fcnschten Wertarten aus,\noder \u00e4ndern Sie den Tabellenaufbau."), new ErrorMessage(902, "Zum Tabellenaufbau werden in einer Kontierung genutzte Konten ben\u00f6tigt.\nBitte w\u00e4hlen Sie die gew\u00fcnschten Konten aus, oder \u00e4ndern Sie den Tabellenaufbau."), new ErrorMessage(903, "Zum Tabellenaufbau werden Statistische Werte ben\u00f6tigt.\nBitte w\u00e4hlen Sie die gew\u00fcnschten Statistische Werte aus,\noder \u00e4ndern Sie den Tabellenaufbau."), new ErrorMessage(702, "Folgende/r relevante/r Mitarbeiter, ist/sind nicht journalisiert: \n"), new ErrorMessage(704, "Journalisierung eines/mehrerer Mitarbeiter/s nicht ausreichend"), new ErrorMessage(705, "Das G\u00fcltigkeits- und das Sichtdatum m\u00fcssen sich im selben Monat befinden."), new ErrorMessage(706, "Das G\u00fcltigkeitsdatum darf nicht gr\u00f6\u00dfer als der aktuelle Abrechnungsmonat sein."), new ErrorMessage(950, "Die Wertart fehlt in Zeile "), new ErrorMessage(118, "Es wurden keine Wertarten f\u00fcr den Andruck in der Kostenauswertung definiert.\nBitte \u00fcberarbeiten Sie die Andrucksteuerung in den Wertarten."), new ErrorMessage(119, "Folgende Wertart/en wurde entweder f\u00fcr den Andruck Betrag in Kostenauswertungen nicht definiert.\nBitte \u00fcberarbeiten Sie die Andrucksteuerung in der/den Wertart/en.\n"), new ErrorMessage(404, "Falsche Zuordnung Krankenkasse beim Mitarbeiter.\nKrankenkasse ist nicht in Zuordnungstabelle Firmen-Krankenkassen enthalten:\n"), new ErrorMessage(405, "Fehlende Krankenkasse bei folgenden Daten:\n"), new ErrorMessage(406, "Fehlende Krankenkasse (Folgeorganisation) f\u00fcr folgende Betriebsnummer:\n"), new ErrorMessage(703, "Folgende Mitarbeiter wurden im ausgew\u00e4hlten Jahr noch nicht journalisiert\nund daher nicht mit ber\u00fccksichtigt:\n\n"), new ErrorMessage(227, "Fehlender Eintrag des Gemeinde-AGS bei den Besteuerungsdaten des Mitarbeiters:\n"), new ErrorMessage(207, "W\u00e4hrungseintrag f\u00fcr die Firme/Betriebsst\u00e4tte ist unter Grundlagen - Steuerung nicht gegeben !\n"), new ErrorMessage(603, "Es gibt keine Kontierungen f\u00fcr eine Daten\u00fcbergabe!\n"), new ErrorMessage(604, "Der Andruck der Wertarten\u00fcbersicht ist nur beim Andruck nach Firma m\u00f6glich!\n"), new ErrorMessage(1000, " Exports\u00e4tze \u00fcbergeben!"), new ErrorMessage(1001, "In Firmen-Grundlagen im Feld eingesetzte FiBu ist die VWE nicht eingestellt! "), new ErrorMessage(1003, "In Firmen-Grundlagen im Feld eingesetzte FiBu ist keine FiBu eingestellt! "), new ErrorMessage(1002, "In Firmen-Grundlagen im Feld eingesetzte KoRe ist die VWE nicht eingestellt! "), new ErrorMessage(122, "Beim Echtlauf ist die Benutzung der Auswahlkriterien im Reiter \"Globale Auswahl\" nicht m\u00f6glich!\nW\u00e4hlen Sie hierzu die Checkbox \"interner Gebrauch\" !"), new ErrorMessage(130, "Bei der Auswahl des Inhalts: \"\u00fcbermitteltes Beitragssoll\" ist die Benutzung des Reiters \"Mitarbeiter Auswahl\" nicht m\u00f6glich!\nW\u00e4hlen Sie hierzu den Inhalt: \"aktuelle Berechnungsergebnisse\" !"), new ErrorMessage(123, "Beim Echtlauf ist die Benutzung des Reiters \"Mitarbeiter Auswahl\" nicht m\u00f6glich!\nW\u00e4hlen Sie hierzu die Checkbox \"interner Gebrauch\" !"), new ErrorMessage(125, "Bei der Auswahl des Inhalts: \"\u00fcbermitteltes Beitragssoll\" ist die Benutzung des Reiters \"Mitarbeiter Auswahl\" nicht m\u00f6glich!\nW\u00e4hlen Sie hierzu den Inhalt: \"aktuelle Berechnungsergebnisse\" !"), new ErrorMessage(124, "Beim Echtlauf ist die Benutzung des Reiters \"von - bis Auswahl\" nicht m\u00f6glich!\nW\u00e4hlen Sie hierzu die Checkbox \"interner Gebrauch\" !"), new ErrorMessage(126, "Bei der Auswahl des Inhalts: \"\u00fcbermitteltes Beitragssoll\" ist die Benutzung des Reiters \"von - bis Auswahl\" nicht m\u00f6glich!\nw\u00e4hlen Sie hierzu den Inhalt: \"aktuelle Berechnungsergebnisse\" !"), new ErrorMessage(806, "Es k\u00f6nnen in einer Auswertung nur die Kostenstellen oder die Kostentr\u00e4ger ausgewertet werden.\nEine Auswertung von beiden Zuordnungskriterien ist nicht m\u00f6glich! "), new ErrorMessage(807, "Es kann nur eine Steuerart \u00fcbergeben werden,\nentweder Vor- oder Mehrwertsteuer."), new ErrorMessage(808, "Es k\u00f6nnen nur die Steuerarten Vor- und Mehrwertsteuer \u00fcbergeben werden.\nBitte \u00fcberpr\u00fcfen Sie daher folgende Kontierungen:\n"), new ErrorMessage(1004, "Bei archivierten Dokumenten kann kein Passwort definiert werden. "), new ErrorMessage(235, "Fehlender Bundeslandeintrag bei der Betriebsst\u00e4tte."), new ErrorMessage(218, "Fehlender Bundeslandeintrag bei der Firma."), new ErrorMessage(208, "Fehlende Aufteilung Konfession ev."), new ErrorMessage(219, "Die Finanzamtsangaben zur Firma sind unvollst\u00e4ndig. Die Adresse fehlt."), new ErrorMessage(236, "Die Finanzamtsangaben zur Betriebsst\u00e4tte sind unvollst\u00e4ndig. Die Adresse fehlt."), new ErrorMessage(1501, "Es ist keine Bankverbindung f\u00fcr das Arbeitsamt angelegt."), new ErrorMessage(127, "Der Wiederholungslauf gilt nicht bei der Auswahl: Beitragsnachweise KVDR"), new ErrorMessage(128, "Der Wiederholungslauf ist f\u00fcr die getroffene Firmenauswahl nicht m\u00f6glich"), new ErrorMessage(129, "Der Wiederholungslauf ist f\u00fcr die getroffene Firmenauswahl nicht m\u00f6glich,\nda f\u00fcr das eingegebene Datum Mitarbeiter der folgenden Firma journalisiert sind:\n\n"), new ErrorMessage(1502, "Mindestens ein Mitarbeiter muss ausgew\u00e4hlt werden"), new ErrorMessage(960, "Folgende Kostenstellen sind in der Kostenrechnung nicht\ndefiniert und k\u00f6nnen somit nicht \u00fcbergeben werden.\nBitte legen Sie diese Kostenstellen neu an:\n\n"), new ErrorMessage(970, "Folgende FiBu-Konten sind f\u00fcr die Kostenrechnung nicht relevant\nwurden aber f\u00fcr die Kosten\u00fcbergabe gekennzeichnet:\n\n"), new ErrorMessage(971, "Folgende FiBu-Konten sind f\u00fcr die Kostenrechnung relevant\nwurden aber f\u00fcr die Kosten\u00fcbergabe nicht gekennzeichnet:\n\n"), new ErrorMessage(237, "Folgendem Mitarbeiter fehlt das \"Jahr LStB\" in der Maske Steuer-Vortr\u00e4ge\n"), new ErrorMessage(238, "Bei folgendem Mitarbeiter entspricht das \"Jahr LStB\" nicht dem Jahr des Berechnungsansto\u00dfes in der Maske Steuer-Vortr\u00e4ge \n"), new ErrorMessage(239, "Bei folgendem Mitarbeiter fehlt der Eintrag \"Dienstverh\u00e4ltnis von\" oder \"Dienstverh\u00e4ltnis bis\" in der Maske Steuer-Vortr\u00e4ge\n"), new ErrorMessage(1100, "Aufgrund von umfangreichen Programmanpassungen, bitte nur die verrechnete Lohnsteueranmeldung nutzen!"), new ErrorMessage(1101, "Es wurden keine Wertarten in der Statistik zugeordnet"), new ErrorMessage(1102, "Bei der viertelj\u00e4hrlichen Lohnsteueranmeldung ist nur \ndie Auswahl der Monate 03, 06, 09 und 12 zul\u00e4ssig"), new ErrorMessage(1103, "Bei der j\u00e4hrlichen Lohnsteueranmeldung ist nur die Auswahl des Monats 12 zul\u00e4ssig"), new ErrorMessage(1200, "F\u00fcr folgende Krankenkassen ist kein Personenkonto zugeordnet:\n\n"), new ErrorMessage(1300, "Eine Auswertung erfolgt erst ab dem Jahr 2011. Bitte passen Sie die G\u00fcltigkeit an."), new ErrorMessage(1400, "Bitte geben Sie einen Statistischen Wert an."), new ErrorMessage(1503, "Bitte treffen Sie eine Auswahl, welche Details im Report dargestellt werden sollen."), new ErrorMessage(150, "Die Report-Details wurden nicht \u00fcbergeben."), new ErrorMessage(1600, "Das folgende Feld konnte nicht geladen werden:\n\n"), new ErrorMessage(1700, "F\u00fcr folgende Mitarbeiter sind keine BG-Daten vorhanden:\n\n"), new ErrorMessage(1800, "Zu diesem Report sind keine Daten vorhanden."), new ErrorMessage(1801, "Es ist nur eine Zuordnung unterschiedlicher Konten zul\u00e4ssig"), new ErrorMessage(1802, "Es ist nur eine Zuordnung unterschiedlicher statistischer Werte zul\u00e4ssig"), new ErrorMessage(1803, "Bei Aktivierung des Zahlungsverkehrs ist die Auswahl Monats- und Jahreswerte f\u00fcr den Parameter Inhalt nicht erlaubt"), new ErrorMessage(1804, "Die Kombination Basis der Auswertung mit Spalte ist nicht zul\u00e4ssig."), new ErrorMessage(1805, "Die Eingabe des Familienkassenschl\u00fcssels (FAMKA-Schl\u00fcssel) in der Agentur f\u00fcr Arbeit der Firma bzw. der Betriebsst\u00e4tte fehlt.")});

    public static String toInfo(String[] messages) {
        StringBuilder b = new StringBuilder();
        b.append("Anzahl ").append(messages.length);
        for (String each : messages) {
            b.append(", ").append(each);
        }
        return b.toString();
    }

    public static void ignoredException(Throwable e) {
        ExceptionMapper.printException((Throwable)e);
    }

    public static AllCallback doThrowableCallback(Throwable t, AllCallback callback) {
        return ReportExceptionMapper.doThrowableCallback(t, callback, LOGGER);
    }

    public static AllCallback doThrowableCallback(Throwable t, AllCallback callback, Logger log) {
        while (t.getCause() != null) {
            log.debug(ExceptionMapper.toString((Throwable)t));
            t = t.getCause();
        }
        log.error(ExceptionMapper.toString((Throwable)t));
        if (t instanceof SystemException) {
            log.warn("callback disappeared [{}]", t);
            return null;
        }
        callback.setException(ReportExceptionMapper.asDatabaseExceptionStruct(t));
        return callback;
    }

    private static DatabaseExceptionStruct asDatabaseExceptionStruct(Throwable t) {
        if (t instanceof ApplicationException) {
            ApplicationException ae = (ApplicationException)t;
            return new DatabaseExceptionStruct(ExceptionUtils.getRootCauseMessage((Throwable)ae), "Programmfehler", "");
        }
        if (t instanceof DataAccessException) {
            DataAccessException pe = (DataAccessException)t;
            return new DatabaseExceptionStruct(ExceptionUtils.getStackTrace((Throwable)pe), pe.getMessage(), pe.getMostSpecificCause().getClass().getSimpleName() + ": " + pe.getMostSpecificCause().getMessage());
        }
        if (t instanceof BusinessDomainException) {
            BusinessDomainException de = (BusinessDomainException)t;
            return new DatabaseExceptionStruct(ExceptionUtils.getStackTrace((Throwable)de), de.getMessage(), "");
        }
        return new DatabaseExceptionStruct(t.toString(), "Programmfehler", ExceptionMapper.toString((Throwable)t));
    }

    public static BusinessDomainException makeNoCompanyAccountDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1501, (String)mErrorList.getDefaultString(1501));
    }

    public static BusinessDomainException makeMissingCurrencyDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)message, (String)"", (int)207, (String)(NO_REPORT_BUILD + mErrorList.getDefaultString(207) + message));
    }

    public static BusinessDomainException makeEffectiveTimepointIsEmptyDomainException(String method) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)method, (String)"", (int)100, (String)mErrorList.getDefaultString(100));
    }

    public static BusinessDomainException makeValidTimepointIsEmptyDomainException(String method) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)method, (String)"", (int)101, (String)mErrorList.getDefaultString(101));
    }

    public static BusinessDomainException makeValidFromIsEmptyDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)message, (String)"", (int)120, (String)mErrorList.getDefaultString(120));
    }

    public static BusinessDomainException makeValidUntillIsEmptyDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)message, (String)"", (int)121, (String)mErrorList.getDefaultString(121));
    }

    public static BusinessDomainException makeYearIsEmptyDomainException(String method) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)method, (String)"", (int)102, (String)mErrorList.getDefaultString(102));
    }

    public static BusinessDomainException makeWrongSortCriteriaChoiceTooMuchGeneralForThisAssortment() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)105, (String)mErrorList.getDefaultString(105));
    }

    public static BusinessDomainException makeWrongSortCriteriaChoiceNoPlantUseForThisAssortment() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)106, (String)mErrorList.getDefaultString(106));
    }

    public static BusinessDomainException makeWrongSortCriteriaChoiceTooMuchForThisAssortment() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)107, (String)mErrorList.getDefaultString(107));
    }

    public static BusinessDomainException makeWrongSortCriteriaNoUseEmployeeCircleForThisAssortment() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)108, (String)mErrorList.getDefaultString(108));
    }

    public static BusinessDomainException makeWrongSortCriteriaNoCostenterForThisAssortment() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)109, (String)mErrorList.getDefaultString(109));
    }

    public static BusinessDomainException makeWrongSortCriteriaNoCostunitForThisAssortment() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)110, (String)mErrorList.getDefaultString(110));
    }

    public static BusinessDomainException makeWrongSortCriteriaNoDepartmentForThisAssortment() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)111, (String)mErrorList.getDefaultString(111));
    }

    public static BusinessDomainException makeWrongSortCriteriaNoOrgunitForThisAssortment() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)112, (String)mErrorList.getDefaultString(112));
    }

    public static BusinessDomainException makeWrongSortCriteriaNoPersonInCharge1ForThisAssortment() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)113, (String)mErrorList.getDefaultString(113));
    }

    public static BusinessDomainException makeWrongSortCriteriaNoPersonInCharge2ForThisAssortment() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)114, (String)mErrorList.getDefaultString(114));
    }

    public static BusinessDomainException makeWrongSecondFilterCriteriaNoChoice() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)115, (String)mErrorList.getDefaultString(115));
    }

    public static BusinessDomainException makeNoEmployeeForThisAssortment() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)103, (String)mErrorList.getDefaultString(103));
    }

    public static boolean isNoEmployeeForThisAssortmentException(BusinessDomainException e) {
        return CLASS_GENERAL.equals(e.getDomain()) && 103 == e.getErrorNumber();
    }

    public static BusinessDomainException makeNoDataForCompanyTaxOffice() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)200, (String)mErrorList.getDefaultString(200));
    }

    public static BusinessDomainException makeNoNameForCompanyTaxOffice() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)202, (String)mErrorList.getDefaultString(202));
    }

    public static BusinessDomainException makeNoAccountForReport() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)104, (String)mErrorList.getDefaultString(104));
    }

    public static BusinessDomainException makeNoDataForStatmentOfContributionPaidReport() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)501, (String)mErrorList.getDefaultString(501));
    }

    public static BusinessDomainException makeNoDateEqualForPaidReport() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)504, (String)mErrorList.getDefaultString(504));
    }

    public static BusinessDomainException makeNoDataForPlantTaxOffice() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)201, (String)mErrorList.getDefaultString(201));
    }

    public static BusinessDomainException makeCompanyTaxNumberMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)210, (String)mErrorList.getDefaultString(210));
    }

    public static BusinessDomainException makeCompanyTaxOfficeDescriptionMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)211, (String)mErrorList.getDefaultString(211));
    }

    public static BusinessDomainException makeCompanyTaxOfficeNumberMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)212, (String)mErrorList.getDefaultString(212));
    }

    public static BusinessDomainException makePlantTaxNumberMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)220, (String)mErrorList.getDefaultString(220));
    }

    public static BusinessDomainException makePlantCompanyTaxNumberMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)234, (String)mErrorList.getDefaultString(234));
    }

    public static BusinessDomainException makePlantTaxOfficeDescriptionMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)221, (String)mErrorList.getDefaultString(221));
    }

    public static BusinessDomainException makePlantTaxOfficeNumberMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)222, (String)mErrorList.getDefaultString(222));
    }

    public static BusinessDomainException makeCompanyEmployeeOfficeMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)310, (String)mErrorList.getDefaultString(310));
    }

    public static BusinessDomainException makePlantEmployeeOfficeMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)320, (String)mErrorList.getDefaultString(320));
    }

    public static BusinessDomainException makeComphealthdundAccountNumberMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)400, (String)mErrorList.getDefaultString(400));
    }

    public static BusinessDomainException makeNoComphealthdundForHealthfundDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)404, (String)(mErrorList.getDefaultString(404) + message));
    }

    public static BusinessDomainException makePlantSettingsMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)203, (String)mErrorList.getDefaultString(203));
    }

    public static BusinessDomainException makeCompanySettingsMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)204, (String)(NO_REPORT_BUILD + mErrorList.getDefaultString(204)));
    }

    public static BusinessDomainException makeCompanySettingsMissingDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)204, (String)(NO_REPORT_BUILD + mErrorList.getDefaultString(204) + ": " + message));
    }

    public static BusinessDomainException makeNoPlantLawAreaDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)228, (String)(mErrorList.getDefaultString(228) + message));
    }

    public static BusinessDomainException makeNoPlantAdressDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)229, (String)(mErrorList.getDefaultString(229) + message));
    }

    public static BusinessDomainException makeNoPlantShortDescriptionDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)231, (String)mErrorList.getDefaultString(231));
    }

    public static BusinessDomainException makeNoPlantLongDescriptionDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)230, (String)mErrorList.getDefaultString(230));
    }

    public static BusinessDomainException makeNoPlantDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)232, (String)mErrorList.getDefaultString(232));
    }

    public static BusinessDomainException makeNoCompanyDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)217, (String)mErrorList.getDefaultString(217));
    }

    public static BusinessDomainException makeNoPlantKeyDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)233, (String)(mErrorList.getDefaultString(233) + message));
    }

    public static BusinessDomainException makeNoCompanyLongDescriptionDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)216, (String)mErrorList.getDefaultString(216));
    }

    public static BusinessDomainException makeNoCompanyAdressDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)215, (String)(mErrorList.getDefaultString(215) + message));
    }

    public static BusinessDomainException makePlantFoundationsMissingDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)205, (String)(mErrorList.getDefaultString(205) + message));
    }

    public static BusinessDomainException makeCompanyFoundationsMissingDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)206, (String)(mErrorList.getDefaultString(206) + message));
    }

    public static BusinessDomainException makeHealthfundAssessmentMissingDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)401, (String)(mErrorList.getDefaultString(401) + message));
    }

    public static BusinessDomainException makeNotCorrectEmployeeListsInStatementOfContributionDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)505, (String)mErrorList.getDefaultString(505));
    }

    public static BusinessDomainException makeNoBundesknappschaftAsHealthfundDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)402, (String)mErrorList.getDefaultString(403));
    }

    public static BusinessDomainException makeNoBundesknappschaftInComphealthfundDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)402, (String)mErrorList.getDefaultString(402));
    }

    public static BusinessDomainException makeMissingFaFilePathDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)602, (String)mErrorList.getDefaultString(602));
    }

    public static BusinessDomainException makeWrongAccountForTheNextAllocationsException(String[] str) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)601, (String)(mErrorList.getDefaultString(601) + ReportExceptionMapper.toInfo(str)));
    }

    public static BusinessDomainException makeStickyEmployeesInEmployeeForReport(String[] messages) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)701, (String)(mErrorList.getDefaultString(701) + ReportExceptionMapper.toInfo(messages)));
    }

    public static BusinessDomainException makeStickyEmployeesInEmployeeForReport(Collection<String> messages) {
        return ReportExceptionMapper.makeStickyEmployeesInEmployeeForReport(messages.toArray(new String[messages.size()]));
    }

    public static BusinessDomainException makeCostCenterMissingInCosting(String[] str) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)960, (String)(mErrorList.getDefaultString(960) + ReportExceptionMapper.toInfo(str)));
    }

    public static BusinessDomainException makeAccountHasNotCosting(String[] str) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)970, (String)(mErrorList.getDefaultString(970) + ReportExceptionMapper.toInfo(str)));
    }

    public static BusinessDomainException makeAccountHasCosting(String[] str) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)971, (String)(mErrorList.getDefaultString(971) + ReportExceptionMapper.toInfo(str)));
    }

    public static BusinessDomainException makeNoInsuranceData(String[] str) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)225, (String)(mErrorList.getDefaultString(225) + ReportExceptionMapper.toInfo(str)));
    }

    public static BusinessDomainException makeNoTaxData(String[] str) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)226, (String)(mErrorList.getDefaultString(226) + ReportExceptionMapper.toInfo(str)));
    }

    public static BusinessDomainException makeNoTaxDataForEmployee(String str) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)226, (String)(mErrorList.getDefaultString(226) + str));
    }

    public static BusinessDomainException makeColumnNotAssignmentCriteriaOfPCompanyDomainException(String column) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)801, (String)(mErrorList.getDefaultString(801) + column));
    }

    public static BusinessDomainException makeColumnMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)802, (String)mErrorList.getDefaultString(802));
    }

    public static BusinessDomainException makeMultiplyNoAssignmentsDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)809, (String)mErrorList.getDefaultString(809));
    }

    public static BusinessDomainException makeReportNameMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)803, (String)mErrorList.getDefaultString(803));
    }

    public static BusinessDomainException makeValueTypeAlreadyExistsDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)804, (String)mErrorList.getDefaultString(804));
    }

    public static BusinessDomainException makeColumnAlreadyExistsDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)805, (String)mErrorList.getDefaultString(805));
    }

    public static BusinessDomainException makeNoValueTypesFundDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)901, (String)mErrorList.getDefaultString(901));
    }

    public static BusinessDomainException makeNoAccountsFundDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)902, (String)mErrorList.getDefaultString(902));
    }

    public static BusinessDomainException makeNoStatValuesFundDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)903, (String)mErrorList.getDefaultString(903));
    }

    public static BusinessDomainException makeEmployeeNotJournalized(String[] str) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)702, (String)(mErrorList.getDefaultString(702) + ReportExceptionMapper.toInfo(str)));
    }

    public static BusinessDomainException makeEmployeeNotJournalized() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)704, (String)(NO_REPORT_BUILD + mErrorList.getDefaultString(704)));
    }

    public static BusinessDomainException makeNoDateEqualForSelfService() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)705, (String)mErrorList.getDefaultString(705));
    }

    public static BusinessDomainException makeWrongValidDateForSelfService() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)706, (String)mErrorList.getDefaultString(706));
    }

    public static BusinessDomainException makeEmployeeNotJournalized(String messag) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)704, (String)(mErrorList.getDefaultString(704) + messag));
    }

    public static BusinessDomainException makeValueTypeMissingDomainException(String ind) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"CostingReportPre.checkValueType", (String)"", (int)950, (String)(mErrorList.getDefaultString(950) + ind));
    }

    public static BusinessDomainException makeNoValuetypesDefinedForPrinting() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)118, (String)mErrorList.getDefaultString(118));
    }

    public static BusinessDomainException makeNoDefinedForResultAndFactor1(String[] str) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)119, (String)(mErrorList.getDefaultString(119) + ReportExceptionMapper.toInfo(str)));
    }

    public static BusinessDomainException makeThisEmployeesAreJournalizedBeforeThisYear(String[] str) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)703, (String)(mErrorList.getDefaultString(703) + ReportExceptionMapper.toInfo(str)));
    }

    public static BusinessDomainException makeMissingEmployeeCommunity(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)227, (String)(mErrorList.getDefaultString(227) + message));
    }

    public static BusinessDomainException makeNoAllocationsToUse() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)603, (String)mErrorList.getDefaultString(603));
    }

    public static BusinessDomainException makeValuetypesOnlyByCompany() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)604, (String)mErrorList.getDefaultString(604));
    }

    public static BusinessDomainException makeTransferdExportRates(String quantity) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1000, (String)(quantity + mErrorList.getDefaultString(1000)));
    }

    public static BusinessDomainException makeVweFaNotInUse() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1001, (String)mErrorList.getDefaultString(1001));
    }

    public static BusinessDomainException makeVweCoNotInUse() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1002, (String)mErrorList.getDefaultString(1002));
    }

    public static BusinessDomainException makeNoFaInUse() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1003, (String)mErrorList.getDefaultString(1003));
    }

    public static BusinessDomainException makeNoUseFirstReportFilterSelection() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)122, (String)mErrorList.getDefaultString(122));
    }

    public static BusinessDomainException makeNoUseFirstReportFilterBSBISelection() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)130, (String)mErrorList.getDefaultString(125));
    }

    public static BusinessDomainException makeNoUseSecondReportFilterSelection() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)123, (String)mErrorList.getDefaultString(123));
    }

    public static BusinessDomainException makeNoUseSecondReportFilterBSBISelection() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)125, (String)mErrorList.getDefaultString(125));
    }

    public static BusinessDomainException makeNoUseThirdReportFilterSelection() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)124, (String)mErrorList.getDefaultString(124));
    }

    public static BusinessDomainException makeNoUseThirdReportFilterBSBISelection() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)126, (String)mErrorList.getDefaultString(126));
    }

    public static BusinessDomainException makeOnlyCostCenterOrCostUnit() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)806, (String)mErrorList.getDefaultString(806));
    }

    public static BusinessDomainException makeNoEncryptionInArchive() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1004, (String)mErrorList.getDefaultString(1004));
    }

    public static BusinessDomainException makePlantFederalStateDateMissing() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)235, (String)mErrorList.getDefaultString(235));
    }

    public static BusinessDomainException makeCompanyFederalStateDateMissing() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)218, (String)mErrorList.getDefaultString(218));
    }

    public static BusinessDomainException makeSplittLumpsumCTMissing() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)208, (String)mErrorList.getDefaultString(208));
    }

    public static BusinessDomainException makePlantTaxOfficeAdressMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)236, (String)mErrorList.getDefaultString(236));
    }

    public static BusinessDomainException makeNoRepeatedEBSForKVDRDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)127, (String)mErrorList.getDefaultString(127));
    }

    public static BusinessDomainException makeNoRepeatedEBSForNotEqualSerialNumberDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)128, (String)(mErrorList.getDefaultString(128) + "\n" + message));
    }

    public static BusinessDomainException makeCompanyTaxOfficeAdressMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)219, (String)mErrorList.getDefaultString(219));
    }

    public static BusinessDomainException makeOnlyOneTaxTypeDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)807, (String)mErrorList.getDefaultString(807));
    }

    public static BusinessDomainException makeOnlyVorOrMehrwertsteuerDomainException(List<String> taxList) {
        Iterator<String> taxListIterator = taxList.iterator();
        Object taxString = "";
        while (taxListIterator.hasNext()) {
            String tempTaxString = taxListIterator.next();
            taxString = (String)taxString + tempTaxString + "\n";
        }
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)808, (String)(mErrorList.getDefaultString(808) + "\n" + (String)taxString));
    }

    public static BusinessDomainException makeNoHealthFundTPDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)405, (String)(mErrorList.getDefaultString(405) + message));
    }

    public static BusinessDomainException makeNoHealthFundByStdCompNrDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)406, (String)(mErrorList.getDefaultString(406) + message));
    }

    public static BusinessDomainException makeNoRepeatedEBSForJournalizedEmployeesDomainException(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)129, (String)(mErrorList.getDefaultString(129) + message));
    }

    public static BusinessDomainException makeNoEmployeeSelectedDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1502, (String)mErrorList.getDefaultString(1502));
    }

    public static BusinessDomainException makeEECarriedForwardOfEntryMissingYearOfCertificateOfWageTaxDeducation(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)237, (String)(NO_REPORT_BUILD + mErrorList.getDefaultString(237) + message));
    }

    public static BusinessDomainException makeEECarriedForwardOfEntryYearOfCertificateOfWageTaxDeducationNotCorrect(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)238, (String)(NO_REPORT_BUILD + mErrorList.getDefaultString(238) + message));
    }

    public static BusinessDomainException makeEECarriedForwardOfEntryMissingEmploymentFromOrUntil(String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)239, (String)(NO_REPORT_BUILD + mErrorList.getDefaultString(239) + message));
    }

    public static BusinessDomainException makeUseSettlementWagetax() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1100, (String)mErrorList.getDefaultString(1100));
    }

    public static BusinessDomainException makeNoStatisticValuePositions() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1101, (String)mErrorList.getDefaultString(1101));
    }

    public static BusinessDomainException makeOnlyThisMonthsForQuartal() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1102, (String)mErrorList.getDefaultString(1102));
    }

    public static BusinessDomainException makeOnlyThisMonthForYearly() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1103, (String)mErrorList.getDefaultString(1103));
    }

    public static BusinessDomainException makeNoPersonnalAccountForHealthfund(String errorList) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1200, (String)(mErrorList.getDefaultString(1200) + errorList));
    }

    public static BusinessDomainException makeNoReportBefore2011() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1300, (String)mErrorList.getDefaultString(1300));
    }

    public static BusinessDomainException makeNoStatisticalValue() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1400, (String)mErrorList.getDefaultString(1400));
    }

    public static BusinessDomainException makeSelectionMissing() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1503, (String)mErrorList.getDefaultString(1503));
    }

    public static BusinessDomainException makeDetailsMissing() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)150, (String)mErrorList.getDefaultString(150));
    }

    public static BusinessDomainException makeStockreprotPropertyNotLoad(String method, String field) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)method, (String)field, (int)1600, (String)(mErrorList.getDefaultString(1600) + field));
    }

    public static BusinessDomainException makeNoAccidentInsuranceFound(String[] str) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)1700, (String)(mErrorList.getDefaultString(1700) + ReportExceptionMapper.toInfo(str)));
    }

    public static BusinessDomainException makeNoDataFound() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1800, (String)mErrorList.getDefaultString(1800));
    }

    public static BusinessDomainException makeAccountAlreadyExists() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1801, (String)mErrorList.getDefaultString(1801));
    }

    public static BusinessDomainException makeStatisticalValueAlreadyExists() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1802, (String)mErrorList.getDefaultString(1802));
    }

    public static BusinessDomainException makeZvkTypeOfListNotAllowed() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1803, (String)mErrorList.getDefaultString(1803));
    }

    public static BusinessDomainException makeCombinationColumnBasisOfReportNotAllowed(ColumnEnum column, BasisOfReportEnum basisOfReport) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)("Basis der Auswertung: " + basisOfReport + "; Spalte: " + column), (int)1804, (String)(mErrorList.getDefaultString(1804) + "\nBasis der Auswertung: " + BasisOfReportEnumMapper.valueToString((int)basisOfReport.value()) + "\nSpalte: " + ColumnEnumMapper.valueToString((int)column.value())));
    }

    public static BusinessDomainException makeFamilyfundkeyIsMissing() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, (String)"", (int)1805, (String)mErrorList.getDefaultString(1805));
    }
}

