/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.journalofwageshortmonthly;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.CorbaExceptionMapper;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.employee.tax.mapper.ChurchTaxEnumMapper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundPersistencyManager;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.reports.ArchivingMetadata;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.StringComparator;
import com.varial.personnel.domain.reports.journalofwageshortmonthly.JournalOfWageShortMonthlyBean;
import com.varial.personnel.domain.reports.journalofwageshortmonthly.JournalOfWageShortMonthlySumBean;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.library.EmployerBean;
import com.varial.personnel.domain.reports.library.ReportEmployeesHandlingHelper;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.typeofvalue.consequenceofvaluetype.ConsequenceOfValueType;
import com.varial.personnel.framework.DateComparator;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.basictypes.PRestrictions;
import com.varial.personnel.persistency.calculation.calculationbasic.CalculationbasicContainer;
import com.varial.personnel.persistency.employee.employment.EmploymentContainer;
import com.varial.personnel.persistency.employee.insurance.IInsuranceDao;
import com.varial.personnel.persistency.employee.insurance.InsuranceContainer;
import com.varial.personnel.persistency.employee.masterall.IMasterallDao;
import com.varial.personnel.persistency.employee.masterall.MasterallContainer;
import com.varial.personnel.persistency.employee.tax.ITaxDao;
import com.varial.personnel.persistency.employee.tax.TaxContainer;
import com.varial.personnel.persistency.employee.valueposition.IValuepositionDao;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.personnel.persistency.plant.plantfoundations.IPlantfoundationsDao;
import com.varial.personnel.persistency.plant.plantfoundations.PlantfoundationsContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallback;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JournalOfWageShortMonthlyReportDataSource
implements JRDataSource {
    private static final IInsuranceDao daoInsurance = (IInsuranceDao)UtilitiesManager.getBean((String)"insuranceDao", IInsuranceDao.class);
    private static final IMasterallDao daoMasterall = (IMasterallDao)UtilitiesManager.getBean((String)"masterallDao", IMasterallDao.class);
    private static final ITaxDao daoTax = (ITaxDao)UtilitiesManager.getBean((String)"taxDao", ITaxDao.class);
    private static final IValuepositionDao daoValueposition = (IValuepositionDao)UtilitiesManager.getBean((String)"valuepositionDao", IValuepositionDao.class);
    private static final IPlantfoundationsDao daoPlantfoundations = (IPlantfoundationsDao)UtilitiesManager.getBean((String)"plantfoundationsDao", IPlantfoundationsDao.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(JournalOfWageShortMonthlyReportDataSource.class);
    private final ReportHelper mReportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);
    private static final int mMaximumReportHeaderPlantDescription = 40;
    private static final String mCurrency = "EUR";
    private static final String PARAMETER_USER = "Parameter_User";
    private static final String PARAMETER_CURRENCY = "Parameter_Currency";
    private static final String staticText_internalUse = "internalUse";
    private static final String PARAMETER_AUSSICHT = "PARAMETER_AUSSICHT";
    private final String mVersion;
    private String mCurrentOidPlant = "";
    private String mCurrentOidPlantTemp = "";
    private String mCurrentOidPCompany = "";
    private String mCurrentOidPCompanyTemp = "";
    private String mCurrentSortCriteriaKey = "";
    private String mCurrentSortCriteriaKeyTemp = "";
    private String mPCompanyReportHeaderKeyDescription = "";
    private final InternalHistoryBean mHistory = new InternalHistoryBean();
    private final Map<String, HealthFund> mHealthFundMap = new HashMap<String, HealthFund>();
    private final CompanySettings mCompanySettings;
    private final PCompany mPCompany;
    private final Date mCalculationStartDate;
    private boolean mLastRun = false;
    private boolean mPrintCurrentEmployee = false;
    private boolean mFirstPurchase = true;
    private boolean mRetroActiveEmplPageChange = false;
    private final boolean mInternalUse;
    private final boolean mPCompanyHasPlants;
    private int mSortCriteria = 0;
    private String FIELD_seitenwechsel = "Seitenwechesl_1";
    private final List<EmployeeJournalOfWageShortMonthly> mEmployeeForReportSortedli;
    private final Iterator<EmployeeJournalOfWageShortMonthly> mEmployeeWageTaxEFRit;
    private final Map<String, JournalOfWageShortMonthlySumBean> mSumBeanHashMap = new HashMap<String, JournalOfWageShortMonthlySumBean>();
    private final String[] mResultOidEmployee;
    private final String[] mResultOidPlant;
    protected String[] mValueTypeNumbers = new String[]{"100100", "100910", "100920", "100930", "100940", "100950", "100960", "100970", "110000", "110590", "130000", "130590", "145110", "145160", "145170", "145210", "145215", "145220", "145225", "145310", "145320", "145360", "145370", "220010", "220050", "223050", "226010", "230510", "230520", "250510", "250610", "320510", "320520", "321050", "322050", "323050", "327050", "328050", "329050", "333050", "334050", "335050", "339050", "340050", "341050", "350510", "351050", "355050", "360050", "361050", "366050", "401100", "401150", "401300", "401350", "700000", "702000", "710010", "710020", "736300", "760100", "760110", "760120", "760130", "760400", "760410", "760420", "760430", "760450", "760460", "760470", "760480", "770020", "770025", "770030", "770035", "770040", "770045", "770050", "770055", "770120", "770130", "770140", "771020", "771030", "771040", "771050", "771120", "771130", "771140", "772100", "775050", "860000", "861000", "862000", "863000", "870000", "871000", "886200", "890000", "890100"};
    private final int mForYear;
    private final Date mForEffectiveDate;
    private final Date mForValidDate;
    private Date mListFirstDate;
    private final Date mListEndDate;
    private final String mStaticText_internalUse;
    private final String mUser;
    private String FIELD_STATUS = "";
    private String FIELD_MONAT_JAHR = "";
    private String FIELD_MONAT = "";
    private String FIELD_PLANT_KEY = "";
    private String FIELD_BETRIEBSSTAETTE = "";
    private String FIELD_SORT_CRITERIA = "";
    private String FIELD_SORT_CRITERIA_DESCRIPTION = "";
    private String FIELD_SORT_CRITERIA_KEY = "";
    private String FIELD_DATUMJAHR = "";
    private String FIELD_PERSONAL_NR = "";
    private String FIELD_NAME = "";
    private String FIELD_VORNAME = "";
    private String FIELD_KRANKENKASSE = "";
    private String FIELD_BEITR_GP_KV = "";
    private String FIELD_BEITR_GP_RV = "";
    private String FIELD_BEITR_GP_AV = "";
    private String FIELD_BEITR_GP_PV = "";
    private String FIELD_PARENT = "";
    private String FIELD_STEUERKLASSE = "";
    private String FIELD_STEUERTABELLE = "";
    private String FIELD_STEUERFAKTOR = "";
    private String FIELD_ZKF = "";
    private String FIELD_RELI_AN = "";
    private String FIELD_RELI_EG = "";
    private String FIELD_GFB = "";
    private String FIELD_GRV = "";
    private String FIELD_MFB = "";
    private String FIELD_RK = "";
    private String FIELD_ZEITRAUMVON = "";
    private String FIELD_ZEITRAUMBIS = "";
    private String FIELD_MTL_FREIB = "";
    private String FIELD_JHL_FREIB = "";
    private String FIELD_VBZ = "";
    private String FIELD_AE = "";
    private String FIELD_PGS = "";
    private String temp_FIELD_MONAT = "";
    private String temp_FIELD_PLANT_KEY = "";
    private String temp_FIELD_BETRIEBSSTAETTE = "";
    private String temp_FIELD_SORT_CRITERIA = "";
    private String temp_FIELD_SORT_CRITERIA_DESCRIPTION = "";
    private String temp_FIELD_SORT_CRITERIA_KEY = "";
    private String temp_FIELD_DATUMJAHR = "";
    private BigDecimal FIELD_ST_TAGE = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_SV_TAGE = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_GESAMT_BRUTTO = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_LOHNSTEUER = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KV_ENTGELT = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_RV_ENTGELT = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AV_ENTGELT = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_PV_ENTGELT = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KV_AGZ = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_UMLAGE_ENTGELT = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_GESETZLICHE_ABZUEGE = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_VWL = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AN_PAUSCHAL = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AG_PAUSCHAL = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_GFB_PAUSCHAL = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_ZVK_ANA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_STEUER_BRUTTO = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KIST = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KV_ANA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_RV_ANA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AV_ANA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_PV_ANA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_RV_AGZ = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_UMLAGE_BEITRAG = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_NETTOLOHN = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KAMMER = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AG_KOSTEN = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_SV_BRUTTO = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_SOLIDARITAETSZUSCHLAG = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KV_AGA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_RV_AGA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AV_AGA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_PV_AGA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_PV_AGZ = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_INSG_UMLAGE = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_BE_ABZUEGE = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KUG = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_ZVK_AGA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AUSZAHLUNG = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_BAV_AG_KOSTEN = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_gesamt_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_lst = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_rv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_av_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_pv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_u_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_gesetzl_abz = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_vwl = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_an_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_zvk_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_steuer_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kist = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_rv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_av_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_pv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_rv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_u_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_nettolohn = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kammer = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_ag_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_gfb_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_ag_kosten = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_sv_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_solz = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_rv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_av_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_pv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_pv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_insg_umlage = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_bezuege_abzuege = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kug = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_zvk_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_auszahlung = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_gesamt_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_lst = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_rv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_av_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_pv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_u_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_gesetzl_abz = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_vwl = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_an_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_zvk_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_steuer_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kist = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_rv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_av_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_pv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_rv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_u_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_nettolohn = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kammer = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_ag_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_gfb_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_ag_kosten = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_sv_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_solz = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_rv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_av_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_pv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_pv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_insg_umlage = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_bezuege_abzuege = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kug = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_zvk_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_auszahlung = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_gesamt_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_lst = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_kv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_rv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_av_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_pv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_kv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_u_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_gesetzl_abz = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_vwl = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_an_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_zvk_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_steuer_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_kist = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_kv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_rv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_av_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_pv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_rv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_u_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_nettolohn = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_kammer = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_ag_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_gfb_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_ag_kosten = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_sv_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_solz = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_kv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_rv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_av_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_pv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_pv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_insg_umlage = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_bezuege_abzuege = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_kug = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_zvk_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal temp_summe_auszahlung = BigDecimal.valueOf(0L, 2);
    private final List<JournalOfWageShortMonthlyBean> mSubreportDetailCollection = new LinkedList<JournalOfWageShortMonthlyBean>();
    private final List<JournalOfWageShortMonthlyBean> mSubreportDetailCollection_temp = new LinkedList<JournalOfWageShortMonthlyBean>();

    public JournalOfWageShortMonthlyReportDataSource(AllCallback callback, ISpecialAccessPersistencyContext specialAccessPersistencyContext, ReportFirstFilterStruct reportFirstFilterStruct, ReportSecondFilterStruct[] reportSecondFilterStruct, ReportThirdFilterStruct reportThirdFilterStruct, ReportSortStruct[] reportSortSeq, Date forEffectiveDate, Date forValidDate, boolean internalUse, List<String> errorList) throws BusinessDomainException {
        this.mUser = SessionContext.getInstance().getSession().getUserCode();
        this.mVersion = Version.getVersion();
        this.mForYear = new VDate(forValidDate).getYear();
        this.mListFirstDate = DateHelper.getFirstDayOfMonth((Date)forValidDate);
        this.mListEndDate = DateHelper.getLastDayOfMonth((Date)forValidDate);
        this.mForEffectiveDate = DateHelper.getLastDayOfMonth((Date)forEffectiveDate);
        this.mForValidDate = DateHelper.getLastDayOfMonth((Date)forValidDate);
        this.mInternalUse = internalUse;
        String string = this.mStaticText_internalUse = this.mInternalUse ? "Interner Gebrauch" : "";
        if (reportSortSeq != null && reportSortSeq.length > 3) {
            throw ReportExceptionMapper.makeWrongSortCriteriaChoiceTooMuchGeneralForThisAssortment();
        }
        String filterStructOidPcompany = ReportHelper.getOidPcompany((ReportFirstFilterStruct)reportFirstFilterStruct, (ReportSecondFilterStruct[])reportSecondFilterStruct, (ReportThirdFilterStruct)reportThirdFilterStruct);
        this.mPCompany = PCompanyPersistencyManager.getPCompany((String)filterStructOidPcompany);
        Foundations foundations = this.mPCompany.getCompanyFoundations(this.mForEffectiveDate, this.mForValidDate).getFoundations();
        this.mPCompanyReportHeaderKeyDescription = foundations.getLongDescription();
        this.mPCompanyReportHeaderKeyDescription = StringMapper.isNullString((String)this.mPCompanyReportHeaderKeyDescription) ? foundations.getShortDescription() : this.mPCompanyReportHeaderKeyDescription;
        String pCompanyKey = this.mPCompany.getPCompanyKey();
        this.mPCompanyReportHeaderKeyDescription = StringMapper.isNullString((String)pCompanyKey) ? this.mPCompanyReportHeaderKeyDescription : pCompanyKey + " / " + this.mPCompanyReportHeaderKeyDescription;
        this.mPCompanyReportHeaderKeyDescription = this.mPCompanyReportHeaderKeyDescription.length() > 42 ? this.mPCompanyReportHeaderKeyDescription.substring(0, 42) : this.mPCompanyReportHeaderKeyDescription;
        this.mCompanySettings = this.mPCompany.getCompanySettings(forEffectiveDate, forValidDate);
        if (this.mCompanySettings == null) {
            throw ReportExceptionMapper.makeCompanySettingsMissingDomainException();
        }
        this.mPCompanyHasPlants = this.mCompanySettings.getUsePlants();
        int sortCount = 0;
        if (reportSortSeq != null) {
            for (ReportSortStruct reportSort : reportSortSeq) {
                int criteriaValue = reportSort.criteria.value();
                if (criteriaValue == 2 && !this.mPCompanyHasPlants) {
                    throw ReportExceptionMapper.makeWrongSortCriteriaChoiceNoPlantUseForThisAssortment();
                }
                if (criteriaValue == 1 && criteriaValue == 2) continue;
                if (++sortCount > 1) {
                    throw ReportExceptionMapper.makeWrongSortCriteriaChoiceTooMuchForThisAssortment();
                }
                switch (criteriaValue) {
                    case 3: {
                        if (this.mCompanySettings.getUseEmployeeCircle()) break;
                        throw ReportExceptionMapper.makeWrongSortCriteriaNoUseEmployeeCircleForThisAssortment();
                    }
                    case 6: {
                        if (this.mCompanySettings.getUseCostCenter()) break;
                        throw ReportExceptionMapper.makeWrongSortCriteriaNoCostenterForThisAssortment();
                    }
                    case 7: {
                        if (this.mCompanySettings.getUseCostUnit()) break;
                        throw ReportExceptionMapper.makeWrongSortCriteriaNoCostunitForThisAssortment();
                    }
                    case 8: {
                        if (this.mCompanySettings.getUseDepartment()) break;
                        throw ReportExceptionMapper.makeWrongSortCriteriaNoDepartmentForThisAssortment();
                    }
                    case 9: {
                        if (this.mCompanySettings.getUseOrgUnit()) break;
                        throw ReportExceptionMapper.makeWrongSortCriteriaNoOrgunitForThisAssortment();
                    }
                    case 10: {
                        if (this.mCompanySettings.getUsePersonInCharge1()) break;
                        throw ReportExceptionMapper.makeWrongSortCriteriaNoPersonInCharge1ForThisAssortment();
                    }
                    case 11: {
                        if (this.mCompanySettings.getUsePersonInCharge2()) break;
                        throw ReportExceptionMapper.makeWrongSortCriteriaNoPersonInCharge2ForThisAssortment();
                    }
                }
                this.mSortCriteria = criteriaValue;
            }
        }
        EmployeeForReportGenerator generator = new EmployeeForReportGenerator(specialAccessPersistencyContext, reportFirstFilterStruct, reportSecondFilterStruct, reportThirdFilterStruct, reportSortSeq, forEffectiveDate, DateHelper.getFirstDayOfMonth((Date)forValidDate), DateHelper.getLastDayOfMonth((Date)forValidDate), errorList);
        EmployeeForReport[] efrs = generator.getEmployeesForReport();
        if (!errorList.isEmpty()) {
            String[] messages = errorList.toArray(new String[errorList.size()]);
            EmployeeForReport[] de = ReportExceptionMapper.makeStickyEmployeesInEmployeeForReport(messages);
            errorList.clear();
            if (internalUse) {
                callback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de));
            } else {
                throw de;
            }
        }
        this.mCalculationStartDate = this.mReportHelper.getCalculationStartDate(this.mPCompany.getCompanyFoundations(this.mForEffectiveDate, this.mListEndDate));
        this.mListFirstDate = DateHelper.max((Date)this.mListFirstDate, (Date)this.mCalculationStartDate);
        this.FIELD_MONAT = ReportHelper.getMonthDescription((int)new VDate(this.mListFirstDate).getMonth());
        LinkedList<EmployeeForReport> listEmployeeForReport = new LinkedList<EmployeeForReport>();
        for (EmployeeForReport efr : efrs) {
            if (!DateHelper.beforeOrEqual((Date)efr.getEmploymentEffectiveFrom(), (Date)this.mForEffectiveDate) || !DateHelper.afterOrEqual((Date)efr.getEmploymentEffectiveUntil(), (Date)this.mForEffectiveDate) || !DateHelper.beforeOrEqual((Date)efr.getEmploymentValidFrom(), (Date)this.mListEndDate) || !DateHelper.afterOrEqual((Date)efr.getEmploymentValidUntil(), (Date)this.mListFirstDate)) continue;
            listEmployeeForReport.add(efr);
        }
        efrs = new EmployeeForReport[listEmployeeForReport.size()];
        if ((efrs = listEmployeeForReport.toArray(efrs)).length == 0) {
            throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
        }
        this.mResultOidEmployee = new String[efrs.length];
        HashSet<String> oidPlants = new HashSet<String>();
        for (int i = 0; i < efrs.length; ++i) {
            this.mResultOidEmployee[i] = efrs[i].getOidEmployee();
            String oidPlant = efrs[i].getOidPlant();
            if (!this.mPCompanyHasPlants || StringMapper.isNullString((String)oidPlant)) continue;
            oidPlants.add(oidPlant);
        }
        this.mResultOidPlant = oidPlants.toArray(new String[oidPlants.size()]);
        Map<String, List<MasterallContainer>> masterAllHM = this.getMasterallHistoryForEmployees(this.mResultOidEmployee, this.mForEffectiveDate, this.mListFirstDate, this.mListEndDate);
        Map<String, List<InsuranceContainer>> insuranceHM = this.getInsuranceHistoryForEmployees(this.mResultOidEmployee, this.mForEffectiveDate, this.mListFirstDate, this.mListEndDate);
        Map<String, List<TaxContainer>> taxHM = this.getTaxHistoryForExployees(this.mResultOidEmployee, this.mForEffectiveDate, this.mListFirstDate, this.mListEndDate);
        if (this.mResultOidPlant.length > 0) {
            Map<String, List<PlantfoundationsContainer>> plantfoundationHM = this.getPlantFoundationsHistoryForEmployees(this.mForEffectiveDate, this.mListFirstDate, this.mListEndDate);
            this.mHistory.setPlantFoundation(plantfoundationHM);
        }
        this.mHistory.setMasterAll(masterAllHM);
        this.mHistory.setInsurance(insuranceHM);
        this.mHistory.setTax(taxHM);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("mForEffectiveDate= {}mListFirstDate={}mListEndDate={}", new Object[]{this.mForEffectiveDate, this.mListFirstDate, this.mListEndDate});
        }
        Map calculationBasicMap = ReportEmployeesHandlingHelper.getHashMapCalculationBasic((String[])this.mResultOidEmployee, (Date)this.mForEffectiveDate, (Date)this.mListFirstDate);
        Map<String, List<EmployeeJournalOfWageShortMonthly>> pCompanyPlantEFRMap = new HashMap<String, List<EmployeeJournalOfWageShortMonthly>>();
        for (EmployeeForReport currentEmployee : efrs) {
            String currentOidEmployee = currentEmployee.getOidEmployee();
            Date currentEmployeeEndDate = currentEmployee.getDateOfWithDrawal() == null ? currentEmployee.getEmploymentValidUntil() : (PDateHelper.getDiffInMonths((Date)this.mListEndDate, (Date)currentEmployee.getDateOfWithDrawal()) > 0 ? this.mListEndDate : currentEmployee.getDateOfWithDrawal());
            Date currentEmployeeFirstDate = DateHelper.max((Date)currentEmployee.getDateOfEntry(), (Date)this.mListFirstDate);
            currentEmployeeEndDate = DateHelper.min((Date)currentEmployeeEndDate, (Date)this.mListEndDate);
            Date employeeStartDate = new VDate(currentEmployeeFirstDate).getDate();
            InternalEmployeeBean employeeHashMap = new InternalEmployeeBean();
            employeeHashMap.setCurrent(currentEmployee);
            employeeHashMap.setHistory(this.mHistory);
            boolean containerDateMoving = true;
            while (containerDateMoving) {
                employeeHashMap.setStartDate(employeeStartDate);
                EmployeeJournalOfWageShortMonthly eWT = this.getEmployeeProperties(employeeHashMap, this.mForEffectiveDate, this.mListFirstDate);
                if (DateHelper.before((Date)currentEmployeeEndDate, (Date)currentEmployeeFirstDate) || currentEmployee.getDateOfWithDrawal() != null && PDateHelper.getDiffInMonths((Date)this.mListEndDate, (Date)currentEmployee.getDateOfWithDrawal()) > 0 && !this.getValuesToPayment(eWT.getValuePositionli(), currentEmployeeFirstDate, currentEmployeeEndDate)) {
                    eWT.setEmployeeToBeRegarded(false);
                } else {
                    eWT.setEmployeeToBeRegarded(true);
                }
                Date containerTempDate = this.getNextcontainerTempDate(eWT, currentEmployeeEndDate);
                eWT.setEmployeeStartDate(employeeStartDate);
                eWT.setEmployeeEndDate(containerTempDate);
                if (DateHelper.afterOrEqual((Date)containerTempDate, (Date)currentEmployeeEndDate)) {
                    containerDateMoving = false;
                    eWT.setEmployeeEndDate(currentEmployeeEndDate);
                }
                Date[] retroactiveCorrectionDates = new Date[2];
                if (DateHelper.equal((Date)this.mForEffectiveDate, (Date)this.mForValidDate)) {
                    retroactiveCorrectionDates = this.getRetroactiveCorrectionDates(currentOidEmployee, employeeStartDate, calculationBasicMap, masterAllHM);
                }
                if (retroactiveCorrectionDates[0] != null && retroactiveCorrectionDates[1] != null) {
                    Date retroactiveCorrectionValidFrom = DateHelper.getFirstDayOfMonth((Date)retroactiveCorrectionDates[0]);
                    retroactiveCorrectionValidFrom = DateHelper.max((Date)retroactiveCorrectionValidFrom, (Date)this.mCalculationStartDate);
                    Date journalizedUntil = DateHelper.getFirstDayOfMonth((Date)retroactiveCorrectionDates[1]);
                    Date oldEffectiveDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate));
                    EmployeeForReport oldRetroactiveCorrectionEFR = EmployeeForReportGenerator.createNew((EmployeeForReport)eWT.getEmployeeForReport());
                    EmployeeForReport newRetroactiveCorrectionEFR = EmployeeForReportGenerator.createNew((EmployeeForReport)eWT.getEmployeeForReport());
                    String[] oidEmployeeArray = new String[]{eWT.getEmployeeForReport().getOidEmployee()};
                    HashMap<String, OldNewValues> oldNewValuesMap = new HashMap<String, OldNewValues>();
                    InternalHistoryBean oldRetroActiveCorrectionHashMapsAllHM = this.getHashMaps(oidEmployeeArray, oldEffectiveDate, DateHelper.getFirstDayOfMonth((Date)retroactiveCorrectionValidFrom), DateHelper.getLastDayOfMonth((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))));
                    InternalHistoryBean newRetroActiveCorrectionHashMapsAllHM = this.getHashMaps(oidEmployeeArray, this.mForEffectiveDate, DateHelper.getFirstDayOfMonth((Date)retroactiveCorrectionValidFrom), DateHelper.getLastDayOfMonth((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))));
                    if (DateHelper.afterOrEqual((Date)journalizedUntil, (Date)DateHelper.getFirstDayOfMonth((Date)this.mListEndDate))) {
                        journalizedUntil = DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mListEndDate)));
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("retroactiveCorrectionValidFrom={} journalizedUntil={}", (Object)retroactiveCorrectionValidFrom, (Object)journalizedUntil);
                    }
                    while (DateHelper.beforeOrEqual((Date)retroactiveCorrectionValidFrom, (Date)journalizedUntil)) {
                        employeeStartDate = retroactiveCorrectionValidFrom;
                        employeeHashMap.setCurrent(oldRetroactiveCorrectionEFR);
                        employeeHashMap.setHistory(oldRetroActiveCorrectionHashMapsAllHM);
                        employeeHashMap.setStartDate(employeeStartDate);
                        EmployeeJournalOfWageShortMonthly eWTOld = this.getEmployeeProperties(employeeHashMap, DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate)), retroactiveCorrectionValidFrom);
                        employeeHashMap.setCurrent(newRetroactiveCorrectionEFR);
                        employeeHashMap.setHistory(newRetroActiveCorrectionHashMapsAllHM);
                        employeeHashMap.setStartDate(employeeStartDate);
                        EmployeeJournalOfWageShortMonthly eWTNew = this.getEmployeeProperties(employeeHashMap, this.mForEffectiveDate, retroactiveCorrectionValidFrom);
                        this.resetDataEmployee();
                        this.getDataFor(eWTOld);
                        Map<String, String> eWTOldStringValuesMap = this.getStringValuesMap();
                        Map<String, BigDecimal> eWTOldBigDecimalValuesMap = this.getBigDecimalValuesMap();
                        this.resetDataEmployee();
                        this.getDataFor(eWTNew);
                        Map<String, String> eWTNewStringValuesMap = this.getStringValuesMap();
                        Map<String, BigDecimal> eWTNewBigDecimalValuesMap = this.getBigDecimalValuesMap();
                        this.resetDataEmployee();
                        this.resetDataSumme();
                        OldNewValues actualOldNewValues = new OldNewValues();
                        actualOldNewValues.ewtOld = eWTOld;
                        actualOldNewValues.ewtOldStringValuesMap = eWTOldStringValuesMap;
                        actualOldNewValues.ewtOldBigDecimalValuesMap = eWTOldBigDecimalValuesMap;
                        actualOldNewValues.ewtNew = eWTNew;
                        actualOldNewValues.ewtNewStringValuesMap = eWTNewStringValuesMap;
                        actualOldNewValues.ewtNewBigDecimalValuesMap = eWTNewBigDecimalValuesMap;
                        actualOldNewValues.compareOldNewValues();
                        if (!actualOldNewValues.areEqual) {
                            String year = Integer.toString(new VDate(retroactiveCorrectionValidFrom).getYear());
                            Object month = new VDate(retroactiveCorrectionValidFrom).getMonth() < 10 ? "0" + Integer.toString(new VDate(retroactiveCorrectionValidFrom).getMonth()) : Integer.toString(new VDate(retroactiveCorrectionValidFrom).getMonth());
                            oldNewValuesMap.put(year + (String)month, actualOldNewValues);
                            eWT.setOldNewValuesMap(oldNewValuesMap);
                        }
                        retroactiveCorrectionValidFrom = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)retroactiveCorrectionValidFrom));
                    }
                }
                if (eWT.getOldNewValuesMap() != null || eWT.getEmployeeToBeRegarded()) {
                    pCompanyPlantEFRMap = this.setEmployeeForPropperEFR(eWT.createNew(), pCompanyPlantEFRMap);
                }
                employeeStartDate = DateHelper.tomorrow((Date)containerTempDate);
            }
        }
        this.mEmployeeForReportSortedli = this.sortEmployeeForReport(pCompanyPlantEFRMap);
        if (this.mEmployeeForReportSortedli.isEmpty()) {
            throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
        }
        this.mEmployeeWageTaxEFRit = this.mEmployeeForReportSortedli.iterator();
    }

    private List<EmployeeJournalOfWageShortMonthly> sortEmployeeForReport(Map<String, List<EmployeeJournalOfWageShortMonthly>> pCompanyPlantEFRMap) {
        LinkedList<EmployeeJournalOfWageShortMonthly> employeeWageTaxEFRli = new LinkedList<EmployeeJournalOfWageShortMonthly>();
        LinkedList<String> pCompanyPlantEFRMapli = new LinkedList<String>(pCompanyPlantEFRMap.keySet());
        Collections.sort(pCompanyPlantEFRMapli, new StringComparator());
        for (String key : pCompanyPlantEFRMapli) {
            List<EmployeeJournalOfWageShortMonthly> plantList = pCompanyPlantEFRMap.get(key);
            employeeWageTaxEFRli.addAll(plantList);
        }
        return employeeWageTaxEFRli;
    }

    private Map<String, List<EmployeeJournalOfWageShortMonthly>> setEmployeeForPropperEFR(EmployeeJournalOfWageShortMonthly eWT, Map<String, List<EmployeeJournalOfWageShortMonthly>> pCompanyPlantEFRMap) {
        EmployeeForReport eFR = eWT.getEmployeeForReport();
        Object key = !StringMapper.isNullString((String)eFR.getOidPlant()) && this.mPCompanyHasPlants ? eWT.getPlantKey() + eWT.getPlantDescription() : "";
        List<EmployeeJournalOfWageShortMonthly> plantList = pCompanyPlantEFRMap.get(key);
        if (plantList == null) {
            plantList = new LinkedList<EmployeeJournalOfWageShortMonthly>();
            pCompanyPlantEFRMap.put((String)key, plantList);
        }
        plantList.add(eWT);
        return pCompanyPlantEFRMap;
    }

    private void resetDataSumme() {
        this.summe_gesamt_brutto = BigDecimal.ZERO;
        this.summe_lst = BigDecimal.ZERO;
        this.summe_kv_entgelt = BigDecimal.ZERO;
        this.summe_rv_entgelt = BigDecimal.ZERO;
        this.summe_av_entgelt = BigDecimal.ZERO;
        this.summe_pv_entgelt = BigDecimal.ZERO;
        this.summe_kv_agz = BigDecimal.ZERO;
        this.summe_u_entgelt = BigDecimal.ZERO;
        this.summe_gesetzl_abz = BigDecimal.ZERO;
        this.summe_vwl = BigDecimal.ZERO;
        this.summe_an_pauschal = BigDecimal.ZERO;
        this.summe_zvk_ana = BigDecimal.ZERO;
        this.summe_steuer_brutto = BigDecimal.ZERO;
        this.summe_kist = BigDecimal.ZERO;
        this.summe_kv_ana = BigDecimal.ZERO;
        this.summe_rv_ana = BigDecimal.ZERO;
        this.summe_av_ana = BigDecimal.ZERO;
        this.summe_pv_ana = BigDecimal.ZERO;
        this.summe_rv_agz = BigDecimal.ZERO;
        this.summe_u_beitrag = BigDecimal.ZERO;
        this.summe_nettolohn = BigDecimal.ZERO;
        this.summe_kammer = BigDecimal.ZERO;
        this.summe_ag_pauschal = BigDecimal.ZERO;
        this.summe_gfb_pauschal = BigDecimal.ZERO;
        this.summe_ag_kosten = BigDecimal.ZERO;
        this.summe_sv_brutto = BigDecimal.ZERO;
        this.summe_solz = BigDecimal.ZERO;
        this.summe_kv_aga = BigDecimal.ZERO;
        this.summe_rv_aga = BigDecimal.ZERO;
        this.summe_av_aga = BigDecimal.ZERO;
        this.summe_pv_aga = BigDecimal.ZERO;
        this.summe_pv_agz = BigDecimal.ZERO;
        this.summe_insg_umlage = BigDecimal.ZERO;
        this.summe_bezuege_abzuege = BigDecimal.ZERO;
        this.summe_kug = BigDecimal.ZERO;
        this.summe_zvk_aga = BigDecimal.ZERO;
        this.summe_auszahlung = BigDecimal.ZERO;
    }

    private Map<String, String> getStringValuesMap() {
        HashMap<String, String> strings = new HashMap<String, String>();
        strings.put("FIELD_MONAT", this.FIELD_MONAT);
        strings.put("FIELD_PERSONAL_NR", this.FIELD_PERSONAL_NR);
        strings.put("FIELD_NAME", this.FIELD_NAME);
        strings.put("FIELD_VORNAME", this.FIELD_VORNAME);
        strings.put("FIELD_DATUMJAHR", this.FIELD_DATUMJAHR);
        strings.put("FIELD_PLANT_KEY", this.FIELD_PLANT_KEY);
        strings.put("FIELD_BETRIEBSSTAETTE", this.FIELD_BETRIEBSSTAETTE);
        strings.put("FIELD_SORT_CRITERIA", this.FIELD_SORT_CRITERIA);
        strings.put("FIELD_SORT_CRITERIA_DESCRIPTION", this.FIELD_SORT_CRITERIA_DESCRIPTION);
        strings.put("FIELD_SORT_CRITERIA_KEY", this.FIELD_SORT_CRITERIA_KEY);
        strings.put("FIELD_KRANKENKASSE", this.FIELD_KRANKENKASSE);
        strings.put("FIELD_BEITR_GP_KV", this.FIELD_BEITR_GP_KV);
        strings.put("FIELD_BEITR_GP_RV", this.FIELD_BEITR_GP_RV);
        strings.put("FIELD_BEITR_GP_AV", this.FIELD_BEITR_GP_AV);
        strings.put("FIELD_BEITR_GP_PV", this.FIELD_BEITR_GP_PV);
        strings.put("FIELD_PARENT", this.FIELD_PARENT);
        strings.put("FIELD_GRV", this.FIELD_GRV);
        strings.put("FIELD_MFB", this.FIELD_MFB);
        strings.put("FIELD_RK", this.FIELD_RK);
        strings.put("FIELD_PGS", this.FIELD_PGS);
        strings.put("FIELD_STEUERKLASSE", this.FIELD_STEUERKLASSE);
        strings.put("FIELD_STEUERTABELLE", this.FIELD_STEUERTABELLE);
        strings.put("FIELD_STEUERFAKTOR", this.FIELD_STEUERFAKTOR);
        strings.put("FIELD_ZKF", this.FIELD_ZKF);
        strings.put("FIELD_RELI_AN", this.FIELD_RELI_AN);
        strings.put("FIELD_RELI_EG", this.FIELD_RELI_EG);
        strings.put("FIELD_GFB", this.FIELD_GFB);
        strings.put("FIELD_MTL_FREIB", this.FIELD_MTL_FREIB);
        strings.put("FIELD_JHL_FREIB", this.FIELD_JHL_FREIB);
        strings.put("FIELD_VBZ", this.FIELD_VBZ);
        strings.put("FIELD_AE", this.FIELD_AE);
        strings.put("FIELD_ZEITRAUMVON", this.FIELD_ZEITRAUMVON);
        strings.put("FIELD_ZEITRAUMBIS", this.FIELD_ZEITRAUMBIS);
        return strings;
    }

    private Map<String, BigDecimal> getBigDecimalValuesMap() {
        HashMap<String, BigDecimal> numbers = new HashMap<String, BigDecimal>();
        numbers.put("FIELD_GESAMT_BRUTTO", this.FIELD_GESAMT_BRUTTO);
        numbers.put("FIELD_LOHNSTEUER", this.FIELD_LOHNSTEUER);
        numbers.put("FIELD_KRANKENVERSICHERUNG_ENTGELT", this.FIELD_KV_ENTGELT);
        numbers.put("FIELD_RENTENVERSICHERUNG_ENTGELT", this.FIELD_RV_ENTGELT);
        numbers.put("FIELD_ARBEITSLOSENVERSICHERUNG_ENTGELT", this.FIELD_AV_ENTGELT);
        numbers.put("FIELD_PFLEGEVERSICHERUNG_ENTGELT", this.FIELD_PV_ENTGELT);
        numbers.put("FIELD_KRANKENVERSICHERUNG_AGZ", this.FIELD_KV_AGZ);
        numbers.put("FIELD_UMLAGE_ENTGELT", this.FIELD_UMLAGE_ENTGELT);
        numbers.put("FIELD_GESETZLICHE_ABZUEGE", this.FIELD_GESETZLICHE_ABZUEGE);
        numbers.put("FIELD_VWL", this.FIELD_VWL);
        numbers.put("FIELD_AN_PAUSCHAL", this.FIELD_AN_PAUSCHAL);
        numbers.put("FIELD_ZVK_ANA", this.FIELD_ZVK_ANA);
        numbers.put("FIELD_STEUER_BRUTTO", this.FIELD_STEUER_BRUTTO);
        numbers.put("FIELD_KIST", this.FIELD_KIST);
        numbers.put("FIELD_KV_ANA", this.FIELD_KV_ANA);
        numbers.put("FIELD_RV_ANA", this.FIELD_RV_ANA);
        numbers.put("FIELD_AV_ANA", this.FIELD_AV_ANA);
        numbers.put("FIELD_PV_ANA", this.FIELD_PV_ANA);
        numbers.put("FIELD_RV_AGZ", this.FIELD_RV_AGZ);
        numbers.put("FIELD_UMLAGE_BEITRAG", this.FIELD_UMLAGE_BEITRAG);
        numbers.put("FIELD_NETTOLOHN", this.FIELD_NETTOLOHN);
        numbers.put("FIELD_KAMMER", this.FIELD_KAMMER);
        numbers.put("FIELD_AG_PAUSCHAL", this.FIELD_AG_PAUSCHAL);
        numbers.put("FIELD_GFB_PAUSCHAL", this.FIELD_GFB_PAUSCHAL);
        numbers.put("FIELD_AG_KOSTEN", this.FIELD_AG_KOSTEN);
        numbers.put("FIELD_SV_BRUTTO", this.FIELD_SV_BRUTTO);
        numbers.put("FIELD_SOLIDARITAETSZUSCHLAG", this.FIELD_SOLIDARITAETSZUSCHLAG);
        numbers.put("FIELD_KV_AGA", this.FIELD_KV_AGA);
        numbers.put("FIELD_RV_AGA", this.FIELD_RV_AGA);
        numbers.put("FIELD_AV_AGA", this.FIELD_AV_AGA);
        numbers.put("FIELD_PV_AGA", this.FIELD_PV_AGA);
        numbers.put("FIELD_PV_AGZ", this.FIELD_PV_AGZ);
        numbers.put("FIELD_INSG_UMLAGE", this.FIELD_INSG_UMLAGE);
        numbers.put("FIELD_BE_ABZUEGE", this.FIELD_BE_ABZUEGE);
        numbers.put("FIELD_KUG", this.FIELD_KUG);
        numbers.put("FIELD_ZVK_AGA", this.FIELD_ZVK_AGA);
        numbers.put("FIELD_AUSZAHLUNG", BigDecimal.valueOf(0L, 2));
        numbers.put("FIELD_ST_TAGE", this.FIELD_ST_TAGE);
        numbers.put("FIELD_SV_TAGE", this.FIELD_SV_TAGE);
        return numbers;
    }

    private boolean getValuesToPayment(List<ValuepositionContainer> valuePositionli, Date employeeStartDate, Date employeeEndDate) {
        BigDecimal AUSZAHLUNG = BigDecimal.valueOf(0L, 2);
        if (valuePositionli != null) {
            for (ValuepositionContainer valuePositionContainer : valuePositionli) {
                if (!DateHelper.beforeOrEqual((Date)valuePositionContainer.validfrom, (Date)employeeEndDate) || !DateHelper.afterOrEqual((Date)valuePositionContainer.validuntil, (Date)employeeStartDate) || valuePositionContainer.valuetypenumber != 890000 && valuePositionContainer.valuetypenumber != 890100) continue;
                Date beginDate = DateHelper.max((Date)valuePositionContainer.validfrom, (Date)employeeStartDate);
                Date endDate = DateHelper.getLastDayOfMonth((Date)DateHelper.min((Date)valuePositionContainer.validuntil, (Date)employeeEndDate));
                AUSZAHLUNG = AUSZAHLUNG.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
            }
        }
        return AUSZAHLUNG.compareTo(BigDecimal.ZERO) != 0;
    }

    private void getValuesHM(List<ValuepositionContainer> valuePositionli, Date employeeStartDate, Date employeeEndDate) throws BusinessDomainException {
        for (ValuepositionContainer valuePositionContainer : valuePositionli) {
            if (!DateHelper.beforeOrEqual((Date)valuePositionContainer.validfrom, (Date)employeeEndDate) || !DateHelper.afterOrEqual((Date)valuePositionContainer.validuntil, (Date)employeeStartDate)) continue;
            Date beginDate = DateHelper.max((Date)valuePositionContainer.validfrom, (Date)employeeStartDate);
            Date endDate = DateHelper.getLastDayOfMonth((Date)DateHelper.min((Date)valuePositionContainer.validuntil, (Date)employeeEndDate));
            BigDecimal months = new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate));
            BigDecimal result = valuePositionContainer.results.multiply(months);
            switch (valuePositionContainer.valuetypenumber) {
                case 100100: {
                    this.FIELD_GESAMT_BRUTTO = this.FIELD_GESAMT_BRUTTO.add(result);
                    break;
                }
                case 110000: {
                    this.FIELD_STEUER_BRUTTO = this.FIELD_STEUER_BRUTTO.add(result);
                    break;
                }
                case 110590: {
                    if (this.FIELD_ST_TAGE.compareTo(BigDecimal.ZERO) != 0) break;
                    this.FIELD_ST_TAGE = this.FIELD_ST_TAGE.add(valuePositionContainer.factor1.multiply(months).setScale(0));
                    break;
                }
                case 130000: {
                    this.FIELD_SV_BRUTTO = this.FIELD_SV_BRUTTO.add(result);
                    break;
                }
                case 130590: {
                    if (this.FIELD_SV_TAGE.compareTo(BigDecimal.ZERO) != 0) break;
                    this.FIELD_SV_TAGE = this.FIELD_SV_TAGE.add(valuePositionContainer.factor1.multiply(months).setScale(0));
                    break;
                }
                case 145110: 
                case 145160: 
                case 145170: 
                case 145210: 
                case 145215: 
                case 145220: 
                case 145225: 
                case 145310: 
                case 145320: 
                case 145360: 
                case 145370: {
                    ValuePosition valuePosition = new ValuePosition(valuePositionContainer.getObjectid());
                    ValuePosition valuePositionFromGenesis = valuePosition.getValuePositionFromGenesisParent();
                    if (valuePositionFromGenesis == null || !JournalOfWageShortMonthlyReportDataSource.isRelevantToAdd(valuePositionFromGenesis, VDate.getDateMax(), endDate)) break;
                    this.FIELD_BAV_AG_KOSTEN = this.FIELD_BAV_AG_KOSTEN.add(result);
                    break;
                }
                case 220010: {
                    this.FIELD_GESETZLICHE_ABZUEGE = this.FIELD_GESETZLICHE_ABZUEGE.add(result);
                    break;
                }
                case 220050: {
                    this.FIELD_LOHNSTEUER = this.FIELD_LOHNSTEUER.add(result);
                    break;
                }
                case 223050: {
                    this.FIELD_SOLIDARITAETSZUSCHLAG = this.FIELD_SOLIDARITAETSZUSCHLAG.add(result);
                    break;
                }
                case 226010: {
                    this.FIELD_KIST = this.FIELD_KIST.add(result);
                    break;
                }
                case 250510: 
                case 250610: {
                    this.FIELD_KAMMER = this.FIELD_KAMMER.add(result);
                    break;
                }
                case 320510: {
                    this.FIELD_GESETZLICHE_ABZUEGE = this.FIELD_GESETZLICHE_ABZUEGE.add(result);
                    break;
                }
                case 321050: 
                case 350510: {
                    this.FIELD_KV_ENTGELT = this.FIELD_KV_ENTGELT.add(result);
                    break;
                }
                case 322050: 
                case 351050: {
                    this.FIELD_KV_ANA = this.FIELD_KV_ANA.add(result);
                    break;
                }
                case 323050: {
                    this.FIELD_KV_AGA = this.FIELD_KV_AGA.add(result);
                    break;
                }
                case 327050: 
                case 401100: 
                case 401150: {
                    this.FIELD_RV_ENTGELT = this.FIELD_RV_ENTGELT.add(result);
                    break;
                }
                case 328050: {
                    this.FIELD_RV_ANA = this.FIELD_RV_ANA.add(result);
                    break;
                }
                case 329050: 
                case 401300: 
                case 401350: {
                    this.FIELD_RV_AGA = this.FIELD_RV_AGA.add(result);
                    break;
                }
                case 333050: {
                    this.FIELD_AV_ENTGELT = this.FIELD_AV_ENTGELT.add(result);
                    break;
                }
                case 334050: {
                    this.FIELD_AV_ANA = this.FIELD_AV_ANA.add(result);
                    break;
                }
                case 335050: {
                    this.FIELD_AV_AGA = this.FIELD_AV_AGA.add(result);
                    break;
                }
                case 339050: {
                    this.FIELD_PV_ENTGELT = this.FIELD_PV_ENTGELT.add(result);
                    break;
                }
                case 340050: 
                case 355050: {
                    this.FIELD_PV_ANA = this.FIELD_PV_ANA.add(result);
                    break;
                }
                case 341050: {
                    this.FIELD_PV_AGA = this.FIELD_PV_AGA.add(result);
                    break;
                }
                case 360050: {
                    this.FIELD_UMLAGE_ENTGELT = this.FIELD_UMLAGE_ENTGELT.add(result);
                    break;
                }
                case 361050: {
                    this.FIELD_UMLAGE_BEITRAG = this.FIELD_UMLAGE_BEITRAG.add(result);
                    break;
                }
                case 366050: {
                    this.FIELD_INSG_UMLAGE = this.FIELD_INSG_UMLAGE.add(result);
                    break;
                }
                case 700000: {
                    this.FIELD_NETTOLOHN = this.FIELD_NETTOLOHN.add(result);
                    break;
                }
                case 702000: {
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(result);
                    break;
                }
                case 710010: {
                    this.FIELD_AG_PAUSCHAL = this.FIELD_AG_PAUSCHAL.add(result);
                    break;
                }
                case 710020: {
                    this.FIELD_AN_PAUSCHAL = this.FIELD_AN_PAUSCHAL.add(result);
                    break;
                }
                case 736300: {
                    this.FIELD_GFB_PAUSCHAL = this.FIELD_GFB_PAUSCHAL.add(result);
                    this.FIELD_AG_PAUSCHAL = this.FIELD_AG_PAUSCHAL.subtract(result);
                    break;
                }
                case 770020: 
                case 770025: 
                case 770030: 
                case 770035: 
                case 770040: 
                case 770045: 
                case 770050: 
                case 770055: 
                case 770120: 
                case 770130: 
                case 770140: {
                    this.FIELD_KV_AGZ = this.FIELD_KV_AGZ.add(result);
                    break;
                }
                case 771020: 
                case 771030: 
                case 771040: 
                case 771050: 
                case 771120: 
                case 771130: 
                case 771140: {
                    this.FIELD_PV_AGZ = this.FIELD_PV_AGZ.add(result);
                    break;
                }
                case 772100: 
                case 775050: {
                    this.FIELD_RV_AGZ = this.FIELD_RV_AGZ.add(result);
                    break;
                }
                case 760100: {
                    if (new VDate(beginDate).getMonth() != 11) break;
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.add(result);
                    this.FIELD_LOHNSTEUER = this.FIELD_LOHNSTEUER.subtract(result);
                    break;
                }
                case 760110: {
                    if (new VDate(beginDate).getMonth() != 11) break;
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.add(result);
                    this.FIELD_SOLIDARITAETSZUSCHLAG = this.FIELD_SOLIDARITAETSZUSCHLAG.subtract(result);
                    break;
                }
                case 760120: 
                case 760130: {
                    if (new VDate(beginDate).getMonth() != 11) break;
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.add(result);
                    this.FIELD_KIST = this.FIELD_KIST.subtract(result);
                    break;
                }
                case 760400: {
                    if (!DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(result);
                    this.FIELD_LOHNSTEUER = this.FIELD_LOHNSTEUER.add(result);
                    break;
                }
                case 760410: {
                    if (!DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(result);
                    this.FIELD_SOLIDARITAETSZUSCHLAG = this.FIELD_SOLIDARITAETSZUSCHLAG.add(result);
                    break;
                }
                case 760420: 
                case 760430: {
                    if (!DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(result);
                    this.FIELD_KIST = this.FIELD_KIST.add(result);
                    break;
                }
                case 760450: {
                    if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(result);
                    this.FIELD_LOHNSTEUER = this.FIELD_LOHNSTEUER.add(result);
                    break;
                }
                case 760460: {
                    if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(result);
                    this.FIELD_SOLIDARITAETSZUSCHLAG = this.FIELD_SOLIDARITAETSZUSCHLAG.add(result);
                    break;
                }
                case 760470: 
                case 760480: {
                    if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(result);
                    this.FIELD_KIST = this.FIELD_KIST.add(result);
                    break;
                }
                case 860000: {
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.add(result);
                    break;
                }
                case 861000: 
                case 863000: 
                case 870000: 
                case 871000: 
                case 886200: {
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(result);
                    break;
                }
                case 862000: {
                    this.FIELD_VWL = this.FIELD_VWL.add(result);
                    this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(result);
                    break;
                }
                case 890000: {
                    this.FIELD_AUSZAHLUNG = this.FIELD_AUSZAHLUNG.add(result);
                    break;
                }
                case 890100: {
                    this.FIELD_AUSZAHLUNG = this.FIELD_AUSZAHLUNG.add(result.negate());
                    break;
                }
                case 230510: 
                case 230520: {
                    this.FIELD_KUG = this.FIELD_KUG.add(result);
                    break;
                }
                case 100910: 
                case 100930: 
                case 100950: 
                case 100960: 
                case 100970: {
                    this.FIELD_ZVK_AGA = this.FIELD_ZVK_AGA.add(result);
                    break;
                }
                case 100920: 
                case 100940: {
                    this.FIELD_ZVK_ANA = this.FIELD_ZVK_ANA.add(result);
                }
            }
        }
        this.FIELD_AG_KOSTEN = this.FIELD_GESAMT_BRUTTO.add(this.FIELD_GFB_PAUSCHAL.add(this.FIELD_AG_PAUSCHAL.add(this.FIELD_KV_AGA.add(this.FIELD_KV_AGZ.add(this.FIELD_RV_AGA.add(this.FIELD_RV_AGZ.add(this.FIELD_AV_AGA.add(this.FIELD_PV_AGA.add(this.FIELD_PV_AGZ.add(this.FIELD_UMLAGE_BEITRAG.add(this.FIELD_INSG_UMLAGE.add(this.FIELD_ZVK_AGA).add(this.FIELD_BAV_AG_KOSTEN))))))))))));
    }

    private void getDataFor(EmployeeJournalOfWageShortMonthly eWT) throws BusinessDomainException {
        TaxContainer taxContainer;
        InsuranceContainer insuranceContainer;
        MasterallContainer masterAllContainer;
        String currentOidPCompany;
        EmployeeForReport eFR = eWT.getEmployeeForReport();
        String currentOidPlant = StringMapper.isNullString((String)eFR.getOidPlant()) ? "" : eFR.getOidPlant();
        this.mCurrentOidPCompany = currentOidPCompany = StringMapper.isNullString((String)eFR.getOidPCompany()) ? "" : eFR.getOidPCompany();
        this.mCurrentOidPlant = this.mPCompanyHasPlants ? currentOidPlant : "";
        Date employeeStartDate = eWT.getEmployeeStartDate();
        Date employeeEndDate = eWT.getEmployeeEndDate();
        this.FIELD_SORT_CRITERIA = eWT.getEmployeeSortCriteria();
        this.FIELD_SORT_CRITERIA_DESCRIPTION = eWT.getEmployeeSortCriteriaDescription();
        this.FIELD_SORT_CRITERIA_KEY = eWT.getEmployeeSortCriteriaKey();
        this.mCurrentSortCriteriaKey = eWT.getEmployeeSortCriteriaKey();
        EmployerBean employerBean = (EmployerBean)UtilitiesManager.getBean((String)"employerBean", EmployerBean.class);
        employerBean.setOidEmployee(eWT.getEmployeeForReport().getOidEmployee());
        employerBean.setEffectiveDate(this.mForEffectiveDate);
        employerBean.setValidDate(this.mForValidDate);
        employerBean.setOidPlant(currentOidPlant);
        employerBean.setOidPCompany(currentOidPCompany);
        employerBean.createEmployerBean();
        if (!StringMapper.isNullString((String)currentOidPlant) && eWT.getPlantfoundationsContainer() != null) {
            this.FIELD_BETRIEBSSTAETTE = employerBean.getPlantShortDescription();
            this.FIELD_PLANT_KEY = employerBean.getPlantCode();
            this.FIELD_RK = employerBean.getPlantLawareaShort();
        }
        if ((masterAllContainer = eWT.getMasterallContainer()) != null) {
            this.FIELD_PERSONAL_NR = Integer.toString(masterAllContainer.personnelnumber);
            this.FIELD_NAME = StringMapper.isNullString((String)masterAllContainer.surname) ? "" : masterAllContainer.surname;
            this.FIELD_VORNAME = StringMapper.isNullString((String)masterAllContainer.firstname) ? "" : masterAllContainer.firstname;
            this.FIELD_DATUMJAHR = Integer.toString(this.mForYear);
            if (StringMapper.isNullString((String)this.FIELD_RK)) {
                this.FIELD_RK = employerBean.getCompanyLawareaShort();
            }
        }
        if ((insuranceContainer = eWT.getInsuranceContainer()) != null) {
            this.FIELD_KRANKENKASSE = StringMapper.isNullString((String)insuranceContainer.oidhealthfund) ? "" : this.getHealthFundTP(insuranceContainer.oidhealthfund, employeeEndDate).getShortDescription();
            this.FIELD_BEITR_GP_KV = Integer.toString(insuranceContainer.duesgrouphi);
            this.FIELD_BEITR_GP_RV = Integer.toString(insuranceContainer.duesgrouppi);
            this.FIELD_BEITR_GP_AV = Integer.toString(insuranceContainer.duesgroupui);
            this.FIELD_BEITR_GP_PV = Integer.toString(insuranceContainer.duesgroupni);
            this.FIELD_GRV = insuranceContainer.specialcategory == 1 ? "ja" : "nein";
            this.FIELD_MFB = insuranceContainer.multiplyemployment != 0 ? "ja" : "nein";
            this.FIELD_PGS = Integer.toString(insuranceContainer.persongroup);
            this.FIELD_PARENT = insuranceContainer.nichildeducation ? "E" : "";
            String string = this.FIELD_GFB = insuranceContainer.persongroup == 109 ? "ja" : "nein";
        }
        if ((taxContainer = eWT.getTaxContainer()) != null) {
            this.FIELD_STEUERKLASSE = Integer.toString(taxContainer.taxbracket);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)taxContainer.percentagesplit)) {
                this.FIELD_STEUERFAKTOR = taxContainer.percentagesplit.toString().replace('.', ',');
            }
            this.FIELD_ZKF = taxContainer.childrelief.toString();
            this.FIELD_ZKF = StringMapper.replaceAllSubString((String)this.FIELD_ZKF, (String)".", (String)",");
            this.FIELD_RELI_AN = ChurchTaxEnumMapper.valueToString((int)taxContainer.churchtaxee);
            this.FIELD_RELI_EG = ChurchTaxEnumMapper.valueToString((int)taxContainer.churchtaxspouse);
            this.FIELD_MTL_FREIB = BigDecimalMapper.toString((BigDecimal)taxContainer.freeallowancemm);
            this.FIELD_JHL_FREIB = BigDecimalMapper.toString((BigDecimal)taxContainer.freeallowanceyy);
            this.FIELD_VBZ = taxContainer.pensionfreedues ? "ja" : "nein";
            this.FIELD_AE = taxContainer.oldagereliefamount ? "ja" : "nein";
        }
        List<ValuepositionContainer> valuePositionli = eWT.getValuePositionli();
        this.FIELD_ZEITRAUMVON = DateMapper.toDDMMPointEndPointSeparationString((Date)employeeStartDate);
        this.FIELD_ZEITRAUMBIS = DateMapper.toDDMMPointEndPointSeparationString((Date)employeeEndDate);
        if (valuePositionli != null) {
            this.getValuesHM(valuePositionli, employeeStartDate, employeeEndDate);
        }
    }

    private void addSumme() {
        this.summe_gesamt_brutto = this.summe_gesamt_brutto.add(this.FIELD_GESAMT_BRUTTO);
        this.summe_lst = this.summe_lst.add(this.FIELD_LOHNSTEUER);
        this.summe_kv_entgelt = this.summe_kv_entgelt.add(this.FIELD_KV_ENTGELT);
        this.summe_rv_entgelt = this.summe_rv_entgelt.add(this.FIELD_RV_ENTGELT);
        this.summe_av_entgelt = this.summe_av_entgelt.add(this.FIELD_AV_ENTGELT);
        this.summe_pv_entgelt = this.summe_pv_entgelt.add(this.FIELD_PV_ENTGELT);
        this.summe_kv_agz = this.summe_kv_agz.add(this.FIELD_KV_AGZ);
        this.summe_u_entgelt = this.summe_u_entgelt.add(this.FIELD_UMLAGE_ENTGELT);
        this.summe_gesetzl_abz = this.summe_gesetzl_abz.add(this.FIELD_GESETZLICHE_ABZUEGE);
        this.summe_vwl = this.summe_vwl.add(this.FIELD_VWL);
        this.summe_an_pauschal = this.summe_an_pauschal.add(this.FIELD_AN_PAUSCHAL);
        this.summe_zvk_ana = this.summe_zvk_ana.add(this.FIELD_ZVK_ANA);
        this.summe_steuer_brutto = this.summe_steuer_brutto.add(this.FIELD_STEUER_BRUTTO);
        this.summe_kist = this.summe_kist.add(this.FIELD_KIST);
        this.summe_kv_ana = this.summe_kv_ana.add(this.FIELD_KV_ANA);
        this.summe_rv_ana = this.summe_rv_ana.add(this.FIELD_RV_ANA);
        this.summe_av_ana = this.summe_av_ana.add(this.FIELD_AV_ANA);
        this.summe_pv_ana = this.summe_pv_ana.add(this.FIELD_PV_ANA);
        this.summe_rv_agz = this.summe_rv_agz.add(this.FIELD_RV_AGZ);
        this.summe_u_beitrag = this.summe_u_beitrag.add(this.FIELD_UMLAGE_BEITRAG);
        this.summe_nettolohn = this.summe_nettolohn.add(this.FIELD_NETTOLOHN);
        this.summe_kammer = this.summe_kammer.add(this.FIELD_KAMMER);
        this.summe_ag_pauschal = this.summe_ag_pauschal.add(this.FIELD_AG_PAUSCHAL);
        this.summe_gfb_pauschal = this.summe_gfb_pauschal.add(this.FIELD_GFB_PAUSCHAL);
        this.summe_ag_kosten = this.summe_ag_kosten.add(this.FIELD_AG_KOSTEN);
        this.summe_sv_brutto = this.summe_sv_brutto.add(this.FIELD_SV_BRUTTO);
        this.summe_solz = this.summe_solz.add(this.FIELD_SOLIDARITAETSZUSCHLAG);
        this.summe_kv_aga = this.summe_kv_aga.add(this.FIELD_KV_AGA);
        this.summe_rv_aga = this.summe_rv_aga.add(this.FIELD_RV_AGA);
        this.summe_av_aga = this.summe_av_aga.add(this.FIELD_AV_AGA);
        this.summe_pv_aga = this.summe_pv_aga.add(this.FIELD_PV_AGA);
        this.summe_pv_agz = this.summe_pv_agz.add(this.FIELD_PV_AGZ);
        this.summe_insg_umlage = this.summe_insg_umlage.add(this.FIELD_INSG_UMLAGE);
        this.summe_bezuege_abzuege = this.summe_bezuege_abzuege.add(this.FIELD_BE_ABZUEGE);
        this.summe_kug = this.summe_kug.add(this.FIELD_KUG);
        this.summe_zvk_aga = this.summe_zvk_aga.add(this.FIELD_ZVK_AGA);
        this.summe_auszahlung = this.summe_auszahlung.add(this.FIELD_AUSZAHLUNG);
        if (this.mPCompanyHasPlants) {
            this.gesamtsumme_gesamt_brutto = this.gesamtsumme_gesamt_brutto.add(this.FIELD_GESAMT_BRUTTO);
            this.gesamtsumme_lst = this.gesamtsumme_lst.add(this.FIELD_LOHNSTEUER);
            this.gesamtsumme_kv_entgelt = this.gesamtsumme_kv_entgelt.add(this.FIELD_KV_ENTGELT);
            this.gesamtsumme_rv_entgelt = this.gesamtsumme_rv_entgelt.add(this.FIELD_RV_ENTGELT);
            this.gesamtsumme_av_entgelt = this.gesamtsumme_av_entgelt.add(this.FIELD_AV_ENTGELT);
            this.gesamtsumme_pv_entgelt = this.gesamtsumme_pv_entgelt.add(this.FIELD_PV_ENTGELT);
            this.gesamtsumme_kv_agz = this.gesamtsumme_kv_agz.add(this.FIELD_KV_AGZ);
            this.gesamtsumme_u_entgelt = this.gesamtsumme_u_entgelt.add(this.FIELD_UMLAGE_ENTGELT);
            this.gesamtsumme_gesetzl_abz = this.gesamtsumme_gesetzl_abz.add(this.FIELD_GESETZLICHE_ABZUEGE);
            this.gesamtsumme_vwl = this.gesamtsumme_vwl.add(this.FIELD_VWL);
            this.gesamtsumme_an_pauschal = this.gesamtsumme_an_pauschal.add(this.FIELD_AN_PAUSCHAL);
            this.gesamtsumme_zvk_ana = this.gesamtsumme_zvk_ana.add(this.FIELD_ZVK_ANA);
            this.gesamtsumme_steuer_brutto = this.gesamtsumme_steuer_brutto.add(this.FIELD_STEUER_BRUTTO);
            this.gesamtsumme_kist = this.gesamtsumme_kist.add(this.FIELD_KIST);
            this.gesamtsumme_kv_ana = this.gesamtsumme_kv_ana.add(this.FIELD_KV_ANA);
            this.gesamtsumme_rv_ana = this.gesamtsumme_rv_ana.add(this.FIELD_RV_ANA);
            this.gesamtsumme_av_ana = this.gesamtsumme_av_ana.add(this.FIELD_AV_ANA);
            this.gesamtsumme_pv_ana = this.gesamtsumme_pv_ana.add(this.FIELD_PV_ANA);
            this.gesamtsumme_rv_agz = this.gesamtsumme_rv_agz.add(this.FIELD_RV_AGZ);
            this.gesamtsumme_u_beitrag = this.gesamtsumme_u_beitrag.add(this.FIELD_UMLAGE_BEITRAG);
            this.gesamtsumme_nettolohn = this.gesamtsumme_nettolohn.add(this.FIELD_NETTOLOHN);
            this.gesamtsumme_kammer = this.gesamtsumme_kammer.add(this.FIELD_KAMMER);
            this.gesamtsumme_ag_pauschal = this.gesamtsumme_ag_pauschal.add(this.FIELD_AG_PAUSCHAL);
            this.gesamtsumme_gfb_pauschal = this.gesamtsumme_gfb_pauschal.add(this.FIELD_GFB_PAUSCHAL);
            this.gesamtsumme_ag_kosten = this.gesamtsumme_ag_kosten.add(this.FIELD_AG_KOSTEN);
            this.gesamtsumme_sv_brutto = this.gesamtsumme_sv_brutto.add(this.FIELD_SV_BRUTTO);
            this.gesamtsumme_solz = this.gesamtsumme_solz.add(this.FIELD_SOLIDARITAETSZUSCHLAG);
            this.gesamtsumme_kv_aga = this.gesamtsumme_kv_aga.add(this.FIELD_KV_AGA);
            this.gesamtsumme_rv_aga = this.gesamtsumme_rv_aga.add(this.FIELD_RV_AGA);
            this.gesamtsumme_av_aga = this.gesamtsumme_av_aga.add(this.FIELD_AV_AGA);
            this.gesamtsumme_pv_aga = this.gesamtsumme_pv_aga.add(this.FIELD_PV_AGA);
            this.gesamtsumme_pv_agz = this.gesamtsumme_pv_agz.add(this.FIELD_PV_AGZ);
            this.gesamtsumme_insg_umlage = this.gesamtsumme_insg_umlage.add(this.FIELD_INSG_UMLAGE);
            this.gesamtsumme_bezuege_abzuege = this.gesamtsumme_bezuege_abzuege.add(this.FIELD_BE_ABZUEGE);
            this.gesamtsumme_kug = this.gesamtsumme_kug.add(this.FIELD_KUG);
            this.gesamtsumme_zvk_aga = this.gesamtsumme_zvk_aga.add(this.FIELD_ZVK_AGA);
            this.gesamtsumme_auszahlung = this.gesamtsumme_auszahlung.add(this.FIELD_AUSZAHLUNG);
            JournalOfWageShortMonthlySumBean bean = this.mSumBeanHashMap.get(this.FIELD_PLANT_KEY);
            if (bean == null) {
                bean = new JournalOfWageShortMonthlySumBean(this.FIELD_PLANT_KEY + " / " + this.FIELD_BETRIEBSSTAETTE);
                bean.addF_gesamt_brutto(this.FIELD_GESAMT_BRUTTO);
                bean.addF_lst(this.FIELD_LOHNSTEUER);
                bean.addF_kv_entgelt(this.FIELD_KV_ENTGELT);
                bean.addF_rv_entgelt(this.FIELD_RV_ENTGELT);
                bean.addF_av_entgelt(this.FIELD_AV_ENTGELT);
                bean.addF_pv_entgelt(this.FIELD_PV_ENTGELT);
                bean.addF_kv_agz(this.FIELD_KV_AGZ);
                bean.addF_u_entgelt(this.FIELD_UMLAGE_ENTGELT);
                bean.addF_gesetzl_abz(this.FIELD_GESETZLICHE_ABZUEGE);
                bean.addF_vwl(this.FIELD_VWL);
                bean.addF_an_pauschal(this.FIELD_AN_PAUSCHAL);
                bean.addF_zvk_ana(this.FIELD_ZVK_ANA);
                bean.addF_steuer_brutto(this.FIELD_STEUER_BRUTTO);
                bean.addF_kist(this.FIELD_KIST);
                bean.addF_kv_ana(this.FIELD_KV_ANA);
                bean.addF_rv_ana(this.FIELD_RV_ANA);
                bean.addF_av_ana(this.FIELD_AV_ANA);
                bean.addF_pv_ana(this.FIELD_PV_ANA);
                bean.addF_rv_agz(this.FIELD_RV_AGZ);
                bean.addF_u_beitrag(this.FIELD_UMLAGE_BEITRAG);
                bean.addF_nettolohn(this.FIELD_NETTOLOHN);
                bean.addF_kammer(this.FIELD_KAMMER);
                bean.addF_ag_pauschal(this.FIELD_AG_PAUSCHAL);
                bean.addF_gfb_pauschal(this.FIELD_GFB_PAUSCHAL);
                bean.addF_ag_kosten(this.FIELD_AG_KOSTEN);
                bean.addF_sv_brutto(this.FIELD_SV_BRUTTO);
                bean.addF_solz(this.FIELD_SOLIDARITAETSZUSCHLAG);
                bean.addF_kv_aga(this.FIELD_KV_AGA);
                bean.addF_rv_aga(this.FIELD_RV_AGA);
                bean.addF_av_aga(this.FIELD_AV_AGA);
                bean.addF_pv_aga(this.FIELD_PV_AGA);
                bean.addF_pv_agz(this.FIELD_PV_AGZ);
                bean.addF_insg_umlage(this.FIELD_INSG_UMLAGE);
                bean.addF_bezuege_abzuege(this.FIELD_BE_ABZUEGE);
                bean.addF_kug(this.FIELD_KUG);
                bean.addF_zvk_aga(this.FIELD_ZVK_AGA);
                bean.addF_auszahlung(this.FIELD_AUSZAHLUNG);
                this.mSumBeanHashMap.put(this.FIELD_PLANT_KEY, bean);
            } else {
                bean.addF_gesamt_brutto(this.FIELD_GESAMT_BRUTTO);
                bean.addF_lst(this.FIELD_LOHNSTEUER);
                bean.addF_kv_entgelt(this.FIELD_KV_ENTGELT);
                bean.addF_rv_entgelt(this.FIELD_RV_ENTGELT);
                bean.addF_av_entgelt(this.FIELD_AV_ENTGELT);
                bean.addF_pv_entgelt(this.FIELD_PV_ENTGELT);
                bean.addF_kv_agz(this.FIELD_KV_AGZ);
                bean.addF_u_entgelt(this.FIELD_UMLAGE_ENTGELT);
                bean.addF_gesetzl_abz(this.FIELD_GESETZLICHE_ABZUEGE);
                bean.addF_vwl(this.FIELD_VWL);
                bean.addF_an_pauschal(this.FIELD_AN_PAUSCHAL);
                bean.addF_zvk_ana(this.FIELD_ZVK_ANA);
                bean.addF_steuer_brutto(this.FIELD_STEUER_BRUTTO);
                bean.addF_kist(this.FIELD_KIST);
                bean.addF_kv_ana(this.FIELD_KV_ANA);
                bean.addF_rv_ana(this.FIELD_RV_ANA);
                bean.addF_av_ana(this.FIELD_AV_ANA);
                bean.addF_pv_ana(this.FIELD_PV_ANA);
                bean.addF_rv_agz(this.FIELD_RV_AGZ);
                bean.addF_u_beitrag(this.FIELD_UMLAGE_BEITRAG);
                bean.addF_nettolohn(this.FIELD_NETTOLOHN);
                bean.addF_kammer(this.FIELD_KAMMER);
                bean.addF_ag_pauschal(this.FIELD_AG_PAUSCHAL);
                bean.addF_gfb_pauschal(this.FIELD_GFB_PAUSCHAL);
                bean.addF_ag_kosten(this.FIELD_AG_KOSTEN);
                bean.addF_sv_brutto(this.FIELD_SV_BRUTTO);
                bean.addF_solz(this.FIELD_SOLIDARITAETSZUSCHLAG);
                bean.addF_kv_aga(this.FIELD_KV_AGA);
                bean.addF_rv_aga(this.FIELD_RV_AGA);
                bean.addF_av_aga(this.FIELD_AV_AGA);
                bean.addF_pv_aga(this.FIELD_PV_AGA);
                bean.addF_pv_agz(this.FIELD_PV_AGZ);
                bean.addF_insg_umlage(this.FIELD_INSG_UMLAGE);
                bean.addF_bezuege_abzuege(this.FIELD_BE_ABZUEGE);
                bean.addF_kug(this.FIELD_KUG);
                bean.addF_zvk_aga(this.FIELD_ZVK_AGA);
                bean.addF_auszahlung(this.FIELD_AUSZAHLUNG);
                this.mSumBeanHashMap.put(this.FIELD_PLANT_KEY, bean);
            }
        }
    }

    private void copyHeaderValuesToTempValues() {
        this.temp_FIELD_MONAT = this.FIELD_MONAT;
        this.temp_FIELD_DATUMJAHR = this.FIELD_DATUMJAHR;
        this.temp_FIELD_BETRIEBSSTAETTE = this.FIELD_BETRIEBSSTAETTE;
        this.temp_FIELD_SORT_CRITERIA = this.FIELD_SORT_CRITERIA;
        this.temp_FIELD_SORT_CRITERIA_DESCRIPTION = this.FIELD_SORT_CRITERIA_DESCRIPTION;
        this.temp_FIELD_SORT_CRITERIA_KEY = this.FIELD_SORT_CRITERIA_KEY;
        this.temp_FIELD_PLANT_KEY = this.FIELD_PLANT_KEY;
    }

    private void copySumHeaderValuesToTempValues() {
        this.temp_FIELD_MONAT = this.FIELD_MONAT;
        this.temp_FIELD_DATUMJAHR = this.FIELD_DATUMJAHR;
        this.temp_FIELD_BETRIEBSSTAETTE = "Summenblatt";
        this.temp_FIELD_SORT_CRITERIA = "";
        this.temp_FIELD_SORT_CRITERIA_DESCRIPTION = "";
        this.temp_FIELD_SORT_CRITERIA_KEY = "";
        this.temp_FIELD_PLANT_KEY = "";
    }

    private void copyDataValuesToTempFields() {
        this.temp_summe_gesamt_brutto = this.summe_gesamt_brutto;
        this.temp_summe_lst = this.summe_lst;
        this.temp_summe_kv_entgelt = this.summe_kv_entgelt;
        this.temp_summe_rv_entgelt = this.summe_rv_entgelt;
        this.temp_summe_av_entgelt = this.summe_av_entgelt;
        this.temp_summe_pv_entgelt = this.summe_pv_entgelt;
        this.temp_summe_kv_agz = this.summe_kv_agz;
        this.temp_summe_u_entgelt = this.summe_u_entgelt;
        this.temp_summe_gesetzl_abz = this.summe_gesetzl_abz;
        this.temp_summe_vwl = this.summe_vwl;
        this.temp_summe_an_pauschal = this.summe_an_pauschal;
        this.temp_summe_zvk_ana = this.summe_zvk_ana;
        this.temp_summe_steuer_brutto = this.summe_steuer_brutto;
        this.temp_summe_kist = this.summe_kist;
        this.temp_summe_kv_ana = this.summe_kv_ana;
        this.temp_summe_rv_ana = this.summe_rv_ana;
        this.temp_summe_av_ana = this.summe_av_ana;
        this.temp_summe_pv_ana = this.summe_pv_ana;
        this.temp_summe_rv_agz = this.summe_rv_agz;
        this.temp_summe_u_beitrag = this.summe_u_beitrag;
        this.temp_summe_nettolohn = this.summe_nettolohn;
        this.temp_summe_kammer = this.summe_kammer;
        this.temp_summe_ag_pauschal = this.summe_ag_pauschal;
        this.temp_summe_gfb_pauschal = this.summe_gfb_pauschal;
        this.temp_summe_ag_kosten = this.summe_ag_kosten;
        this.temp_summe_sv_brutto = this.summe_sv_brutto;
        this.temp_summe_solz = this.summe_solz;
        this.temp_summe_kv_aga = this.summe_kv_aga;
        this.temp_summe_rv_aga = this.summe_rv_aga;
        this.temp_summe_av_aga = this.summe_av_aga;
        this.temp_summe_pv_aga = this.summe_pv_aga;
        this.temp_summe_pv_agz = this.summe_pv_agz;
        this.temp_summe_insg_umlage = this.summe_insg_umlage;
        this.temp_summe_bezuege_abzuege = this.summe_bezuege_abzuege;
        this.temp_summe_kug = this.summe_kug;
        this.temp_summe_zvk_aga = this.summe_zvk_aga;
        this.temp_summe_auszahlung = this.summe_auszahlung;
    }

    private void copySumDataValuesToTempFields() {
        this.temp_summe_gesamt_brutto = this.gesamtsumme_gesamt_brutto;
        this.temp_summe_lst = this.gesamtsumme_lst;
        this.temp_summe_kv_entgelt = this.gesamtsumme_kv_entgelt;
        this.temp_summe_rv_entgelt = this.gesamtsumme_rv_entgelt;
        this.temp_summe_av_entgelt = this.gesamtsumme_av_entgelt;
        this.temp_summe_pv_entgelt = this.gesamtsumme_pv_entgelt;
        this.temp_summe_kv_agz = this.gesamtsumme_kv_agz;
        this.temp_summe_u_entgelt = this.gesamtsumme_u_entgelt;
        this.temp_summe_gesetzl_abz = this.gesamtsumme_gesetzl_abz;
        this.temp_summe_vwl = this.gesamtsumme_vwl;
        this.temp_summe_an_pauschal = this.gesamtsumme_an_pauschal;
        this.temp_summe_zvk_ana = this.gesamtsumme_zvk_ana;
        this.temp_summe_steuer_brutto = this.gesamtsumme_steuer_brutto;
        this.temp_summe_kist = this.gesamtsumme_kist;
        this.temp_summe_kv_ana = this.gesamtsumme_kv_ana;
        this.temp_summe_rv_ana = this.gesamtsumme_rv_ana;
        this.temp_summe_av_ana = this.gesamtsumme_av_ana;
        this.temp_summe_pv_ana = this.gesamtsumme_pv_ana;
        this.temp_summe_rv_agz = this.gesamtsumme_rv_agz;
        this.temp_summe_u_beitrag = this.gesamtsumme_u_beitrag;
        this.temp_summe_nettolohn = this.gesamtsumme_nettolohn;
        this.temp_summe_kammer = this.gesamtsumme_kammer;
        this.temp_summe_ag_pauschal = this.gesamtsumme_ag_pauschal;
        this.temp_summe_gfb_pauschal = this.gesamtsumme_gfb_pauschal;
        this.temp_summe_ag_kosten = this.gesamtsumme_ag_kosten;
        this.temp_summe_sv_brutto = this.gesamtsumme_sv_brutto;
        this.temp_summe_solz = this.gesamtsumme_solz;
        this.temp_summe_kv_aga = this.gesamtsumme_kv_aga;
        this.temp_summe_rv_aga = this.gesamtsumme_rv_aga;
        this.temp_summe_av_aga = this.gesamtsumme_av_aga;
        this.temp_summe_pv_aga = this.gesamtsumme_pv_aga;
        this.temp_summe_pv_agz = this.gesamtsumme_pv_agz;
        this.temp_summe_insg_umlage = this.gesamtsumme_insg_umlage;
        this.temp_summe_bezuege_abzuege = this.gesamtsumme_bezuege_abzuege;
        this.temp_summe_kug = this.gesamtsumme_kug;
        this.temp_summe_zvk_aga = this.gesamtsumme_zvk_aga;
        this.temp_summe_auszahlung = this.gesamtsumme_auszahlung;
    }

    private void resetDataEmployee() {
        this.FIELD_PERSONAL_NR = "";
        this.FIELD_NAME = "";
        this.FIELD_VORNAME = "";
        this.FIELD_KRANKENKASSE = "";
        this.FIELD_BEITR_GP_KV = "";
        this.FIELD_BEITR_GP_RV = "";
        this.FIELD_BEITR_GP_AV = "";
        this.FIELD_BEITR_GP_PV = "";
        this.FIELD_PARENT = "";
        this.FIELD_GRV = "";
        this.FIELD_MFB = "";
        this.FIELD_RK = "";
        this.FIELD_ZEITRAUMVON = "";
        this.FIELD_ZEITRAUMBIS = "";
        this.FIELD_PGS = "";
        this.FIELD_STEUERKLASSE = "";
        this.FIELD_STEUERTABELLE = "";
        this.FIELD_STEUERFAKTOR = "";
        this.FIELD_ZKF = "";
        this.FIELD_RELI_AN = "";
        this.FIELD_RELI_EG = "";
        this.FIELD_GFB = "";
        this.FIELD_MTL_FREIB = "";
        this.FIELD_JHL_FREIB = "";
        this.FIELD_VBZ = "";
        this.FIELD_AE = "";
        this.FIELD_MONAT_JAHR = "";
        this.FIELD_STATUS = "";
        this.FIELD_GESAMT_BRUTTO = BigDecimal.valueOf(0L, 2);
        this.FIELD_LOHNSTEUER = BigDecimal.valueOf(0L, 2);
        this.FIELD_KV_ENTGELT = BigDecimal.valueOf(0L, 2);
        this.FIELD_RV_ENTGELT = BigDecimal.valueOf(0L, 2);
        this.FIELD_AV_ENTGELT = BigDecimal.valueOf(0L, 2);
        this.FIELD_PV_ENTGELT = BigDecimal.valueOf(0L, 2);
        this.FIELD_KV_AGZ = BigDecimal.valueOf(0L, 2);
        this.FIELD_UMLAGE_ENTGELT = BigDecimal.valueOf(0L, 2);
        this.FIELD_GESETZLICHE_ABZUEGE = BigDecimal.valueOf(0L, 2);
        this.FIELD_VWL = BigDecimal.valueOf(0L, 2);
        this.FIELD_AN_PAUSCHAL = BigDecimal.valueOf(0L, 2);
        this.FIELD_ZVK_ANA = BigDecimal.valueOf(0L, 2);
        this.FIELD_STEUER_BRUTTO = BigDecimal.valueOf(0L, 2);
        this.FIELD_KIST = BigDecimal.valueOf(0L, 2);
        this.FIELD_KV_ANA = BigDecimal.valueOf(0L, 2);
        this.FIELD_RV_ANA = BigDecimal.valueOf(0L, 2);
        this.FIELD_AV_ANA = BigDecimal.valueOf(0L, 2);
        this.FIELD_PV_ANA = BigDecimal.valueOf(0L, 2);
        this.FIELD_RV_AGZ = BigDecimal.valueOf(0L, 2);
        this.FIELD_UMLAGE_BEITRAG = BigDecimal.valueOf(0L, 2);
        this.FIELD_NETTOLOHN = BigDecimal.valueOf(0L, 2);
        this.FIELD_KAMMER = BigDecimal.valueOf(0L, 2);
        this.FIELD_AG_PAUSCHAL = BigDecimal.valueOf(0L, 2);
        this.FIELD_GFB_PAUSCHAL = BigDecimal.valueOf(0L, 2);
        this.FIELD_AG_KOSTEN = BigDecimal.valueOf(0L, 2);
        this.FIELD_SV_BRUTTO = BigDecimal.valueOf(0L, 2);
        this.FIELD_SOLIDARITAETSZUSCHLAG = BigDecimal.valueOf(0L, 2);
        this.FIELD_KV_AGA = BigDecimal.valueOf(0L, 2);
        this.FIELD_RV_AGA = BigDecimal.valueOf(0L, 2);
        this.FIELD_AV_AGA = BigDecimal.valueOf(0L, 2);
        this.FIELD_PV_AGA = BigDecimal.valueOf(0L, 2);
        this.FIELD_PV_AGZ = BigDecimal.valueOf(0L, 2);
        this.FIELD_INSG_UMLAGE = BigDecimal.valueOf(0L, 2);
        this.FIELD_BE_ABZUEGE = BigDecimal.valueOf(0L, 2);
        this.FIELD_KUG = BigDecimal.valueOf(0L, 2);
        this.FIELD_ZVK_AGA = BigDecimal.valueOf(0L, 2);
        this.FIELD_AUSZAHLUNG = BigDecimal.valueOf(0L, 2);
        this.FIELD_ST_TAGE = BigDecimal.ZERO;
        this.FIELD_SV_TAGE = BigDecimal.ZERO;
        this.FIELD_BAV_AG_KOSTEN = BigDecimal.ZERO;
    }

    private InternalHistoryBean getHashMaps(String[] oidEmployee, Date effectiveDate, Date validFromDate, Date validUntilDate) {
        InternalHistoryBean historyBean = new InternalHistoryBean();
        Map<String, List<MasterallContainer>> masterAllHM = this.getMasterallHistoryForEmployees(oidEmployee, effectiveDate, validFromDate, validUntilDate);
        Map<String, List<InsuranceContainer>> insuranceHM = this.getInsuranceHistoryForEmployees(oidEmployee, effectiveDate, validFromDate, validUntilDate);
        Map<String, List<TaxContainer>> taxHM = this.getTaxHistoryForExployees(oidEmployee, effectiveDate, validFromDate, validUntilDate);
        if (this.mResultOidPlant.length > 0) {
            Map<String, List<PlantfoundationsContainer>> plantfoundationHM = this.getPlantFoundationsHistoryForEmployees(effectiveDate, validFromDate, validUntilDate);
            historyBean.setPlantFoundation(plantfoundationHM);
        }
        historyBean.setMasterAll(masterAllHM);
        historyBean.setInsurance(insuranceHM);
        historyBean.setTax(taxHM);
        return historyBean;
    }

    private Date[] getRetroactiveCorrectionDates(String currentOidEmployee, Date employeeStartDate, Map<String, List<CalculationbasicContainer>> calculationBasicMap, Map<String, List<MasterallContainer>> masterAllMap) {
        List<CalculationbasicContainer> calculationBasicContainerLi;
        Date minValidFrom = null;
        Date journalizedUntil = null;
        List<MasterallContainer> listeMaster = masterAllMap.get(currentOidEmployee);
        if (listeMaster != null) {
            for (MasterallContainer masterallContainer : listeMaster) {
                if (!DateHelper.beforeOrEqual((Date)masterallContainer.validfrom, (Date)employeeStartDate) || !DateHelper.afterOrEqual((Date)masterallContainer.validuntil, (Date)employeeStartDate)) continue;
                journalizedUntil = masterallContainer.journalizeduntil;
                if (PDateHelper.getDiffInMonths((Date)this.mForValidDate, (Date)journalizedUntil) <= 1) break;
                journalizedUntil = null;
                break;
            }
        }
        if (journalizedUntil != null && (calculationBasicContainerLi = calculationBasicMap.get(currentOidEmployee)) != null) {
            LinkedList<Date> validFromDateList = new LinkedList<Date>();
            for (CalculationbasicContainer calculationbasicContainer : calculationBasicContainerLi) {
                if (!DateHelper.before((Date)calculationbasicContainer.validfrom, (Date)this.mForEffectiveDate)) continue;
                validFromDateList.add(calculationbasicContainer.validfrom);
            }
            Date[] datesValidFrom = new Date[validFromDateList.size()];
            datesValidFrom = validFromDateList.toArray(datesValidFrom);
            Arrays.sort(datesValidFrom, new DateComparator());
            minValidFrom = datesValidFrom[0];
        }
        Date[] rueckrechnungsWerte = new Date[2];
        if (journalizedUntil != null && minValidFrom != null) {
            rueckrechnungsWerte[0] = minValidFrom;
            rueckrechnungsWerte[1] = journalizedUntil;
        }
        return rueckrechnungsWerte;
    }

    private Date getNextcontainerTempDate(EmployeeJournalOfWageShortMonthly eWT, Date containerTempDate) {
        if (eWT.getPlantfoundationsContainer() != null && DateHelper.before((Date)eWT.getPlantfoundationsContainer().validuntil, (Date)containerTempDate)) {
            containerTempDate = eWT.getPlantfoundationsContainer().validuntil;
        }
        if (eWT.getEmploymentContainer() != null && DateHelper.before((Date)eWT.getEmploymentContainer().validuntil, (Date)containerTempDate)) {
            containerTempDate = eWT.getEmploymentContainer().validuntil;
        }
        if (eWT.getMasterallContainer() != null && DateHelper.before((Date)eWT.getMasterallContainer().validuntil, (Date)containerTempDate)) {
            containerTempDate = eWT.getMasterallContainer().validuntil;
        }
        return containerTempDate;
    }

    private EmployeeJournalOfWageShortMonthly getEmployeeProperties(InternalEmployeeBean employeeHashMap, Date effectiveDate, Date validDate) throws BusinessDomainException {
        List<InsuranceContainer> list;
        List<TaxContainer> listeTax;
        List<MasterallContainer> listeMaster;
        Map<String, List<PlantfoundationsContainer>> plantfoundationsMap;
        Object listePlantFoundations;
        EmployeeForReport currentEmployee = employeeHashMap.getCurrent();
        EmployeeJournalOfWageShortMonthly eWT = new EmployeeJournalOfWageShortMonthly(currentEmployee);
        eWT.setPlantyKey(currentEmployee.getPlantKey());
        switch (this.mSortCriteria) {
            case 3: {
                eWT.setEmployeeSortCriteria("Mitarbeiterkreis");
                eWT.setEmployeesortCriteriaDescription(currentEmployee.getEmployeeCircleDescription());
                eWT.setEmployeeSortCriteriaKey(currentEmployee.getEmployeeCircleKey());
                break;
            }
            case 6: {
                eWT.setEmployeeSortCriteria("Kostenstelle");
                eWT.setEmployeesortCriteriaDescription(currentEmployee.getCostCenterDescription());
                eWT.setEmployeeSortCriteriaKey(currentEmployee.getCostCenterKey());
                break;
            }
            case 7: {
                eWT.setEmployeeSortCriteria("Kostentr\u00e4ger");
                eWT.setEmployeesortCriteriaDescription(currentEmployee.getCostUnitDescription());
                eWT.setEmployeeSortCriteriaKey(currentEmployee.getCostUnitKey());
                break;
            }
            case 8: {
                eWT.setEmployeeSortCriteria("Abteilung");
                eWT.setEmployeesortCriteriaDescription(currentEmployee.getDepartmentDescription());
                eWT.setEmployeeSortCriteriaKey(currentEmployee.getDepartmentKey());
                break;
            }
            case 9: {
                eWT.setEmployeeSortCriteria("Organisationseinheit");
                eWT.setEmployeesortCriteriaDescription(currentEmployee.getOrgUnitDescription());
                eWT.setEmployeeSortCriteriaKey(currentEmployee.getOrgUnitKey());
                break;
            }
            case 10: {
                eWT.setEmployeeSortCriteria("Bearbeiter 1");
                eWT.setEmployeesortCriteriaDescription(currentEmployee.getPersonInCharge1Description());
                eWT.setEmployeeSortCriteriaKey(currentEmployee.getPersonInCharge1Key());
                break;
            }
            case 11: {
                eWT.setEmployeeSortCriteria("Bearbeiter 2");
                eWT.setEmployeesortCriteriaDescription(currentEmployee.getPersonInCharge2Description());
                eWT.setEmployeeSortCriteriaKey(currentEmployee.getPersonInCharge2Key());
                break;
            }
        }
        eWT.setDateOfEntery(currentEmployee.getDateOfEntry());
        String currentOidEmployee = currentEmployee.getOidEmployee();
        String currentOidPCompany = currentEmployee.getOidPCompany();
        String currentOidPlant = this.mPCompanyHasPlants ? currentEmployee.getOidPlant() : "";
        Date employeeStartDate = employeeHashMap.getStartDate();
        InternalHistoryBean hashMapAll = employeeHashMap.getHistory();
        Map<String, List<TaxContainer>> taxAllMap = hashMapAll.getTax();
        List<ValuepositionContainer> valuePositions = this.getValuePositions(currentOidEmployee, effectiveDate, DateHelper.getFirstDayOfMonth((Date)validDate), DateHelper.getLastDayOfMonth((Date)validDate));
        Map<String, List<MasterallContainer>> masterAllMap = hashMapAll.getMasterAll();
        Map<String, List<InsuranceContainer>> insuranceMap = hashMapAll.getInsurance();
        eWT.setEmployeeStartDate(employeeStartDate);
        eWT.setEmployeeEndDate(DateHelper.getLastDayOfMonth((Date)employeeStartDate));
        if (!StringMapper.isNullString((String)currentOidPlant) && (listePlantFoundations = (plantfoundationsMap = hashMapAll.getPlantFoundation()).get(currentOidPlant)) != null) {
            Iterator iterator = listePlantFoundations.iterator();
            while (iterator.hasNext()) {
                PlantfoundationsContainer plantFoundationsContainer = (PlantfoundationsContainer)iterator.next();
                if (!DateHelper.beforeOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)plantFoundationsContainer.validfrom), (Date)employeeStartDate) || !DateHelper.afterOrEqual((Date)DateHelper.getLastDayOfMonth((Date)plantFoundationsContainer.validuntil), (Date)employeeStartDate)) continue;
                eWT.setPlantfoundationsContainer(plantFoundationsContainer);
                eWT.setPlantDescription(StringMapper.isNullString((String)plantFoundationsContainer.shortdescription) ? "" : plantFoundationsContainer.shortdescription);
                break;
            }
        }
        if ((listeMaster = masterAllMap.get(currentOidEmployee)) != null) {
            for (MasterallContainer masterallContainer : listeMaster) {
                if (!DateHelper.beforeOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)masterallContainer.validfrom), (Date)employeeStartDate) || !DateHelper.afterOrEqual((Date)DateHelper.getLastDayOfMonth((Date)masterallContainer.validuntil), (Date)employeeStartDate)) continue;
                eWT.setMasterallContainer(masterallContainer);
                if (this.mInternalUse || PDateHelper.getDiffInMonths((Date)this.mForValidDate, (Date)masterallContainer.journalizeduntil) <= 0) break;
                throw ReportExceptionMapper.makeEmployeeNotJournalized();
            }
        }
        if ((listeTax = taxAllMap.get(currentOidEmployee)) != null) {
            for (TaxContainer taxContainer : listeTax) {
                if (!DateHelper.beforeOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)taxContainer.validfrom), (Date)employeeStartDate) || !DateHelper.afterOrEqual((Date)DateHelper.getLastDayOfMonth((Date)taxContainer.validuntil), (Date)employeeStartDate)) continue;
                eWT.setTaxContainer(taxContainer);
                break;
            }
        }
        if ((list = insuranceMap.get(currentOidEmployee)) != null) {
            for (InsuranceContainer insuranceContainer : list) {
                if (!DateHelper.beforeOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)insuranceContainer.validfrom), (Date)employeeStartDate) || !DateHelper.afterOrEqual((Date)DateHelper.getLastDayOfMonth((Date)insuranceContainer.validuntil), (Date)employeeStartDate)) continue;
                eWT.setInsuranceContainer(insuranceContainer);
                break;
            }
        }
        eWT.setValuePositionli(valuePositions);
        eWT.setOidPCompany(currentOidPCompany);
        eWT.setOidPlant(currentOidPlant);
        return eWT;
    }

    private Map<String, List<MasterallContainer>> getMasterallHistoryForEmployees(String[] oidEmployees, Date forEffectiveDate, Date listFirstDate, Date listEndDate) {
        HashMap<String, List<MasterallContainer>> masterAllHM = new HashMap<String, List<MasterallContainer>>();
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)forEffectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)forEffectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)listEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)listFirstDate))});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
            for (Criterion inRestriction : inRestrictions) {
                PersistencyDataSet masterallDatas = daoMasterall.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"validfrom")}, Restrictions.and((Criterion)inRestriction, (Criterion)filter));
                while (masterallDatas.hasNext()) {
                    MasterallContainer masterallContainer = (MasterallContainer)masterallDatas.getNext();
                    LinkedList<MasterallContainer> liste = (LinkedList<MasterallContainer>)masterAllHM.get(masterallContainer.oidemployee);
                    if (liste == null) {
                        liste = new LinkedList<MasterallContainer>();
                        masterAllHM.put(masterallContainer.oidemployee, liste);
                    }
                    liste.add(masterallContainer);
                }
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return masterAllHM;
    }

    private Map<String, List<InsuranceContainer>> getInsuranceHistoryForEmployees(String[] oidEmployees, Date forEffectiveDate, Date listFirstDate, Date listEndDate) {
        HashMap<String, List<InsuranceContainer>> insuranceHM = new HashMap<String, List<InsuranceContainer>>();
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)forEffectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)forEffectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)listEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)listFirstDate))});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
            for (Criterion inRestriction : inRestrictions) {
                PersistencyDataSet insuranceDatas = daoInsurance.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"validfrom")}, Restrictions.and((Criterion)inRestriction, (Criterion)filter));
                while (insuranceDatas.hasNext()) {
                    InsuranceContainer insuranceContainer = (InsuranceContainer)insuranceDatas.getNext();
                    LinkedList<InsuranceContainer> liste = (LinkedList<InsuranceContainer>)insuranceHM.get(insuranceContainer.oidemployee);
                    if (liste == null) {
                        liste = new LinkedList<InsuranceContainer>();
                        insuranceHM.put(insuranceContainer.oidemployee, liste);
                    }
                    liste.add(insuranceContainer);
                }
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return insuranceHM;
    }

    private Map<String, List<TaxContainer>> getTaxHistoryForExployees(String[] oidEmployees, Date forEffectiveDate, Date listFirstDate, Date listEndDate) {
        HashMap<String, List<TaxContainer>> taxHM = new HashMap<String, List<TaxContainer>>();
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)forEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)forEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)listEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)listFirstDate))});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
            for (Criterion inRestriction : inRestrictions) {
                PersistencyDataSet taxDatas = daoTax.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"validfrom")}, Restrictions.and((Criterion)inRestriction, (Criterion)filter));
                while (taxDatas.hasNext()) {
                    TaxContainer taxContainer = (TaxContainer)taxDatas.getNext();
                    LinkedList<TaxContainer> liste = (LinkedList<TaxContainer>)taxHM.get(taxContainer.oidemployee);
                    if (liste == null) {
                        liste = new LinkedList<TaxContainer>();
                        taxHM.put(taxContainer.oidemployee, liste);
                    }
                    liste.add(taxContainer);
                }
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return taxHM;
    }

    private List<ValuepositionContainer> getValuePositions(String oidEmployee, Date forEffectiveDate, Date listFirstDate, Date listEndDate) {
        ArrayList<ValuepositionContainer> valuePositions = null;
        try {
            PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"rankingnumber")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.in((String)"valuetypenumber", (String[])this.mValueTypeNumbers), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)forEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)forEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)listEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)listFirstDate))}));
            if (valuePositionDatas != null) {
                valuePositions = new ArrayList<ValuepositionContainer>();
                while (valuePositionDatas.hasNext()) {
                    ValuepositionContainer valuePositionContainer = (ValuepositionContainer)valuePositionDatas.getNext();
                    valuePositions.add(valuePositionContainer);
                }
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return valuePositions;
    }

    private HealthFundTP getHealthFundTP(String healthFundOid, Date validDate) throws BusinessDomainException {
        HealthFund healthFund = this.mHealthFundMap.get(healthFundOid);
        if (healthFund == null) {
            healthFund = HealthFundPersistencyManager.getHealthFund((String)healthFundOid);
            this.mHealthFundMap.put(healthFundOid, healthFund);
        }
        return healthFund.getHealthFundTP(this.mForEffectiveDate, validDate);
    }

    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put(PARAMETER_USER, this.mUser);
        parameters.put(PARAMETER_CURRENCY, mCurrency);
        parameters.put(staticText_internalUse, this.mStaticText_internalUse);
        parameters.put(PARAMETER_AUSSICHT, DateMapper.toDDMMYYYYPointSeparationString((Date)this.mForEffectiveDate));
        return parameters;
    }

    private void setStringValues(Map<String, String> strings) {
        this.FIELD_STATUS = strings.get("FIELD_STATUS");
        this.FIELD_MONAT_JAHR = strings.get("FIELD_MONAT_JAHR");
        this.FIELD_MONAT = strings.get("FIELD_MONAT");
        this.FIELD_PLANT_KEY = strings.get("FIELD_PLANT_KEY");
        this.FIELD_BETRIEBSSTAETTE = strings.get("FIELD_BETRIEBSSTAETTE");
        this.FIELD_SORT_CRITERIA = strings.get("FIELD_SORT_CRITERIA");
        this.FIELD_SORT_CRITERIA_DESCRIPTION = strings.get("FIELD_SORT_CRITERIA_DESCRIPTION");
        this.FIELD_SORT_CRITERIA_KEY = strings.get("FIELD_SORT_CRITERIA_KEY");
        this.FIELD_DATUMJAHR = strings.get("FIELD_DATUMJAHR");
        this.FIELD_PERSONAL_NR = strings.get("FIELD_PERSONAL_NR");
        this.FIELD_NAME = strings.get("FIELD_NAME");
        this.FIELD_VORNAME = strings.get("FIELD_VORNAME");
        this.FIELD_KRANKENKASSE = strings.get("FIELD_KRANKENKASSE");
        this.FIELD_BEITR_GP_KV = strings.get("FIELD_BEITR_GP_KV");
        this.FIELD_BEITR_GP_RV = strings.get("FIELD_BEITR_GP_RV");
        this.FIELD_BEITR_GP_AV = strings.get("FIELD_BEITR_GP_AV");
        this.FIELD_BEITR_GP_PV = strings.get("FIELD_BEITR_GP_PV");
        this.FIELD_PARENT = strings.get("FIELD_PARENT");
        this.FIELD_STEUERKLASSE = strings.get("FIELD_STEUERKLASSE");
        this.FIELD_STEUERTABELLE = strings.get("FIELD_STEUERTABELLE");
        this.FIELD_STEUERFAKTOR = strings.get("FIELD_STEUERFAKTOR");
        this.FIELD_ZKF = strings.get("FIELD_ZKF");
        this.FIELD_RELI_AN = strings.get("FIELD_RELI_AN");
        this.FIELD_RELI_EG = strings.get("FIELD_RELI_EG");
        this.FIELD_GFB = strings.get("FIELD_GFB");
        this.FIELD_GRV = strings.get("FIELD_GRV");
        this.FIELD_MFB = strings.get("FIELD_MFB");
        this.FIELD_RK = strings.get("FIELD_RK");
        this.FIELD_ZEITRAUMVON = strings.get("FIELD_ZEITRAUMVON");
        this.FIELD_ZEITRAUMBIS = strings.get("FIELD_ZEITRAUMBIS");
        this.FIELD_MTL_FREIB = strings.get("FIELD_MTL_FREIB");
        this.FIELD_JHL_FREIB = strings.get("FIELD_JHL_FREIB");
        this.FIELD_VBZ = strings.get("FIELD_VBZ");
        this.FIELD_AE = strings.get("FIELD_AE");
        this.FIELD_PGS = strings.get("FIELD_PGS");
    }

    private void setBigDecimalValues(Map<String, BigDecimal> numbers) {
        this.FIELD_ST_TAGE = numbers.get("FIELD_ST_TAGE");
        this.FIELD_SV_TAGE = numbers.get("FIELD_SV_TAGE");
        this.FIELD_GESAMT_BRUTTO = numbers.get("FIELD_GESAMT_BRUTTO");
        this.FIELD_LOHNSTEUER = numbers.get("FIELD_LOHNSTEUER");
        this.FIELD_KV_ENTGELT = numbers.get("FIELD_KRANKENVERSICHERUNG_ENTGELT");
        this.FIELD_RV_ENTGELT = numbers.get("FIELD_RENTENVERSICHERUNG_ENTGELT");
        this.FIELD_AV_ENTGELT = numbers.get("FIELD_ARBEITSLOSENVERSICHERUNG_ENTGELT");
        this.FIELD_PV_ENTGELT = numbers.get("FIELD_PFLEGEVERSICHERUNG_ENTGELT");
        this.FIELD_KV_AGZ = numbers.get("FIELD_KRANKENVERSICHERUNG_AGZ");
        this.FIELD_UMLAGE_ENTGELT = numbers.get("FIELD_UMLAGE_ENTGELT");
        this.FIELD_GESETZLICHE_ABZUEGE = numbers.get("FIELD_GESETZLICHE_ABZUEGE");
        this.FIELD_VWL = numbers.get("FIELD_VWL");
        this.FIELD_AN_PAUSCHAL = numbers.get("FIELD_AN_PAUSCHAL");
        this.FIELD_ZVK_ANA = numbers.get("FIELD_ZVK_ANA");
        this.FIELD_STEUER_BRUTTO = numbers.get("FIELD_STEUER_BRUTTO");
        this.FIELD_KIST = numbers.get("FIELD_KIST");
        this.FIELD_KV_ANA = numbers.get("FIELD_KV_ANA");
        this.FIELD_RV_ANA = numbers.get("FIELD_RV_ANA");
        this.FIELD_AV_ANA = numbers.get("FIELD_AV_ANA");
        this.FIELD_PV_ANA = numbers.get("FIELD_PV_ANA");
        this.FIELD_RV_AGZ = numbers.get("FIELD_RV_AGZ");
        this.FIELD_UMLAGE_BEITRAG = numbers.get("FIELD_UMLAGE_BEITRAG");
        this.FIELD_NETTOLOHN = numbers.get("FIELD_NETTOLOHN");
        this.FIELD_KAMMER = numbers.get("FIELD_KAMMER");
        this.FIELD_AG_PAUSCHAL = numbers.get("FIELD_AG_PAUSCHAL");
        this.FIELD_GFB_PAUSCHAL = numbers.get("FIELD_GFB_PAUSCHAL");
        this.FIELD_AG_KOSTEN = numbers.get("FIELD_AG_KOSTEN");
        this.FIELD_SV_BRUTTO = numbers.get("FIELD_SV_BRUTTO");
        this.FIELD_SOLIDARITAETSZUSCHLAG = numbers.get("FIELD_SOLIDARITAETSZUSCHLAG");
        this.FIELD_KV_AGA = numbers.get("FIELD_KV_AGA");
        this.FIELD_RV_AGA = numbers.get("FIELD_RV_AGA");
        this.FIELD_AV_AGA = numbers.get("FIELD_AV_AGA");
        this.FIELD_PV_AGA = numbers.get("FIELD_PV_AGA");
        this.FIELD_PV_AGZ = numbers.get("FIELD_PV_AGZ");
        this.FIELD_INSG_UMLAGE = numbers.get("FIELD_INSG_UMLAGE");
        this.FIELD_BE_ABZUEGE = numbers.get("FIELD_BE_ABZUEGE");
        this.FIELD_KUG = numbers.get("FIELD_KUG");
        this.FIELD_ZVK_AGA = numbers.get("FIELD_ZVK_AGA");
        this.FIELD_AUSZAHLUNG = numbers.get("FIELD_AUSZAHLUNG");
    }

    public boolean next() throws JRException {
        try {
            boolean next = false;
            while (this.mEmployeeWageTaxEFRit.hasNext()) {
                next = true;
                EmployeeJournalOfWageShortMonthly ewt = this.mEmployeeWageTaxEFRit.next();
                if (ewt.getEmployeeToBeRegarded() && ewt.getOldNewValuesMap() != null) {
                    boolean firstPurchaseOldNewIt = true;
                    this.mCurrentOidPCompanyTemp = this.mCurrentOidPCompany;
                    this.mCurrentOidPlantTemp = this.mCurrentOidPlant;
                    this.mCurrentSortCriteriaKeyTemp = this.mCurrentSortCriteriaKey;
                    Map<String, OldNewValues> oldNewHM = ewt.getOldNewValuesMap();
                    Iterator oldNewit = ReportHelper.getIteratorFromHashMap(oldNewHM.keySet());
                    while (oldNewit.hasNext()) {
                        String motnKey = ((String)oldNewit.next()).toString();
                        OldNewValues monthOldNewHM = oldNewHM.get(motnKey);
                        EmployeeJournalOfWageShortMonthly eWTOld = monthOldNewHM.ewtOld;
                        EmployeeForReport oldNewEFR = eWTOld.getEmployeeForReport();
                        this.mCurrentOidPCompany = oldNewEFR.getOidPCompany();
                        this.mCurrentOidPlant = this.mPCompanyHasPlants ? oldNewEFR.getOidPlant() : "";
                        this.mCurrentSortCriteriaKey = eWTOld.getEmployeeSortCriteriaKey();
                        if (!(!firstPurchaseOldNewIt || StringMapper.equal((String)this.mCurrentOidPCompany, (String)this.mCurrentOidPCompanyTemp) && StringMapper.equal((String)this.mCurrentOidPlant, (String)this.mCurrentOidPlantTemp) && StringMapper.equal((String)this.mCurrentSortCriteriaKey, (String)this.mCurrentSortCriteriaKeyTemp))) {
                            this.FIELD_seitenwechsel = this.FIELD_seitenwechsel.equals("Seitenwechesl_1") ? "Seitenwechesl_2" : "Seitenwechesl_1";
                            this.mSubreportDetailCollection_temp.clear();
                            this.mSubreportDetailCollection_temp.addAll(this.mSubreportDetailCollection);
                            this.mSubreportDetailCollection.clear();
                            this.copyHeaderValuesToTempValues();
                            this.copyDataValuesToTempFields();
                            this.mRetroActiveEmplPageChange = true;
                            this.resetDataSumme();
                        }
                        this.resetDataEmployee();
                        this.setStringValues(monthOldNewHM.ewtOldStringValuesMap);
                        this.setBigDecimalValues(monthOldNewHM.ewtOldBigDecimalValuesMap);
                        this.addSumme();
                        this.buildCollectionRetroActive();
                        this.resetDataEmployee();
                        this.setStringValues(monthOldNewHM.ewtNewStringValuesMap);
                        this.setBigDecimalValues(monthOldNewHM.ewtNewBigDecimalValuesMap);
                        this.addSumme();
                        this.buildCollectionRetroActive();
                        firstPurchaseOldNewIt = false;
                    }
                    if (!(ewt.getEmployeeToBeRegarded() || StringMapper.equal((String)this.mCurrentOidPCompany, (String)this.mCurrentOidPCompanyTemp) && StringMapper.equal((String)this.mCurrentOidPlant, (String)this.mCurrentOidPlantTemp) && StringMapper.equal((String)this.mCurrentSortCriteriaKey, (String)this.mCurrentSortCriteriaKeyTemp))) {
                        return next;
                    }
                }
                this.resetDataEmployee();
                if (ewt.getEmployeeToBeRegarded()) {
                    if (ewt.getOldNewValuesMap() == null) {
                        this.mCurrentOidPCompanyTemp = this.mCurrentOidPCompany;
                        this.mCurrentOidPlantTemp = this.mCurrentOidPlant;
                        this.mCurrentSortCriteriaKeyTemp = this.mCurrentSortCriteriaKey;
                        this.copyDataValuesToTempFields();
                        this.copyHeaderValuesToTempValues();
                    }
                    this.resetDataEmployee();
                    this.getDataFor(ewt);
                    if (!this.mFirstPurchase) {
                        if (!(this.mRetroActiveEmplPageChange || StringMapper.equal((String)this.mCurrentOidPCompany, (String)this.mCurrentOidPCompanyTemp) && StringMapper.equal((String)this.mCurrentOidPlant, (String)this.mCurrentOidPlantTemp) && StringMapper.equal((String)this.mCurrentSortCriteriaKey, (String)this.mCurrentSortCriteriaKeyTemp))) {
                            this.FIELD_seitenwechsel = this.FIELD_seitenwechsel.equals("Seitenwechesl_1") ? "Seitenwechesl_2" : "Seitenwechesl_1";
                            this.mSubreportDetailCollection_temp.clear();
                            this.mSubreportDetailCollection_temp.addAll(this.mSubreportDetailCollection);
                            this.mSubreportDetailCollection.clear();
                            this.resetDataSumme();
                            this.buildCollection();
                            this.addSumme();
                            return true;
                        }
                        this.buildCollection();
                        this.addSumme();
                        if (this.mRetroActiveEmplPageChange) {
                            this.mRetroActiveEmplPageChange = false;
                            break;
                        }
                    } else {
                        this.buildCollection();
                        this.addSumme();
                        this.mFirstPurchase = false;
                    }
                }
                if (!this.mRetroActiveEmplPageChange) continue;
                this.mRetroActiveEmplPageChange = false;
            }
            if (!this.mPrintCurrentEmployee && !this.mEmployeeWageTaxEFRit.hasNext()) {
                if (!StringMapper.equal((String)this.mCurrentOidPlant, (String)this.mCurrentOidPlantTemp) && !StringMapper.isNullString((String)this.mCurrentOidPlantTemp)) {
                    this.mCurrentOidPlantTemp = this.mCurrentOidPlant;
                }
                this.mSubreportDetailCollection_temp.clear();
                this.mSubreportDetailCollection_temp.addAll(this.mSubreportDetailCollection);
                this.mSubreportDetailCollection.clear();
                this.copyHeaderValuesToTempValues();
                this.copyDataValuesToTempFields();
                this.FIELD_seitenwechsel = this.FIELD_seitenwechsel.equals("Seitenwechesl_1") ? "Seitenwechesl_2" : "Seitenwechesl_1";
                next = true;
                this.mPrintCurrentEmployee = true;
            }
            if (!next && !this.mLastRun && this.mPCompanyHasPlants && !this.mSumBeanHashMap.isEmpty()) {
                this.buildSumCollection();
                this.mSubreportDetailCollection_temp.clear();
                this.mSubreportDetailCollection_temp.addAll(this.mSubreportDetailCollection);
                this.mSubreportDetailCollection.clear();
                this.copySumHeaderValuesToTempValues();
                this.copySumDataValuesToTempFields();
                this.FIELD_seitenwechsel = "Seitenwechsel_3";
                next = true;
                this.mLastRun = true;
            }
            return next;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (BusinessDomainException e) {
            throw new JRException((Throwable)e);
        }
    }

    private void buildCollection() {
        this.mSubreportDetailCollection.add(new JournalOfWageShortMonthlyBean(this.FIELD_STATUS, this.FIELD_MONAT_JAHR, this.FIELD_PERSONAL_NR, this.FIELD_NAME, this.FIELD_VORNAME, this.FIELD_KRANKENKASSE, this.FIELD_BEITR_GP_KV, this.FIELD_BEITR_GP_RV, this.FIELD_BEITR_GP_AV, this.FIELD_BEITR_GP_PV, this.FIELD_PARENT, this.toCurrencyFormat(this.FIELD_GESAMT_BRUTTO), this.toCurrencyFormat(this.FIELD_LOHNSTEUER), this.toCurrencyFormat(this.FIELD_KV_ENTGELT), this.toCurrencyFormat(this.FIELD_RV_ENTGELT), this.toCurrencyFormat(this.FIELD_AV_ENTGELT), this.toCurrencyFormat(this.FIELD_PV_ENTGELT), this.toCurrencyFormat(this.FIELD_KV_AGZ), this.toCurrencyFormat(this.FIELD_UMLAGE_ENTGELT), this.toCurrencyFormat(this.FIELD_GESETZLICHE_ABZUEGE), this.toCurrencyFormat(this.FIELD_VWL), this.toCurrencyFormat(this.FIELD_AN_PAUSCHAL), this.toCurrencyFormat(this.FIELD_ZVK_ANA), this.FIELD_STEUERKLASSE, this.FIELD_STEUERTABELLE, this.FIELD_STEUERFAKTOR, this.FIELD_ZKF, this.FIELD_RELI_AN, this.FIELD_RELI_EG, this.FIELD_GFB, this.FIELD_GRV, this.FIELD_MFB, this.FIELD_RK, this.toCurrencyFormat(this.FIELD_STEUER_BRUTTO), this.toCurrencyFormat(this.FIELD_KIST), this.toCurrencyFormat(this.FIELD_KV_ANA), this.toCurrencyFormat(this.FIELD_RV_ANA), this.toCurrencyFormat(this.FIELD_AV_ANA), this.toCurrencyFormat(this.FIELD_PV_ANA), this.toCurrencyFormat(this.FIELD_RV_AGZ), this.toCurrencyFormat(this.FIELD_UMLAGE_BEITRAG), this.toCurrencyFormat(this.FIELD_NETTOLOHN), this.toCurrencyFormat(this.FIELD_KAMMER), this.toCurrencyFormat(this.FIELD_AG_PAUSCHAL), this.toCurrencyFormat(this.FIELD_GFB_PAUSCHAL), this.toCurrencyFormat(this.FIELD_AG_KOSTEN), this.FIELD_ZEITRAUMVON, this.FIELD_ZEITRAUMBIS, this.toCurrencyFormat(this.FIELD_ST_TAGE), this.toCurrencyFormat(this.FIELD_SV_TAGE), this.FIELD_MTL_FREIB, this.FIELD_JHL_FREIB, this.FIELD_VBZ, this.FIELD_AE, this.FIELD_PGS, this.toCurrencyFormat(this.FIELD_SV_BRUTTO), this.toCurrencyFormat(this.FIELD_SOLIDARITAETSZUSCHLAG), this.toCurrencyFormat(this.FIELD_KV_AGA), this.toCurrencyFormat(this.FIELD_RV_AGA), this.toCurrencyFormat(this.FIELD_AV_AGA), this.toCurrencyFormat(this.FIELD_PV_AGA), this.toCurrencyFormat(this.FIELD_PV_AGZ), this.toCurrencyFormat(this.FIELD_INSG_UMLAGE), this.toCurrencyFormat(this.FIELD_BE_ABZUEGE), this.toCurrencyFormat(this.FIELD_KUG), this.toCurrencyFormat(this.FIELD_ZVK_AGA), this.toCurrencyFormat(this.FIELD_AUSZAHLUNG)));
    }

    private void buildSumCollection() {
        LinkedList<JournalOfWageShortMonthlySumBean> beanList = new LinkedList<JournalOfWageShortMonthlySumBean>(this.mSumBeanHashMap.values());
        for (JournalOfWageShortMonthlySumBean bean : beanList) {
            if (bean == null) continue;
            this.mSubreportDetailCollection.add(new JournalOfWageShortMonthlyBean("", "", "", bean.getF_betriebsstaette(), "", "", "", "", "", "", "", bean.getF_gesamt_brutto(), bean.getF_lst(), bean.getF_kv_entgelt(), bean.getF_rv_entgelt(), bean.getF_av_entgelt(), bean.getF_pv_entgelt(), bean.getF_kv_agz(), bean.getF_u_entgelt(), bean.getF_gesetzl_abz(), bean.getF_vwl(), bean.getF_an_pauschal(), bean.getF_zvk_ana(), "", "", "", "", "", "", "", "", "", "", bean.getF_steuer_brutto(), bean.getF_kist(), bean.getF_kv_ana(), bean.getF_rv_ana(), bean.getF_av_ana(), bean.getF_pv_ana(), bean.getF_rv_agz(), bean.getF_u_beitrag(), bean.getF_nettolohn(), bean.getF_kammer(), bean.getF_ag_pauschal(), bean.getF_gfb_pauschal(), bean.getF_ag_kosten(), "", "", "", "", "", "", "", "", "", bean.getF_sv_brutto(), bean.getF_solz(), bean.getF_kv_aga(), bean.getF_rv_aga(), bean.getF_av_aga(), bean.getF_pv_aga(), bean.getF_pv_agz(), bean.getF_insg_umlage(), bean.getF_bezuege_abzuege(), bean.getF_kug(), bean.getF_zvk_aga(), bean.getF_auszahlung()));
        }
    }

    private void buildCollectionRetroActive() {
        this.mSubreportDetailCollection.add(new JournalOfWageShortMonthlyBean(this.FIELD_STATUS, this.FIELD_MONAT_JAHR, this.FIELD_PERSONAL_NR, this.FIELD_NAME, this.FIELD_VORNAME, this.FIELD_KRANKENKASSE, this.FIELD_BEITR_GP_KV, this.FIELD_BEITR_GP_RV, this.FIELD_BEITR_GP_AV, this.FIELD_BEITR_GP_PV, this.FIELD_PARENT, this.toCurrencyFormat(this.FIELD_GESAMT_BRUTTO), this.toCurrencyFormat(this.FIELD_LOHNSTEUER), this.toCurrencyFormat(this.FIELD_KV_ENTGELT), this.toCurrencyFormat(this.FIELD_RV_ENTGELT), this.toCurrencyFormat(this.FIELD_AV_ENTGELT), this.toCurrencyFormat(this.FIELD_PV_ENTGELT), this.toCurrencyFormat(this.FIELD_KV_AGZ), this.toCurrencyFormat(this.FIELD_UMLAGE_ENTGELT), this.toCurrencyFormat(this.FIELD_GESETZLICHE_ABZUEGE), this.toCurrencyFormat(this.FIELD_VWL), this.toCurrencyFormat(this.FIELD_AN_PAUSCHAL), this.toCurrencyFormat(this.FIELD_ZVK_ANA), this.FIELD_STEUERKLASSE, this.FIELD_STEUERTABELLE, this.FIELD_STEUERFAKTOR, this.FIELD_ZKF, this.FIELD_RELI_AN, this.FIELD_RELI_EG, this.FIELD_GFB, this.FIELD_GRV, this.FIELD_MFB, this.FIELD_RK, this.toCurrencyFormat(this.FIELD_STEUER_BRUTTO), this.toCurrencyFormat(this.FIELD_KIST), this.toCurrencyFormat(this.FIELD_KV_ANA), this.toCurrencyFormat(this.FIELD_RV_ANA), this.toCurrencyFormat(this.FIELD_AV_ANA), this.toCurrencyFormat(this.FIELD_PV_ANA), this.toCurrencyFormat(this.FIELD_RV_AGZ), this.toCurrencyFormat(this.FIELD_UMLAGE_BEITRAG), this.toCurrencyFormat(this.FIELD_NETTOLOHN), this.toCurrencyFormat(this.FIELD_KAMMER), this.toCurrencyFormat(this.FIELD_AG_PAUSCHAL), this.toCurrencyFormat(this.FIELD_GFB_PAUSCHAL), this.toCurrencyFormat(this.FIELD_AG_KOSTEN), this.FIELD_ZEITRAUMVON, this.FIELD_ZEITRAUMBIS, this.toCurrencyFormat(this.FIELD_ST_TAGE), this.toCurrencyFormat(this.FIELD_SV_TAGE), this.FIELD_MTL_FREIB, this.FIELD_JHL_FREIB, this.FIELD_VBZ, this.FIELD_AE, this.FIELD_PGS, this.toCurrencyFormat(this.FIELD_SV_BRUTTO), this.toCurrencyFormat(this.FIELD_SOLIDARITAETSZUSCHLAG), this.toCurrencyFormat(this.FIELD_KV_AGA), this.toCurrencyFormat(this.FIELD_RV_AGA), this.toCurrencyFormat(this.FIELD_AV_AGA), this.toCurrencyFormat(this.FIELD_PV_AGA), this.toCurrencyFormat(this.FIELD_PV_AGZ), this.toCurrencyFormat(this.FIELD_INSG_UMLAGE), this.toCurrencyFormat(this.FIELD_BE_ABZUEGE), this.toCurrencyFormat(this.FIELD_KUG), this.toCurrencyFormat(this.FIELD_ZVK_AGA), "-"));
    }

    private String toCurrencyFormat(Object obj) {
        String temp2;
        String temp1;
        Object temp = BigDecimalMapper.toString((BigDecimal)((BigDecimal)obj));
        int length = ((String)temp).length();
        if (((String)temp).substring(0, 1).equals("-")) {
            --length;
        }
        if (length < 7) {
            temp = ((String)temp).replace('.', ',');
        }
        if (length >= 7 && length < 10) {
            temp = ((String)temp).replace('.', ',');
            temp1 = ((String)temp).substring(0, ((String)temp).length() - 6);
            temp2 = ((String)temp).substring(((String)temp).length() - 6, ((String)temp).length());
            temp = temp1 + "." + temp2;
        }
        if (length >= 10) {
            temp = ((String)temp).replace('.', ',');
            temp1 = ((String)temp).substring(0, ((String)temp).length() - 9);
            temp2 = ((String)temp).substring(((String)temp).length() - 9, ((String)temp).length() - 6);
            String temp3 = ((String)temp).substring(((String)temp).length() - 6, ((String)temp).length());
            temp = temp1 + "." + temp2 + "." + temp3;
        }
        return temp;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object temp;
        Object value = null;
        String fieldName = field.getName();
        if (fieldName.equals("archi_string")) {
            ArchivingMetadata am = new ArchivingMetadata();
            am.setUserID(this.mUser);
            am.setCompanyKeyAndName(this.mPCompanyReportHeaderKeyDescription);
            am.setValidFrom(this.mListFirstDate);
            am.setValidUntil(this.mListEndDate);
            am.setPlantKey(this.temp_FIELD_PLANT_KEY);
            am.setReportName("Monatslohnjournal");
            return am.getArchiString();
        }
        if (fieldName.equals("version")) {
            value = this.mVersion;
        }
        if (fieldName.equals("monat")) {
            value = this.temp_FIELD_MONAT;
        }
        if (fieldName.equals("datumjahr")) {
            value = this.temp_FIELD_DATUMJAHR;
        }
        if (fieldName.equals("firma")) {
            value = this.mPCompanyReportHeaderKeyDescription;
        }
        if (fieldName.equals("betriebsstaette")) {
            temp = this.temp_FIELD_PLANT_KEY + this.temp_FIELD_BETRIEBSSTAETTE;
            if (StringMapper.isNullString((String)temp)) {
                value = "";
            } else {
                temp = StringMapper.isNullString((String)this.temp_FIELD_PLANT_KEY) ? this.temp_FIELD_BETRIEBSSTAETTE : this.temp_FIELD_PLANT_KEY + " / " + this.temp_FIELD_BETRIEBSSTAETTE;
                value = temp = ((String)temp).length() > 40 ? ((String)temp).substring(0, 40) : temp;
            }
        }
        if (fieldName.equals("sortierkriterium")) {
            value = this.temp_FIELD_SORT_CRITERIA;
        }
        if (fieldName.equals("sortierkriteriumschluesselbeschreibung")) {
            temp = this.temp_FIELD_SORT_CRITERIA_KEY + this.temp_FIELD_SORT_CRITERIA_DESCRIPTION;
            value = StringMapper.isNullString((String)temp) ? "" : this.temp_FIELD_SORT_CRITERIA_KEY + " / " + this.temp_FIELD_SORT_CRITERIA_DESCRIPTION;
        }
        if (fieldName.equals("seitenwechsel")) {
            value = this.FIELD_seitenwechsel;
        }
        if (fieldName.equals("summe_gesamt_brutto")) {
            value = this.temp_summe_gesamt_brutto;
        }
        if (fieldName.equals("summe_lst")) {
            value = this.temp_summe_lst;
        }
        if (fieldName.equals("summe_kv_entgelt")) {
            value = this.temp_summe_kv_entgelt;
        }
        if (fieldName.equals("summe_rv_entgelt")) {
            value = this.temp_summe_rv_entgelt;
        }
        if (fieldName.equals("summe_av_entgelt")) {
            value = this.temp_summe_av_entgelt;
        }
        if (fieldName.equals("summe_pv_entgelt")) {
            value = this.temp_summe_pv_entgelt;
        }
        if (fieldName.equals("summe_kv_agz")) {
            value = this.temp_summe_kv_agz;
        }
        if (fieldName.equals("summe_u_entgelt")) {
            value = this.temp_summe_u_entgelt;
        }
        if (fieldName.equals("summe_gesetzl_abz")) {
            value = this.temp_summe_gesetzl_abz;
        }
        if (fieldName.equals("summe_vwl")) {
            value = this.temp_summe_vwl;
        }
        if (fieldName.equals("summe_an_pauschal")) {
            value = this.temp_summe_an_pauschal;
        }
        if (fieldName.equals("summe_zvk_ana")) {
            value = this.temp_summe_zvk_ana;
        }
        if (fieldName.equals("summe_steuer_brutto")) {
            value = this.temp_summe_steuer_brutto;
        }
        if (fieldName.equals("summe_kist")) {
            value = this.temp_summe_kist;
        }
        if (fieldName.equals("summe_kv_ana")) {
            value = this.temp_summe_kv_ana;
        }
        if (fieldName.equals("summe_rv_ana")) {
            value = this.temp_summe_rv_ana;
        }
        if (fieldName.equals("summe_av_ana")) {
            value = this.temp_summe_av_ana;
        }
        if (fieldName.equals("summe_pv_ana")) {
            value = this.temp_summe_pv_ana;
        }
        if (fieldName.equals("summe_rv_agz")) {
            value = this.temp_summe_rv_agz;
        }
        if (fieldName.equals("summe_u_beitrag")) {
            value = this.temp_summe_u_beitrag;
        }
        if (fieldName.equals("summe_nettolohn")) {
            value = this.temp_summe_nettolohn;
        }
        if (fieldName.equals("summe_kammer")) {
            value = this.temp_summe_kammer;
        }
        if (fieldName.equals("summe_ag_pauschal")) {
            value = this.temp_summe_ag_pauschal;
        }
        if (fieldName.equals("summe_gfb_pauschal")) {
            value = this.temp_summe_gfb_pauschal;
        }
        if (fieldName.equals("summe_ag_kosten")) {
            value = this.temp_summe_ag_kosten;
        }
        if (fieldName.equals("summe_sv_brutto")) {
            value = this.temp_summe_sv_brutto;
        }
        if (fieldName.equals("summe_solz")) {
            value = this.temp_summe_solz;
        }
        if (fieldName.equals("summe_kv_aga")) {
            value = this.temp_summe_kv_aga;
        }
        if (fieldName.equals("summe_rv_aga")) {
            value = this.temp_summe_rv_aga;
        }
        if (fieldName.equals("summe_av_aga")) {
            value = this.temp_summe_av_aga;
        }
        if (fieldName.equals("summe_pv_aga")) {
            value = this.temp_summe_pv_aga;
        }
        if (fieldName.equals("summe_pv_agz")) {
            value = this.temp_summe_pv_agz;
        }
        if (fieldName.equals("summe_insg_umlage")) {
            value = this.temp_summe_insg_umlage;
        }
        if (fieldName.equals("summe_bezuege_abzuege")) {
            value = this.temp_summe_bezuege_abzuege;
        }
        if (fieldName.equals("summe_kug")) {
            value = this.temp_summe_kug;
        }
        if (fieldName.equals("summe_zvk_aga")) {
            value = this.temp_summe_zvk_aga;
        }
        if (fieldName.equals("summe_auszahlung")) {
            value = this.temp_summe_auszahlung;
        }
        if (fieldName.equals("subreport_detail_bean")) {
            value = this.mSubreportDetailCollection_temp;
        }
        if (value instanceof BigDecimal) {
            value = this.toCurrencyFormat(value);
        }
        return value;
    }

    private Map<String, List<PlantfoundationsContainer>> getPlantFoundationsHistoryForEmployees(Date forEffectiveDate, Date listFirstDate, Date listEndDate) {
        HashMap<String, LinkedList<PlantfoundationsContainer>> plantfoundationsMap = null;
        try {
            PersistencyDataSet plantfoundationsDatas = daoPlantfoundations.getDataSet(new Order[]{Order.asc((String)"oidplant"), Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidplant", (String[])this.mResultOidPlant), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)forEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)forEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)listEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)listFirstDate))}));
            if (plantfoundationsDatas != null) {
                plantfoundationsMap = new HashMap<String, LinkedList<PlantfoundationsContainer>>();
                while (plantfoundationsDatas.hasNext()) {
                    PlantfoundationsContainer plantfoundationsContainer = (PlantfoundationsContainer)plantfoundationsDatas.getNext();
                    LinkedList<PlantfoundationsContainer> liste = (LinkedList<PlantfoundationsContainer>)plantfoundationsMap.get(plantfoundationsContainer.oidplant);
                    if (liste == null) {
                        liste = new LinkedList<PlantfoundationsContainer>();
                        plantfoundationsMap.put(plantfoundationsContainer.oidplant, liste);
                    }
                    liste.add(plantfoundationsContainer);
                }
            }
        }
        catch (RuntimeException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return plantfoundationsMap;
    }

    private static boolean isRelevantToAdd(ValuePosition valuePosition, Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        ConsequenceOfValueType[] consequencesOfVT;
        for (ConsequenceOfValueType consequenceOfVT : consequencesOfVT = valuePosition.getValueType().getValueTypeTP(effectiveTimePoint, validTimePoint).getConsequenceForOrientation()) {
            if (consequenceOfVT.getConsequenceOfValueType().getValueTypeKey() != 100200) continue;
            return false;
        }
        return true;
    }

    private static class EmployeeJournalOfWageShortMonthly {
        private final EmployeeForReport eFR;
        private Date employeeStartDate;
        private Date employeeEndDate;
        private Date dateOfEntery;
        private String oidPCompany = "";
        private String oidPlant = "";
        private String plantKey = "";
        private String plantDescription = "";
        private String sortCriteria = "";
        private String sortCriteriaDescription = "";
        private String sortCriteriaKey = "";
        private PlantfoundationsContainer plantfoundationsContainer;
        private MasterallContainer masterAllContainer;
        private EmploymentContainer employmentContainer;
        private TaxContainer taxContainer;
        private InsuranceContainer insuranceContainer;
        private List<ValuepositionContainer> valuePositionli;
        private Map<String, OldNewValues> oldNewValuesMap;
        private boolean employeeToBeRegarded = true;

        public EmployeeJournalOfWageShortMonthly(EmployeeForReport eFR) {
            this.eFR = eFR;
        }

        public EmployeeJournalOfWageShortMonthly createNew() {
            EmployeeJournalOfWageShortMonthly eWT = new EmployeeJournalOfWageShortMonthly(EmployeeForReportGenerator.createNew((EmployeeForReport)this.eFR));
            eWT.masterAllContainer = this.masterAllContainer;
            eWT.employmentContainer = this.employmentContainer;
            eWT.taxContainer = this.taxContainer;
            eWT.plantfoundationsContainer = this.plantfoundationsContainer;
            eWT.insuranceContainer = this.insuranceContainer;
            eWT.employeeStartDate = this.employeeStartDate;
            eWT.employeeEndDate = this.employeeEndDate;
            eWT.valuePositionli = this.valuePositionli;
            eWT.oldNewValuesMap = this.oldNewValuesMap;
            eWT.employeeToBeRegarded = this.employeeToBeRegarded;
            eWT.dateOfEntery = this.dateOfEntery;
            eWT.oidPCompany = this.oidPCompany;
            eWT.oidPlant = this.oidPlant;
            eWT.plantDescription = this.plantDescription;
            eWT.sortCriteria = this.sortCriteria;
            eWT.sortCriteriaDescription = this.sortCriteriaDescription;
            eWT.sortCriteriaKey = this.sortCriteriaKey;
            eWT.plantKey = this.plantKey;
            return eWT;
        }

        public EmployeeForReport getEmployeeForReport() {
            return this.eFR;
        }

        public Date getEmployeeStartDate() {
            return this.employeeStartDate;
        }

        public Date getEmployeeEndDate() {
            return this.employeeEndDate;
        }

        public EmploymentContainer getEmploymentContainer() {
            return this.employmentContainer;
        }

        public MasterallContainer getMasterallContainer() {
            return this.masterAllContainer;
        }

        public TaxContainer getTaxContainer() {
            return this.taxContainer;
        }

        public PlantfoundationsContainer getPlantfoundationsContainer() {
            return this.plantfoundationsContainer;
        }

        public InsuranceContainer getInsuranceContainer() {
            return this.insuranceContainer;
        }

        public List<ValuepositionContainer> getValuePositionli() {
            return this.valuePositionli;
        }

        public Map<String, OldNewValues> getOldNewValuesMap() {
            return this.oldNewValuesMap;
        }

        public boolean getEmployeeToBeRegarded() {
            return this.employeeToBeRegarded;
        }

        public String getEmployeeSortCriteria() {
            return this.sortCriteria;
        }

        public String getEmployeeSortCriteriaDescription() {
            return this.sortCriteriaDescription;
        }

        public String getEmployeeSortCriteriaKey() {
            return this.sortCriteriaKey;
        }

        public String getPlantDescription() {
            return this.plantDescription;
        }

        public String getPlantKey() {
            return this.plantKey;
        }

        public void setEmployeeStartDate(Date employeeStartDate) {
            this.employeeStartDate = employeeStartDate;
        }

        public void setEmployeeEndDate(Date employeeEndDate) {
            this.employeeEndDate = employeeEndDate;
        }

        public void setDateOfEntery(Date dateOfEntery) {
            this.dateOfEntery = dateOfEntery;
        }

        public void setMasterallContainer(MasterallContainer masterAllContainer) {
            this.masterAllContainer = masterAllContainer;
        }

        public void setTaxContainer(TaxContainer taxContainer) {
            this.taxContainer = taxContainer;
        }

        public void setPlantfoundationsContainer(PlantfoundationsContainer plantfoundationsContainer) {
            this.plantfoundationsContainer = plantfoundationsContainer;
        }

        public void setValuePositionli(List<ValuepositionContainer> valuePositionli) {
            this.valuePositionli = valuePositionli;
        }

        public void setInsuranceContainer(InsuranceContainer insuranceContainer) {
            this.insuranceContainer = insuranceContainer;
        }

        public void setOldNewValuesMap(Map<String, OldNewValues> oldNewValuesMap) {
            this.oldNewValuesMap = oldNewValuesMap;
        }

        public void setEmployeeToBeRegarded(boolean employeeToBeRegarded) {
            this.employeeToBeRegarded = employeeToBeRegarded;
        }

        public void setEmployeeSortCriteria(String sortCriteria) {
            this.sortCriteria = sortCriteria;
        }

        public void setEmployeesortCriteriaDescription(String sortCriteriaDescription) {
            this.sortCriteriaDescription = sortCriteriaDescription;
        }

        public void setEmployeeSortCriteriaKey(String sortCriteriaKey) {
            this.sortCriteriaKey = sortCriteriaKey;
        }

        public void setPlantDescription(String plantDescription) {
            this.plantDescription = plantDescription;
        }

        public void setOidPCompany(String oidPCompany) {
            this.oidPCompany = oidPCompany;
        }

        public void setOidPlant(String oidPlant) {
            this.oidPlant = oidPlant;
        }

        public void setPlantyKey(String plantKey) {
            this.plantKey = plantKey;
        }
    }

    private static class InternalEmployeeBean {
        private Date startDate;
        private EmployeeForReport current;
        private InternalHistoryBean history;

        private InternalEmployeeBean() {
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public EmployeeForReport getCurrent() {
            return this.current;
        }

        public void setCurrent(EmployeeForReport current) {
            this.current = current;
        }

        public InternalHistoryBean getHistory() {
            return this.history;
        }

        public void setHistory(InternalHistoryBean mapAll) {
            this.history = mapAll;
        }
    }

    private static class InternalHistoryBean {
        private Map<String, List<TaxContainer>> tax;
        private Map<String, List<InsuranceContainer>> insurance;
        private Map<String, List<MasterallContainer>> masterAll;
        private Map<String, List<PlantfoundationsContainer>> plantFoundation;

        private InternalHistoryBean() {
        }

        public Map<String, List<TaxContainer>> getTax() {
            return this.tax;
        }

        public void setTax(Map<String, List<TaxContainer>> tax) {
            this.tax = tax;
        }

        public Map<String, List<InsuranceContainer>> getInsurance() {
            return this.insurance;
        }

        public void setInsurance(Map<String, List<InsuranceContainer>> insurance) {
            this.insurance = insurance;
        }

        public Map<String, List<MasterallContainer>> getMasterAll() {
            return this.masterAll;
        }

        public void setMasterAll(Map<String, List<MasterallContainer>> masterAll) {
            this.masterAll = masterAll;
        }

        public Map<String, List<PlantfoundationsContainer>> getPlantFoundation() {
            return this.plantFoundation;
        }

        public void setPlantFoundation(Map<String, List<PlantfoundationsContainer>> plantFoundation) {
            this.plantFoundation = plantFoundation;
        }
    }

    private class OldNewValues {
        private boolean areEqual;
        private EmployeeJournalOfWageShortMonthly ewtNew;
        private Map<String, String> ewtNewStringValuesMap;
        private Map<String, BigDecimal> ewtNewBigDecimalValuesMap;
        private EmployeeJournalOfWageShortMonthly ewtOld;
        private Map<String, String> ewtOldStringValuesMap;
        private Map<String, BigDecimal> ewtOldBigDecimalValuesMap;

        private OldNewValues() {
        }

        private void compareOldNewValues() {
            this.areEqual = StringMapper.equal((String)this.ewtOld.getEmployeeForReport().getOidPCompany(), (String)this.ewtNew.getEmployeeForReport().getOidPCompany());
            if (JournalOfWageShortMonthlyReportDataSource.this.mPCompanyHasPlants) {
                this.areEqual = StringMapper.equal((String)this.ewtOld.getEmployeeForReport().getOidPlant(), (String)this.ewtNew.getEmployeeForReport().getOidPlant());
            }
            LinkedList<String> stringValuesOldli = new LinkedList<String>(this.ewtOldStringValuesMap.keySet());
            Iterator stringValuesOldit = stringValuesOldli.iterator();
            while (stringValuesOldit.hasNext() && this.areEqual) {
                String stringValuesOldKey = (String)stringValuesOldit.next();
                this.areEqual = StringMapper.equal((String)this.ewtOldStringValuesMap.get(stringValuesOldKey), (String)this.ewtNewStringValuesMap.get(stringValuesOldKey));
            }
            LinkedList<String> bigDecimalValuesOldli = new LinkedList<String>(this.ewtOldBigDecimalValuesMap.keySet());
            Iterator bigDecimalValuesOldit = bigDecimalValuesOldli.iterator();
            while (bigDecimalValuesOldit.hasNext() && this.areEqual) {
                String bigDecimalValuesOldKey = ((String)bigDecimalValuesOldit.next()).toString();
                if (StringMapper.equal((String)"FIELD_AUSZAHLUNG", (String)bigDecimalValuesOldKey)) {
                    bigDecimalValuesOldKey = "";
                }
                this.areEqual = BigDecimalMapper.compareTo((BigDecimal)this.ewtOldBigDecimalValuesMap.get(bigDecimalValuesOldKey), (BigDecimal)this.ewtNewBigDecimalValuesMap.get(bigDecimalValuesOldKey)) == 0;
            }
            if (!this.areEqual) {
                HashMap<String, BigDecimal> temp_BigDecimalValuesOldHM = new HashMap<String, BigDecimal>();
                for (String bigDecimalValuesOldKey : bigDecimalValuesOldli) {
                    BigDecimal temp_Value = this.ewtOldBigDecimalValuesMap.get(bigDecimalValuesOldKey);
                    temp_BigDecimalValuesOldHM.put(bigDecimalValuesOldKey, temp_Value.multiply(new BigDecimal(-1)));
                }
                String monat_jahr = ReportHelper.getMonthDescription((int)new VDate(this.ewtOld.getEmployeeStartDate()).getMonth()) + " / " + Integer.toString(new VDate(this.ewtOld.getEmployeeStartDate()).getYear());
                this.ewtOldStringValuesMap.put("FIELD_STATUS", "storno");
                this.ewtOldStringValuesMap.put("FIELD_MONAT_JAHR", monat_jahr);
                this.ewtNewStringValuesMap.put("FIELD_STATUS", "neu");
                this.ewtNewStringValuesMap.put("FIELD_MONAT_JAHR", monat_jahr);
                this.ewtOldBigDecimalValuesMap = temp_BigDecimalValuesOldHM;
            }
        }
    }
}

