/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.journalofwageshort;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.CorbaExceptionMapper;
import com.varial.personnel.domain.employee.tax.mapper.ChurchTaxEnumMapper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundPersistencyManager;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.reports.ArchivingMetadata;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortCriteria;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.StringComparator;
import com.varial.personnel.domain.reports.journalofwageshort.JournalOfWageEmployeeBean;
import com.varial.personnel.domain.reports.journalofwageshort.JournalOfWageShortSumBean;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.library.EmployerBean;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.library.ReportsSortComparator;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.typeofvalue.consequenceofvaluetype.ConsequenceOfValueType;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.basictypes.PRestrictions;
import com.varial.personnel.persistency.employee.employment.EmploymentContainer;
import com.varial.personnel.persistency.employee.employment.IEmploymentDao;
import com.varial.personnel.persistency.employee.insurance.IInsuranceDao;
import com.varial.personnel.persistency.employee.insurance.InsuranceContainer;
import com.varial.personnel.persistency.employee.masterall.IMasterallDao;
import com.varial.personnel.persistency.employee.masterall.MasterallContainer;
import com.varial.personnel.persistency.employee.tax.ITaxDao;
import com.varial.personnel.persistency.employee.tax.TaxContainer;
import com.varial.personnel.persistency.employee.valueposition.IValuepositionDao;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.query.AllCallback;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalOfWageShortReportDataSource
implements JRDataSource {
    private static IEmploymentDao daoEmployment = (IEmploymentDao)UtilitiesManager.getApplicationContext().getBean("employmentDao");
    private static IInsuranceDao daoInsurance = (IInsuranceDao)UtilitiesManager.getApplicationContext().getBean("insuranceDao");
    private static IMasterallDao daoMasterall = (IMasterallDao)UtilitiesManager.getApplicationContext().getBean("masterallDao");
    private static ITaxDao daoTax = (ITaxDao)UtilitiesManager.getApplicationContext().getBean("taxDao");
    private static IValuepositionDao daoValueposition = (IValuepositionDao)UtilitiesManager.getApplicationContext().getBean("valuepositionDao");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JournalOfWageShortReportDataSource.class.getName());
    private final ReportHelper mReportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);
    private static final String PARAMETER_USER = "Parameter_User";
    private static final String staticText_internalUse = "internalUse";
    private static final String PARAMETER_AUSSICHT = "PARAMETER_AUSSICHT";
    private static final int mMaximumReportHeaderPlantDescription = 40;
    private final String mVersion;
    private PersistencyDataSet mMasterallDatas;
    private PersistencyDataSet mInsuranceDatas;
    private PersistencyDataSet mTaxDatas;
    private PersistencyDataSet mEmploymentDatas;
    private final CompanySettings mCompanySettings;
    private boolean mPCompanyHasPlants = false;
    private boolean mLastRuns = false;
    private final Map<String, List<MasterallContainer>> mMasterAllMap = new HashMap<String, List<MasterallContainer>>();
    private final Map<String, JournalOfWageShortSumBean> mSumBeanHashMap = new HashMap<String, JournalOfWageShortSumBean>();
    private final Map<String, List<InsuranceContainer>> mInsuranceAllMap = new HashMap<String, List<InsuranceContainer>>();
    private final Map<String, List<TaxContainer>> mTaxAllMap = new HashMap<String, List<TaxContainer>>();
    private final Map<String, List<EmploymentContainer>> mEmploymentAllMap = new HashMap<String, List<EmploymentContainer>>();
    private String mPCompanyReportHeaderKeyDescription = "";
    private PersistencyDataSet mValuePositionDatas;
    private final Map<String, HealthFund> mHealthFundMap = new HashMap<String, HealthFund>();
    private MasterallContainer mMasterAllContainer;
    private InsuranceContainer mInsuranceContainer;
    private TaxContainer mTaxContainer;
    private EmploymentContainer mEmploymentContainer;
    protected String[] mResultValueTypeNumber = new String[]{"100100", "100910", "100920", "100930", "100940", "100950", "100960", "100970", "110000", "110590", "130000", "130590", "145110", "145160", "145170", "145210", "145215", "145220", "145225", "145310", "145320", "145360", "145370", "220010", "220050", "223050", "226010", "230510", "230520", "250510", "250610", "320510", "320520", "321050", "322050", "323050", "327050", "328050", "329050", "333050", "334050", "335050", "339050", "340050", "341050", "350510", "351050", "355050", "360050", "361050", "366050", "401100", "401150", "401300", "401350", "700000", "702000", "710010", "710020", "736300", "760100", "760110", "760120", "760130", "760400", "760410", "760420", "760430", "760450", "760460", "760470", "760480", "770020", "770025", "770030", "770035", "770040", "770045", "770050", "770055", "770120", "770130", "770140", "771020", "771030", "771040", "771050", "771120", "771130", "771140", "772100", "775050", "860000", "861000", "862000", "863000", "870000", "871000", "886200", "890000", "890100"};
    private boolean mFirstPurchase = true;
    private boolean mNext;
    private final boolean mInternalUse;
    private String TEMP_BETRIEBSSTAETTE = "temp";
    private String SEITENWECHSEL = "Seitenwechesl_1";
    private String mCurrentOidEmployee;
    private final Iterator<JournalOfWageEmployeeBean> mEmployeeForReportIt;
    private Iterator<JournalOfWageShortSumBean> mSumBeanIterator;
    private String[] mResultOidEmployee;
    private final int mForYear;
    private final Date mForEffectiveDate;
    private Date mListFirstDate;
    private final Date mListEndDate;
    private Date mEmployeeFirstDate;
    private Date mEmployeeEndDate;
    private Date mStammEndDate;
    protected String mStaticText_internalUse = "";
    protected String mUser = "";
    private String FIELD_MONAT_BIS = "";
    private String FIELD_BETRIEBSSTAETTE = "";
    private String FIELD_BETRIEBSSTAETTE_KEY = "";
    private String FIELD_DATUMJAHR = "";
    private String FIELD_PERSONAL_NR = "";
    private String FIELD_NAME = "";
    private String FIELD_VORNAME = "";
    private String FIELD_KRANKENKASSE = "";
    private String FIELD_BEITR_GP_KV = "";
    private String FIELD_BEITR_GP_RV = "";
    private String FIELD_BEITR_GP_AV = "";
    private String FIELD_BEITR_GP_PV = "";
    private String FIELD_PARENT = "";
    private String FIELD_STEUERKLASSE = "";
    private String FIELD_STEUERTABELLE = "";
    private String FIELD_STEUERFAKTOR = "";
    private String FIELD_ZKF = "";
    private String FIELD_RELI_AN = "";
    private String FIELD_RELI_EG = "";
    private String FIELD_GFB = "";
    private String FIELD_GRV = "";
    private String FIELD_MFB = "";
    private String FIELD_RK = "";
    private String FIELD_ZEITRAUMVON = "";
    private String FIELD_ZEITRAUMBIS = "";
    private String FIELD_VBZ = "";
    private String FIELD_AE = "";
    private String FIELD_PGS = "";
    private BigDecimal FIELD_MTL_FREIB = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_JHL_FREIB = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_ST_TAGE = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_SV_TAGE = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_GESAMT_BRUTTO = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_LOHNSTEUER = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KV_ENTGELT = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_RV_ENTGELT = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AV_ENTGELT = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_PV_ENTGELT = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KV_AGZ = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_UMLAGE_ENTGELT = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_GESETZLICHE_ABZUEGE = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_VWL = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AN_PAUSCHAL = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_ZVK_ANA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_STEUER_BRUTTO = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KIST = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KV_ANA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_RV_ANA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AV_ANA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_PV_ANA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_RV_AGZ = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_UMLAGE_BEITRAG = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_NETTOLOHN = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KAMMER = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AG_PAUSCHAL = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_GFB_PAUSCHAL = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AG_KOSTEN = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_SV_BRUTTO = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_SOLIDARITAETSZUSCHLAG = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KV_AGA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_RV_AGA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AV_AGA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_PV_AGA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_PV_AGZ = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_INSG_UMLAGE = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_BE_ABZUEGE = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_KUG = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_ZVK_AGA = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_AUSZAHLUNG = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_BAV_AG_KOSTEN = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_gesamt_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_lst = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_rv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_av_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_pv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_u_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_gesetzl_abz = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_vwl = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_an_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_zvk_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_steuer_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kist = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_rv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_av_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_pv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_rv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_u_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_nettolohn = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kammer = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_ag_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_gfb_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_ag_kosten = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_sv_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_solz = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_rv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_av_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_pv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_pv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_insg_umlage = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_bezuege_abzuege = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_kug = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_zvk_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal summe_auszahlung = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_gesamt_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_lst = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_rv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_av_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_pv_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_u_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_gesetzl_abz = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_vwl = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_an_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_zvk_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_steuer_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kist = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_rv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_av_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_pv_ana = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_rv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_u_beitrag = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_nettolohn = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kammer = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_ag_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_gfb_pauschal = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_ag_kosten = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_sv_brutto = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_solz = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_rv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_av_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_pv_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_pv_agz = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_insg_umlage = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_bezuege_abzuege = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_kug = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_zvk_aga = BigDecimal.valueOf(0L, 2);
    private BigDecimal gesamtsumme_auszahlung = BigDecimal.valueOf(0L, 2);
    private final ReportSortStruct[] mReportSortSeq;
    private final EmployeeForReportGenerator generator;

    public JournalOfWageShortReportDataSource(AllCallback callback, ISpecialAccessPersistencyContext sapc, ReportFirstFilterStruct firstFilter, ReportSecondFilterStruct[] secondFilters, ReportThirdFilterStruct thirdFilter, ReportSortStruct[] sorts, Date forEffectiveDate, Date forValidDate, boolean internalUse, List<String> errorList) throws BusinessDomainException {
        this.mReportSortSeq = sorts;
        this.mUser = SessionContext.getInstance().getSession().getUserCode();
        this.mVersion = Version.getVersion();
        this.mInternalUse = internalUse;
        this.mForYear = new VDate(forValidDate).getYear();
        this.FIELD_MONAT_BIS = this.getMonth(new VDate(forValidDate).getMonth());
        this.mForEffectiveDate = DateHelper.getLastDayOfMonth((Date)forEffectiveDate);
        this.mListFirstDate = DateHelper.getFirstDayOfYear((Date)forValidDate);
        this.mListEndDate = DateHelper.getLastDayOfMonth((Date)forValidDate);
        this.initCurrentObjects();
        this.generator = new EmployeeForReportGenerator(sapc, firstFilter, secondFilters, thirdFilter, sorts, forEffectiveDate, this.mListFirstDate, this.mListEndDate, errorList);
        EmployeeForReport[] efrs = this.generator.getEmployeesForReport();
        if (!errorList.isEmpty()) {
            String[] temp = errorList.toArray(new String[errorList.size()]);
            BusinessDomainException de = ReportExceptionMapper.makeStickyEmployeesInEmployeeForReport(temp);
            errorList.clear();
            if (internalUse) {
                callback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de));
            } else {
                throw de;
            }
        }
        PCompany mEePCompany = (PCompany)this.generator.used((IPersistentObject)PCompanyPersistencyManager.getPCompany((String)efrs[0].getOidPCompany()));
        Date mCalculationStartDate = this.mReportHelper.getCalculationStartDate(mEePCompany.getCompanyFoundations(this.mForEffectiveDate, DateHelper.getLastDayOfMonth((Date)forValidDate)));
        this.mPCompanyReportHeaderKeyDescription = mEePCompany.getCompanyFoundations(this.mForEffectiveDate, forValidDate).getFoundations().getLongDescription();
        this.mPCompanyReportHeaderKeyDescription = StringMapper.isNullString((String)this.mPCompanyReportHeaderKeyDescription) ? mEePCompany.getCompanyFoundations(this.mForEffectiveDate, forValidDate).getFoundations().getShortDescription() : this.mPCompanyReportHeaderKeyDescription;
        String pCompanyKey = mEePCompany.getPCompanyKey();
        this.mPCompanyReportHeaderKeyDescription = StringMapper.isNullString((String)pCompanyKey) ? this.mPCompanyReportHeaderKeyDescription : pCompanyKey + " / " + this.mPCompanyReportHeaderKeyDescription;
        this.mPCompanyReportHeaderKeyDescription = this.mPCompanyReportHeaderKeyDescription.length() > 42 ? this.mPCompanyReportHeaderKeyDescription.substring(0, 42) : this.mPCompanyReportHeaderKeyDescription;
        this.mCompanySettings = mEePCompany.getCompanySettings(forEffectiveDate, forValidDate);
        if (this.mCompanySettings == null) {
            throw ReportExceptionMapper.makeCompanySettingsMissingDomainException();
        }
        this.mPCompanyHasPlants = this.mCompanySettings.getUsePlants();
        if (DateHelper.before((Date)this.mListFirstDate, (Date)mCalculationStartDate)) {
            this.mListFirstDate = mCalculationStartDate;
        }
        HashMap plantHashMap = new HashMap();
        for (int i = 0; i < efrs.length; ++i) {
            String oidEmployee;
            LinkedList<EmployeeForReport> liste;
            HashMap<String, LinkedList<EmployeeForReport>> employeesPlantMap;
            String plantKey;
            String string = plantKey = efrs[i].getPlantKey() == null ? "" : efrs[i].getPlantKey();
            if (plantKey == null) {
                plantKey = "";
            }
            if ((employeesPlantMap = (HashMap<String, LinkedList<EmployeeForReport>>)plantHashMap.get(plantKey)) == null) {
                employeesPlantMap = new HashMap<String, LinkedList<EmployeeForReport>>();
                plantHashMap.put(plantKey, employeesPlantMap);
            }
            if ((liste = (LinkedList<EmployeeForReport>)employeesPlantMap.get(oidEmployee = efrs[i].getOidEmployee())) == null) {
                liste = new LinkedList<EmployeeForReport>();
                liste.add(efrs[i]);
                employeesPlantMap.put(oidEmployee, liste);
                continue;
            }
            liste.add(efrs[i]);
            employeesPlantMap.put(oidEmployee, liste);
        }
        LinkedList plantsLi = new LinkedList(plantHashMap.keySet());
        Iterator plantsIt = plantsLi.iterator();
        LinkedList<JournalOfWageEmployeeBean> employeesList = new LinkedList<JournalOfWageEmployeeBean>();
        while (plantsIt.hasNext()) {
            String plantKey = ((String)plantsIt.next()).toString();
            Map employeesMap = (Map)plantHashMap.get(plantKey);
            LinkedList oidEmployeeLi = new LinkedList(employeesMap.keySet());
            for (String oidEmployeeKey : oidEmployeeLi) {
                List employeeForReportlist = (List)employeesMap.get(oidEmployeeKey);
                if (employeeForReportlist.size() > 1) {
                    employeesList.addAll(this.createJournalOfWageEmployeeBeans(employeeForReportlist));
                    continue;
                }
                JournalOfWageEmployeeBean jOWEB = this.getJournalOfWageEmployeeBean((EmployeeForReport)employeeForReportlist.get(0));
                if (jOWEB.getDateOfWithDrawal() == null) {
                    employeesList.add(jOWEB);
                    continue;
                }
                if (!DateHelper.afterOrEqual((Date)jOWEB.getDateOfWithDrawal(), (Date)this.mListFirstDate)) continue;
                employeesList.add(jOWEB);
            }
        }
        if (employeesList.isEmpty()) {
            throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
        }
        List<JournalOfWageEmployeeBean> sortedEFRLi = this.getSortedEFR(employeesList);
        this.getHashMapMasterall();
        this.getHashMapInsurance();
        this.getHashMapTax();
        this.getHashMapEmployment();
        this.mEmployeeForReportIt = sortedEFRLi.iterator();
    }

    private List<JournalOfWageEmployeeBean> createJournalOfWageEmployeeBeans(List<EmployeeForReport> eFRLi) {
        LinkedList<JournalOfWageEmployeeBean> jOWEBLi = new LinkedList<JournalOfWageEmployeeBean>();
        LinkedList<JournalOfWageEmployeeBean> oreginalJOWEBLi = new LinkedList<JournalOfWageEmployeeBean>();
        for (EmployeeForReport eFR : eFRLi) {
            JournalOfWageEmployeeBean jOWEB = this.getJournalOfWageEmployeeBean(eFR);
            if (LOGGER.isDebugEnabled()) {
                jOWEB.printValues();
            }
            oreginalJOWEBLi.add(jOWEB);
        }
        this.printIteratorValues(oreginalJOWEBLi);
        Collections.sort(oreginalJOWEBLi, new JOWBeanPreComparator());
        Iterator it = oreginalJOWEBLi.iterator();
        JournalOfWageEmployeeBean jOWEBPrevios = null;
        HashMap<Date, JournalOfWageEmployeeBean> jOWEBMap = new HashMap<Date, JournalOfWageEmployeeBean>();
        while (it.hasNext()) {
            JournalOfWageEmployeeBean jOWEBNext = (JournalOfWageEmployeeBean)it.next();
            jOWEBPrevios = (JournalOfWageEmployeeBean)jOWEBMap.get(jOWEBNext.getDateOfEntry());
            Date tmpDateOfWithDrawal = jOWEBNext.getDateOfWithDrawal();
            if (tmpDateOfWithDrawal != null && DateHelper.before((Date)tmpDateOfWithDrawal, (Date)this.mListFirstDate)) continue;
            if (jOWEBPrevios == null) {
                jOWEBMap.put(jOWEBNext.getDateOfEntry(), jOWEBNext);
                continue;
            }
            if (!DateHelper.before((Date)jOWEBPrevios.getValidFrom(), (Date)jOWEBNext.getValidFrom())) continue;
            jOWEBPrevios.setDateOfWithDrawal(jOWEBNext.getDateOfWithDrawal());
            jOWEBPrevios.setValidUntil(jOWEBNext.getValidUntil());
            jOWEBMap.put(jOWEBPrevios.getDateOfEntry(), jOWEBPrevios);
        }
        if (!jOWEBMap.isEmpty()) {
            jOWEBLi.addAll(jOWEBMap.values());
        }
        Collections.sort(jOWEBLi, new JOWBeanComparator());
        return jOWEBLi;
    }

    private void printIteratorValues(List<JournalOfWageEmployeeBean> oreginalJOWEBLi) {
        for (JournalOfWageEmployeeBean jOWEB : oreginalJOWEBLi) {
            jOWEB.printValues();
        }
    }

    private JournalOfWageEmployeeBean getJournalOfWageEmployeeBean(EmployeeForReport eFR) {
        JournalOfWageEmployeeBean jOWEBean = new JournalOfWageEmployeeBean(eFR.getEmploymentEffectiveFrom(), eFR.getEmploymentEffectiveUntil(), eFR.getEmploymentValidFrom(), eFR.getEmploymentValidUntil(), eFR.getDateOfWithDrawal(), eFR.getDateOfEntry(), eFR.getOidEmployee(), eFR.getOidPCompany(), eFR.getOidPlant(), eFR.getPersonnelNumber(), eFR.getPCompanyKey(), eFR.getPlantKey(), eFR.getPlantDescription());
        if (this.mReportSortSeq != null && this.mReportSortSeq.length > 0) {
            jOWEBean.setPCompany(new ReportSortCriteria((Object)eFR.getPCompanyKey(), (Object)eFR.getPCompanyDescription()));
            jOWEBean.setEmployee(new ReportSortCriteria((Object)eFR.getPersonnelNumber(), (Object)eFR.getSurname()));
            jOWEBean.setPlant(new ReportSortCriteria((Object)eFR.getPlantKey(), (Object)eFR.getPlantDescription()));
            jOWEBean.setEmployeeCircle(new ReportSortCriteria((Object)eFR.getEmployeeCircleKey(), (Object)eFR.getEmployeeCircleDescription()));
            jOWEBean.setCostCenter(new ReportSortCriteria((Object)eFR.getCostCenterKey(), (Object)eFR.getCostCenterDescription()));
            jOWEBean.setCostUnit(new ReportSortCriteria((Object)eFR.getCostUnitKey(), (Object)eFR.getCostUnitDescription()));
            jOWEBean.setDepartment(new ReportSortCriteria((Object)eFR.getDepartmentKey(), (Object)eFR.getDepartmentDescription()));
            jOWEBean.setOrgUnit(new ReportSortCriteria((Object)eFR.getOrgUnitKey(), (Object)eFR.getOrgUnitDescription()));
            jOWEBean.setPersonInCharge1(new ReportSortCriteria((Object)eFR.getPersonInCharge1Key(), (Object)eFR.getPersonInCharge1Description()));
            jOWEBean.setPersonInCharge2(new ReportSortCriteria((Object)eFR.getPersonInCharge2Key(), (Object)eFR.getPersonInCharge2Description()));
        } else {
            jOWEBean.setEmployee(new ReportSortCriteria((Object)eFR.getPersonnelNumber(), (Object)eFR.getSurname()));
        }
        return jOWEBean;
    }

    protected List<JournalOfWageEmployeeBean> getSortedEFR(List<JournalOfWageEmployeeBean> eFRLi) {
        HashMap<Object, LinkedList<JournalOfWageEmployeeBean>> eFRMap = new HashMap<Object, LinkedList<JournalOfWageEmployeeBean>>();
        LinkedList<String> oidEmployeeLi = new LinkedList<String>();
        Iterator<JournalOfWageEmployeeBean> eFRIt = eFRLi.iterator();
        while (eFRIt.hasNext()) {
            Object plantDescription = "";
            JournalOfWageEmployeeBean jOWEB = eFRIt.next();
            plantDescription = !StringMapper.isNullString((String)jOWEB.getOidPlant()) ? jOWEB.getPlantKey() + jOWEB.getPlantDescription() : "";
            oidEmployeeLi.add(jOWEB.getOidEmployee());
            LinkedList<JournalOfWageEmployeeBean> personnelLi = (LinkedList<JournalOfWageEmployeeBean>)eFRMap.get(plantDescription);
            if (personnelLi == null) {
                personnelLi = new LinkedList<JournalOfWageEmployeeBean>();
                eFRMap.put(plantDescription, personnelLi);
            }
            personnelLi.add(jOWEB);
        }
        this.mResultOidEmployee = new String[oidEmployeeLi.size()];
        this.mResultOidEmployee = oidEmployeeLi.toArray(this.mResultOidEmployee);
        LinkedList<JournalOfWageEmployeeBean> eFRNewLi = new LinkedList<JournalOfWageEmployeeBean>();
        LinkedList plantDescriptionLi = new LinkedList(eFRMap.keySet());
        Collections.sort(plantDescriptionLi, new StringComparator());
        Iterator plantDescriptionIt = plantDescriptionLi.iterator();
        while (plantDescriptionIt.hasNext()) {
            String plantDescrptionKey = ((String)plantDescriptionIt.next()).toString();
            List personnelNumberLi = (List)eFRMap.get(plantDescrptionKey);
            Collections.sort(personnelNumberLi, new ReportsSortComparator(new ReportSortStruct[0]));
            Collections.sort(personnelNumberLi, new ReportsSortComparator(this.mReportSortSeq));
            eFRNewLi.addAll(personnelNumberLi);
        }
        return eFRNewLi;
    }

    private void getHashMapMasterall() {
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mForEffectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mForEffectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mListEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mListFirstDate))});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])this.mResultOidEmployee);
            for (Criterion each : inRestrictions) {
                this.mMasterallDatas = daoMasterall.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"validfrom")}, Restrictions.and((Criterion)each, (Criterion)filter));
                while (this.mMasterallDatas.hasNext()) {
                    MasterallContainer masterallContainer = (MasterallContainer)this.mMasterallDatas.getNext();
                    List<MasterallContainer> liste = this.mMasterAllMap.get(masterallContainer.oidemployee);
                    if (liste == null) {
                        liste = new LinkedList<MasterallContainer>();
                        this.mMasterAllMap.put(masterallContainer.oidemployee, liste);
                    }
                    liste.add(masterallContainer);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void getHashMapInsurance() {
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mForEffectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mForEffectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mListEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mListFirstDate))});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])this.mResultOidEmployee);
            for (Criterion each : inRestrictions) {
                this.mInsuranceDatas = daoInsurance.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"validfrom")}, Restrictions.and((Criterion)each, (Criterion)filter));
                while (this.mInsuranceDatas.hasNext()) {
                    InsuranceContainer insuranceContainer = (InsuranceContainer)this.mInsuranceDatas.getNext();
                    List<InsuranceContainer> liste = this.mInsuranceAllMap.get(insuranceContainer.oidemployee);
                    if (liste == null) {
                        liste = new LinkedList<InsuranceContainer>();
                        this.mInsuranceAllMap.put(insuranceContainer.oidemployee, liste);
                    }
                    liste.add(insuranceContainer);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void getHashMapTax() {
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mForEffectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mForEffectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mListEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mListFirstDate))});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])this.mResultOidEmployee);
            for (Criterion each : inRestrictions) {
                this.mTaxDatas = daoTax.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"validfrom")}, Restrictions.and((Criterion)each, (Criterion)filter));
                while (this.mTaxDatas.hasNext()) {
                    TaxContainer taxContainer = (TaxContainer)this.mTaxDatas.getNext();
                    List<TaxContainer> liste = this.mTaxAllMap.get(taxContainer.oidemployee);
                    if (liste == null) {
                        liste = new LinkedList<TaxContainer>();
                        this.mTaxAllMap.put(taxContainer.oidemployee, liste);
                    }
                    liste.add(taxContainer);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void getHashMapEmployment() {
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mForEffectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mForEffectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mListEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mListFirstDate))});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])this.mResultOidEmployee);
            for (Criterion each : inRestrictions) {
                this.mEmploymentDatas = daoEmployment.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"validfrom")}, Restrictions.and((Criterion)each, (Criterion)filter));
                while (this.mEmploymentDatas.hasNext()) {
                    EmploymentContainer employmentContainer = (EmploymentContainer)this.mEmploymentDatas.getNext();
                    List<EmploymentContainer> liste = this.mEmploymentAllMap.get(employmentContainer.oidemployee);
                    if (liste == null) {
                        liste = new LinkedList<EmploymentContainer>();
                        this.mEmploymentAllMap.put(employmentContainer.oidemployee, liste);
                    }
                    liste.add(employmentContainer);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private List<ValuepositionContainer> getValuePositions(String oidEmployee) {
        LinkedList<ValuepositionContainer> vpListe = null;
        try {
            this.mValuePositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.in((String)"valuetypenumber", (String[])this.mResultValueTypeNumber), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mForEffectiveDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mForEffectiveDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mListEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.mListFirstDate))}));
            ValuepositionContainer valuePositionContainer = new ValuepositionContainer();
            if (this.mValuePositionDatas != null) {
                vpListe = new LinkedList<ValuepositionContainer>();
                while (this.mValuePositionDatas.hasNext()) {
                    valuePositionContainer = (ValuepositionContainer)this.mValuePositionDatas.getNext();
                    if (valuePositionContainer == null) continue;
                    vpListe.add(valuePositionContainer);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return vpListe;
    }

    private void getValuePositionsAuszahlungsBetragLi(String oidEmployee, Date validFrom, Date validUntil) {
        try {
            Date validFromDate = new VDate(validFrom).getDate();
            while (DateHelper.beforeOrEqual((Date)validFromDate, (Date)validUntil)) {
                Date lastDayOfMonth = DateHelper.getLastDayOfMonth((Date)validFromDate);
                Date firstDayOfMonth = DateHelper.getFirstDayOfMonth((Date)validFromDate);
                PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"valuetypenumber", (String)"890000"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)lastDayOfMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)firstDayOfMonth)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)lastDayOfMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)firstDayOfMonth))}));
                ValuepositionContainer vPC = new ValuepositionContainer();
                if (valuePositionDatas != null && valuePositionDatas.hasNext()) {
                    vPC = (ValuepositionContainer)valuePositionDatas.getNext();
                    Date beginDate = new VDate(validFromDate).getDate();
                    Date endDate = DateHelper.getLastDayOfMonth((Date)validFromDate);
                    this.FIELD_AUSZAHLUNG = this.FIELD_AUSZAHLUNG.add(vPC.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                }
                validFromDate = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)validFromDate));
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private HealthFundTP getHealthFundTP(String healthFundOid, Date employeeFirstDate) throws BusinessDomainException {
        HealthFund eeHealthFund = this.mHealthFundMap.get(healthFundOid);
        if (eeHealthFund == null) {
            eeHealthFund = HealthFundPersistencyManager.getHealthFund((String)healthFundOid);
            this.mHealthFundMap.put(healthFundOid, eeHealthFund);
        }
        return eeHealthFund.getHealthFundTP(this.mForEffectiveDate, employeeFirstDate);
    }

    private void getContainers(String currentOidEmployee, Date stammFistDate) throws BusinessDomainException {
        this.mMasterAllContainer = null;
        List<MasterallContainer> listeMaster = this.mMasterAllMap.get(currentOidEmployee);
        if (listeMaster != null) {
            for (MasterallContainer masterallContainer : listeMaster) {
                if (!DateHelper.beforeOrEqual((Date)masterallContainer.validfrom, (Date)stammFistDate) || !DateHelper.afterOrEqual((Date)masterallContainer.validuntil, (Date)stammFistDate)) continue;
                this.mMasterAllContainer = masterallContainer;
                if (this.mInternalUse || PDateHelper.getDiffInMonths((Date)this.mListEndDate, (Date)masterallContainer.journalizeduntil) <= 0) break;
                throw ReportExceptionMapper.makeEmployeeNotJournalized();
            }
        }
        this.mInsuranceContainer = null;
        List<InsuranceContainer> listeInsurance = this.mInsuranceAllMap.get(currentOidEmployee);
        if (listeInsurance != null) {
            for (InsuranceContainer insuranceContainer : listeInsurance) {
                if (!DateHelper.beforeOrEqual((Date)insuranceContainer.validfrom, (Date)stammFistDate) || !DateHelper.afterOrEqual((Date)insuranceContainer.validuntil, (Date)stammFistDate)) continue;
                this.mInsuranceContainer = insuranceContainer;
                break;
            }
        }
        this.mTaxContainer = null;
        List<TaxContainer> listeTax = this.mTaxAllMap.get(currentOidEmployee);
        if (listeTax != null) {
            for (TaxContainer taxContainer : listeTax) {
                if (!DateHelper.beforeOrEqual((Date)taxContainer.validfrom, (Date)stammFistDate) || !DateHelper.afterOrEqual((Date)taxContainer.validuntil, (Date)stammFistDate)) continue;
                this.mTaxContainer = taxContainer;
                break;
            }
        }
        this.mEmploymentContainer = null;
        List<EmploymentContainer> listeEmployment = this.mEmploymentAllMap.get(currentOidEmployee);
        if (listeEmployment != null) {
            for (EmploymentContainer employmentContainer : listeEmployment) {
                if (!DateHelper.beforeOrEqual((Date)employmentContainer.validfrom, (Date)stammFistDate) || !DateHelper.afterOrEqual((Date)employmentContainer.validuntil, (Date)stammFistDate)) continue;
                this.mEmploymentContainer = employmentContainer;
                break;
            }
        }
        this.mStammEndDate = new VDate(this.mEmployeeEndDate).getDate();
        if (this.mMasterAllContainer != null && DateHelper.before((Date)this.mMasterAllContainer.validuntil, (Date)this.mStammEndDate)) {
            this.mStammEndDate = new VDate(this.mMasterAllContainer.validuntil).getDate();
        }
        if (this.mInsuranceContainer != null && DateHelper.before((Date)this.mInsuranceContainer.validuntil, (Date)this.mStammEndDate)) {
            this.mStammEndDate = new VDate(this.mInsuranceContainer.validuntil).getDate();
        }
        if (this.mTaxContainer != null && DateHelper.before((Date)this.mTaxContainer.validuntil, (Date)this.mStammEndDate)) {
            this.mStammEndDate = new VDate(this.mTaxContainer.validuntil).getDate();
        }
        if (this.mEmploymentContainer != null && DateHelper.before((Date)this.mEmploymentContainer.validuntil, (Date)this.mStammEndDate)) {
            this.mStammEndDate = new VDate(this.mEmploymentContainer.validuntil).getDate();
        }
    }

    private void getData(JournalOfWageEmployeeBean jOWEmployeeBean) throws BusinessDomainException {
        this.mCurrentOidEmployee = jOWEmployeeBean.getOidEmployee();
        this.mEmployeeFirstDate = DateHelper.before((Date)jOWEmployeeBean.getDateOfEntry(), (Date)jOWEmployeeBean.getValidFrom()) ? jOWEmployeeBean.getDateOfEntry() : jOWEmployeeBean.getValidFrom();
        this.mEmployeeFirstDate = DateHelper.before((Date)this.mEmployeeFirstDate, (Date)this.mListFirstDate) ? this.mListFirstDate : this.mEmployeeFirstDate;
        this.mEmployeeFirstDate = DateHelper.before((Date)this.mEmployeeFirstDate, (Date)jOWEmployeeBean.getValidFrom()) ? jOWEmployeeBean.getValidFrom() : this.mEmployeeFirstDate;
        Date date = this.mEmployeeEndDate = jOWEmployeeBean.getDateOfWithDrawal() == null ? jOWEmployeeBean.getValidUntil() : jOWEmployeeBean.getDateOfWithDrawal();
        if (DateHelper.after((Date)this.mEmployeeEndDate, (Date)this.mListEndDate)) {
            this.mEmployeeEndDate = this.mListEndDate;
        }
        Date employeeFirstDate = this.mEmployeeFirstDate;
        Date employeeEndDate = this.mEmployeeEndDate;
        String currentOidEmployee = jOWEmployeeBean.getOidEmployee();
        this.FIELD_DATUMJAHR = Integer.toString(this.mForYear);
        this.getContainers(currentOidEmployee, employeeEndDate);
        this.resetDataEmployee();
        if (this.mMasterAllContainer != null) {
            this.FIELD_PERSONAL_NR = Integer.toString(this.mMasterAllContainer.personnelnumber);
            this.FIELD_NAME = StringMapper.isNullString((String)this.mMasterAllContainer.surname) ? "" : this.mMasterAllContainer.surname;
            String string = this.FIELD_VORNAME = StringMapper.isNullString((String)this.mMasterAllContainer.firstname) ? "" : this.mMasterAllContainer.firstname;
        }
        if (this.mInsuranceContainer != null) {
            this.FIELD_KRANKENKASSE = StringMapper.isNullString((String)this.mInsuranceContainer.oidhealthfund) ? "" : this.getHealthFundTP(this.mInsuranceContainer.oidhealthfund, employeeEndDate).getShortDescription();
            this.FIELD_BEITR_GP_KV = Integer.toString(this.mInsuranceContainer.duesgrouphi);
            this.FIELD_BEITR_GP_RV = Integer.toString(this.mInsuranceContainer.duesgrouppi);
            this.FIELD_BEITR_GP_AV = Integer.toString(this.mInsuranceContainer.duesgroupui);
            this.FIELD_BEITR_GP_PV = Integer.toString(this.mInsuranceContainer.duesgroupni);
            this.FIELD_GRV = this.mInsuranceContainer.specialcategory == 1 ? "ja" : "nein";
            this.FIELD_MFB = this.mInsuranceContainer.multiplyemployment != 0 ? "ja" : "nein";
            this.FIELD_PGS = Integer.toString(this.mInsuranceContainer.persongroup);
            this.FIELD_PARENT = this.mInsuranceContainer.nichildeducation ? "E" : "";
            String string = this.FIELD_GFB = this.mInsuranceContainer.persongroup == 109 ? "ja" : "nein";
        }
        if (this.mTaxContainer != null) {
            this.FIELD_STEUERKLASSE = Integer.toString(this.mTaxContainer.taxbracket);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mTaxContainer.percentagesplit)) {
                this.FIELD_STEUERFAKTOR = this.mTaxContainer.percentagesplit.toString().replace('.', ',');
            }
            this.FIELD_ZKF = BigDecimalMapper.toString((BigDecimal)this.mTaxContainer.childrelief);
            this.FIELD_ZKF = StringMapper.replaceAllSubString((String)this.FIELD_ZKF, (String)".", (String)",");
            this.FIELD_RELI_AN = ChurchTaxEnumMapper.valueToString((int)this.mTaxContainer.churchtaxee);
            this.FIELD_RELI_EG = ChurchTaxEnumMapper.valueToString((int)this.mTaxContainer.churchtaxspouse);
            this.FIELD_MTL_FREIB = this.mTaxContainer.freeallowancemm;
            this.FIELD_JHL_FREIB = this.mTaxContainer.freeallowanceyy;
            this.FIELD_VBZ = this.mTaxContainer.pensionfreedues ? "ja" : "nein";
            String string = this.FIELD_AE = this.mTaxContainer.oldagereliefamount ? "ja" : "nein";
        }
        if (this.mEmploymentContainer != null) {
            this.FIELD_BETRIEBSSTAETTE = "";
            this.FIELD_BETRIEBSSTAETTE_KEY = "";
            EmployerBean employerBean = (EmployerBean)UtilitiesManager.getBean((String)"employerBean", EmployerBean.class);
            employerBean.setOidEmployee(jOWEmployeeBean.getOidEmployee());
            employerBean.setEffectiveDate(jOWEmployeeBean.getEffectiveFrom());
            employerBean.setValidDate(this.mListEndDate);
            employerBean.setOidPlant(jOWEmployeeBean.getOidPlant());
            employerBean.setOidPCompany(jOWEmployeeBean.getOidPCompany());
            employerBean.createEmployerBean();
            if (!StringMapper.isNullString((String)jOWEmployeeBean.getOidPlant())) {
                this.FIELD_BETRIEBSSTAETTE = employerBean.getPlantShortDescription();
                this.FIELD_BETRIEBSSTAETTE_KEY = employerBean.getPlantCode();
                this.FIELD_RK = employerBean.getPlantLawareaShort();
            }
            if (StringMapper.isNullString((String)this.FIELD_RK)) {
                this.FIELD_RK = employerBean.getCompanyLawareaShort();
            }
        }
        this.resetValuesBD();
        List<ValuepositionContainer> liste = this.getValuePositions(this.mCurrentOidEmployee);
        if (jOWEmployeeBean.getDateOfWithDrawal() != null && DateHelper.before((Date)jOWEmployeeBean.getDateOfWithDrawal(), (Date)this.mListEndDate) && DateHelper.after((Date)jOWEmployeeBean.getDateOfWithDrawal(), (Date)this.mListFirstDate)) {
            this.getValuePositionsAuszahlungsBetragLi(this.mCurrentOidEmployee, employeeFirstDate, employeeEndDate);
        } else {
            this.getValuePositionsAuszahlungsBetragLi(this.mCurrentOidEmployee, employeeFirstDate, this.mListEndDate);
        }
        if (liste != null) {
            for (ValuepositionContainer valuePositionContainer : liste) {
                Date beginDate = new VDate(employeeFirstDate).getDate();
                Date endDate = new VDate(employeeEndDate).getDate();
                this.FIELD_ZEITRAUMVON = DateMapper.toDDMMPointSeparationString((Date)beginDate) + ".";
                this.FIELD_ZEITRAUMBIS = DateMapper.toDDMMPointSeparationString((Date)endDate) + ".";
                if (!DateHelper.beforeOrEqual((Date)valuePositionContainer.validfrom, (Date)endDate) || !DateHelper.afterOrEqual((Date)valuePositionContainer.validuntil, (Date)beginDate)) continue;
                beginDate = DateHelper.after((Date)valuePositionContainer.validfrom, (Date)beginDate) ? valuePositionContainer.validfrom : beginDate;
                endDate = DateHelper.before((Date)valuePositionContainer.validuntil, (Date)endDate) ? valuePositionContainer.validuntil : endDate;
                endDate = DateHelper.getLastDayOfMonth((Date)endDate);
                switch (valuePositionContainer.valuetypenumber) {
                    case 100100: {
                        this.FIELD_GESAMT_BRUTTO = this.FIELD_GESAMT_BRUTTO.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 110000: {
                        this.FIELD_STEUER_BRUTTO = this.FIELD_STEUER_BRUTTO.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 110590: {
                        this.FIELD_ST_TAGE = this.FIELD_ST_TAGE.add(valuePositionContainer.factor1.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))).setScale(0));
                        break;
                    }
                    case 130000: {
                        this.FIELD_SV_BRUTTO = this.FIELD_SV_BRUTTO.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 130590: {
                        this.FIELD_SV_TAGE = this.FIELD_SV_TAGE.add(valuePositionContainer.factor1.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))).setScale(0));
                        break;
                    }
                    case 145110: 
                    case 145160: 
                    case 145170: 
                    case 145210: 
                    case 145215: 
                    case 145220: 
                    case 145225: 
                    case 145310: 
                    case 145320: 
                    case 145360: 
                    case 145370: {
                        ValuePosition valuePosition = new ValuePosition(valuePositionContainer.getObjectid());
                        ValuePosition valuePositionFromGenisis = valuePosition.getValuePositionFromGenesisParent();
                        if (valuePositionFromGenisis == null || !JournalOfWageShortReportDataSource.isRelevantToAdd(valuePositionFromGenisis, VDate.getDateMax(), endDate)) break;
                        this.FIELD_BAV_AG_KOSTEN = this.FIELD_BAV_AG_KOSTEN.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 220010: {
                        this.FIELD_GESETZLICHE_ABZUEGE = this.FIELD_GESETZLICHE_ABZUEGE.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 220050: {
                        this.FIELD_LOHNSTEUER = this.FIELD_LOHNSTEUER.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 223050: {
                        this.FIELD_SOLIDARITAETSZUSCHLAG = this.FIELD_SOLIDARITAETSZUSCHLAG.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 226010: {
                        this.FIELD_KIST = this.FIELD_KIST.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 250510: 
                    case 250610: {
                        this.FIELD_KAMMER = this.FIELD_KAMMER.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 320510: {
                        this.FIELD_GESETZLICHE_ABZUEGE = this.FIELD_GESETZLICHE_ABZUEGE.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 321050: 
                    case 350510: {
                        this.FIELD_KV_ENTGELT = this.FIELD_KV_ENTGELT.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 322050: 
                    case 351050: {
                        this.FIELD_KV_ANA = this.FIELD_KV_ANA.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 323050: {
                        this.FIELD_KV_AGA = this.FIELD_KV_AGA.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 327050: 
                    case 401100: 
                    case 401150: {
                        this.FIELD_RV_ENTGELT = this.FIELD_RV_ENTGELT.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 328050: {
                        this.FIELD_RV_ANA = this.FIELD_RV_ANA.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 329050: 
                    case 401300: 
                    case 401350: {
                        this.FIELD_RV_AGA = this.FIELD_RV_AGA.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 333050: {
                        this.FIELD_AV_ENTGELT = this.FIELD_AV_ENTGELT.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 334050: {
                        this.FIELD_AV_ANA = this.FIELD_AV_ANA.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 335050: {
                        this.FIELD_AV_AGA = this.FIELD_AV_AGA.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 339050: {
                        this.FIELD_PV_ENTGELT = this.FIELD_PV_ENTGELT.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 340050: 
                    case 355050: {
                        this.FIELD_PV_ANA = this.FIELD_PV_ANA.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 341050: {
                        this.FIELD_PV_AGA = this.FIELD_PV_AGA.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 360050: {
                        this.FIELD_UMLAGE_ENTGELT = this.FIELD_UMLAGE_ENTGELT.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 361050: {
                        this.FIELD_UMLAGE_BEITRAG = this.FIELD_UMLAGE_BEITRAG.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 366050: {
                        this.FIELD_INSG_UMLAGE = this.FIELD_INSG_UMLAGE.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 700000: {
                        this.FIELD_NETTOLOHN = this.FIELD_NETTOLOHN.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 702000: {
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 710010: {
                        this.FIELD_AG_PAUSCHAL = this.FIELD_AG_PAUSCHAL.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 736300: {
                        this.FIELD_GFB_PAUSCHAL = this.FIELD_GFB_PAUSCHAL.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        this.FIELD_AG_PAUSCHAL = this.FIELD_AG_PAUSCHAL.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 710020: {
                        this.FIELD_AN_PAUSCHAL = this.FIELD_AN_PAUSCHAL.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 770020: 
                    case 770025: 
                    case 770030: 
                    case 770035: 
                    case 770040: 
                    case 770045: 
                    case 770050: 
                    case 770055: 
                    case 770120: 
                    case 770130: 
                    case 770140: {
                        this.FIELD_KV_AGZ = this.FIELD_KV_AGZ.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 771020: 
                    case 771030: 
                    case 771040: 
                    case 771050: 
                    case 771120: 
                    case 771130: 
                    case 771140: {
                        this.FIELD_PV_AGZ = this.FIELD_PV_AGZ.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 772100: 
                    case 775050: {
                        this.FIELD_RV_AGZ = this.FIELD_RV_AGZ.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 760100: {
                        if (new VDate(beginDate).getMonth() != 11) break;
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        this.FIELD_LOHNSTEUER = this.FIELD_LOHNSTEUER.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 760110: {
                        if (new VDate(beginDate).getMonth() != 11) break;
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        this.FIELD_SOLIDARITAETSZUSCHLAG = this.FIELD_SOLIDARITAETSZUSCHLAG.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 760120: 
                    case 760130: {
                        if (new VDate(beginDate).getMonth() != 11) break;
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        this.FIELD_KIST = this.FIELD_KIST.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 760400: {
                        if (!DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        this.FIELD_LOHNSTEUER = this.FIELD_LOHNSTEUER.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 760410: {
                        if (!DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        this.FIELD_SOLIDARITAETSZUSCHLAG = this.FIELD_SOLIDARITAETSZUSCHLAG.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 760420: 
                    case 760430: {
                        if (!DateHelper.before((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        this.FIELD_KIST = this.FIELD_KIST.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 760450: {
                        if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        this.FIELD_LOHNSTEUER = this.FIELD_LOHNSTEUER.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 760460: {
                        if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        this.FIELD_SOLIDARITAETSZUSCHLAG = this.FIELD_SOLIDARITAETSZUSCHLAG.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 760470: 
                    case 760480: {
                        if (!DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2006, 0, 1).getDate()) || new VDate(beginDate).getMonth() != 11 || valuePositionContainer.category != 22) break;
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        this.FIELD_KIST = this.FIELD_KIST.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 860000: {
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 861000: 
                    case 863000: 
                    case 870000: 
                    case 871000: 
                    case 886200: {
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 862000: {
                        this.FIELD_VWL = this.FIELD_VWL.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        this.FIELD_BE_ABZUEGE = this.FIELD_BE_ABZUEGE.subtract(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 230510: 
                    case 230520: {
                        this.FIELD_KUG = this.FIELD_KUG.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 100910: 
                    case 100930: 
                    case 100950: 
                    case 100960: 
                    case 100970: {
                        this.FIELD_ZVK_AGA = this.FIELD_ZVK_AGA.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                        break;
                    }
                    case 100920: 
                    case 100940: {
                        this.FIELD_ZVK_ANA = this.FIELD_ZVK_ANA.add(valuePositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)endDate), (Date)beginDate))));
                    }
                }
            }
            this.FIELD_AG_KOSTEN = this.FIELD_GESAMT_BRUTTO.add(this.FIELD_GFB_PAUSCHAL.add(this.FIELD_AG_PAUSCHAL.add(this.FIELD_KV_AGA.add(this.FIELD_KV_AGZ.add(this.FIELD_RV_AGA.add(this.FIELD_RV_AGZ.add(this.FIELD_AV_AGA.add(this.FIELD_PV_AGA.add(this.FIELD_PV_AGZ.add(this.FIELD_UMLAGE_BEITRAG.add(this.FIELD_INSG_UMLAGE.add(this.FIELD_ZVK_AGA).add(this.FIELD_BAV_AG_KOSTEN))))))))))));
        }
    }

    private void resetDataEmployee() {
        this.FIELD_PERSONAL_NR = "";
        this.FIELD_NAME = "";
        this.FIELD_VORNAME = "";
        this.FIELD_KRANKENKASSE = "";
        this.FIELD_BEITR_GP_KV = "";
        this.FIELD_BEITR_GP_RV = "";
        this.FIELD_BEITR_GP_AV = "";
        this.FIELD_BEITR_GP_PV = "";
        this.FIELD_PARENT = "";
        this.FIELD_GRV = "";
        this.FIELD_MFB = "";
        this.FIELD_PGS = "";
        this.FIELD_RK = "";
        this.FIELD_ZEITRAUMVON = "";
        this.FIELD_ZEITRAUMBIS = "";
        this.FIELD_STEUERKLASSE = "";
        this.FIELD_STEUERTABELLE = "";
        this.FIELD_STEUERFAKTOR = "";
        this.FIELD_ZKF = "";
        this.FIELD_RELI_AN = "";
        this.FIELD_RELI_EG = "";
        this.FIELD_GFB = "";
        this.FIELD_MTL_FREIB = BigDecimal.ZERO;
        this.FIELD_JHL_FREIB = BigDecimal.ZERO;
        this.FIELD_VBZ = "";
        this.FIELD_AE = "";
    }

    private void resetValuesBD() {
        this.FIELD_GESAMT_BRUTTO = BigDecimal.valueOf(0L, 2);
        this.FIELD_LOHNSTEUER = BigDecimal.valueOf(0L, 2);
        this.FIELD_KV_ENTGELT = BigDecimal.valueOf(0L, 2);
        this.FIELD_RV_ENTGELT = BigDecimal.valueOf(0L, 2);
        this.FIELD_AV_ENTGELT = BigDecimal.valueOf(0L, 2);
        this.FIELD_PV_ENTGELT = BigDecimal.valueOf(0L, 2);
        this.FIELD_KV_AGZ = BigDecimal.valueOf(0L, 2);
        this.FIELD_UMLAGE_ENTGELT = BigDecimal.valueOf(0L, 2);
        this.FIELD_GESETZLICHE_ABZUEGE = BigDecimal.valueOf(0L, 2);
        this.FIELD_VWL = BigDecimal.valueOf(0L, 2);
        this.FIELD_AN_PAUSCHAL = BigDecimal.valueOf(0L, 2);
        this.FIELD_ZVK_ANA = BigDecimal.valueOf(0L, 2);
        this.FIELD_STEUER_BRUTTO = BigDecimal.valueOf(0L, 2);
        this.FIELD_KIST = BigDecimal.valueOf(0L, 2);
        this.FIELD_KV_ANA = BigDecimal.valueOf(0L, 2);
        this.FIELD_RV_ANA = BigDecimal.valueOf(0L, 2);
        this.FIELD_AV_ANA = BigDecimal.valueOf(0L, 2);
        this.FIELD_PV_ANA = BigDecimal.valueOf(0L, 2);
        this.FIELD_RV_AGZ = BigDecimal.valueOf(0L, 2);
        this.FIELD_UMLAGE_BEITRAG = BigDecimal.valueOf(0L, 2);
        this.FIELD_NETTOLOHN = BigDecimal.valueOf(0L, 2);
        this.FIELD_KAMMER = BigDecimal.valueOf(0L, 2);
        this.FIELD_AG_PAUSCHAL = BigDecimal.valueOf(0L, 2);
        this.FIELD_GFB_PAUSCHAL = BigDecimal.valueOf(0L, 2);
        this.FIELD_AG_KOSTEN = BigDecimal.valueOf(0L, 2);
        this.FIELD_SV_BRUTTO = BigDecimal.valueOf(0L, 2);
        this.FIELD_SOLIDARITAETSZUSCHLAG = BigDecimal.valueOf(0L, 2);
        this.FIELD_KV_AGA = BigDecimal.valueOf(0L, 2);
        this.FIELD_RV_AGA = BigDecimal.valueOf(0L, 2);
        this.FIELD_AV_AGA = BigDecimal.valueOf(0L, 2);
        this.FIELD_PV_AGA = BigDecimal.valueOf(0L, 2);
        this.FIELD_PV_AGZ = BigDecimal.valueOf(0L, 2);
        this.FIELD_INSG_UMLAGE = BigDecimal.valueOf(0L, 2);
        this.FIELD_BE_ABZUEGE = BigDecimal.valueOf(0L, 2);
        this.FIELD_KUG = BigDecimal.valueOf(0L, 2);
        this.FIELD_ZVK_AGA = BigDecimal.valueOf(0L, 2);
        this.FIELD_AUSZAHLUNG = BigDecimal.valueOf(0L, 2);
        this.FIELD_ST_TAGE = BigDecimal.valueOf(0L, 2);
        this.FIELD_SV_TAGE = BigDecimal.valueOf(0L, 2);
        this.FIELD_BAV_AG_KOSTEN = BigDecimal.ZERO;
    }

    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put(PARAMETER_USER, this.mUser);
        parameters.put(staticText_internalUse, this.mStaticText_internalUse);
        parameters.put(PARAMETER_AUSSICHT, DateMapper.toDDMMYYYYPointSeparationString((Date)this.mForEffectiveDate));
        return parameters;
    }

    public boolean next() throws JRException {
        try {
            this.mNext = false;
            if (this.mEmployeeForReportIt.hasNext()) {
                this.mNext = true;
                JournalOfWageEmployeeBean jOWEB = this.mEmployeeForReportIt.next();
                this.getData(jOWEB);
                if (!this.mFirstPurchase && !StringMapper.equal((String)this.TEMP_BETRIEBSSTAETTE, (String)this.FIELD_BETRIEBSSTAETTE)) {
                    this.SEITENWECHSEL = StringMapper.equal((String)this.SEITENWECHSEL, (String)"Seitenwechesl_1") ? "Seitenwechesl_2" : "Seitenwechesl_1";
                    this.resetSummValues();
                }
                this.addSumme();
                this.mFirstPurchase = false;
            } else if (this.mPCompanyHasPlants && !this.mSumBeanHashMap.isEmpty()) {
                if (!this.mLastRuns) {
                    this.getSumBeanIterator();
                    this.mLastRuns = true;
                    this.SEITENWECHSEL = "Seitenwechsel_3";
                }
                if (this.mSumBeanIterator.hasNext()) {
                    this.buildSumCollection();
                    this.copySumDataValuesToTempFields();
                    this.mNext = true;
                } else {
                    this.mNext = false;
                }
            }
            return this.mNext;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
    }

    public void initCurrentObjects() {
        this.mStaticText_internalUse = this.mInternalUse ? "Interner Gebrauch" : "";
    }

    private String getMonth(int value) {
        String monat = "";
        switch (value) {
            case 0: {
                monat = "Januar";
                break;
            }
            case 1: {
                monat = "Februar";
                break;
            }
            case 2: {
                monat = "M\u00e4rz";
                break;
            }
            case 3: {
                monat = "April";
                break;
            }
            case 4: {
                monat = "Mai";
                break;
            }
            case 5: {
                monat = "Juni";
                break;
            }
            case 6: {
                monat = "Juli";
                break;
            }
            case 7: {
                monat = "August";
                break;
            }
            case 8: {
                monat = "September";
                break;
            }
            case 9: {
                monat = "Oktober";
                break;
            }
            case 10: {
                monat = "November";
                break;
            }
            case 11: {
                monat = "Dezember";
            }
        }
        return monat;
    }

    private String toCurrencyFormat(Object obj) {
        Object temp;
        if (obj != null) {
            String temp2;
            String temp1;
            temp = BigDecimalMapper.toString((BigDecimal)((BigDecimal)obj));
            int length = ((String)temp).length();
            if (((String)temp).substring(0, 1).equals("-")) {
                --length;
            }
            if (length < 7) {
                temp = ((String)temp).replace('.', ',');
            }
            if (length >= 7 && length < 10) {
                temp = ((String)temp).replace('.', ',');
                temp1 = ((String)temp).substring(0, ((String)temp).length() - 6);
                temp2 = ((String)temp).substring(((String)temp).length() - 6, ((String)temp).length());
                temp = temp1 + "." + temp2;
            }
            if (length >= 10) {
                temp = ((String)temp).replace('.', ',');
                temp1 = ((String)temp).substring(0, ((String)temp).length() - 9);
                temp2 = ((String)temp).substring(((String)temp).length() - 9, ((String)temp).length() - 6);
                String temp3 = ((String)temp).substring(((String)temp).length() - 6, ((String)temp).length());
                temp = temp1 + "." + temp2 + "." + temp3;
            }
        } else {
            temp = "";
        }
        return temp;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        String fieldName = field.getName();
        if (fieldName.equals("version")) {
            value = this.mVersion;
        }
        if (fieldName.equals("monat_bis")) {
            value = this.FIELD_MONAT_BIS;
        }
        if (fieldName.equals("datumjahr")) {
            value = this.FIELD_DATUMJAHR;
        }
        if (fieldName.equals("firma")) {
            value = this.mPCompanyReportHeaderKeyDescription;
        }
        if (fieldName.equals("betriebsstaette")) {
            Object temp = this.FIELD_BETRIEBSSTAETTE + this.FIELD_BETRIEBSSTAETTE_KEY;
            if (StringMapper.isNullString((String)temp)) {
                value = "";
            } else {
                temp = StringMapper.isNullString((String)this.FIELD_BETRIEBSSTAETTE_KEY) ? this.FIELD_BETRIEBSSTAETTE : this.FIELD_BETRIEBSSTAETTE_KEY + " / " + this.FIELD_BETRIEBSSTAETTE;
                value = temp = ((String)temp).length() > 40 ? ((String)temp).substring(0, 40) : temp;
            }
        }
        if (fieldName.equals("personalnummer")) {
            value = this.FIELD_PERSONAL_NR;
        }
        if (fieldName.equals("seitenwechsel")) {
            value = this.SEITENWECHSEL;
        }
        if (fieldName.equals("name")) {
            value = this.FIELD_NAME;
        }
        if (fieldName.equals("vorname")) {
            Object object = value = StringMapper.isNullString((String)this.FIELD_VORNAME) ? "" : ", " + this.FIELD_VORNAME;
        }
        if (fieldName.equals("krankenkasse")) {
            value = this.FIELD_KRANKENKASSE;
        }
        if (fieldName.equals("kv")) {
            value = this.FIELD_BEITR_GP_KV;
        }
        if (fieldName.equals("rv")) {
            value = this.FIELD_BEITR_GP_RV;
        }
        if (fieldName.equals("av")) {
            value = this.FIELD_BEITR_GP_AV;
        }
        if (fieldName.equals("pv")) {
            value = this.FIELD_BEITR_GP_PV;
        }
        if (fieldName.equals("gesamt_brutto")) {
            value = this.FIELD_GESAMT_BRUTTO;
        }
        if (fieldName.equals("lst")) {
            value = this.FIELD_LOHNSTEUER;
        }
        if (fieldName.equals("kv_entgelt")) {
            value = this.FIELD_KV_ENTGELT;
        }
        if (fieldName.equals("rv_entgelt")) {
            value = this.FIELD_RV_ENTGELT;
        }
        if (fieldName.equals("av_entgelt")) {
            value = this.FIELD_AV_ENTGELT;
        }
        if (fieldName.equals("pv_entgelt")) {
            value = this.FIELD_PV_ENTGELT;
        }
        if (fieldName.equals("kv_agz")) {
            value = this.FIELD_KV_AGZ;
        }
        if (fieldName.equals("u_entgelt")) {
            value = this.FIELD_UMLAGE_ENTGELT;
        }
        if (fieldName.equals("gesetzl_abz")) {
            value = this.FIELD_GESETZLICHE_ABZUEGE;
        }
        if (fieldName.equals("vwl")) {
            value = this.FIELD_VWL;
        }
        if (fieldName.equals("an_pauschal")) {
            value = this.FIELD_AN_PAUSCHAL;
        }
        if (fieldName.equals("zvk_ana")) {
            value = this.FIELD_ZVK_ANA;
        }
        if (fieldName.equals("stkl")) {
            value = this.FIELD_STEUERKLASSE;
        }
        if (fieldName.equals("stkl_b")) {
            value = this.FIELD_STEUERTABELLE;
        }
        if (fieldName.equals("faktor")) {
            value = this.FIELD_STEUERFAKTOR;
        }
        if (fieldName.equals("zkf")) {
            value = this.FIELD_ZKF;
        }
        if (fieldName.equals("konf_an")) {
            value = this.FIELD_RELI_AN;
        }
        if (fieldName.equals("konf_eg")) {
            value = this.FIELD_RELI_EG;
        }
        if (fieldName.equals("gfb")) {
            value = this.FIELD_GFB;
        }
        if (fieldName.equals("grv")) {
            value = this.FIELD_GRV;
        }
        if (fieldName.equals("mfb")) {
            value = this.FIELD_MFB;
        }
        if (fieldName.equals("rk")) {
            value = this.FIELD_RK;
        }
        if (fieldName.equals("steuer_brutto")) {
            value = this.FIELD_STEUER_BRUTTO;
        }
        if (fieldName.equals("kist")) {
            value = this.FIELD_KIST;
        }
        if (fieldName.equals("kv_ana")) {
            value = this.FIELD_KV_ANA;
        }
        if (fieldName.equals("rv_ana")) {
            value = this.FIELD_RV_ANA;
        }
        if (fieldName.equals("av_ana")) {
            value = this.FIELD_AV_ANA;
        }
        if (fieldName.equals("pv_ana")) {
            value = this.FIELD_PV_ANA;
        }
        if (fieldName.equals("rv_agz")) {
            value = this.FIELD_RV_AGZ;
        }
        if (fieldName.equals("u_beitrag")) {
            value = this.FIELD_UMLAGE_BEITRAG;
        }
        if (fieldName.equals("nettolohn")) {
            value = this.FIELD_NETTOLOHN;
        }
        if (fieldName.equals("kammer")) {
            value = this.FIELD_KAMMER;
        }
        if (fieldName.equals("ag_pauschal")) {
            value = this.FIELD_AG_PAUSCHAL;
        }
        if (fieldName.equals("gfb_pauschal")) {
            value = this.FIELD_GFB_PAUSCHAL;
        }
        if (fieldName.equals("ag_kosten")) {
            value = this.FIELD_AG_KOSTEN;
        }
        if (fieldName.equals("zeitraumvon")) {
            Object object = value = StringMapper.isNullString((String)this.FIELD_ZEITRAUMVON) ? "" : this.FIELD_ZEITRAUMVON + "-";
        }
        if (fieldName.equals("zeitraumbis")) {
            value = this.FIELD_ZEITRAUMBIS;
        }
        if (fieldName.equals("st_tg")) {
            if (this.FIELD_ST_TAGE != null) {
                value = BigDecimalMapper.toString((BigDecimal)this.FIELD_ST_TAGE);
                value = ((String)value).substring(0, ((String)value).length() - 3);
            } else {
                value = "";
            }
        }
        if (fieldName.equals("sv_tg")) {
            if (this.FIELD_ST_TAGE != null) {
                value = BigDecimalMapper.toString((BigDecimal)this.FIELD_SV_TAGE);
                value = ((String)value).substring(0, ((String)value).length() - 3);
            } else {
                value = "";
            }
        }
        if (fieldName.equals("mtl_freib")) {
            value = this.FIELD_MTL_FREIB;
        }
        if (fieldName.equals("jhl_freib")) {
            value = this.FIELD_JHL_FREIB;
        }
        if (fieldName.equals("vbz")) {
            value = this.FIELD_VBZ;
        }
        if (fieldName.equals("ae")) {
            value = this.FIELD_AE;
        }
        if (fieldName.equals("pgs")) {
            value = this.FIELD_PGS;
        }
        if (fieldName.equals("parent")) {
            value = this.FIELD_PARENT;
        }
        if (fieldName.equals("sv_brutto")) {
            value = this.FIELD_SV_BRUTTO;
        }
        if (fieldName.equals("solz")) {
            value = this.FIELD_SOLIDARITAETSZUSCHLAG;
        }
        if (fieldName.equals("kv_aga")) {
            value = this.FIELD_KV_AGA;
        }
        if (fieldName.equals("rv_aga")) {
            value = this.FIELD_RV_AGA;
        }
        if (fieldName.equals("av_aga")) {
            value = this.FIELD_AV_AGA;
        }
        if (fieldName.equals("pv_aga")) {
            value = this.FIELD_PV_AGA;
        }
        if (fieldName.equals("pv_agz")) {
            value = this.FIELD_PV_AGZ;
        }
        if (fieldName.equals("insg_umlage")) {
            value = this.FIELD_INSG_UMLAGE;
        }
        if (fieldName.equals("bezuege_abzuege")) {
            value = this.FIELD_BE_ABZUEGE;
        }
        if (fieldName.equals("kug")) {
            value = this.FIELD_KUG;
        }
        if (fieldName.equals("zvk_aga")) {
            value = this.FIELD_ZVK_AGA;
        }
        if (fieldName.equals("auszahlung")) {
            value = this.FIELD_AUSZAHLUNG;
        }
        if (fieldName.equals("summe_gesamt_brutto")) {
            value = this.summe_gesamt_brutto;
        }
        if (fieldName.equals("summe_lst")) {
            value = this.summe_lst;
        }
        if (fieldName.equals("summe_kv_entgelt")) {
            value = this.summe_kv_entgelt;
        }
        if (fieldName.equals("summe_rv_entgelt")) {
            value = this.summe_rv_entgelt;
        }
        if (fieldName.equals("summe_av_entgelt")) {
            value = this.summe_av_entgelt;
        }
        if (fieldName.equals("summe_pv_entgelt")) {
            value = this.summe_pv_entgelt;
        }
        if (fieldName.equals("summe_kv_agz")) {
            value = this.summe_kv_agz;
        }
        if (fieldName.equals("summe_u_entgelt")) {
            value = this.summe_u_entgelt;
        }
        if (fieldName.equals("summe_gesetzl_abz")) {
            value = this.summe_gesetzl_abz;
        }
        if (fieldName.equals("summe_vwl")) {
            value = this.summe_vwl;
        }
        if (fieldName.equals("summe_an_pauschal")) {
            value = this.summe_an_pauschal;
        }
        if (fieldName.equals("summe_zvk_ana")) {
            value = this.summe_zvk_ana;
        }
        if (fieldName.equals("summe_steuer_brutto")) {
            value = this.summe_steuer_brutto;
        }
        if (fieldName.equals("summe_kist")) {
            value = this.summe_kist;
        }
        if (fieldName.equals("summe_kv_ana")) {
            value = this.summe_kv_ana;
        }
        if (fieldName.equals("summe_rv_ana")) {
            value = this.summe_rv_ana;
        }
        if (fieldName.equals("summe_av_ana")) {
            value = this.summe_av_ana;
        }
        if (fieldName.equals("summe_pv_ana")) {
            value = this.summe_pv_ana;
        }
        if (fieldName.equals("summe_rv_agz")) {
            value = this.summe_rv_agz;
        }
        if (fieldName.equals("summe_u_beitrag")) {
            value = this.summe_u_beitrag;
        }
        if (fieldName.equals("summe_nettolohn")) {
            value = this.summe_nettolohn;
        }
        if (fieldName.equals("summe_kammer")) {
            value = this.summe_kammer;
        }
        if (fieldName.equals("summe_ag_pauschal")) {
            value = this.summe_ag_pauschal;
        }
        if (fieldName.equals("summe_gfb_pauschal")) {
            value = this.summe_gfb_pauschal;
        }
        if (fieldName.equals("summe_ag_kosten")) {
            value = this.summe_ag_kosten;
        }
        if (fieldName.equals("summe_sv_brutto")) {
            value = this.summe_sv_brutto;
        }
        if (fieldName.equals("summe_solz")) {
            value = this.summe_solz;
        }
        if (fieldName.equals("summe_kv_aga")) {
            value = this.summe_kv_aga;
        }
        if (fieldName.equals("summe_rv_aga")) {
            value = this.summe_rv_aga;
        }
        if (fieldName.equals("summe_av_aga")) {
            value = this.summe_av_aga;
        }
        if (fieldName.equals("summe_pv_aga")) {
            value = this.summe_pv_aga;
        }
        if (fieldName.equals("summe_pv_agz")) {
            value = this.summe_pv_agz;
        }
        if (fieldName.equals("summe_insg_umlage")) {
            value = this.summe_insg_umlage;
        }
        if (fieldName.equals("summe_bezuege_abzuege")) {
            value = this.summe_bezuege_abzuege;
        }
        if (fieldName.equals("summe_kug")) {
            value = this.summe_kug;
        }
        if (fieldName.equals("summe_zvk_aga")) {
            value = this.summe_zvk_aga;
        }
        if (fieldName.equals("summe_auszahlung")) {
            value = this.summe_auszahlung;
        }
        if (value instanceof BigDecimal) {
            value = this.toCurrencyFormat(value);
        }
        if (value instanceof String) {
            Object object = value = StringMapper.isNullString((String)((String)value)) ? "" : value;
        }
        if ("archi_string".equals(fieldName)) {
            ArchivingMetadata am = new ArchivingMetadata();
            am.setUserID(SessionContext.getInstance().getSession().getUserCode());
            am.setCompanyKeyAndName(this.mPCompanyReportHeaderKeyDescription);
            am.setPlantKey(this.FIELD_BETRIEBSSTAETTE_KEY);
            am.setValidFrom(this.mListFirstDate);
            am.setValidUntil(this.mListEndDate);
            am.setReportName(this.getReportName());
            value = am.getArchiString();
        }
        this.TEMP_BETRIEBSSTAETTE = this.FIELD_BETRIEBSSTAETTE;
        return value;
    }

    private String getReportName() {
        return "Jahreslohnjournal";
    }

    private void resetSummValues() {
        this.summe_gesamt_brutto = BigDecimal.valueOf(0L, 2);
        this.summe_lst = BigDecimal.valueOf(0L, 2);
        this.summe_kv_entgelt = BigDecimal.valueOf(0L, 2);
        this.summe_rv_entgelt = BigDecimal.valueOf(0L, 2);
        this.summe_av_entgelt = BigDecimal.valueOf(0L, 2);
        this.summe_pv_entgelt = BigDecimal.valueOf(0L, 2);
        this.summe_kv_agz = BigDecimal.valueOf(0L, 2);
        this.summe_u_entgelt = BigDecimal.valueOf(0L, 2);
        this.summe_gesetzl_abz = BigDecimal.valueOf(0L, 2);
        this.summe_vwl = BigDecimal.valueOf(0L, 2);
        this.summe_an_pauschal = BigDecimal.valueOf(0L, 2);
        this.summe_zvk_ana = BigDecimal.valueOf(0L, 2);
        this.summe_steuer_brutto = BigDecimal.valueOf(0L, 2);
        this.summe_kist = BigDecimal.valueOf(0L, 2);
        this.summe_kv_ana = BigDecimal.valueOf(0L, 2);
        this.summe_rv_ana = BigDecimal.valueOf(0L, 2);
        this.summe_av_ana = BigDecimal.valueOf(0L, 2);
        this.summe_pv_ana = BigDecimal.valueOf(0L, 2);
        this.summe_rv_agz = BigDecimal.valueOf(0L, 2);
        this.summe_u_beitrag = BigDecimal.valueOf(0L, 2);
        this.summe_nettolohn = BigDecimal.valueOf(0L, 2);
        this.summe_kammer = BigDecimal.valueOf(0L, 2);
        this.summe_ag_pauschal = BigDecimal.valueOf(0L, 2);
        this.summe_gfb_pauschal = BigDecimal.valueOf(0L, 2);
        this.summe_ag_kosten = BigDecimal.valueOf(0L, 2);
        this.summe_sv_brutto = BigDecimal.valueOf(0L, 2);
        this.summe_solz = BigDecimal.valueOf(0L, 2);
        this.summe_kv_aga = BigDecimal.valueOf(0L, 2);
        this.summe_rv_aga = BigDecimal.valueOf(0L, 2);
        this.summe_av_aga = BigDecimal.valueOf(0L, 2);
        this.summe_pv_aga = BigDecimal.valueOf(0L, 2);
        this.summe_pv_agz = BigDecimal.valueOf(0L, 2);
        this.summe_insg_umlage = BigDecimal.valueOf(0L, 2);
        this.summe_bezuege_abzuege = BigDecimal.valueOf(0L, 2);
        this.summe_kug = BigDecimal.valueOf(0L, 2);
        this.summe_zvk_aga = BigDecimal.valueOf(0L, 2);
        this.summe_auszahlung = BigDecimal.valueOf(0L, 2);
    }

    private void addSumme() {
        this.summe_gesamt_brutto = this.summe_gesamt_brutto.add(this.FIELD_GESAMT_BRUTTO);
        this.summe_lst = this.summe_lst.add(this.FIELD_LOHNSTEUER);
        this.summe_kv_entgelt = this.summe_kv_entgelt.add(this.FIELD_KV_ENTGELT);
        this.summe_rv_entgelt = this.summe_rv_entgelt.add(this.FIELD_RV_ENTGELT);
        this.summe_av_entgelt = this.summe_av_entgelt.add(this.FIELD_AV_ENTGELT);
        this.summe_pv_entgelt = this.summe_pv_entgelt.add(this.FIELD_PV_ENTGELT);
        this.summe_kv_agz = this.summe_kv_agz.add(this.FIELD_KV_AGZ);
        this.summe_u_entgelt = this.summe_u_entgelt.add(this.FIELD_UMLAGE_ENTGELT);
        this.summe_gesetzl_abz = this.summe_gesetzl_abz.add(this.FIELD_GESETZLICHE_ABZUEGE);
        this.summe_vwl = this.summe_vwl.add(this.FIELD_VWL);
        this.summe_an_pauschal = this.summe_an_pauschal.add(this.FIELD_AN_PAUSCHAL);
        this.summe_zvk_ana = this.summe_zvk_ana.add(this.FIELD_ZVK_ANA);
        this.summe_steuer_brutto = this.summe_steuer_brutto.add(this.FIELD_STEUER_BRUTTO);
        this.summe_kist = this.summe_kist.add(this.FIELD_KIST);
        this.summe_kv_ana = this.summe_kv_ana.add(this.FIELD_KV_ANA);
        this.summe_rv_ana = this.summe_rv_ana.add(this.FIELD_RV_ANA);
        this.summe_av_ana = this.summe_av_ana.add(this.FIELD_AV_ANA);
        this.summe_pv_ana = this.summe_pv_ana.add(this.FIELD_PV_ANA);
        this.summe_rv_agz = this.summe_rv_agz.add(this.FIELD_RV_AGZ);
        this.summe_u_beitrag = this.summe_u_beitrag.add(this.FIELD_UMLAGE_BEITRAG);
        this.summe_nettolohn = this.summe_nettolohn.add(this.FIELD_NETTOLOHN);
        this.summe_kammer = this.summe_kammer.add(this.FIELD_KAMMER);
        this.summe_ag_pauschal = this.summe_ag_pauschal.add(this.FIELD_AG_PAUSCHAL);
        this.summe_gfb_pauschal = this.summe_gfb_pauschal.add(this.FIELD_GFB_PAUSCHAL);
        this.summe_ag_kosten = this.summe_ag_kosten.add(this.FIELD_AG_KOSTEN);
        this.summe_sv_brutto = this.summe_sv_brutto.add(this.FIELD_SV_BRUTTO);
        this.summe_solz = this.summe_solz.add(this.FIELD_SOLIDARITAETSZUSCHLAG);
        this.summe_kv_aga = this.summe_kv_aga.add(this.FIELD_KV_AGA);
        this.summe_rv_aga = this.summe_rv_aga.add(this.FIELD_RV_AGA);
        this.summe_av_aga = this.summe_av_aga.add(this.FIELD_AV_AGA);
        this.summe_pv_aga = this.summe_pv_aga.add(this.FIELD_PV_AGA);
        this.summe_pv_agz = this.summe_pv_agz.add(this.FIELD_PV_AGZ);
        this.summe_insg_umlage = this.summe_insg_umlage.add(this.FIELD_INSG_UMLAGE);
        this.summe_bezuege_abzuege = this.summe_bezuege_abzuege.add(this.FIELD_BE_ABZUEGE);
        this.summe_kug = this.summe_kug.add(this.FIELD_KUG);
        this.summe_zvk_aga = this.summe_zvk_aga.add(this.FIELD_ZVK_AGA);
        this.summe_auszahlung = this.summe_auszahlung.add(this.FIELD_AUSZAHLUNG);
        if (this.mPCompanyHasPlants) {
            this.gesamtsumme_gesamt_brutto = this.gesamtsumme_gesamt_brutto.add(this.FIELD_GESAMT_BRUTTO);
            this.gesamtsumme_lst = this.gesamtsumme_lst.add(this.FIELD_LOHNSTEUER);
            this.gesamtsumme_kv_entgelt = this.gesamtsumme_kv_entgelt.add(this.FIELD_KV_ENTGELT);
            this.gesamtsumme_rv_entgelt = this.gesamtsumme_rv_entgelt.add(this.FIELD_RV_ENTGELT);
            this.gesamtsumme_av_entgelt = this.gesamtsumme_av_entgelt.add(this.FIELD_AV_ENTGELT);
            this.gesamtsumme_pv_entgelt = this.gesamtsumme_pv_entgelt.add(this.FIELD_PV_ENTGELT);
            this.gesamtsumme_kv_agz = this.gesamtsumme_kv_agz.add(this.FIELD_KV_AGZ);
            this.gesamtsumme_u_entgelt = this.gesamtsumme_u_entgelt.add(this.FIELD_UMLAGE_ENTGELT);
            this.gesamtsumme_gesetzl_abz = this.gesamtsumme_gesetzl_abz.add(this.FIELD_GESETZLICHE_ABZUEGE);
            this.gesamtsumme_vwl = this.gesamtsumme_vwl.add(this.FIELD_VWL);
            this.gesamtsumme_an_pauschal = this.gesamtsumme_an_pauschal.add(this.FIELD_AN_PAUSCHAL);
            this.gesamtsumme_zvk_ana = this.gesamtsumme_zvk_ana.add(this.FIELD_ZVK_ANA);
            this.gesamtsumme_steuer_brutto = this.gesamtsumme_steuer_brutto.add(this.FIELD_STEUER_BRUTTO);
            this.gesamtsumme_kist = this.gesamtsumme_kist.add(this.FIELD_KIST);
            this.gesamtsumme_kv_ana = this.gesamtsumme_kv_ana.add(this.FIELD_KV_ANA);
            this.gesamtsumme_rv_ana = this.gesamtsumme_rv_ana.add(this.FIELD_RV_ANA);
            this.gesamtsumme_av_ana = this.gesamtsumme_av_ana.add(this.FIELD_AV_ANA);
            this.gesamtsumme_pv_ana = this.gesamtsumme_pv_ana.add(this.FIELD_PV_ANA);
            this.gesamtsumme_rv_agz = this.gesamtsumme_rv_agz.add(this.FIELD_RV_AGZ);
            this.gesamtsumme_u_beitrag = this.gesamtsumme_u_beitrag.add(this.FIELD_UMLAGE_BEITRAG);
            this.gesamtsumme_nettolohn = this.gesamtsumme_nettolohn.add(this.FIELD_NETTOLOHN);
            this.gesamtsumme_kammer = this.gesamtsumme_kammer.add(this.FIELD_KAMMER);
            this.gesamtsumme_ag_pauschal = this.gesamtsumme_ag_pauschal.add(this.FIELD_AG_PAUSCHAL);
            this.gesamtsumme_gfb_pauschal = this.gesamtsumme_gfb_pauschal.add(this.FIELD_GFB_PAUSCHAL);
            this.gesamtsumme_ag_kosten = this.gesamtsumme_ag_kosten.add(this.FIELD_AG_KOSTEN);
            this.gesamtsumme_sv_brutto = this.gesamtsumme_sv_brutto.add(this.FIELD_SV_BRUTTO);
            this.gesamtsumme_solz = this.gesamtsumme_solz.add(this.FIELD_SOLIDARITAETSZUSCHLAG);
            this.gesamtsumme_kv_aga = this.gesamtsumme_kv_aga.add(this.FIELD_KV_AGA);
            this.gesamtsumme_rv_aga = this.gesamtsumme_rv_aga.add(this.FIELD_RV_AGA);
            this.gesamtsumme_av_aga = this.gesamtsumme_av_aga.add(this.FIELD_AV_AGA);
            this.gesamtsumme_pv_aga = this.gesamtsumme_pv_aga.add(this.FIELD_PV_AGA);
            this.gesamtsumme_pv_agz = this.gesamtsumme_pv_agz.add(this.FIELD_PV_AGZ);
            this.gesamtsumme_insg_umlage = this.gesamtsumme_insg_umlage.add(this.FIELD_INSG_UMLAGE);
            this.gesamtsumme_bezuege_abzuege = this.gesamtsumme_bezuege_abzuege.add(this.FIELD_BE_ABZUEGE);
            this.gesamtsumme_kug = this.gesamtsumme_kug.add(this.FIELD_KUG);
            this.gesamtsumme_zvk_aga = this.gesamtsumme_zvk_aga.add(this.FIELD_ZVK_AGA);
            this.gesamtsumme_auszahlung = this.gesamtsumme_auszahlung.add(this.FIELD_AUSZAHLUNG);
            JournalOfWageShortSumBean bean = this.mSumBeanHashMap.get(this.FIELD_BETRIEBSSTAETTE_KEY + " / " + this.FIELD_BETRIEBSSTAETTE);
            if (bean == null) {
                bean = new JournalOfWageShortSumBean(this.FIELD_BETRIEBSSTAETTE_KEY + " / " + this.FIELD_BETRIEBSSTAETTE);
                bean.addF_gesamt_brutto(this.FIELD_GESAMT_BRUTTO);
                bean.addF_lst(this.FIELD_LOHNSTEUER);
                bean.addF_kv_entgelt(this.FIELD_KV_ENTGELT);
                bean.addF_rv_entgelt(this.FIELD_RV_ENTGELT);
                bean.addF_av_entgelt(this.FIELD_AV_ENTGELT);
                bean.addF_pv_entgelt(this.FIELD_PV_ENTGELT);
                bean.addF_kv_agz(this.FIELD_KV_AGZ);
                bean.addF_u_entgelt(this.FIELD_UMLAGE_ENTGELT);
                bean.addF_gesetzl_abz(this.FIELD_GESETZLICHE_ABZUEGE);
                bean.addF_vwl(this.FIELD_VWL);
                bean.addF_an_pauschal(this.FIELD_AN_PAUSCHAL);
                bean.addF_zvk_ana(this.FIELD_ZVK_ANA);
                bean.addF_steuer_brutto(this.FIELD_STEUER_BRUTTO);
                bean.addF_kist(this.FIELD_KIST);
                bean.addF_kv_ana(this.FIELD_KV_ANA);
                bean.addF_rv_ana(this.FIELD_RV_ANA);
                bean.addF_av_ana(this.FIELD_AV_ANA);
                bean.addF_pv_ana(this.FIELD_PV_ANA);
                bean.addF_rv_agz(this.FIELD_RV_AGZ);
                bean.addF_u_beitrag(this.FIELD_UMLAGE_BEITRAG);
                bean.addF_nettolohn(this.FIELD_NETTOLOHN);
                bean.addF_kammer(this.FIELD_KAMMER);
                bean.addF_ag_pauschal(this.FIELD_AG_PAUSCHAL);
                bean.addF_gfb_pauschal(this.FIELD_GFB_PAUSCHAL);
                bean.addF_ag_kosten(this.FIELD_AG_KOSTEN);
                bean.addF_sv_brutto(this.FIELD_SV_BRUTTO);
                bean.addF_solz(this.FIELD_SOLIDARITAETSZUSCHLAG);
                bean.addF_kv_aga(this.FIELD_KV_AGA);
                bean.addF_rv_aga(this.FIELD_RV_AGA);
                bean.addF_av_aga(this.FIELD_AV_AGA);
                bean.addF_pv_aga(this.FIELD_PV_AGA);
                bean.addF_pv_agz(this.FIELD_PV_AGZ);
                bean.addF_insg_umlage(this.FIELD_INSG_UMLAGE);
                bean.addF_bezuege_abzuege(this.FIELD_BE_ABZUEGE);
                bean.addF_kug(this.FIELD_KUG);
                bean.addF_zvk_aga(this.FIELD_ZVK_AGA);
                bean.addF_auszahlung(this.FIELD_AUSZAHLUNG);
                this.mSumBeanHashMap.put(this.FIELD_BETRIEBSSTAETTE_KEY + " / " + this.FIELD_BETRIEBSSTAETTE, bean);
            } else {
                bean.addF_gesamt_brutto(this.FIELD_GESAMT_BRUTTO);
                bean.addF_lst(this.FIELD_LOHNSTEUER);
                bean.addF_kv_entgelt(this.FIELD_KV_ENTGELT);
                bean.addF_rv_entgelt(this.FIELD_RV_ENTGELT);
                bean.addF_av_entgelt(this.FIELD_AV_ENTGELT);
                bean.addF_pv_entgelt(this.FIELD_PV_ENTGELT);
                bean.addF_kv_agz(this.FIELD_KV_AGZ);
                bean.addF_u_entgelt(this.FIELD_UMLAGE_ENTGELT);
                bean.addF_gesetzl_abz(this.FIELD_GESETZLICHE_ABZUEGE);
                bean.addF_vwl(this.FIELD_VWL);
                bean.addF_an_pauschal(this.FIELD_AN_PAUSCHAL);
                bean.addF_zvk_ana(this.FIELD_ZVK_ANA);
                bean.addF_steuer_brutto(this.FIELD_STEUER_BRUTTO);
                bean.addF_kist(this.FIELD_KIST);
                bean.addF_kv_ana(this.FIELD_KV_ANA);
                bean.addF_rv_ana(this.FIELD_RV_ANA);
                bean.addF_av_ana(this.FIELD_AV_ANA);
                bean.addF_pv_ana(this.FIELD_PV_ANA);
                bean.addF_rv_agz(this.FIELD_RV_AGZ);
                bean.addF_u_beitrag(this.FIELD_UMLAGE_BEITRAG);
                bean.addF_nettolohn(this.FIELD_NETTOLOHN);
                bean.addF_kammer(this.FIELD_KAMMER);
                bean.addF_ag_pauschal(this.FIELD_AG_PAUSCHAL);
                bean.addF_gfb_pauschal(this.FIELD_GFB_PAUSCHAL);
                bean.addF_ag_kosten(this.FIELD_AG_KOSTEN);
                bean.addF_sv_brutto(this.FIELD_SV_BRUTTO);
                bean.addF_solz(this.FIELD_SOLIDARITAETSZUSCHLAG);
                bean.addF_kv_aga(this.FIELD_KV_AGA);
                bean.addF_rv_aga(this.FIELD_RV_AGA);
                bean.addF_av_aga(this.FIELD_AV_AGA);
                bean.addF_pv_aga(this.FIELD_PV_AGA);
                bean.addF_pv_agz(this.FIELD_PV_AGZ);
                bean.addF_insg_umlage(this.FIELD_INSG_UMLAGE);
                bean.addF_bezuege_abzuege(this.FIELD_BE_ABZUEGE);
                bean.addF_kug(this.FIELD_KUG);
                bean.addF_zvk_aga(this.FIELD_ZVK_AGA);
                bean.addF_auszahlung(this.FIELD_AUSZAHLUNG);
                this.mSumBeanHashMap.put(this.FIELD_BETRIEBSSTAETTE_KEY + " / " + this.FIELD_BETRIEBSSTAETTE, bean);
            }
        }
    }

    private void copySumDataValuesToTempFields() {
        this.summe_gesamt_brutto = this.gesamtsumme_gesamt_brutto;
        this.summe_lst = this.gesamtsumme_lst;
        this.summe_kv_entgelt = this.gesamtsumme_kv_entgelt;
        this.summe_rv_entgelt = this.gesamtsumme_rv_entgelt;
        this.summe_av_entgelt = this.gesamtsumme_av_entgelt;
        this.summe_pv_entgelt = this.gesamtsumme_pv_entgelt;
        this.summe_kv_agz = this.gesamtsumme_kv_agz;
        this.summe_u_entgelt = this.gesamtsumme_u_entgelt;
        this.summe_gesetzl_abz = this.gesamtsumme_gesetzl_abz;
        this.summe_vwl = this.gesamtsumme_vwl;
        this.summe_an_pauschal = this.gesamtsumme_an_pauschal;
        this.summe_zvk_ana = this.gesamtsumme_zvk_ana;
        this.summe_steuer_brutto = this.gesamtsumme_steuer_brutto;
        this.summe_kist = this.gesamtsumme_kist;
        this.summe_kv_ana = this.gesamtsumme_kv_ana;
        this.summe_rv_ana = this.gesamtsumme_rv_ana;
        this.summe_av_ana = this.gesamtsumme_av_ana;
        this.summe_pv_ana = this.gesamtsumme_pv_ana;
        this.summe_rv_agz = this.gesamtsumme_rv_agz;
        this.summe_u_beitrag = this.gesamtsumme_u_beitrag;
        this.summe_nettolohn = this.gesamtsumme_nettolohn;
        this.summe_kammer = this.gesamtsumme_kammer;
        this.summe_ag_pauschal = this.gesamtsumme_ag_pauschal;
        this.summe_gfb_pauschal = this.gesamtsumme_gfb_pauschal;
        this.summe_ag_kosten = this.gesamtsumme_ag_kosten;
        this.summe_sv_brutto = this.gesamtsumme_sv_brutto;
        this.summe_solz = this.gesamtsumme_solz;
        this.summe_kv_aga = this.gesamtsumme_kv_aga;
        this.summe_rv_aga = this.gesamtsumme_rv_aga;
        this.summe_av_aga = this.gesamtsumme_av_aga;
        this.summe_pv_aga = this.gesamtsumme_pv_aga;
        this.summe_pv_agz = this.gesamtsumme_pv_agz;
        this.summe_insg_umlage = this.gesamtsumme_insg_umlage;
        this.summe_bezuege_abzuege = this.gesamtsumme_bezuege_abzuege;
        this.summe_kug = this.gesamtsumme_kug;
        this.summe_zvk_aga = this.gesamtsumme_zvk_aga;
        this.summe_auszahlung = this.gesamtsumme_auszahlung;
    }

    private void getSumBeanIterator() {
        LinkedList<JournalOfWageShortSumBean> beanList = new LinkedList<JournalOfWageShortSumBean>(this.mSumBeanHashMap.values());
        beanList.sort(Comparator.comparing(JournalOfWageShortSumBean::getF_betriebsstaette));
        this.mSumBeanIterator = beanList.iterator();
    }

    private void buildSumCollection() {
        JournalOfWageShortSumBean bean = this.mSumBeanIterator.next();
        if (bean != null) {
            this.FIELD_BETRIEBSSTAETTE = "Summenblatt";
            this.FIELD_BETRIEBSSTAETTE_KEY = "";
            this.FIELD_PERSONAL_NR = "";
            this.FIELD_NAME = bean.getF_betriebsstaette();
            this.FIELD_VORNAME = "";
            this.FIELD_KRANKENKASSE = "";
            this.FIELD_BEITR_GP_KV = "";
            this.FIELD_BEITR_GP_RV = "";
            this.FIELD_BEITR_GP_AV = "";
            this.FIELD_BEITR_GP_PV = "";
            this.FIELD_PARENT = "";
            this.FIELD_GESAMT_BRUTTO = bean.getF_gesamt_brutto();
            this.FIELD_LOHNSTEUER = bean.getF_lst();
            this.FIELD_KV_ENTGELT = bean.getF_kv_entgelt();
            this.FIELD_RV_ENTGELT = bean.getF_rv_entgelt();
            this.FIELD_AV_ENTGELT = bean.getF_av_entgelt();
            this.FIELD_PV_ENTGELT = bean.getF_pv_entgelt();
            this.FIELD_KV_AGZ = bean.getF_kv_agz();
            this.FIELD_UMLAGE_ENTGELT = bean.getF_u_entgelt();
            this.FIELD_GESETZLICHE_ABZUEGE = bean.getF_gesetzl_abz();
            this.FIELD_VWL = bean.getF_vwl();
            this.FIELD_AN_PAUSCHAL = bean.getF_an_pauschal();
            this.FIELD_ZVK_ANA = bean.getF_zvk_ana();
            this.FIELD_STEUERKLASSE = "";
            this.FIELD_STEUERTABELLE = "";
            this.FIELD_STEUERFAKTOR = "";
            this.FIELD_ZKF = "";
            this.FIELD_RELI_AN = "";
            this.FIELD_RELI_EG = "";
            this.FIELD_GFB = "";
            this.FIELD_GRV = "";
            this.FIELD_MFB = "";
            this.FIELD_RK = "";
            this.FIELD_STEUER_BRUTTO = bean.getF_steuer_brutto();
            this.FIELD_KIST = bean.getF_kist();
            this.FIELD_KV_ANA = bean.getF_kv_ana();
            this.FIELD_RV_ANA = bean.getF_rv_ana();
            this.FIELD_AV_ANA = bean.getF_av_ana();
            this.FIELD_PV_ANA = bean.getF_pv_ana();
            this.FIELD_RV_AGZ = bean.getF_rv_agz();
            this.FIELD_UMLAGE_BEITRAG = bean.getF_u_beitrag();
            this.FIELD_NETTOLOHN = bean.getF_nettolohn();
            this.FIELD_KAMMER = bean.getF_kammer();
            this.FIELD_AG_PAUSCHAL = bean.getF_ag_pauschal();
            this.FIELD_GFB_PAUSCHAL = bean.getF_gfb_pauschal();
            this.FIELD_AG_KOSTEN = bean.getF_ag_kosten();
            this.FIELD_ZEITRAUMVON = "";
            this.FIELD_ZEITRAUMBIS = "";
            this.FIELD_ST_TAGE = null;
            this.FIELD_SV_TAGE = null;
            this.FIELD_MTL_FREIB = null;
            this.FIELD_JHL_FREIB = null;
            this.FIELD_VBZ = "";
            this.FIELD_AE = "";
            this.FIELD_PGS = "";
            this.FIELD_SV_BRUTTO = bean.getF_sv_brutto();
            this.FIELD_SOLIDARITAETSZUSCHLAG = bean.getF_solz();
            this.FIELD_KV_AGA = bean.getF_kv_aga();
            this.FIELD_RV_AGA = bean.getF_rv_aga();
            this.FIELD_AV_AGA = bean.getF_av_aga();
            this.FIELD_PV_AGA = bean.getF_pv_aga();
            this.FIELD_PV_AGZ = bean.getF_pv_agz();
            this.FIELD_INSG_UMLAGE = bean.getF_insg_umlage();
            this.FIELD_BE_ABZUEGE = bean.getF_bezuege_abzuege();
            this.FIELD_KUG = bean.getF_kug();
            this.FIELD_ZVK_AGA = bean.getF_zvk_aga();
            this.FIELD_AUSZAHLUNG = bean.getF_auszahlung();
        }
    }

    private static boolean isRelevantToAdd(ValuePosition valuePosition, Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        ConsequenceOfValueType[] consequencesOfVT;
        for (ConsequenceOfValueType consequenceOfVT : consequencesOfVT = valuePosition.getValueType().getValueTypeTP(effectiveTimePoint, validTimePoint).getConsequenceForOrientation()) {
            if (consequenceOfVT.getConsequenceOfValueType().getValueTypeKey() != 100200) continue;
            return false;
        }
        return true;
    }

    class JOWBeanPreComparator
    implements Comparator<JournalOfWageEmployeeBean> {
        @Override
        public int compare(JournalOfWageEmployeeBean ebb1, JournalOfWageEmployeeBean ebb2) {
            int comp = DateHelper.compare((Date)ebb1.getValidFrom(), (Date)ebb2.getValidFrom());
            return comp;
        }
    }

    class JOWBeanComparator
    implements Comparator<JournalOfWageEmployeeBean> {
        @Override
        public int compare(JournalOfWageEmployeeBean ebb1, JournalOfWageEmployeeBean ebb2) {
            int comp = DateHelper.compare((Date)ebb1.getDateOfEntry(), (Date)ebb2.getDateOfEntry());
            return comp;
        }
    }
}

