/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.employeepayment;

import com.infor.igf.core.util.StringUtil;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Disjunction;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.text.TextFactory;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.CorbaExceptionMapper;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.domain.country.CountryPersistencyManager;
import com.varial.framework.domain.country.ICountry;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.paymentbase.PaymentCountryEnum;
import com.varial.framework.paymentbase.PaymentTransactionTypeEnum;
import com.varial.interfaces.IBankAccount;
import com.varial.interfaces.INLAccountCompanySetting;
import com.varial.interfaces.factory.NLAccountCompanySettingFactory;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.advancepayment.AdvancePayment;
import com.varial.personnel.domain.employee.advancepayment.AdvancePaymentTP;
import com.varial.personnel.domain.employee.attachment.EEAttachment;
import com.varial.personnel.domain.employee.bankdetails.Truncation;
import com.varial.personnel.domain.employee.bankdetails.TruncationEnum;
import com.varial.personnel.domain.employee.bankdetails.TruncationScaleEnum;
import com.varial.personnel.domain.employee.bankdetails.mapper.TruncationEnumMapper;
import com.varial.personnel.domain.employee.bankdetails.mapper.TruncationScaleEnumMapper;
import com.varial.personnel.domain.employee.paymentdeduction.EEPaymentDeduction;
import com.varial.personnel.domain.employee.paymentdeduction.ModeOfDeductionEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.global.recipient.ModeOfPaymentEnum;
import com.varial.personnel.domain.global.recipient.Recipient;
import com.varial.personnel.domain.payment.PayrollPayment;
import com.varial.personnel.domain.payment.PayrollPaymentBank;
import com.varial.personnel.domain.payment.PayrollPaymentSession;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.SortCriteriaEnum;
import com.varial.personnel.domain.reports.employeepayment.AttachmentBean;
import com.varial.personnel.domain.reports.employeepayment.EmployeePaymentBean;
import com.varial.personnel.domain.reports.employeepayment.EmployeePaymentDataBean;
import com.varial.personnel.domain.reports.employeepayment.EmployeePaymentType;
import com.varial.personnel.domain.reports.employeepayment.ErrorBean;
import com.varial.personnel.domain.reports.employeepayment.PayDeductionBean;
import com.varial.personnel.domain.reports.employeepayment.PensionSchemeReasonForTransfer;
import com.varial.personnel.domain.reports.employeepayment.mapper.PaymentExceptionMapper;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.library.EvaluationBean;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.library.ReportValues;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.basictypes.PRestrictions;
import com.varial.personnel.framework.basictypes.TypeOfBankTransferEnum;
import com.varial.personnel.isoft.domain.reports.employeepayment.EmployeePaymentIndividual;
import com.varial.personnel.persistency.assignments.comprecipientall.ComprecipientallContainer;
import com.varial.personnel.persistency.assignments.comprecipientall.IComprecipientallDao;
import com.varial.personnel.persistency.calculation.calculationbasic.CalculationbasicContainer;
import com.varial.personnel.persistency.calculation.calculationbasic.ICalculationbasicDao;
import com.varial.personnel.persistency.company.companyaccount.CompanyaccountContainer;
import com.varial.personnel.persistency.company.companyaccount.ICompanyaccountDao;
import com.varial.personnel.persistency.company.companyaccounttp.CompanyaccounttpContainer;
import com.varial.personnel.persistency.company.companyaccounttp.ICompanyaccounttpDao;
import com.varial.personnel.persistency.employee.attachmentall.AttachmentallContainer;
import com.varial.personnel.persistency.employee.attachmentall.IAttachmentallDao;
import com.varial.personnel.persistency.employee.eebankdetailsall.EebankdetailsallContainer;
import com.varial.personnel.persistency.employee.eebankdetailsall.IEebankdetailsallDao;
import com.varial.personnel.persistency.employee.eepensschemeall.EepensschemeallContainer;
import com.varial.personnel.persistency.employee.eepensschemeall.IEepensschemeallDao;
import com.varial.personnel.persistency.employee.employmentall.IEmploymentallDao;
import com.varial.personnel.persistency.employee.masterall.IMasterallDao;
import com.varial.personnel.persistency.employee.masterall.MasterallContainer;
import com.varial.personnel.persistency.employee.paydeductionall.IPaydeductionallDao;
import com.varial.personnel.persistency.employee.paydeductionall.PaydeductionallContainer;
import com.varial.personnel.persistency.employee.valueposition.IValuepositionDao;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.personnel.persistency.global.banktp.BanktpContainer;
import com.varial.personnel.persistency.global.banktp.IBanktpDao;
import com.varial.personnel.persistency.global.recipientall.IRecipientallDao;
import com.varial.personnel.persistency.global.recipientall.RecipientallContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import com.varial.serverbase.query.AllCallback;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.springframework.beans.factory.InitializingBean;

public class EmployeePaymentDataSource
implements JRDataSource,
InitializingBean {
    private ICalculationbasicDao daoCalculationbasic;
    private ICompanyaccountDao daoCompanyaccount;
    private ICompanyaccounttpDao daoCompanyaccounttp;
    private IAttachmentallDao daoAttachmentall;
    private IEebankdetailsallDao daoEebankdetailsall;
    private IEepensschemeallDao daoEepensschemeall;
    private IEmploymentallDao daoEmploymentall;
    private IMasterallDao daoMasterall;
    private IPaydeductionallDao daoPaydeductionall;
    private IValuepositionDao daoValueposition;
    private IBanktpDao daoBanktp;
    private IRecipientallDao daoRecipientall;
    private IComprecipientallDao daoComprecipientall;
    private static final BigDecimal ZERO = BigDecimal.valueOf(0L, 2);
    private static final String _18TIMES9 = "999999999999999999";
    private String FIELD_MONAT;
    private String FIELD_USER;
    private String FIELD_DATE;
    private String FIELD_RELEASE;
    private String FIELD_FIRMA_BEZEICHNUNG;
    private String FIELD_FIRMA_NR;
    private String FIELD_PERSONALNUMMER;
    private String FIELD_NAME;
    private String FIELD_BLZ;
    private String FIELD_BANKBEZEICHNUNG;
    private String FIELD_KONTONUMMER;
    private String FIELD_VERWENDUNGSZWECK;
    private String FIELD_EMPFAENGER;
    private String FIELD_ZAHLUNGSART;
    private String FIELD_BETRAG;
    private String FIELD_SUMME_DTA;
    private String FIELD_SUMME_BAR;
    private String FIELD_SUMME_SCHECK;
    private String FIELD_SUMME_EINZUG;
    private String FIELD_SUMME_GESAMT;
    private String FIELD_HAUSBANK;
    private Collection<EmployeePaymentDataBean> FIELD_WAGEDATAS;
    private Collection<ErrorBean> FIELD_ERRORDATAS;
    private Date mUltimoOfPaymentMonth;
    protected Date mForValidDate;
    protected Date mForEffectiveDate;
    private String mOidPCompany;
    private String[] mOidPCompanies;
    private String mName;
    private String mmjjjj;
    private String mBank;
    private String mPaymentTransactionCode;
    private String mStandardBankAccount;
    private final List<MasterallContainer> mMasterallContainerList = new LinkedList<MasterallContainer>();
    private final List<ErrorBean> errorList = new ArrayList<ErrorBean>();
    private final List<EvaluationBean> mToValuate = new ArrayList<EvaluationBean>();
    private Iterator<List<EmployeePaymentDataBean>> mPaymentIterator;
    private INLAccountCompanySetting mNlAccountCompanySetting;
    private boolean mHasPayments = false;
    private boolean mAnticipationPayment;
    private boolean mAdvancePayment;
    private boolean mSalary;
    private boolean mAttachment;
    private boolean mVwlPayment;
    private boolean mPaymentDeduction;
    private boolean mPensionScheme;
    private AllCallback mCallback;
    private ISpecialAccessPersistencyContext mSpecialAccessPersistencyContext;
    private ReportFirstFilterStruct mFirstFilter;
    private ReportSecondFilterStruct[] mSecondFilters;
    private ReportThirdFilterStruct mThirdFilter;
    private ReportSortStruct[] mSorts;
    private String mOidNominalAccount;
    private List<String> mErrorList;
    private String[] mOIDEmployees;
    private String[] mValueTypes;
    private int mIndex = 0;
    private boolean mSortNachName = false;
    private PCompany mCompanyForSettings;
    private boolean mIsSuperiorForConsolidation;
    private ReportValues mReportValues;
    private final Map<String, BanktpContainer> mBankHashMap = new HashMap<String, BanktpContainer>();
    private final Set<String> mBankKeySet = new HashSet<String>();
    private final Map<String, CompanyaccountContainer> mCompanyAccountHashMap = new HashMap<String, CompanyaccountContainer>();
    private final Map<String, List<EebankdetailsallContainer>> mEEBankDetailsAllHashMap = new HashMap<String, List<EebankdetailsallContainer>>();
    private final Map<String, ValuepositionContainer> mValuePositionHashMap = new HashMap<String, ValuepositionContainer>();
    private final Map<String, RecipientallContainer> mRecipientHashMap = new HashMap<String, RecipientallContainer>();
    private final Map<String, ComprecipientallContainer> mCompRecipientHashMap = new HashMap<String, ComprecipientallContainer>();
    private final Map<String, CompanyFoundations> mCompanyFoundationsMap = new HashMap<String, CompanyFoundations>();
    private final Map<String, PCompany> mPCompanyMap = new HashMap<String, PCompany>();
    private final LinkedList<EmployeePaymentDataBean> mEmployeePaymentDataBeans = new LinkedList();
    private final Map<String, Map<String, List<EmployeePaymentDataBean>>> mTempAllHashMap = new HashMap<String, Map<String, List<EmployeePaymentDataBean>>>();
    private final Map<String, String> mHomeBankHashMap = new HashMap<String, String>();
    private final Map<String, AccountSums> mAccountSumsHashMap = new HashMap<String, AccountSums>();
    private final Map<String, Date> mCalculationbasicHashMap = new HashMap<String, Date>();
    private final Map<String, String> mPaymentNoteHashMap = new HashMap<String, String>();
    private final Map<String, PayDeductionBean> mPayDeductionHashMap = new HashMap<String, PayDeductionBean>();
    private final Map<String, AttachmentBean> mAttachmentHashMap = new HashMap<String, AttachmentBean>();
    private final Map<String, Integer> mValueTypeMap = new HashMap<String, Integer>();
    private PensionSchemeReasonForTransfer mPensionSchemeReasonForTransfer;
    private EmployeeForReportGenerator generator;
    private static final String NO_BANK_ACCOUNT_FOR_EMPLOYEE = " Keine Bankverbindung";
    private static final String NO_TYPE_OF_PAYMENT_FOR_EMPLOYEE = " Keine Zahlungsweise";
    private static final String NO_COMPANY_BANK_ACCOUNT_FOR_EMPLOYEE = " Kein Firmenbankkonto zugewiesen";

    public Date getForEffectiveDate() {
        return this.mForEffectiveDate;
    }

    public Date getForValidDate() {
        return this.mForValidDate;
    }

    public void setOidPCompany(String oidPCompany) {
        this.mOidPCompany = oidPCompany;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setForEffectiveDate(Date forEffectiveDate) {
        this.mForEffectiveDate = forEffectiveDate;
    }

    public void setForValidDate(Date forValidDate) {
        this.mForValidDate = forValidDate;
    }

    public void setAnticipationPayment(boolean anticipationPayment) {
        this.mAnticipationPayment = anticipationPayment;
    }

    public void setAdvancePayment(boolean advancePayment) {
        this.mAdvancePayment = advancePayment;
    }

    public void setSalary(boolean salary) {
        this.mSalary = salary;
    }

    public void setAttachment(boolean attachment) {
        this.mAttachment = attachment;
    }

    public void setVwlPayment(boolean vwlPayment) {
        this.mVwlPayment = vwlPayment;
    }

    public void setPaymentDeduction(boolean paymentDeduction) {
        this.mPaymentDeduction = paymentDeduction;
    }

    public void setPensionScheme(boolean pensionScheme) {
        this.mPensionScheme = pensionScheme;
    }

    public void setCallback(AllCallback callback) {
        this.mCallback = callback;
    }

    public void setSpecialAccessPersistencyContext(ISpecialAccessPersistencyContext specialAccessPersistencyContext) {
        this.mSpecialAccessPersistencyContext = specialAccessPersistencyContext;
    }

    public void setFirstFilter(ReportFirstFilterStruct firstFilter) {
        this.mFirstFilter = firstFilter;
    }

    public void setSecondFilters(ReportSecondFilterStruct[] secondFilters) {
        this.mSecondFilters = secondFilters;
    }

    public void setThirdFilter(ReportThirdFilterStruct thirdFilter) {
        this.mThirdFilter = thirdFilter;
    }

    public void setSorts(ReportSortStruct[] sorts) {
        this.mSorts = sorts;
        this.mSortNachName = sorts.length > 0 && sorts[0].criteria == SortCriteriaEnum.SCE_employee && sorts[0].description;
    }

    public void setOidNominalAccount(String oidNominalAccount) {
        this.mOidNominalAccount = oidNominalAccount;
    }

    public void setErrorList(List<String> errorList) {
        this.mErrorList = errorList;
    }

    private void addError(String personnelNumber, String text) {
        this.errorList.add(new ErrorBean(personnelNumber, personnelNumber + "\t" + text, Boolean.TRUE, Boolean.FALSE));
    }

    private void addErrorKeinFirmenkontoBeiZahlungenAnDritte(PaydeductionallContainer payDeductionAllContainer) throws BusinessDomainException {
        Object personnelNumber;
        if (this.mIsSuperiorForConsolidation) {
            String pCompanyKey = this.mReportValues.getPCompanyKey(payDeductionAllContainer.oidpcompany);
            personnelNumber = pCompanyKey + "/" + Integer.toString(payDeductionAllContainer.personnelnumber);
        } else {
            personnelNumber = Integer.toString(payDeductionAllContainer.personnelnumber);
        }
        this.addError((String)personnelNumber, payDeductionAllContainer.surname + ", " + payDeductionAllContainer.firstname + " - Kein Firmenkonto bei Zahlungen an Dritte - Zahlung wurde auf Bar gesetzt!");
    }

    public void startWorking() throws BusinessDomainException {
        this.mNlAccountCompanySetting = !StringMapper.isNullString((String)this.mOidNominalAccount) ? NLAccountCompanySettingFactory.getFactory().getNLAccountCompanySetting(this.mOidNominalAccount) : null;
        this.mUltimoOfPaymentMonth = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
        if (StringMapper.isNullString((String)this.mName)) {
            throw PaymentExceptionMapper.makeNoNameForEmployeePaymentException();
        }
        this.generator = new EmployeeForReportGenerator(this.mSpecialAccessPersistencyContext, this.mFirstFilter, this.mSecondFilters, this.mThirdFilter, this.mSorts, this.mForEffectiveDate, DateHelper.getFirstDayOfMonth((Date)this.mForValidDate), DateHelper.getLastDayOfMonth((Date)this.mForValidDate), this.mErrorList);
        this.mCompanyForSettings = this.generator.getPCompanyForSettings();
        this.mOidPCompanies = this.generator.getPCompanies();
        this.mIsSuperiorForConsolidation = this.generator.isSuperiorForConsolidation();
        ReportHelper.getPaymentSessionName((String)this.mName, (String)this.mCompanyForSettings.getObjectid());
        if (!this.mErrorList.isEmpty()) {
            String[] messages = this.mErrorList.toArray(new String[this.mErrorList.size()]);
            EmployeeForReport[] de = ReportExceptionMapper.makeStickyEmployeesInEmployeeForReport(messages);
            this.mErrorList.clear();
            this.mCallback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de));
        }
        LinkedList<String> oidEmployeeList = new LinkedList<String>();
        this.mReportValues = new ReportValues();
        this.init_mCalculationbasicHashMap();
        for (EmployeeForReport employee : this.generator.getEmployeesForReport()) {
            if (employee.getDateOfWithDrawal() != null) {
                if (DateHelper.afterOrEqual((Date)employee.getDateOfWithDrawal(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate)) || employee.getDateOfWithDrawal() == null) {
                    oidEmployeeList.add(employee.getOidEmployee());
                    continue;
                }
                Date returnCalculationDate = this.mCalculationbasicHashMap.get(employee.getOidEmployee());
                if (returnCalculationDate == null) continue;
                oidEmployeeList.add(employee.getOidEmployee());
                continue;
            }
            oidEmployeeList.add(employee.getOidEmployee());
        }
        this.mOIDEmployees = new String[oidEmployeeList.size()];
        this.mOIDEmployees = oidEmployeeList.toArray(this.mOIDEmployees);
        if (this.mOIDEmployees.length == 0) {
            throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
        }
        this.FIELD_NAME = this.mName;
        this.FIELD_FIRMA_NR = this.getPCompany(this.mOidPCompany).getPCompanyKey();
        this.FIELD_FIRMA_BEZEICHNUNG = this.getCompanyFoundations(this.mOidPCompany).getFoundations().getShortDescription();
        int month = new VDate(this.mForEffectiveDate).getMonth();
        String monat = ReportHelper.getMonthDescription((int)month);
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
        this.FIELD_MONAT = monat + " " + df.format(this.mForValidDate).substring(6, 10);
        this.FIELD_RELEASE = Version.getVersion();
        this.FIELD_USER = SessionContext.getInstance().getSession().getUserCode();
        this.FIELD_DATE = DateMapper.toDDMMYYYYPointSeparationString((Date)new Date());
        if (this.mAdvancePayment && this.mAnticipationPayment) {
            this.mValueTypes = new String[]{"870110", "871000"};
        }
        if (this.mAdvancePayment && !this.mAnticipationPayment) {
            this.mValueTypes = new String[]{"871000"};
        }
        if (!this.mAdvancePayment && this.mAnticipationPayment) {
            this.mValueTypes = new String[]{"870110"};
        }
        this.mmjjjj = DateMapper.toMMYYYYPointSeparationString((Date)this.mUltimoOfPaymentMonth);
        this.mPaymentTransactionCode = this.mmjjjj.substring(this.mmjjjj.length() - 1, this.mmjjjj.length());
        this.init_mValuePositionHashMap();
        this.init_mMasterallContainerList();
        this.init_mEEBankDetailsAllHashMap();
        this.init_mBankHashMap();
        this.init_mCompanyAccountHashMap();
        this.init_mRecipientHashMap();
        this.init_mCompRecipientHashMap();
        this.mPensionSchemeReasonForTransfer = new PensionSchemeReasonForTransfer(this.mForValidDate, this.mRecipientHashMap, this.mCompRecipientHashMap);
        this.createPayrollPaymentSessions();
    }

    private void createPayrollPaymentSessions() throws BusinessDomainException {
        List<Object> employeePaymentList = new LinkedList();
        List<Object> payDeductionList = new LinkedList();
        List<Object> pensionSchemeList = new LinkedList();
        List<Object> attachmentList = new LinkedList();
        Map<String, IBankAccount> compBankHashMap = this.getCompanyAccounts();
        Map<String, List<EmployeePaymentBean>> eeBankHashMap = this.getSortBankAccounts();
        HashMap<String, List<PaydeductionallContainer>> payDeductionHashMap = new HashMap();
        if (this.mPaymentDeduction || this.mVwlPayment) {
            this.init_mPayDeductionHashMapVariablerBetrag();
            payDeductionHashMap = this.getPayDeduction(this.getPayDeductionsVP(this.mOIDEmployees));
        }
        HashMap<String, List<EepensschemeallContainer>> pensionSchemenHashMap = new HashMap();
        if (this.mPensionScheme) {
            pensionSchemenHashMap = this.getEEPensionScheme(this.mOIDEmployees);
        }
        HashMap<String, List<AttachmentallContainer>> attachmentHashMap = new HashMap();
        if (this.mAttachment) {
            attachmentHashMap = this.getAttachment(this.getAttachmentVP(this.mOIDEmployees));
        }
        for (String kontoKey : this.mBankKeySet) {
            if (kontoKey.compareTo(_18TIMES9) != 0) {
                PayrollPayment[] payments;
                PayrollPaymentSession session = new PayrollPaymentSession(this.mCompanyForSettings.getCompany());
                session.makeSaveable();
                session.setName(this.mName + "          " + Integer.toString(this.mIndex));
                IBankAccount bankAccount = compBankHashMap.get(kontoKey);
                if (bankAccount == null) {
                    String blz = kontoKey.substring(0, 8);
                    String objectId = kontoKey.substring(8, kontoKey.length());
                    throw PaymentExceptionMapper.makeMissingCompanyAccountInAccountingException((String)("BLZ:\t" + blz + "\nobjectid des Kontos:\t" + objectId));
                }
                this.mBank = bankAccount.getBankName() + "  -  " + ReportHelper.toIbanFormat((String)bankAccount.getOtherReference()) + "  -  " + bankAccount.getSwift();
                this.mBank = this.mBank + "  -  Zahlungsart SEPA";
                this.mHomeBankHashMap.put(kontoKey, this.mBank);
                session.setBankAccount(bankAccount);
                session.setCreator(SessionContext.getInstance().getSession().getUserCode());
                session.setCreationDate(DateHelper.today());
                session.setPaymentCountry(PaymentCountryEnum.PCE_NATIONALPAYMENT);
                employeePaymentList = this.createEEPayments(kontoKey, eeBankHashMap, session);
                if (this.mPaymentDeduction || this.mVwlPayment) {
                    payDeductionList = this.createPayDeductions(kontoKey, payDeductionHashMap, session);
                }
                if (this.mPensionScheme) {
                    pensionSchemeList = this.createPensionScheme(kontoKey, pensionSchemenHashMap, session);
                }
                if (this.mAttachment) {
                    attachmentList = this.createAttachment(kontoKey, attachmentHashMap, session);
                }
                LinkedList sessionList = new LinkedList();
                if (employeePaymentList != null) {
                    sessionList.addAll(employeePaymentList);
                }
                if (payDeductionList != null) {
                    sessionList.addAll(payDeductionList);
                }
                if (pensionSchemeList != null) {
                    sessionList.addAll(pensionSchemeList);
                }
                if (attachmentList != null) {
                    sessionList.addAll(attachmentList);
                }
                if ((payments = sessionList.toArray(new PayrollPayment[0])).length == 0) {
                    session.destroy();
                } else {
                    this.mHasPayments = true;
                    session.setPayments((Payment[])payments);
                }
                ++this.mIndex;
                continue;
            }
            this.mBank = "keiner Hausbank zugeordnet";
            this.mHomeBankHashMap.put(kontoKey, this.mBank);
            employeePaymentList = this.createEEPayments(kontoKey, eeBankHashMap, null);
            payDeductionList = this.createPayDeductions(kontoKey, payDeductionHashMap, null);
            pensionSchemeList = this.createPensionScheme(kontoKey, pensionSchemenHashMap, null);
            attachmentList = this.createAttachment(kontoKey, attachmentHashMap, null);
        }
        this.mHomeBankHashMap.put("999999999999999998", "\u00dcberzahlungen");
        if (!this.errorList.isEmpty()) {
            Collections.sort(this.errorList, new ErrorListComparator());
            this.FIELD_ERRORDATAS = this.errorList;
        }
        for (EmployeePaymentDataBean paymentDatas : this.mEmployeePaymentDataBeans) {
            List<EmployeePaymentDataBean> list;
            Map<String, List<EmployeePaymentDataBean>> employeePaymentHashMap = this.mTempAllHashMap.get(paymentDatas.getBankKey());
            if (employeePaymentHashMap == null) {
                employeePaymentHashMap = new HashMap<String, List<EmployeePaymentDataBean>>();
                this.mTempAllHashMap.put(paymentDatas.getBankKey(), employeePaymentHashMap);
            }
            if ((list = employeePaymentHashMap.get(paymentDatas.getZahlungsgruppe())) == null) {
                list = new LinkedList<EmployeePaymentDataBean>();
                employeePaymentHashMap.put(paymentDatas.getZahlungsgruppe(), list);
            }
            list.add(paymentDatas);
        }
        LinkedList<String> paymentList = new LinkedList<String>(this.mTempAllHashMap.keySet());
        Collections.sort(paymentList, new PaymentComparator());
        Iterator<String> paymentAllIterator = paymentList.iterator();
        this.getPaymentLists(paymentAllIterator);
    }

    private List<PayrollPayment> createEEPayments(String kontoKey, Map<String, List<EmployeePaymentBean>> eeBankHashMap, PayrollPaymentSession session) throws BusinessDomainException {
        List<EmployeePaymentBean> eebankList;
        LinkedList<PayrollPayment> paymentList = new LinkedList<PayrollPayment>();
        if ((this.mSalary || this.mAnticipationPayment || this.mAdvancePayment) && (eebankList = eeBankHashMap.get(kontoKey)) != null) {
            for (EmployeePaymentBean employeePaymentBean : eebankList) {
                EmployeePaymentDataBean paymentData;
                Object personnelNumber;
                Object pCompanyKey;
                if (this.mIsSuperiorForConsolidation) {
                    pCompanyKey = this.mReportValues.getPCompanyKey(employeePaymentBean.getOidpcompany()) + "/";
                    personnelNumber = (String)pCompanyKey + Integer.toString(employeePaymentBean.getPersonnelnumber());
                } else {
                    pCompanyKey = "";
                    personnelNumber = Integer.toString(employeePaymentBean.getPersonnelnumber());
                }
                if (BigDecimalMapper.compareTo((BigDecimal)employeePaymentBean.getNetpay(), (BigDecimal)ZERO) == 0) continue;
                ModeOfPaymentEnum modeofpayment = this.getModeOfPayment(employeePaymentBean.getModeofpayment(), employeePaymentBean.getBiccode(), employeePaymentBean.getIban(), (String)personnelNumber, employeePaymentBean.getSurname() + ", " + employeePaymentBean.getFirstname(), "Lohn / Gehalt");
                if (BigDecimalMapper.compareTo((BigDecimal)employeePaymentBean.getNetpay(), (BigDecimal)ZERO) > 0) {
                    paymentData = new EmployeePaymentDataBean();
                    boolean companyAccount = StringMapper.compareTo((String)employeePaymentBean.getOidcompanyaccount(), (String)"") != 0 || this.mStandardBankAccount != null;
                    paymentData.setBlz(employeePaymentBean.getBiccode());
                    paymentData.setBankbezeichnung(employeePaymentBean.getShortdescriptionbank());
                    paymentData.setBankKey(kontoKey);
                    paymentData.setBetrag(employeePaymentBean.getNetpay());
                    paymentData.setKontonummer(ReportHelper.toIbanFormat((String)employeePaymentBean.getIban()));
                    if (StringMapper.isNullString((String)employeePaymentBean.getOwnerofaccount())) {
                        paymentData.setEmpfaenger(employeePaymentBean.getSurname() + ", " + employeePaymentBean.getFirstname());
                    } else {
                        paymentData.setEmpfaenger(employeePaymentBean.getOwnerofaccount());
                    }
                    String verwendungszweck = this.getVerwendungszweck(employeePaymentBean, true);
                    paymentData.setVerwendungszweck(verwendungszweck);
                    paymentData.setZahlungsart(this.getZahlungsart(modeofpayment));
                    paymentData.setZahlungsartKey(companyAccount ? modeofpayment.value() : 2);
                    paymentData.setBank(this.mBank);
                    paymentData.setName(employeePaymentBean.getSurname() + ", " + employeePaymentBean.getFirstname());
                    paymentData.setZahlungsgruppe("Lohn / Gehalt");
                    paymentData.setPersonalnummer((String)personnelNumber);
                    paymentData.setPersonalnummerForSort((String)pCompanyKey + ReportHelper.changeToCompare((String)personnelNumber));
                    this.mEmployeePaymentDataBeans.add(paymentData);
                    if (!companyAccount || BigDecimalMapper.compareTo((BigDecimal)employeePaymentBean.getNetpay(), (BigDecimal)ZERO) == -1 || modeofpayment.value() >= 2) continue;
                    PayrollPayment payment = new PayrollPayment(session);
                    payment.setAbsenderCode(paymentData.getPersonalnummer());
                    payment.setAbsenderBezeichnung(paymentData.getName());
                    payment.setBankName(employeePaymentBean.getShortdescriptionbank());
                    payment.setDocumentDate(DateHelper.today());
                    payment.setPaymentTransactionCode(this.mPaymentTransactionCode);
                    payment.setAmount(employeePaymentBean.getNetpay());
                    payment.setPaymentNote(verwendungszweck);
                    payment.setForcedPayment(false);
                    payment.setStop(false);
                    payment.setPaymentTransactionType(PaymentTransactionTypeEnum.PTTE_WAGE);
                    payment.setPaymentTransactionCode("");
                    payment.setNominalAccount(this.mNlAccountCompanySetting);
                    switch (modeofpayment.value()) {
                        case 0: {
                            payment.setTypeOfPayment(ModeOfPayment.DIRECT_DEBIT);
                            break;
                        }
                        case 1: {
                            payment.setTypeOfPayment(ModeOfPayment.CHECK);
                            break;
                        }
                        default: {
                            this.addError((String)personnelNumber, employeePaymentBean.getSurname() + ", " + employeePaymentBean.getFirstname() + NO_TYPE_OF_PAYMENT_FOR_EMPLOYEE);
                        }
                    }
                    payment.setShortAddressOwner(employeePaymentBean.getIban());
                    payment.setDeviatingOwner(employeePaymentBean.getOwnerofaccount());
                    payment.setBankAccountNumber(employeePaymentBean.getAccountnumber());
                    payment.setBankSortingCode(employeePaymentBean.getBankcodenumber());
                    payment.setBIC(employeePaymentBean.getBiccode());
                    PostalAddress address = StringMapper.isNullString((String)employeePaymentBean.getOwnerofaccount()) ? new PostalAddress(employeePaymentBean.getSurname() + ", " + employeePaymentBean.getFirstname(), employeePaymentBean.getStreet() + " " + employeePaymentBean.getStreetnumber(), employeePaymentBean.getPostalcode(), employeePaymentBean.getDomicile(), "", null, null, (ICountry)CountryPersistencyManager.getCountryByCodeWithCache((String)"DE")) : new PostalAddress(employeePaymentBean.getOwnerofaccount(), "", "", "", "", null, null, (ICountry)CountryPersistencyManager.getCountryByCodeWithCache((String)"DE"));
                    payment.setPostalAddress((IPostalAddress)address);
                    this.addPayment(this.mForValidDate, paymentList, payment, this.getIEmployeePM().getEmployee(employeePaymentBean.getOidemployee()), null, EmployeePaymentType.mitarbeiter, employeePaymentBean.getValueTypeNumberFromNetPay(), null);
                    continue;
                }
                if (BigDecimalMapper.compareTo((BigDecimal)employeePaymentBean.getNetpay(), (BigDecimal)ZERO) >= 0) continue;
                paymentData = new EmployeePaymentDataBean();
                paymentData.setBlz(employeePaymentBean.getBiccode());
                paymentData.setBankbezeichnung(employeePaymentBean.getShortdescriptionbank());
                paymentData.setBankKey("999999999999999998");
                paymentData.setBetrag(employeePaymentBean.getNetpay());
                paymentData.setKontonummer(ReportHelper.toIbanFormat((String)employeePaymentBean.getIban()));
                paymentData.setEmpfaenger(employeePaymentBean.getOwnerofaccount());
                paymentData.setVerwendungszweck(this.getVerwendungszweck(employeePaymentBean, false));
                paymentData.setZahlungsart(this.getZahlungsart(modeofpayment));
                paymentData.setZahlungsartKey(modeofpayment.value());
                paymentData.setBank(this.mBank);
                paymentData.setName(employeePaymentBean.getSurname() + ", " + employeePaymentBean.getFirstname());
                paymentData.setZahlungsgruppe("Lohn / Gehalt");
                paymentData.setPersonalnummer((String)personnelNumber);
                paymentData.setPersonalnummerForSort((String)pCompanyKey + ReportHelper.changeToCompare((String)personnelNumber));
                this.mEmployeePaymentDataBeans.add(paymentData);
            }
        }
        return paymentList;
    }

    private String getVerwendungszweck(EmployeePaymentBean employeePaymentBean, boolean repetitionofname) {
        Object verwendungszweck = this.mAdvancePayment || this.mAnticipationPayment ? this.mPaymentNoteHashMap.get(employeePaymentBean.getOidemployee()) : (!StringMapper.isNullString((String)employeePaymentBean.getReasonfortransfer()) ? employeePaymentBean.getReasonfortransfer() : "Lohn / Gehalt");
        verwendungszweck = (String)verwendungszweck + " " + this.mmjjjj;
        if (repetitionofname && employeePaymentBean.isRepetitionofname()) {
            verwendungszweck = (String)verwendungszweck + employeePaymentBean.getSurname() + ", " + employeePaymentBean.getFirstname();
        }
        verwendungszweck = EmployeePaymentIndividual.individuellerVerwendungszweck((EmployeePaymentDataSource)this, (String)verwendungszweck, (EmployeePaymentBean)employeePaymentBean);
        return verwendungszweck;
    }

    private String getZahlungsart(ModeOfPaymentEnum modeofpayment) {
        switch (modeofpayment.value()) {
            case 0: {
                return "\u00dcberweisung SEPA";
            }
            case 1: {
                return "Scheck";
            }
            case 2: {
                return "Bar";
            }
            case 3: {
                return "Einzug";
            }
        }
        throw new IllegalArgumentException(modeofpayment.toString());
    }

    private List<PayrollPayment> createPayDeductions(String kontoKey, Map<String, List<PaydeductionallContainer>> payDeductionHashMap, PayrollPaymentSession session) throws BusinessDomainException {
        List<PaydeductionallContainer> payDeductionList;
        LinkedList<Object> employeePaymentDataBeans = new LinkedList<Object>();
        if ((this.mPaymentDeduction || this.mVwlPayment) && (payDeductionList = payDeductionHashMap.get(kontoKey)) != null) {
            int referenceNumber = 200000;
            HashMap<SammelueberweisungKey, EmployeePaymentDataBean> hashMap = new HashMap<SammelueberweisungKey, EmployeePaymentDataBean>();
            for (PaydeductionallContainer payDeductionContainer : payDeductionList) {
                PostalAddress address;
                Object reasonfortransfer;
                ModeOfPaymentEnum modeofpayment;
                String iban;
                String accountNumber;
                BanktpContainer bankTPcontainer;
                SammelueberweisungKey sammelueberweisungKey;
                boolean useCompanyAccount;
                Object personnelNumber;
                Object pCompanyKey;
                if (payDeductionContainer == null || (!this.mVwlPayment || payDeductionContainer.modeofdeduction != 0) && payDeductionContainer.modeofdeduction != 2 && (!this.mPaymentDeduction || payDeductionContainer.modeofdeduction != 1)) continue;
                if (this.mIsSuperiorForConsolidation) {
                    pCompanyKey = this.mReportValues.getPCompanyKey(payDeductionContainer.oidpcompany) + "/";
                    personnelNumber = (String)pCompanyKey + Integer.toString(payDeductionContainer.personnelnumber);
                } else {
                    pCompanyKey = "";
                    personnelNumber = Integer.toString(payDeductionContainer.personnelnumber);
                }
                boolean bl = useCompanyAccount = !StringMapper.equal((String)payDeductionContainer.oidcompanyaccount, (String)"") || this.mStandardBankAccount != null;
                PayDeductionBean payDeductionBean = this.mPayDeductionHashMap.get(payDeductionContainer.objectidroot);
                BigDecimal amount = payDeductionBean.getBetrag();
                if (amount == null || BigDecimalMapper.compareTo((BigDecimal)amount, (BigDecimal)ZERO) <= 0) continue;
                String recipientName = "";
                boolean isSammelueberweisung = !StringMapper.isNullString((String)payDeductionContainer.oidrecipient) && (payDeductionContainer.modetype == 1 || payDeductionContainer.modetype == 3);
                SammelueberweisungKey sammelueberweisungKey2 = sammelueberweisungKey = isSammelueberweisung ? new SammelueberweisungKey(payDeductionContainer.valuetypenumber, payDeductionContainer.oidrecipient) : null;
                if (!StringMapper.isNullString((String)payDeductionContainer.oidrecipient)) {
                    RecipientallContainer recipientContainer = this.mRecipientHashMap.get(payDeductionContainer.oidrecipient);
                    ComprecipientallContainer compRecipientContainer = this.mCompRecipientHashMap.get(payDeductionContainer.oidrecipient);
                    bankTPcontainer = this.mBankHashMap.get(recipientContainer.oidbank);
                    accountNumber = recipientContainer.accountnumber;
                    iban = recipientContainer.iban;
                    modeofpayment = ModeOfPaymentEnum.from_int((int)recipientContainer.modeofpayment);
                    reasonfortransfer = !isSammelueberweisung && !StringMapper.isNullString((String)payDeductionContainer.reasonfortransfer) ? payDeductionContainer.reasonfortransfer + " " + this.mmjjjj : (compRecipientContainer != null && !StringMapper.isNullString((String)compRecipientContainer.reasonoftransfer) ? compRecipientContainer.reasonoftransfer + " " + this.mmjjjj : (!StringMapper.isNullString((String)recipientContainer.reasonfortransfer) ? recipientContainer.reasonfortransfer + " " + this.mmjjjj : ""));
                    if (StringMapper.isNullString((String)recipientContainer.longdescription) && payDeductionContainer.modeofpayment < 2) {
                        this.addError((String)personnelNumber, payDeductionContainer.surname + ", " + payDeductionContainer.firstname + " Keine Empf\u00e4nger bei Abz\u00fcge mit \u00dcberweisung");
                    } else {
                        recipientName = recipientContainer.longdescription;
                    }
                    address = new PostalAddress(recipientContainer.longdescription, recipientContainer.street, recipientContainer.postalcode, recipientContainer.city, "", null, null, (ICountry)CountryPersistencyManager.getCountryByCodeWithCache((String)"DE"));
                } else {
                    bankTPcontainer = this.mBankHashMap.get(payDeductionContainer.oidbank);
                    accountNumber = payDeductionContainer.accountnumber;
                    iban = payDeductionContainer.iban;
                    reasonfortransfer = payDeductionContainer.reasonfortransfer + " " + this.mmjjjj;
                    modeofpayment = ModeOfPaymentEnum.from_int((int)payDeductionContainer.modeofpayment);
                    if (StringMapper.isNullString((String)payDeductionContainer.recipient) && payDeductionContainer.modeofpayment < 2) {
                        this.addError((String)personnelNumber, payDeductionContainer.surname + ", " + payDeductionContainer.firstname + " Keine Empf\u00e4nger bei Abz\u00fcge mit \u00dcberweisung");
                    } else {
                        recipientName = payDeductionContainer.recipient;
                    }
                    address = new PostalAddress(payDeductionContainer.recipient, payDeductionContainer.street, payDeductionContainer.postalcode, payDeductionContainer.city, "", null, null, (ICountry)CountryPersistencyManager.getCountryByCodeWithCache((String)"DE"));
                }
                if (bankTPcontainer != null) {
                    modeofpayment = this.getModeOfPayment(modeofpayment, bankTPcontainer.biccode, iban, bankTPcontainer.bankcodenumber, payDeductionContainer.surname + ", " + payDeductionContainer.firstname, "Abz\u00fcge mit \u00dcberweisung");
                }
                EmployeePaymentDataBean paymentData = isSammelueberweisung ? (EmployeePaymentDataBean)hashMap.get(sammelueberweisungKey) : null;
                EEPaymentDeduction eePaymentDeduction = new EEPaymentDeduction(payDeductionContainer.objectidroot);
                if (paymentData != null) {
                    paymentData.addEEPaymentDeduction(eePaymentDeduction, amount);
                    continue;
                }
                paymentData = new EmployeePaymentDataBean();
                if (isSammelueberweisung) {
                    hashMap.put(sammelueberweisungKey, paymentData);
                    paymentData.setIsSammelueberweisung(true);
                }
                paymentData.setVerwendungszweck((String)reasonfortransfer);
                paymentData.setEmpfaenger(recipientName);
                paymentData.addEEPaymentDeduction(eePaymentDeduction, amount);
                paymentData.setKontonummer(ReportHelper.toIbanFormat((String)iban));
                if (bankTPcontainer != null) {
                    paymentData.setBlz(bankTPcontainer.biccode);
                    paymentData.setBankbezeichnung(bankTPcontainer.shortdescription);
                    paymentData.setBankKey(bankTPcontainer.bankcodenumber + accountNumber);
                }
                paymentData.setBank(this.mBank);
                if (isSammelueberweisung) {
                    paymentData.setPersonalnummer("");
                    paymentData.setPersonalnummerForSort((String)pCompanyKey + ReportHelper.changeToCompare((String)"0") + recipientName);
                } else {
                    paymentData.setName(payDeductionContainer.surname + ", " + payDeductionContainer.firstname);
                    paymentData.setPersonalnummer((String)personnelNumber);
                    paymentData.setPersonalnummerForSort((String)pCompanyKey + ReportHelper.changeToCompare((String)personnelNumber));
                }
                paymentData.setZahlungsgruppe("Zahlungen an Dritte");
                paymentData.setZahlungsart(this.getZahlungsart(modeofpayment));
                paymentData.setZahlungsartKey(modeofpayment.value());
                if (!useCompanyAccount && modeofpayment.value() < 2) {
                    paymentData.setZahlungsart("Bar");
                    paymentData.setZahlungsartKey(2);
                }
                paymentData.setBankKey(kontoKey);
                paymentData.setReferenceNumber(Integer.toString(++referenceNumber));
                paymentData.setTypeOfBankTransfer(TypeOfBankTransferEnum.TOBTE_SEPA);
                paymentData.setModeOfDeduction(ModeOfDeductionEnum.from_int((int)payDeductionContainer.modeofdeduction));
                if (bankTPcontainer != null) {
                    paymentData.setBIC(bankTPcontainer.biccode);
                    paymentData.setBankSortingCode(bankTPcontainer.bankcodenumber);
                }
                paymentData.setIBAN(iban);
                paymentData.setPostalAddress(address);
                paymentData.setBankAccountNumber(accountNumber);
                paymentData.setModeOfPayment(modeofpayment);
                paymentData.setUseCompanyAccount(useCompanyAccount);
                if (!isSammelueberweisung) {
                    paymentData.setOidEmployee(payDeductionContainer.oidemployee);
                }
                paymentData.setOidRecipient(payDeductionContainer.oidrecipient);
                if (isSammelueberweisung) continue;
                employeePaymentDataBeans.add(paymentData);
            }
            ArrayList sammelueberweisungen = new ArrayList(hashMap.values());
            Collections.sort(sammelueberweisungen, new SammelueberweisungComparator());
            employeePaymentDataBeans.addAll(0, sammelueberweisungen);
        }
        LinkedList<PayrollPayment> paymentList = new LinkedList<PayrollPayment>();
        for (EmployeePaymentDataBean employeePaymentDataBean : employeePaymentDataBeans) {
            if (BigDecimalMapper.compareTo((BigDecimal)employeePaymentDataBean.getBetrag_value(), (BigDecimal)ZERO) <= 0 || employeePaymentDataBean.getModeOfPayment() != ModeOfPaymentEnum.MOPE_Ueberweisung && employeePaymentDataBean.getModeOfPayment() != ModeOfPaymentEnum.MOPE_Scheck || !employeePaymentDataBean.getUseCompanyAccount()) continue;
            PayrollPayment payment = this.createPayrollPayment(session, employeePaymentDataBean);
            this.addPayment(this.mForValidDate, paymentList, payment, StringMapper.isNullString((String)employeePaymentDataBean.getOidEmployee()) ? null : this.getIEmployeePM().getEmployee(employeePaymentDataBean.getOidEmployee()), StringMapper.isNullString((String)employeePaymentDataBean.getOidRecipient()) ? null : Recipient.getRecipient((String)employeePaymentDataBean.getOidRecipient()), EmployeePaymentType.vwl, null, employeePaymentDataBean.getEEPaymentDeductions());
        }
        this.mEmployeePaymentDataBeans.addAll(employeePaymentDataBeans);
        return paymentList;
    }

    private PayrollPayment createPayrollPayment(PayrollPaymentSession session, EmployeePaymentDataBean paymentData) throws BusinessDomainException {
        PayrollPayment payment = new PayrollPayment(session);
        payment.setAbsenderCode(paymentData.getPersonalnummer());
        payment.setAbsenderBezeichnung(paymentData.getName());
        payment.setBankName(paymentData.getBankbezeichnung());
        payment.setPaymentNote(paymentData.getVerwendungszweck());
        payment.setNominalAccount(this.mNlAccountCompanySetting);
        payment.setDocumentDate(DateHelper.today());
        payment.setPaymentTransactionCode(this.mPaymentTransactionCode);
        payment.setReferenceNumber(paymentData.getReferenceNumber());
        payment.setAmount(paymentData.getBetrag_value());
        payment.setForcedPayment(false);
        payment.setStop(false);
        payment.setShortAddressOwner(paymentData.getIBAN());
        payment.setBankAccountNumber(paymentData.getBankAccountNumber());
        payment.setBankSortingCode(paymentData.getBankSortingCode());
        payment.setBIC(paymentData.getBIC());
        payment.setPostalAddress((IPostalAddress)paymentData.getPostalAddress());
        switch (paymentData.getZahlungsartKey()) {
            case 0: {
                payment.setTypeOfPayment(ModeOfPayment.DIRECT_DEBIT);
                break;
            }
            case 1: {
                payment.setTypeOfPayment(ModeOfPayment.CHECK);
                break;
            }
            default: {
                this.addError(paymentData.getPersonalnummer(), paymentData.getName() + NO_TYPE_OF_PAYMENT_FOR_EMPLOYEE);
            }
        }
        if (paymentData.getModeOfDeduction() != ModeOfDeductionEnum.MODE_Sonstige) {
            payment.setPaymentTransactionType(PaymentTransactionTypeEnum.PTTE_WEALTHCREATION);
            payment.setPaymentTransactionCode(DateMapper.toDDMMYYYYPointSeparationString((Date)this.mForValidDate).substring(9, 10));
        } else {
            payment.setPaymentTransactionType(PaymentTransactionTypeEnum.PTTE_BACS);
            payment.setPaymentTransactionCode("");
            payment.setModeOfDeduction(paymentData.getModeOfDeduction());
        }
        return payment;
    }

    private List<PayrollPayment> createPensionScheme(String kontoKey, Map<String, List<EepensschemeallContainer>> pensionSchemeHashMap, PayrollPaymentSession session) throws BusinessDomainException {
        List<EepensschemeallContainer> pensionSchemeList;
        LinkedList<PayrollPayment> paymentList = new LinkedList<PayrollPayment>();
        LinkedList<EmployeePaymentDataBean> employeePaymentDataBeans = new LinkedList<EmployeePaymentDataBean>();
        PostalAddress address = new PostalAddress("", "", "", "", "", null, null, (ICountry)CountryPersistencyManager.getCountry((String)"2"));
        String recipient = "";
        int referenceNumber = 300000;
        if (this.mPensionScheme && (pensionSchemeList = pensionSchemeHashMap.get(kontoKey)) != null) {
            for (EepensschemeallContainer pensionSchemeContainer : pensionSchemeList) {
                String city;
                String postalcode;
                String street;
                ModeOfPaymentEnum modeofpayment;
                String iban;
                String accountNumber;
                BanktpContainer bankTPcontainer;
                Date rcDate;
                if (pensionSchemeContainer == null) continue;
                boolean companyAccount = StringMapper.compareTo((String)pensionSchemeContainer.oidcompanyaccount, (String)"") != 0 || this.mStandardBankAccount != null;
                BigDecimal amount = this.getPensionSchemeVP(pensionSchemeContainer.oidemployee, this.mForEffectiveDate, this.mForValidDate, pensionSchemeContainer.oideepensscheme);
                if (pensionSchemeContainer.revaluation && (rcDate = this.mCalculationbasicHashMap.get(pensionSchemeContainer.oidemployee)) != null) {
                    amount = amount.add(this.getReturnCalculationPensionScheme(pensionSchemeContainer.objectidroot, rcDate));
                }
                String pCompanyKey = this.mIsSuperiorForConsolidation ? this.mReportValues.getPCompanyKey(pensionSchemeContainer.oidpcompany) + "/" : "";
                String personnelNumber = pCompanyKey + Integer.toString(pensionSchemeContainer.personnelnumber);
                String personnelNumberForSort = pCompanyKey + ReportHelper.changeToCompare((String)Integer.toString(pensionSchemeContainer.personnelnumber));
                if (amount == null || BigDecimalMapper.compareTo((BigDecimal)amount, (BigDecimal)ZERO) <= 0) continue;
                String reasonfortransfer = this.mPensionSchemeReasonForTransfer.getReasonForTransfer(pensionSchemeContainer);
                if (!StringMapper.isNullString((String)pensionSchemeContainer.oidrecipient)) {
                    RecipientallContainer recipientContainer = this.mRecipientHashMap.get(pensionSchemeContainer.oidrecipient);
                    bankTPcontainer = this.mBankHashMap.get(recipientContainer.oidbank);
                    accountNumber = recipientContainer.accountnumber;
                    iban = recipientContainer.iban;
                    modeofpayment = ModeOfPaymentEnum.from_int((int)recipientContainer.modeofpayment);
                    if (StringMapper.isNullString((String)recipientContainer.longdescription) && pensionSchemeContainer.modeofpayment < 2) {
                        this.addError(personnelNumber, pensionSchemeContainer.surname + ", " + pensionSchemeContainer.firstname + " Keine Empf\u00e4nger bei Abz\u00fcge zur BAV");
                    } else {
                        recipient = recipientContainer.longdescription;
                    }
                    street = recipientContainer.street;
                    postalcode = recipientContainer.postalcode;
                    city = recipientContainer.city;
                    address = new PostalAddress(recipientContainer.longdescription, street, postalcode, city, "", null, null, (ICountry)CountryPersistencyManager.getCountryByCodeWithCache((String)"DE"));
                } else {
                    bankTPcontainer = this.mBankHashMap.get(pensionSchemeContainer.oidbank);
                    accountNumber = pensionSchemeContainer.accountnumber;
                    iban = pensionSchemeContainer.iban;
                    modeofpayment = ModeOfPaymentEnum.from_int((int)pensionSchemeContainer.modeofpayment);
                    if (StringMapper.isNullString((String)pensionSchemeContainer.nameofrecipient) && pensionSchemeContainer.modeofpayment < 2) {
                        this.addError(personnelNumber, pensionSchemeContainer.surname + ", " + pensionSchemeContainer.firstname + " Keine Empf\u00e4nger bei Abz\u00fcge zur BAV: ");
                    } else {
                        recipient = pensionSchemeContainer.nameofrecipient;
                    }
                    street = pensionSchemeContainer.street;
                    postalcode = pensionSchemeContainer.postalcode;
                    city = pensionSchemeContainer.city;
                    address = new PostalAddress(pensionSchemeContainer.nameofrecipient, street, postalcode, city, "", null, null, (ICountry)CountryPersistencyManager.getCountryByCodeWithCache((String)"DE"));
                }
                if (bankTPcontainer != null) {
                    modeofpayment = this.getModeOfPayment(modeofpayment, bankTPcontainer.biccode, iban, bankTPcontainer.bankcodenumber, pensionSchemeContainer.surname + ", " + pensionSchemeContainer.firstname, "Abz\u00fcge zur BAV");
                }
                EmployeePaymentDataBean paymentData = new EmployeePaymentDataBean();
                paymentData.setVerwendungszweck(reasonfortransfer);
                paymentData.setEmpfaenger(recipient);
                paymentData.setBetrag(amount);
                paymentData.setKontonummer(ReportHelper.toIbanFormat((String)iban));
                if (bankTPcontainer != null) {
                    paymentData.setBlz(bankTPcontainer.biccode);
                    paymentData.setBankbezeichnung(bankTPcontainer.shortdescription);
                    paymentData.setBankKey(bankTPcontainer.bankcodenumber + accountNumber);
                }
                paymentData.setBank(this.mBank);
                paymentData.setName(pensionSchemeContainer.surname + ", " + pensionSchemeContainer.firstname);
                paymentData.setPersonalnummer(personnelNumber);
                paymentData.setPersonalnummerForSort(personnelNumberForSort);
                paymentData.setZahlungsgruppe("Zahlungen BAV");
                paymentData.setZahlungsart(this.getZahlungsart(modeofpayment));
                paymentData.setZahlungsartKey(modeofpayment.value());
                if (!companyAccount && modeofpayment.value() < 2) {
                    paymentData.setZahlungsart("Bar");
                    paymentData.setZahlungsartKey(2);
                }
                paymentData.setBankKey(kontoKey);
                employeePaymentDataBeans.add(paymentData);
                if (BigDecimalMapper.compareTo((BigDecimal)amount, (BigDecimal)ZERO) <= 0 || modeofpayment.value() >= 2 || !companyAccount) continue;
                PayrollPayment payment = new PayrollPayment(session);
                payment.setAbsenderCode(paymentData.getPersonalnummer());
                payment.setAbsenderBezeichnung(paymentData.getName());
                payment.setPaymentNote(reasonfortransfer);
                payment.setNominalAccount(this.mNlAccountCompanySetting);
                payment.setDocumentDate(DateHelper.today());
                payment.setPaymentTransactionCode(this.mPaymentTransactionCode);
                payment.setReferenceNumber(Integer.toString(++referenceNumber));
                payment.setAmount(amount);
                payment.setForcedPayment(false);
                payment.setStop(false);
                payment.setShortAddressOwner(iban);
                payment.setBankAccountNumber(accountNumber);
                if (bankTPcontainer != null) {
                    payment.setBankName(bankTPcontainer.shortdescription);
                    payment.setBankSortingCode(bankTPcontainer.bankcodenumber);
                    payment.setBIC(bankTPcontainer.biccode);
                }
                payment.setPostalAddress((IPostalAddress)address);
                switch (modeofpayment.value()) {
                    case 0: {
                        payment.setTypeOfPayment(ModeOfPayment.DIRECT_DEBIT);
                        break;
                    }
                    case 1: {
                        payment.setTypeOfPayment(ModeOfPayment.CHECK);
                        break;
                    }
                    default: {
                        this.addError(personnelNumber, pensionSchemeContainer.surname + ", " + pensionSchemeContainer.firstname + NO_TYPE_OF_PAYMENT_FOR_EMPLOYEE);
                    }
                }
                payment.setPaymentTransactionType(PaymentTransactionTypeEnum.PTTE_BACS);
                payment.setPaymentTransactionCode(DateMapper.toDDMMYYYYPointSeparationString((Date)this.mForValidDate).substring(9, 10));
                this.addPayment(this.mForValidDate, paymentList, payment, this.getIEmployeePM().getEmployee(pensionSchemeContainer.oidemployee), StringMapper.isNullString((String)pensionSchemeContainer.oidrecipient) ? null : Recipient.getRecipient((String)pensionSchemeContainer.oidrecipient), EmployeePaymentType.bav, null, null);
            }
        }
        employeePaymentDataBeans.sort(new DataComparator());
        this.mEmployeePaymentDataBeans.addAll(employeePaymentDataBeans);
        return paymentList;
    }

    private List<PayrollPayment> createAttachment(String kontoKey, Map<String, List<AttachmentallContainer>> attachmentHashMap, PayrollPaymentSession session) throws BusinessDomainException {
        List<AttachmentallContainer> attachmentList;
        LinkedList<PayrollPayment> paymentList = new LinkedList<PayrollPayment>();
        PostalAddress address = new PostalAddress("", "", "", "", "", null, null, (ICountry)CountryPersistencyManager.getCountry((String)"2"));
        String recipient = "";
        int referenceNumber = 400000;
        if (this.mAttachment && (attachmentList = attachmentHashMap.get(kontoKey)) != null) {
            for (AttachmentallContainer attachmentContainer : attachmentList) {
                String city;
                String postalcode;
                String street;
                Object reasonfortransfer;
                ModeOfPaymentEnum modeofpayment;
                String iban;
                String accountNumber;
                BanktpContainer bankTPcontainer;
                Object personnelNumber;
                Object pCompanyKey;
                if (attachmentContainer == null) continue;
                boolean companyAccount = StringMapper.compareTo((String)attachmentContainer.oidcompanyaccount, (String)"") != 0 || this.mStandardBankAccount != null;
                AttachmentBean attachmentBean = this.mAttachmentHashMap.get(attachmentContainer.objectidroot);
                BigDecimal amount = attachmentBean.getBetrag();
                if (this.mIsSuperiorForConsolidation) {
                    pCompanyKey = this.mReportValues.getPCompanyKey(attachmentContainer.oidpcompany) + "/";
                    personnelNumber = (String)pCompanyKey + Integer.toString(attachmentContainer.personnelnumber);
                } else {
                    pCompanyKey = "";
                    personnelNumber = Integer.toString(attachmentContainer.personnelnumber);
                }
                if (amount == null || BigDecimalMapper.compareTo((BigDecimal)amount, (BigDecimal)ZERO) <= 0) continue;
                if (!StringMapper.isNullString((String)attachmentContainer.oidrecipient)) {
                    RecipientallContainer recipientContainer = this.mRecipientHashMap.get(attachmentContainer.oidrecipient);
                    ComprecipientallContainer compRecipientContainer = this.mCompRecipientHashMap.get(attachmentContainer.oidrecipient);
                    bankTPcontainer = this.mBankHashMap.get(recipientContainer.oidbank);
                    accountNumber = recipientContainer.accountnumber;
                    iban = recipientContainer.iban;
                    modeofpayment = ModeOfPaymentEnum.from_int((int)recipientContainer.modeofpayment);
                    reasonfortransfer = !StringMapper.isNullString((String)attachmentContainer.reasonfortransfer) ? attachmentContainer.reasonfortransfer + " " + this.mmjjjj : (compRecipientContainer != null && !StringMapper.isNullString((String)compRecipientContainer.reasonoftransfer) ? compRecipientContainer.reasonoftransfer + " " + this.mmjjjj : (!StringMapper.isNullString((String)recipientContainer.reasonfortransfer) ? recipientContainer.reasonfortransfer + " " + this.mmjjjj : ""));
                    if (StringMapper.isNullString((String)recipientContainer.longdescription)) {
                        this.addError((String)personnelNumber, attachmentContainer.surname + ", " + attachmentContainer.firstname + "Keine Empf\u00e4nger bei Pf\u00e4ndungen: ");
                    } else {
                        recipient = recipientContainer.longdescription;
                    }
                    street = recipientContainer.street;
                    postalcode = recipientContainer.postalcode;
                    city = recipientContainer.city;
                    address = new PostalAddress(recipientContainer.longdescription, street, postalcode, city, "", null, null, (ICountry)CountryPersistencyManager.getCountryByCodeWithCache((String)"DE"));
                } else {
                    bankTPcontainer = this.mBankHashMap.get(attachmentContainer.oidbank);
                    accountNumber = attachmentContainer.accountnumber;
                    iban = attachmentContainer.iban;
                    modeofpayment = ModeOfPaymentEnum.from_int((int)attachmentContainer.modeofpayment);
                    reasonfortransfer = attachmentContainer.reasonfortransfer + " " + this.mmjjjj;
                    if (StringMapper.isNullString((String)attachmentContainer.recipient)) {
                        this.addError((String)personnelNumber, attachmentContainer.surname + ", " + attachmentContainer.firstname + " Keine Empf\u00e4nger bei Pf\u00e4ndungen: ");
                    } else {
                        recipient = attachmentContainer.recipient;
                    }
                    street = attachmentContainer.street;
                    postalcode = attachmentContainer.postalcode;
                    city = attachmentContainer.city;
                    address = new PostalAddress(attachmentContainer.recipient, street, postalcode, city, "", null, null, (ICountry)CountryPersistencyManager.getCountryByCodeWithCache((String)"DE"));
                }
                if (bankTPcontainer != null) {
                    modeofpayment = this.getModeOfPayment(modeofpayment, bankTPcontainer.biccode, iban, bankTPcontainer.bankcodenumber, attachmentContainer.surname + ", " + attachmentContainer.firstname, "Pf\u00e4ndungen");
                }
                EmployeePaymentDataBean paymentDatas = new EmployeePaymentDataBean();
                paymentDatas.setVerwendungszweck((String)reasonfortransfer);
                paymentDatas.setEmpfaenger(recipient);
                paymentDatas.setBetrag(amount);
                paymentDatas.setKontonummer(iban);
                if (bankTPcontainer != null) {
                    paymentDatas.setBlz(bankTPcontainer.biccode);
                    paymentDatas.setBankbezeichnung(bankTPcontainer.shortdescription);
                    paymentDatas.setBankKey(bankTPcontainer.bankcodenumber + accountNumber);
                }
                paymentDatas.setBank(this.mBank);
                paymentDatas.setName(attachmentContainer.surname + ", " + attachmentContainer.firstname);
                paymentDatas.setPersonalnummer((String)personnelNumber);
                paymentDatas.setPersonalnummerForSort((String)pCompanyKey + ReportHelper.changeToCompare((String)personnelNumber));
                paymentDatas.setZahlungsgruppe("Pf\u00e4ndungen");
                paymentDatas.setZahlungsart(this.getZahlungsart(modeofpayment));
                paymentDatas.setZahlungsartKey(modeofpayment.value());
                if (!companyAccount && modeofpayment.value() < 2) {
                    paymentDatas.setZahlungsart("Bar");
                    paymentDatas.setZahlungsartKey(2);
                }
                paymentDatas.setBankKey(kontoKey);
                this.mEmployeePaymentDataBeans.add(paymentDatas);
                if (BigDecimalMapper.compareTo((BigDecimal)amount, (BigDecimal)ZERO) <= 0 || modeofpayment.value() >= 2 || !companyAccount) continue;
                PayrollPayment payment = new PayrollPayment(session);
                payment.setAbsenderCode(paymentDatas.getPersonalnummer());
                payment.setAbsenderBezeichnung(paymentDatas.getName());
                payment.setPaymentNote((String)reasonfortransfer);
                payment.setNominalAccount(this.mNlAccountCompanySetting);
                payment.setDocumentDate(DateHelper.today());
                payment.setPaymentTransactionCode(this.mPaymentTransactionCode);
                payment.setReferenceNumber(Integer.toString(++referenceNumber));
                payment.setAmount(amount);
                payment.setForcedPayment(false);
                payment.setStop(false);
                payment.setShortAddressOwner(iban);
                payment.setBankAccountNumber(accountNumber);
                if (bankTPcontainer != null) {
                    payment.setBankName(bankTPcontainer.shortdescription);
                    payment.setBankSortingCode(bankTPcontainer.bankcodenumber);
                    payment.setBIC(bankTPcontainer.biccode);
                }
                payment.setPostalAddress((IPostalAddress)address);
                switch (modeofpayment.value()) {
                    case 0: {
                        payment.setTypeOfPayment(ModeOfPayment.DIRECT_DEBIT);
                        break;
                    }
                    case 1: {
                        payment.setTypeOfPayment(ModeOfPayment.CHECK);
                        break;
                    }
                    default: {
                        this.addError((String)personnelNumber, attachmentContainer.surname + ", " + attachmentContainer.firstname + NO_TYPE_OF_PAYMENT_FOR_EMPLOYEE);
                    }
                }
                payment.setPaymentTransactionType(PaymentTransactionTypeEnum.PTTE_BACS);
                payment.setPaymentTransactionCode("");
                this.addPayment(this.mForValidDate, paymentList, payment, this.getIEmployeePM().getEmployee(attachmentContainer.oidemployee), StringMapper.isNullString((String)attachmentContainer.oidrecipient) ? null : Recipient.getRecipient((String)attachmentContainer.oidrecipient), EmployeePaymentType.pfaendung, null, null);
            }
        }
        return paymentList;
    }

    private void getPaymentLists(Iterator<String> paymentIterator) throws BusinessDomainException {
        LinkedList<List<EmployeePaymentDataBean>> paymentList = new LinkedList<List<EmployeePaymentDataBean>>();
        while (paymentIterator.hasNext()) {
            String temp = paymentIterator.next();
            this.FIELD_HAUSBANK = this.mHomeBankHashMap.get(temp);
            Map<String, List<EmployeePaymentDataBean>> tempDetailHashMap = this.mTempAllHashMap.get(temp);
            if (tempDetailHashMap == null) continue;
            this.FIELD_WAGEDATAS = null;
            BigDecimal summe_dta = ZERO;
            BigDecimal summe_bar = ZERO;
            BigDecimal summe_scheck = ZERO;
            BigDecimal summe_einzug = ZERO;
            BigDecimal summe_gesamt = ZERO;
            List<EmployeePaymentDataBean> tempDetailList = null;
            int i = 0;
            while (i < 5) {
                switch (i) {
                    case 0: {
                        tempDetailList = tempDetailHashMap.get("Lohn / Gehalt");
                        break;
                    }
                    case 1: {
                        tempDetailList = tempDetailHashMap.get("Zahlungen an Dritte");
                        break;
                    }
                    case 2: {
                        tempDetailList = tempDetailHashMap.get("Zahlungen BAV");
                        break;
                    }
                    case 3: {
                        tempDetailList = tempDetailHashMap.get("Pf\u00e4ndungen");
                        break;
                    }
                    case 4: {
                        tempDetailList = tempDetailHashMap.get("\u00dcberzahlungen");
                    }
                }
                ++i;
                if (tempDetailList == null) continue;
                paymentList.add(tempDetailList);
                Collections.sort(tempDetailList, new DataComparator());
                EmployeePaymentDataBean tempDatas = new EmployeePaymentDataBean();
                for (EmployeePaymentDataBean datas : tempDetailList) {
                    BigDecimal tempBetrag;
                    if (datas.getZahlungsartKey() == 0) {
                        tempBetrag = datas.getBetrag_value().add(tempDatas.getSumme_DTA_value());
                        datas.setSumme_dta(tempBetrag);
                        datas.setSumme_scheck(tempDatas.getSumme_Scheck_value());
                        datas.setSumme_bar(tempDatas.getSumme_Bar_value());
                        datas.setSumme_einzug(tempDatas.getSumme_Einzug_value());
                        tempBetrag = tempDatas.getSumme_Gesamt_value().add(datas.getBetrag_value());
                        datas.setSumme_gesamt(tempBetrag);
                    }
                    if (datas.getZahlungsartKey() == 1) {
                        tempBetrag = datas.getBetrag_value().add(tempDatas.getSumme_Scheck_value());
                        datas.setSumme_scheck(tempBetrag);
                        datas.setSumme_dta(tempDatas.getSumme_DTA_value());
                        datas.setSumme_bar(tempDatas.getSumme_Bar_value());
                        datas.setSumme_einzug(tempDatas.getSumme_Einzug_value());
                        tempBetrag = tempDatas.getSumme_Gesamt_value().add(datas.getBetrag_value());
                        datas.setSumme_gesamt(tempBetrag);
                    }
                    if (datas.getZahlungsartKey() == 2) {
                        tempBetrag = datas.getBetrag_value().add(tempDatas.getSumme_Bar_value());
                        datas.setSumme_bar(tempBetrag);
                        datas.setSumme_scheck(tempDatas.getSumme_Scheck_value());
                        datas.setSumme_dta(tempDatas.getSumme_DTA_value());
                        datas.setSumme_einzug(tempDatas.getSumme_Einzug_value());
                        tempBetrag = tempDatas.getSumme_Gesamt_value().add(datas.getBetrag_value());
                        datas.setSumme_gesamt(tempBetrag);
                    }
                    if (datas.getZahlungsartKey() == 3) {
                        tempBetrag = datas.getBetrag_value().add(tempDatas.getSumme_Einzug_value());
                        datas.setSumme_einzug(tempBetrag);
                        datas.setSumme_scheck(tempDatas.getSumme_Scheck_value());
                        datas.setSumme_bar(tempDatas.getSumme_Bar_value());
                        datas.setSumme_dta(tempDatas.getSumme_DTA_value());
                        tempBetrag = tempDatas.getSumme_Gesamt_value().add(datas.getBetrag_value());
                        datas.setSumme_gesamt(tempBetrag);
                    }
                    tempDatas = datas;
                }
                summe_dta = summe_dta.add(tempDatas.getSumme_DTA_value());
                summe_scheck = summe_scheck.add(tempDatas.getSumme_Scheck_value());
                summe_bar = summe_bar.add(tempDatas.getSumme_Bar_value());
                summe_einzug = summe_einzug.add(tempDatas.getSumme_Einzug_value());
                summe_gesamt = summe_gesamt.add(tempDatas.getSumme_Gesamt_value());
            }
            AccountSums sums = new AccountSums(summe_dta, summe_scheck, summe_bar, summe_einzug, summe_gesamt);
            this.mAccountSumsHashMap.put(temp, sums);
        }
        if (paymentList.isEmpty()) {
            throw PaymentExceptionMapper.makeNoPaymentDatasException();
        }
        this.mPaymentIterator = paymentList.iterator();
    }

    public boolean next() throws JRException {
        boolean next;
        try {
            if (this.mPaymentIterator.hasNext()) {
                List<EmployeePaymentDataBean> tempList = this.mPaymentIterator.next();
                EmployeePaymentDataBean paymentdatas = tempList.get(0);
                AccountSums sums = this.mAccountSumsHashMap.get(paymentdatas.getBankKey());
                this.FIELD_WAGEDATAS = tempList;
                this.FIELD_HAUSBANK = this.mHomeBankHashMap.get(paymentdatas.getBankKey());
                this.FIELD_SUMME_DTA = sums.getSumme_dta();
                this.FIELD_SUMME_SCHECK = sums.getSumme_scheck();
                this.FIELD_SUMME_BAR = sums.getSumme_bar();
                this.FIELD_SUMME_EINZUG = sums.getSumme_einzug();
                this.FIELD_SUMME_GESAMT = sums.getSumme_gesamt();
                next = true;
            } else {
                next = false;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
        return next;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        String fieldName = field.getName();
        if (fieldName.equals("monat")) {
            value = this.FIELD_MONAT;
        }
        if (fieldName.equals("firma_nr")) {
            value = this.FIELD_FIRMA_NR;
        }
        if (fieldName.equals("firma_bezeichnung")) {
            value = this.FIELD_FIRMA_BEZEICHNUNG;
        }
        if (fieldName.equals("user")) {
            value = this.FIELD_USER;
        }
        if (fieldName.equals("date")) {
            value = this.FIELD_DATE;
        }
        if (fieldName.equals("release")) {
            value = this.FIELD_RELEASE;
        }
        if (fieldName.equals("personalnummer")) {
            value = this.FIELD_PERSONALNUMMER;
        }
        if (fieldName.equals("name")) {
            value = this.FIELD_NAME;
        }
        if (fieldName.equals("blz")) {
            value = this.FIELD_BLZ;
        }
        if (fieldName.equals("bankbezeichnung")) {
            value = this.FIELD_BANKBEZEICHNUNG;
        }
        if (fieldName.equals("kontonummer")) {
            value = this.FIELD_KONTONUMMER;
        }
        if (fieldName.equals("verwendungszweck")) {
            value = this.FIELD_VERWENDUNGSZWECK;
        }
        if (fieldName.equals("empfaenger")) {
            value = this.FIELD_EMPFAENGER;
        }
        if (fieldName.equals("zahlungsart")) {
            value = this.FIELD_ZAHLUNGSART;
        }
        if (fieldName.equals("betrag")) {
            value = this.FIELD_BETRAG;
        }
        if (fieldName.equals("summe_dta")) {
            value = this.FIELD_SUMME_DTA;
        }
        if (fieldName.equals("summe_bar")) {
            value = this.FIELD_SUMME_BAR;
        }
        if (fieldName.equals("summe_scheck")) {
            value = this.FIELD_SUMME_SCHECK;
        }
        if (fieldName.equals("summe_einzug")) {
            value = this.FIELD_SUMME_EINZUG;
        }
        if (fieldName.equals("summe_gesamt")) {
            value = this.FIELD_SUMME_GESAMT;
        }
        if (fieldName.equals("hausbank")) {
            value = this.FIELD_HAUSBANK;
        }
        if (fieldName.equals("wagedatas")) {
            value = this.FIELD_WAGEDATAS;
        }
        if (fieldName.equals("errordatas")) {
            value = this.FIELD_ERRORDATAS;
        }
        if (value instanceof String) {
            value = StringUtil.toJasperString((String)((String)value));
        }
        return value;
    }

    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        return parameters;
    }

    private Map<String, IBankAccount> getCompanyAccounts() throws BusinessDomainException {
        IBankAccount[] bankAccounts;
        HashMap<String, IBankAccount> compBankHashMap = new HashMap<String, IBankAccount>();
        try {
            bankAccounts = PayrollPaymentBank.getAllBankAccountsOfCompany((String)this.mCompanyForSettings.getObjectid(), (Date)this.mForValidDate);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (bankAccounts.length == 0) {
            throw PaymentExceptionMapper.makeNoBankAccountForCompanyException();
        }
        for (IBankAccount bankAccount : bankAccounts) {
            if (bankAccount == null) continue;
            compBankHashMap.put(bankAccount.getBankSortingCode() + bankAccount.getObjectid(), bankAccount);
        }
        return compBankHashMap;
    }

    private Map<String, List<EmployeePaymentBean>> createEmployeePaymentBeans() {
        HashMap<String, List<EmployeePaymentBean>> employeePaymentBeanMap = new HashMap<String, List<EmployeePaymentBean>>();
        for (MasterallContainer masterallContainer : this.mMasterallContainerList) {
            BigDecimal netPay;
            if (masterallContainer == null) continue;
            ValuepositionContainer vpContainer = this.mValuePositionHashMap.get(masterallContainer.oidemployee);
            BigDecimal bigDecimal = netPay = vpContainer != null ? vpContainer.results : BigDecimal.ZERO;
            List<EebankdetailsallContainer> eebankdetailsallList = this.mEEBankDetailsAllHashMap.get(masterallContainer.oidemployee);
            if (eebankdetailsallList == null) continue;
            if (eebankdetailsallList.size() > 1) {
                Collections.sort(eebankdetailsallList, new EebankdetailsallContainerComparator());
            }
            BigDecimal tempNetPay = netPay;
            for (EebankdetailsallContainer eeBankcontainer : eebankdetailsallList) {
                BanktpContainer bankTPcontainer;
                if (eeBankcontainer == null || !(this.mSalary && eeBankcontainer.forsalary || this.mAdvancePayment && eeBankcontainer.foranticipation || this.mAnticipationPayment && eeBankcontainer.foranticipation) && eeBankcontainer.rankingnumber != 99) continue;
                netPay = tempNetPay;
                if (eeBankcontainer.rankingnumber != 99 || !BigDecimalMapper.isZero((BigDecimal)netPay)) {
                    netPay = this.generateNetPay(netPay, eeBankcontainer);
                    if (eeBankcontainer.deductionfromnet) {
                        tempNetPay = tempNetPay.subtract(netPay);
                    }
                }
                String biccode = "";
                String bankcodenumber = "";
                String shortdescription = "";
                if (eeBankcontainer.oidbank != null && (bankTPcontainer = this.mBankHashMap.get(eeBankcontainer.oidbank)) != null) {
                    biccode = StringMapper.isNullString((String)bankTPcontainer.biccode) ? this.getBicCodeByBankcodenumber(bankTPcontainer.bankcodenumber) : bankTPcontainer.biccode;
                    bankcodenumber = bankTPcontainer.bankcodenumber;
                    shortdescription = bankTPcontainer.shortdescription;
                }
                if (BigDecimalMapper.isZero((BigDecimal)netPay)) continue;
                LinkedList<EmployeePaymentBean> employeePaymentBeanList = (LinkedList<EmployeePaymentBean>)employeePaymentBeanMap.get(masterallContainer.oidemployee);
                if (employeePaymentBeanList == null) {
                    employeePaymentBeanList = new LinkedList<EmployeePaymentBean>();
                    employeePaymentBeanMap.put(masterallContainer.oidemployee, employeePaymentBeanList);
                }
                employeePaymentBeanList.add(new EmployeePaymentBean(masterallContainer.oidemployee, masterallContainer.personnelnumber, masterallContainer.surname, masterallContainer.firstname, masterallContainer.street, masterallContainer.streetnumber, masterallContainer.postalcode, masterallContainer.domicile, eeBankcontainer.oidcompanyaccount, biccode, bankcodenumber, shortdescription, eeBankcontainer.accountnumber, eeBankcontainer.ownerofaccount, eeBankcontainer.iban, eeBankcontainer.reasonfortransfer, ModeOfPaymentEnum.from_int((int)eeBankcontainer.modeofpayment), eeBankcontainer.rankingnumber, netPay, eeBankcontainer.repetitionofname, masterallContainer.oidpcompany, this.getValueTypeNumber(eeBankcontainer.oidvtretentionnpay)));
            }
        }
        return employeePaymentBeanMap;
    }

    private Integer getValueTypeNumber(String oidValueType) {
        Integer valueTypeNumber = null;
        if (!StringMapper.isNullString((String)oidValueType) && (valueTypeNumber = this.mValueTypeMap.get(oidValueType)) == null) {
            valueTypeNumber = ValueType.getValueType((String)oidValueType).getValueTypeKey();
        }
        return valueTypeNumber;
    }

    private BigDecimal generateNetPay(BigDecimal tempNetPay, EebankdetailsallContainer eeBankcontainer) {
        BigDecimal netPay = tempNetPay;
        TruncationEnum trunc = TruncationEnumMapper.toTruncationEnum((int)eeBankcontainer.truncation);
        TruncationScaleEnum scale = TruncationScaleEnumMapper.toTruncationScaleEnum((int)eeBankcontainer.truncationscale);
        if (trunc == TruncationEnum.TE_noRounding) {
            trunc = TruncationEnum.TE_commercializeRounding;
            scale = TruncationScaleEnum.TSE_2_ADP;
        }
        Truncation truncation = new Truncation(trunc, scale);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)eeBankcontainer.retentionpercntpay)) {
            netPay = netPay.divide(BigDecimal.valueOf(100L));
            netPay = netPay.multiply(eeBankcontainer.retentionpercntpay);
            netPay = truncation.round(netPay);
        }
        if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)eeBankcontainer.retentionamtntpay) || BigDecimalMapper.compareTo((BigDecimal)netPay, (BigDecimal)eeBankcontainer.retentionamtntpay) <= 0 && eeBankcontainer.deductionfromnet)) {
            netPay = eeBankcontainer.retentionamtntpay;
            netPay = truncation.round(netPay);
        }
        if (!StringMapper.isNullString((String)eeBankcontainer.oidvtretentionnpay)) {
            BigDecimal result = this.getResultByOidVT(eeBankcontainer.oidemployee, eeBankcontainer.oidvtretentionnpay, eeBankcontainer.includedretroactiv);
            if (eeBankcontainer.deductionfromnet && BigDecimalMapper.compareTo((BigDecimal)netPay, (BigDecimal)result) > 0 || !eeBankcontainer.deductionfromnet) {
                netPay = result;
                netPay = truncation.round(netPay);
            }
        }
        return netPay;
    }

    private BigDecimal getResultByOidVT(String oidEmployee, String oidVT, boolean withRC) {
        Date rcDate;
        BigDecimal result = this.getValuePositionByVT(oidEmployee, oidVT);
        if (withRC && (rcDate = this.mCalculationbasicHashMap.get(oidEmployee)) != null) {
            while (DateHelper.before((Date)rcDate, (Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))) {
                result = result.subtract(this.getReturnCalculationDatasOld(oidEmployee, oidVT, rcDate));
                result = result.add(this.getReturnCalculationDatasNew(oidEmployee, oidVT, rcDate));
                rcDate = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)rcDate));
            }
        }
        return result;
    }

    private BigDecimal getValuePositionByVT(String oidEmployee, String oidVT) {
        try {
            PersistencyDataSet valuepositionDatas = this.daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"oidvaluetype", (String)oidVT)}));
            BigDecimal result = BigDecimal.ZERO;
            if (valuepositionDatas != null) {
                while (valuepositionDatas.hasNext()) {
                    ValuepositionContainer container = (ValuepositionContainer)valuepositionDatas.getNext();
                    if (container == null) continue;
                    result = result.add(container.results);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private Map<String, List<EmployeePaymentBean>> getSortBankAccounts() throws BusinessDomainException {
        List<EmployeePaymentBean> eeBankList = new LinkedList();
        HashMap<String, List<EmployeePaymentBean>> eeBankHashMap = new HashMap<String, List<EmployeePaymentBean>>();
        Map<String, List<EmployeePaymentBean>> paymentBeanHashMap = this.createEmployeePaymentBeans();
        for (MasterallContainer masterallContainer : this.mMasterallContainerList) {
            Object personnelNumber;
            Object pCompanyKey;
            if (this.mIsSuperiorForConsolidation) {
                pCompanyKey = this.mReportValues.getPCompanyKey(masterallContainer.oidpcompany) + "/";
                personnelNumber = (String)pCompanyKey + Integer.toString(masterallContainer.personnelnumber);
            } else {
                pCompanyKey = "";
                personnelNumber = Integer.toString(masterallContainer.personnelnumber);
            }
            List<EmployeePaymentBean> eeBankdetailList = paymentBeanHashMap.get(masterallContainer.oidemployee);
            if (eeBankdetailList == null) {
                BigDecimal netPay;
                ValuepositionContainer vpContainer = this.mValuePositionHashMap.get(masterallContainer.oidemployee);
                BigDecimal bigDecimal = netPay = vpContainer != null ? vpContainer.results : BigDecimal.ZERO;
                if ((this.mAnticipationPayment || this.mAdvancePayment || this.mSalary) && !BigDecimalMapper.isZeroOrNull((BigDecimal)netPay)) {
                    this.addError((String)personnelNumber, masterallContainer.surname + ", " + masterallContainer.firstname + " - Keine Bankverbindung - Mitarbeiter wurde bei den \u00dcberweisungen nicht ber\u00fccksichtigt!");
                }
                eeBankList = (List)eeBankHashMap.get(_18TIMES9);
                this.mBankKeySet.add(_18TIMES9);
                if (eeBankList == null) {
                    eeBankList = new LinkedList();
                    eeBankHashMap.put(_18TIMES9, eeBankList);
                }
                eeBankList.add(new EmployeePaymentBean(masterallContainer.oidemployee, masterallContainer.personnelnumber, masterallContainer.surname, masterallContainer.firstname, masterallContainer.street, masterallContainer.streetnumber, masterallContainer.postalcode, masterallContainer.domicile, "", "", "", "", "", "", "", "", ModeOfPaymentEnum.MOPE_Barzahlung, 0, netPay, false, masterallContainer.oidpcompany, null));
                continue;
            }
            for (EmployeePaymentBean employeePaymentBean : eeBankdetailList) {
                BanktpContainer bankTPcontainer;
                CompanyaccountContainer companyAccountContainer = this.mCompanyAccountHashMap.get(employeePaymentBean.getOidcompanyaccount());
                BanktpContainer banktpContainer = bankTPcontainer = companyAccountContainer == null ? null : this.mBankHashMap.get(companyAccountContainer.oidbank);
                if (bankTPcontainer != null) {
                    eeBankList = (List)eeBankHashMap.get(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid());
                    this.mBankKeySet.add(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid());
                    if (eeBankList == null) {
                        eeBankList = new LinkedList();
                        eeBankHashMap.put(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid(), eeBankList);
                    }
                    eeBankList.add(employeePaymentBean);
                    continue;
                }
                if (employeePaymentBean.getModeofpayment().value() < 2) {
                    if (this.mStandardBankAccount != null) {
                        companyAccountContainer = this.mCompanyAccountHashMap.get(this.mStandardBankAccount);
                        bankTPcontainer = this.mBankHashMap.get(companyAccountContainer.oidbank);
                        if (bankTPcontainer == null) continue;
                        eeBankList = (List)eeBankHashMap.get(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid());
                        this.mBankKeySet.add(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid());
                        if (eeBankList == null) {
                            eeBankList = new LinkedList();
                            eeBankHashMap.put(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid(), eeBankList);
                        }
                        eeBankList.add(employeePaymentBean);
                        continue;
                    }
                    this.addError((String)personnelNumber, masterallContainer.surname + ", " + masterallContainer.firstname + " - Kein Firmenbankkonto zugewiesen - Mitarbeiter wurde bei den \u00dcberweisungen nicht ber\u00fccksichtigt!");
                    eeBankList = (List)eeBankHashMap.get(_18TIMES9);
                    this.mBankKeySet.add(_18TIMES9);
                    if (eeBankList == null) {
                        eeBankList = new LinkedList();
                        eeBankHashMap.put(_18TIMES9, eeBankList);
                    }
                    eeBankList.add(employeePaymentBean);
                    continue;
                }
                eeBankList = (List)eeBankHashMap.get(_18TIMES9);
                this.mBankKeySet.add(_18TIMES9);
                if (eeBankList == null) {
                    eeBankList = new LinkedList();
                    eeBankHashMap.put(_18TIMES9, eeBankList);
                }
                eeBankList.add(employeePaymentBean);
            }
        }
        return eeBankHashMap;
    }

    private void init_mMasterallContainerList() {
        LinkedList<String> oidList = new LinkedList<String>();
        try {
            for (String oidEmployee : this.mOIDEmployees) {
                if (oidList.size() == 500) {
                    String[] teilStrings = new String[500];
                    oidList.toArray(teilStrings);
                    PersistencyDataSet masterallAllDatas = this.daoMasterall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidemployee", (String[])teilStrings), Restrictions.le((String)"effectiveFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate)))}));
                    while (masterallAllDatas.hasNext()) {
                        MasterallContainer container = (MasterallContainer)masterallAllDatas.getNext();
                        this.mMasterallContainerList.add(container);
                    }
                    oidList.clear();
                }
                oidList.add(oidEmployee);
            }
            String[] teilString = new String[oidList.size()];
            oidList.toArray(teilString);
            PersistencyDataSet masterallAllDatas = this.daoMasterall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidemployee", (String[])teilString), Restrictions.le((String)"effectiveFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate)))}));
            while (masterallAllDatas.hasNext()) {
                MasterallContainer container = (MasterallContainer)masterallAllDatas.getNext();
                this.mMasterallContainerList.add(container);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void init_mValuePositionHashMap() {
        try {
            Conjunction filter = this.mAdvancePayment || this.mAnticipationPayment ? Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.in((String)"valuetypenumber", (String[])this.mValueTypes)}) : Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"valuetypenumber", (String)Integer.toString(890000)), Restrictions.eq((String)"valuetypenumber", (String)Integer.toString(890100))})});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])this.mOIDEmployees);
            for (Criterion inRestriction : inRestrictions) {
                PersistencyDataSet valuepositionDatas = this.daoValueposition.getDataSet(null, Restrictions.and((Criterion)inRestriction, (Criterion)filter));
                while (valuepositionDatas.hasNext()) {
                    ValuepositionContainer tempContainer;
                    ValuepositionContainer container = (ValuepositionContainer)valuepositionDatas.getNext();
                    if (container.valuetypenumber == 890100) {
                        container.results = container.results.negate();
                    }
                    if ((tempContainer = this.mValuePositionHashMap.get(container.oidemployee)) == null) {
                        this.mValuePositionHashMap.put(container.oidemployee, container);
                    } else {
                        tempContainer.results = tempContainer.results.add(container.results);
                    }
                    if (!this.mAdvancePayment && !this.mAnticipationPayment) continue;
                    String paymentNote = this.mPaymentNoteHashMap.get(container.oidemployee);
                    if (StringMapper.isNullString((String)paymentNote)) {
                        paymentNote = container.valuetypenumber == 870110 ? "Abschlag" : "Vorschuss";
                    } else if (container.valuetypenumber == 870110 && StringMapper.equal((String)paymentNote, (String)"Vorschuss") || container.valuetypenumber == 871000 && StringMapper.equal((String)paymentNote, (String)"Abschlag")) {
                        paymentNote = "Abschlag/Vorschu\u00df";
                    }
                    this.mPaymentNoteHashMap.put(container.oidemployee, paymentNote);
                }
            }
            if (this.mAnticipationPayment) {
                this.getAutomaticAnticipationPayments();
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void getAutomaticAnticipationPayments() {
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.eq((String)"genesisparenttype", (String)"5")});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])this.mOIDEmployees);
            for (Criterion inRestriction : inRestrictions) {
                PersistencyDataSet valuepositionDatas = this.daoValueposition.getDataSet(null, Restrictions.and((Criterion)inRestriction, (Criterion)filter));
                while (valuepositionDatas.hasNext()) {
                    AdvancePaymentTP advancePaymentTP;
                    ValuepositionContainer container = (ValuepositionContainer)valuepositionDatas.getNext();
                    if (!this.checkAutomaticAnticipationPayment(container.getObjectid()) || (advancePaymentTP = AdvancePaymentTP.getAdvancePaymentTP((String)container.oidgenesisparent)).isPaid()) continue;
                    ValuepositionContainer tempContainer = this.mValuePositionHashMap.get(container.oidemployee);
                    if (tempContainer == null) {
                        this.mValuePositionHashMap.put(container.oidemployee, container);
                    } else {
                        tempContainer.results = tempContainer.results.add(container.results);
                    }
                    String paymentNote = this.mPaymentNoteHashMap.get(container.oidemployee);
                    if (StringMapper.isNullString((String)paymentNote)) {
                        paymentNote = "Abschlag";
                    } else if (StringMapper.equal((String)paymentNote, (String)"Vorschuss")) {
                        paymentNote = "Abschlag/Vorschu\u00df";
                    }
                    this.mPaymentNoteHashMap.put(container.oidemployee, paymentNote);
                    this.setPaidAndEvaluate(advancePaymentTP);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private boolean checkAutomaticAnticipationPayment(String oidValuePosition) {
        try {
            PersistencyDataSet valuepositionDatas = this.daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"valuetypenumber", (String)"870125"), Restrictions.eq((String)"oidgenesisparent", (String)oidValuePosition)}));
            return valuepositionDatas.hasNext();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void setPaidAndEvaluate(AdvancePaymentTP advancePaymentTP) throws BusinessDomainException {
        advancePaymentTP.makeSaveable();
        advancePaymentTP.setPaid(true);
        AdvancePayment advancePayment = advancePaymentTP.getAdvancePayment();
        Date valuateEffectiveFrom = advancePaymentTP.getEffectiveFrom();
        Date valuateValidFrom = advancePayment.getEmployee().checkAndCorrectValidFromStartOfValuate(advancePaymentTP.getEffectiveFrom(), advancePaymentTP.getValidFrom());
        this.mToValuate.add(new EvaluationBean(advancePayment.getEmployee(), valuateEffectiveFrom, valuateValidFrom, advancePaymentTP.getClassName()));
    }

    private BigDecimal getValuePositionVari(String oidEmployee, String oidValueType, boolean revalution) {
        BigDecimal result = ZERO;
        try {
            Date tempRRDate;
            PersistencyDataSet valuepositionDatas = this.daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.eq((String)"oidvaluetype", (String)oidValueType), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            while (valuepositionDatas.hasNext()) {
                ValuepositionContainer container = (ValuepositionContainer)valuepositionDatas.getNext();
                result = result.add(container.results);
            }
            if (revalution && (tempRRDate = this.mCalculationbasicHashMap.get(oidEmployee)) != null) {
                while (DateHelper.before((Date)tempRRDate, (Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))) {
                    result = result.add(this.getReturnCalculationDatasNew(oidEmployee, oidValueType, tempRRDate));
                    result = result.subtract(this.getReturnCalculationDatasOld(oidEmployee, oidValueType, tempRRDate));
                    tempRRDate = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)tempRRDate));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private BigDecimal getReturnCalculationDatasOld(String oidEmployee, String oidValueType, Date returnCalculationDate) {
        BigDecimal result = BigDecimal.ZERO;
        Date effectiveDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate));
        try {
            PersistencyDataSet rrValuePositionDatas = this.daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)returnCalculationDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)returnCalculationDate))), Restrictions.eq((String)"oidvaluetype", (String)oidValueType)}));
            while (rrValuePositionDatas.hasNext()) {
                ValuepositionContainer container = (ValuepositionContainer)rrValuePositionDatas.getNext();
                result = result.add(container.results);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    private BigDecimal getReturnCalculationDatasNew(String oidEmployee, String oidValueType, Date returnCalculationDate) {
        BigDecimal result = BigDecimal.ZERO;
        try {
            PersistencyDataSet rrValuePositionDatas = this.daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)returnCalculationDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)returnCalculationDate)), Restrictions.eq((String)"oidvaluetype", (String)oidValueType)}));
            while (rrValuePositionDatas.hasNext()) {
                ValuepositionContainer container = (ValuepositionContainer)rrValuePositionDatas.getNext();
                result = result.add(container.results);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    private void init_mBankHashMap() {
        try {
            PersistencyDataSet bankDatas = this.daoBanktp.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth)))}));
            while (bankDatas.hasNext()) {
                BanktpContainer container = (BanktpContainer)bankDatas.getNext();
                this.mBankHashMap.put(container.oidbank, container);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private String getBicCodeByBankcodenumber(String bankcodenumber) {
        try {
            PersistencyDataSet bankDatas = this.daoBanktp.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.eq((String)"bankcodenumber", (String)bankcodenumber)}));
            while (bankDatas.hasNext()) {
                BanktpContainer container = (BanktpContainer)bankDatas.getNext();
                if (StringMapper.isNullString((String)container.biccode)) continue;
                return container.biccode;
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return "";
    }

    private void init_mEEBankDetailsAllHashMap() {
        try {
            PersistencyDataSet eEBankDetailsAllDatas = this.daoEebankdetailsall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.in((String)"oidpcompany", (String[])this.mOidPCompanies)}));
            while (eEBankDetailsAllDatas.hasNext()) {
                EebankdetailsallContainer container = (EebankdetailsallContainer)eEBankDetailsAllDatas.getNext();
                List<EebankdetailsallContainer> eeBankList = this.mEEBankDetailsAllHashMap.get(container.oidemployee);
                if (eeBankList == null) {
                    eeBankList = new LinkedList<EebankdetailsallContainer>();
                    this.mEEBankDetailsAllHashMap.put(container.oidemployee, eeBankList);
                }
                eeBankList.add(container);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void addPayDeductionAllContainer(Map<String, List<PaydeductionallContainer>> payDeductionListHashMap, String key, PaydeductionallContainer payDeductionAllContainer) {
        List<PaydeductionallContainer> list = payDeductionListHashMap.get(key);
        if (list == null) {
            list = new LinkedList<PaydeductionallContainer>();
            payDeductionListHashMap.put(key, list);
            this.mBankKeySet.add(key);
        }
        list.add(payDeductionAllContainer);
    }

    private void addPayDeductionAllContainer(Map<String, List<PaydeductionallContainer>> payDeductionListHashMap, CompanyaccountContainer companyAccountContainer, PaydeductionallContainer payDeductionAllContainer) {
        if (companyAccountContainer != null) {
            BanktpContainer bankTPcontainer = this.mBankHashMap.get(companyAccountContainer.oidbank);
            this.addPayDeductionAllContainer(payDeductionListHashMap, bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid(), payDeductionAllContainer);
        }
    }

    private Map<String, List<PaydeductionallContainer>> getPayDeduction(String[] payDeductionRootOids) {
        HashMap<String, List<PaydeductionallContainer>> payDeductionHashMap = new HashMap<String, List<PaydeductionallContainer>>();
        try {
            if (payDeductionRootOids.length > 0) {
                PersistencyDataSet payDeductionallAllDatas = this.daoPaydeductionall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"objectidroot", (String[])payDeductionRootOids), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth)))}));
                while (payDeductionallAllDatas.hasNext()) {
                    int modeOfPayment;
                    PaydeductionallContainer payDeductionAllContainer = (PaydeductionallContainer)payDeductionallAllDatas.getNext();
                    if (!StringMapper.isNullString((String)payDeductionAllContainer.oidcompanyaccount)) {
                        CompanyaccountContainer companyAccountContainer = this.mCompanyAccountHashMap.get(payDeductionAllContainer.oidcompanyaccount);
                        this.addPayDeductionAllContainer(payDeductionHashMap, companyAccountContainer, payDeductionAllContainer);
                        continue;
                    }
                    int n = modeOfPayment = StringMapper.isNullString((String)payDeductionAllContainer.oidrecipient) ? payDeductionAllContainer.modeofpayment : this.getModeOfPaymentByRecipient(payDeductionAllContainer.oidrecipient);
                    if (modeOfPayment == 0 || modeOfPayment == 1) {
                        if (this.mStandardBankAccount != null) {
                            CompanyaccountContainer companyAccountContainer = this.mCompanyAccountHashMap.get(this.mStandardBankAccount);
                            this.addPayDeductionAllContainer(payDeductionHashMap, companyAccountContainer, payDeductionAllContainer);
                            continue;
                        }
                        this.addErrorKeinFirmenkontoBeiZahlungenAnDritte(payDeductionAllContainer);
                        this.addPayDeductionAllContainer(payDeductionHashMap, _18TIMES9, payDeductionAllContainer);
                        continue;
                    }
                    this.addPayDeductionAllContainer(payDeductionHashMap, _18TIMES9, payDeductionAllContainer);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return payDeductionHashMap;
    }

    private Map<String, List<EepensschemeallContainer>> getEEPensionScheme(String[] oidEmployees) {
        HashMap<String, List<EepensschemeallContainer>> pensionSchemeHashMap = new HashMap<String, List<EepensschemeallContainer>>();
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth)))});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
            for (Criterion inRestriction : inRestrictions) {
                PersistencyDataSet pensionSchemeAllDatas = this.daoEepensschemeall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{inRestriction, filter}));
                while (pensionSchemeAllDatas.hasNext()) {
                    LinkedList<EepensschemeallContainer> tempList;
                    int modeOfPayment;
                    List<EepensschemeallContainer> tempList2;
                    Object personnelNumber;
                    EepensschemeallContainer container = (EepensschemeallContainer)pensionSchemeAllDatas.getNext();
                    if (this.mIsSuperiorForConsolidation) {
                        String pCompanyKey = this.mReportValues.getPCompanyKey(container.oidpcompany);
                        personnelNumber = pCompanyKey + "/" + Integer.toString(container.personnelnumber);
                    } else {
                        personnelNumber = Integer.toString(container.personnelnumber);
                    }
                    if (!StringMapper.isNullString((String)container.oidcompanyaccount)) {
                        CompanyaccountContainer companyAccountContainer = this.mCompanyAccountHashMap.get(container.oidcompanyaccount);
                        if (companyAccountContainer == null) continue;
                        BanktpContainer bankTPcontainer = this.mBankHashMap.get(companyAccountContainer.oidbank);
                        String key = bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid();
                        tempList2 = (LinkedList<EepensschemeallContainer>)pensionSchemeHashMap.get(key);
                        this.mBankKeySet.add(key);
                        if (tempList2 == null) {
                            tempList2 = new LinkedList<EepensschemeallContainer>();
                            pensionSchemeHashMap.put(key, tempList2);
                        }
                        tempList2.add(container);
                        continue;
                    }
                    int n = modeOfPayment = StringMapper.isNullString((String)container.oidrecipient) ? container.modeofpayment : this.getModeOfPaymentByRecipient(container.oidrecipient);
                    if (modeOfPayment < 2) {
                        if (this.mStandardBankAccount != null) {
                            CompanyaccountContainer companyAccountContainer = this.mCompanyAccountHashMap.get(this.mStandardBankAccount);
                            if (companyAccountContainer == null) continue;
                            BanktpContainer bankTPcontainer = this.mBankHashMap.get(companyAccountContainer.oidbank);
                            tempList2 = (List)pensionSchemeHashMap.get(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid());
                            this.mBankKeySet.add(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid());
                            if (tempList2 == null) {
                                tempList2 = new LinkedList();
                                pensionSchemeHashMap.put(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid(), tempList2);
                            }
                            tempList2.add(container);
                            continue;
                        }
                        this.addError((String)personnelNumber, container.surname + ", " + container.firstname + " - Kein Firmenkonto bei Zahlungen f\u00fcr BAV - Zahlung wurde auf Bar gesetzt!");
                        tempList = (List)pensionSchemeHashMap.get(_18TIMES9);
                        this.mBankKeySet.add(_18TIMES9);
                        if (tempList == null) {
                            tempList = new LinkedList();
                            pensionSchemeHashMap.put(_18TIMES9, tempList);
                        }
                        tempList.add(container);
                        continue;
                    }
                    tempList = (LinkedList<EepensschemeallContainer>)pensionSchemeHashMap.get(_18TIMES9);
                    this.mBankKeySet.add(_18TIMES9);
                    if (tempList == null) {
                        tempList = new LinkedList<EepensschemeallContainer>();
                        pensionSchemeHashMap.put(_18TIMES9, tempList);
                    }
                    tempList.add(container);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return pensionSchemeHashMap;
    }

    private Map<String, List<AttachmentallContainer>> getAttachment(String[] rootOids) {
        HashMap<String, List<AttachmentallContainer>> attachmentHashMap = new HashMap<String, List<AttachmentallContainer>>();
        try {
            if (rootOids.length > 0) {
                PersistencyDataSet attachmentDatas = this.daoAttachmentall.getDataSet(null, (Criterion)this.getFilterForOids(rootOids, this.mUltimoOfPaymentMonth, this.mUltimoOfPaymentMonth));
                while (attachmentDatas.hasNext()) {
                    LinkedList<AttachmentallContainer> tempList;
                    int modeOfPayment;
                    Object personnelNumber;
                    Object pCompanyKey;
                    AttachmentallContainer container = (AttachmentallContainer)attachmentDatas.getNext();
                    if (this.mIsSuperiorForConsolidation) {
                        pCompanyKey = this.mReportValues.getPCompanyKey(container.oidpcompany) + "/";
                        personnelNumber = (String)pCompanyKey + Integer.toString(container.personnelnumber);
                    } else {
                        pCompanyKey = "";
                        personnelNumber = Integer.toString(container.personnelnumber);
                    }
                    if (!StringMapper.isNullString((String)container.oidcompanyaccount)) {
                        CompanyaccountContainer companyAccountContainer = this.mCompanyAccountHashMap.get(container.oidcompanyaccount);
                        if (companyAccountContainer == null) continue;
                        BanktpContainer bankTPcontainer = this.mBankHashMap.get(companyAccountContainer.oidbank);
                        LinkedList<AttachmentallContainer> tempList2 = (LinkedList<AttachmentallContainer>)attachmentHashMap.get(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid());
                        this.mBankKeySet.add(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid());
                        if (tempList2 == null) {
                            tempList2 = new LinkedList<AttachmentallContainer>();
                            attachmentHashMap.put(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid(), tempList2);
                        }
                        tempList2.add(container);
                        continue;
                    }
                    int n = modeOfPayment = StringMapper.isNullString((String)container.oidrecipient) ? container.modeofpayment : this.getModeOfPaymentByRecipient(container.oidrecipient);
                    if (modeOfPayment < 2) {
                        if (this.mStandardBankAccount != null) {
                            CompanyaccountContainer companyAccountContainer = this.mCompanyAccountHashMap.get(this.mStandardBankAccount);
                            if (companyAccountContainer == null) continue;
                            BanktpContainer bankTPcontainer = this.mBankHashMap.get(companyAccountContainer.oidbank);
                            LinkedList<AttachmentallContainer> tempList3 = (LinkedList<AttachmentallContainer>)attachmentHashMap.get(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid());
                            this.mBankKeySet.add(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid());
                            if (tempList3 == null) {
                                tempList3 = new LinkedList<AttachmentallContainer>();
                                attachmentHashMap.put(bankTPcontainer.bankcodenumber + companyAccountContainer.getObjectid(), tempList3);
                            }
                            tempList3.add(container);
                            continue;
                        }
                        this.addError((String)personnelNumber, container.surname + ", " + container.firstname + " - Kein Firmenkonto bei Zahlungen Pf\u00e4ndungen - Zahlung wurde auf Bar gesetzt!");
                        tempList = (List)attachmentHashMap.get(_18TIMES9);
                        this.mBankKeySet.add(_18TIMES9);
                        if (tempList == null) {
                            tempList = new LinkedList();
                            attachmentHashMap.put(_18TIMES9, tempList);
                        }
                        tempList.add(container);
                        continue;
                    }
                    tempList = (LinkedList<AttachmentallContainer>)attachmentHashMap.get(_18TIMES9);
                    this.mBankKeySet.add(_18TIMES9);
                    if (tempList == null) {
                        tempList = new LinkedList<AttachmentallContainer>();
                        attachmentHashMap.put(_18TIMES9, tempList);
                    }
                    tempList.add(container);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return attachmentHashMap;
    }

    private void init_mCompanyAccountHashMap() {
        try {
            PersistencyDataSet companyAccountDatas = this.daoCompanyaccount.getDataSet(null, Restrictions.eq((String)"oidpcompany", (String)this.mCompanyForSettings.getObjectid()));
            while (companyAccountDatas.hasNext()) {
                CompanyaccountContainer companyAccountContainer = (CompanyaccountContainer)companyAccountDatas.getNext();
                this.mCompanyAccountHashMap.put(companyAccountContainer.getObjectid(), companyAccountContainer);
                if (this.mStandardBankAccount != null) continue;
                this.mStandardBankAccount = this.getCompanyStandardAccount(companyAccountContainer.getObjectid()) ? companyAccountContainer.getObjectid() : null;
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private boolean getCompanyStandardAccount(String oidCompanyAccount) {
        boolean standardAccount = false;
        try {
            PersistencyDataSet companyAccounttpDatas = this.daoCompanyaccounttp.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidcompanyaccount", (String)oidCompanyAccount), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth)))}));
            CompanyaccounttpContainer companyAccounttpContainer = (CompanyaccounttpContainer)companyAccounttpDatas.getNext();
            if (companyAccounttpContainer != null) {
                standardAccount = companyAccounttpContainer.standardaccount;
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return standardAccount;
    }

    private void init_mRecipientHashMap() {
        try {
            PersistencyDataSet recipientAllDatas = this.daoRecipientall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth)))}));
            while (recipientAllDatas.hasNext()) {
                RecipientallContainer recipientAllContainer = (RecipientallContainer)recipientAllDatas.getNext();
                this.mRecipientHashMap.put(recipientAllContainer.oidrecipient, recipientAllContainer);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void init_mCompRecipientHashMap() {
        try {
            PersistencyDataSet comprecipientAllDatas = this.daoComprecipientall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.mUltimoOfPaymentMonth)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mUltimoOfPaymentMonth))), Restrictions.in((String)"oidpcompany", (String[])this.mOidPCompanies)}));
            while (comprecipientAllDatas.hasNext()) {
                ComprecipientallContainer compRecipientAllContainer = (ComprecipientallContainer)comprecipientAllDatas.getNext();
                this.mCompRecipientHashMap.put(compRecipientAllContainer.oidrecipient, compRecipientAllContainer);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private BigDecimal getPensionSchemeVP(String oidEmployee, Date effectiveDate, Date validDate, String oidRoot) {
        BigDecimal result = ZERO;
        try {
            PersistencyDataSet valuepositionDatas = this.daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"genesisparenttype", (String)"11"), Restrictions.eq((String)"oidemployee", (String)oidEmployee)}));
            while (valuepositionDatas.hasNext()) {
                String tempOidRoot;
                ValuepositionContainer valuepositionContainer = (ValuepositionContainer)valuepositionDatas.getNext();
                if (valuepositionContainer.valuetypenumber == 99999 || !StringMapper.equal((String)oidRoot, (String)(tempOidRoot = !StringMapper.isNullString((String)valuepositionContainer.oidrootgenesis) ? valuepositionContainer.oidrootgenesis : this.getPensionSchemeRoot(valuepositionContainer.oidgenesisparent)))) continue;
                result = result.add(valuepositionContainer.results);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    private String getPensionSchemeRoot(String oidTp) {
        String oidRoot = null;
        try {
            PersistencyDataSet pensionSchemeAllDatas = this.daoEepensschemeall.getDataSet(null, Restrictions.eq((String)"objectid", (String)oidTp));
            if (pensionSchemeAllDatas.hasNext()) {
                EepensschemeallContainer container = (EepensschemeallContainer)pensionSchemeAllDatas.getNext();
                oidRoot = container.objectidroot;
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return oidRoot;
    }

    private BigDecimal getReturnCalculationPensionScheme(String oidPensionSchemeRoot, Date returnCalculationDate) {
        BigDecimal result = ZERO;
        Date tempRCDate = returnCalculationDate;
        Date newEffective = this.mForEffectiveDate;
        Date oldEffective = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate));
        while (DateHelper.before((Date)tempRCDate, (Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))) {
            EepensschemeallContainer pensionSchemeNewContainer = this.getPensionSchemeByRoot(oidPensionSchemeRoot, newEffective, tempRCDate);
            EepensschemeallContainer pensionSchemeOldContainer = this.getPensionSchemeByRoot(oidPensionSchemeRoot, oldEffective, tempRCDate);
            if (pensionSchemeOldContainer != null && pensionSchemeNewContainer != null) {
                result = result.add(this.getPensionSchemeVP(pensionSchemeNewContainer.oidemployee, newEffective, tempRCDate, oidPensionSchemeRoot));
                result = result.subtract(this.getPensionSchemeVP(pensionSchemeOldContainer.oidemployee, oldEffective, tempRCDate, oidPensionSchemeRoot));
            }
            if (pensionSchemeOldContainer != null && pensionSchemeNewContainer == null) {
                result = result.subtract(this.getPensionSchemeVP(pensionSchemeOldContainer.oidemployee, oldEffective, tempRCDate, oidPensionSchemeRoot));
            }
            if (pensionSchemeOldContainer == null && pensionSchemeNewContainer != null) {
                result = result.add(this.getPensionSchemeVP(pensionSchemeNewContainer.oidemployee, newEffective, tempRCDate, oidPensionSchemeRoot));
            }
            tempRCDate = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)tempRCDate));
        }
        return result;
    }

    private EepensschemeallContainer getPensionSchemeByRoot(String oidPensionSchemeRoot, Date effectiveDate, Date validDate) {
        EepensschemeallContainer container = null;
        try {
            PersistencyDataSet eepensschemeallDatas = this.daoEepensschemeall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validDate))), Restrictions.eq((String)"objectidroot", (String)oidPensionSchemeRoot)}));
            if (eepensschemeallDatas.hasNext()) {
                container = (EepensschemeallContainer)eepensschemeallDatas.getNext();
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return container;
    }

    private BigDecimal getPaymentResults(ValuePosition valuePosition) {
        PersistentObject ausloeser = valuePosition.getGenesisOfParentObjects();
        String[] oidValueTypes = new String[]{"861110", "861114", "862110", "862114"};
        if (ausloeser instanceof EEAttachment) {
            oidValueTypes = new String[]{"795060", "795064", "795070", "795074", "795080", "795084", "795090", "795094", "795061", "795065", "795550", "795551", "795554", "795260", "795270", "795280", "795290", "795265"};
        }
        BigDecimal result = ZERO;
        try {
            PersistencyDataSet valuepositionDatas = this.daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.eq((String)"oidgenesisparent", (String)valuePosition.getObjectid()), Restrictions.in((String)"valuetypenumber", (String[])oidValueTypes)}));
            while (valuepositionDatas.hasNext()) {
                ValuepositionContainer valuepositionContainer = (ValuepositionContainer)valuepositionDatas.getNext();
                result = result.add(valuepositionContainer.results);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    private String[] getPayDeductionsVP(String[] oidEmployees) {
        String[] rootOids;
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.eq((String)"genesisparenttype", (String)"9")});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
            for (Criterion inRestriction : inRestrictions) {
                PersistencyDataSet valuepositionDatas = this.daoValueposition.getDataSet(null, Restrictions.and((Criterion)filter, (Criterion)inRestriction));
                while (valuepositionDatas.hasNext()) {
                    ValuepositionContainer valuepositionContainer = (ValuepositionContainer)valuepositionDatas.getNext();
                    String oidRoot = this.getPayDeductionRoot(valuepositionContainer.oidgenesisparent);
                    PayDeductionBean payDecuctionBean = this.mPayDeductionHashMap.get(oidRoot);
                    BigDecimal result = this.getPaymentResults(ValuePosition.getValuePosition(valuepositionContainer.getObjectid()));
                    if (payDecuctionBean == null) {
                        payDecuctionBean = new PayDeductionBean(oidRoot, result, 1);
                        this.mPayDeductionHashMap.put(oidRoot, payDecuctionBean);
                        continue;
                    }
                    if (payDecuctionBean.getModeType() == 2 || payDecuctionBean.getModeType() == 3) continue;
                    payDecuctionBean.addBetrag(result);
                }
            }
            LinkedList<String> payDeductionList = new LinkedList<String>(this.mPayDeductionHashMap.keySet());
            rootOids = new String[payDeductionList.size()];
            rootOids = payDeductionList.toArray(rootOids);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return rootOids;
    }

    private void init_mPayDeductionHashMapVariablerBetrag() {
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.in((String)"modetype", (String[])new String[]{Integer.toString(2), Integer.toString(3)})});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])this.mOIDEmployees);
            for (Criterion inRestriction : inRestrictions) {
                PersistencyDataSet paydeductionallDatas = this.daoPaydeductionall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{inRestriction, filter}));
                while (paydeductionallDatas.hasNext()) {
                    PaydeductionallContainer paydeductionallContainer = (PaydeductionallContainer)paydeductionallDatas.getNext();
                    BigDecimal result = this.getValuePositionVari(paydeductionallContainer.oidemployee, paydeductionallContainer.oidvaluetype, paydeductionallContainer.revalution);
                    PayDeductionBean payDecuctionBean = this.mPayDeductionHashMap.get(paydeductionallContainer.objectidroot);
                    if (payDecuctionBean == null) {
                        payDecuctionBean = new PayDeductionBean(paydeductionallContainer.objectidroot, result, paydeductionallContainer.modetype);
                        this.mPayDeductionHashMap.put(paydeductionallContainer.objectidroot, payDecuctionBean);
                        continue;
                    }
                    payDecuctionBean.addBetrag(result);
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private String getPayDeductionRoot(String oidTp) {
        String oidRoot = null;
        try {
            PersistencyDataSet payDeductionallAllDatas = this.daoPaydeductionall.getDataSet(null, Restrictions.eq((String)"objectid", (String)oidTp));
            if (payDeductionallAllDatas.hasNext()) {
                PaydeductionallContainer container = (PaydeductionallContainer)payDeductionallAllDatas.getNext();
                oidRoot = container.objectidroot;
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return oidRoot;
    }

    private String[] getAttachmentVP(String[] oidEmployees) {
        String[] rootOids;
        try {
            Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate))), Restrictions.eq((String)"genesisparenttype", (String)"13")});
            List inRestrictions = PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
            for (Criterion inRestriction : inRestrictions) {
                PersistencyDataSet valuepositionDatas = this.daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{filter, inRestriction}));
                while (valuepositionDatas.hasNext()) {
                    ValuepositionContainer valuepositionContainer = (ValuepositionContainer)valuepositionDatas.getNext();
                    String oidRoot = valuepositionContainer.oidgenesisparent;
                    AttachmentBean attachmentBean = this.mAttachmentHashMap.get(oidRoot);
                    BigDecimal result = this.getPaymentResults(ValuePosition.getValuePosition(valuepositionContainer.getObjectid()));
                    if (attachmentBean == null) {
                        attachmentBean = new AttachmentBean(oidRoot, result);
                        this.mAttachmentHashMap.put(oidRoot, attachmentBean);
                        continue;
                    }
                    attachmentBean.addBetrag(result);
                }
            }
            LinkedList<String> attachmentList = new LinkedList<String>(this.mAttachmentHashMap.keySet());
            rootOids = new String[attachmentList.size()];
            rootOids = attachmentList.toArray(rootOids);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return rootOids;
    }

    private CompanyFoundations getCompanyFoundations(String pCompanyOid) throws BusinessDomainException {
        CompanyFoundations eeCompanyFoundations = this.mCompanyFoundationsMap.get(pCompanyOid);
        if (eeCompanyFoundations == null) {
            PCompany pCompany = this.getPCompany(pCompanyOid);
            eeCompanyFoundations = pCompany.getCompanyFoundations(this.mForEffectiveDate, this.mForValidDate);
            this.mCompanyFoundationsMap.put(pCompanyOid, eeCompanyFoundations);
        }
        return eeCompanyFoundations;
    }

    private PCompany getPCompany(String pCompanyOid) {
        PCompany pCompany = this.mPCompanyMap.get(pCompanyOid);
        if (pCompany == null) {
            pCompany = PCompanyPersistencyManager.getPCompany((String)pCompanyOid);
            this.mPCompanyMap.put(pCompanyOid, pCompany);
        }
        return pCompany;
    }

    private void init_mCalculationbasicHashMap() {
        try {
            PersistencyDataSet CalculationbasicDatas = this.daoCalculationbasic.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.ge((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.lt((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate)))}));
            while (CalculationbasicDatas.hasNext()) {
                CalculationbasicContainer container = (CalculationbasicContainer)CalculationbasicDatas.getNext();
                Date tempDate = this.mCalculationbasicHashMap.get(container.oidemployee);
                if (tempDate == null) {
                    this.mCalculationbasicHashMap.put(container.oidemployee, container.validfrom);
                    continue;
                }
                tempDate = DateHelper.before((Date)tempDate, (Date)container.validfrom) ? tempDate : container.validfrom;
                this.mCalculationbasicHashMap.put(container.oidemployee, tempDate);
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private ModeOfPaymentEnum getModeOfPayment(ModeOfPaymentEnum modeofpayment, String bic, String iban, String personnelNumber, String name, String zahlArt) {
        if (modeofpayment == ModeOfPaymentEnum.MOPE_Ueberweisung) {
            if (!StringMapper.isNullString((String)bic) && !StringMapper.isNullString((String)iban)) {
                return ModeOfPaymentEnum.MOPE_Ueberweisung;
            }
            this.addError(personnelNumber, name + " - Keine vollst\u00e4ndigen SEPA-Daten bei " + zahlArt + " - Zahlung wurde auf BAR gesetzt!");
            return ModeOfPaymentEnum.MOPE_Barzahlung;
        }
        return modeofpayment;
    }

    private Disjunction getFilterForOids(String[] oidAttachments, Date effectiveTimePoint, Date validTimePoint) {
        Disjunction result = Restrictions.disjunction();
        ArrayList<String> oidList = new ArrayList<String>();
        for (String oidAttachment : oidAttachments) {
            if (oidList.size() == 250) {
                String[] teilStrings = new String[250];
                oidList.toArray(teilStrings);
                result.add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidattachment", (String[])teilStrings), Restrictions.le((String)"effectiveFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveTimePoint))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveTimePoint))), Restrictions.le((String)"validFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint)))}));
                oidList.clear();
            }
            oidList.add(oidAttachment);
        }
        String[] teilString = new String[oidList.size()];
        oidList.toArray(teilString);
        result.add((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidattachment", (String[])teilString), Restrictions.le((String)"effectiveFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveTimePoint))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveTimePoint))), Restrictions.le((String)"validFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validTimePoint)))}));
        return result;
    }

    public boolean hasPayments() {
        return this.mHasPayments;
    }

    private int getModeOfPaymentByRecipient(String oidRecipient) {
        RecipientallContainer recipient = this.mRecipientHashMap.get(oidRecipient);
        return recipient.modeofpayment;
    }

    protected void addPayment(Date validDate, List<PayrollPayment> paymentList, PayrollPayment payment, Employee employee, Recipient recipient, EmployeePaymentType employeePaymentType, Integer valueTypeNumberFromNetPay, List<EEPaymentDeduction> eePaymentDeductions) throws BusinessDomainException {
        paymentList.add(payment);
    }

    public List<EvaluationBean> getValuateList() {
        return this.mToValuate;
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    public void setDaoCalculationbasic(ICalculationbasicDao daoCalculationbasic) {
        this.daoCalculationbasic = daoCalculationbasic;
    }

    public void setDaoCompanyaccount(ICompanyaccountDao daoCompanyaccount) {
        this.daoCompanyaccount = daoCompanyaccount;
    }

    public void setDaoCompanyaccounttp(ICompanyaccounttpDao daoCompanyaccounttp) {
        this.daoCompanyaccounttp = daoCompanyaccounttp;
    }

    public void setDaoAttachmentall(IAttachmentallDao daoAttachmentall) {
        this.daoAttachmentall = daoAttachmentall;
    }

    public void setDaoEebankdetailsall(IEebankdetailsallDao daoEebankdetailsall) {
        this.daoEebankdetailsall = daoEebankdetailsall;
    }

    public void setDaoEepensschemeall(IEepensschemeallDao daoEepensschemeall) {
        this.daoEepensschemeall = daoEepensschemeall;
    }

    public void setDaoEmploymentall(IEmploymentallDao daoEmploymentall) {
        this.daoEmploymentall = daoEmploymentall;
    }

    public void setDaoMasterall(IMasterallDao daoMasterall) {
        this.daoMasterall = daoMasterall;
    }

    public void setDaoPaydeductionall(IPaydeductionallDao daoPaydeductionall) {
        this.daoPaydeductionall = daoPaydeductionall;
    }

    public void setDaoValueposition(IValuepositionDao daoValueposition) {
        this.daoValueposition = daoValueposition;
    }

    public void setDaoBanktp(IBanktpDao daoBanktp) {
        this.daoBanktp = daoBanktp;
    }

    public void setDaoRecipientall(IRecipientallDao daoRecipientall) {
        this.daoRecipientall = daoRecipientall;
    }

    public void setDaoComprecipientall(IComprecipientallDao daoCompRecipientall) {
        this.daoComprecipientall = daoCompRecipientall;
    }

    public void afterPropertiesSet() {
        this.checkNotNull(this.daoCalculationbasic, "daoCalculationbasic");
        this.checkNotNull(this.daoCompanyaccount, "daoCompanyaccount");
        this.checkNotNull(this.daoCompanyaccounttp, "daoCompanyaccounttp");
        this.checkNotNull(this.daoAttachmentall, "daoAttachmentall");
        this.checkNotNull(this.daoEebankdetailsall, "daoEebankdetailsall");
        this.checkNotNull(this.daoEepensschemeall, "daoEepensschemeall");
        this.checkNotNull(this.daoEmploymentall, "daoEmploymentall");
        this.checkNotNull(this.daoMasterall, "daoMasterall");
        this.checkNotNull(this.daoPaydeductionall, "daoPaydeductionall");
        this.checkNotNull(this.daoValueposition, "daoValueposition");
        this.checkNotNull(this.daoBanktp, "daoBanktp");
        this.checkNotNull(this.daoRecipientall, "daoRecipientall");
        this.checkNotNull(this.daoComprecipientall, "daoComprecipientall");
    }

    private void checkNotNull(Object daoObject, String daoName) {
        if (daoObject == null) {
            throw new IllegalArgumentException(TextFactory.makeArgumentNotSet((String)daoName));
        }
    }

    private class AccountSums {
        private final BigDecimal mSumme_dta;
        private final BigDecimal mSumme_scheck;
        private final BigDecimal mSumme_bar;
        private final BigDecimal mSumme_einzug;
        private final BigDecimal mSumme_gesamt;

        public AccountSums(BigDecimal summe_dta, BigDecimal summe_scheck, BigDecimal summe_bar, BigDecimal summe_einzug, BigDecimal summe_gesamt) {
            this.mSumme_dta = summe_dta;
            this.mSumme_scheck = summe_scheck;
            this.mSumme_bar = summe_bar;
            this.mSumme_einzug = summe_einzug;
            this.mSumme_gesamt = summe_gesamt;
        }

        public String getSumme_dta() {
            return this.toCurrencyFormat(this.mSumme_dta);
        }

        public String getSumme_scheck() {
            return this.toCurrencyFormat(this.mSumme_scheck);
        }

        public String getSumme_bar() {
            return this.toCurrencyFormat(this.mSumme_bar);
        }

        public String getSumme_einzug() {
            return this.toCurrencyFormat(this.mSumme_einzug);
        }

        public String getSumme_gesamt() {
            return this.toCurrencyFormat(this.mSumme_gesamt);
        }

        private String toCurrencyFormat(BigDecimal number) {
            return EmployeePaymentDataBean.toCurrencyFormat((BigDecimal)number);
        }
    }

    private class SammelueberweisungKey {
        private final int mValuetypeNumber;
        private final String mOidRecipient;

        public SammelueberweisungKey(int valuetypeNumber, String oidRecipient) {
            this.mValuetypeNumber = valuetypeNumber;
            this.mOidRecipient = oidRecipient;
        }

        public boolean equals(Object object) {
            if (object instanceof SammelueberweisungKey) {
                SammelueberweisungKey sammelueberweisungKey = (SammelueberweisungKey)object;
                return this.mValuetypeNumber == sammelueberweisungKey.mValuetypeNumber && this.mOidRecipient.equals(sammelueberweisungKey.mOidRecipient);
            }
            return false;
        }

        public int hashCode() {
            return this.mOidRecipient.hashCode() + this.mValuetypeNumber;
        }
    }

    private class SammelueberweisungComparator
    implements Comparator<EmployeePaymentDataBean> {
        private SammelueberweisungComparator() {
        }

        @Override
        public int compare(EmployeePaymentDataBean epdb1, EmployeePaymentDataBean epdb2) {
            assert (epdb1 != null);
            assert (epdb2 != null);
            RecipientallContainer recipient1 = EmployeePaymentDataSource.this.mRecipientHashMap.get(epdb1.getOidRecipient());
            RecipientallContainer recipient2 = EmployeePaymentDataSource.this.mRecipientHashMap.get(epdb2.getOidRecipient());
            assert (recipient1 != null);
            assert (recipient2 != null);
            return StringMapper.compareTo((String)recipient1.longdescription, (String)recipient2.longdescription);
        }
    }

    private class DataComparator
    implements Comparator<EmployeePaymentDataBean> {
        @Override
        public int compare(EmployeePaymentDataBean epdb1, EmployeePaymentDataBean epdb2) {
            int comp = EmployeePaymentDataSource.this.mSortNachName ? StringMapper.compareTo((String)epdb1.getName(), (String)epdb2.getName()) : StringMapper.compareTo((String)epdb1.getPersonalnummerForSort(), (String)epdb2.getPersonalnummerForSort());
            return comp;
        }
    }

    private class ErrorListComparator
    implements Comparator<ErrorBean> {
        @Override
        public int compare(ErrorBean eb1, ErrorBean eb2) {
            return StringMapper.compareTo((String)eb1.getPersonnelNumber(), (String)eb2.getPersonnelNumber());
        }
    }

    private class EebankdetailsallContainerComparator
    implements Comparator<EebankdetailsallContainer> {
        @Override
        public int compare(EebankdetailsallContainer eebdc1, EebankdetailsallContainer eebdc2) {
            return Integer.compare(eebdc1.rankingnumber, eebdc2.rankingnumber);
        }
    }

    private class PaymentComparator
    implements Comparator<String> {
        @Override
        public int compare(String bankkey1, String bankkey2) {
            return Double.compare(Double.parseDouble(bankkey1), Double.parseDouble(bankkey2));
        }
    }
}

