/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.eau.receive;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.eau.eauaccount.EauAccount;
import com.varial.personnel.domain.eau.eaudxag.EauDxag;
import com.varial.personnel.domain.eau.eaudxkk.EauDxkk;
import com.varial.personnel.domain.eau.receive.EauReceive;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipientTP;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.query.PutDataException;
import com.varial.shared.Version;
import java.util.Date;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;

public class EauReceiveProtocolReportDataSource {
    private final EauReceive mCreator;
    private final Iterator<EauAccount> mIterator;
    private EauAccount mAccount;
    private final ProgressBarUpdater mProgressBar;

    public EauReceiveProtocolReportDataSource(EauReceive creator, ProgressBarUpdater progressBar) throws PutDataException {
        this.mIterator = creator.getImporteds().iterator();
        this.mCreator = creator;
        this.mProgressBar = progressBar;
        this.mProgressBar.setTotal(creator.getImporteds().size());
    }

    public boolean next() throws JRException {
        boolean hasNext = this.mIterator.hasNext();
        try {
            if (hasNext) {
                this.mAccount = this.mIterator.next();
                this.mProgressBar.update();
            } else {
                this.mAccount = null;
            }
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
        return hasNext;
    }

    public EauDxag getDxag() {
        if (this.mAccount.isReadOnly()) {
            return null;
        }
        return this.mAccount.getEauDxag();
    }

    public String getSenderName() throws BusinessDomainException {
        DEUVSender bo = this.mCreator.getDeuvSender();
        DEUVSenderTP tp = bo.getDEUVSenderTP(VDate.getDateMax(), VDate.getDateMax());
        return tp.getName();
    }

    public Date getCreateDate() {
        return VDate.getCurrentLocalizedDateAndTime();
    }

    public String getUser() {
        return SessionContext.getInstance().getSession().getUserCode();
    }

    public String getPerfidiaFile() throws BusinessDomainException {
        DEUVRecipient recipient = this.mAccount.getDEUVRecipient();
        if (recipient == null) {
            return "";
        }
        String subFolder = Deuv.getPerfidiaSubFolder((DEUVRecipient)recipient);
        String file = "EEAA0";
        if (this.isDxkk()) {
            file = "EEAR0";
        }
        return String.format("pem/recv/%s/dat/" + file + "*, Laufnr. %s", subFolder, this.mAccount.getCurrentFileNumber());
    }

    public String getRecipientName() throws BusinessDomainException {
        DEUVRecipient bo = this.mAccount.getDEUVRecipient();
        if (bo == null) {
            return "";
        }
        DEUVRecipientTP tp = bo.getDEUVRecipientTP(VDate.getDateMax(), VDate.getDateMax());
        return tp.getName();
    }

    public String getVersion() {
        return Version.getVersion();
    }

    public Date getDatumUhrzeit() {
        return VDate.getCurrentLocalizedDateAndTime();
    }

    public String getErrorMessage() {
        if (this.mAccount.isAbsentTimeChanged()) {
            if (this.mAccount.isCancelFromHF()) {
                return "Stornierung seitens der Krankenkasse. Begrenzung der Mitarbeiterfehlzeit zur\u00fcckgesetzt.";
            }
            return "Erfolgreiche \u00dcbernahme des voraussichtlichen AU-Bis in die Mitarbeiterfehlzeit.";
        }
        StringBuilder sb = new StringBuilder(this.mAccount.getErrorMessage());
        for (EauDxkk each : this.getDxkk()) {
            String message = each.getMessage();
            if (message == null) continue;
            sb.append(message);
        }
        return sb.toString();
    }

    public String getEmployeeDescription() throws BusinessDomainException {
        Employee employee = this.mAccount.getEmployee();
        Object result = "?";
        if (employee != null) {
            Master master = employee.getMaster(VDate.getDateMax(), VDate.getDateMax());
            result = employee.getPersonnelnumber() + "    " + master.getSurname() + ", " + master.getFirstname();
        }
        return result;
    }

    public String getReasonDesc() {
        return "" + this.mAccount.getReasonOfDelivery();
    }

    public EauDxkk[] getDxkk() {
        return this.mAccount.getEauDxkkForProtocol();
    }

    public Boolean getHasDXKKs() {
        return this.getDxkk().length > 0;
    }

    public EauAccount getAccount() {
        return this.mAccount;
    }

    public String getName() throws BusinessDomainException {
        Employee employee = this.mAccount.getEmployee();
        Object result = "?";
        if (employee != null) {
            Master master = employee.getMaster(VDate.getDateMax(), VDate.getDateMax());
            result = master.getSurname() + ", " + master.getFirstname();
        }
        return result;
    }

    public String getInsuranceNumber() {
        return this.mAccount.getObjectid() == null ? "?" : this.mAccount.getEauDxag().getVsnr();
    }

    public String getAuabag() {
        return this.mAccount.getObjectid() == null ? "?" : DateMapper.toDDMMYYYYPointSeparationString((Date)this.mAccount.getEauDxag().getAuabag());
    }

    public String getRecipientNumber() {
        return this.mAccount.getObjectid() == null ? "?" : this.mAccount.getEauDxag().getBbnrempfaenger();
    }

    public String getStorno() {
        if (this.mAccount.isCancelFromHF()) {
            return "J";
        }
        return this.mAccount.getCanceled();
    }

    public String getReasonOfDeliveryDesc() {
        String result = "eAU R\u00fcckmeldung";
        if (this.isDxvd()) {
            result = "eAU Verarbeitungsergebnis Datensatzabweisung";
        }
        if (this.isDxve()) {
            result = "eAU Verarbeitungsergebnis";
        }
        return result;
    }

    private boolean isDxkk() {
        return "DXKK".equals(this.mAccount.getAnswerType());
    }

    private boolean isDxve() {
        return "DXVE".equals(this.mAccount.getAnswerType());
    }

    private boolean isDxvd() {
        return "DXVD".equals(this.mAccount.getAnswerType());
    }
}

