/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.pcompany;

import com.infor.igf.core.integration.BODService;
import com.infor.igf.core.integration.IntegrationException;
import com.infor.igf.core.integration.bod.BusinessObjectDocument;
import com.infor.igf.core.integration.bod.BusinessObjectDocumentFactory;
import com.infor.igf.core.integration.bod.ConfirmDocument;
import com.infor.igf.core.integration.bod.Failure;
import com.infor.igf.core.integration.bod.Fortress;
import com.infor.igf.core.integration.bod.Noun;
import com.infor.igf.core.integration.bod.ShowDocument;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.company.Company;
import com.varial.framework.domain.company.CompanyPersistencyManager;
import com.varial.interfaces.ICostCenter;
import com.varial.interfaces.ICostUnit;
import com.varial.interfaces.IPayrollCompany;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTP;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager;
import com.varial.personnel.domain.companyplant.TaxNumberBean;
import com.varial.personnel.domain.designationtype.costcenter.CostCenter;
import com.varial.personnel.domain.designationtype.costcenter.CostCenterTP;
import com.varial.personnel.domain.designationtype.costcenter.CostingCostCenter;
import com.varial.personnel.domain.designationtype.costunit.CostUnit;
import com.varial.personnel.domain.designationtype.costunit.CostUnitTP;
import com.varial.personnel.domain.designationtype.costunit.CostingCostUnit;
import com.varial.personnel.domain.designationtype.designation.mapper.DesignationExceptionMapper;
import com.varial.personnel.domain.employee.disability.EEDisabilityTP;
import com.varial.personnel.domain.employee.disability.EEDisabilityTPPersistencyManager;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.employment.IEmploymentPersistencyManager;
import com.varial.personnel.domain.employee.insurance.IInsurancePersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.account.CompanyAccountTPPersistencyManager;
import com.varial.personnel.domain.pcompany.allocation.assignment.CompanyAllocationAssignment;
import com.varial.personnel.domain.pcompany.allocation.assignment.CompanyAllocationAssignmentPersistencyManager;
import com.varial.personnel.domain.pcompany.allocation.assignment.CompanyAllocationAssignmentTP;
import com.varial.personnel.domain.pcompany.allocation.foundations.CompanyAllocationFoundationsTP;
import com.varial.personnel.domain.pcompany.allocation.foundations.CompanyAllocationFoundationsTPPersistencyManager;
import com.varial.personnel.domain.pcompany.allocation.foundations.mapper.CompanyAllocationFoundationsFilterStructMapper;
import com.varial.personnel.domain.pcompany.attributive.AttributiveCompany;
import com.varial.personnel.domain.pcompany.attributive.AttributiveCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.community.CompanyCommunity;
import com.varial.personnel.domain.pcompany.community.CompanyCommunityPersistencyManager;
import com.varial.personnel.domain.pcompany.contacts.CompanyCommunityContact;
import com.varial.personnel.domain.pcompany.contacts.CompanyCommunityContactPersistencyManager;
import com.varial.personnel.domain.pcompany.contacts.CompanyContact;
import com.varial.personnel.domain.pcompany.contacts.CompanyContactPersistencyManager;
import com.varial.personnel.domain.pcompany.contacts.CompanyEmploymentOfficeContact;
import com.varial.personnel.domain.pcompany.contacts.CompanyEmploymentOfficeContactPersistencyManager;
import com.varial.personnel.domain.pcompany.contacts.CompanyTaxOfficeContact;
import com.varial.personnel.domain.pcompany.contacts.CompanyTaxOfficeContactPersistencyManager;
import com.varial.personnel.domain.pcompany.disability.CompanyDisabilityTP;
import com.varial.personnel.domain.pcompany.disability.CompanyDisabilityTPComparator;
import com.varial.personnel.domain.pcompany.disability.CompanyDisabilityTPPersistencyManager;
import com.varial.personnel.domain.pcompany.disability.CompanyOrderDisability;
import com.varial.personnel.domain.pcompany.disability.CompanyOrderDisabilityPersistencyManager;
import com.varial.personnel.domain.pcompany.disability.contacts.CompanyDisabilityContact;
import com.varial.personnel.domain.pcompany.disability.contacts.CompanyDisabilityContactPersistencyManager;
import com.varial.personnel.domain.pcompany.disability.notes.CompanyDisabilityNote;
import com.varial.personnel.domain.pcompany.disability.notes.CompanyDisabilityNotePersistencyManager;
import com.varial.personnel.domain.pcompany.disability.transfer.CompanyDisabilityTransfer;
import com.varial.personnel.domain.pcompany.emploffice.CompanyEmploymentOffice;
import com.varial.personnel.domain.pcompany.emploffice.CompanyEmploymentOfficePersistencyManager;
import com.varial.personnel.domain.pcompany.foundations.CCompanyFoundationsFilterStruct;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundationsComparator;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundationsPersistencyManager;
import com.varial.personnel.domain.pcompany.foundations.mapper.CompanyFoundationsFilterStructMapper;
import com.varial.personnel.domain.pcompany.mapper.PCompanyExceptionMapper;
import com.varial.personnel.domain.pcompany.notes.CompanyCommunityNote;
import com.varial.personnel.domain.pcompany.notes.CompanyCommunityNotePersistencyManager;
import com.varial.personnel.domain.pcompany.notes.CompanyEmploymentOfficeNote;
import com.varial.personnel.domain.pcompany.notes.CompanyEmploymentOfficeNotePersistencyManager;
import com.varial.personnel.domain.pcompany.notes.CompanyNote;
import com.varial.personnel.domain.pcompany.notes.CompanyNotePersistencyManager;
import com.varial.personnel.domain.pcompany.notes.CompanyTaxOfficeNote;
import com.varial.personnel.domain.pcompany.notes.CompanyTaxOfficeNotePersistencyManager;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.pcompany.settings.CompanySettingsComparator;
import com.varial.personnel.domain.pcompany.settings.CompanySettingsPersistencyManager;
import com.varial.personnel.domain.pcompany.taxoffice.CompanyTaxOffice;
import com.varial.personnel.domain.pcompany.taxoffice.CompanyTaxOfficePersistencyManager;
import com.varial.personnel.domain.plant.taxoffice.PlantTaxOffice;
import com.varial.personnel.domain.plant.taxoffice.PlantTaxOfficePersistencyManager;
import com.varial.personnel.domain.reports.costingreportpre.CostingReportPre;
import com.varial.personnel.domain.reports.costingreportpre.CostingReportPrePersistencyManager;
import com.varial.personnel.domain.reports.eestockreportpre.EEStockReportPre;
import com.varial.personnel.domain.reports.eestockreportpre.EEStockReportPrePersistencyManager;
import com.varial.personnel.domain.reports.qualimatrixpre.QualiMatrixPre;
import com.varial.personnel.domain.reports.qualimatrixpre.QualiMatrixPrePersistencyManager;
import com.varial.personnel.domain.reports.remaindaysreportpre.RemainDaysReportPre;
import com.varial.personnel.domain.reports.remaindaysreportpre.RemainDaysReportPrePersistencyManager;
import com.varial.personnel.domain.reports.valuetypedatasheetpre.ValueTypeDataSheetPre;
import com.varial.personnel.domain.reports.valuetypedatasheetpre.ValueTypeDataSheetPrePersistencyManager;
import com.varial.personnel.framework.PersonnelHistory;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.checkup.MembershipNumberOfAIF;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCompany
extends PersonnelPersistenceObject<PersonnelTimedPersistenceObject>
implements IPayrollCompany {
    private static final Logger LOGGER = LoggerFactory.getLogger(PCompany.class);
    private static final int PRIORITY = 5;
    static final String CLASSNAME = PCompany.class.getName();
    private String mPCompanyKey;
    private Company mCompany;
    private PCompany mSuperiorCompanyForConsolidation;
    private boolean mIsSuperiorForConsolidation;
    private boolean mIsMultiple;
    private Date mDateOfEventDsbd;
    private PersonnelHistory<CompanyFoundations> mCompanyFoundationsHistory;
    private PersonnelHistory<CompanySettings> mCompanySettingsHistory;
    private PersonnelHistory<CompanyDisabilityTP> mCompanyDisabilityTPHistory;
    private PersonnelHistory<CompanyTaxOffice> mCompanyTaxOfficeHistory;
    private PersonnelHistory<CompanyEmploymentOffice> mCompanyEmploymentOfficeHistory;
    private PersonnelHistory<CompanyCommunity> mCompanyCommunityHistory;
    private PersonnelHistory<CompanyAllocationFoundationsTP> mCompanyAllocationFoundationsHistory;
    private CompanyAllocationAssignment[] mCompanyAllocationAssignments = new CompanyAllocationAssignment[0];
    private CompanyNote[] mCompanyNote;
    private CompanyContact[] mCompanyContact;
    private CompanyTaxOfficeNote[] mCompanyTaxOfficeNote;
    private CompanyTaxOfficeContact[] mCompanyTaxOfficeContact;
    private CompanyEmploymentOfficeNote[] mCompanyEmploymentOfficeNote;
    private CompanyEmploymentOfficeContact[] mCompanyEmploymentOfficeContact;
    private CompanyCommunityNote[] mCompanyCommunityNote;
    private CompanyCommunityContact[] mCompanyCommunityContact;
    private CompanyOrderDisability[] mCompanyOrderDisability;
    private CompanyDisabilityContact[] mCompanyDisabilityContact;
    private CompanyDisabilityNote[] mCompanyDisabilityNote;
    private AttributiveCompany[] mAttributiveCompanys;
    private CostingReportPre[] mCostingReportPres = new CostingReportPre[0];
    private ValueTypeDataSheetPre[] mValueTypeDataSheetPres = new ValueTypeDataSheetPre[0];
    private RemainDaysReportPre[] mRemainDaysReportPres = new RemainDaysReportPre[0];
    private EEStockReportPre[] mEEStockReportPres = new EEStockReportPre[0];
    private QualiMatrixPre[] mQualiMatrixPres = new QualiMatrixPre[0];

    public PCompany() {
        super(5);
    }

    public static PCompany getPCompanyByPCompanyKey(String pcompanyKey) {
        PCompany[] pcompany = PCompanyPersistencyManager.query(null, (Criterion)Restrictions.eq((String)"pcompanykey", (String)pcompanyKey));
        if (pcompany.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)("PCompanyKey = " + pcompanyKey));
        }
        pcompany[0].makeReadOnly();
        return pcompany[0];
    }

    public static boolean existStdCompanyNumber(String stdCompanyNumber, Date effectiveFrom, Date validFrom) {
        return CompanyEmploymentOfficePersistencyManager.existStdCompanyNumber((String)stdCompanyNumber, (Date)effectiveFrom, (Date)validFrom);
    }

    public PCompany(String objectID) {
        super(5, objectID);
    }

    public PCompany(String objectId, int version) {
        super(5, objectId, version);
    }

    protected PCompany(boolean readOnly) {
        super(5, readOnly);
    }

    protected void saveImpl() {
        PCompanyPersistencyManager.save((PCompany)this);
    }

    protected void load() {
        PCompanyPersistencyManager.load((PCompany)this);
    }

    protected void deleteImpl() {
        PCompanyPersistencyManager.delete((PCompany)this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        int i;
        List list;
        if (this.mCompanyFoundationsHistory != null) {
            list = this.mCompanyFoundationsHistory.getAll();
            for (i = 0; i < list.size(); ++i) {
                ((CompanyFoundations)list.get(i)).remove();
            }
        }
        if (this.mCompanySettingsHistory != null) {
            list = this.mCompanySettingsHistory.getAll();
            for (i = 0; i < list.size(); ++i) {
                ((CompanySettings)list.get(i)).remove();
            }
        }
        for (CompanyDisabilityTP companyDisabilityTP : this.getPCompanyDisabilityTPHistory()) {
            companyDisabilityTP.makeSaveable();
            companyDisabilityTP.destroy();
        }
        for (CompanyDisabilityTP companyDisabilityTP : this.getPCompanyTaxOfficeHistory()) {
            companyDisabilityTP.makeSaveable();
            companyDisabilityTP.destroy();
        }
        for (CompanyDisabilityTP companyDisabilityTP : this.getPCompanyEmploymentOfficeHistory()) {
            companyDisabilityTP.makeSaveable();
            companyDisabilityTP.destroy();
        }
        for (CompanyDisabilityTP companyDisabilityTP : this.getPCompanyCommunityHistory()) {
            companyDisabilityTP.makeSaveable();
            companyDisabilityTP.destroy();
        }
        for (CompanyDisabilityTP companyDisabilityTP : this.getAttributiveCompany()) {
            companyDisabilityTP.makeSaveable();
            companyDisabilityTP.destroy();
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getPCompanyKey();
    }

    public static PCompany[] getPCompany(Order[] sortierung, Criterion filters) {
        return PCompanyPersistencyManager.query((Order[])sortierung, (Criterion)filters);
    }

    protected void setData(String pCompanykey, Company company, PCompany superiorCompanyForConsolidation, boolean isSuperiorForConsolidation, boolean isMultiple, Date dateOfEventDsbd) {
        this.mPCompanyKey = pCompanykey;
        this.mCompany = company;
        this.mSuperiorCompanyForConsolidation = superiorCompanyForConsolidation;
        this.mIsSuperiorForConsolidation = isSuperiorForConsolidation;
        this.mIsMultiple = isMultiple;
        this.mDateOfEventDsbd = dateOfEventDsbd;
    }

    public PersonnelHistory<PersonnelTimedPersistenceObject> getHistory() {
        throw new UnsupportedOperationException("No default");
    }

    public String getPCompanyKey() {
        this.requireLoaded();
        return this.mPCompanyKey;
    }

    public void setPCompanyKey(String pCompanyKey) {
        this.mPCompanyKey = pCompanyKey;
    }

    public Company getCompany() {
        this.requireLoaded();
        return this.mCompany;
    }

    public void setCompany(Company company) {
        this.mCompany = company;
    }

    public PCompany getSuperiorCompanyForConsolidation() {
        this.requireLoaded();
        return this.mSuperiorCompanyForConsolidation;
    }

    public void setSuperiorCompanyForConsolidation(PCompany company) {
        this.mSuperiorCompanyForConsolidation = company;
    }

    public boolean getIsSuperiorForConsolidation() {
        this.requireLoaded();
        return this.mIsSuperiorForConsolidation;
    }

    public void setIsSuperiorForConsolidation(boolean isSuperiorForConsolidation) {
        this.mIsSuperiorForConsolidation = isSuperiorForConsolidation;
    }

    public boolean getIsMultiple() {
        this.requireLoaded();
        return this.mIsMultiple;
    }

    public void setIsMultiple(boolean isMultiple) {
        this.mIsMultiple = isMultiple;
    }

    public Date getDateOfEventDsbd() {
        this.requireLoaded();
        return this.mDateOfEventDsbd;
    }

    public void setDateOfEventDsbd(Date dateOfEventDsbd) {
        this.mDateOfEventDsbd = dateOfEventDsbd;
    }

    public void addCompanyFoundationsHistory(CompanyFoundations cf, boolean removeNew) throws BusinessDomainException {
        cf.checkAttributes();
        CompanyFoundations[] changedArray = PCompany.listToCompanyFoundationsArray(this.getCompanyFoundationsHistory().addItem((PersonnelTimedPersistenceObject)cf, removeNew));
        if (changedArray.length == 1 && DateHelper.after((Date)cf.getEffectiveFrom(), (Date)cf.getValidFrom())) {
            cf.setEffectiveFrom(cf.getValidFrom());
        }
        for (CompanyFoundations lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    private static CompanyFoundations[] listToCompanyFoundationsArray(List<CompanyFoundations> list) {
        CompanyFoundations[] CFdata = new CompanyFoundations[list.size()];
        return list.toArray(CFdata);
    }

    public PersonnelHistory<CompanyFoundations> getCompanyFoundationsHistory() {
        this.requireLoaded();
        if (this.mCompanyFoundationsHistory == null) {
            this.mCompanyFoundationsHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getPCompanyFoundationsHistory());
        }
        return this.mCompanyFoundationsHistory;
    }

    public CompanyFoundations[] getPCompanyFoundationsHistory() {
        if (this.isNew()) {
            return new CompanyFoundations[0];
        }
        return CompanyFoundationsPersistencyManager.getCompanyFoundationsHistory((PCompany)this);
    }

    public static CompanyFoundations[] getActiveCompanyFoundations(CCompanyFoundationsFilterStruct[] filters, Order[] sortierung) {
        CompanyFoundations[] cf = CompanyFoundationsPersistencyManager.queryAll((Order[])sortierung, (Criterion)CompanyFoundationsFilterStructMapper.toFilter((CCompanyFoundationsFilterStruct[])filters), (boolean)true);
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(cf, new CompanyFoundationsComparator());
        }
        return cf;
    }

    public CompanyFoundations getActiveCompanyFoundation() {
        CompanyFoundations[] cfa = CompanyFoundationsPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (PCompany)this);
        if (cfa.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return cfa[0];
    }

    public CompanyFoundations getCompanyFoundations(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (CompanyFoundations)this.getCompanyFoundationsHistory().getItem(effectiveFrom, validFrom);
    }

    public CompanyFoundations[] getActiveEffectiveCompanyFoundationsHistory() {
        CompanyFoundations[] result = new CompanyFoundations[this.getCompanyFoundationsHistory().getItems(VDate.getDateMax()).size()];
        return this.getCompanyFoundationsHistory().getItems(VDate.getDateMax()).toArray(result);
    }

    public void setCompanyFoundationsHistory(CompanyFoundations cf, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        CompanyFoundations[] changedArray;
        cf.checkAttributes();
        if (DateHelper.equal((Date)cf.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = PCompany.listToCompanyFoundationsArray(this.getCompanyFoundationsHistory().setItem((PersonnelTimedPersistenceObject)cf, removeNew));
        } else {
            removeNew = true;
            changedArray = PCompany.listToCompanyFoundationsArray(this.getCompanyFoundationsHistory().addItem((PersonnelTimedPersistenceObject)cf, removeNew));
            if (changedArray.length == 1 && DateHelper.after((Date)cf.getEffectiveFrom(), (Date)cf.getValidFrom())) {
                cf.setEffectiveFrom(cf.getValidFrom());
            }
        }
        for (CompanyFoundations lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    public CompanyFoundations[] getEffectiveCompanyFoundationsHistory(Date effectivTimePoint) {
        return this.getCompanyFoundationsHistory(effectivTimePoint);
    }

    public CompanyFoundations[] getCompanyFoundationsHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new CompanyFoundations[0];
        }
        return PCompany.listToCompanyFoundationsArray(this.getCompanyFoundationsHistory().getItems(effectivTimePoint));
    }

    public CompanyFoundations[] getCompanyFoundationsTimePeriods(CompanyFoundations ptpo) {
        return (CompanyFoundations[])this.getCompanyFoundationsHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public static CompanyFoundations[] getCompanyFoundations(Criterion filters, Order[] sortierung) {
        CompanyFoundations[] tpArray = CompanyFoundationsPersistencyManager.query((Order[])sortierung, (Criterion)filters);
        return tpArray;
    }

    public static CompanyFoundations[] getCompanyFoundations(CCompanyFoundationsFilterStruct[] filters, Order[] sortierung, Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        if (validTimePoint == null) {
            throw PCompanyExceptionMapper.makeValidTimepointIsEmptyDomainException((String)"getCompanyFoundations");
        }
        if (effectiveTimePoint == null) {
            effectiveTimePoint = validTimePoint;
        }
        if (DateHelper.before((Date)effectiveTimePoint, (Date)validTimePoint)) {
            effectiveTimePoint = validTimePoint;
        }
        CompanyFoundations[] tpArray = CompanyFoundationsPersistencyManager.queryAll((Order[])sortierung, (Criterion)CompanyFoundationsFilterStructMapper.toFilter((CCompanyFoundationsFilterStruct[])filters, (Date)effectiveTimePoint, (Date)validTimePoint), (boolean)true);
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(tpArray, new CompanyFoundationsComparator());
        }
        return tpArray;
    }

    public static CompanyFoundations[] getCompanyFoundationsForDEUVSender(String oidDEUVSender) {
        CompanySettings[] cfs = CompanySettingsPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidDEUVSender", (String)oidDEUVSender), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}));
        if (cfs.length == 0) {
            return new CompanyFoundations[0];
        }
        ArrayList<CompanySettings> notStopped = new ArrayList<CompanySettings>();
        for (CompanySettings companySetting : cfs) {
            if (companySetting.getPCompany().getCompany().isStopped(DateHelper.today())) continue;
            notStopped.add(companySetting);
        }
        ArrayList<CompanyFoundations> list = new ArrayList<CompanyFoundations>();
        for (CompanySettings lElement : notStopped) {
            CompanyFoundations[] cfa = CompanyFoundationsPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)lElement.getPCompany().getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}));
            if (cfa.length <= 0) continue;
            list.add(cfa[0]);
        }
        return PCompany.listToCompanyFoundationsArray(list);
    }

    public void addCompanySettingsHistory(CompanySettings cs, boolean removeNew) throws BusinessDomainException {
        cs.checkAttributes();
        CompanySettings[] changedArray = PCompany.listToCompanySettingsArray(this.getCompanySettingsHistory().addItem((PersonnelTimedPersistenceObject)cs, removeNew));
        if (changedArray.length == 1 && DateHelper.after((Date)cs.getEffectiveFrom(), (Date)cs.getValidFrom())) {
            cs.setEffectiveFrom(cs.getValidFrom());
        }
        for (CompanySettings lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    private static CompanySettings[] listToCompanySettingsArray(List<CompanySettings> list) {
        CompanySettings[] CFdata = new CompanySettings[list.size()];
        return list.toArray(CFdata);
    }

    public PersonnelHistory<CompanySettings> getCompanySettingsHistory() {
        this.requireLoaded();
        if (this.mCompanySettingsHistory == null) {
            this.mCompanySettingsHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getPCompanySettingsHistory());
        }
        return this.mCompanySettingsHistory;
    }

    public CompanySettings[] getPCompanySettingsHistory() {
        if (this.isNew()) {
            return new CompanySettings[0];
        }
        return CompanySettingsPersistencyManager.getCompanySettingsHistory((PCompany)this);
    }

    public static CompanySettings[] getActiveCompanySettings(CCompanyFoundationsFilterStruct[] filters, Order[] sortierung) {
        CompanySettings[] cs = CompanySettingsPersistencyManager.queryAll((Order[])sortierung, (Criterion)CompanyFoundationsFilterStructMapper.toFilter((CCompanyFoundationsFilterStruct[])filters));
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(cs, new CompanySettingsComparator());
        }
        return cs;
    }

    public CompanySettings getActiveCompanySettings() {
        CompanySettings[] cst = CompanySettingsPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (PCompany)this);
        if (cst.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return cst[0];
    }

    public CompanySettings getCompanySettings(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (CompanySettings)this.getCompanySettingsHistory().getItem(effectiveFrom, validFrom);
    }

    public CompanySettings[] getActiveEffectiveCompanySettingsHistory() {
        CompanySettings[] result = new CompanySettings[this.getCompanySettingsHistory().getItems(VDate.getDateMax()).size()];
        return this.getCompanySettingsHistory().getItems(VDate.getDateMax()).toArray(result);
    }

    public void setCompanySettingsHistory(CompanySettings cs, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        CompanySettings[] changedArray;
        cs.checkAttributes();
        if (DateHelper.equal((Date)cs.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = PCompany.listToCompanySettingsArray(this.getCompanySettingsHistory().setItem((PersonnelTimedPersistenceObject)cs, removeNew));
        } else {
            removeNew = true;
            changedArray = PCompany.listToCompanySettingsArray(this.getCompanySettingsHistory().addItem((PersonnelTimedPersistenceObject)cs, removeNew));
            if (changedArray.length == 1 && DateHelper.after((Date)cs.getEffectiveFrom(), (Date)cs.getValidFrom())) {
                cs.setEffectiveFrom(cs.getValidFrom());
            }
        }
        for (CompanySettings lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    public CompanySettings[] getEffectiveCompanySettingsHistory(Date effectivTimePoint) {
        return this.getCompanySettingsHistory(effectivTimePoint);
    }

    public CompanySettings[] getCompanySettingsHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new CompanySettings[0];
        }
        return PCompany.listToCompanySettingsArray(this.getCompanySettingsHistory().getItems(effectivTimePoint));
    }

    public CompanySettings[] getCompanySettingsTimePeriods(CompanySettings ptpo) {
        return (CompanySettings[])this.getCompanySettingsHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public void addCompanyDisabilityTPHistory(CompanyDisabilityTP dTP, boolean removeNew) throws BusinessDomainException {
        dTP.checkAttributes();
        CompanyDisabilityTP[] changedArray = PCompany.listToCompanyDisabilityTPArray(this.getCompanyDisabilityTPHistory().addItem((PersonnelTimedPersistenceObject)dTP, removeNew));
        if (changedArray.length == 1 && DateHelper.after((Date)dTP.getEffectiveFrom(), (Date)dTP.getValidFrom())) {
            dTP.setEffectiveFrom(dTP.getValidFrom());
        }
        for (CompanyDisabilityTP lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    private static CompanyDisabilityTP[] listToCompanyDisabilityTPArray(List<CompanyDisabilityTP> list) {
        CompanyDisabilityTP[] CFdata = new CompanyDisabilityTP[list.size()];
        return list.toArray(CFdata);
    }

    public PersonnelHistory<CompanyDisabilityTP> getCompanyDisabilityTPHistory() {
        this.requireLoaded();
        if (this.mCompanyDisabilityTPHistory == null) {
            this.mCompanyDisabilityTPHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getPCompanyDisabilityTPHistory());
        }
        return this.mCompanyDisabilityTPHistory;
    }

    public CompanyDisabilityTP[] getPCompanyDisabilityTPHistory() {
        if (this.isNew()) {
            return new CompanyDisabilityTP[0];
        }
        return CompanyDisabilityTPPersistencyManager.getCompanyDisabilityTPHistory((PCompany)this);
    }

    public static CompanyDisabilityTP[] getActiveCompanyDisabilityTP(CCompanyFoundationsFilterStruct[] filters, Order[] sortierung) {
        CompanyDisabilityTP[] dTP = CompanyDisabilityTPPersistencyManager.queryAll((Order[])sortierung, (Criterion)CompanyFoundationsFilterStructMapper.toFilter((CCompanyFoundationsFilterStruct[])filters));
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(dTP, new CompanyDisabilityTPComparator());
        }
        return dTP;
    }

    public CompanyDisabilityTP getActiveCompanyDisabilityTP() {
        CompanyDisabilityTP[] dTPt = CompanyDisabilityTPPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (PCompany)this);
        if (dTPt.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return dTPt[0];
    }

    public CompanyDisabilityTP getCompanyDisabilityTP(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (CompanyDisabilityTP)this.getCompanyDisabilityTPHistory().getItem(effectiveFrom, validFrom);
    }

    public CompanyDisabilityTP[] getActiveEffectiveCompanyDisabilityTPHistory() {
        CompanyDisabilityTP[] result = new CompanyDisabilityTP[this.getCompanyDisabilityTPHistory().getItems(VDate.getDateMax()).size()];
        return this.getCompanyDisabilityTPHistory().getItems(VDate.getDateMax()).toArray(result);
    }

    public void setCompanyDisabilityTPHistory(CompanyDisabilityTP dTP, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        CompanyDisabilityTP[] changedArray;
        dTP.checkAttributes();
        if (DateHelper.equal((Date)dTP.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = PCompany.listToCompanyDisabilityTPArray(this.getCompanyDisabilityTPHistory().setItem((PersonnelTimedPersistenceObject)dTP, removeNew));
        } else {
            removeNew = true;
            changedArray = PCompany.listToCompanyDisabilityTPArray(this.getCompanyDisabilityTPHistory().addItem((PersonnelTimedPersistenceObject)dTP, removeNew));
            if (changedArray.length == 1 && DateHelper.after((Date)dTP.getEffectiveFrom(), (Date)dTP.getValidFrom())) {
                dTP.setEffectiveFrom(dTP.getValidFrom());
            }
        }
        for (CompanyDisabilityTP lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    public CompanyDisabilityTP[] getEffectiveCompanyDisabilityTPHistory(Date effectivTimePoint) {
        return this.getCompanyDisabilityTPHistory(effectivTimePoint);
    }

    public CompanyDisabilityTP[] getCompanyDisabilityTPHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new CompanyDisabilityTP[0];
        }
        return PCompany.listToCompanyDisabilityTPArray(this.getCompanyDisabilityTPHistory().getItems(effectivTimePoint));
    }

    public CompanyDisabilityTP[] getCompanyDisabilityTPTimePeriods(CompanyDisabilityTP ptpo) {
        return (CompanyDisabilityTP[])this.getCompanyDisabilityTPHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public void transferRehaDatElan(String notificationYear, Date orderFrom, Date orderUntil, String pathName) throws BusinessDomainException {
        new CompanyDisabilityTransfer(this, notificationYear, orderFrom, orderUntil, pathName).transferRehaDatElan();
    }

    public void addCompanyTaxOfficeHistory(CompanyTaxOffice cto, boolean removeNew) throws BusinessDomainException {
        cto.checkAttributes();
        CompanyTaxOffice[] changedArray = PCompany.listToCompanyTaxOfficeArray(this.getCompanyTaxOfficeHistory().addItem((PersonnelTimedPersistenceObject)cto, removeNew));
        if (changedArray.length == 1 && DateHelper.after((Date)cto.getEffectiveFrom(), (Date)cto.getValidFrom())) {
            cto.setEffectiveFrom(cto.getValidFrom());
        }
        for (CompanyTaxOffice lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    private static CompanyTaxOffice[] listToCompanyTaxOfficeArray(List<CompanyTaxOffice> list) {
        CompanyTaxOffice[] CTOdata = new CompanyTaxOffice[list.size()];
        return list.toArray(CTOdata);
    }

    public PersonnelHistory<CompanyTaxOffice> getCompanyTaxOfficeHistory() {
        this.requireLoaded();
        if (this.mCompanyTaxOfficeHistory == null) {
            this.mCompanyTaxOfficeHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getPCompanyTaxOfficeHistory());
        }
        return this.mCompanyTaxOfficeHistory;
    }

    public CompanyTaxOffice[] getPCompanyTaxOfficeHistory() {
        if (this.isNew()) {
            return new CompanyTaxOffice[0];
        }
        return CompanyTaxOfficePersistencyManager.getCompanyTaxOfficeHistory((PCompany)this);
    }

    public CompanyTaxOffice getActiveCompanyTaxOffice() {
        CompanyTaxOffice[] ctoArray = CompanyTaxOfficePersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (PCompany)this);
        if (ctoArray.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return ctoArray[0];
    }

    public static CompanyTaxOffice[] getActiveCompanyTaxOffice(CCompanyFoundationsFilterStruct[] filters, Order[] sortierung) {
        CompanyTaxOffice[] cto = CompanyTaxOfficePersistencyManager.queryAll((Order[])sortierung, (Criterion)CompanyFoundationsFilterStructMapper.toFilter((CCompanyFoundationsFilterStruct[])filters), (boolean)true);
        return cto;
    }

    public CompanyTaxOffice getCompanyTaxOffice(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (CompanyTaxOffice)this.getCompanyTaxOfficeHistory().getItem(effectiveFrom, validFrom);
    }

    public CompanyTaxOffice getCompanyTaxOfficeOrNull(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (CompanyTaxOffice)this.getCompanyTaxOfficeHistory().getItemOrNull(effectiveFrom, validFrom);
    }

    public CompanyTaxOffice[] getActiveEffectiveCompanyTaxOfficeHistory() {
        CompanyTaxOffice[] result = new CompanyTaxOffice[this.getCompanyTaxOfficeHistory().getItems(VDate.getDateMax()).size()];
        return this.getCompanyTaxOfficeHistory().getItems(VDate.getDateMax()).toArray(result);
    }

    public void setCompanyTaxOfficeHistory(CompanyTaxOffice cs, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        CompanyTaxOffice[] changedArray;
        cs.checkAttributes();
        if (DateHelper.equal((Date)cs.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = PCompany.listToCompanyTaxOfficeArray(this.getCompanyTaxOfficeHistory().setItem((PersonnelTimedPersistenceObject)cs, removeNew));
        } else {
            removeNew = true;
            changedArray = PCompany.listToCompanyTaxOfficeArray(this.getCompanyTaxOfficeHistory().addItem((PersonnelTimedPersistenceObject)cs, removeNew));
            if (changedArray.length == 1 && DateHelper.after((Date)cs.getEffectiveFrom(), (Date)cs.getValidFrom())) {
                cs.setEffectiveFrom(cs.getValidFrom());
            }
        }
        for (CompanyTaxOffice lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    public CompanyTaxOffice[] getEffectiveCompanyTaxOfficeHistory(Date effectivTimePoint) {
        return this.getCompanyTaxOfficeHistory(effectivTimePoint);
    }

    public CompanyTaxOffice[] getCompanyTaxOfficeHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new CompanyTaxOffice[0];
        }
        return PCompany.listToCompanyTaxOfficeArray(this.getCompanyTaxOfficeHistory().getItems(effectivTimePoint));
    }

    public CompanyTaxOffice[] getCompanyTaxOfficeTimePeriods(CompanyTaxOffice ptpo) {
        return (CompanyTaxOffice[])this.getCompanyTaxOfficeHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public void addCompanyEmploymentOfficeHistory(CompanyEmploymentOffice ceo, boolean removeNew) throws BusinessDomainException {
        ceo.checkAttributes();
        CompanyEmploymentOffice[] changedArray = PCompany.listToCompanyEmploymentOfficeArray(this.getCompanyEmploymentOfficeHistory().addItem((PersonnelTimedPersistenceObject)ceo, removeNew));
        if (changedArray.length == 1 && DateHelper.after((Date)ceo.getEffectiveFrom(), (Date)ceo.getValidFrom())) {
            ceo.setEffectiveFrom(ceo.getValidFrom());
        }
        for (CompanyEmploymentOffice lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    private static CompanyEmploymentOffice[] listToCompanyEmploymentOfficeArray(List<CompanyEmploymentOffice> list) {
        CompanyEmploymentOffice[] CEOdata = new CompanyEmploymentOffice[list.size()];
        return list.toArray(CEOdata);
    }

    public PersonnelHistory<CompanyEmploymentOffice> getCompanyEmploymentOfficeHistory() {
        this.requireLoaded();
        if (this.mCompanyEmploymentOfficeHistory == null) {
            this.mCompanyEmploymentOfficeHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getPCompanyEmploymentOfficeHistory());
        }
        return this.mCompanyEmploymentOfficeHistory;
    }

    public CompanyEmploymentOffice[] getPCompanyEmploymentOfficeHistory() {
        if (this.isNew()) {
            return new CompanyEmploymentOffice[0];
        }
        return CompanyEmploymentOfficePersistencyManager.getCompanyEmploymentOfficeHistory((PCompany)this);
    }

    public CompanyEmploymentOffice getActiveCompanyEmploymentOffice() {
        CompanyEmploymentOffice[] ctoArray = CompanyEmploymentOfficePersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (PCompany)this);
        if (ctoArray.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return ctoArray[0];
    }

    public static CompanyEmploymentOffice[] getActiveCompanyEmploymentOffice(CCompanyFoundationsFilterStruct[] filters, Order[] sortierung) {
        CompanyEmploymentOffice[] ceo = CompanyEmploymentOfficePersistencyManager.queryAll((Order[])sortierung, (Criterion)CompanyFoundationsFilterStructMapper.toFilter((CCompanyFoundationsFilterStruct[])filters), (boolean)true);
        return ceo;
    }

    public CompanyEmploymentOffice getCompanyEmploymentOffice(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (CompanyEmploymentOffice)this.getCompanyEmploymentOfficeHistory().getItem(effectiveFrom, validFrom);
    }

    public CompanyEmploymentOffice[] getActiveEffectiveCompanyEmploymentOfficeHistory() {
        CompanyEmploymentOffice[] result = new CompanyEmploymentOffice[this.getCompanyEmploymentOfficeHistory().getItems(VDate.getDateMax()).size()];
        return this.getCompanyEmploymentOfficeHistory().getItems(VDate.getDateMax()).toArray(result);
    }

    public void setCompanyEmploymentOfficeHistory(CompanyEmploymentOffice cs, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        CompanyEmploymentOffice[] changedArray;
        cs.checkAttributes();
        if (DateHelper.equal((Date)cs.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = PCompany.listToCompanyEmploymentOfficeArray(this.getCompanyEmploymentOfficeHistory().setItem((PersonnelTimedPersistenceObject)cs, removeNew));
        } else {
            removeNew = true;
            changedArray = PCompany.listToCompanyEmploymentOfficeArray(this.getCompanyEmploymentOfficeHistory().addItem((PersonnelTimedPersistenceObject)cs, removeNew));
            if (changedArray.length == 1 && DateHelper.after((Date)cs.getEffectiveFrom(), (Date)cs.getValidFrom())) {
                cs.setEffectiveFrom(cs.getValidFrom());
            }
        }
        for (CompanyEmploymentOffice lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    public CompanyEmploymentOffice[] getEffectiveCompanyEmploymentOfficeHistory(Date effectivTimePoint) {
        return this.getCompanyEmploymentOfficeHistory(effectivTimePoint);
    }

    public CompanyEmploymentOffice[] getCompanyEmploymentOfficeHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new CompanyEmploymentOffice[0];
        }
        return PCompany.listToCompanyEmploymentOfficeArray(this.getCompanyEmploymentOfficeHistory().getItems(effectivTimePoint));
    }

    public CompanyEmploymentOffice[] getCompanyEmploymentOfficeTimePeriods(CompanyEmploymentOffice ptpo) {
        return (CompanyEmploymentOffice[])this.getCompanyEmploymentOfficeHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public void addCompanyCommunityHistory(CompanyCommunity ceo, boolean removeNew) throws BusinessDomainException {
        ceo.checkAttributes();
        CompanyCommunity[] changedArray = PCompany.listToCompanyCommunityArray(this.getCompanyCommunityHistory().addItem((PersonnelTimedPersistenceObject)ceo, removeNew));
        if (changedArray.length == 1 && DateHelper.after((Date)ceo.getEffectiveFrom(), (Date)ceo.getValidFrom())) {
            ceo.setEffectiveFrom(ceo.getValidFrom());
        }
        for (CompanyCommunity lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    private static CompanyCommunity[] listToCompanyCommunityArray(List<CompanyCommunity> list) {
        CompanyCommunity[] CEOdata = new CompanyCommunity[list.size()];
        return list.toArray(CEOdata);
    }

    private PersonnelHistory<CompanyCommunity> getCompanyCommunityHistory() {
        this.requireLoaded();
        if (this.mCompanyCommunityHistory == null) {
            this.mCompanyCommunityHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getPCompanyCommunityHistory());
        }
        return this.mCompanyCommunityHistory;
    }

    public CompanyCommunity[] getPCompanyCommunityHistory() {
        if (this.isNew()) {
            return new CompanyCommunity[0];
        }
        return CompanyCommunityPersistencyManager.getCompanyCommunityHistory((PCompany)this);
    }

    public static CompanyCommunity[] getActiveCompanyCommunity(CCompanyFoundationsFilterStruct[] filters, Order[] sortierung) {
        CompanyCommunity[] cc = CompanyCommunityPersistencyManager.queryAll((Order[])sortierung, (Criterion)CompanyFoundationsFilterStructMapper.toFilter((CCompanyFoundationsFilterStruct[])filters), (boolean)true);
        return cc;
    }

    public CompanyCommunity getActiveCompanyCommunity() {
        CompanyCommunity[] cco = CompanyCommunityPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (PCompany)this);
        if (cco.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return cco[0];
    }

    public CompanyCommunity getCompanyCommunity(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (CompanyCommunity)this.getCompanyCommunityHistory().getItem(effectiveFrom, validFrom);
    }

    public CompanyCommunity[] getActiveEffectiveCompanyCommunityHistory() {
        CompanyCommunity[] result = new CompanyCommunity[this.getCompanyCommunityHistory().getItems(VDate.getDateMax()).size()];
        return this.getCompanyCommunityHistory().getItems(VDate.getDateMax()).toArray(result);
    }

    public void setCompanyCommunityHistory(CompanyCommunity cs, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        CompanyCommunity[] changedArray;
        cs.checkAttributes();
        if (DateHelper.equal((Date)cs.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = PCompany.listToCompanyCommunityArray(this.getCompanyCommunityHistory().setItem((PersonnelTimedPersistenceObject)cs, removeNew));
        } else {
            removeNew = true;
            changedArray = PCompany.listToCompanyCommunityArray(this.getCompanyCommunityHistory().addItem((PersonnelTimedPersistenceObject)cs, removeNew));
            if (changedArray.length == 1 && DateHelper.after((Date)cs.getEffectiveFrom(), (Date)cs.getValidFrom())) {
                cs.setEffectiveFrom(cs.getValidFrom());
            }
        }
        for (CompanyCommunity lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    public CompanyCommunity[] getEffectiveCompanyCommunityHistory(Date effectivTimePoint) {
        return this.getCompanyCommunityHistory(effectivTimePoint);
    }

    public CompanyCommunity[] getCompanyCommunityHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new CompanyCommunity[0];
        }
        return PCompany.listToCompanyCommunityArray(this.getCompanyCommunityHistory().getItems(effectivTimePoint));
    }

    public CompanyCommunity[] getCompanyCommunityTimePeriods(CompanyCommunity ptpo) {
        return (CompanyCommunity[])this.getCompanyCommunityHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public CompanyCommunity[] getPCompanyInstitutionHistory() {
        return this.getPCompanyCommunityHistory();
    }

    public CompanyCommunity[] getEffectiveCompanyInstitutionsHistory(Date effectivTimePoint) {
        return this.getEffectiveCompanyCommunityHistory(effectivTimePoint);
    }

    public CompanyCommunity[] getActiveEffectiveCompanyInstitutionsHistory() {
        return this.getActiveEffectiveCompanyCommunityHistory();
    }

    @Deprecated
    public CompanyFoundations getObjectFromObjectId(Date eTP, Date vTP) throws BusinessDomainException {
        eTP = this.checkTimePoint(eTP, vTP);
        CompanyFoundations[] cf = CompanyFoundationsPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)eTP)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)eTP)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)vTP)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)vTP))}), (PCompany)this);
        if (cf.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return cf[0];
    }

    public CompanyNote[] getCompanyNote() {
        this.requireLoaded();
        if (this.mCompanyNote == null) {
            this.mCompanyNote = this.isNew() ? new CompanyNote[0] : CompanyNotePersistencyManager.getCompanyNotes((PCompany)this);
        }
        return this.mCompanyNote;
    }

    public void setCompanyNote(CompanyNote[] aPRN) throws BusinessDomainException {
        if (this.getCompanyNote() != null) {
            for (CompanyNote lElement : this.mCompanyNote) {
                boolean delete = true;
                if (aPRN.length == 0) {
                    delete = true;
                } else {
                    for (CompanyNote lElement2 : aPRN) {
                        if (!StringMapper.equal((String)lElement.getObjectid(), (String)lElement2.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                lElement.makeSaveable();
                lElement.destroy();
            }
        }
        for (CompanyNote lElement : aPRN) {
            lElement.makeSaveable();
        }
        this.mCompanyNote = aPRN;
    }

    public CompanyContact[] getCompanyContact() {
        this.requireLoaded();
        if (this.mCompanyContact == null) {
            this.mCompanyContact = this.isNew() ? new CompanyContact[0] : CompanyContactPersistencyManager.getCompanyContacts((PCompany)this);
        }
        return this.mCompanyContact;
    }

    public void setCompanyContact(CompanyContact[] aPRC) throws BusinessDomainException {
        if (this.getCompanyContact() != null) {
            for (CompanyContact lElement : this.mCompanyContact) {
                boolean delete = true;
                if (aPRC.length == 0) {
                    delete = true;
                } else {
                    for (CompanyContact lElement2 : aPRC) {
                        if (!StringMapper.equal((String)lElement.getObjectid(), (String)lElement2.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                lElement.makeSaveable();
                lElement.destroy();
            }
        }
        for (CompanyContact lElement : aPRC) {
            lElement.makeSaveable();
        }
        this.mCompanyContact = aPRC;
    }

    public CompanyDisabilityNote[] getCompanyDisabilityNote() {
        this.requireLoaded();
        if (this.mCompanyDisabilityNote == null) {
            this.mCompanyDisabilityNote = this.isNew() ? new CompanyDisabilityNote[0] : CompanyDisabilityNotePersistencyManager.getCompanyDisabilityNotes((PCompany)this);
        }
        return this.mCompanyDisabilityNote;
    }

    public void setCompanyDisabilityNote(CompanyDisabilityNote[] note) throws BusinessDomainException {
        if (this.getCompanyDisabilityNote() != null) {
            for (CompanyDisabilityNote lElement : this.mCompanyDisabilityNote) {
                boolean delete = true;
                if (note.length == 0) {
                    delete = true;
                } else {
                    for (CompanyDisabilityNote lElement2 : note) {
                        if (!StringMapper.equal((String)lElement.getObjectid(), (String)lElement2.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                lElement.makeSaveable();
                lElement.destroy();
            }
        }
        for (CompanyDisabilityNote lElement : note) {
            lElement.makeSaveable();
        }
        this.mCompanyDisabilityNote = note;
    }

    public CompanyDisabilityContact[] getCompanyDisabilityContact() {
        this.requireLoaded();
        if (this.mCompanyDisabilityContact == null) {
            this.mCompanyDisabilityContact = this.isNew() ? new CompanyDisabilityContact[0] : CompanyDisabilityContactPersistencyManager.getCompanyDisabilityContacts((PCompany)this);
        }
        return this.mCompanyDisabilityContact;
    }

    public void setCompanyDisabilityContact(CompanyDisabilityContact[] contact) throws BusinessDomainException {
        if (this.getCompanyDisabilityContact() != null) {
            for (CompanyDisabilityContact lElement : this.mCompanyDisabilityContact) {
                boolean delete = true;
                if (contact.length == 0) {
                    delete = true;
                } else {
                    for (CompanyDisabilityContact lElement2 : contact) {
                        if (!StringMapper.equal((String)lElement.getObjectid(), (String)lElement2.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                lElement.makeSaveable();
                lElement.destroy();
            }
        }
        for (CompanyDisabilityContact lElement : contact) {
            lElement.makeSaveable();
        }
        this.mCompanyDisabilityContact = contact;
    }

    public CompanyOrderDisability[] getCompanyOrderDisability() {
        this.requireLoaded();
        if (this.mCompanyOrderDisability == null) {
            this.mCompanyOrderDisability = this.isNew() ? new CompanyOrderDisability[0] : CompanyOrderDisabilityPersistencyManager.getCompanyOrderDisabilitys((PCompany)this);
        }
        return this.mCompanyOrderDisability;
    }

    public void setCompanyOrderDisability(CompanyOrderDisability[] order) throws BusinessDomainException {
        if (this.getCompanyOrderDisability() != null) {
            for (CompanyOrderDisability lElement : this.mCompanyOrderDisability) {
                boolean delete = true;
                if (order.length == 0) {
                    delete = true;
                } else {
                    for (CompanyOrderDisability lElement2 : order) {
                        if (!StringMapper.equal((String)lElement.getObjectid(), (String)lElement2.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                lElement.makeSaveable();
                lElement.destroy();
            }
        }
        for (CompanyOrderDisability lElement : order) {
            lElement.checkAttributes();
            lElement.makeSaveable();
        }
        this.mCompanyOrderDisability = order;
    }

    public CompanyTaxOfficeNote[] getCompanyTaxOfficeNote() {
        this.requireLoaded();
        if (this.mCompanyTaxOfficeNote == null) {
            this.mCompanyTaxOfficeNote = this.isNew() ? new CompanyTaxOfficeNote[0] : CompanyTaxOfficeNotePersistencyManager.getCompanyTaxOfficeNotes((PCompany)this);
        }
        return this.mCompanyTaxOfficeNote;
    }

    public void setCompanyTaxOfficeNote(CompanyTaxOfficeNote[] cTON) throws BusinessDomainException {
        if (this.getCompanyTaxOfficeNote() != null) {
            for (CompanyTaxOfficeNote lElement : this.mCompanyTaxOfficeNote) {
                boolean delete = true;
                if (cTON.length == 0) {
                    delete = true;
                } else {
                    for (CompanyTaxOfficeNote lElement2 : cTON) {
                        if (!StringMapper.equal((String)lElement.getObjectid(), (String)lElement2.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                lElement.makeSaveable();
                lElement.destroy();
            }
        }
        for (CompanyTaxOfficeNote lElement : cTON) {
            lElement.makeSaveable();
        }
        this.mCompanyTaxOfficeNote = cTON;
    }

    public CompanyTaxOfficeContact[] getCompanyTaxOfficeContact() {
        this.requireLoaded();
        if (this.mCompanyTaxOfficeContact == null) {
            this.mCompanyTaxOfficeContact = this.isNew() ? new CompanyTaxOfficeContact[0] : CompanyTaxOfficeContactPersistencyManager.getCompanyTaxOfficeContacts((PCompany)this);
        }
        return this.mCompanyTaxOfficeContact;
    }

    public void setCompanyTaxOfficeContact(CompanyTaxOfficeContact[] cTOC) throws BusinessDomainException {
        if (this.getCompanyTaxOfficeContact() != null) {
            for (int i = 0; i < this.mCompanyTaxOfficeContact.length; ++i) {
                boolean delete = true;
                if (cTOC.length == 0) {
                    delete = true;
                } else {
                    for (CompanyTaxOfficeContact lElement : cTOC) {
                        if (!StringMapper.equal((String)this.mCompanyTaxOfficeContact[i].getObjectid(), (String)lElement.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                this.mCompanyTaxOfficeContact[i].makeSaveable();
                this.mCompanyTaxOfficeContact[i].destroy();
            }
        }
        for (CompanyTaxOfficeContact lElement : cTOC) {
            lElement.makeSaveable();
        }
        this.mCompanyTaxOfficeContact = cTOC;
    }

    public CompanyEmploymentOfficeNote[] getCompanyEmploymentOfficeNote() {
        this.requireLoaded();
        if (this.mCompanyEmploymentOfficeNote == null) {
            this.mCompanyEmploymentOfficeNote = this.isNew() ? new CompanyEmploymentOfficeNote[0] : CompanyEmploymentOfficeNotePersistencyManager.getCompanyEmploymentOfficeNotes((PCompany)this);
        }
        return this.mCompanyEmploymentOfficeNote;
    }

    public void setCompanyEmploymentOfficeNote(CompanyEmploymentOfficeNote[] cTON) throws BusinessDomainException {
        if (this.getCompanyEmploymentOfficeNote() != null) {
            for (CompanyEmploymentOfficeNote lElement : this.mCompanyEmploymentOfficeNote) {
                boolean delete = true;
                if (cTON.length == 0) {
                    delete = true;
                } else {
                    for (CompanyEmploymentOfficeNote lElement2 : cTON) {
                        if (!StringMapper.equal((String)lElement.getObjectid(), (String)lElement2.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                lElement.makeSaveable();
                lElement.destroy();
            }
        }
        for (CompanyEmploymentOfficeNote lElement : cTON) {
            lElement.makeSaveable();
        }
        this.mCompanyEmploymentOfficeNote = cTON;
    }

    public CompanyEmploymentOfficeContact[] getCompanyEmploymentOfficeContact() {
        this.requireLoaded();
        if (this.mCompanyEmploymentOfficeContact == null) {
            this.mCompanyEmploymentOfficeContact = this.isNew() ? new CompanyEmploymentOfficeContact[0] : CompanyEmploymentOfficeContactPersistencyManager.getCompanyEmploymentOfficeContacts((PCompany)this);
        }
        return this.mCompanyEmploymentOfficeContact;
    }

    public void setCompanyEmploymentOfficeContact(CompanyEmploymentOfficeContact[] cTOC) throws BusinessDomainException {
        if (this.getCompanyEmploymentOfficeContact() != null) {
            for (int i = 0; i < this.mCompanyEmploymentOfficeContact.length; ++i) {
                boolean delete = true;
                if (cTOC.length == 0) {
                    delete = true;
                } else {
                    for (CompanyEmploymentOfficeContact lElement : cTOC) {
                        if (!StringMapper.equal((String)this.mCompanyEmploymentOfficeContact[i].getObjectid(), (String)lElement.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                this.mCompanyEmploymentOfficeContact[i].makeSaveable();
                this.mCompanyEmploymentOfficeContact[i].destroy();
            }
        }
        for (CompanyEmploymentOfficeContact lElement : cTOC) {
            lElement.makeSaveable();
        }
        this.mCompanyEmploymentOfficeContact = cTOC;
    }

    public CompanyCommunityNote[] getCompanyCommunityNote() {
        this.requireLoaded();
        if (this.mCompanyCommunityNote == null) {
            this.mCompanyCommunityNote = this.isNew() ? new CompanyCommunityNote[0] : CompanyCommunityNotePersistencyManager.getCompanyCommunityNotes((PCompany)this);
        }
        return this.mCompanyCommunityNote;
    }

    public void setCompanyCommunityNote(CompanyCommunityNote[] cTON) throws BusinessDomainException {
        if (this.getCompanyCommunityNote() != null) {
            for (CompanyCommunityNote lElement : this.mCompanyCommunityNote) {
                boolean delete = true;
                if (cTON.length == 0) {
                    delete = true;
                } else {
                    for (CompanyCommunityNote lElement2 : cTON) {
                        if (!StringMapper.equal((String)lElement.getObjectid(), (String)lElement2.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                lElement.makeSaveable();
                lElement.destroy();
            }
        }
        for (CompanyCommunityNote lElement : cTON) {
            lElement.makeSaveable();
        }
        this.mCompanyCommunityNote = cTON;
    }

    public CompanyCommunityContact[] getCompanyCommunityContact() {
        this.requireLoaded();
        if (this.mCompanyCommunityContact == null) {
            this.mCompanyCommunityContact = this.isNew() ? new CompanyCommunityContact[0] : CompanyCommunityContactPersistencyManager.getCompanyCommunityContacts((PCompany)this);
        }
        return this.mCompanyCommunityContact;
    }

    public void setCompanyCommunityContact(CompanyCommunityContact[] cTOC) throws BusinessDomainException {
        if (this.getCompanyCommunityContact() != null) {
            for (int i = 0; i < this.mCompanyCommunityContact.length; ++i) {
                boolean delete = true;
                if (cTOC.length == 0) {
                    delete = true;
                } else {
                    for (CompanyCommunityContact lElement : cTOC) {
                        if (!StringMapper.equal((String)this.mCompanyCommunityContact[i].getObjectid(), (String)lElement.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                this.mCompanyCommunityContact[i].makeSaveable();
                this.mCompanyCommunityContact[i].destroy();
            }
        }
        for (CompanyCommunityContact lElement : cTOC) {
            lElement.makeSaveable();
        }
        this.mCompanyCommunityContact = cTOC;
    }

    public AttributiveCompany[] getAttributiveCompany() {
        this.requireLoaded();
        if (this.mAttributiveCompanys == null) {
            this.mAttributiveCompanys = this.isNew() ? new AttributiveCompany[0] : AttributiveCompanyPersistencyManager.getAttributiveCompanys((PCompany)this);
        }
        return this.mAttributiveCompanys;
    }

    public void setAttributiveCompany(AttributiveCompany[] ac) throws BusinessDomainException {
        if (this.getAttributiveCompany() != null) {
            for (AttributiveCompany lElement : this.mAttributiveCompanys) {
                boolean delete = true;
                if (ac.length == 0) {
                    delete = true;
                } else {
                    for (AttributiveCompany lElement2 : ac) {
                        if (!StringMapper.equal((String)lElement.getObjectid(), (String)lElement2.getObjectid())) continue;
                        delete = false;
                    }
                }
                if (!delete) continue;
                lElement.makeSaveable();
                lElement.destroy();
            }
        }
        for (AttributiveCompany lElement : ac) {
            lElement.makeSaveable();
        }
        this.mAttributiveCompanys = ac;
    }

    public void addCompanyAllocationFoundationsHistory(CompanyAllocationFoundationsTP tp, boolean removeNew) throws BusinessDomainException {
        tp.checkAttributes();
        CompanyAllocationFoundationsTP[] changedArray = PCompany.listToCompanyAllocationFoundationsTPArray(this.getCompanyAllocationFoundationsHistory().addItem((PersonnelTimedPersistenceObject)tp, removeNew));
        if (changedArray.length == 1 && DateHelper.after((Date)tp.getEffectiveFrom(), (Date)tp.getValidFrom())) {
            tp.setEffectiveFrom(tp.getValidFrom());
        }
        for (CompanyAllocationFoundationsTP lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    private static CompanyAllocationFoundationsTP[] listToCompanyAllocationFoundationsTPArray(List<CompanyAllocationFoundationsTP> list) {
        CompanyAllocationFoundationsTP[] tpData = new CompanyAllocationFoundationsTP[list.size()];
        return list.toArray(tpData);
    }

    private PersonnelHistory<CompanyAllocationFoundationsTP> getCompanyAllocationFoundationsHistory() {
        this.requireLoaded();
        if (this.mCompanyAllocationFoundationsHistory == null) {
            this.mCompanyAllocationFoundationsHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getPCompanyAllocationFoundationsHistory());
        }
        return this.mCompanyAllocationFoundationsHistory;
    }

    public CompanyAllocationFoundationsTP[] getPCompanyAllocationFoundationsHistory() {
        if (this.isNew()) {
            return new CompanyAllocationFoundationsTP[0];
        }
        return CompanyAllocationFoundationsTPPersistencyManager.getCompanyAllocationFoundationsHistory((PCompany)this);
    }

    public CompanyAllocationFoundationsTP getActiveCompanyAllocationFoundations() {
        CompanyAllocationFoundationsTP[] tpArray = CompanyAllocationFoundationsTPPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (PCompany)this);
        if (tpArray.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return tpArray[0];
    }

    public static CompanyAllocationFoundationsTP[] getActiveCompanyAllocationFoundations(CCompanyFoundationsFilterStruct[] filters, Order[] sortierung) throws BusinessDomainException {
        PCompany pcompany = null;
        if (!StringMapper.isNullString((String)filters[0].pCompanyKey)) {
            Company company = CompanyPersistencyManager.getCompanyByCode((String)filters[0].pCompanyKey);
            PCompany[] pcompanys = PCompanyPersistencyManager.query(null, (Criterion)Restrictions.eq((String)"objectid", (String)company.getObjectid()));
            if (pcompanys.length == 0) {
                return new CompanyAllocationFoundationsTP[0];
            }
            pcompany = pcompanys[0];
        }
        Criterion filter = CompanyAllocationFoundationsFilterStructMapper.toFilter((String)(pcompany == null ? "" : pcompany.getObjectid()), (String)filters[0].location, (String)filters[0].trade, (String)filters[0].postalCode, (String)filters[0].city);
        CompanyAllocationFoundationsTP[] tp = CompanyAllocationFoundationsTPPersistencyManager.queryAll((Order[])sortierung, (Criterion)filter);
        return tp;
    }

    public CompanyAllocationFoundationsTP getCompanyAllocationFoundations(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.requireLoaded();
        return (CompanyAllocationFoundationsTP)this.getCompanyAllocationFoundationsHistory().getItem(effectiveFrom, validFrom);
    }

    public CompanyAllocationFoundationsTP[] getActiveEffectiveCompanyAllocationFoundationsHistory() {
        CompanyAllocationFoundationsTP[] result = new CompanyAllocationFoundationsTP[this.getCompanyAllocationFoundationsHistory().getItems(VDate.getDateMax()).size()];
        return this.getCompanyAllocationFoundationsHistory().getItems(VDate.getDateMax()).toArray(result);
    }

    public void setCompanyAllocationFoundationsHistory(CompanyAllocationFoundationsTP tp, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        CompanyAllocationFoundationsTP[] changedArray;
        tp.checkAttributes();
        if (DateHelper.equal((Date)tp.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = PCompany.listToCompanyAllocationFoundationsTPArray(this.getCompanyAllocationFoundationsHistory().setItem((PersonnelTimedPersistenceObject)tp, removeNew));
        } else {
            removeNew = true;
            changedArray = PCompany.listToCompanyAllocationFoundationsTPArray(this.getCompanyAllocationFoundationsHistory().addItem((PersonnelTimedPersistenceObject)tp, removeNew));
            if (changedArray.length == 1 && DateHelper.after((Date)tp.getEffectiveFrom(), (Date)tp.getValidFrom())) {
                tp.setEffectiveFrom(tp.getValidFrom());
            }
        }
        for (CompanyAllocationFoundationsTP lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    public CompanyAllocationFoundationsTP[] getEffectiveCompanyAllocationFoundationsHistory(Date effectivTimePoint) {
        return this.getCompanyAllocationFoundationsHistory(effectivTimePoint);
    }

    public CompanyAllocationFoundationsTP[] getCompanyAllocationFoundationsHistory(Date effectivTimePoint) {
        this.requireLoaded();
        if (this.isNew()) {
            return new CompanyAllocationFoundationsTP[0];
        }
        return PCompany.listToCompanyAllocationFoundationsTPArray(this.getCompanyAllocationFoundationsHistory().getItems(effectivTimePoint));
    }

    public CompanyAllocationFoundationsTP[] getCompanyAllocationFoundationsTimePeriods(CompanyAllocationFoundationsTP ptpo) {
        return (CompanyAllocationFoundationsTP[])this.getCompanyAllocationFoundationsHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public CompanyAllocationAssignment[] getCompanyAllocationAssignments(CompanyAllocationFoundationsTP caFoundationTP) {
        if (this.isNew()) {
            return new CompanyAllocationAssignment[0];
        }
        if (this.mCompanyAllocationAssignments.length == 0) {
            this.mCompanyAllocationAssignments = CompanyAllocationAssignmentPersistencyManager.getCompanyAllocationAssignments((PCompany)this, (CompanyAllocationFoundationsTP)caFoundationTP);
        }
        return this.mCompanyAllocationAssignments;
    }

    private CompanyAllocationAssignmentTP[] getCompanyAllocationAssignmentHistory() {
        CompanyAllocationAssignment[] boArray = this.getCompanyAllocationAssignments(this.getActiveCompanyAllocationFoundations());
        if (boArray.length > 0) {
            ArrayList<CompanyAllocationAssignmentTP> list = new ArrayList<CompanyAllocationAssignmentTP>();
            for (CompanyAllocationAssignment lElement : boArray) {
                CompanyAllocationAssignmentTP[] tpArray;
                for (CompanyAllocationAssignmentTP lElement2 : tpArray = lElement.getCompanyAllocationAssignmentTPs()) {
                    list.add(lElement2);
                }
            }
            CompanyAllocationAssignmentTP[] array = new CompanyAllocationAssignmentTP[list.size()];
            return list.toArray(array);
        }
        return new CompanyAllocationAssignmentTP[0];
    }

    public CompanyAllocationAssignmentTP[] getEffectiveCompanyAllocationAssignments(Date effectiveTimePoint, Date validTimePoint) {
        CompanyAllocationAssignmentTP[] tpArray = this.getCompanyAllocationAssignmentHistory();
        if (tpArray.length > 0) {
            ArrayList<CompanyAllocationAssignmentTP> list = new ArrayList<CompanyAllocationAssignmentTP>();
            for (CompanyAllocationAssignmentTP lElement : tpArray) {
                if (!DateHelper.afterOrEqual((Date)lElement.getEffectiveFrom(), (Date)effectiveTimePoint) && !lElement.inEffectiveness(effectiveTimePoint) || !DateHelper.afterOrEqual((Date)lElement.getValidFrom(), (Date)validTimePoint) && !lElement.inValidness(validTimePoint)) continue;
                list.add(lElement);
            }
            CompanyAllocationAssignmentTP[] array = new CompanyAllocationAssignmentTP[list.size()];
            return list.toArray(array);
        }
        return new CompanyAllocationAssignmentTP[0];
    }

    public static CostingReportPre[] getCostingReportPres(Criterion filter, Order[] sortierung, boolean readOnly) {
        return CostingReportPrePersistencyManager.query((Order[])sortierung, (Criterion)filter, (boolean)readOnly);
    }

    public CostingReportPre[] getCostingReportPre() {
        if (this.mCostingReportPres.length == 0) {
            this.mCostingReportPres = CostingReportPrePersistencyManager.getCostingReportPre((PCompany)this);
        }
        return this.mCostingReportPres;
    }

    public static ValueTypeDataSheetPre[] getValueTypeDataSheetPres(Criterion filter, Order[] sortierung, boolean readOnly) {
        return ValueTypeDataSheetPrePersistencyManager.query((Order[])sortierung, (Criterion)filter, (boolean)readOnly);
    }

    public ValueTypeDataSheetPre[] getValueTypeDataSheetPre() {
        if (this.mValueTypeDataSheetPres.length == 0) {
            this.mValueTypeDataSheetPres = ValueTypeDataSheetPrePersistencyManager.getValueTypeDataSheetPre((PCompany)this);
        }
        return this.mValueTypeDataSheetPres;
    }

    public static RemainDaysReportPre[] getRemainDaysReportPres(Criterion filter, Order[] sortierung, boolean readOnly) {
        return RemainDaysReportPrePersistencyManager.query((Order[])sortierung, (Criterion)filter, (boolean)readOnly);
    }

    public RemainDaysReportPre[] getRemainDaysReportPre() {
        if (this.mRemainDaysReportPres.length == 0) {
            this.mRemainDaysReportPres = RemainDaysReportPrePersistencyManager.getRemainDaysReportPre((PCompany)this);
        }
        return this.mRemainDaysReportPres;
    }

    public static EEStockReportPre[] getEEStockReportPres(Criterion filter, Order[] sortierung, boolean readOnly) {
        return EEStockReportPrePersistencyManager.query((Order[])sortierung, (Criterion)filter, (boolean)readOnly);
    }

    public EEStockReportPre[] getEEStockReportPre() {
        if (this.mEEStockReportPres.length == 0) {
            this.mEEStockReportPres = EEStockReportPrePersistencyManager.getEEStockReportPres((PCompany)this);
        }
        return this.mEEStockReportPres;
    }

    public static QualiMatrixPre[] getQualiMatrixPres(Criterion filter, Order[] sortierung, boolean readOnly) {
        return QualiMatrixPrePersistencyManager.query((Order[])sortierung, (Criterion)filter, (boolean)readOnly);
    }

    public QualiMatrixPre[] getQualiMatrixPre() {
        if (this.mQualiMatrixPres.length == 0) {
            this.mQualiMatrixPres = QualiMatrixPrePersistencyManager.getQualiMatrixPre((PCompany)this);
        }
        return this.mQualiMatrixPres;
    }

    public Date getStartOfHistory() {
        return CompanyFoundationsPersistencyManager.getStartOfHistory((String)this.getObjectid());
    }

    public boolean hasVWEAccounting(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        if (validTimePoint == null) {
            throw PCompanyExceptionMapper.makeValidTimepointIsEmptyDomainException((String)"hasVWEAccounting");
        }
        if (effectiveTimePoint == null) {
            effectiveTimePoint = validTimePoint;
        } else if (DateHelper.before((Date)effectiveTimePoint, (Date)validTimePoint)) {
            effectiveTimePoint = validTimePoint;
        }
        CompanyFoundations[] cf = CompanyFoundationsPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validTimePoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validTimePoint))}), (PCompany)this);
        boolean hasVWEAccounting = false;
        if (cf.length != 0 && cf[0].getFinancialAccountingProgram().value() == 1) {
            hasVWEAccounting = true;
        }
        return hasVWEAccounting;
    }

    public void existsCompanyAllocationFoundationTP() throws BusinessDomainException {
        long countRow = CompanyAllocationFoundationsTPPersistencyManager.getRowCount((PCompany)this);
        if (countRow != 0L) {
            throw PCompanyExceptionMapper.makeCompanyAllocationFoundationTPAlreadyExistsDomainException();
        }
    }

    public HealthFund getAssessmentHealthFund(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        CompanySettings companySettings;
        HealthFund healthFund;
        block3: {
            healthFund = null;
            companySettings = null;
            try {
                companySettings = this.getCompanySettings(effectiveTimePoint, validTimePoint);
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block3;
                throw e;
            }
        }
        if (companySettings != null) {
            healthFund = companySettings.getSettings().getRateAssessmentAccomplishingHealthFund();
        }
        return healthFund;
    }

    public EEDisabilityTP[] getDisabledEmployeesOfYear(Date timePoint) {
        return EEDisabilityTPPersistencyManager.getDisabledEmployeesOfYear((PCompany)this, (Date)timePoint);
    }

    public CompanyOrderDisability[] getCompanyOrdersDisability(int year) {
        return CompanyOrderDisabilityPersistencyManager.getCompanyOrdersDisability((PCompany)this, (int)year);
    }

    public void existsCompanyTaxOffice() throws BusinessDomainException {
        long countRow = CompanyTaxOfficePersistencyManager.getRowCount((PCompany)this);
        if (countRow != 0L) {
            throw PCompanyExceptionMapper.makeCompanyTaxOfficeAlreadyExistsDomainException();
        }
    }

    public void existsCompanyEmploymentOffice() throws BusinessDomainException {
        long countRow = CompanyEmploymentOfficePersistencyManager.getRowCount((PCompany)this);
        if (countRow != 0L) {
            throw PCompanyExceptionMapper.makeCompanyEmploymentOfficeAlreadyExistsDomainException();
        }
    }

    public void existsCompanyCommunity() throws BusinessDomainException {
        long countRow = CompanyCommunityPersistencyManager.getRowCount((PCompany)this);
        if (countRow != 0L) {
            throw PCompanyExceptionMapper.makeCompanyCommunityAlreadyExistsDomainException();
        }
    }

    public void existsIntegrationOffice() throws BusinessDomainException {
        long countRow = CompanyDisabilityTPPersistencyManager.getRowCount((PCompany)this);
        if (countRow != 0L) {
            throw PCompanyExceptionMapper.makeIntegrationOfficeAlreadyExistsDomainException();
        }
    }

    public void toStringValues(StringBuilder b) {
        b.append(this.getPCompanyKey()).append(',');
    }

    public CompanyFoundations getCompanyFoundations(String effectiveTimePoint, String validTimePoint) throws BusinessDomainException {
        Date effectiveFrom = DateMapper.toDate((String)effectiveTimePoint);
        Date validFrom = DateMapper.toDate((String)validTimePoint);
        return this.getCompanyFoundations(this.checkTimePoint(effectiveFrom, validFrom), validFrom);
    }

    public CompanySettings getCompanySettings(String effectiveTimePoint, String validTimePoint) throws BusinessDomainException {
        Date effectiveFrom = DateMapper.toDate((String)effectiveTimePoint);
        Date validFrom = DateMapper.toDate((String)validTimePoint);
        return this.getCompanySettings(this.checkTimePoint(effectiveFrom, validFrom), validFrom);
    }

    private Date checkTimePoint(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        if (validFrom == null) {
            throw PCompanyExceptionMapper.makeValidTimepointIsEmptyDomainException((String)"checkTimePoint");
        }
        if (effectiveFrom == null || DateHelper.before((Date)effectiveFrom, (Date)validFrom)) {
            return validFrom;
        }
        return effectiveFrom;
    }

    public String[] getApprentices(Date validFrom, Date validUntil) {
        Insurance[] insurances = this.getIInsurancePM().queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom)), Restrictions.le((String)"dateofentry", (String)DateMapper.toString((Date)validUntil)), Restrictions.or((Criterion)Restrictions.ge((String)"dateofwithdrawal", (String)DateMapper.toString((Date)validFrom)), (Criterion)Restrictions.isNull((String)"dateofwithdrawal")), Restrictions.or((Criterion)Restrictions.eq((String)"persongroup", (String)"102"), (Criterion)Restrictions.eq((String)"persongroup", (String)"105"))}), true);
        if (insurances.length == 0) {
            return new String[0];
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Insurance lInsurance : insurances) {
            String oidEmployee = lInsurance.getEmployee().getObjectid();
            map.put(oidEmployee, oidEmployee);
        }
        return map.keySet().toArray(new String[map.keySet().size()]);
    }

    public void checkVWECostCenter(CostCenter costCenter, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        CompanyFoundations cf;
        if (costCenter != null && (cf = this.getCompanyFoundations(effectiveFrom, validFrom)).useCostCenterFromCosting() && !costCenter.isVWECostCenter(cf.getCostingCompanyForCostCenter(), validFrom)) {
            throw PCompanyExceptionMapper.makeVWECostCenterMissingDomainException((String)costCenter.getCostCenter());
        }
    }

    public void comparisonCostCenterWithCosting(String oidCompany, Date validFrom) throws BusinessDomainException {
        if (!this.getCompanyFoundations(validFrom, validFrom).useCostCenterFromCosting()) {
            throw DesignationExceptionMapper.makeComparisonCostcenterCostunitNotAllowedDomainException();
        }
        CostingCostCenter costCenter = new CostingCostCenter("", oidCompany, "", validFrom, null, "", "");
        BODService ims = (BODService)UtilitiesManager.getBean((String)"igf.integration.internal.BODService", BODService.class);
        BusinessObjectDocument result = ims.process((BusinessObjectDocument)BusinessObjectDocumentFactory.createGetDocument((Fortress)Fortress.PAYROLL, (Fortress)Fortress.COSTING, (Noun)Noun.COSTCENTER, (Object)costCenter));
        if (result.isConfirmDocument()) {
            ConfirmDocument cd = (ConfirmDocument)result;
            if (cd.hasErrors()) {
                throw new IntegrationException(((Failure)cd.getErrors().get(0)).getMessage());
            }
            throw new IllegalStateException("Fehler bei \u00dcbernahme der Kostenstellen");
        }
        ShowDocument sd = (ShowDocument)result;
        List data = sd.getData();
        this.comparison(validFrom, data.toArray(new ICostCenter[data.size()]));
    }

    private void comparison(Date validTimePoint, ICostCenter[] costCenters) throws BusinessDomainException {
        for (ICostCenter costCenter : costCenters) {
            CostCenter pCostCenter = CostCenter.getCostCenterByDomainKey((PCompany)this, (String)costCenter.getCostCentreCode());
            if (pCostCenter != null) continue;
            Date startOfHistory = this.getStartOfHistory();
            Date systemStart = PersonnelBasic.getPersonnelBasic().getSystemStart();
            Date validFrom = DateHelper.getFirstDayOfMonth((Date)validTimePoint);
            if (DateHelper.before((Date)validFrom, (Date)costCenter.getValidFrom())) {
                validFrom = costCenter.getValidFrom();
            }
            if (DateHelper.before((Date)validFrom, (Date)startOfHistory)) {
                validFrom = startOfHistory;
            }
            pCostCenter = new CostCenter(this);
            pCostCenter.setCostCenter(costCenter.getCostCentreCode());
            CostCenterTP pCostCenterTP = new CostCenterTP(pCostCenter);
            pCostCenterTP.setEffectiveFrom(systemStart);
            pCostCenterTP.setEffectiveUntil(VDate.getDateMax());
            pCostCenterTP.setValidFrom(validFrom);
            pCostCenterTP.setValidUntil(VDate.getDateMax());
            pCostCenterTP.setShortDescription(costCenter.getShortDescription());
            pCostCenterTP.setLongDescription(costCenter.getLongDescription());
            pCostCenterTP.setPayrollHandling(false);
            pCostCenter.addHistory((PersonnelTimedPersistenceObject)pCostCenterTP, true);
        }
    }

    public void comparisonCostUnitWithCosting(String oidCompany, Date validFrom) throws BusinessDomainException {
        if (!this.getCompanyFoundations(validFrom, validFrom).useCostUnitFromCosting()) {
            throw DesignationExceptionMapper.makeComparisonCostcenterCostunitNotAllowedDomainException();
        }
        CostingCostUnit costUnit = new CostingCostUnit("", oidCompany, "", validFrom, null, "", "");
        BODService ims = (BODService)UtilitiesManager.getBean((String)"igf.integration.internal.BODService", BODService.class);
        BusinessObjectDocument result = ims.process((BusinessObjectDocument)BusinessObjectDocumentFactory.createGetDocument((Fortress)Fortress.PAYROLL, (Fortress)Fortress.COSTING, (Noun)Noun.COSTUNIT, (Object)costUnit));
        if (result.isConfirmDocument()) {
            ConfirmDocument cd = (ConfirmDocument)result;
            if (cd.hasErrors()) {
                throw new IntegrationException(((Failure)cd.getErrors().get(0)).getMessage());
            }
            throw new IllegalStateException("Fehler bei \u00dcbernahme der Kostentr\u00e4ger");
        }
        ShowDocument sd = (ShowDocument)result;
        List data = sd.getData();
        this.comparison(validFrom, data.toArray(new ICostUnit[data.size()]));
    }

    private void comparison(Date validTimePoint, ICostUnit[] costUnits) throws BusinessDomainException {
        for (ICostUnit costUnit : costUnits) {
            CostUnit pCostUnit = CostUnit.getCostUnitByDomainKey((PCompany)this, (String)costUnit.getCostUnitCode());
            if (pCostUnit != null) continue;
            Date startOfHistory = this.getStartOfHistory();
            Date systemStart = PersonnelBasic.getPersonnelBasic().getSystemStart();
            Date validFrom = DateHelper.getFirstDayOfMonth((Date)validTimePoint);
            if (DateHelper.before((Date)validFrom, (Date)costUnit.getValidFrom())) {
                validFrom = costUnit.getValidFrom();
            }
            if (DateHelper.before((Date)validFrom, (Date)startOfHistory)) {
                validFrom = startOfHistory;
            }
            pCostUnit = new CostUnit(this);
            pCostUnit.setCostUnit(costUnit.getCostUnitCode());
            CostUnitTP pCostUnitTP = new CostUnitTP(pCostUnit);
            pCostUnitTP.setEffectiveFrom(systemStart);
            pCostUnitTP.setEffectiveUntil(VDate.getDateMax());
            pCostUnitTP.setValidFrom(validFrom);
            pCostUnitTP.setValidUntil(VDate.getDateMax());
            pCostUnitTP.setShortDescription(costUnit.getShortDescription());
            pCostUnitTP.setLongDescription(costUnit.getLongDescription());
            pCostUnitTP.setPayrollHandling(false);
            pCostUnit.addHistory((PersonnelTimedPersistenceObject)pCostUnitTP, true);
        }
    }

    public List<String> specialCheckMembershipNumber() throws BusinessDomainException {
        AssignmentPCompanyAccidentInsuranceFundTP[] apaifTPs;
        ArrayList<String> falseMembershipnumbers = new ArrayList<String>();
        for (AssignmentPCompanyAccidentInsuranceFundTP apaifTP : apaifTPs = AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)DateMapper.toString((Date)VDate.getDateMax())), Restrictions.eq((String)"validuntil", (String)DateMapper.toString((Date)VDate.getDateMax()))}))) {
            String bbnruv;
            String result;
            Date validUntilOfConsolidation;
            if (DateHelper.before((Date)apaifTP.getValidFrom(), (Date)DateHelper.parse((String)"2009-01-01")) || apaifTP.getMembershipNotValid() || (validUntilOfConsolidation = apaifTP.getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund().getAccidentInsuranceFundTP(VDate.getDateMax(), VDate.getDateMax()).getValidUntilOfConsolidation()) != null && DateHelper.before((Date)validUntilOfConsolidation, (Date)new Date()) || StringMapper.isNullString((String)(result = MembershipNumberOfAIF.checkMembershipNumber(bbnruv = apaifTP.getAssignmentPCompanyAccidentInsuranceFund().getAccidentInsuranceFund().getAccidentInsuranceFundTP(VDate.getDateMax(), VDate.getDateMax()).getStdCompanyNoOfAccIns(), apaifTP.getMembershipNumber())))) continue;
            falseMembershipnumbers.add(apaifTP.getMembershipNumber());
        }
        return falseMembershipnumbers;
    }

    public boolean existsStandardCompanyAccount() {
        long rowCount = CompanyAccountTPPersistencyManager.getRowCount((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"standardaccount", (String)"T")}));
        return rowCount != 0L;
    }

    public static boolean isPayrollCompany(String objectid) {
        PCompany[] bos = PCompanyPersistencyManager.query(null, (Criterion)Restrictions.eq((String)"objectid", (String)objectid));
        return bos.length != 0;
    }

    private IInsurancePersistencyManager getIInsurancePM() {
        return (IInsurancePersistencyManager)UtilitiesManager.getBean((String)"insurancePersistencyManager", IInsurancePersistencyManager.class);
    }

    public static TaxNumberBean[] getTaxNumberBean() {
        PlantTaxOffice[] plantTaxOffices;
        CompanyTaxOffice[] companyTaxOffices;
        ArrayList<TaxNumberBean> taxNumberBeans = new ArrayList<TaxNumberBean>();
        for (CompanyTaxOffice companyTaxOffice : companyTaxOffices = CompanyTaxOfficePersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), (boolean)true)) {
            String taxNumber = companyTaxOffice.getGeneralTaxOffice().getTaxNumber();
            String taxOfficeKey = companyTaxOffice.getGeneralTaxOffice().getTaxOffice().getTaxOffice();
            int bundesland = StringMapper.isNullString((String)taxOfficeKey) ? 0 : Integer.parseInt(taxOfficeKey.substring(0, 2));
            String convertedTaxNumber = PCompany.getEmployerPartElsterTaxNumber(taxNumber, bundesland);
            taxNumberBeans.add(new TaxNumberBean(companyTaxOffice.getPCompany(), null, companyTaxOffice.getGeneralTaxOffice(), convertedTaxNumber));
        }
        for (PlantTaxOffice plantTaxOffice : plantTaxOffices = PlantTaxOfficePersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}))) {
            String taxNumber = plantTaxOffice.getGeneralTaxOffice().getTaxNumber();
            if (StringMapper.isNullString((String)taxNumber)) continue;
            String taxOfficeKey = plantTaxOffice.getGeneralTaxOffice().getTaxOffice().getTaxOffice();
            int bundesland = StringMapper.isNullString((String)taxOfficeKey) ? 0 : Integer.parseInt(taxOfficeKey.substring(0, 2));
            String convertedTaxNumber = PCompany.getEmployerPartElsterTaxNumber(taxNumber, bundesland);
            taxNumberBeans.add(new TaxNumberBean(plantTaxOffice.getPlant().getHeadCompany(), plantTaxOffice.getPlant(), plantTaxOffice.getGeneralTaxOffice(), convertedTaxNumber));
        }
        return taxNumberBeans.toArray(new TaxNumberBean[taxNumberBeans.size()]);
    }

    public static String getEmployerPartElsterTaxNumber(String taxNumber, int bundesland) {
        if (StringMapper.isNullString((String)taxNumber)) {
            return "";
        }
        if (bundesland == 0) {
            return "";
        }
        taxNumber = StringMapper.replaceAllSubString((String)taxNumber, (String)",", (String)"");
        taxNumber = StringMapper.replaceAllSubString((String)taxNumber, (String)".", (String)"");
        taxNumber = StringMapper.replaceAllSubString((String)taxNumber, (String)" ", (String)"");
        taxNumber = StringMapper.replaceAllSubString((String)taxNumber, (String)"/", (String)"");
        taxNumber = StringMapper.replaceAllSubString((String)taxNumber, (String)"|", (String)"");
        taxNumber = StringMapper.replaceAllSubString((String)taxNumber, (String)"-", (String)"");
        taxNumber = StringMapper.replaceAllSubString((String)taxNumber, (String)"\\", (String)"");
        switch (bundesland) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: {
                taxNumber = taxNumber.substring(2, taxNumber.length());
                break;
            }
            case 10: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 40: 
            case 41: 
            case 51: 
            case 52: 
            case 53: 
            case 91: 
            case 92: {
                taxNumber = taxNumber.substring(3, taxNumber.length());
                break;
            }
            case 11: {
                if (taxNumber.length() <= 8) break;
                taxNumber = taxNumber.substring(2, taxNumber.length());
                break;
            }
            default: {
                LOGGER.debug(" Kein Bundesland");
            }
        }
        return taxNumber;
    }

    public int getNumberOfActivelyEmployedEmployees(Date from, Date until) {
        int number = 0;
        Date fromDate = DateHelper.getLastDayOfMonth((Date)from);
        Date untilDate = DateHelper.getLastDayOfMonth((Date)until);
        while (DateHelper.beforeOrEqual((Date)fromDate, (Date)untilDate)) {
            number += this.getNumberOfActivelyEmployedEmployees(fromDate);
            fromDate = PDateHelper.getLastDayNextMonth((Date)fromDate);
        }
        return number;
    }

    public int getNumberOfActivelyEmployedEmployees(Date month) {
        Employment[] employments;
        int number = 0;
        Date effectiveTimePoint = VDate.getDateMax();
        Date validTimePoint = DateHelper.getLastDayOfMonth((Date)month);
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)this.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validTimePoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validTimePoint))});
        for (Employment each : employments = PCompany.getEmploymentPM().queryAll(null, (Criterion)filter, true)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("### Monat: " + DateMapper.toDDMMYYYYPointSeparationString((Date)month) + " Mitarbeiter: " + each.getEmployee().getDomainKey() + " mit Eintritt: " + DateMapper.toDDMMYYYYPointSeparationString((Date)each.getDateOfEntry()) + " und Austritt: " + DateMapper.toDDMMYYYYPointSeparationString((Date)each.getDateOfWithDrawal()) + " und Nachfolger: " + (each.getEmployee().getSuccessor() != null ? " J " : " N "));
            }
            if (!each.getEmployee().isMonthOfEmployment(month, each) || each.getDateOfWithDrawal() != null && DateHelper.between((Date)each.getDateOfWithDrawal(), (Date)DateHelper.getFirstDayOfMonth((Date)month), (Date)DateHelper.getLastDayOfMonth((Date)month)) && each.getEmployee().getSuccessor() != null) continue;
            ++number;
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("### Anzahl: " + number);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("### Gesamtanzahl: " + number);
        }
        return number;
    }

    private static IEmploymentPersistencyManager getEmploymentPM() {
        return (IEmploymentPersistencyManager)UtilitiesManager.getGenericAccessor().getBean("employmentPersistencyManager", IEmploymentPersistencyManager.class);
    }
}

