/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.fileimport.absenttime;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.base.types.date.GMTCalendar;
import com.varial.framework.domain.fileimport.ImportReader;
import com.varial.framework.domain.fileimport.ImportedLine;
import com.varial.framework.domain.transfer.AbstractTransferSession;
import com.varial.personnel.domain.absenttime.AbsentTimeTP;
import com.varial.personnel.domain.absenttime.AbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.fileimport.absenttime.AbsentTimePositionReader;
import com.varial.personnel.domain.fileimport.absenttime.TransferDataList;
import com.varial.personnel.domain.fileimport.interfaces.AbstractPersonnelFileTransferImporter;
import com.varial.personnel.domain.fileimport.mapper.PersonnelFileImportExceptionMapper;
import com.varial.personnel.domain.fileimport.varpayment.CompanyKeyTranslation;
import com.varial.personnel.domain.transfer.TransferData;
import com.varial.personnel.domain.transfer.absenttime.AbsentDays;
import com.varial.personnel.domain.transfer.absenttime.AbsentDaysAgent;
import com.varial.personnel.domain.transfer.absenttime.TransferAbsentTimeDirect;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class AbsentTimeDirectTransferFileImporterImpl
extends AbstractPersonnelFileTransferImporter {
    private static final String FILE_ABSENTTIMES = "XXSEQSYM";
    private final ImportReader tokenReaderPW;
    private ImportReader currentReader;
    private boolean mStop;
    private ImportedLine mLineForNextRead;
    private TransferDataList transferDataList;

    public AbsentTimeDirectTransferFileImporterImpl() {
        int[] positions = new int[]{0, 3, 6, 12, 18, 25, 31, 62, 63};
        this.tokenReaderPW = new AbsentTimePositionReader(positions);
        this.mLineForNextRead = null;
    }

    protected ImportReader getTokenReader() {
        return this.tokenReaderPW;
    }

    protected ImportReader getCurrentReader() {
        return this.currentReader;
    }

    protected void setCurrentReader(ImportReader tokenReader) {
        this.currentReader = tokenReader;
    }

    public void startImport() throws BusinessDomainException {
        this.mStop = true;
        String name = this.getFileImport().getFileName1();
        if (StringMapper.isNullString((String)name)) {
            return;
        }
        File file = new File(name);
        if (!file.exists()) {
            this.log("File not found < " + name);
            throw PersonnelFileImportExceptionMapper.makeFileNotExistsDomainException((String)name);
        }
        if (!file.isFile()) {
            this.log("File is not a normal file < " + name);
            throw PersonnelFileImportExceptionMapper.makeFileNotRegularyDomainException((String)name);
        }
        if (!file.canRead()) {
            this.log("File can not be read < " + name);
            throw PersonnelFileImportExceptionMapper.makeFileNotReadableDomainException((String)name);
        }
        String encoding = this.getFileImport().getCharSet();
        if (this.getTokenReader().startRead(file, encoding)) {
            this.setCurrentReader(this.getTokenReader());
            this.mStop = false;
        }
    }

    public boolean hasNext() throws BusinessDomainException {
        if (this.mStop) {
            return false;
        }
        if (this.transferDataList != null && this.transferDataList.hasNext()) {
            boolean next = true;
            return next;
        }
        this.transferDataList = null;
        boolean next = this.mLineForNextRead == null ? this.getCurrentReader().hasNext() : true;
        if (!next) {
            this.mStop = true;
        }
        return next;
    }

    public TransferData getNext() throws BusinessDomainException {
        ImportedLine line;
        if (this.mStop) {
            return null;
        }
        TransferData result = null;
        if (this.transferDataList != null && (result = this.transferDataList.getNext()) != null) {
            return result;
        }
        if (this.mLineForNextRead == null) {
            line = this.getCurrentReader().nextLine();
        } else {
            line = this.mLineForNextRead;
            this.mLineForNextRead = null;
        }
        if (line == null || line.mFields == null || line.mFields.length == 0) {
            return null;
        }
        this.getFileImportSession().setActualData(line.mImportedLine, line.mFields);
        this.transferDataList = this.makeTransferAbsentTimeDirect(line.mLineNumber, line.mFields);
        if (this.transferDataList != null) {
            result = this.transferDataList.getNext();
        }
        return result;
    }

    public void endImportImpl() {
        if (this.getTokenReader() != null) {
            this.getTokenReader().endRead();
        }
    }

    private TransferDataList makeTransferAbsentTimeDirect(int rw, String[] tokens) throws BusinessDomainException {
        if (tokens.length < 8) {
            throw ExceptionMapper.makeApplicationException((String)"AbsentTimeDirectTransferFileImporterImpl: not enough fields in import line");
        }
        String firmennummer = tokens[1];
        String einrechMonatJahr = tokens[2];
        String abrechMonatJahr = tokens[3];
        String personalnummer = tokens[4];
        String symbole = tokens[6];
        String month = "";
        String year = "";
        Date dateMonthYear = null;
        if (einrechMonatJahr.length() == 6) {
            year = einrechMonatJahr.substring(0, 4);
            month = einrechMonatJahr.substring(4);
            dateMonthYear = new VDate(Integer.parseInt(year), Integer.parseInt(month) - 1, 1).getDate();
        }
        if (dateMonthYear == null) {
            throw EmployeeExceptionMapper.makeEffectiveTimePointMissingDomainException();
        }
        Date effectiveFrom = DateHelper.getFirstDayOfMonth(dateMonthYear);
        Date effectiveUntil = DateHelper.getLastDayOfMonth(dateMonthYear);
        String retroMonth = "";
        String retroYear = "";
        Date retroDate = null;
        if (abrechMonatJahr.length() == 6) {
            retroYear = abrechMonatJahr.substring(0, 4);
            retroMonth = abrechMonatJahr.substring(4);
            retroDate = new VDate(Integer.parseInt(retroYear), Integer.parseInt(retroMonth) - 1, 1).getDate();
        }
        if (retroDate == null) {
            throw EmployeeExceptionMapper.makeValidFromFalseDomainException();
        }
        Date validFrom = DateHelper.getFirstDayOfMonth(retroDate);
        Date validUntil = DateHelper.getLastDayOfMonth(retroDate);
        List absentDaysList = AbsentDaysAgent.determineAbsentDays((String)symbole, retroDate);
        AbsentTimeTP[] absenttimeTPs = this.getAllValidAbsentTimes(validFrom, symbole);
        for (AbsentDays absentDay : absentDaysList) {
            if (this.transferDataList == null) {
                this.transferDataList = new TransferDataList();
            }
            AbsentTimeTP atTP = this.getFittingAbsentTimeTP(absenttimeTPs, absentDay.getSymbol());
            TransferAbsentTimeDirect result = new TransferAbsentTimeDirect((AbstractTransferSession)this.getTransferSessionAbsentTimesDirect());
            result.setAbsentTimeKey(atTP.getAbsentTime().getAbsentTimeKey());
            this.transferDataList.addTransferData((TransferData)result);
            Calendar cal = GMTCalendar.getSharedInstance();
            cal.setTime(validFrom);
            cal.set(5, absentDay.getBegin());
            Date absentBegin = cal.getTime();
            cal.setTime(validUntil);
            cal.set(5, absentDay.getEnd());
            Date absentEnd = cal.getTime();
            result.setCompanyKey(this.convertCompanyKey(firmennummer));
            result.setDailySymbol(symbole);
            String msg = null;
            try {
                msg = "Die Personalnummer in Satz " + rw;
                result.setPersonnelnumber(Integer.parseInt(personalnummer));
                int monthyear = Integer.parseInt(einrechMonatJahr);
                result.setMonthYear(monthyear);
                int rectroMY = Integer.parseInt(abrechMonatJahr);
                result.setRetroactiveMY(rectroMY);
            }
            catch (NumberFormatException e) {
                this.log(msg + " war fehlerhaft und wurde deshalb in 0 umgesetzt.");
            }
            result.setEffectiveFrom(effectiveFrom);
            result.setEffectiveUntil(effectiveUntil);
            result.setValidFrom(absentBegin);
            result.setValidUntil(absentEnd);
        }
        return this.transferDataList;
    }

    private AbsentTimeTP getFittingAbsentTimeTP(AbsentTimeTP[] absenttimesTP, String preSystemKey) throws BusinessDomainException {
        for (AbsentTimeTP atTP : absenttimesTP) {
            if (!preSystemKey.trim().equals(atTP.getAbsentTimeKeyOfPreSystem().trim())) continue;
            return atTP;
        }
        throw EmployeeExceptionMapper.makeNoAbsentTimeWithFittingPreSystemKeyDomainException();
    }

    private AbsentTimeTP[] getAllValidAbsentTimes(Date validFrom, String symbole) throws BusinessDomainException {
        HashSet<String> symbolSet = new HashSet<String>();
        for (char c : symbole.toCharArray()) {
            if (c == '.' || Character.isWhitespace(c)) continue;
            symbolSet.add(String.valueOf(c));
        }
        Conjunction filters = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validFrom)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom)), Restrictions.in((String)"absenttimepresyste", (String[])symbolSet.toArray(new String[symbolSet.size()]))});
        AbsentTimeTP[] absenttimesTP = AbsentTimeTPPersistencyManager.queryAll(null, (Criterion)filters);
        if (absenttimesTP == null || absenttimesTP.length == 0) {
            throw EmployeeExceptionMapper.makeAbsentTimeNotFoundDomainException((String)("f\u00fcr folgende Fehlzeit Vorsystem " + symbolSet.toArray(new String[symbolSet.size()]).toString()));
        }
        return absenttimesTP;
    }

    private String convertCompanyKey(String firmennummer) {
        CompanyKeyTranslation t = new CompanyKeyTranslation(firmennummer);
        t = (CompanyKeyTranslation)this.mFileImportSession.getLoaded((Object)t);
        return t.getCompanyKey();
    }

    protected void shiftFiles() {
        block4: {
            int copies = this.getFileImport().getNumberOfCopies();
            if (copies <= 0 || StringMapper.isNullString((String)this.getFileImport().getFileName1())) break block4;
            File file1 = new File(this.getFileImport().getFileName1());
            if (file1.isDirectory()) {
                File varPayments = new File(file1, FILE_ABSENTTIMES);
                for (int i = copies - 1; i >= 0; --i) {
                    AbsentTimeDirectTransferFileImporterImpl.shift((int)i, (String)varPayments.getAbsolutePath());
                }
            } else {
                for (int i = copies - 1; i >= 0; --i) {
                    AbsentTimeDirectTransferFileImporterImpl.shift((int)i, (String)this.getFileImport().getFileName1());
                }
            }
        }
    }

    public static boolean isDefault(String token) {
        return StringMapper.isNullString((String)token) ? false : token.charAt(0) == '*';
    }
}

