/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.mapper;

import com.infor.igf.core.util.StacktraceUtils;
import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationCase;
import com.varial.personnel.domain.employee.attachment.EEAttachmentTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.ErmittlungSVEntgeltEGA;
import com.varial.personnel.domain.evaluation.ErmittlungSVEntgeltLfd;
import com.varial.personnel.domain.evaluation.KinderzuwendungKKH;
import com.varial.personnel.domain.evaluation.formula.BewertungWertguthabenFormula;
import com.varial.personnel.domain.evaluation.formula.KVBeitragsermittlungFreiwilligFormula;
import com.varial.personnel.domain.evaluation.formula.LohnsteuerErmittlungFormula;
import com.varial.personnel.domain.evaluation.formula.Steuerung23cSGBIVFormula;
import com.varial.personnel.domain.evaluation.formula.SteuerungDarlehenFormula;
import com.varial.personnel.domain.evaluation.formula.SteuerungMarbPauschalFormula;
import com.varial.personnel.domain.evaluation.libraryimpl.EmployeeLibraryImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.GlobalLibraryImpl;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.recipient.Recipient;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.typeofvalue.basictypes.AverageHandlingEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.AverageHandlingEnumMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import java.math.BigDecimal;
import java.util.Date;

public final class EvaluationExceptionMapper {
    private static final String CLASS_GENERAL = "PYBewertung";
    private static final String STRING_GLLIBIMPL = "GobalLibraryImpl";
    public static final int NOCFGROSSWAGE = 110;
    public static final int NOPAYMENTWITHSOCIALINSURANCEDAYS = 112;
    private static final int PERMANENTPAYMENTINNONCONTRIBUTORYTIME = 50;
    private static final int ZEROINSUM = 100;
    private static final int WRONGVALUETYPE = 111;
    private static final int NOHEALTHFUNDFOUND = 113;
    private static final int NOAGEPARTTIMEMODELFORCALCULATIONEXIST = 114;
    private static final int GROSSWAGEOFTAXATIONISNOTSUFFICIENTFORTAXALLOWANCEOFBAV = 145;
    private static final int GROSSWAGEEGASMALLERTHANGROSSWAGECONVERSION = 150;
    private static final int INVALIDDUESGROUPEUI_BIS_31122016_UND_AB_01012022 = 350;
    private static final int INVALIDDUESGROUPEUI_AB_01012017 = 351;
    private static final int MISSINGLUMPSUMINCOMETAXTP = 700;
    private static final int MISSING_SOCIALINSURANCE = 701;
    private static final int MISSING_FSTATEREGIONCONTRIBUTIONS = 702;
    private static final int NOFSTATEREGION = 703;
    private static final int NOFSTATEREGIONCALENDAR = 704;
    private static final int NOPAYMENTFORGLEITZONE = 705;
    private static final int NOASSESSMENTPERCENTAGEFOUNDFORU1 = 706;
    private static final int NOASSESSMENTPERCENTAGEFOUNDFORU2 = 707;
    private static final int NOASSESSMENTPERCENTAGEFOUNDFORU3 = 708;
    private static final int NOCONTRIBUTIONPERCENTAGEFORKVDR = 709;
    private static final int NOCONTRIBUTIONPERCENTAGEGENERALFORKV = 710;
    private static final int NOCONTRIBUTIONPERCENTAGEINCREASEDFORKV = 711;
    private static final int NOCONTRIBUTIONPERCENTAGEREDUCEDFORKV = 712;
    private static final int NOASSESSMENTHEALTHFUNDFOUND = 713;
    private static final int NOCOMPAREABLENETWAGEFOR23C = 714;
    private static final int NOVALIDASSIGNMENTFORU1 = 715;
    private static final int NOVALIDASSIGNMENTFORU2 = 716;
    private static final int NOVALIDASSIGNMENTFORU3 = 717;
    private static final int NO_CF_SI = 719;
    private static final int NO_ERA_MODEL_AVAILABLE = 720;
    private static final int NO_MULTIPLE_EMPLOYMENT_TO_CALCULATE_VALUEPOSITION = 721;
    private static final int INCREASE_DUES_GROUP_VHI_AFTER_2008_NOT_ALLOWED = 722;
    private static final int INCREASE_DUES_GROUP_HI_AFTER_2008_NOT_ALLOWED = 723;
    private static final int NO_VALUEPOSITION_FOR_MULTIPLE_EMPLOYMENT_ = 724;
    private static final int NOLOANBOASGENESIS = 750;
    private static final int NO_EEATTACHMENT_GENESIS = 751;
    private static final int FALSE_BAV_REGISTRATION = 752;
    private static final int WRONG_SIGN_OF_ALTERSENTLASTUNG = 753;
    private static final int NO_BGS_KV_STOERFALL = 754;
    private static final int NO_BGS_RV_STOERFALL = 755;
    private static final int NO_BGS_AV_STOERFALL = 756;
    private static final int NO_BGS_PV_STOERFALL = 757;
    private static final int VALUE_ACCOUNT_ONLY_IN_HOUR_OR_AMMOUNT_POSSIBLE = 758;
    private static final int NOAMOUNTFORHOURLYEECREDITFOUND = 759;
    private static final int WRONG_DOWNTIME_SITUATION = 760;
    private static final int NO_CREDIT_MODEL_ASSIGNED = 761;
    private static final int CREDIT_RATE_SMALLER_THAN_INTEREST_RATE = 762;
    private static final int WRONG_AGZ_CALCULATION = 763;
    private static final int WRONG_AGZ_CALCULATION_AFTER_KUG = 764;
    private static final int NO_TABLENAME_IN_NOTE_OF_VALUETYPE = 765;
    private static final int WRONG_TABLENAME_IN_NOTE_OF_VALUETYPE = 766;
    private static final int NO_ASSESMENT_OF_PAY_SCALE_IN_RESULT = 767;
    private static final int NO_CFSI_AFTER_CHANGED_PERSONAL_ID = 768;
    private static final int NO_ADVANCE_PAYMENT_AS_GENESIS_FOUND = 769;
    private static final int NO_ORDERFROM_IN_ATTACHMENT = 770;
    private static final int NO_RECEPTDATE_IN_ATTACHMENT = 771;
    private static final int PAY_SCALE_NOT_FOUND = 772;
    private static final int PGS121PERMANENTINCOMEOVERGENERALMARGINALVALUEOFLOWINCOMEEARNERS = 773;
    private static final int NONETWAGEFOR23C = 774;
    private static final int NUMBER_OF_PAID_OVERTIME_EXCEEDED = 800;
    private static final int VBLU_ALTERS_KONFLIKT = 801;
    private static final int GLEITZONE_SAG = 802;
    private static final int MFB_SAG = 803;
    private static final int MISSING_VALUE_TYPE = 804;
    private static final int NO_PERCENTAGE_FOR_3BESTG_AVAILABLE = 805;
    private static final int NO_VALUETYPE_TAXACATION_FOR_3BESTG_AVAILABLE = 806;
    private static final int NO_VALUETYPE_EXEMTED_FROM_CONTRIBUTIONS_FOR_3BESTG_AVAILABLE = 807;
    private static final int NO_VALUETYPE_LIABLE_FOR_CONTRIBUTIONS_FOR_3BESTG_AVAILABLE = 808;
    private static final int NO_VALUE_TYPE_IN_ERA_EXTRAPAYMENT = 809;
    private static final int ZERO_DAYS_IN_DBGZ_NOT_ALLOWED = 810;
    private static final int NO_IMPLEMENTATION_OF_ZVK = 811;
    private static final int NO_ER_ADDITIONAL_AMOUNT_FOR_ZVK_IMPLEMENTED = 812;
    private static final int THREE_MONTH_AVERAGE_CALCULATION = 813;
    private static final int NO_ADDITIONAL_ALLOWANCE_TO_SICKNESS_BENEFIT_AVAILABLE = 814;
    private static final int NO_ASSIGNMENT_FOR_FOLLOW_INSTITUTION = 815;
    private static final int VBLU_AGREEMENT_CALCULATE_FROM_FIRST_DAY_OF_YEAR = 15004;
    private static final int COST_CENTER_KEY_NOT_IN_PAY_SCALE = 816;
    private static final int NO_DIFFERENT_BUFFER_COST_UNIT_ON_ONE_TIME_CREATE = 817;
    private static final int NO_DIFFERENT_BUFFER_COST_CENTER_ON_ONE_TIME_CREATE = 818;
    private static final int NO_DIFFERENT_BUFFER_PERFORMANCE_FACTOR_ON_ONE_TIME_CREATE = 819;
    private static final int NO_DIFFERENT_BUFFER_PERCENTAGE_ON_ONE_TIME_CREATE = 820;
    private static final int NO_DIFFERENT_COST_UNIT_ON_ONE_TIME_CREATE = 821;
    private static final int NO_DIFFERENT_COST_CENTER_ON_ONE_TIME_CREATE = 822;
    private static final int NO_DIFFERENT_PERCENTAGE_ON_ONE_TIME_CREATE = 823;
    private static final int NO_DIFFERENT_PERFORMANCE_FACTOR_ON_ONE_TIME_CREATE = 824;
    private static final int NO_ASSIGNMENT_PCOMPANY_ZVK = 825;
    private static final int NO_CALENDAR_FOR_YEAR = 826;
    private static final int NO_AAG_STARTDATE = 827;
    private static final int NO_DATEOFBIRTH_OF_CHILD = 829;
    private static final int NO_37b__CALCULATION_IN_CONNECTION__WITH_MARCH_CLAUSE = 830;
    private static final int NO_SHORTTIMEWORK_WITH_AV0 = 831;
    private static final int NO_SHORTTIMEWORK_WITH_FLATTAX = 832;
    @Errors
    private static final ErrorList mErrorList = new ErrorList("PYBewertung", new ErrorMessage[]{new ErrorMessage(114, "Es wurde kein ATZ-Modell zur Ermittlung vertraglicher ATZ gefunden."), new ErrorMessage(100, "Kumulierte Summe im Divisor ist 0"), new ErrorMessage(50, "In Zeitr\u00e4umen mit 0 SV-Tagen ist kein lfd. Entgelt zul\u00e4ssig. Erzeugt aus AWA "), new ErrorMessage(110, "Keine Vortragsdaten f\u00fcr Bruttolohn"), new ErrorMessage(111, "Formelaufruf durch falsche Wertart"), new ErrorMessage(112, "Kein lfd. Entgelt in Zeitraum mit SV-Tagen gefunden!"), new ErrorMessage(145, "Der zu versteuernde Arbeitslohn ist nicht ausreichend f\u00fcr den Steuerfreibetrag der BAV"), new ErrorMessage(150, "Die BAV aus Sonderzahlungen kann nicht bedient werden, da das beitragspfl. Entgelt aus EGA nicht ausreicht!"), new ErrorMessage(700, "Die Globale Vorgabe Pauschalsteuer fehlt"), new ErrorMessage(701, "Die Globale Vorgabe Sozialversicherung fehlt"), new ErrorMessage(702, "Die Globale Vorgaben Bundesland/Region fehlen"), new ErrorMessage(703, "Kein Zugeordnetes Bundesland/Region in Mitarbeiter/Betriebsst\u00e4tte/Firma"), new ErrorMessage(704, "F\u00fcr die Ermittlung des Gro\u00dfbuchstaben U wurde kein Kalender im Bundesland hinterlegt"), new ErrorMessage(705, "F\u00fcr die Berechnung sind keine SV-Tage vorhanden und kein fiktives Entgelt zur Gleitzone!"), new ErrorMessage(350, "Nach dem Erreichen des Renteneintrittsalters ist der BGS AV des Mitarbeiters auf 2 zu setzen und das Kennzeichen Befreiung AG vom AV-Beitrag zu entfernen"), new ErrorMessage(351, "Nach dem Erreichen des Renteneintrittsalters ist der BGS AV des Mitarbeiters auf 0 zu setzen. Es besteht Versicherungsfreiheit"), new ErrorMessage(706, "F\u00fcr die Berechnung der Umlage U1 ist kein Prozentsatz in der Krankenkasse hinterlegt: "), new ErrorMessage(707, "F\u00fcr die Berechnung der Umlage U2 ist kein Prozentsatz in der Krankenkasse hinterlegt: "), new ErrorMessage(708, "F\u00fcr die Berechnung der Umlage U3 ist kein Prozentsatz in der Krankenkasse hinterlegt: "), new ErrorMessage(113, "F\u00fcr die Berechnung ist keine Krankenkasse hinterlegt"), new ErrorMessage(715, "In der Zuordnung Firma Krankenkasse wurde f\u00fcr die Umlage 1 kein Prozentsatz ausgew\u00e4hlt:"), new ErrorMessage(716, "In der Zuordnung Firma Krankenkasse wurde f\u00fcr die Umlage 2 kein Prozentsatz ausgew\u00e4hlt:"), new ErrorMessage(717, "In der Zuordnung Firma Krankenkasse wurde f\u00fcr die Umlage 3 kein Prozentsatz ausgew\u00e4hlt:"), new ErrorMessage(709, "F\u00fcr die Berechnung des Beitrages zur KVDR ist kein Prozentsatz in der Krankenkasse hinterlegt: "), new ErrorMessage(710, "F\u00fcr die Berechnung des allgemeinen Beitrags zur KV ist kein Prozentsatz in der Krankenkasse hinterlegt: "), new ErrorMessage(711, "F\u00fcr die Berechnung des erh\u00f6hten  Beitrags zur KV ist kein Prozentsatz in der Krankenkasse hinterlegt: "), new ErrorMessage(712, "F\u00fcr die Berechnung des erm\u00e4\u00dfigten Beitrags zur KV ist kein Prozentsatz in der Krankenkasse hinterlegt: "), new ErrorMessage(713, "F\u00fcr die Berechnung der Umlage ist keine Krankenkasse hinterlegt: "), new ErrorMessage(714, "F\u00fcr die Verbeitragung von Sachbez\u00fcgen w\u00e4hrend Sozialleistungen wurde kein 'gemeldetes Vergleichsnetto' in der Fehlzeit hinterlegt."), new ErrorMessage(774, "F\u00fcr die Verbeitragung von fortgez. Entgelten w\u00e4hrend Sozialleistungen konnte kein Vergleichsnetto ermittelt werden. Bitte hinterlegen Sie dieses manuell in der Fehlzeit."), new ErrorMessage(719, "Keine Vortragswerte f\u00fcr die Bewertung von EGA M\u00e4rzklausel vorhanden"), new ErrorMessage(721, "F\u00fcr die Berechnung der Wertposition ist keine Mehrfachbesch\u00e4ftigung in den Mitarbeiter SV-Daten geschl\u00fcsselt"), new ErrorMessage(724, "Der Mitarbeiter ist in seinen SV-Daten auf Mehrfachbesch\u00e4ftigung geschl\u00fcsselt. Es wurde aber kein Entgelt anderer Arbeitgeber vorgegeben."), new ErrorMessage(720, "F\u00fcr die ERA-Ermittlung fehlt das ERA-Modell in den Grundlagen der Firma! Bitte ERA-Modell zuordnen"), new ErrorMessage(750, "Die Wertart wurde nicht aus einem AG-Darlehensvertrag erzeugt"), new ErrorMessage(751, "Die Wertart wurde nicht aus einem Pf\u00e4ndungsvertrag erzeugt"), new ErrorMessage(752, "Eingabe der BAV erfolgte nicht unter Funktion BAV"), new ErrorMessage(753, "Wenn ein Mitarbeiter zu Beginn des Kalenderjahres das 64. Lebensjahr vollendet hat, so steht Ihnen ein Altersentlastungsbetrag zu. Bitte korrigieren Sie das Kennzeichen Altersentlastung in der Besteuerung des Mitarbeiters zum "), new ErrorMessage(754, "Bei Eintritt eines St\u00f6rfalls wurde kein Beitragsgruppenschl\u00fcssel f\u00fcr die Verbeitragung der KV-Luft gefunden. Bitte pflegen Sie diesen ggf. \u00fcber Mitarbeiter-->Vortr\u00e4ge-->SV-Luft bei Wertguthaben"), new ErrorMessage(755, "Bei Eintritt eines St\u00f6rfalls wurde kein Beitragsgruppenschl\u00fcssel f\u00fcr die Verbeitragung der RV-Luft gefunden. Bitte pflegen Sie diesen ggf. \u00fcber Mitarbeiter-->Vortr\u00e4ge-->SV-Luft bei Wertguthaben"), new ErrorMessage(756, "Bei Eintritt eines St\u00f6rfalls wurde kein Beitragsgruppenschl\u00fcssel f\u00fcr die Verbeitragung der AV-Luft gefunden. Bitte pflegen Sie diesen ggf. \u00fcber Mitarbeiter-->Vortr\u00e4ge-->SV-Luft bei Wertguthaben"), new ErrorMessage(757, "Bei Eintritt eines St\u00f6rfalls wurde kein Beitragsgruppenschl\u00fcssel f\u00fcr die Verbeitragung der PV-Luft gefunden. Bitte pflegen Sie diesen ggf. \u00fcber Mitarbeiter-->Vortr\u00e4ge-->SV-Luft bei Wertguthaben"), new ErrorMessage(758, "Wertguthaben k\u00f6nnen nur in Stunden_100 oder Betr\u00e4gen gef\u00fchrt werden. Bitte passen Sie die Einheit des Faktoren an. Wertartennummer = "), new ErrorMessage(759, "F\u00fcr die Ermittlung von WGH-Abbau ist kein Stundensatz gefunden worden. "), new ErrorMessage(722, "Die erh\u00f6hte Beitragsklasse zur freiwilligen KV ist ab dem 01.01.2009 nicht mehr zul\u00e4ssig. Bitte korrigieren Sie die SV-Angaben des Mitarbeiters ab 01.01.2009."), new ErrorMessage(723, "Die Beitragsgruppe 2 (erh\u00f6hter Beitragssatz) in der KV ist ab dem 01.01.2009 nicht mehr zul\u00e4ssig. Bitte korrigieren Sie die SV-Angaben des Mitarbeiters ab 01.01.2009."), new ErrorMessage(760, "Bei der Berechnung von KuG ist in einem Monat nur die Vergabe von Ausfall- oder Weiterbildungsstunden zul\u00e4ssig"), new ErrorMessage(761, "Mitarbeiter in Altersteilzeit m\u00fcssen ein sv-pflichtiges WGH-Konto f\u00fcr die Abrechnung besitzen"), new ErrorMessage(762, "Die Rate des AG-Darlehens ist nicht ausreichend um die angefallenen Zinsen zu decken"), new ErrorMessage(763, "W\u00e4hrend Zeitr\u00e4umen mit Kurzarbeitergeld ist die AG-Zuschussermittlung zur frw. KV oder PV nur nach Entgelt zul\u00e4ssig."), new ErrorMessage(764, "Wurde Kurzarbeitergeld im Kalenderjahr durchgef\u00fchrt, ist die AG-Zuschussermittlung zur frw. KV oder PV nur nach Entgelt zul\u00e4ssig."), new ErrorMessage(765, "Kein Name der Tariftabelle des Mitarbeiters in der Notiz der Wertart gefunden. Wertart: "), new ErrorMessage(766, "Kein Name der Tariftabelle des Mitarbeiters in der Notiz der Wertart gefunden. Wertart: "), new ErrorMessage(767, "Die notwendige Zuordnung einer Tariftabelle wurde im Resultat der Wertart nicht vorgenommen. Wertart:"), new ErrorMessage(768, "Nach dem Wechsel der Personalnummer ist f\u00fcr die Bewertung von Sonderzahlungen der Vortrag von SV-Daten zwingend erforderlich!"), new ErrorMessage(769, "Automatische Abschl\u00e4ge unterliegen einer Zahlungskontrolle und m\u00fcssen somit \u00fcber die Abschlagserfassung in die Berechnung eingesteuert werden"), new ErrorMessage(770, "In der Abtretung wurde kein 'Beschluss vom' erfasst. "), new ErrorMessage(771, "In der Pf\u00e4ndung wurde kein 'Eingangsdatum' erfasst. "), new ErrorMessage(772, "Die Tariftabelle wurde nicht gefunden: "), new ErrorMessage(773, "Bei PGS 121 ist das \u00dcberschreiten der GRV-Grenze nicht erlaubt: "), new ErrorMessage(800, "Die Anzahl der erfassten bezahlten \u00dcberstunden ist laut ArbZG um "), new ErrorMessage(801, "Das Lebensalter des Mitarbeiters l\u00e4\u00dft keine VBLU-Versicherung zu"), new ErrorMessage(802, "Die Kennzeichnung zur Gleitzone beim Mitarbeiter entspricht nicht der R\u00fcckmeldung SAG ! Bitte korrigieren Sie die SV-Angaben des Mitarbeiters."), new ErrorMessage(803, "Durch eine R\u00fcckmeldung der Krankenkasse wurden Entgelte gemeldet! Bitte korrigieren Sie die SV-Angaben des Mitarbeiters auf Mehrfachbesch\u00e4ftigung."), new ErrorMessage(804, "Wertartennummer nicht im Wertartenkatalog enthalten : "), new ErrorMessage(805, "F\u00fcr die Bewertung nach \u00a7 3b EStG ist der gesetzliche Prozentsatz in der Wertartenbeschreibung nicht vorhanden. Wertart : "), new ErrorMessage(806, "F\u00fcr die Bewertung nach \u00a7 3b EStG ist die Wertart f\u00fcr den steuerpflichtigen Anteil in der Wertartenbeschreibung nicht vorhanden. Wertart : "), new ErrorMessage(807, "F\u00fcr die Bewertung nach \u00a7 3b EStG ist die Wertart f\u00fcr den sv-freien Anteil in der Wertartenbeschreibung nicht vorhanden. Wertart : "), new ErrorMessage(808, "F\u00fcr die Bewertung nach \u00a7 3b EStG ist die Wertart f\u00fcr den sv-pflichtigen Anteil in der Wertartenbeschreibung nicht vorhanden. Wertart : "), new ErrorMessage(809, " / F\u00fcr den Abrechnungsmonat ist keine Anwenderwertart im ERA-Modell hinterlegt. Siehe Zulage: "), new ErrorMessage(810, " / im DBGZ f\u00fcr den Abrechnungsmonat sind 0 SV-Tage hinterlegt. Dies ist ab Januar 2013 nicht gestattet."), new ErrorMessage(811, "F\u00fcr folgende Art ZVK wurde noch keine Berechnung entwickelt: "), new ErrorMessage(812, "Ein Arbeitgeber-Zusatzbeitrag ist berechnungsseitig f\u00fcr den Typ ZVK nicht zul\u00e4ssig: "), new ErrorMessage(813, "F\u00fcr die Ermittlung des Dreimonatsdurchschnittes bei Mutterschutz sind nicht ausreichend Abrechnungsergebnisse vorhanden. Bitte f\u00fcllen Sie die Vortr\u00e4ge in den Besch\u00e4ftigungsdaten 'berechnungsrelevant'."), new ErrorMessage(814, "Eine Umstellung von manueller auf maschinelle Krankengeldzuschussermittlung ist w\u00e4hrend des Krankengeldbezuges nicht m\u00f6glich. Bitte wenden Sie sich an Ihren Fachberater."), new ErrorMessage(15004, " Besonderheit zur VBLU-Abgrenzung. Bitte zur\u00fcckrechnen zum "), new ErrorMessage(815, "F\u00fcr die Folgeorganisation einer Krankenkasse ist keine Zuordnung in der Firma getroffen worden"), new ErrorMessage(816, "F\u00fcr die Kombination Tariftabelle / Kostenstelle ist keine Gruppe vorhanden : "), new ErrorMessage(817, "Die Weitergabe unterschiedlicher Kostentr\u00e4ger an den Zwischenspeicher einer Folgewertart, die nur einmalig erzeugt werden darf, ist nicht zul\u00e4ssig! "), new ErrorMessage(818, "Die Weitergabe unterschiedlicher Kostenstellen an den Zwischenspeicher einer Folgewertart, die nur einmalig erzeugt werden darf, ist nicht zul\u00e4ssig! "), new ErrorMessage(821, "Die Weitergabe unterschiedlicher Kostentr\u00e4ger an eine Folgewertart, die nur einmalig erzeugt werden darf, ist nicht zul\u00e4ssig! "), new ErrorMessage(822, "Die Weitergabe unterschiedlicher Kostenstellen an eine Folgewertart, die nur einmalig erzeugt werden darf, ist nicht zul\u00e4ssig! "), new ErrorMessage(820, "Die Weitergabe unterschiedlicher Prozents\u00e4tze an den Zwischenspeicher einer Folgewertart, die nur einmalig erzeugt werden darf, ist nicht zul\u00e4ssig! "), new ErrorMessage(819, "Die Weitergabe unterschiedlicher Leistungsfaktoren an den Zwischenspeicher einer Folgewertart, die nur einmalig erzeugt werden darf, ist nicht zul\u00e4ssig! "), new ErrorMessage(823, "Die Weitergabe unterschiedlicher Prozents\u00e4tze an eine Folgewertart, die nur einmalig erzeugt werden darf, ist nicht zul\u00e4ssig! "), new ErrorMessage(824, "Die Weitergabe unterschiedlicher Leistungsfaktoren an eine Folgewertart, die nur einmalig erzeugt werden darf, ist nicht zul\u00e4ssig! "), new ErrorMessage(825, "Keine Zuordnung der ZVK gefunden : "), new ErrorMessage(826, "F\u00fcr die Ermittlung von Soll- und Ist-Zeiten ist f\u00fcr folgendes Jahr kein Bundeslandkalender vorhanden: "), new ErrorMessage(827, "F\u00fcr diesen Berechnungsfall fehlt das Startdatum AAG im DE\u00dcV-Absender: "), new ErrorMessage(829, "F\u00fcr die Berechnung des Kindergeldes fehlt das Geburtsdatum des Kindes in der Funktion Mitarbeiter - Familienangeh\u00f6rige! "), new ErrorMessage(830, "Die Berechnung eines Sachbezuges nach 37b EStG, in Verbindung mit einer M\u00e4rzklausel, ist maschinell nicht zu korrekt zu bewerten. Bitte verschieben sie den Sachbezug in einen Monat au\u00dferhalb des M\u00e4rzklausel-Zeitraumes."), new ErrorMessage(831, "Kurzarbeit bei AV-BGS = 0 nicht zul\u00e4ssig! Bitte entfernen sie die KUG-Ausfall- bzw. KUG-Krank-Stunden."), new ErrorMessage(832, "Kurzarbeit bei 2% Pauschalsteuer ist nicht zul\u00e4ssig! Bitte entfernen sie die KUG-Ausfall- bzw. KUG-Krank-Stunden.")});

    private EvaluationExceptionMapper() {
    }

    public static BusinessDomainException makeNoCFGrossWageDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"EmployeeLibraryImpl", null, (int)110, (String)mErrorList.getDefaultString(110));
    }

    public static BusinessDomainException makeGrossWageOfTaxationIsNotSufficientForTaxAllowanceOfBAVDomainException(String effectiveFromPlusValidFrom) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"SteuerungPensionszusageANFormula", (String)effectiveFromPlusValidFrom, (int)145, (String)mErrorList.getDefaultString(145));
    }

    public static BusinessDomainException makeMissingLumpSumIncomeTaxTPDomainException(String effectiveFromPlusValidFrom) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"GlobalLibraryImpl.pausch_lst_satz", (String)effectiveFromPlusValidFrom, (int)700, (String)mErrorList.getDefaultString(700));
    }

    public static BusinessDomainException makeMissingSocialInsuranceDomainException(String effectiveFromPlusValidFrom) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"GlobalLibraryImpl.getSocialInsurance", (String)effectiveFromPlusValidFrom, (int)701, (String)mErrorList.getDefaultString(701));
    }

    public static BusinessDomainException makeMissingFStateRegionContributionsTPDomainException(String effectiveFromPlusValidFrom) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"GlobalLibraryImpl.getFStateRegionContributionsTP", (String)effectiveFromPlusValidFrom, (int)702, (String)mErrorList.getDefaultString(702));
    }

    public static BusinessDomainException makeNoFederalStateDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"GlobalLibraryImpl.getFStateRegion", (String)"", (int)703, (String)mErrorList.getDefaultString(703));
    }

    public static BusinessDomainException makeNoFStateRegionCalendarDomainException(String date, String bula) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"ErmittlungAnzahlUFormula", (String)date, (int)704, (String)(mErrorList.getDefaultString(704) + " f\u00fcr: " + bula + " " + date));
    }

    public static BusinessDomainException makeDivisorIsNullDomainException(String method, String durchSchnitt, AverageHandlingEnum ahe, String typeOfValue, BigDecimal value) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)method, (String)new StringBuffer().append(durchSchnitt).append(" ").append(AverageHandlingEnumMapper.toSpecialString((AverageHandlingEnum)ahe)).append(" ").append(typeOfValue).append(" = ").append(BigDecimalMapper.toString((BigDecimal)value)).toString(), (int)100, (String)mErrorList.getDefaultString(100));
    }

    public static BusinessDomainException makeGrossWageEGASmallerThanGrossWageConversionDomainException(Date date, int valuetypeNumber) {
        return ExceptionMapper.makeDomainException((String)"BAV aus Sonderzahlungen kann nicht bedient werden", (String)"", (String)DateMapper.toDDMMYYYYPointSeparationString((Date)date), (int)150, (String)(mErrorList.getDefaultString(150) + "\nAbrechnungsmonat: " + DateMapper.toDDMMYYYYPointSeparationString((Date)date) + "\nAnwenderwertart: " + valuetypeNumber));
    }

    public static BusinessDomainException makeNoPaymentForGleitzone(Date date) {
        return ExceptionMapper.makeDomainException((String)"ErmittlungSVEntgeltLfdFormula", (String)"bewerteGleitzone", (String)VDate.toString((Date)date), (int)705, (String)mErrorList.getDefaultString(705));
    }

    public static BusinessDomainException makeInvalidDuesGroupUI(Date date) {
        int fehlerCode = DateHelper.afterOrEqual((Date)date, (Date)new VDate(2017, 0, 1).getDate()) && DateHelper.beforeOrEqual((Date)date, (Date)new VDate(2021, 11, 31).getDate()) ? 351 : 350;
        return ExceptionMapper.makeDomainException((String)"ErmittlungAVEntgeltFormula", (String)"", (String)VDate.toString((Date)date), (int)fehlerCode, (String)(mErrorList.getDefaultString(fehlerCode) + " " + DateMapper.toDDMMYYYYPointSeparationString((Date)date)));
    }

    public static BusinessDomainException makePermanentPaymentInNonContributoryTimeDomainException(Date date, int valuetypeNumber) {
        return ExceptionMapper.makeDomainException((String)"ErmittlungSVEntgeltLfdFormula", (String)"", (String)DateMapper.toDDMMYYYYPointSeparationString((Date)date), (int)50, (String)(VDate.toString((Date)date) + " " + mErrorList.getDefaultString(50) + valuetypeNumber));
    }

    public static BusinessDomainException makeNoAssessmentPercentageFoundForU1(String shortDescription, Date gueltigAb) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", (String)shortDescription, (int)706, (String)(VDate.toString((Date)gueltigAb) + " " + mErrorList.getDefaultString(706) + shortDescription));
    }

    public static BusinessDomainException makeNoAssessmentPercentageFoundForU2(String shortDescription, Date gueltigAb) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", (String)shortDescription, (int)707, (String)(VDate.toString((Date)gueltigAb) + " " + mErrorList.getDefaultString(707) + shortDescription));
    }

    public static BusinessDomainException makeNoAssessmentPercentageFoundForU3(String shortDescription, Date validFrom) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", (String)shortDescription, (int)708, (String)(VDate.toString((Date)validFrom) + " " + mErrorList.getDefaultString(708) + shortDescription));
    }

    public static BusinessDomainException makeNoValidAssignmentForU1(String shortDescription, Date validFrom) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", (String)shortDescription, (int)715, (String)(DateMapper.toMMYYYYPointSeparationString((Date)validFrom) + " " + mErrorList.getDefaultString(715) + " " + shortDescription));
    }

    public static BusinessDomainException makeNoValidAssignmentForU2(String shortDescription, Date validFrom) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", (String)shortDescription, (int)716, (String)(DateMapper.toMMYYYYPointSeparationString((Date)validFrom) + " " + mErrorList.getDefaultString(716) + " " + shortDescription));
    }

    public static BusinessDomainException makeNoValidAssignmentForU3(String shortDescription, Date validFrom) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", (String)shortDescription, (int)717, (String)(DateMapper.toMMYYYYPointSeparationString((Date)validFrom) + " " + mErrorList.getDefaultString(717) + " " + shortDescription));
    }

    public static BusinessDomainException makeNoHealthFundFound(Date validFrom) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", null, (int)113, (String)(VDate.toString((Date)validFrom) + " " + mErrorList.getDefaultString(113)));
    }

    public static BusinessDomainException makeNoContributionPercentageForKVdR(String shortDescription, Date validFrom) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", (String)shortDescription, (int)709, (String)(VDate.toString((Date)validFrom) + " " + mErrorList.getDefaultString(709) + shortDescription));
    }

    public static BusinessDomainException makeNoContributionPercentageGeneralForKV(String shortDescription, Date validFrom) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", (String)shortDescription, (int)710, (String)(VDate.toString((Date)validFrom) + " " + mErrorList.getDefaultString(710) + shortDescription));
    }

    public static BusinessDomainException makeNoContributionPercentageIncreasedForKV(String shortDescription, Date validFrom) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", (String)shortDescription, (int)711, (String)(VDate.toString((Date)validFrom) + " " + mErrorList.getDefaultString(711) + shortDescription));
    }

    public static BusinessDomainException makeNoContributionPercentageReducedForKV(String shortDescription, Date validFrom) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", (String)shortDescription, (int)712, (String)(VDate.toString((Date)validFrom) + " " + mErrorList.getDefaultString(712) + shortDescription));
    }

    public static BusinessDomainException makeNoAssessmentHealthFundFoundDomainException(Date date) {
        return ExceptionMapper.makeDomainException((String)STRING_GLLIBIMPL, (String)"", (String)VDate.toString((Date)date), (int)713, (String)(VDate.toString((Date)date) + " " + mErrorList.getDefaultString(713)));
    }

    public static BusinessDomainException makeWrongValueTypeDomaineException(String name, int valuetypenumber) {
        return ExceptionMapper.makeDomainException((String)name, (String)"", (String)Integer.toString(valuetypenumber), (int)111, (String)mErrorList.getDefaultString(111));
    }

    public static BusinessDomainException makeNoPaymentWithSocialInsuranceDaysDomainException(Date validFrom) {
        return ExceptionMapper.makeDomainException((String)CalculationCase.class.getName(), (String)"", (String)DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom), (int)112, (String)(DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom) + " " + mErrorList.getDefaultString(112)));
    }

    public static BusinessDomainException makeNoAgePartTimeModelForCalculationExistDomainException() {
        return ExceptionMapper.makeDomainException((String)GlobalLibraryImpl.class.getName(), (String)"marb_ATZ_Modell", null, (int)114, (String)mErrorList.getDefaultString(114));
    }

    public static BusinessDomainException makeNoCompareableNetWageDomainException(String fehlzeitDomainKey) {
        return ExceptionMapper.makeDomainException((String)Steuerung23cSGBIVFormula.class.getName(), (String)"checkFor23cSGBIV", (String)fehlzeitDomainKey, (int)714, (String)mErrorList.getDefaultString(714));
    }

    public static BusinessDomainException makeNoNetWageDomainException(String fehlzeitDomainKey) {
        return ExceptionMapper.makeDomainException((String)Steuerung23cSGBIVFormula.class.getName(), (String)"checkFor23cSGBIV", (String)fehlzeitDomainKey, (int)774, (String)mErrorList.getDefaultString(774));
    }

    public static BusinessDomainException makeNoLoanBOAsGenesisDomainException() {
        return ExceptionMapper.makeDomainException((String)SteuerungDarlehenFormula.class.getName(), (String)"ermittlungBerechnungsparameter", null, (int)750, (String)mErrorList.getDefaultString(750));
    }

    public static BusinessDomainException makeNoCFSIAvailable() {
        return ExceptionMapper.makeDomainException((String)ErmittlungSVEntgeltEGA.class.getName(), (String)"CheckAttendance()", null, (int)719, (String)mErrorList.getDefaultString(719));
    }

    public static BusinessDomainException makeNoMultipleEmploymentForCalculateOfValuePositionDomainException(Date date, int valueTypeKey) {
        return ExceptionMapper.makeDomainException((String)ErmittlungSVEntgeltLfd.class.getName(), (String)"checkMultipleEmployment()", (String)(Integer.toString(valueTypeKey) + " / " + DateMapper.toMMYYYYPointSeparationString((Date)date)), (int)721, (String)(Integer.toString(valueTypeKey) + " / " + DateMapper.toMMYYYYPointSeparationString((Date)date) + " - " + mErrorList.getDefaultString(721)));
    }

    public static BusinessDomainException makeNoValuePositionForMultipleEmploymentDomainException(Date date) {
        return ExceptionMapper.makeDomainException((String)ErmittlungSVEntgeltLfd.class.getName(), (String)"checkMultipleEmployment()", (String)DateMapper.toMMYYYYPointSeparationString((Date)date), (int)724, (String)(DateMapper.toMMYYYYPointSeparationString((Date)date) + " - " + mErrorList.getDefaultString(724)));
    }

    public static BusinessDomainException makeNoEraModelAvailableDomainException(Date validFrom, int valueTypeKey) {
        return ExceptionMapper.makeDomainException((String)ErmittlungSVEntgeltLfd.class.getName(), (String)"checkMultipleEmployment()", null, (int)720, (String)(Integer.toString(valueTypeKey) + " " + DateMapper.toMMYYYYPointSeparationString((Date)validFrom) + " " + mErrorList.getDefaultString(720)));
    }

    public static BusinessDomainException makeNoEEAttachmentGenesisDomainException(ValuePosition genesisOfParentObjects, Date berchnungGueltigAb) {
        return ExceptionMapper.makeDomainException((String)ErmittlungSVEntgeltLfd.class.getName(), (String)"selecktierPf\u00e4ndungsvertrag", null, (int)751, (String)(Integer.toString(genesisOfParentObjects.getValueType().getValueTypeKey()) + " " + DateMapper.toMMYYYYPointSeparationString((Date)berchnungGueltigAb) + " " + mErrorList.getDefaultString(751)));
    }

    public static BusinessDomainException makeFalseBAVRegistrationDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, null, null, (int)752, (String)mErrorList.getDefaultString(752));
    }

    public static BusinessDomainException makeWrongSignOfAltersentlastung(Date beginnAltersentlastung) {
        return ExceptionMapper.makeDomainException((String)LohnsteuerErmittlungFormula.class.getName(), (String)"alte1", (String)"false", (int)753, (String)(mErrorList.getDefaultString(753) + DateMapper.toDDMMYYYYPointSeparationString((Date)beginnAltersentlastung)));
    }

    public static BusinessDomainException makeNoBGSKVStoerfallDomainException() {
        return ExceptionMapper.makeDomainException((String)EmployeeLibraryImpl.class.getName(), (String)"marbBgsKvStoerfall", null, (int)754, (String)mErrorList.getDefaultString(754));
    }

    public static BusinessDomainException makeNoBGSRVStoerfallDomainException() {
        return ExceptionMapper.makeDomainException((String)EmployeeLibraryImpl.class.getName(), (String)"marbBgsRvStoerfall", null, (int)755, (String)mErrorList.getDefaultString(755));
    }

    public static BusinessDomainException makeNoBGSAVStoerfallDomainException() {
        return ExceptionMapper.makeDomainException((String)EmployeeLibraryImpl.class.getName(), (String)"marbBgsAvStoerfall", null, (int)756, (String)mErrorList.getDefaultString(756));
    }

    public static BusinessDomainException makeNoBGSPVStoerfallDomainException() {
        return ExceptionMapper.makeDomainException((String)EmployeeLibraryImpl.class.getName(), (String)"marbBgsPvStoerfall", null, (int)757, (String)mErrorList.getDefaultString(757));
    }

    public static BusinessDomainException makeValueAccountOnlyInHourOrAmmountPossibleDomainException(int wertartenNummer) {
        return ExceptionMapper.makeDomainException((String)BewertungWertguthabenFormula.class.getName(), null, null, (int)758, (String)(mErrorList.getDefaultString(758) + wertartenNummer));
    }

    public static BusinessDomainException makeNoPaymentWithSocialInsuranceDaysDomainException(Date validFrom, CharSequence info) {
        return ExceptionMapper.makeDomainException((String)CalculationCase.class.getName(), null, (String)DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom), (int)112, (String)(DateMapper.toDDMMPointSeparationString((Date)validFrom) + " " + mErrorList.getDefaultString(112) + " F\u00fcr: " + info));
    }

    public static BusinessDomainException makeNoAmountForHourlyEECreditFoundDomainException(Date berchnungGueltigAb) {
        return ExceptionMapper.makeDomainException((String)BewertungWertguthabenFormula.class.getName(), null, null, (int)759, (String)(mErrorList.getDefaultString(759) + DateMapper.toMMYYYYPointSeparationString((Date)berchnungGueltigAb)));
    }

    public static BusinessDomainException makeIncreaseDuesGroupVHIAfter2008NotAllowedDomainException() {
        return ExceptionMapper.makeDomainException((String)KVBeitragsermittlungFreiwilligFormula.class.getName(), null, null, (int)722, (String)mErrorList.getDefaultString(722));
    }

    public static BusinessDomainException makeIncreaseDuesGroupHIAfter2008NotAllowedDomainException() {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, null, (int)723, (String)mErrorList.getDefaultString(723));
    }

    public static BusinessDomainException makeWrongDowntimeSituationDomainException(Date berchnungGueltigAb) {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, null, (int)760, (String)(mErrorList.getDefaultString(760) + " " + DateMapper.toMMYYYYPointSeparationString((Date)berchnungGueltigAb)));
    }

    public static BusinessDomainException makeNoCreditModelAssignedToEmployeeBusinessDomainException(Date berchnungGueltigAb) {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, null, (int)761, (String)(mErrorList.getDefaultString(761) + " " + DateMapper.toMMYYYYPointSeparationString((Date)berchnungGueltigAb)));
    }

    public static BusinessDomainException makeCreditRateSmallerThanInterestRateDomainException(Date berchnungGueltigAb) {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, null, (int)762, (String)(mErrorList.getDefaultString(762) + " " + DateMapper.toMMYYYYPointSeparationString((Date)berchnungGueltigAb)));
    }

    public static BusinessDomainException makeWrongAGZCalculationAfterKugDomainException(Date berchnungGueltigAb) {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, null, (int)764, (String)(mErrorList.getDefaultString(764) + " " + DateMapper.toMMYYYYPointSeparationString((Date)berchnungGueltigAb)));
    }

    public static BusinessDomainException makeNoTableNameInNoteOfValueType(int wertartenNummer) {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, null, (int)765, (String)(mErrorList.getDefaultString(765) + " " + wertartenNummer));
    }

    public static BusinessDomainException makeWrongTableNameInNoteOfValueType(int wertartenNummer) {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, null, (int)766, (String)(mErrorList.getDefaultString(766) + " " + wertartenNummer));
    }

    public static BusinessDomainException makeCalcOnlyIfPayScaleIsAssessmentOfResultException(int wertartenNummer) {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, null, (int)767, (String)(mErrorList.getDefaultString(767) + " " + wertartenNummer));
    }

    public static BusinessDomainException makeNoCFSIAfterChangedPersonalIdAvailable() {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, null, (int)768, (String)mErrorList.getDefaultString(768));
    }

    public static BusinessDomainException makeNoAdvancePaymentAsGenesisFoundDomainException() {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, null, (int)769, (String)mErrorList.getDefaultString(769));
    }

    public static BusinessDomainException makeNoOrderDateInAttachment(EEAttachmentTP eatp, Date validFrom) {
        return ExceptionMapper.makeDomainException((String)CalculationCase.class.getName(), (String)StacktraceUtils.getCallingMethod((int)1), (String)DateMapper.toString((Date)validFrom), (int)770, (String)(mErrorList.getDefaultString(770) + eatp.getDomainKey()));
    }

    public static BusinessDomainException makeNoReceptDateInAttachment(EEAttachmentTP eatp, Date validFrom) {
        return ExceptionMapper.makeDomainException((String)CalculationCase.class.getName(), (String)StacktraceUtils.getCallingMethod((int)1), (String)DateMapper.toString((Date)validFrom), (int)771, (String)(mErrorList.getDefaultString(771) + eatp.getDomainKey()));
    }

    public static BusinessDomainException makePayScaleNotFound(String scaleName) {
        return ExceptionMapper.makeDomainException((String)KinderzuwendungKKH.class.getName(), (String)StacktraceUtils.getCallingMethod((int)1), null, (int)772, (String)(mErrorList.getDefaultString(772) + scaleName));
    }

    public static BusinessDomainException makePersonGroupe121PermanentPaymentOverGeneralMarginalValueOfLowIncomeEarners(BigDecimal avEntgeltLfd, BigDecimal grvGrenze) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingMethod(), (String)BigDecimalMapper.toString((BigDecimal)avEntgeltLfd), (int)773, (String)(mErrorList.getDefaultString(773) + BigDecimalMapper.toString((BigDecimal)grvGrenze)));
    }

    public static BusinessDomainException makeNumberOfPaidOvertimeExceededDomainException(String anzahl) {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, null, (int)800, (String)(mErrorList.getDefaultString(800) + anzahl + " \u00fcberschritten!"));
    }

    public static BusinessDomainException makeVBLUAlterskonfliktDomainException(Date berechnungsdatum) {
        return ExceptionMapper.makeDomainException((String)EvaluationExceptionMapper.class.getName(), null, (String)DateMapper.toDDMMYYYYPointSeparationString((Date)berechnungsdatum), (int)801, (String)mErrorList.getDefaultString(801));
    }

    public static BusinessDomainException makeSAGGleitzonenProblem(Date validFrom, String gleitzoneSAG, String gleitzoneMarb) {
        return ExceptionMapper.makeDomainException((String)SteuerungMarbPauschalFormula.class.getName(), null, (String)(DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom) + " SAG : " + gleitzoneSAG + " || Mitarbeiter-SV-besonderes SV-Merkmal :" + gleitzoneMarb), (int)802, (String)mErrorList.getDefaultString(802));
    }

    public static BusinessDomainException makeSAG_MehrfachbeschaeftigungDomainException(Date berchnungGueltigAb, String string) {
        return ExceptionMapper.makeDomainException((String)SteuerungMarbPauschalFormula.class.getName(), null, (String)(DateMapper.toDDMMYYYYPointSeparationString((Date)berchnungGueltigAb) + " / " + string), (int)803, (String)mErrorList.getDefaultString(803));
    }

    public static BusinessDomainException makeMissingValueTypeDomaineException(int valueTypeNumber) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)804, (String)(mErrorList.getDefaultString(804) + valueTypeNumber));
    }

    public static BusinessDomainException makeNoPercentageFor3bEStGAvailable(int valueTypeNumber) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)805, (String)(mErrorList.getDefaultString(805) + valueTypeNumber));
    }

    public static BusinessDomainException makeNoValueTypeTaxacationFor3bEStGAvailable(int valueTypeNumber) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)806, (String)(mErrorList.getDefaultString(806) + valueTypeNumber));
    }

    public static BusinessDomainException makeNoValueTypeExemtedFromContributionsFor3bEStGAvailable(int valueTypeNumber) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)807, (String)(mErrorList.getDefaultString(807) + valueTypeNumber));
    }

    public static BusinessDomainException makeNoValueTypeLiableForContributionsFor3bEStGAvailable(int valueTypeNumber) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)808, (String)(mErrorList.getDefaultString(808) + valueTypeNumber));
    }

    public static BusinessDomainException makeNoValueTypeInERAExtraPaymentDomainException(Date validFrom, int i) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom), (int)809, (String)(DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom) + mErrorList.getDefaultString(809) + i));
    }

    public static BusinessDomainException makeZeroDaysInDbgzNotAllowedDomainException(Date validFrom) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom), (int)810, (String)(DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom) + mErrorList.getDefaultString(810)));
    }

    public static BusinessDomainException makeNoImplementationOfZVKDomainException(String typeOfZVK) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)typeOfZVK, (int)811, (String)(mErrorList.getDefaultString(811) + typeOfZVK));
    }

    public static BusinessDomainException makeNoERAdditionalAmountForZVKImplemented(String typeOfZVK) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)typeOfZVK, (int)812, (String)(mErrorList.getDefaultString(812) + typeOfZVK));
    }

    public static BusinessDomainException makeThreeMonthAverageCalculationDomainException() {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)813, (String)mErrorList.getDefaultString(813));
    }

    public static BusinessDomainException makeNoAdditionalAllowanceToSicknessBenefitAvailableDomainException() {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)814, (String)mErrorList.getDefaultString(814));
    }

    public static BusinessDomainException makeVBLUAgreementCalculateFromFirstDayOfYearDomainException(Date berchnungGueltigAb) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)15004, (String)(DateMapper.toString((Date)berchnungGueltigAb) + mErrorList.getDefaultString(15004) + DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)berchnungGueltigAb))));
    }

    public static BusinessDomainException noAssignmentForFollowInstitutionDomainException(HealthFundTP hftp, Date validfrom) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)815, (String)(mErrorList.getDefaultString(815) + " / " + hftp.getStandardCompanyNumber() + " / " + DateMapper.toDDMMYYYYPointSeparationString((Date)validfrom)));
    }

    public static BusinessDomainException makeCostCenterKeyNotInPayScaleDomainException(String costCenter, int i) {
        return EvaluationExceptionMapper.makeCostCenterKeyNotInPayScaleDomainException(costCenter, Integer.toString(i));
    }

    public static BusinessDomainException makeCostCenterKeyNotInPayScaleDomainException(String costCenter, String tariftabelle) {
        String keyCombination = new StringBuffer().append(tariftabelle).append(" / ").append(costCenter).toString();
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)keyCombination, (int)816, (String)new StringBuffer(mErrorList.getDefaultString(816)).append(keyCombination).toString());
    }

    public static BusinessDomainException makeNoDifferentBufferCostUnitOnOneTimeCreate(int consequence, int basic, Date validfrom) {
        String keyCombination = new StringBuffer(DateMapper.toDDMMYYYYPointSeparationString((Date)validfrom)).append(" / ").append(basic).append(" -> ").append(consequence).toString();
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)keyCombination, (int)817, (String)new StringBuffer(mErrorList.getDefaultString(817)).append(keyCombination).toString());
    }

    public static BusinessDomainException makeNoDifferentBufferCostCenterOnOneTimeCreate(int consequence, int basic, Date validfrom) {
        String keyCombination = new StringBuffer(DateMapper.toDDMMYYYYPointSeparationString((Date)validfrom)).append(" / ").append(basic).append(" -> ").append(consequence).toString();
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)keyCombination, (int)818, (String)new StringBuffer(mErrorList.getDefaultString(818)).append(keyCombination).toString());
    }

    public static BusinessDomainException makeNoDifferentBufferPerformanceFactorOnOneTimeCreate(int consequence, int basic, Date validfrom) {
        String keyCombination = new StringBuffer(DateMapper.toDDMMYYYYPointSeparationString((Date)validfrom)).append(" / ").append(basic).append(" -> ").append(consequence).toString();
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)keyCombination, (int)819, (String)new StringBuffer(mErrorList.getDefaultString(819)).append(keyCombination).toString());
    }

    public static BusinessDomainException makeNoDifferentBufferPercentageOnOneTimeCreate(int consequence, int basic, Date validfrom) {
        String keyCombination = new StringBuffer(DateMapper.toDDMMYYYYPointSeparationString((Date)validfrom)).append(" / ").append(basic).append(" -> ").append(consequence).toString();
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)keyCombination, (int)820, (String)new StringBuffer(mErrorList.getDefaultString(820)).append(keyCombination).toString());
    }

    public static BusinessDomainException makeNoDifferentCostUnitOnOneTimeCreate(int consequence, int basic, Date validfrom) {
        String keyCombination = new StringBuffer(DateMapper.toDDMMYYYYPointSeparationString((Date)validfrom)).append(" / ").append(basic).append(" -> ").append(consequence).toString();
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)keyCombination, (int)821, (String)new StringBuffer(mErrorList.getDefaultString(821)).append(keyCombination).toString());
    }

    public static BusinessDomainException makeNoDifferentCostCenterOnOneTimeCreate(int consequence, int basic, Date validfrom) {
        String keyCombination = new StringBuffer(DateMapper.toDDMMYYYYPointSeparationString((Date)validfrom)).append(" / ").append(basic).append(" -> ").append(consequence).toString();
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)keyCombination, (int)822, (String)new StringBuffer(mErrorList.getDefaultString(822)).append(keyCombination).toString());
    }

    public static BusinessDomainException makeNoDifferentPerformanceFactorOnOneTimeCreate(int consequence, int basic, Date validfrom) {
        String keyCombination = new StringBuffer(DateMapper.toDDMMYYYYPointSeparationString((Date)validfrom)).append(" / ").append(basic).append(" -> ").append(consequence).toString();
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)keyCombination, (int)824, (String)new StringBuffer(mErrorList.getDefaultString(824)).append(keyCombination).toString());
    }

    public static BusinessDomainException makeNoDifferentPercentageOnOneTimeCreate(int consequence, int basic, Date validfrom) {
        String keyCombination = new StringBuffer(DateMapper.toDDMMYYYYPointSeparationString((Date)validfrom)).append(" / ").append(basic).append(" -> ").append(consequence).toString();
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)keyCombination, (int)823, (String)new StringBuffer(mErrorList.getDefaultString(823)).append(keyCombination).toString());
    }

    public static BusinessDomainException makeNoAssignmentPCompanyZVK(Recipient zvk, PCompany marbFirma, Plant marbBetriebsstaette, Date effectiveFrom, Date validFrom) {
        String keyCombination = new StringBuffer().append(zvk == null ? "" : zvk.getRecipientKey()).append(" / ").append(marbFirma == null ? "" : marbFirma.getPCompanyKey()).append(" / ").append(marbBetriebsstaette == null ? "" : marbBetriebsstaette.getPlantKey()).append(" / ").append(DateMapper.toDDMMYYYYPointSeparationString((Date)effectiveFrom)).append(" / ").append(DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom)).toString();
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)keyCombination, (int)825, (String)new StringBuffer(mErrorList.getDefaultString(825)).append(keyCombination).toString());
    }

    public static BusinessDomainException makeNoCalendarForYearDomainException(int year) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), (String)new Integer(year).toString(), (int)826, (String)new StringBuffer(mErrorList.getDefaultString(826)).append(year).toString());
    }

    public static BusinessDomainException makeNoAAGStartDateDomainException() {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)827, (String)mErrorList.getDefaultString(827));
    }

    public static BusinessDomainException makeNoDateOfBirthOfChildDomainException() {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)829, (String)mErrorList.getDefaultString(829));
    }

    public static BusinessDomainException makeNo37bCalculationInConnectionWithMarchClauseDomainException(String valueType) {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)830, (String)(valueType + mErrorList.getDefaultString(830)));
    }

    public static BusinessDomainException makeShorttimeworkWithAVBGS0DomainException() {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)831, (String)mErrorList.getDefaultString(831));
    }

    public static BusinessDomainException makeShorttimeworkWithFLATTAXDomainException() {
        return ExceptionMapper.makeDomainException((String)StacktraceUtils.getCallingClassAndMethod(), (String)StacktraceUtils.getCallingClassAndMethod(), null, (int)832, (String)mErrorList.getDefaultString(832));
    }
}

