/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.libraryimpl;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.absenttime.AbsentTime;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.employee.carriedforward.entry.EECarriedForwardOfEntry;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.IMultipleUsedMethods;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.fstateregion.FStateRegion;
import com.varial.personnel.domain.global.fstateregion.calendar.DayOfWeekEnum;
import com.varial.personnel.domain.global.fstateregion.calendar.FStateRegionCalendarTP;
import com.varial.personnel.domain.global.fstateregion.calendar.FStateRegionCalendarTPPersistencyManager;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.domain.workingtime.WorkingTimeTP;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class MultipleUsedMethodsImpl
implements IMultipleUsedMethods {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private static final BigDecimal ZWOELF = BigDecimal.valueOf(12L);
    private static final int JAHR = 0;
    private static final int MONAT = 1;
    private static final int TAGE = 2;
    private static final int STUNDEN = 3;
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final CalculationLibrary callib;
    private final ValuePositionLibrary wplib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private ValuePosition[] vpArray;
    private BigDecimal mVBezLfd = BigDecimal.ZERO;
    private BigDecimal lfdStpflArbLohn = BigDecimal.ZERO;
    private BigDecimal mFiktJArbLohn = BigDecimal.ZERO;
    private BigDecimal mJahresBruttoLfd = BigDecimal.ZERO;
    private BigDecimal mStPflMMArbLohn = BigDecimal.ZERO;
    private BigDecimal mMMArbLohnSBZAufgel = BigDecimal.ZERO;
    private BigDecimal mMMArbLohnSBZ = BigDecimal.ZERO;
    private BigDecimal mMMArbLohnErmSBZAufgel = BigDecimal.ZERO;
    private BigDecimal mVBezSBZ = BigDecimal.ZERO;
    private WorkingTime mAZMMitarbeiter;
    private boolean mAZMMarbGeladen = false;
    private WorkingTime mAZMMitarbeiterVM;
    private boolean mAZMMarbVMGeladen = false;
    private WorkingTime mAZMBetrieb;
    private boolean mAZMFaGeladen = false;
    private WorkingTime mAZMBetriebVM;
    private boolean mAZMFaVMGeladen = false;
    private boolean wStdTabGefuellt = false;
    private BigDecimal[] wStdTab;
    private int lzzVor = 2;
    private BigDecimal mEntschInJArbLohn = BigDecimal.ZERO;
    private BigDecimal mEntschInSbz = BigDecimal.ZERO;
    private BigDecimal mKapitalabfindungen = BigDecimal.ZERO;
    private BigDecimal mEntschInVkapaUndVMT = BigDecimal.ZERO;
    private BigDecimal mJVBez = BigDecimal.ZERO;
    private BigDecimal mSterbe = BigDecimal.ZERO;
    private boolean erzeugeGrossbuchstabeS = false;
    private BigDecimal mFehlStunden = BigDecimal.ZERO;
    private BigDecimal mArbeitsStunden = BigDecimal.ZERO;

    public MultipleUsedMethodsImpl(CalculationLibrary caLibrary, EmployeeLibrary eeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary vPLibrary) {
        this.callib = caLibrary;
        this.eelib = eeLibrary;
        this.gllib = globalLibrary;
        this.wplib = vPLibrary;
    }

    public int lzzVorBerrechnung() {
        return this.lzzVor;
    }

    public void fillLohnsteuerablaufLfd() throws BusinessDomainException {
        if (this.eelib.versorgungsFreibetrag()) {
            this.ermittlungVersorgungsbezugLfd();
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferResult())) {
            this.lfdStpflArbLohn = this.wplib.wertPosition().getBufferResult();
        }
        this.lfdStpflArbLohn = this.lfdStpflArbLohn.add(this.wplib.result());
        BigDecimal steuerTage = this.wplib.steuerTage();
        if (steuerTage.compareTo(DREISSIG) == 0) {
            this.callib.re4(this.lfdStpflArbLohn.movePointRight(2).setScale(0, RoundingMode.DOWN));
            this.callib.vbez(this.mVBezLfd.movePointRight(2).setScale(0, RoundingMode.DOWN));
        } else {
            if (steuerTage.compareTo(BigDecimal.ZERO) == 0) {
                this.callib.re4(BigDecimal.ZERO);
                this.callib.vbez(BigDecimal.ZERO);
            } else {
                this.callib.re4(this.lfdStpflArbLohn.divide(steuerTage, 2, RoundingMode.HALF_UP).movePointRight(2).setScale(0, RoundingMode.DOWN));
                this.callib.vbez(this.mVBezLfd.divide(steuerTage, 2, RoundingMode.HALF_UP).movePointRight(2).setScale(0, RoundingMode.DOWN));
            }
            this.eelib.lzz(4);
            this.lzzVor = 4;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillLohnsteuerablaufSBZ() throws BusinessDomainException {
        block15: {
            block13: {
                block12: {
                    block14: {
                        this.eelib.lzz(1);
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferResult())) break block13;
                        this.mFiktJArbLohn = this.ermittleSteuerpflichtigenArbeitslohnBisVormonat();
                        this.pruefeEntschaedigung();
                        this.ermittlungLfdArbeitslohnAktMonat();
                        this.mMMArbLohnSBZAufgel = !BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferFactor2()) ? this.wplib.wertPosition().getBufferFactor2() : BigDecimal.ZERO;
                        this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.mStPflMMArbLohn);
                        if (!DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2006, 11, 1).getDate())) break block14;
                        if (!DateHelper.after((Date)this.eelib.marbEintritt(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb())) && !DateHelper.between((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.tomorrow((Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb())), (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) break block12;
                        if (DateHelper.afterOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), (Date)new VDate(2007, 0, 1).getDate())) {
                            this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.ermittleFiktiverVorverdiensFremderAGab2007());
                            break block12;
                        } else {
                            try {
                                this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.eelib.vortragBruttoArbeitslohn(this.wplib.gueltigAb()));
                            }
                            catch (BusinessDomainException e) {
                                if (e.getErrorNumber() == 110) {
                                    this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.ermittleFiktiverVorverdiensFremderAG());
                                }
                                break block12;
                            }
                        }
                    }
                    if (DateHelper.after((Date)this.eelib.marbEintritt(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()))) {
                        if (DateHelper.afterOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), (Date)new VDate(2007, 0, 1).getDate())) {
                            this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.ermittleFiktiverVorverdiensFremderAGab2007());
                        } else {
                            try {
                                this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.eelib.vortragBruttoArbeitslohn(this.wplib.gueltigAb()));
                            }
                            catch (BusinessDomainException e) {
                                if (e.getErrorNumber() != 110) break block12;
                                this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.ermittleFiktiverVorverdiensFremderAG());
                            }
                        }
                    }
                }
                this.ermittlungFiktiverArbeitslohnRestjahr();
                if (this.eelib.versorgungsFreibetrag()) {
                    this.ermittlungVersorgungsbezugLfd();
                    this.ermittlungVersorgungsbezugSBZ();
                    this.mJVBez = this.mVBezLfd.multiply(this.eelib.zmvb()).setScale(2, RoundingMode.DOWN);
                }
                this.wplib.wertPosition().setBufferResult(this.mFiktJArbLohn);
                break block15;
            }
            this.mFiktJArbLohn = this.wplib.wertPosition().getBufferResult();
            this.mMMArbLohnSBZAufgel = this.wplib.wertPosition().getBufferFactor2();
            this.mJVBez = this.wplib.wertPosition().getBufferFactor1();
            this.mVBezSBZ = this.wplib.wertPosition().getBufferPercentage();
            this.mEntschInJArbLohn = this.wplib.wertPosition().getBufferField01();
            this.mEntschInSbz = this.wplib.wertPosition().getBufferField02();
            this.mSterbe = this.wplib.wertPosition().getBufferField05();
        }
        BigDecimal sonstb = this.mMMArbLohnSBZAufgel.add(this.wplib.result()).movePointRight(2).setScale(0, RoundingMode.DOWN);
        this.callib.re4(BigDecimal.ZERO);
        this.callib.jre4(this.mFiktJArbLohn.movePointRight(2).setScale(0, RoundingMode.DOWN));
        this.callib.jvbez(this.mJVBez.movePointRight(2).setScale(0, RoundingMode.DOWN));
        this.callib.sonstb(BigDecimalMapper.compareTo((BigDecimal)sonstb, (BigDecimal)BigDecimal.ZERO) > 0 ? sonstb : BigDecimal.ZERO);
        this.callib.vbs(this.mVBezSBZ.movePointRight(2).setScale(0, RoundingMode.DOWN));
        this.callib.vmt(BigDecimal.ZERO);
        this.callib.sterbe(this.mSterbe);
        if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2022, 7, 1).getDate())) {
            this.callib.jre4ent(this.mEntschInJArbLohn.setScale(0, RoundingMode.DOWN));
            this.callib.sonstent(this.mEntschInSbz.setScale(0, RoundingMode.DOWN));
            return;
        }
        this.callib.jre4ent(this.mEntschInJArbLohn.movePointRight(2).setScale(0, RoundingMode.DOWN));
        this.callib.sonstent(this.mEntschInSbz.movePointRight(2).setScale(0, RoundingMode.DOWN));
    }

    private void pruefeEntschaedigung() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
            ValuePosition[] vpArray;
            for (ValuePosition vPos : vpArray = this.wplib.genesisUndFolgen()) {
                if (vPos.getValueType().getValueTypeKey() != 102580 && vPos.getValueType().getValueTypeKey() != 102590) continue;
                this.mEntschInSbz = this.mEntschInSbz.add(vPos.getResult());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fillLohnsteuerablaufErmSBZ() throws BusinessDomainException {
        block13: {
            block11: {
                block10: {
                    block12: {
                        this.eelib.lzz(1);
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferResult())) break block11;
                        this.mFiktJArbLohn = this.ermittleSteuerpflichtigenArbeitslohnBisVormonat();
                        this.ermittlungLfdArbeitslohnAktMonat();
                        this.ermittlungArbeitslohnSBZAktMonat();
                        if (this.eelib.versorgungsFreibetrag()) {
                            this.ermittlungVersorgungsbezugLfd();
                            this.ermittlungVersorgungsbezugSBZ();
                        }
                        this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.mStPflMMArbLohn);
                        this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.mMMArbLohnSBZAufgel);
                        if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) break block12;
                        if (!DateHelper.after((Date)this.eelib.marbEintritt(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb())) && !DateHelper.after((Date)this.gllib.firmaBerechnungsStart(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()))) break block10;
                        if (DateHelper.afterOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), (Date)new VDate(2008, 0, 1).getDate())) {
                            this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.ermittleFiktiverVorverdiensFremderAGab2007());
                            break block10;
                        } else {
                            try {
                                this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.eelib.vortragBruttoArbeitslohn(this.wplib.gueltigAb()));
                            }
                            catch (BusinessDomainException e) {
                                if (e.getErrorNumber() == 110) {
                                    this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.ermittleFiktiverVorverdiensFremderAG());
                                }
                                break block10;
                            }
                        }
                    }
                    if (DateHelper.after((Date)this.eelib.marbEintritt(), (Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()))) {
                        try {
                            this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.eelib.vortragBruttoArbeitslohn(this.wplib.gueltigAb()));
                        }
                        catch (BusinessDomainException e) {
                            if (e.getErrorNumber() != 110) break block10;
                            this.mFiktJArbLohn = this.mFiktJArbLohn.add(this.ermittleFiktiverVorverdiensFremderAG());
                        }
                    }
                }
                this.ermittlungFiktiverArbeitslohnRestjahr();
                if (this.eelib.versorgungsFreibetrag()) {
                    this.ermittlungVersorgungsbezugLfd();
                    this.ermittlungVersorgungsbezugSBZ();
                    this.mJVBez = this.mVBezLfd.multiply(this.eelib.zmvb()).setScale(2, RoundingMode.DOWN);
                }
                this.wplib.wertPosition().setBufferResult(this.mFiktJArbLohn);
                this.pruefeVkapaUndEntsch();
                break block13;
            }
            this.mFiktJArbLohn = this.wplib.wertPosition().getBufferResult();
            this.mEntschInJArbLohn = this.wplib.wertPosition().getBufferField01();
            this.mMMArbLohnErmSBZAufgel = this.wplib.wertPosition().getBufferFactor2();
            this.mJVBez = this.wplib.wertPosition().getBufferFactor1();
            this.mVBezSBZ = this.wplib.wertPosition().getBufferPercentage();
            this.mMMArbLohnSBZAufgel = this.wplib.wertPosition().getBufferPerformanceFactor();
            this.mEntschInSbz = this.wplib.wertPosition().getBufferField02();
            this.mKapitalabfindungen = this.wplib.wertPosition().getBufferField03();
            this.mEntschInVkapaUndVMT = this.wplib.wertPosition().getBufferField04();
            this.mSterbe = this.wplib.wertPosition().getBufferField05();
        }
        BigDecimal sonstb = this.mMMArbLohnSBZAufgel.movePointRight(2).setScale(0, RoundingMode.DOWN);
        BigDecimal vmt = this.mMMArbLohnErmSBZAufgel.add(this.wplib.result()).movePointRight(2).setScale(0, RoundingMode.DOWN);
        this.callib.jre4(this.mFiktJArbLohn.movePointRight(2).setScale(0, RoundingMode.DOWN));
        this.callib.jre4ent(this.mEntschInJArbLohn.movePointRight(2).setScale(0, RoundingMode.DOWN));
        this.callib.sonstb(BigDecimalMapper.compareTo((BigDecimal)sonstb, (BigDecimal)BigDecimal.ZERO) > 0 ? sonstb : BigDecimal.ZERO);
        this.callib.sonstent(this.mEntschInSbz.movePointRight(2).setScale(0, RoundingMode.DOWN));
        this.callib.vmt(BigDecimalMapper.compareTo((BigDecimal)vmt, (BigDecimal)BigDecimal.ZERO) > 0 ? vmt : BigDecimal.ZERO);
        this.callib.vkapa(this.mKapitalabfindungen.movePointRight(2).setScale(0, RoundingMode.DOWN));
        this.callib.entsch(this.mEntschInVkapaUndVMT.movePointRight(2).setScale(0, RoundingMode.DOWN));
        this.callib.jvbez(this.mJVBez.movePointRight(2).setScale(0, RoundingMode.DOWN));
        this.callib.vbs(this.mVBezSBZ.movePointRight(2).setScale(0, RoundingMode.DOWN));
        this.callib.sterbe(this.mSterbe.movePointRight(2).setScale(0, RoundingMode.DOWN));
    }

    private void pruefeVkapaUndEntsch() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
            ValuePosition[] vpArray;
            block4: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes(102570, 102550))) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 102570: {
                        this.mKapitalabfindungen = this.mKapitalabfindungen.add(vPos.getResult());
                        continue block4;
                    }
                    case 102550: {
                        this.mEntschInVkapaUndVMT = this.mEntschInVkapaUndVMT.add(vPos.getResult());
                    }
                }
            }
        }
    }

    public BigDecimal ermittleWochenstundenMitarbeiter() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        WorkingTimeTP wttp = this.eelib.marb().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb());
        result = BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getWeeklyWorkingTime()) ? (BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getMondayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getTuesdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getWednesdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getThursdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getFridayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getSaturdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getSundayHours()) ? wttp.getMonthlyTargetHours().divide(BigDecimal.valueOf(435L, 2), 2, RoundingMode.HALF_UP) : wttp.getMondayHours().add(wttp.getTuesdayHours()).add(wttp.getWednesdayHours()).add(wttp.getThursdayHours()).add(wttp.getFridayHours()).add(wttp.getSaturdayHours()).add(wttp.getSundayHours())) : wttp.getWeeklyWorkingTime();
        return result;
    }

    private BigDecimal ermittleFiktiverVorverdiensFremderAGab2007() throws BusinessDomainException {
        EECarriedForwardOfEntry[] cfs = this.eelib.marb().getEECarriedForwardOfEntry();
        BigDecimal gesamteSteuertage = BigDecimal.ZERO;
        BigDecimal gesVortragsBrutto = BigDecimal.ZERO;
        int aktJahr = new VDate(this.wplib.gueltigAb()).getYear();
        if (this.hatSteuerlicheVortragswert(cfs, aktJahr)) {
            for (EECarriedForwardOfEntry lCf : cfs) {
                BigDecimal steuertage = BigDecimal.ZERO;
                if (lCf.getYearOfCertificateOfWageTaxDeducation() != aktJahr) continue;
                steuertage = this.ermittleSteuertageVorEintritt();
                gesamteSteuertage = gesamteSteuertage.add(steuertage);
                if (lCf.getLetterS()) {
                    this.erzeugeGrossbuchstabeS = true;
                }
                if (BigDecimalMapper.isZero((BigDecimal)lCf.getGrossPay())) {
                    BigDecimal vortrag = BigDecimal.ZERO;
                    vortrag = BigDecimalMapper.isZero((BigDecimal)this.eelib.massgeblicherMonatsverdienst()) ? this.lfdStpflArbLohn.multiply(steuertage).divide(DREISSIG, 2, RoundingMode.DOWN) : this.eelib.massgeblicherMonatsverdienst().multiply(steuertage).divide(DREISSIG, 2, RoundingMode.DOWN);
                    gesVortragsBrutto = gesVortragsBrutto.add(vortrag);
                    continue;
                }
                gesVortragsBrutto = gesVortragsBrutto.add(lCf.getGrossPay());
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) continue;
                this.mJahresBruttoLfd = BigDecimalMapper.isZeroOrNull((BigDecimal)lCf.getGrossPayTherefromBonus()) ? this.mJahresBruttoLfd.add(lCf.getGrossPay()) : this.mJahresBruttoLfd.add(lCf.getGrossPay().subtract(lCf.getGrossPayTherefromBonus()));
            }
        } else {
            gesVortragsBrutto = this.ermittleFiktiverVorverdiensFremderAG();
            this.erzeugeGrossbuchstabeS = true;
        }
        if (this.erzeugeGrossbuchstabeS) {
            this.erzeugeGrossbuchstabeS(gesVortragsBrutto, gesamteSteuertage);
        }
        return gesVortragsBrutto;
    }

    private boolean hatSteuerlicheVortragswert(EECarriedForwardOfEntry[] cfs, int aktJahr) throws BusinessDomainException {
        Date eintritt;
        boolean hatVortragswerte = false;
        Date date = eintritt = DateHelper.before((Date)this.eelib.marbEintritt(), (Date)this.gllib.firmaBerechnungsStart()) ? this.gllib.firmaBerechnungsStart() : this.eelib.marbEintritt();
        if (cfs.length != 0) {
            for (EECarriedForwardOfEntry lCf : cfs) {
                if (!DateHelper.beforeOrEqual((Date)lCf.getEmploymentUntil(), (Date)DateHelper.yesterday((Date)eintritt)) || lCf.getYearOfCertificateOfWageTaxDeducation() != aktJahr) continue;
                hatVortragswerte = true;
            }
        }
        return hatVortragswerte;
    }

    private void ermittlungFiktiverArbeitslohnRestjahr() throws BusinessDomainException {
        BigDecimal restMonateImJahr = ZWOELF.subtract(BigDecimal.valueOf(new VDate(this.wplib.gueltigAb()).getMonth()).add(BigDecimal.ONE));
        this.mFiktJArbLohn = BigDecimalMapper.isZeroOrNull((BigDecimal)this.eelib.massgeblicherMonatsverdienst()) ? (DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2006, 0, 1).getDate()) ? this.mFiktJArbLohn.add(restMonateImJahr.multiply(this.mStPflMMArbLohn)) : this.mFiktJArbLohn.add(restMonateImJahr.multiply(this.durchschnittLfd(this.wplib.gueltigAb())))) : this.mFiktJArbLohn.add(restMonateImJahr.multiply(this.eelib.massgeblicherMonatsverdienst()));
    }

    private void ermittlungVersorgungsbezugSBZ() throws BusinessDomainException {
        block4: for (ValuePosition lElement : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(102505, 102560))) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 102505: {
                    this.mVBezSBZ = this.mVBezSBZ.add(lElement.getResult());
                    continue block4;
                }
                case 102560: {
                    this.mSterbe = this.mSterbe.add(lElement.getResult());
                }
            }
        }
    }

    private void ermittlungVersorgungsbezugLfd() throws BusinessDomainException {
        for (ValuePosition lElement : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(102500))) {
            this.mVBezLfd = this.mVBezLfd.add(lElement.getResult());
        }
    }

    private void ermittlungArbeitslohnSBZAktMonat() throws BusinessDomainException {
        for (ValuePosition lElement : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(110610, 110630))) {
            this.mMMArbLohnSBZ = this.mMMArbLohnSBZ.add(lElement.getResult());
        }
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
            for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(102580, 102590))) {
                this.mEntschInSbz = this.mEntschInSbz.add(vPos.getResult());
            }
        }
    }

    private void ermittlungLfdArbeitslohnAktMonat() throws BusinessDomainException {
        for (ValuePosition lElement : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(110510))) {
            this.mStPflMMArbLohn = this.mStPflMMArbLohn.add(lElement.getResult());
            this.mJahresBruttoLfd = this.mJahresBruttoLfd.add(lElement.getResult());
        }
    }

    private BigDecimal durchschnittLfd(Date date) throws BusinessDomainException {
        BigDecimal anzMonate = BigDecimal.ZERO;
        if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
            Date verglDatum;
            Date date2 = verglDatum = DateHelper.before((Date)this.eelib.marbEintritt(), (Date)this.gllib.firmaBerechnungsStart()) ? this.gllib.firmaBerechnungsStart() : this.eelib.marbEintritt();
            anzMonate = DateHelper.after((Date)verglDatum, (Date)DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb())) && DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2008, 0, 1).getDate()) ? BigDecimal.valueOf(new VDate(date).getMonth() - new VDate(verglDatum).getMonth() + 1) : BigDecimal.valueOf(new VDate(date).getMonth()).add(BigDecimal.ONE);
        } else {
            anzMonate = !this.erzeugeGrossbuchstabeS ? BigDecimal.valueOf(new VDate(date).getMonth()).add(BigDecimal.ONE) : (DateHelper.after((Date)this.eelib.marbEintritt(), (Date)DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb())) ? BigDecimal.valueOf(new VDate(date).getMonth() - new VDate(this.eelib.marbEintritt()).getMonth() + 1) : BigDecimal.valueOf(new VDate(date).getMonth()).add(BigDecimal.ONE));
        }
        return this.mJahresBruttoLfd.divide(anzMonate, 2, RoundingMode.DOWN);
    }

    private BigDecimal ermittleFiktiverVorverdiensFremderAG() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal steuerTage = this.ermittleSteuertageVorEintritt();
        result = BigDecimalMapper.isZeroOrNull((BigDecimal)this.eelib.massgeblicherMonatsverdienst()) ? result.add(this.mStPflMMArbLohn.multiply(steuerTage).divide(DREISSIG, 2, RoundingMode.HALF_UP)) : result.add(this.eelib.massgeblicherMonatsverdienst().multiply(steuerTage).divide(DREISSIG, 2, RoundingMode.HALF_UP));
        if (!BigDecimalMapper.isZero((BigDecimal)result) && !BigDecimalMapper.isZero((BigDecimal)steuerTage)) {
            this.erzeugeGrossbuchstabeS(result, steuerTage);
        }
        if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2010, 0, 1).getDate())) {
            this.mJahresBruttoLfd = this.mJahresBruttoLfd.add(result);
        }
        return result;
    }

    private void erzeugeGrossbuchstabeS(BigDecimal result, BigDecimal steuerTage) throws BusinessDomainException {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.genesisParentWPErgebnis())) {
            this.wplib.addNeueWertPosition(220695, BigDecimal.ZERO, BigDecimal.ZERO, steuerTage, BigDecimal.ZERO, result, true);
        }
    }

    private BigDecimal ermittleSteuertageVorEintritt() throws BusinessDomainException {
        int diffMMVorEintritt = PDateHelper.getDiffInMonths((Date)this.eelib.marbEintritt(), (Date)DateHelper.getFirstDayOfYear((Date)this.eelib.marbEintritt()));
        BigDecimal steuerTage = BigDecimal.valueOf(diffMMVorEintritt).multiply(DREISSIG);
        for (ValuePosition lElement : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.eelib.marbEintritt()), DateHelper.getLastDayOfMonth((Date)this.eelib.marbEintritt()), ValueTypeHelper.getValueTypes(110590))) {
            steuerTage = steuerTage.add(DREISSIG.subtract(lElement.getFactor1()));
        }
        return steuerTage;
    }

    private BigDecimal ermittleSteuerpflichtigenArbeitslohnBisVormonat() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb());
        ValueType[] vtArray = DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate()) ? ValueTypeHelper.getValueTypes(110510, 110610, 110620, 110630, 102580) : ValueTypeHelper.getValueTypes(110510, 110610, 110620);
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) {
            block5: for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), vtArray)) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 102580: {
                        this.mEntschInJArbLohn = this.mEntschInJArbLohn.add(vPos.getResult());
                        continue block5;
                    }
                    case 110510: {
                        this.mJahresBruttoLfd = this.mJahresBruttoLfd.add(vPos.getResult());
                    }
                    default: {
                        result = result.add(vPos.getResult());
                    }
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        return result;
    }

    public BigDecimal monatlicheIstStundenMitarbeiter() throws BusinessDomainException {
        return this.monatlicheIstStundenMitarbeiter(true);
    }

    public BigDecimal monatlicheIstStundenMitarbeiter(boolean einrechnungVonTeilweisenBeschaeftigungsverbot) throws BusinessDomainException {
        BigDecimal result = this.istZeit(new VDate(this.wplib.gueltigAb()).getMonth() + 1, new VDate(this.wplib.gueltigAb()).getYear(), 3, einrechnungVonTeilweisenBeschaeftigungsverbot);
        if (this.marbTeilzeit() && this.eelib.marbVHSatzTeilzeit().compareTo(BigDecimal.ZERO) != 0) {
            result = result.multiply(this.eelib.marbVHSatzTeilzeit()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        }
        return result;
    }

    public BigDecimal taeglicheSollstundenMitarbeiter() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellMitarbeiter() != null && (mAZ = this.arbeitszeitModellMitarbeiter().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getDailyTargetHours();
        }
        if (this.marbTeilzeit() && this.eelib.marbVHSatzTeilzeit().compareTo(BigDecimal.ZERO) != 0) {
            result = result.multiply(this.eelib.marbVHSatzTeilzeit()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        }
        return result;
    }

    public BigDecimal woechentlicheSollstundenMitarbeiter() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellMitarbeiter() != null && (mAZ = this.arbeitszeitModellMitarbeiter().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getWeeklyWorkingTime();
        }
        if (this.marbTeilzeit() && this.eelib.marbVHSatzTeilzeit().compareTo(BigDecimal.ZERO) != 0) {
            result = result.multiply(this.eelib.marbVHSatzTeilzeit()).divide(EINHUNDERT, 6, RoundingMode.HALF_UP);
            result = this.eelib.marbRundungTeilzeit().round(result);
        }
        return result;
    }

    public BigDecimal monatlicheKonkreteSollstundenMitarbeiter() throws BusinessDomainException {
        BigDecimal result = this.konkreteSollzeit(this.arbeitszeitModellMitarbeiter(), 1, 3);
        if (this.marbTeilzeit() && this.eelib.marbVHSatzTeilzeit().compareTo(BigDecimal.ZERO) != 0) {
            result = result.multiply(this.eelib.marbVHSatzTeilzeit()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        }
        return result;
    }

    public BigDecimal monatlicheFesteSollstundenMitarbeiter() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellMitarbeiter() != null && (mAZ = this.arbeitszeitModellMitarbeiter().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getMonthlyTargetHours();
        }
        if (this.marbTeilzeit() && this.eelib.marbVHSatzTeilzeit().compareTo(BigDecimal.ZERO) != 0) {
            result = result.multiply(this.eelib.marbVHSatzTeilzeit()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        }
        return result;
    }

    public BigDecimal jaehrlicheKonkreteSollstundenMitarbeiter() throws BusinessDomainException {
        BigDecimal result = this.konkreteSollzeit(this.arbeitszeitModellMitarbeiter(), 0, 3);
        if (this.marbTeilzeit() && this.eelib.marbVHSatzTeilzeit().compareTo(BigDecimal.ZERO) != 0) {
            result = result.multiply(this.eelib.marbVHSatzTeilzeit()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        }
        return result;
    }

    public BigDecimal jaehrlicheFesteSollstundenMitarbeiter() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellMitarbeiter() != null && (mAZ = this.arbeitszeitModellMitarbeiter().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getMonthlyTargetHours().multiply(ZWOELF);
        }
        if (this.marbTeilzeit() && this.eelib.marbVHSatzTeilzeit().compareTo(BigDecimal.ZERO) != 0) {
            result = result.multiply(this.eelib.marbVHSatzTeilzeit()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        }
        return result;
    }

    public BigDecimal monatlicheIsttageMitarbeiter() throws BusinessDomainException {
        return this.istZeit(new VDate(this.wplib.gueltigAb()).getMonth() + 1, new VDate(this.wplib.gueltigAb()).getYear(), 2, false);
    }

    public BigDecimal monatlicheKonkreteSolltageMitarbeiter() throws BusinessDomainException {
        return this.konkreteSollzeit(this.arbeitszeitModellMitarbeiter(), 1, 2);
    }

    public BigDecimal monatlicheFesteSolltageMitarbeiter() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellMitarbeiter() != null && (mAZ = this.arbeitszeitModellMitarbeiter().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getMonthlyTargetDays();
        }
        return result;
    }

    public BigDecimal jaehrlicheKonkreteSolltageMitarbeiter() throws BusinessDomainException {
        return this.konkreteSollzeit(this.arbeitszeitModellMitarbeiter(), 0, 2);
    }

    public BigDecimal jaehrlicheFesteSolltageMitarbeiter() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellMitarbeiter() != null && (mAZ = this.arbeitszeitModellMitarbeiter().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getMonthlyTargetDays().multiply(ZWOELF);
        }
        return result;
    }

    public BigDecimal taeglicheSollstundenBetrieb() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellBetrieb() != null && (mAZ = this.arbeitszeitModellBetrieb().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getDailyTargetHours();
        }
        return result;
    }

    public BigDecimal woechentlicheSollstundenBetrieb() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellBetrieb() != null && (mAZ = this.arbeitszeitModellBetrieb().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getWeeklyWorkingTime();
        }
        return result;
    }

    public BigDecimal monatlicheKonkreteSollstundenBetrieb() throws BusinessDomainException {
        return this.konkreteSollzeit(this.arbeitszeitModellBetrieb(), 1, 3);
    }

    public BigDecimal monatlicheFesteSollstundenBetrieb() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellBetrieb() != null && (mAZ = this.arbeitszeitModellBetrieb().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getMonthlyTargetHours();
        }
        return result;
    }

    public BigDecimal monatlicheKonkreteSolltageBetrieb() throws BusinessDomainException {
        return this.konkreteSollzeit(this.arbeitszeitModellBetrieb(), 1, 2);
    }

    public BigDecimal monatlicheFesteSolltageBetrieb() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellBetrieb() != null && (mAZ = this.arbeitszeitModellBetrieb().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getMonthlyTargetDays();
        }
        return result;
    }

    public BigDecimal jaehrlicheKonkreteSollstundenBetrieb() throws BusinessDomainException {
        return this.konkreteSollzeit(this.arbeitszeitModellBetrieb(), 0, 3);
    }

    public BigDecimal jaehrlicheFesteSollstundenBetrieb() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellBetrieb() != null && (mAZ = this.arbeitszeitModellBetrieb().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getMonthlyTargetHours().multiply(ZWOELF);
        }
        return result;
    }

    public BigDecimal jaehrlicheKonkreteSolltageBetrieb() throws BusinessDomainException {
        return this.konkreteSollzeit(this.mAZMBetrieb, 0, 2);
    }

    public BigDecimal jaehrlicheFesteSolltageBetrieb() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellBetrieb() != null && (mAZ = this.arbeitszeitModellBetrieb().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getMonthlyTargetDays().multiply(ZWOELF);
        }
        return result;
    }

    public boolean marbTeilzeit() throws BusinessDomainException {
        boolean partTime = false;
        if (this.eelib.marbArbeitsangaben() != null) {
            partTime = this.eelib.marbArbeitsangaben().getPartTimeWork();
        }
        return partTime;
    }

    public WorkingTime arbeitszeitModellMitarbeiter() throws BusinessDomainException {
        if (!this.mAZMMarbGeladen) {
            this.mAZMMarbGeladen = true;
            if (this.eelib.marbArbeitsangaben() != null) {
                this.mAZMMitarbeiter = this.eelib.marbArbeitsangaben().getWorkingTime();
            }
            if (this.mAZMMitarbeiter == null) {
                this.mAZMMitarbeiter = this.arbeitszeitModellBetrieb();
            }
        }
        return this.mAZMMitarbeiter;
    }

    private WorkingTime arbeitszeitModellBetrieb() throws BusinessDomainException {
        if (!this.mAZMFaGeladen) {
            this.mAZMFaGeladen = true;
            if (this.eelib.marbArbeitsangaben() != null) {
                this.mAZMBetrieb = this.eelib.marbArbeitsangaben().getDifferingWorkingTime();
            }
            if (this.mAZMBetrieb == null && this.eelib.marbBetriebsstaette() != null) {
                this.mAZMBetrieb = this.eelib.marbBetriebsstaette().getPlantFoundations(this.wplib.wirksamAb(), this.wplib.gueltigAb()).getFoundations().getWorkingTime();
            }
            if (this.mAZMBetrieb == null) {
                this.mAZMBetrieb = this.eelib.marbFirma().getCompanyFoundations(this.wplib.wirksamAb(), this.wplib.gueltigAb()).getFoundations().getWorkingTime();
            }
        }
        return this.mAZMBetrieb;
    }

    private BigDecimal istZeit(int monat, int jahr, int einheit, boolean einrechnungVonTeilweisenBeschaeftigungsverbot) throws BusinessDomainException {
        BigDecimal istZeit = BigDecimal.ZERO;
        FStateRegion fstateregion = this.eelib.marb().getFStateRegionForCalendar(this.wplib.wirksamAb(), this.wplib.gueltigAb());
        if (fstateregion != null) {
            FStateRegionCalendarTP[] bulaKalender = this.selectFStateRegionCalendar(fstateregion, monat, jahr, null, null);
            if (bulaKalender.length != 0) {
                istZeit = this.errechneIstZeit(this.arbeitszeitModellMitarbeiter(), bulaKalender, einheit, einrechnungVonTeilweisenBeschaeftigungsverbot);
            } else {
                throw EvaluationExceptionMapper.makeNoCalendarForYearDomainException(jahr);
            }
        }
        return istZeit;
    }

    private BigDecimal errechneIstZeit(WorkingTime arbeitsZeitModell, FStateRegionCalendarTP[] bulaKalender, int einheit, boolean einrechnungVonTeilweisenBeschaeftigungsverbot) throws BusinessDomainException {
        BigDecimal istZeitGesamt = BigDecimal.ZERO;
        WorkingTimeTP wttp = arbeitsZeitModell.getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb());
        this.fuelleWochenarbeitsstunden(wttp);
        block4: for (int i = 0; i < bulaKalender.length; ++i) {
            Date tagesDatum = bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getCalendarDate();
            if (!this.pruefeAnwesenheit(tagesDatum, einheit)) continue;
            switch (einheit) {
                case 2: {
                    if (this.wStdTabGefuellt) {
                        if (bulaKalender[i].getHighlyHoliday() || bulaKalender[i].getPublicHoliday()) {
                            if (bulaKalender[i].getWorkingDay()) {
                                if (BigDecimalMapper.isZero((BigDecimal)this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek()))) continue block4;
                                istZeitGesamt = istZeitGesamt.add(BigDecimal.ONE);
                                continue block4;
                            }
                            if (!wttp.isPaidPublicHoliday() || BigDecimalMapper.isZero((BigDecimal)this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek()))) continue block4;
                            istZeitGesamt = istZeitGesamt.add(BigDecimal.ONE);
                            continue block4;
                        }
                        if (BigDecimalMapper.isZero((BigDecimal)this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek()))) continue block4;
                        istZeitGesamt = istZeitGesamt.add(BigDecimal.ONE);
                        continue block4;
                    }
                    if (bulaKalender[i].getWorkingDay()) {
                        istZeitGesamt = istZeitGesamt.add(BigDecimal.ONE);
                        continue block4;
                    }
                    if (!bulaKalender[i].getPublicHoliday() && !bulaKalender[i].getHighlyHoliday() || !wttp.isPaidPublicHoliday()) continue block4;
                    istZeitGesamt = istZeitGesamt.add(BigDecimal.ONE);
                    continue block4;
                }
                case 3: {
                    BigDecimal istZeitTaeglich = BigDecimal.ZERO;
                    if (this.wStdTabGefuellt) {
                        if (bulaKalender[i].getHighlyHoliday() || bulaKalender[i].getPublicHoliday()) {
                            if (bulaKalender[i].getWorkingDay()) {
                                istZeitTaeglich = this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek());
                            } else if (wttp.isPaidPublicHoliday()) {
                                istZeitTaeglich = this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek());
                            }
                        } else {
                            istZeitTaeglich = this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek());
                        }
                    } else if (bulaKalender[i].getWorkingDay()) {
                        istZeitTaeglich = wttp.getDailyTargetHours();
                    } else if ((bulaKalender[i].getPublicHoliday() || bulaKalender[i].getHighlyHoliday()) && wttp.isPaidPublicHoliday()) {
                        istZeitTaeglich = wttp.getDailyTargetHours();
                    }
                    if (einrechnungVonTeilweisenBeschaeftigungsverbot) {
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mFehlStunden) && BigDecimalMapper.compareTo((BigDecimal)(istZeitTaeglich = istZeitTaeglich.subtract(this.mFehlStunden)), (BigDecimal)BigDecimal.ZERO) < 0) {
                            istZeitTaeglich = BigDecimal.ZERO;
                        }
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mArbeitsStunden)) {
                            istZeitTaeglich = BigDecimalMapper.compareTo((BigDecimal)istZeitTaeglich, (BigDecimal)this.mArbeitsStunden) > 0 ? this.mArbeitsStunden : BigDecimal.ZERO;
                        }
                    }
                    istZeitGesamt = istZeitGesamt.add(istZeitTaeglich);
                    continue block4;
                }
            }
        }
        return istZeitGesamt;
    }

    private boolean pruefeAnwesenheit(Date tagesDatum, int einheit) throws BusinessDomainException {
        Employment marbBesch = this.eelib.marb().getEmployment(this.wplib.wirksamAb(), this.wplib.gueltigAb());
        boolean result = false;
        this.mFehlStunden = BigDecimal.ZERO;
        this.mArbeitsStunden = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)tagesDatum, (Date)marbBesch.getDateOfEntry()) && !this.pruefeAustritt(marbBesch, tagesDatum)) {
            EEAbsentTimeTP[] fehlzeit = this.findeFehlzeiten(tagesDatum);
            if (fehlzeit.length == 0) {
                result = true;
            } else {
                for (int j = 0; j < fehlzeit.length; ++j) {
                    AbsentTime absentTime = fehlzeit[j].getEEAbsentTime().getAbsentTime();
                    if (this.callib.fehlzeitNichtBeruecksichtigen(absentTime)) {
                        result = true;
                        continue;
                    }
                    if (!absentTime.getAbsentTimeTP(this.wplib.wirksamAb(), tagesDatum).getCutByPartTimePayPeriod()) {
                        result = true;
                    }
                    if (einheit != 3) continue;
                    this.mFehlStunden = fehlzeit[j].getNumberOfHours();
                    this.mArbeitsStunden = fehlzeit[j].getNumberOfWorkingHours();
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mFehlStunden) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.mArbeitsStunden)) continue;
                    result = true;
                }
            }
        }
        return result;
    }

    private boolean pruefeAustritt(Employment marbBesch, Date tagesDatum) {
        boolean result = false;
        if (marbBesch.getDateOfWithDrawal() != null && DateHelper.after((Date)tagesDatum, (Date)marbBesch.getDateOfWithDrawal())) {
            result = true;
        }
        return result;
    }

    private BigDecimal leseWochenStundenTabelle(DayOfWeekEnum wochentag) {
        BigDecimal result = BigDecimal.ZERO;
        switch (wochentag.value()) {
            case 0: {
                result = this.wStdTab[0];
                break;
            }
            case 1: {
                result = this.wStdTab[1];
                break;
            }
            case 2: {
                result = this.wStdTab[2];
                break;
            }
            case 3: {
                result = this.wStdTab[3];
                break;
            }
            case 4: {
                result = this.wStdTab[4];
                break;
            }
            case 5: {
                result = this.wStdTab[5];
                break;
            }
            case 6: {
                result = this.wStdTab[6];
                break;
            }
        }
        return result;
    }

    private void fuelleWochenarbeitsstunden(WorkingTimeTP wttp) {
        this.wStdTab = new BigDecimal[7];
        if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getMondayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getTuesdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getWednesdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getThursdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getFridayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getSaturdayHours()) && BigDecimalMapper.isZeroOrNull((BigDecimal)wttp.getSundayHours()))) {
            this.wStdTabGefuellt = true;
            this.wStdTab[0] = wttp.getMondayHours();
            this.wStdTab[1] = wttp.getTuesdayHours();
            this.wStdTab[2] = wttp.getWednesdayHours();
            this.wStdTab[3] = wttp.getThursdayHours();
            this.wStdTab[4] = wttp.getFridayHours();
            this.wStdTab[5] = wttp.getSaturdayHours();
            this.wStdTab[6] = wttp.getSundayHours();
        }
    }

    private EEAbsentTimeTP[] findeFehlzeiten(Date tagesDatum) throws BusinessDomainException {
        return EEAbsentTimeTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.eelib.marb().getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.wplib.wirksamAb())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.wplib.wirksamAb())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)tagesDatum)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)tagesDatum))}), (boolean)true);
    }

    private BigDecimal konkreteSollzeit(WorkingTime arbeitszeitModell, int zeitraum, int einheit) throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        if (arbeitszeitModell != null) {
            FStateRegion region = this.eelib.marb().getFStateRegionForCalendar(this.wplib.wirksamAb(), this.wplib.gueltigAb());
            FStateRegionCalendarTP[] bulaKalender = new FStateRegionCalendarTP[]{};
            switch (zeitraum) {
                case 0: {
                    bulaKalender = this.selectFStateRegionCalendar(region, 0, new VDate(this.wplib.gueltigAb()).getYear(), null, null);
                    if (bulaKalender.length == 0) {
                        throw EvaluationExceptionMapper.makeNoCalendarForYearDomainException(new VDate(this.wplib.gueltigAb()).getYear());
                    }
                    new CalculationBasic(this.eelib.marb(), this.wplib.wirksamAb(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfYear((Date)this.wplib.gueltigAb())), arbeitszeitModell.getClass().getName());
                    break;
                }
                case 1: {
                    bulaKalender = this.selectFStateRegionCalendar(region, new VDate(this.wplib.gueltigAb()).getMonth() + 1, new VDate(this.wplib.gueltigAb()).getYear(), null, null);
                    if (bulaKalender.length == 0) {
                        throw EvaluationExceptionMapper.makeNoCalendarForYearDomainException(new VDate(this.wplib.gueltigAb()).getYear());
                    }
                    new CalculationBasic(this.eelib.marb(), this.wplib.wirksamAb(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb())), arbeitszeitModell.getClass().getName());
                    break;
                }
            }
            result = this.errechneSollZeit(arbeitszeitModell, bulaKalender, einheit);
        }
        return result;
    }

    private BigDecimal errechneSollZeit(WorkingTime arbeitszeitModell, FStateRegionCalendarTP[] bulaKalender, int einheit) throws BusinessDomainException {
        BigDecimal sollZeit = BigDecimal.ZERO;
        WorkingTimeTP wttp = arbeitszeitModell.getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb());
        this.fuelleWochenarbeitsstunden(wttp);
        block4: for (int i = 0; i < bulaKalender.length; ++i) {
            switch (einheit) {
                case 2: {
                    if (this.wStdTabGefuellt) {
                        if (bulaKalender[i].getHighlyHoliday() || bulaKalender[i].getPublicHoliday()) {
                            if (bulaKalender[i].getWorkingDay()) {
                                if (BigDecimalMapper.isZero((BigDecimal)this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek()))) continue block4;
                                sollZeit = sollZeit.add(BigDecimal.ONE);
                                continue block4;
                            }
                            if (!wttp.isPaidPublicHoliday() || BigDecimalMapper.isZero((BigDecimal)this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek()))) continue block4;
                            sollZeit = sollZeit.add(BigDecimal.ONE);
                            continue block4;
                        }
                        if (BigDecimalMapper.isZero((BigDecimal)this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek()))) continue block4;
                        sollZeit = sollZeit.add(BigDecimal.ONE);
                        continue block4;
                    }
                    if (bulaKalender[i].getWorkingDay()) {
                        sollZeit = sollZeit.add(BigDecimal.ONE);
                        continue block4;
                    }
                    if (!bulaKalender[i].getPublicHoliday() && !bulaKalender[i].getHighlyHoliday() || !wttp.isPaidPublicHoliday()) continue block4;
                    sollZeit = sollZeit.add(BigDecimal.ONE);
                    continue block4;
                }
                case 3: {
                    if (this.wStdTabGefuellt) {
                        if (bulaKalender[i].getHighlyHoliday() || bulaKalender[i].getPublicHoliday()) {
                            if (bulaKalender[i].getWorkingDay()) {
                                sollZeit = sollZeit.add(this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek()));
                                continue block4;
                            }
                            if (!wttp.isPaidPublicHoliday()) continue block4;
                            sollZeit = sollZeit.add(this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek()));
                            continue block4;
                        }
                        sollZeit = sollZeit.add(this.leseWochenStundenTabelle(bulaKalender[i].getFStateRegionCalendar().getCalendarDate().getDayOfWeek()));
                        continue block4;
                    }
                    if (bulaKalender[i].getWorkingDay()) {
                        sollZeit = sollZeit.add(wttp.getDailyTargetHours());
                        continue block4;
                    }
                    if (!bulaKalender[i].getPublicHoliday() && !bulaKalender[i].getHighlyHoliday() || !wttp.isPaidPublicHoliday()) continue block4;
                    sollZeit = sollZeit.add(wttp.getDailyTargetHours());
                    continue block4;
                }
            }
        }
        return sollZeit;
    }

    private FStateRegionCalendarTP[] selectFStateRegionCalendar(FStateRegion fstateregion, int month, int year, Date from, Date until) throws BusinessDomainException {
        Conjunction items = Restrictions.conjunction();
        items.add(Restrictions.eq((String)"oidfstateregion", (String)fstateregion.getObjectid()));
        items.add(Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.wplib.wirksamAb())));
        items.add(Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.wplib.wirksamAb())));
        items.add(Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)this.wplib.gueltigAb())));
        items.add(Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)this.wplib.gueltigAb())));
        if (month != 0) {
            items.add(Restrictions.eq((String)"mm", (String)Integer.toString(month)));
        }
        if (year != 0) {
            items.add(Restrictions.eq((String)"yyyy", (String)Integer.toString(year)));
        }
        if (from != null) {
            items.add(Restrictions.ge((String)"calendardate", (String)DateMapper.toString((Date)from)));
        }
        if (until != null) {
            items.add(Restrictions.le((String)"calendardate", (String)DateMapper.toString((Date)until)));
        }
        return FStateRegionCalendarTPPersistencyManager.getFStateRegionCalendar((Order[])new Order[]{Order.asc((String)"calendardate")}, (Criterion)items);
    }

    public BigDecimal maximalerZeitgrad() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        if (this.eelib.marbArbeitsangaben() == null) {
            result = this.gllib.maximalerZeitgrad();
        } else {
            result = this.eelib.marbArbeitsangaben().getMaxlLaborUtilizationRate();
            if (result.compareTo(BigDecimal.ZERO) == 0) {
                result = this.gllib.maximalerZeitgrad();
            }
        }
        return result;
    }

    public BigDecimal minimalerZeitgrad() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        if (this.eelib.marbArbeitsangaben() == null) {
            result = this.gllib.minimalerZeitgrad();
        } else {
            result = this.eelib.marbArbeitsangaben().getMinLaborUtilizationRate();
            if (result.compareTo(BigDecimal.ZERO) == 0) {
                result = this.gllib.minimalerZeitgrad();
            }
        }
        return result;
    }

    public BigDecimal woechentlicheSollstundenMitarbeiterVM() throws BusinessDomainException {
        WorkingTimeTP mAZ;
        BigDecimal result = BigDecimal.ZERO;
        if (this.arbeitszeitModellMitarbeiterVM() != null && (mAZ = this.arbeitszeitModellMitarbeiterVM().getWorkingTimeTP(this.wplib.wirksamAb(), this.wplib.gueltigAb())) != null) {
            result = mAZ.getWeeklyWorkingTime();
        }
        if (this.marbTeilzeit() && this.eelib.marbVHSatzTeilzeit().compareTo(BigDecimal.ZERO) != 0) {
            result = result.multiply(this.eelib.marbVHSatzTeilzeit()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        }
        return result;
    }

    private WorkingTime arbeitszeitModellMitarbeiterVM() throws BusinessDomainException {
        if (!this.mAZMMarbVMGeladen) {
            this.mAZMMarbVMGeladen = true;
            if (this.eelib.marbArbeitsangabenVM() != null) {
                this.mAZMMitarbeiterVM = this.eelib.marbArbeitsangabenVM().getWorkingTime();
            }
            if (this.mAZMMitarbeiterVM == null) {
                this.mAZMMitarbeiterVM = this.arbeitszeitModellBetriebVM();
            }
        }
        return this.mAZMMitarbeiterVM;
    }

    private WorkingTime arbeitszeitModellBetriebVM() throws BusinessDomainException {
        if (!this.mAZMFaVMGeladen) {
            this.mAZMFaVMGeladen = true;
            if (this.eelib.marbArbeitsangabenVM() != null) {
                this.mAZMBetriebVM = this.eelib.marbArbeitsangabenVM().getDifferingWorkingTime();
            }
            if (this.mAZMBetriebVM == null && this.eelib.marbBetriebsstaette() != null) {
                this.mAZMBetriebVM = this.eelib.marbBetriebsstaette().getPlantFoundations(this.wplib.wirksamAb(), DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb())))).getFoundations().getWorkingTime();
            }
            if (this.mAZMBetriebVM == null) {
                this.mAZMBetriebVM = this.eelib.marbFirma().getCompanyFoundations(this.wplib.wirksamAb(), DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb())))).getFoundations().getWorkingTime();
            }
        }
        return this.mAZMBetriebVM;
    }

    public BigDecimal vergleichsnettoAufBasisVormonat(Date beginEFK) throws BusinessDomainException {
        BigDecimal netto = BigDecimal.ZERO;
        Date selDate = new VDate(this.callib.berchnungGueltigAb()).addMonths(-1).getDate();
        Date suchDatum = DateHelper.yesterday((Date)beginEFK);
        while (suchDatum != null) {
            EEAbsentTimeTP[] fehlzeiten = this.getFehlzeiten(suchDatum);
            if (fehlzeiten.length == 0) {
                suchDatum = null;
                continue;
            }
            if (StringMapper.equal((String)fehlzeiten[0].getEEAbsentTime().getAbsentTime().getAbsentTimeKey(), (String)"EFK") || StringMapper.equal((String)fehlzeiten[0].getEEAbsentTime().getAbsentTime().getAbsentTimeKey(), (String)"EFZ") || StringMapper.equal((String)fehlzeiten[0].getEEAbsentTime().getAbsentTime().getAbsentTimeKey(), (String)"EFU") || StringMapper.equal((String)fehlzeiten[0].getEEAbsentTime().getAbsentTime().getAbsentTimeKey(), (String)"EFS")) {
                selDate = new VDate(fehlzeiten[0].getValidFrom()).addMonths(-1).getDate();
                suchDatum = DateHelper.yesterday((Date)fehlzeiten[0].getValidFrom());
                continue;
            }
            suchDatum = null;
        }
        ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.callib.berchnungGueltigAb())), DateHelper.yesterday((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes(this.wplib.wertartenNummer()));
        if (vpArray.length == 0) {
            Date lVerglDatum;
            BigDecimal svTage = BigDecimal.ZERO;
            Date date = lVerglDatum = DateHelper.beforeOrEqual((Date)this.eelib.marbEintritt(), (Date)this.gllib.firmaBerechnungsStart()) ? this.gllib.firmaBerechnungsStart() : this.eelib.marbEintritt();
            while (svTage.compareTo(DREISSIG) != 0 && DateHelper.afterOrEqual((Date)selDate, (Date)lVerglDatum)) {
                svTage = BigDecimal.ZERO;
                netto = BigDecimal.ZERO;
                block7: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), DateHelper.getFirstDayOfMonth((Date)selDate), DateHelper.getLastDayOfMonth((Date)selDate), ValueTypeHelper.getValueTypes(130590, 700400, 770020, 770025, 770120, 770110, 770000, 770005, 770010, 771020, 771120, 771110, 771000, 771010, 774510, 774511, 774512, 774514, 774550, 774610, 774620, 774630, 774730, 774760, 774761, 774762, 774764, 774800, 774860, 774870, 774880, 774980, 775510, 775512, 775514, 775520, 775550, 775555, 775560, 775610, 775620, 775630, 775640, 775650, 775655, 775720, 775725, 775730))) {
                    switch (vPos.getValueType().getValueTypeKey()) {
                        case 130590: {
                            svTage = svTage.add(vPos.getFactor1());
                            continue block7;
                        }
                        case 700400: {
                            netto = netto.add(vPos.getResult());
                            continue block7;
                        }
                        case 770020: 
                        case 770025: 
                        case 770120: 
                        case 771020: 
                        case 771120: 
                        case 775510: 
                        case 775512: 
                        case 775514: 
                        case 775520: 
                        case 775550: 
                        case 775555: 
                        case 775560: 
                        case 775610: 
                        case 775620: 
                        case 775630: 
                        case 775640: 
                        case 775650: 
                        case 775655: 
                        case 775720: 
                        case 775725: 
                        case 775730: {
                            netto = netto.add(vPos.getResult());
                            continue block7;
                        }
                        default: {
                            netto = netto.subtract(vPos.getResult());
                        }
                    }
                }
                selDate = new VDate(selDate).addMonths(-1).getDate();
            }
        } else {
            for (ValuePosition vPos : vpArray) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer5())) continue;
                netto = vPos.getPersistentBuffer5();
                this.wplib.persistentBuffer5(netto);
            }
        }
        return netto;
    }

    private EEAbsentTimeTP[] getFehlzeiten(Date validDate) throws BusinessDomainException {
        EEAbsentTimeTP[] fehlzeiten = this.eelib.marb().getEEAbsentTimesTP(new Order[]{Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.eelib.marb().getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungWirksamAb()))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validDate)), Restrictions.ge((String)"validUntil", (String)DateMapper.toString((Date)validDate))}), true);
        return fehlzeiten;
    }
}

