/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.libraryimpl;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.taskreminder.TaskReminder;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFund;
import com.varial.personnel.domain.assignments.pcompanyhealthfund.AssignmentPCompanyHealthFundTP;
import com.varial.personnel.domain.assignments.pcompanyzvk.AssignmentPCompanyZVKTP;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.calculation.CalculationCase;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.companyplant.GeneralCommunity;
import com.varial.personnel.domain.companyplant.ModeOfProcedureEnum;
import com.varial.personnel.domain.companyplant.PensionschemeSettingsEnum;
import com.varial.personnel.domain.companyplant.ZvkSettingsEnum;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.ContributionScalePHIEnum;
import com.varial.personnel.domain.employee.insurance.ContributionScaleVHIEnum;
import com.varial.personnel.domain.employee.insurance.TypeAgePartTimeEnum;
import com.varial.personnel.domain.employee.pensionscheme.ContractTypeEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.vblu.VbluImplementationPathEnum;
import com.varial.personnel.domain.employee.zvk.ZvkTypeOfCalcAddContEnum;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.global.ageparttimemodel.AgePartTimeModel;
import com.varial.personnel.domain.global.ageparttimemodel.AgePartTimeModelTP;
import com.varial.personnel.domain.global.ageparttimemodel.ContractEnum;
import com.varial.personnel.domain.global.childallowance.ChildAllowance;
import com.varial.personnel.domain.global.childallowance.ChildAllowanceTP;
import com.varial.personnel.domain.global.community.Community;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.deuv.sender.DEUVSenderTP;
import com.varial.personnel.domain.global.eramodel.ERAModelTP;
import com.varial.personnel.domain.global.federalstate.FederalState;
import com.varial.personnel.domain.global.federalstate.FederalStateTP;
import com.varial.personnel.domain.global.fstateregion.FStateRegion;
import com.varial.personnel.domain.global.fstateregion.FStateRegionPersistencyManager;
import com.varial.personnel.domain.global.fstateregion.contributions.FStateRegionContributionsTP;
import com.varial.personnel.domain.global.healthfund.Assessment;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.lumpsumitax.ConsolidationIntoALumpSumEnum;
import com.varial.personnel.domain.global.lumpsumitax.LumpSumIncomeTax;
import com.varial.personnel.domain.global.lumpsumitax.LumpSumIncomeTaxTP;
import com.varial.personnel.domain.global.recipient.Recipient;
import com.varial.personnel.domain.global.recipient.RecipientTP;
import com.varial.personnel.domain.global.recipient.vblu.VBLU;
import com.varial.personnel.domain.global.recipient.zvk.TypeOfZvkEnum;
import com.varial.personnel.domain.global.recipient.zvk.ZVK;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurance;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurancePersistencyManager;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTP;
import com.varial.personnel.domain.payscale.increaseinpayrates.IncreaseInPayRates;
import com.varial.personnel.domain.payscale.increaseinpayrates.IncreaseInPayRatesPersistencyManager;
import com.varial.personnel.domain.payscale.increaseinpayrates.IncreaseInPayRatesTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.pcompany.settings.CompanySettings;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.foundations.PlantFoundations;
import com.varial.personnel.domain.plant.place.PlantPlace;
import com.varial.personnel.domain.plant.place.PlantPlaceTP;
import com.varial.personnel.domain.plant.settings.PlantSettings;
import com.varial.personnel.domain.plant.taxoffice.PlantTaxOffice;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.taskreminder.TaskReminderHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class GlobalLibraryImpl
implements GlobalLibrary {
    private static final BigDecimal BD100 = BigDecimal.valueOf(100L);
    private static final BigDecimal BD2 = BigDecimal.valueOf(2L);
    private static final BigDecimal BD3 = BigDecimal.valueOf(3L);
    private static final BigDecimal BD20 = BigDecimal.valueOf(20L);
    private static final BigDecimal BD12 = BigDecimal.valueOf(12L);
    private static final BigDecimal BD30 = BigDecimal.valueOf(30L);
    private static final BigDecimal BD360 = BigDecimal.valueOf(360L);
    private static final BigDecimal BD4 = BigDecimal.valueOf(4L);
    private final CalculationCase cCase;
    private CompanyFoundations compFounds = null;
    private boolean compFoundsLd = false;
    private CompanySettings compSettings = null;
    private boolean compSettingsLd = false;
    private BigDecimal grenzeErhoehungsUmlage = BigDecimal.ZERO;
    private boolean grenzeErhoehungsUmlageLoaded = false;
    private boolean egaVorhandenImVerdoppelungsmonat = false;
    private final boolean egaVorhandenImVerdoppelungsmonatLoaded = false;
    private boolean krvLoaded = false;
    private AgePartTimeModel mAgePartTimeModel = null;
    private AgePartTimeModelTP mAPTModelTP = null;
    private boolean mAPTModelTPLd = false;
    private AssignmentPCompanyHealthFund mAssPCompHF = null;
    private boolean mAssPCompHFLd = false;
    private BigDecimal maximalGrenze;
    private boolean maximalGrenzeLoaded = false;
    private final EmployeeLibrary mEELib;
    private Date mERACompareMonth;
    private boolean mERAComparisonMonthLoaded = false;
    private boolean mERAModellTPLoaded = false;
    private ERAModelTP mERAModelTP;
    private Date mERAStart;
    private boolean mERAStartLoaded = false;
    protected FederalState mFederalState = null;
    protected boolean mFederalStateLd = false;
    protected FStateRegion mFStateRegion = null;
    protected boolean mFStateRegionLd = false;
    private HealthFundTP mHealthFund = null;
    private HealthFundTP mHealthFundKVdR = null;
    private boolean mHealthFundLoaded = false;
    private boolean mHFKVdRLoaded = false;
    private int mKrv;
    private boolean mRegContTPKiStLd = false;
    private FStateRegionContributionsTP mRegionContTP = null;
    private FStateRegionContributionsTP mRegionContTPKiSt = null;
    private boolean mRegionContTPLd = false;
    private FStateRegion mRegionKiSt = null;
    private boolean mRegionKiStLd = false;
    private boolean mSocialInsLd = false;
    private SocialInsuranceTP mSocialInsurance = null;
    private AssignmentPCompanyZVKTP mZuordnungZVK;
    private boolean mZuordnungZVKLoaded = false;
    private boolean plantFoundLd = false;
    private PlantFoundations plantFounds = null;
    private PlantSettings plantSettings = null;
    private boolean plantSettingsLd = false;
    private final ValuePosition vPosition;
    private boolean mFederalStateTPLd = false;
    private FederalStateTP mFederalStateTP;
    private PlantPlaceTP mPPTP;
    private boolean mPPTPLoaded = false;
    private RecipientTP mZvkRecipientTP = null;
    private boolean mZvkRecipientLoaded = false;
    private RecipientTP mVbluRecipientTP = null;
    private boolean mVbluRecipientLoaded = false;
    private final ReportHelper mReportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);

    public GlobalLibraryImpl(ValuePosition valuePosition, CalculationCase calculationCase, EmployeeLibrary eeLib) {
        this.vPosition = valuePosition;
        this.cCase = calculationCase;
        this.mEELib = eeLib;
    }

    @Override
    public BigDecimal bulaPvAga() throws BusinessDomainException {
        BigDecimal bsPVAGA = this.getFStateRegionContributionsTP() == null ? BigDecimal.ZERO : this.getFStateRegionContributionsTP().getERContribRateNI();
        return bsPVAGA;
    }

    @Override
    public int bundeslandSchluesselBeschaeftigungsort() throws BusinessDomainException {
        int bulaSchluessel = this.getFederalState() == null ? 0 : this.getFederalState().getFederalState();
        return bulaSchluessel;
    }

    @Override
    public Date comparisonMonthERA() throws BusinessDomainException {
        if (!this.mERAComparisonMonthLoaded) {
            this.mERAComparisonMonthLoaded = true;
            if (this.getPlantFoundations() == null || this.getPlantFoundations().getFoundations().getEraModel() == null) {
                if (this.getCompanyFoundations().getFoundations().getEraModel() != null) {
                    this.mERACompareMonth = this.getCompanyFoundations().getFoundations().getEraComparisonMonth();
                }
            } else {
                this.mERACompareMonth = this.getPlantFoundations().getFoundations().getEraComparisonMonth();
            }
        }
        return this.mERACompareMonth;
    }

    @Override
    public boolean isERAVierundfuenfzigerRegelung() throws BusinessDomainException {
        return this.getERAModellTP().isRegulation54();
    }

    @Override
    public boolean isTariferhoehungUberschreiterZulage() throws BusinessDomainException {
        return this.getERAModellTP().getIncreaseOfExcess();
    }

    private BigDecimal ermittelKalendertageMitarbeiterFuerKuerzungGlobalerParameter() throws BusinessDomainException {
        Integer[] mDays = new Integer[new VDate(DateHelper.getLastDayOfMonth((Date)this.vPosition.getValidFrom())).getDay()];
        for (int i = 0; i < mDays.length; ++i) {
            mDays[i] = 1;
        }
        Date ersterDesMonats = DateHelper.getFirstDayOfMonth((Date)this.vPosition.getValidFrom());
        Date letzterDesMonats = DateHelper.getLastDayOfMonth((Date)ersterDesMonats);
        if (this.mEELib.marbAustritt() != null && DateHelper.between((Date)this.mEELib.marbAustritt(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
            for (int index = new VDate(this.mEELib.marbAustritt()).getDay(); index < mDays.length; ++index) {
                mDays[index] = 0;
            }
        }
        if (DateHelper.between((Date)this.mEELib.marbEintritt(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
            int eintrittsTag = new VDate(this.mEELib.marbEintritt()).getDay();
            for (int i = 0; i < eintrittsTag - 1; ++i) {
                mDays[i] = 0;
            }
        }
        EEAbsentTimeTP[] fehlzeiten = this.mEELib.aktuelleFehlzeiten();
        int start = 0;
        int ende = mDays.length - 1;
        for (EEAbsentTimeTP element : fehlzeiten) {
            if (element.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom()).getCutOfSocialInsuranceDays().value() == 0 || DateHelper.before((Date)element.getValidUntil(), (Date)ersterDesMonats) || DateHelper.after((Date)element.getValidFrom(), (Date)letzterDesMonats)) continue;
            if (DateHelper.between((Date)element.getValidFrom(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
                start = new VDate(element.getValidFrom()).getDay() - 1;
            }
            if (DateHelper.between((Date)element.getValidUntil(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
                ende = new VDate(element.getValidUntil()).getDay() - 1;
            }
            for (int j = start; j <= ende; ++j) {
                mDays[j] = 0;
            }
        }
        BigDecimal kalendertage = BigDecimal.ZERO;
        for (Integer mDay : mDays) {
            kalendertage = kalendertage.add(BigDecimal.valueOf(mDay.longValue()));
        }
        if (BigDecimalMapper.compareTo((BigDecimal)kalendertage, (BigDecimal)BigDecimal.valueOf(new VDate(DateHelper.getLastDayOfMonth((Date)this.vPosition.getValidFrom())).getDay())) != 0) {
            new CalculationBasic(this.vPosition.getEmployee(), this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom(), this.getClass().getName());
        }
        return kalendertage;
    }

    @Override
    public void erzeugeWiedervorlage(int plausi, String zusatz) throws BusinessDomainException {
        String reminderName = this.getRemindername(plausi, zusatz);
        String reminderNote = this.getReminderNote(plausi, zusatz);
        Date reminderDate = this.cCase.getValidFrom();
        if (TaskReminderHelper.existsTaskReminderInCalculationCase((CalculationCase)this.cCase, (String)reminderName, (Date)reminderDate)) {
            return;
        }
        if (TaskReminderHelper.existsTaskReminder((String)reminderName, (Date)reminderDate)) {
            return;
        }
        TaskReminder reminder = TaskReminderHelper.createTaskReminder((String)reminderName, (Date)reminderDate, (String)reminderNote, (String)SessionContext.getInstance().getSession().getUserCode());
        this.cCase.addTaskreminder(reminder);
    }

    private String getReminderNote(int plausi, String zusatz) {
        switch (plausi) {
            case 1: {
                return "Mitarbeiter, die weder in der RV pflichtig noch einer berufsst\u00e4ndischen Versorgung versichert sind, bekommen keine VBLU-Berechnung.";
            }
            case 2: {
                return "Mitarbeiter mit Steuerklasse 6 sollten auf die Fortf\u00fchrung ihres VBLU-Neuvertr\u00e4gen angesprochen werden.";
            }
            case 3: {
                return "Mitarbeiter mit Steuerklasse 6 sollten auf die Fortf\u00fchrung ihres VBLU-Altvertrages angesprochen werden.";
            }
            case 4: {
                return "Mitarbeiter mit Steuerklasse 1 bis 5 sollten auf die Fortf\u00fchrung ihres steuer- und SV-pflichtigen VBLU-Vertrages angesprochen werden.";
            }
            case 5: {
                return "Mitarbeiter mit Beitragsgruppe RV Halber Beitrag (AG) sollten auf die Fortf\u00fchrung ihres VBLU-Vertrages angesprochen werden.";
            }
            case 6: {
                return "Mitarbeiter mit Beitragsgruppe RV Pauschalbeitrag GfB (AG) sollten auf die Fortf\u00fchrung ihres VBLU-Vertrages angesprochen werden.";
            }
            case 7: {
                return "Der Mitarbeiter " + this.mEELib.marb().getPersonnelnumber() + " hat Steuerklasse 6 und BAV mit AN-finanzierter Aufwendung " + zusatz + ".";
            }
            case 8: {
                return "Der Mitarbeiter " + this.mEELib.marb().getPersonnelnumber() + " mit BAV-Vertrag und Beitragsgruppe RV " + zusatz + ".";
            }
            case 9: {
                return "Der Mitarbeiter " + this.mEELib.marb().getPersonnelnumber() + " mit BAV-Vertrag ohne Versorgungseinrichtung.";
            }
        }
        return "";
    }

    private String getRemindername(int plausi, String zusatz) {
        String reminderName = "";
        switch (plausi) {
            case 1: {
                reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.vPosition.getEmployee(), (String)"bitte \u00fcberpr\u00fcfen VBLU-Vertrag ohne RV ");
                break;
            }
            case 2: {
                reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.vPosition.getEmployee(), (String)"bitte \u00fcberpr\u00fcfen VBLU-Neuvertrag und StKl 6 ");
                break;
            }
            case 3: {
                reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.vPosition.getEmployee(), (String)"bitte \u00fcberpr\u00fcfen VBLU-Altvertrag und StKl 6 ");
                break;
            }
            case 4: {
                reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.vPosition.getEmployee(), (String)"bitte \u00fcberpr\u00fcfen steuer- und SV-pflichtigen VBLU-Vertrag und Steuerklasse ungleich 6 ");
                break;
            }
            case 5: {
                reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.vPosition.getEmployee(), (String)"bitte \u00fcberpr\u00fcfen VBLU-Vertrag und Beitragsgruppe RV Halber Beitrag (AG) ");
                break;
            }
            case 6: {
                reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.vPosition.getEmployee(), (String)"bitte \u00fcberpr\u00fcfen VBLU-Vertrag und Beitragsgruppe RV Pauschalbeitrag GfB (AG) ");
                break;
            }
            case 7: {
                reminderName = TaskReminderHelper.getIndividualMessageWithCompanyCodeAndPersonnelnumber((Employee)this.vPosition.getEmployee(), (String)"bitte \u00fcberpr\u00fcfen Steuerklasse 6 und BAV mit AN-finanzierter Aufwendung: ", (String)zusatz);
                break;
            }
            case 8: {
                reminderName = TaskReminderHelper.getIndividualMessageWithCompanyCodeAndPersonnelnumber((Employee)this.vPosition.getEmployee(), (String)"bitte \u00fcberpr\u00fcfen BAV-Vertrag und Beitragsgruppe RV: ", (String)zusatz);
                break;
            }
            case 9: {
                reminderName = TaskReminderHelper.getFixedMessageWithCompanyCodeAndPersonnelnumber((Employee)this.vPosition.getEmployee(), (String)"bitte \u00fcberpr\u00fcfen BAV-Vertrag ohne Versorgungseinrichtung ");
                break;
            }
            default: {
                reminderName = "";
            }
        }
        return reminderName;
    }

    @Override
    public void erzeugeWiedervorlage23cWerteFehlzeit(EEAbsentTimeTP timeTP) throws BusinessDomainException {
        String reminderName = TaskReminderHelper.getIndividualMessageWithCompanyCodeAndPersonnelnumber((Employee)timeTP.getEEAbsentTime().getEmployee(), (String)"fehlen Werte zur Berechnung des \u00a7 23c SGB IV in der Fehlzeit: ", (String)(timeTP.getEEAbsentTime().getAbsentTime().getAbsentTimeKey() + " vom " + DateMapper.toDDMMYYYYPointSeparationString((Date)timeTP.getValidFrom())));
        String reminderNote = "Das Vergleichsnetto und das kalendert\u00e4gliche Krankengeld sind notwendige Werte f\u00fcr die Berechnung des beitragspflichtigen Anteils \neiner Arbeitgeberleistung au\u00dferhalb der Entgeltfortzahlung";
        Date reminderDate = timeTP.getValidFrom();
        if (TaskReminderHelper.existsTaskReminderInCalculationCase((CalculationCase)this.cCase, (String)reminderName, (Date)reminderDate)) {
            return;
        }
        if (TaskReminderHelper.existsTaskReminder((String)reminderName, (Date)reminderDate)) {
            return;
        }
        TaskReminder reminder = TaskReminderHelper.createTaskReminder((String)reminderName, (Date)reminderDate, (String)"Das Vergleichsnetto und das kalendert\u00e4gliche Krankengeld sind notwendige Werte f\u00fcr die Berechnung des beitragspflichtigen Anteils \neiner Arbeitgeberleistung au\u00dferhalb der Entgeltfortzahlung", (String)SessionContext.getInstance().getSession().getUserCode());
        this.cCase.addTaskreminder(reminder);
    }

    @Override
    public void erzeugeWiedervorlageBruchteileVonCent(int valueTypeKey) throws BusinessDomainException {
        String reminderName = "Der Wertart " + String.valueOf(valueTypeKey) + " produziert Bruchteile von Cent im Bruttolohn.";
        String reminderNote = "Der Wertart " + String.valueOf(valueTypeKey) + " mu\u00df in ihrer Beschreibung so modifiziert werden, dass keine Bruchteile von Cent-Betr\u00e4gen in den Bruttolohn gelangen k\u00f6nnen.\nBitte wenden Sie sich mit Ihren Fragen an Ihren Fachberater.";
        Date reminderDate = DateHelper.after((Date)this.firmaBerechnungsStart(), (Date)new VDate(2007, 0, 1).getDate()) ? this.firmaBerechnungsStart() : new VDate(2007, 0, 1).getDate();
        if (TaskReminderHelper.existsTaskReminderInCalculationCase((CalculationCase)this.cCase, (String)reminderName, (Date)reminderDate)) {
            return;
        }
        if (TaskReminderHelper.existsTaskReminder((String)reminderName, (Date)reminderDate)) {
            return;
        }
        TaskReminder reminder = TaskReminderHelper.createTaskReminder((String)reminderName, (Date)reminderDate, (String)reminderNote, (String)SessionContext.getInstance().getSession().getUserCode());
        this.cCase.addTaskreminder(reminder);
    }

    @Override
    public Date firmaBerechnungsStart() throws BusinessDomainException {
        return this.mReportHelper.getCalculationStartDate(this.getCompanyFoundations());
    }

    private AssignmentPCompanyHealthFund getAssesmentPCompanyHealthFund(HealthFund healthFund) throws BusinessDomainException {
        block3: {
            AssignmentPCompanyHealthFund[] aphArray;
            block4: {
                if (this.mAssPCompHFLd) break block3;
                this.mAssPCompHFLd = true;
                aphArray = AssignmentPCompanyHealthFund.getAssignmentPCompanyHealthFund((PCompany)this.vPosition.getEmployee().getPCompany(), (HealthFund)healthFund);
                if (this.getPlantFoundations() != null) break block4;
                for (AssignmentPCompanyHealthFund element : aphArray) {
                    if (element.getPlant() != null) continue;
                    this.mAssPCompHF = element;
                }
                break block3;
            }
            boolean gefunden = false;
            for (AssignmentPCompanyHealthFund element : aphArray) {
                if (element.getPlant() == null || !StringMapper.equal((String)element.getPlant().getObjectid(), (String)this.getPlantFoundations().getPlant().getObjectid())) continue;
                this.mAssPCompHF = element;
                gefunden = true;
            }
            if (gefunden) break block3;
            for (AssignmentPCompanyHealthFund element : aphArray) {
                if (element.getPlant() != null) continue;
                this.mAssPCompHF = element;
            }
        }
        return this.mAssPCompHF;
    }

    private AssignmentPCompanyZVKTP getAssesmentPCompanyZVK(Recipient zvk) throws BusinessDomainException {
        block5: {
            if (!this.mZuordnungZVKLoaded) {
                this.mZuordnungZVKLoaded = true;
                try {
                    this.mZuordnungZVK = AssignmentPCompanyZVKTP.getAssignmentZVKTP((Recipient)zvk, (PCompany)this.mEELib.marbFirma(), (Plant)this.mEELib.marbBetriebsstaette(), (Date)this.cCase.getEffectiveFrom(), (Date)this.cCase.getValidFrom());
                    if (this.mZuordnungZVK == null) {
                        throw EvaluationExceptionMapper.makeNoAssignmentPCompanyZVK(zvk, this.mEELib.marbFirma(), this.mEELib.marbBetriebsstaette(), this.cCase.getEffectiveFrom(), this.cCase.getValidFrom());
                    }
                    if (!DateHelper.equal((Date)this.mZuordnungZVK.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.cCase.getEmployee(), this.cCase.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mZuordnungZVK.getValidUntil()), this.mZuordnungZVK.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block5;
                    throw e;
                }
            }
        }
        return this.mZuordnungZVK;
    }

    protected CompanyFoundations getCompanyFoundations() throws BusinessDomainException {
        block4: {
            if (!this.compFoundsLd) {
                this.compFoundsLd = true;
                try {
                    this.compFounds = this.mEELib.marbFirma().getCompanyFoundations(this.cCase.getEffectiveFrom(), this.cCase.getValidFrom());
                    if (!DateHelper.equal((Date)this.compFounds.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.cCase.getEmployee(), this.cCase.getEffectiveFrom(), DateHelper.tomorrow((Date)this.compFounds.getValidUntil()), this.compFounds.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
        }
        return this.compFounds;
    }

    private CompanySettings getCompanySettings() throws BusinessDomainException {
        block4: {
            if (!this.compSettingsLd) {
                this.compSettingsLd = true;
                try {
                    this.compSettings = this.mEELib.marbFirma().getCompanySettings(this.cCase.getEffectiveFrom(), this.cCase.getValidFrom());
                    if (!DateHelper.equal((Date)this.compSettings.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.cCase.getEmployee(), this.cCase.getEffectiveFrom(), DateHelper.tomorrow((Date)this.compSettings.getValidUntil()), this.compSettings.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
        }
        return this.compSettings;
    }

    @Override
    public boolean getERAJahrVollstaendig() throws BusinessDomainException {
        VDate eraVergleichsdatum = new VDate(DateHelper.getFirstDayOfMonth((Date)this.startERA()));
        int anzMonateBisERAErhoehung = this.getERAModellTP().getMonthForUndercut();
        eraVergleichsdatum = eraVergleichsdatum.addMonths(anzMonateBisERAErhoehung);
        boolean result = false;
        while (DateHelper.beforeOrEqual((Date)eraVergleichsdatum.getDate(), (Date)this.cCase.getValidFrom())) {
            if (DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.cCase.getValidFrom()), (Date)DateHelper.getFirstDayOfMonth((Date)eraVergleichsdatum.getDate()))) {
                result = true;
            }
            eraVergleichsdatum = eraVergleichsdatum.addMonths(anzMonateBisERAErhoehung);
        }
        if (!result) {
            new CalculationBasic(this.mEELib.marb(), this.cCase.getEffectiveFrom(), eraVergleichsdatum.getDate(), ERAModelTP.class.getName());
        }
        return result;
    }

    @Override
    public ERAModelTP getERAModellTP() throws BusinessDomainException {
        if (!this.mERAModellTPLoaded) {
            this.mERAModellTPLoaded = true;
            if (this.getPlantFoundations() == null || this.getPlantFoundations().getFoundations().getEraModel() == null) {
                if (this.getCompanyFoundations().getFoundations().getEraModel() == null) {
                    throw EvaluationExceptionMapper.makeNoEraModelAvailableDomainException(this.vPosition.getValidFrom(), this.vPosition.getValueType().getValueTypeKey());
                }
                this.mERAModelTP = this.getCompanyFoundations().getFoundations().getEraModel().getERAModelTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
                if (!DateHelper.equal((Date)this.mERAModelTP.getValidUntil(), (Date)VDate.getDateMax())) {
                    new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mERAModelTP.getValidUntil()), this.mERAModelTP.getClassName());
                }
            } else {
                this.mERAModelTP = this.getPlantFoundations().getFoundations().getEraModel().getERAModelTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
                if (!DateHelper.equal((Date)this.mERAModelTP.getValidUntil(), (Date)VDate.getDateMax())) {
                    new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mERAModelTP.getValidUntil()), this.mERAModelTP.getClassName());
                }
            }
        }
        return this.mERAModelTP;
    }

    private PlantPlace getPlantPlace() throws BusinessDomainException {
        PlantPlace pp;
        block3: {
            pp = null;
            try {
                Employment empl = this.mEELib.marb().getEmployment(this.cCase.getEffectiveFrom(), this.cCase.getValidFrom());
                if (empl.getPlantPlace() != null) {
                    pp = empl.getPlantPlace();
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block3;
                throw e;
            }
        }
        return pp;
    }

    private FederalState getFederalState() throws BusinessDomainException {
        if (!this.mFederalStateLd) {
            this.mFederalStateLd = true;
            if (this.getPlantPlaceTP() != null && this.getPlantPlaceTP().getFederalState() != null) {
                this.mFederalState = this.getPlantPlaceTP().getFederalState();
            }
            if (this.mFederalState == null && this.getPlantFoundations() != null && this.getPlantFoundations().getFoundations().getFederalState() != null) {
                this.mFederalState = this.getPlantFoundations().getFoundations().getFederalState();
            }
            if (this.mFederalState == null) {
                this.mFederalState = this.getCompanyFoundations().getFoundations().getFederalState();
            }
        }
        return this.mFederalState;
    }

    private PlantPlaceTP getPlantPlaceTP() throws BusinessDomainException {
        block4: {
            if (!this.mPPTPLoaded) {
                this.mPPTPLoaded = true;
                if (this.getPlantPlace() != null) {
                    try {
                        this.mPPTP = this.getPlantPlace().getPlantPlaceTP(this.cCase.getEffectiveFrom(), this.cCase.getValidFrom());
                    }
                    catch (BusinessDomainException e) {
                        if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                        throw e;
                    }
                }
            }
        }
        return this.mPPTP;
    }

    private FederalStateTP getFederalStateTP() throws BusinessDomainException {
        if (!this.mFederalStateTPLd) {
            this.mFederalStateTPLd = true;
            if (this.getFederalState() != null) {
                this.mFederalStateTP = this.getFederalState().getFederalStateTP(this.cCase.getEffectiveFrom(), this.cCase.getValidFrom());
            }
        }
        return this.mFederalStateTP;
    }

    protected FStateRegion getFStateRegion() throws BusinessDomainException {
        if (!this.mFStateRegionLd) {
            this.mFStateRegionLd = true;
            if (this.getPlantPlaceTP() != null && this.getPlantPlaceTP().getFederalState() != null) {
                this.mFStateRegion = FStateRegionPersistencyManager.getFStateRegion((String)this.getPlantPlaceTP().getFederalState().getObjectid());
            }
            if (this.mFStateRegion == null && this.getPlantFoundations() != null) {
                if (this.getPlantFoundations().getFoundations().getRegionForChurchTax() != null) {
                    this.mFStateRegion = FStateRegionPersistencyManager.getFStateRegion((String)this.getPlantFoundations().getFoundations().getRegionForChurchTax().getObjectid());
                } else if (this.getPlantFoundations().getFoundations().getFederalState() != null) {
                    this.mFStateRegion = FStateRegionPersistencyManager.getFStateRegion((String)this.getPlantFoundations().getFoundations().getFederalState().getObjectid());
                }
            }
            if (this.mFStateRegion == null) {
                if (this.getCompanyFoundations().getFoundations().getRegionForChurchTax() != null) {
                    this.mFStateRegion = FStateRegionPersistencyManager.getFStateRegion((String)this.getCompanyFoundations().getFoundations().getRegionForChurchTax().getObjectid());
                } else if (this.getCompanyFoundations().getFoundations().getFederalState() != null) {
                    this.mFStateRegion = FStateRegionPersistencyManager.getFStateRegion((String)this.getCompanyFoundations().getFoundations().getFederalState().getObjectid());
                } else {
                    throw EvaluationExceptionMapper.makeNoFederalStateDomainException();
                }
            }
        }
        return this.mFStateRegion;
    }

    protected FStateRegionContributionsTP getFStateRegionContributionsTP() throws BusinessDomainException {
        block4: {
            if (!this.mRegionContTPLd) {
                this.mRegionContTPLd = true;
                try {
                    this.mRegionContTP = this.getFStateRegion().getFStateRegionContributionsTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
                    if (!DateHelper.equal((Date)this.mRegionContTP.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mRegionContTP.getValidUntil()), this.mRegionContTP.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw EvaluationExceptionMapper.makeMissingFStateRegionContributionsTPDomainException(DateMapper.toString((Date)this.vPosition.getEffectiveFrom()) + DateMapper.toString((Date)this.vPosition.getValidFrom()));
                }
            }
        }
        return this.mRegionContTP;
    }

    private FStateRegionContributionsTP getFStateRegionContributionsTPForKiSt() throws BusinessDomainException {
        block4: {
            if (!this.mRegContTPKiStLd) {
                this.mRegContTPKiStLd = true;
                try {
                    this.mRegionContTPKiSt = this.getFStateRegionKiSt().getFStateRegionContributionsTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
                    if (!DateHelper.equal((Date)this.mRegionContTPKiSt.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mRegionContTPKiSt.getValidUntil()), this.mRegionContTPKiSt.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw EvaluationExceptionMapper.makeMissingFStateRegionContributionsTPDomainException(DateMapper.toString((Date)this.vPosition.getEffectiveFrom()) + DateMapper.toString((Date)this.vPosition.getValidFrom()));
                }
            }
        }
        return this.mRegionContTPKiSt;
    }

    private FStateRegion getFStateRegionKiSt() throws BusinessDomainException {
        if (!this.mRegionKiStLd) {
            this.mRegionKiStLd = true;
            if (this.getPlantFoundations() == null) {
                if (this.getCompanyFoundations().getFoundations().getRegionForChurchTax() == null) {
                    if (this.getCompanyFoundations().getFoundations().getFederalState() == null) {
                        EvaluationExceptionMapper.makeNoFederalStateDomainException();
                    } else {
                        this.mRegionKiSt = FStateRegionPersistencyManager.getFStateRegion((String)this.getCompanyFoundations().getFoundations().getFederalState().getObjectid());
                    }
                } else {
                    this.mRegionKiSt = FStateRegionPersistencyManager.getFStateRegion((String)this.getCompanyFoundations().getFoundations().getRegionForChurchTax().getObjectid());
                }
            } else {
                PlantTaxOffice plantTaxOffice;
                block23: {
                    plantTaxOffice = null;
                    try {
                        plantTaxOffice = this.getPlantFoundations().getPlant().getPlantTaxOffice(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
                    }
                    catch (BusinessDomainException e) {
                        if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block23;
                        throw e;
                    }
                }
                if (plantTaxOffice == null) {
                    if (this.getCompanyFoundations().getFoundations().getRegionForChurchTax() == null) {
                        if (this.getCompanyFoundations().getFoundations().getFederalState() == null) {
                            EvaluationExceptionMapper.makeNoFederalStateDomainException();
                        } else {
                            this.mRegionKiSt = FStateRegionPersistencyManager.getFStateRegion((String)this.getCompanyFoundations().getFoundations().getFederalState().getObjectid());
                        }
                    } else {
                        this.mRegionKiSt = FStateRegionPersistencyManager.getFStateRegion((String)this.getCompanyFoundations().getFoundations().getRegionForChurchTax().getObjectid());
                    }
                } else if (this.getPlantFoundations().getFoundations().getRegionForChurchTax() == null) {
                    if (this.getPlantFoundations().getFoundations().getFederalState() == null) {
                        if (this.getCompanyFoundations().getFoundations().getRegionForChurchTax() == null) {
                            if (this.getCompanyFoundations().getFoundations().getFederalState() == null) {
                                EvaluationExceptionMapper.makeNoFederalStateDomainException();
                            } else {
                                this.mRegionKiSt = FStateRegionPersistencyManager.getFStateRegion((String)this.getCompanyFoundations().getFoundations().getFederalState().getObjectid());
                            }
                        } else {
                            this.mRegionKiSt = FStateRegionPersistencyManager.getFStateRegion((String)this.getCompanyFoundations().getFoundations().getRegionForChurchTax().getObjectid());
                        }
                    } else {
                        this.mRegionKiSt = FStateRegionPersistencyManager.getFStateRegion((String)this.getPlantFoundations().getFoundations().getFederalState().getObjectid());
                    }
                } else {
                    this.mRegionKiSt = FStateRegionPersistencyManager.getFStateRegion((String)this.getPlantFoundations().getFoundations().getRegionForChurchTax().getObjectid());
                }
            }
        }
        return this.mRegionKiSt;
    }

    private HealthFundTP getHealthFund() throws BusinessDomainException {
        block5: {
            if (!this.mHealthFundLoaded) {
                this.mHealthFundLoaded = true;
                try {
                    if (this.getSocialInsurance() != null && this.mEELib.marbKrk() != null) {
                        this.mHealthFund = this.mEELib.marbKrk().getHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
                        if (!DateHelper.equal((Date)this.mHealthFund.getValidUntil(), (Date)VDate.getDateMax())) {
                            new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mHealthFund.getValidUntil()), this.mHealthFund.getClassName());
                        }
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block5;
                    throw e;
                }
            }
        }
        return this.mHealthFund;
    }

    private HealthFundTP getHealthFundKVdR() throws BusinessDomainException {
        block5: {
            if (!this.mHFKVdRLoaded) {
                this.mHFKVdRLoaded = true;
                try {
                    if (this.mEELib.marbKrkKVdR() != null) {
                        Date validFromKVdR = this.mEELib.getValidFromKVdR(this.cCase.getValidFrom());
                        this.mHealthFundKVdR = this.mEELib.marbKrkKVdR().getHealthFundTP(this.vPosition.getEffectiveFrom(), validFromKVdR);
                        if (!DateHelper.equal((Date)this.mHealthFundKVdR.getValidUntil(), (Date)VDate.getDateMax())) {
                            new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mHealthFundKVdR.getValidUntil()), this.mHealthFundKVdR.getClassName());
                        }
                        new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.addMonths((Date)DateHelper.tomorrow((Date)this.mHealthFundKVdR.getValidUntil()), (int)2), this.mHealthFundKVdR.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block5;
                    throw e;
                }
            }
        }
        return this.mHealthFundKVdR;
    }

    private PlantFoundations getPlantFoundations() throws BusinessDomainException {
        block5: {
            if (!this.plantFoundLd) {
                this.plantFoundLd = true;
                try {
                    if (this.mEELib.marbBetriebsstaette() != null) {
                        this.plantFounds = this.mEELib.marbBetriebsstaette().getPlantFoundations(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
                        if (!DateHelper.equal((Date)this.plantFounds.getValidUntil(), (Date)VDate.getDateMax())) {
                            new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.plantFounds.getValidUntil()), this.plantFounds.getClassName());
                        }
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block5;
                    throw e;
                }
            }
        }
        return this.plantFounds;
    }

    private PlantSettings getPlantSettings() throws BusinessDomainException {
        block5: {
            if (!this.plantSettingsLd) {
                this.plantSettingsLd = true;
                try {
                    if (this.mEELib.marbBetriebsstaette() != null) {
                        this.plantSettings = this.mEELib.marbBetriebsstaette().getPlantSettings(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
                        if (!DateHelper.equal((Date)this.plantSettings.getValidUntil(), (Date)VDate.getDateMax())) {
                            new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.plantSettings.getValidUntil()), this.plantSettings.getClassName());
                        }
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block5;
                    throw e;
                }
            }
        }
        return this.plantSettings;
    }

    protected SocialInsuranceTP getSocialInsurance() throws BusinessDomainException {
        block4: {
            if (!this.mSocialInsLd) {
                this.mSocialInsLd = true;
                try {
                    SocialInsurance socialIns = SocialInsurancePersistencyManager.getInstance();
                    this.mSocialInsurance = socialIns.getSocialInsurance(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
                    if (!DateHelper.equal((Date)this.mSocialInsurance.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mSocialInsurance.getValidUntil()), this.mSocialInsurance.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw EvaluationExceptionMapper.makeMissingSocialInsuranceDomainException(DateMapper.toString((Date)this.vPosition.getEffectiveFrom()) + DateMapper.toString((Date)this.vPosition.getValidFrom()));
                }
            }
        }
        return this.mSocialInsurance;
    }

    private SocialInsuranceTP getSocialInsurance(Date validDate) throws BusinessDomainException {
        block3: {
            try {
                SocialInsurance socialIns = SocialInsurancePersistencyManager.getInstance();
                this.mSocialInsurance = socialIns.getSocialInsurance(this.vPosition.getEffectiveFrom(), validDate);
                if (!DateHelper.equal((Date)this.mSocialInsurance.getValidUntil(), (Date)VDate.getDateMax())) {
                    new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mSocialInsurance.getValidUntil()), this.mSocialInsurance.getClassName());
                }
            }
            catch (BusinessDomainException e) {
                if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block3;
                throw EvaluationExceptionMapper.makeMissingSocialInsuranceDomainException(DateMapper.toString((Date)this.vPosition.getEffectiveFrom()) + DateMapper.toString((Date)validDate));
            }
        }
        return this.mSocialInsurance;
    }

    @Override
    public IncreaseInPayRatesTP getTariferhoehungsDatensatz() throws BusinessDomainException {
        IncreaseInPayRatesTP result;
        block4: {
            ERAModelTP emtp = this.getERAModellTP();
            IncreaseInPayRates iipr = null;
            result = null;
            if (emtp != null && (iipr = IncreaseInPayRatesPersistencyManager.getIncreaseInPayRatesByKey((String)emtp.getPayScale().getObjectid(), (String)emtp.getPayScaleGroup3().getObjectid())) == null) {
                iipr = IncreaseInPayRatesPersistencyManager.getIncreaseInPayRatesByKey((String)emtp.getPayScale().getObjectid(), (String)"");
            }
            if (iipr != null) {
                try {
                    result = iipr.getIncreaseInPayRatesTP(this.cCase.getEffectiveFrom(), this.cCase.getValidFrom());
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
        }
        return result;
    }

    @Override
    public BigDecimal heranfuehrungsbetrag() throws BusinessDomainException {
        return this.getERAModellTP().getAmountForUnderCut();
    }

    @Override
    public boolean isInsGPflBetrieb() throws BusinessDomainException {
        if (this.getPlantSettings() != null) {
            return this.getPlantSettings().getSettings().getInsolvencyAssessable();
        }
        return this.getCompanySettings().getSettings().getInsolvencyAssessable();
    }

    @Override
    public boolean isZVKUmlage() throws BusinessDomainException {
        boolean result = false;
        Recipient zvk = this.mEELib.zvKasse();
        AssignmentPCompanyZVKTP assign = this.getAssesmentPCompanyZVK(zvk);
        if (assign != null && assign.getCalculateAssessmZvk()) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isZvkZusatzbeitrag() throws BusinessDomainException {
        boolean result = false;
        Recipient zvk = this.mEELib.zvKasse();
        AssignmentPCompanyZVKTP assign = this.getAssesmentPCompanyZVK(zvk);
        if (assign != null && assign.getCalculateAddContZvk()) {
            result = true;
        }
        return result;
    }

    @Override
    public BigDecimal kammerBeitragsObergrenze() throws BusinessDomainException {
        BigDecimal oberGrenze = BigDecimal.ZERO;
        if (this.getFStateRegionContributionsTPForKiSt() != null) {
            oberGrenze = this.getFStateRegionContributionsTPForKiSt().getDuesMaxLimit();
        }
        return oberGrenze;
    }

    @Override
    public BigDecimal kammerBeitragsSatz() throws BusinessDomainException {
        BigDecimal bsKammer = BigDecimal.ZERO;
        if (this.getFStateRegionContributionsTPForKiSt() != null) {
            bsKammer = this.getFStateRegionContributionsTPForKiSt().getContributionRate();
        }
        return bsKammer;
    }

    @Override
    public BigDecimal kammerBeitragsUntergrenze() throws BusinessDomainException {
        BigDecimal unterGrenze = BigDecimal.ZERO;
        if (this.getFStateRegionContributionsTPForKiSt() != null) {
            unterGrenze = this.getFStateRegionContributionsTPForKiSt().getDuesMinLimit();
        }
        return unterGrenze;
    }

    @Override
    public BigDecimal kammerBruttoObergrenze() throws BusinessDomainException {
        BigDecimal oberGrenze = BigDecimal.ZERO;
        if (this.getFStateRegionContributionsTPForKiSt() != null) {
            oberGrenze = this.getFStateRegionContributionsTPForKiSt().getBruttoMaxLimit();
        }
        return oberGrenze;
    }

    @Override
    public BigDecimal kammerBruttoUntergrenze() throws BusinessDomainException {
        BigDecimal unterGrenze = BigDecimal.ZERO;
        if (this.getFStateRegionContributionsTPForKiSt() != null) {
            unterGrenze = this.getFStateRegionContributionsTPForKiSt().getBruttoMinLimit();
        }
        return unterGrenze;
    }

    @Override
    public BigDecimal kiStBeschaeftigungsort() throws BusinessDomainException {
        BigDecimal vHSatz = this.mEELib.isMarbKiStWohnort() ? FStateRegionPersistencyManager.getFStateRegion((String)this.mEELib.bundeslandKiStWohnort().getObjectid()).getFStateRegionContributionsTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom()).getChurchTax() : (this.getFStateRegionContributionsTPForKiSt() == null ? BigDecimal.ZERO : (this.isBadWimpfen() ? BigDecimal.valueOf(900L, 2) : this.getFStateRegionContributionsTPForKiSt().getChurchTax()));
        return vHSatz;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isBadWimpfen() throws BusinessDomainException {
        PlantTaxOffice plantTaxOffice;
        boolean isBadWimpfen;
        block10: {
            isBadWimpfen = false;
            if (!DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2016, 0, 1).getDate())) return isBadWimpfen;
            if (this.getFStateRegionKiSt().getFStateRegion() != 8) return isBadWimpfen;
            if (this.mEELib.marbKiStAbz() != 2) return isBadWimpfen;
            if (this.getPlantFoundations() == null) {
                try {
                    GeneralCommunity generalCommunity = this.mEELib.marbFirma().getCompanyCommunity(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom()).getGeneralCommunity();
                    if (generalCommunity == null) return isBadWimpfen;
                    Community community = generalCommunity.getCommunity();
                    if (community == null) return isBadWimpfen;
                    String ags = community.getGeneralCommunityKey();
                    if (!StringMapper.equal((String)ags, (String)"08125007")) return isBadWimpfen;
                    return true;
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) return isBadWimpfen;
                    throw e;
                }
            }
            plantTaxOffice = null;
            try {
                plantTaxOffice = this.getPlantFoundations().getPlant().getPlantTaxOffice(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block10;
                throw e;
            }
        }
        if (plantTaxOffice == null) {
            try {
                GeneralCommunity generalCommunity = this.mEELib.marbFirma().getCompanyCommunity(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom()).getGeneralCommunity();
                if (generalCommunity == null) return isBadWimpfen;
                Community community = generalCommunity.getCommunity();
                if (community == null) return isBadWimpfen;
                String ags = community.getGeneralCommunityKey();
                if (!StringMapper.equal((String)ags, (String)"08125007")) return isBadWimpfen;
                return true;
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) return isBadWimpfen;
                throw e;
            }
        }
        try {
            GeneralCommunity generalCommunity = this.mEELib.marbBetriebsstaette().getPlantCommunity(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom()).getGeneralCommunity();
            if (generalCommunity == null) return isBadWimpfen;
            Community community = generalCommunity.getCommunity();
            if (community == null) return isBadWimpfen;
            String ags = community.getGeneralCommunityKey();
            if (!StringMapper.equal((String)ags, (String)"08125007")) return isBadWimpfen;
            return true;
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) return isBadWimpfen;
            throw e;
        }
    }

    @Override
    public int kiStBundeslandSchluesselBeschaeftigungsort() throws BusinessDomainException {
        int bulaSchluessel = this.mEELib.isMarbKiStWohnort() ? this.mEELib.bundeslandKiStWohnort().getFederalState() : (this.getFederalState() == null ? 0 : this.getFederalState().getFederalState());
        return bulaSchluessel;
    }

    @Override
    public BigDecimal krkBsNachBGSKV(int marbBgrKv) throws BusinessDomainException {
        BigDecimal krkBS = BigDecimal.ZERO;
        switch (marbBgrKv) {
            case 1: {
                krkBS = this.krkBsAllgemein();
                break;
            }
            case 2: {
                if (DateHelper.before((Date)this.cCase.getValidFrom(), (Date)new VDate(2009, 0, 1).getDate())) {
                    krkBS = this.krkBsErhoeht();
                    break;
                }
                throw EvaluationExceptionMapper.makeIncreaseDuesGroupHIAfter2008NotAllowedDomainException();
            }
            case 3: {
                krkBS = this.krkBsErmaessigt();
                break;
            }
        }
        return krkBS;
    }

    @Override
    public BigDecimal krkBsAllgemein() throws BusinessDomainException {
        if (this.getHealthFund() == null) {
            throw EvaluationExceptionMapper.makeNoHealthFundFound(this.cCase.getValidFrom());
        }
        BigDecimal lBeitragssatz = this.getHealthFund().getPercentageGeneral();
        if (lBeitragssatz == null) {
            throw EvaluationExceptionMapper.makeNoContributionPercentageGeneralForKV(this.getHealthFund().getShortDescription(), this.cCase.getValidFrom());
        }
        if (DateHelper.between((Date)this.cCase.getValidFrom(), (Date)new VDate(2009, 0, 1).getDate(), (Date)new VDate(2014, 11, 31).getDate())) {
            lBeitragssatz = lBeitragssatz.subtract(this.kvZusatzVHSatz());
        }
        return lBeitragssatz;
    }

    @Override
    public BigDecimal krkBsErhoeht() throws BusinessDomainException {
        if (this.getHealthFund() == null) {
            throw EvaluationExceptionMapper.makeNoHealthFundFound(this.cCase.getValidFrom());
        }
        BigDecimal lBeitragssatz = this.getHealthFund().getPercentageIncreased();
        if (lBeitragssatz == null) {
            throw EvaluationExceptionMapper.makeNoContributionPercentageIncreasedForKV(this.getHealthFund().getShortDescription(), this.cCase.getValidFrom());
        }
        return lBeitragssatz;
    }

    @Override
    public BigDecimal krkBsErmaessigt() throws BusinessDomainException {
        if (this.getHealthFund() == null) {
            throw EvaluationExceptionMapper.makeNoHealthFundFound(this.cCase.getValidFrom());
        }
        BigDecimal lBeitragssatz = this.getHealthFund().getPercentageReduced();
        if (lBeitragssatz == null) {
            throw EvaluationExceptionMapper.makeNoContributionPercentageReducedForKV(this.getHealthFund().getShortDescription(), this.cCase.getValidFrom());
        }
        if (DateHelper.between((Date)this.cCase.getValidFrom(), (Date)new VDate(2009, 0, 1).getDate(), (Date)new VDate(2014, 11, 31).getDate())) {
            lBeitragssatz = lBeitragssatz.subtract(this.kvZusatzVHSatz());
        }
        return lBeitragssatz;
    }

    @Override
    public BigDecimal krkBsKvdr() throws BusinessDomainException {
        BigDecimal beitragssatz = BigDecimal.ZERO;
        Date validFromKVdR = this.mEELib.getValidFromKVdR(this.cCase.getValidFrom());
        if (this.getHealthFundKVdR() == null) {
            if (this.getHealthFund() == null) {
                throw EvaluationExceptionMapper.makeNoHealthFundFound(this.cCase.getValidFrom());
            }
            beitragssatz = this.getHealthFund().getContributionForPensionersPercentage();
            if (beitragssatz == null) {
                throw EvaluationExceptionMapper.makeNoContributionPercentageForKVdR(this.getHealthFund().getShortDescription(), validFromKVdR);
            }
        } else {
            beitragssatz = this.getHealthFundKVdR().getContributionForPensionersPercentage();
            if (beitragssatz == null) {
                throw EvaluationExceptionMapper.makeNoContributionPercentageForKVdR(this.getHealthFundKVdR().getShortDescription(), validFromKVdR);
            }
        }
        if (DateHelper.between((Date)validFromKVdR, (Date)new VDate(2009, 0, 1).getDate(), (Date)new VDate(2014, 11, 31).getDate())) {
            beitragssatz = beitragssatz.subtract(this.kvZusatzVHSatz());
        }
        if (DateHelper.between((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 0, 1).getDate(), (Date)new VDate(2015, 1, 28).getDate())) {
            beitragssatz = beitragssatz.subtract(BigDecimal.valueOf(9L, 1));
        }
        return beitragssatz;
    }

    @Override
    public BigDecimal krkGesBeitragBklAllgemein() throws BusinessDomainException {
        BigDecimal gesBeitrag = BigDecimal.ZERO;
        if (this.getHealthFund() != null) {
            gesBeitrag = this.getHealthFund().getDuesVHIGeneral();
        }
        return gesBeitrag;
    }

    @Override
    public BigDecimal krkGesBeitragBklAllgemeinAGZ() throws BusinessDomainException {
        BigDecimal gesBeitrag = BigDecimal.ZERO;
        if (this.getHealthFund() != null) {
            gesBeitrag = this.getHealthFund().getDuesVHIGeneralGrant();
        }
        return gesBeitrag;
    }

    @Override
    public BigDecimal krkGesBeitragBklAllgemeinAGZPV() throws BusinessDomainException {
        BigDecimal gesBeitrag = BigDecimal.ZERO;
        if (this.getHealthFund() != null) {
            gesBeitrag = this.getHealthFund().getVNIableForGrantGen();
        }
        return gesBeitrag;
    }

    @Override
    public BigDecimal krkGesBeitragBklAlllgemeinPV() throws BusinessDomainException {
        BigDecimal gesBeitrag = BigDecimal.ZERO;
        if (this.getHealthFund() != null) {
            gesBeitrag = this.getHealthFund().getDuesVNIGeneral();
        }
        return gesBeitrag;
    }

    @Override
    public BigDecimal krkGesBeitragBklErhoeht() throws BusinessDomainException {
        BigDecimal gesBeitrag = BigDecimal.ZERO;
        if (this.getHealthFund() != null) {
            gesBeitrag = this.getHealthFund().getDuesVHIIncreased();
        }
        return gesBeitrag;
    }

    @Override
    public BigDecimal krkGesBeitragBklErhoehtAGZ() throws BusinessDomainException {
        BigDecimal gesBeitrag = BigDecimal.ZERO;
        if (this.getHealthFund() != null) {
            gesBeitrag = this.getHealthFund().getDuesVHIIncreasedGrant();
        }
        return gesBeitrag;
    }

    @Override
    public BigDecimal krkGesBeitragBklErmaessigt() throws BusinessDomainException {
        BigDecimal gesBeitrag = BigDecimal.ZERO;
        if (this.getHealthFund() != null) {
            gesBeitrag = this.getHealthFund().getDuesVHIReduced();
        }
        return gesBeitrag;
    }

    @Override
    public BigDecimal krkGesBeitragBklErmaessigtAGZ() throws BusinessDomainException {
        BigDecimal gesBeitrag = BigDecimal.ZERO;
        if (this.getHealthFund() != null) {
            gesBeitrag = this.getHealthFund().getDuesVHIReducedGrant();
        }
        return gesBeitrag;
    }

    @Override
    public int krkTyp() throws BusinessDomainException {
        int typ = 0;
        if (this.getHealthFund() != null) {
            typ = this.getHealthFund().getTypeOfHealthFundEnum().value();
        }
        return typ;
    }

    @Override
    public int krv() throws BusinessDomainException {
        if (!this.krvLoaded) {
            this.krvLoaded = true;
            block0 : switch (this.mEELib.marbBgrRv()) {
                case 0: {
                    switch (this.mEELib.marbVersorgungsart().value()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            switch (this.marbRechtskreis()) {
                                case 'W': 
                                case 'w': {
                                    this.mKrv = 0;
                                    break block0;
                                }
                            }
                            this.mKrv = 1;
                            break block0;
                        }
                    }
                    this.mKrv = 2;
                    break;
                }
                case 1: {
                    switch (this.marbRechtskreis()) {
                        case 'W': 
                        case 'w': {
                            this.mKrv = 0;
                            break block0;
                        }
                    }
                    this.mKrv = 1;
                    break;
                }
                default: {
                    this.mKrv = 2;
                }
            }
        }
        return this.mKrv;
    }

    @Override
    public BigDecimal kvZusatzVHSatz() throws BusinessDomainException {
        BigDecimal mVhSatzZusatzKV = BigDecimal.ZERO;
        if (this.getSocialInsurance() != null && BigDecimalMapper.isZeroOrNull((BigDecimal)(mVhSatzZusatzKV = this.getSocialInsurance().getGlobal().getSurchargeHI()))) {
            mVhSatzZusatzKV = BigDecimal.ZERO;
        }
        return mVhSatzZusatzKV;
    }

    @Override
    public BigDecimal kvZusatzDurchVHSatz() throws BusinessDomainException {
        BigDecimal vhSatzDurchZusatzKV = BigDecimal.ZERO;
        if (this.getSocialInsurance() != null && BigDecimalMapper.isZeroOrNull((BigDecimal)(vhSatzDurchZusatzKV = this.getSocialInsurance().getGlobal().getAdditionalDuesHI()))) {
            vhSatzDurchZusatzKV = BigDecimal.ZERO;
        }
        return vhSatzDurchZusatzKV;
    }

    @Override
    public BigDecimal kvAnaZusatzDurchVHSatz() throws BusinessDomainException {
        BigDecimal vhSatzDurchZusatzKV = BigDecimal.ZERO;
        if (this.getSocialInsurance() != null && BigDecimalMapper.isZeroOrNull((BigDecimal)(vhSatzDurchZusatzKV = this.getSocialInsurance().getGlobal().getAdditionalDuesHIEE()))) {
            vhSatzDurchZusatzKV = BigDecimal.ZERO;
        }
        return vhSatzDurchZusatzKV;
    }

    @Override
    public BigDecimal kvAgaZusatzDurchVHSatz() throws BusinessDomainException {
        BigDecimal vhSatzDurchZusatzKV = BigDecimal.ZERO;
        if (this.getSocialInsurance() != null && BigDecimalMapper.isZeroOrNull((BigDecimal)(vhSatzDurchZusatzKV = this.getSocialInsurance().getGlobal().getAdditionalDuesHIER()))) {
            vhSatzDurchZusatzKV = BigDecimal.ZERO;
        }
        return vhSatzDurchZusatzKV;
    }

    @Override
    public BigDecimal getKVBSZusatzversicherung(boolean nehmeImmerDurchnittlichenSatz) throws BusinessDomainException {
        BigDecimal kvZusatzVHSatz = BigDecimal.ZERO;
        kvZusatzVHSatz = DateHelper.before((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 0, 1).getDate()) ? this.kvZusatzVHSatz() : (this.mEELib.marbPgs() == 111 || this.mEELib.marbPgs() == 122 && this.mEELib.isPGS122Geringverdiener() || this.mEELib.marbPgs() == 123 || nehmeImmerDurchnittlichenSatz || this.cCase.isDurchschnittlicherZusatzbeitrag() ? this.kvZusatzDurchVHSatz() : this.mEELib.marbKrkAnaBsZusatzbeitrag());
        return kvZusatzVHSatz;
    }

    @Override
    public BigDecimal getKVANABSZusatzversicherung(boolean nehmeImmerDurchnittlichenSatz) throws BusinessDomainException {
        BigDecimal kvZusatzVHSatz = BigDecimal.ZERO;
        kvZusatzVHSatz = DateHelper.before((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 0, 1).getDate()) ? this.kvZusatzVHSatz() : (this.mEELib.marbPgs() == 111 || this.mEELib.marbPgs() == 122 && this.mEELib.isPGS122Geringverdiener() || this.mEELib.marbPgs() == 123 || nehmeImmerDurchnittlichenSatz || this.cCase.isDurchschnittlicherZusatzbeitrag() ? this.kvAnaZusatzDurchVHSatz() : this.mEELib.marbKrkAnaBsZusatzbeitrag());
        return kvZusatzVHSatz;
    }

    @Override
    public BigDecimal getKVAGABSZusatzversicherung(boolean nehmeImmerDurchnittlichenSatz) throws BusinessDomainException {
        BigDecimal kvZusatzVHSatz = BigDecimal.ZERO;
        kvZusatzVHSatz = DateHelper.before((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 0, 1).getDate()) ? this.kvZusatzVHSatz() : (this.mEELib.marbPgs() == 111 || this.mEELib.marbPgs() == 122 && this.mEELib.isPGS122Geringverdiener() || this.mEELib.marbPgs() == 123 || nehmeImmerDurchnittlichenSatz || this.cCase.isDurchschnittlicherZusatzbeitrag() ? this.kvAgaZusatzDurchVHSatz() : this.mEELib.marbKrkAgaBsZusatzbeitrag());
        return kvZusatzVHSatz;
    }

    @Override
    public BigDecimal getKVBSZusatzversicherungKVdR() throws BusinessDomainException {
        Date validFromKVdR;
        BigDecimal kvZusatzVHSatz = BigDecimal.ZERO;
        kvZusatzVHSatz = DateHelper.between((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 0, 1).getDate(), (Date)new VDate(2015, 1, 28).getDate()) ? BigDecimal.valueOf(9L, 1) : (DateHelper.before((Date)(validFromKVdR = this.mEELib.getValidFromKVdR(this.cCase.getValidFrom())), (Date)new VDate(2015, 0, 1).getDate()) ? this.kvZusatzVHSatz() : this.mEELib.marbKrkBsZusatzbeitragKVdR());
        return kvZusatzVHSatz;
    }

    @Override
    public boolean lohnsteuerJahresausgleichFirma() throws BusinessDomainException {
        return this.getCompanySettings().getSettings().getAnnualIncomeTaxReturn();
    }

    @Override
    public boolean marbAtsModellBbgRvGekuerzt() throws BusinessDomainException {
        if (this.mEELib.isMarbAtzVertraglich()) {
            if (this.marbAtzModell() == null) {
                throw EvaluationExceptionMapper.makeNoAgePartTimeModelForCalculationExistDomainException();
            }
            return this.mAPTModelTP.isLimitationOfDues();
        }
        return true;
    }

    private AgePartTimeModelTP marbAtzModell() throws BusinessDomainException {
        if (!this.mAPTModelTPLd) {
            block11: {
                this.mAPTModelTPLd = true;
                if (this.mEELib.marbVersicherungsdaten() != null) {
                    this.mAgePartTimeModel = this.mEELib.marbVersicherungsdaten().getAgePartTimeModel();
                }
                if (this.mAgePartTimeModel == null) {
                    if (this.mEELib.marbBetriebsstaette() == null) {
                        this.mAgePartTimeModel = this.mEELib.marbFirma().getCompanySettings(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom()).getSettings().getAgePartTimeModel();
                    } else {
                        try {
                            this.mAgePartTimeModel = this.mEELib.marbBetriebsstaette().getPlantSettings(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom()).getSettings().getAgePartTimeModel();
                            if (this.mAgePartTimeModel == null) {
                                this.mAgePartTimeModel = this.mEELib.marbFirma().getCompanySettings(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom()).getSettings().getAgePartTimeModel();
                            }
                        }
                        catch (BusinessDomainException e) {
                            if (!FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block11;
                            this.mAgePartTimeModel = this.mEELib.marbFirma().getCompanySettings(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom()).getSettings().getAgePartTimeModel();
                        }
                    }
                }
            }
            if (this.mAgePartTimeModel != null) {
                this.mAPTModelTP = this.mAgePartTimeModel.getAgePartTimeModelTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
                if (!DateHelper.equal((Date)this.mAPTModelTP.getValidUntil(), (Date)VDate.getDateMax())) {
                    new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mAPTModelTP.getValidUntil()), this.mAPTModelTP.getClassName());
                }
            } else {
                throw EvaluationExceptionMapper.makeNoAgePartTimeModelForCalculationExistDomainException();
            }
        }
        return this.mAPTModelTP;
    }

    @Override
    public BigDecimal marbAtzModellBbgRv() throws BusinessDomainException {
        return this.marbAtzModell().getLimitedDuesInPercent();
    }

    @Override
    public boolean marbAtzModellKennzFortlUnterschiedsbetrag() throws BusinessDomainException {
        return this.marbAtzModell().getERPIIncreaseInAbsentTime();
    }

    @Override
    public boolean marbAtzModellKennzMindesnettoIGMetall() throws BusinessDomainException {
        return this.marbAtzModell().getPapIGMetall();
    }

    @Override
    public ContractEnum marbAtzModellVertragsart() throws BusinessDomainException {
        return this.marbAtzModell().getTypeOfContract();
    }

    @Override
    public BigDecimal marbAtzModellVhSatzMindestNetto() throws BusinessDomainException {
        return this.marbAtzModell().getGuaranteedMinimumNetWage();
    }

    @Override
    public BigDecimal marbAtzModellVhSatzNettoAufstockung() throws BusinessDomainException {
        return this.marbAtzModell().getMinimumIncrease();
    }

    @Override
    public BigDecimal marbAtzModellVhSatzRvAufstockung() throws BusinessDomainException {
        return this.marbAtzModell().getIncreasePensionInsurance();
    }

    @Override
    public boolean marbATZModellNurATZBrutto() throws BusinessDomainException {
        return this.marbAtzModell().isOnlyAgePartTimeGrossWage();
    }

    @Override
    public BigDecimal marbEinnahmeUntergrenzeKVdR() throws BusinessDomainException {
        BigDecimal unterGrenze;
        switch (this.marbRechtskreis()) {
            case 'W': {
                unterGrenze = this.getSocialInsurance().getLawAreaWest().getMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome();
                break;
            }
            default: {
                unterGrenze = this.getSocialInsurance().getLawAreaEast().getMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome();
            }
        }
        return unterGrenze;
    }

    @Override
    public char marbRechtskreis() throws BusinessDomainException {
        char rechtskreis = this.getFederalStateTP() == null ? (char)'W' : this.getFederalStateTP().getLawArea().charAt(0);
        return rechtskreis;
    }

    @Override
    public BigDecimal maximalerZeitgrad() throws BusinessDomainException {
        if (this.getPlantSettings() != null) {
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.getPlantSettings().getSettings().getMaxlLaborUtilizationRate())) {
                return this.getPlantSettings().getSettings().getMaxlLaborUtilizationRate();
            }
            return this.getCompanySettings().getSettings().getMaxlLaborUtilizationRate();
        }
        return this.getCompanySettings().getSettings().getMaxlLaborUtilizationRate();
    }

    @Override
    public BigDecimal mindestbetragKiStBeschaeftigungsort(BigDecimal steuerTage) throws BusinessDomainException {
        BigDecimal mindestbetrag = this.mEELib.isMarbKiStWohnort() ? (BigDecimalMapper.compareTo((BigDecimal)steuerTage, (BigDecimal)BD30) == 0 ? FStateRegionPersistencyManager.getFStateRegion((String)this.mEELib.bundeslandKiStWohnort().getObjectid()).getFStateRegionContributionsTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom()).getMinAmountMM() : FStateRegionPersistencyManager.getFStateRegion((String)this.mEELib.bundeslandKiStWohnort().getObjectid()).getFStateRegionContributionsTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom()).getMinAmountDD().multiply(steuerTage)) : (BigDecimalMapper.compareTo((BigDecimal)steuerTage, (BigDecimal)BD30) == 0 ? (this.getFStateRegionContributionsTPForKiSt() == null ? BigDecimal.ZERO : this.getFStateRegionContributionsTPForKiSt().getMinAmountMM()) : this.getFStateRegionContributionsTPForKiSt().getMinAmountDD().multiply(steuerTage));
        return mindestbetrag;
    }

    @Override
    public BigDecimal minimalerZeitgrad() throws BusinessDomainException {
        if (this.getPlantSettings() != null) {
            if (this.getPlantSettings().getSettings().getMinLaborUtilizationRate().compareTo(BigDecimal.ZERO) != 0) {
                return this.getPlantSettings().getSettings().getMinLaborUtilizationRate();
            }
            return this.getCompanySettings().getSettings().getMinLaborUtilizationRate();
        }
        return this.getCompanySettings().getSettings().getMinLaborUtilizationRate();
    }

    @Override
    public boolean nachweisverfahren(ConsolidationIntoALumpSumEnum lEnum) throws BusinessDomainException {
        boolean nachweisverfahren;
        block4: {
            int i;
            block3: {
                nachweisverfahren = false;
                if (this.getPlantSettings() != null) break block3;
                for (int i2 = 0; i2 < this.getCompanySettings().getCtConsolidations().length; ++i2) {
                    if (this.getCompanySettings().getCtConsolidations()[i2].getLumpSumIncomeTax().getTypeOfConsolidation() != lEnum) continue;
                    nachweisverfahren = this.getCompanySettings().getCtConsolidations()[i2].getModeOfProcedureEnum().value() == 0;
                }
                break block4;
            }
            boolean gefunden = false;
            for (i = 0; i < this.getPlantSettings().getCtConsolidations().length; ++i) {
                if (this.getPlantSettings().getCtConsolidations()[i].getLumpSumIncomeTax().getTypeOfConsolidation() != lEnum) continue;
                nachweisverfahren = this.getPlantSettings().getCtConsolidations()[i].getModeOfProcedureEnum() == ModeOfProcedureEnum.MOPE_Nachweisverfahren;
                gefunden = true;
            }
            if (gefunden) break block4;
            for (i = 0; i < this.getCompanySettings().getCtConsolidations().length; ++i) {
                if (this.getCompanySettings().getCtConsolidations()[i].getLumpSumIncomeTax().getTypeOfConsolidation() != lEnum) continue;
                nachweisverfahren = this.getCompanySettings().getCtConsolidations()[i].getModeOfProcedureEnum().value() == 0;
            }
        }
        return nachweisverfahren;
    }

    @Override
    public BigDecimal pauschalierungsGrenze(ConsolidationIntoALumpSumEnum cialsenum) throws BusinessDomainException {
        try {
            LumpSumIncomeTaxTP lumpSumIncomeTaxTP = LumpSumIncomeTax.getLumpSumIncomeTax((ConsolidationIntoALumpSumEnum)cialsenum).getLumpSumIncomeTaxTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
            if (!DateHelper.equal((Date)lumpSumIncomeTaxTP.getValidUntil(), (Date)VDate.getDateMax())) {
                new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)lumpSumIncomeTaxTP.getValidUntil()), lumpSumIncomeTaxTP.getClassName());
            }
            return lumpSumIncomeTaxTP.getAmount();
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                throw EvaluationExceptionMapper.makeMissingLumpSumIncomeTaxTPDomainException(DateMapper.toString((Date)this.vPosition.getEffectiveFrom()) + DateMapper.toString((Date)this.vPosition.getValidFrom()));
            }
            throw e;
        }
    }

    @Override
    public BigDecimal pauschKiStLandUndForstBeschaeftigungsort() throws BusinessDomainException {
        BigDecimal pauschVHSatz = BigDecimal.ZERO;
        if (this.getFStateRegionContributionsTPForKiSt() != null) {
            pauschVHSatz = this.getFStateRegionContributionsTPForKiSt().getLumpSumCTForest();
        }
        return pauschVHSatz;
    }

    @Override
    public BigDecimal pauschKiStNormalBeschaeftigungsort() throws BusinessDomainException {
        BigDecimal pauschVHSatz = BigDecimal.ZERO;
        if (this.getFStateRegionContributionsTPForKiSt() != null) {
            pauschVHSatz = this.getFStateRegionContributionsTPForKiSt().getLumpSumChurchTax();
        }
        return pauschVHSatz;
    }

    @Override
    public BigDecimal pauschLStSatz(ConsolidationIntoALumpSumEnum cialsenum) throws BusinessDomainException {
        try {
            LumpSumIncomeTaxTP lumpSumIncomeTaxTP = LumpSumIncomeTax.getLumpSumIncomeTax((ConsolidationIntoALumpSumEnum)cialsenum).getLumpSumIncomeTaxTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
            if (!DateHelper.equal((Date)lumpSumIncomeTaxTP.getValidUntil(), (Date)VDate.getDateMax())) {
                new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)lumpSumIncomeTaxTP.getValidUntil()), lumpSumIncomeTaxTP.getClassName());
            }
            return lumpSumIncomeTaxTP.getPercentage();
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                throw EvaluationExceptionMapper.makeMissingLumpSumIncomeTaxTPDomainException(DateMapper.toString((Date)this.vPosition.getEffectiveFrom()) + DateMapper.toString((Date)this.vPosition.getValidFrom()));
            }
            throw e;
        }
    }

    @Override
    public BigDecimal pfandfreierBetragDritteUnterhaltspflichtigePerson() throws BusinessDomainException {
        BigDecimal pfandfrei = DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2022, 6, 1).getDate()) ? BigDecimal.valueOf(27890L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2021, 6, 1).getDate()) ? BigDecimal.valueOf(26265L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2019, 6, 1).getDate()) ? BigDecimal.valueOf(24712L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2017, 6, 1).getDate()) ? BigDecimal.valueOf(23773L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 6, 1).getDate()) ? BigDecimal.valueOf(22517L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2013, 6, 1).getDate()) ? BigDecimal.valueOf(21912L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2011, 6, 1).getDate()) ? BigDecimal.valueOf(21573L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2005, 6, 1).getDate()) ? BigDecimal.valueOf(20656L, 2) : BigDecimal.valueOf(195L))))))));
        return pfandfrei;
    }

    @Override
    public BigDecimal pfandfreierBetragErsteUnterhaltspflichtigePerson() throws BusinessDomainException {
        BigDecimal pfandfrei = DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2022, 6, 1).getDate()) ? BigDecimal.valueOf(50062L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2021, 6, 1).getDate()) ? BigDecimal.valueOf(47144L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2019, 6, 1).getDate()) ? BigDecimal.valueOf(44357L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2017, 6, 1).getDate()) ? BigDecimal.valueOf(42671L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 6, 1).getDate()) ? BigDecimal.valueOf(40416L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2013, 6, 1).getDate()) ? BigDecimal.valueOf(39330L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2011, 6, 1).getDate()) ? BigDecimal.valueOf(38722L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2005, 6, 1).getDate()) ? BigDecimal.valueOf(37076L, 2) : BigDecimal.valueOf(350L))))))));
        return pfandfrei;
    }

    @Override
    public BigDecimal pfandfreierBetragFuenfteUnterhaltspflichtigePerson() throws BusinessDomainException {
        BigDecimal pfandfrei = DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2022, 6, 1).getDate()) ? BigDecimal.valueOf(27890L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2021, 6, 1).getDate()) ? BigDecimal.valueOf(26265L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2019, 6, 1).getDate()) ? BigDecimal.valueOf(24712L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2017, 6, 1).getDate()) ? BigDecimal.valueOf(23773L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 6, 1).getDate()) ? BigDecimal.valueOf(22517L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2013, 6, 1).getDate()) ? BigDecimal.valueOf(21912L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2011, 6, 1).getDate()) ? BigDecimal.valueOf(21573L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2005, 6, 1).getDate()) ? BigDecimal.valueOf(20656L, 2) : BigDecimal.valueOf(195L))))))));
        return pfandfrei;
    }

    @Override
    public BigDecimal pfandfreierBetragSchuldner() throws BusinessDomainException {
        BigDecimal pfandfrei;
        if (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2022, 6, 1).getDate())) {
            pfandfrei = BigDecimal.valueOf(133016L, 2);
        } else if (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2021, 6, 1).getDate())) {
            pfandfrei = BigDecimal.valueOf(125264L, 2);
        } else if (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2019, 6, 1).getDate())) {
            pfandfrei = BigDecimal.valueOf(117859L, 2);
        } else if (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2017, 6, 1).getDate())) {
            pfandfrei = BigDecimal.valueOf(113380L, 2);
        } else if (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 6, 1).getDate())) {
            pfandfrei = BigDecimal.valueOf(107388L, 2);
        } else if (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2013, 6, 1).getDate())) {
            pfandfrei = BigDecimal.valueOf(104504L, 2);
        } else if (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2011, 6, 1).getDate())) {
            pfandfrei = BigDecimal.valueOf(102889L, 2);
        } else if (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2005, 6, 1).getDate())) {
            new CalculationBasic(this.vPosition.getEmployee(), this.vPosition.getEffectiveFrom(), new VDate(2011, 6, 1).getDate(), "com.varial.personnel.domain.evaluation.formula.ErmittlungPfaendungsbetragFormula");
            pfandfrei = BigDecimal.valueOf(98515L, 2);
        } else {
            new CalculationBasic(this.vPosition.getEmployee(), this.vPosition.getEffectiveFrom(), new VDate(2005, 6, 1).getDate(), "com.varial.personnel.domain.evaluation.formula.ErmittlungPfaendungsbetragFormula");
            pfandfrei = BigDecimal.valueOf(930L);
        }
        return pfandfrei;
    }

    @Override
    public BigDecimal pfandfreierBetragVierteUnterhaltspflichtigePerson() throws BusinessDomainException {
        BigDecimal pfandfrei = DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2022, 6, 1).getDate()) ? BigDecimal.valueOf(27890L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2021, 6, 1).getDate()) ? BigDecimal.valueOf(26265L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2019, 6, 1).getDate()) ? BigDecimal.valueOf(24712L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2017, 6, 1).getDate()) ? BigDecimal.valueOf(23773L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 6, 1).getDate()) ? BigDecimal.valueOf(22517L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2013, 6, 1).getDate()) ? BigDecimal.valueOf(21912L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2011, 6, 1).getDate()) ? BigDecimal.valueOf(21573L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2005, 6, 1).getDate()) ? BigDecimal.valueOf(20656L, 2) : BigDecimal.valueOf(195L))))))));
        return pfandfrei;
    }

    @Override
    public BigDecimal pfandfreierBetragZweiteUnterhaltspflichtigePerson() throws BusinessDomainException {
        BigDecimal pfandfrei = DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2022, 6, 1).getDate()) ? BigDecimal.valueOf(27890L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2021, 6, 1).getDate()) ? BigDecimal.valueOf(26265L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2019, 6, 1).getDate()) ? BigDecimal.valueOf(24712L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2017, 6, 1).getDate()) ? BigDecimal.valueOf(23773L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 6, 1).getDate()) ? BigDecimal.valueOf(22517L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2013, 6, 1).getDate()) ? BigDecimal.valueOf(21912L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2011, 6, 1).getDate()) ? BigDecimal.valueOf(21573L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2005, 6, 1).getDate()) ? BigDecimal.valueOf(20656L, 2) : BigDecimal.valueOf(195L))))))));
        return pfandfrei;
    }

    @Override
    public int pvs() throws BusinessDomainException {
        int result = 0;
        if (this.bundeslandSchluesselBeschaeftigungsort() == 15) {
            result = 1;
        }
        return result;
    }

    @Override
    public Date startERA() throws BusinessDomainException {
        if (!this.mERAStartLoaded) {
            this.mERAStartLoaded = true;
            if (this.getPlantFoundations() == null || this.getPlantFoundations().getFoundations().getEraModel() == null) {
                if (this.getCompanyFoundations().getFoundations().getEraModel() != null) {
                    this.mERAStart = this.getCompanyFoundations().getFoundations().getEraImplementation();
                }
            } else {
                this.mERAStart = this.getPlantFoundations().getFoundations().getEraImplementation();
            }
        }
        return this.mERAStart;
    }

    @Override
    public BigDecimal svBbgKnappschaft() throws BusinessDomainException {
        BigDecimal bbg = this.marbRechtskreis() == 'W' ? this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForMinersPensionersInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP) : this.getSocialInsurance().getLawAreaEast().getMaximumAssessableEarningsForMinersPensionersInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP);
        return bbg;
    }

    @Override
    public BigDecimal svBbgKnappschaftJaehrl() throws BusinessDomainException {
        BigDecimal bbg = this.marbRechtskreis() == 'W' ? this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForMinersPensionersInsurance() : this.getSocialInsurance().getLawAreaEast().getMaximumAssessableEarningsForMinersPensionersInsurance();
        return bbg;
    }

    @Override
    public BigDecimal svSagVHSatzBelastungsgrenze() throws BusinessDomainException {
        BigDecimal result = this.getSocialInsurance().getGlobal().getDebtLimit();
        return result;
    }

    @Override
    public BigDecimal svSagDurchZusatzbeitrag() throws BusinessDomainException {
        BigDecimal result = this.getSocialInsurance().getGlobal().getAdditionalDues();
        return result;
    }

    @Override
    public BigDecimal svBbgKvPv() throws BusinessDomainException {
        BigDecimal bbg = this.marbRechtskreis() == 'W' ? this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForHealthAndNursingInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP) : this.getSocialInsurance().getLawAreaEast().getMaximumAssessableEarningsForHealthAndNursingInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP);
        return bbg;
    }

    @Override
    public BigDecimal svBbgKvPvJaehrl() throws BusinessDomainException {
        BigDecimal bbg = this.marbRechtskreis() == 'W' ? this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForHealthAndNursingInsurance() : this.getSocialInsurance().getLawAreaEast().getMaximumAssessableEarningsForHealthAndNursingInsurance();
        return bbg;
    }

    @Override
    public BigDecimal svBbgRvAvWest() throws BusinessDomainException {
        return this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal svBbgRvAvOst() throws BusinessDomainException {
        return this.getSocialInsurance().getLawAreaEast().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal svBbgRvAv() throws BusinessDomainException {
        BigDecimal bbg = this.marbRechtskreis() == 'W' ? this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP) : this.getSocialInsurance().getLawAreaEast().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP);
        return bbg;
    }

    @Override
    public BigDecimal svBbgRvAvJaehrl() throws BusinessDomainException {
        BigDecimal bbg = this.marbRechtskreis() == 'W' ? this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance() : this.getSocialInsurance().getLawAreaEast().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance();
        return bbg;
    }

    @Override
    public BigDecimal svBbgRvAvJaehrlBAV() throws BusinessDomainException {
        return this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BD4).divide(BD100, 2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal svBbgRvAvJaehrlBAV(ContractTypeEnum vertragsart) throws BusinessDomainException {
        BigDecimal freibetrag = this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BD4).divide(BD100, 2, RoundingMode.HALF_UP);
        if (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2018, 0, 1).getDate())) {
            freibetrag = freibetrag.multiply(BigDecimal.valueOf(2L));
        } else {
            switch (vertragsart.value()) {
                case 1: {
                    freibetrag = freibetrag.add(BigDecimal.valueOf(1800L));
                    break;
                }
            }
        }
        return freibetrag;
    }

    @Override
    public BigDecimal svBbgRvAvJaehrlBAV(ZvkTypeOfCalcAddContEnum vertragsartZVK) throws BusinessDomainException {
        BigDecimal freibetrag = BigDecimal.ZERO;
        switch (vertragsartZVK.value()) {
            case 5: {
                freibetrag = this.svBbgRvAvJaehrlBAV(ContractTypeEnum.CTE_Neuvertrag);
                break;
            }
            case 4: {
                freibetrag = this.svBbgRvAvJaehrlBAV(ContractTypeEnum.CTE_Neuvertrag_mit_1800);
                break;
            }
            default: {
                freibetrag = this.svBbgRvAvJaehrlBAV(ContractTypeEnum.CTE_Neuvertrag_ohne_1800);
            }
        }
        return freibetrag;
    }

    @Override
    public BigDecimal svBbgRvAvJaehrlBAV(VbluImplementationPathEnum vertragsartVBLU) throws BusinessDomainException {
        BigDecimal freibetrag = BigDecimal.ZERO;
        switch (vertragsartVBLU.value()) {
            case 5: {
                freibetrag = this.svBbgRvAvJaehrlBAV(ContractTypeEnum.CTE_Neuvertrag);
                break;
            }
            case 3: {
                freibetrag = this.svBbgRvAvJaehrlBAV(ContractTypeEnum.CTE_Neuvertrag_mit_1800);
                break;
            }
            default: {
                freibetrag = this.svBbgRvAvJaehrlBAV(ContractTypeEnum.CTE_Neuvertrag_ohne_1800);
            }
        }
        return freibetrag;
    }

    @Override
    public BigDecimal svBbgRvAvMonatlBAV(ContractTypeEnum vertragsart) throws BusinessDomainException {
        return this.svBbgRvAvJaehrlBAV(vertragsart).divide(BD12, 2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal svBbgRvAvMonatlBAV(ZvkTypeOfCalcAddContEnum vertragsartZVK) throws BusinessDomainException {
        return this.svBbgRvAvJaehrlBAV(vertragsartZVK).divide(BD12, 2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal svBbgRvAvMonatlBAV() throws BusinessDomainException {
        return this.svBbgRvAvJaehrlBAV().divide(BD12, 2, RoundingMode.HALF_UP);
    }

    private BigDecimal svBbgRvAvMonatlZVKUmlage() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        result = DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2022, 0, 1).getDate()) ? this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP).multiply(BD3).divide(BD100, 2, RoundingMode.HALF_UP) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2020, 0, 1).getDate()) ? this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP).multiply(BD3).divide(BD100, 0, RoundingMode.UP) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2014, 0, 1).getDate()) ? this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP).multiply(BD2).divide(BD100, 0, RoundingMode.UP) : this.getSocialInsurance().getLawAreaWest().getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BD30).divide(BD360, 2, RoundingMode.HALF_UP).divide(BD100, 0, RoundingMode.UP)));
        return result;
    }

    @Override
    public BigDecimal svBsDurchschnittlich() throws BusinessDomainException {
        BigDecimal beitragsSatz = this.getSocialInsurance() == null ? BigDecimal.ZERO : (this.mEELib.marbPgs() == 103 && this.mEELib.marbAtzModellArt() == TypeAgePartTimeEnum.TOAPTE_BLOCKZEIT && DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)this.mEELib.marbAtzFreistellungAb()) || this.mEELib.marbPKv() && this.mEELib.marbBklPKv() == ContributionScalePHIEnum.CSPHIE_ERMAESSIGT || this.mEELib.marbPKv() && this.mEELib.marbBklFKv() == ContributionScaleVHIEnum.CSE_ERMAESSIGT ? (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2013, 0, 1).getDate()) ? this.getSocialInsurance().getGlobal().getAverageReducedContributionRateForAllowanceInPHI() : this.getSocialInsurance().getGlobal().getAverageGeneralContributionRateForAllowanceInPHI()) : this.getSocialInsurance().getGlobal().getAverageGeneralContributionRateForAllowanceInPHI());
        if (DateHelper.between((Date)this.cCase.getValidFrom(), (Date)new VDate(2009, 0, 1).getDate(), (Date)new VDate(2014, 11, 31).getDate())) {
            beitragsSatz = beitragsSatz.subtract(this.kvZusatzVHSatz());
        }
        return beitragsSatz;
    }

    @Override
    public BigDecimal svBsGesamtAv() throws BusinessDomainException {
        return this.getSocialInsurance().getGlobal().getTotalContributionRateForUnemploymentInsurance();
    }

    @Override
    public BigDecimal svBsGesamtPV() throws BusinessDomainException {
        return this.getSocialInsurance().getGlobal().getTotalContributionRateForNursingInsurance();
    }

    @Override
    public BigDecimal svBsGesamtRv() throws BusinessDomainException {
        return this.getSocialInsurance().getGlobal().getTotalContributionRateForPensionersInsurance();
    }

    @Override
    public BigDecimal svBsKinderlosPV() throws BusinessDomainException {
        return this.getSocialInsurance().getGlobal().getEESurchargeNI();
    }

    @Override
    public BigDecimal svBsKnappschaftGesamt() throws BusinessDomainException {
        return this.getSocialInsurance().getGlobal().getTotalContributionRateForMinersPensionersInsurance();
    }

    @Override
    public BigDecimal svBsPauschGfbKV() throws BusinessDomainException {
        BigDecimal beitragsSatz = this.getSocialInsurance() == null ? BigDecimal.ZERO : this.getSocialInsurance().getGlobal().getBlanketContributionRateForHealthInsuranceConcerningLowIncomeEarners();
        return beitragsSatz;
    }

    @Override
    public BigDecimal svBsPauschGfbRv() throws BusinessDomainException {
        return this.getSocialInsurance().getGlobal().getBlanketContributionRateForPensionersInsuranceConcerningLowIncomeEarners();
    }

    @Override
    public BigDecimal svFaktorGleitzonenregelung(Date validDate) throws BusinessDomainException {
        return this.getSocialInsurance(validDate).getGlobal().getFactorForFormula();
    }

    @Override
    public BigDecimal svGeringfuegigkeitsgrenzeGfb() throws BusinessDomainException {
        return this.getSocialInsurance().getGlobal().getInsignificantMaximumLimitForLowIncomeEarnersAmount();
    }

    @Override
    public BigDecimal svGeringverdienerGrenze() throws BusinessDomainException {
        BigDecimal grvGrenze = BigDecimal.ZERO;
        if (this.cCase.getTypeOfCalculationCase() != TypeOfCalculationCase.BescheinigungOhneGeringverdienerGrenze) {
            grvGrenze = this.marbRechtskreis() == 'W' ? this.getSocialInsurance().getLawAreaWest().getGeneralMarginalValueOfLowIncomeEarners() : this.getSocialInsurance().getLawAreaEast().getGeneralMarginalValueOfLowIncomeEarners();
            if (this.mEELib.isTeilLZZVorhanden()) {
                BigDecimal kalendertage = this.ermittelKalendertageMitarbeiterFuerKuerzungGlobalerParameter();
                if (kalendertage.compareTo(BD30) > 0) {
                    kalendertage = BD30;
                }
                grvGrenze = grvGrenze.multiply(kalendertage).divide(BD30, 2, RoundingMode.HALF_UP);
            }
        } else {
            grvGrenze = BigDecimal.valueOf(999999L, 2);
        }
        return grvGrenze;
    }

    @Override
    public BigDecimal svGleitzonenObergrenze(Date validDate) throws BusinessDomainException {
        return this.getSocialInsurance(validDate).getGlobal().getLowWageUntil();
    }

    @Override
    public BigDecimal svGleitzonenUntergrenze(Date validDate) throws BusinessDomainException {
        return this.getSocialInsurance(validDate).getGlobal().getLowWageFrom();
    }

    @Override
    public BigDecimal svMbmgGfbRV() throws BusinessDomainException {
        return this.getSocialInsurance().getGlobal().getMinimumCalculationBasisForLowIncomeEarnersAmount();
    }

    @Override
    public BigDecimal svVhSatzInsGUmlage() throws BusinessDomainException {
        return this.getSocialInsurance().getGlobal().getPercentInsolvencyAssessment();
    }

    @Override
    public boolean tarifErhoehungsMonat() throws BusinessDomainException {
        IncreaseInPayRatesTP iiprtp = this.getTariferhoehungsDatensatz();
        boolean result = false;
        if (iiprtp != null) {
            result = DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)iiprtp.getValidFrom()), (Date)DateHelper.getFirstDayOfMonth((Date)this.cCase.getValidFrom()));
        }
        return result;
    }

    @Override
    public BigDecimal umlageAbfuehrungU1(HealthFund healthFund) throws BusinessDomainException {
        AssignmentPCompanyHealthFund assesmenthf = this.getAssesmentPCompanyHealthFund(healthFund);
        if (assesmenthf == null) {
            throw EvaluationExceptionMapper.makeNoValidAssignmentForU1(healthFund.getDomainKey(), this.cCase.getValidFrom());
        }
        AssignmentPCompanyHealthFundTP assesmenthfTP = assesmenthf.getAssignmentPCompanyHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        if (!DateHelper.equal((Date)assesmenthfTP.getValidUntil(), (Date)VDate.getDateMax())) {
            new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)assesmenthfTP.getValidUntil()), assesmenthfTP.getClassName());
        }
        int assesment = assesmenthfTP.getAssessment1();
        HealthFundTP hftp = healthFund.getHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        if (assesment <= 0) {
            throw EvaluationExceptionMapper.makeNoValidAssignmentForU1(hftp.getShortDescription(), this.vPosition.getValidFrom());
        }
        Assessment ass = hftp.getAssessments()[assesment - 1];
        if (ass == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentPercentageFoundForU1(hftp.getShortDescription(), this.cCase.getValidFrom());
        }
        return ass.getSubmitPercentage();
    }

    @Override
    public BigDecimal umlageErstattungU1(HealthFund healthFund) throws BusinessDomainException {
        AssignmentPCompanyHealthFundTP assesmenthfTP = this.getAssesmentPCompanyHealthFund(healthFund).getAssignmentPCompanyHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        if (!DateHelper.equal((Date)assesmenthfTP.getValidUntil(), (Date)VDate.getDateMax())) {
            new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)assesmenthfTP.getValidUntil()), assesmenthfTP.getClassName());
        }
        int assesment = assesmenthfTP.getAssessment1();
        HealthFundTP hftp = healthFund.getHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        Assessment ass = hftp.getAssessments()[assesment - 1];
        if (ass == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentPercentageFoundForU1(hftp.getShortDescription(), this.cCase.getValidFrom());
        }
        return ass.getRefundPercentage();
    }

    @Override
    public BigDecimal umlageAbfuehrungU2(HealthFund healthFund) throws BusinessDomainException {
        AssignmentPCompanyHealthFund assesmentHF = this.getAssesmentPCompanyHealthFund(healthFund);
        if (assesmentHF == null) {
            throw EvaluationExceptionMapper.makeNoValidAssignmentForU2(healthFund.getDomainKey(), this.cCase.getValidFrom());
        }
        AssignmentPCompanyHealthFundTP assesmenthfTP = assesmentHF.getAssignmentPCompanyHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        if (!DateHelper.equal((Date)assesmenthfTP.getValidUntil(), (Date)VDate.getDateMax())) {
            new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)assesmenthfTP.getValidUntil()), assesmenthfTP.getClassName());
        }
        int assesment = assesmenthfTP.getAssessment2();
        HealthFundTP hftp = healthFund.getHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        if (assesment <= 0) {
            throw EvaluationExceptionMapper.makeNoValidAssignmentForU2(hftp.getShortDescription(), this.vPosition.getValidFrom());
        }
        Assessment ass = hftp.getAssessments()[assesment - 1];
        if (ass == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentPercentageFoundForU2(hftp.getShortDescription(), this.cCase.getValidFrom());
        }
        return ass.getSubmitPercentage();
    }

    @Override
    public BigDecimal umlageErstattungU2(HealthFund healthFund) throws BusinessDomainException {
        AssignmentPCompanyHealthFundTP assesmenthfTP = this.getAssesmentPCompanyHealthFund(healthFund).getAssignmentPCompanyHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        if (!DateHelper.equal((Date)assesmenthfTP.getValidUntil(), (Date)VDate.getDateMax())) {
            new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)assesmenthfTP.getValidUntil()), assesmenthfTP.getClassName());
        }
        int assesment = assesmenthfTP.getAssessment2();
        HealthFundTP hftp = healthFund.getHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        Assessment ass = hftp.getAssessments()[assesment - 1];
        if (ass == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentPercentageFoundForU2(hftp.getShortDescription(), this.cCase.getValidFrom());
        }
        return ass.getRefundPercentage();
    }

    @Override
    public BigDecimal umlageAbfuehrungU3(HealthFund healthfund) throws BusinessDomainException {
        AssignmentPCompanyHealthFundTP assesmenthfTP = this.getAssesmentPCompanyHealthFund(healthfund).getAssignmentPCompanyHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        if (!DateHelper.equal((Date)assesmenthfTP.getValidUntil(), (Date)VDate.getDateMax())) {
            new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)assesmenthfTP.getValidUntil()), assesmenthfTP.getClassName());
        }
        int assesment = assesmenthfTP.getAssessment3();
        HealthFundTP hftp = healthfund.getHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        if (assesment <= 0) {
            throw EvaluationExceptionMapper.makeNoValidAssignmentForU3(hftp.getShortDescription(), this.vPosition.getValidFrom());
        }
        Assessment ass = hftp.getAssessments()[assesment - 1];
        if (ass == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentPercentageFoundForU3(hftp.getShortDescription(), this.cCase.getValidFrom());
        }
        return ass.getSubmitPercentage();
    }

    @Override
    public BigDecimal umlageErstattungU3(HealthFund healthFund) throws BusinessDomainException {
        AssignmentPCompanyHealthFundTP assesmenthfTP = this.getAssesmentPCompanyHealthFund(healthFund).getAssignmentPCompanyHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        if (!DateHelper.equal((Date)assesmenthfTP.getValidUntil(), (Date)VDate.getDateMax())) {
            new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)assesmenthfTP.getValidUntil()), assesmenthfTP.getClassName());
        }
        int assesment = assesmenthfTP.getAssessment3();
        HealthFundTP hftp = healthFund.getHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        Assessment ass = hftp.getAssessments()[assesment - 1];
        if (ass == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentPercentageFoundForU3(hftp.getShortDescription(), this.cCase.getValidFrom());
        }
        return ass.getRefundPercentage();
    }

    @Override
    public HealthFund umlageKasseFirma() throws BusinessDomainException {
        HealthFund umlageKasse = null;
        if (this.getPlantSettings() == null || this.getPlantSettings().getSettings() == null || this.getPlantSettings().getSettings().getRateAssessmentAccomplishingHealthFund() == null) {
            if (this.getCompanySettings() != null && this.compSettings.getSettings() != null) {
                umlageKasse = this.compSettings.getSettings().getRateAssessmentAccomplishingHealthFund();
            }
        } else {
            umlageKasse = this.plantSettings.getSettings().getRateAssessmentAccomplishingHealthFund();
        }
        return this.mEELib.checkKrkFolgeOrganisation(umlageKasse, this.cCase.getEffectiveFrom(), this.cCase.getValidFrom());
    }

    public boolean begrenzungU2MAeAufBBG(HealthFund healthFund) throws BusinessDomainException {
        HealthFundTP hftp = healthFund.getHealthFundTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
        return hftp.getU2LimittationMother();
    }

    @Override
    public boolean umlagepflichtFirma() throws BusinessDomainException {
        boolean pflichtig = false;
        if (this.getPlantSettings() == null || this.plantSettings.getSettings() == null || this.plantSettings.getSettings().getRateAssessmentAccomplishingHealthFund() == null) {
            if (this.getCompanySettings() != null && this.compSettings.getSettings() != null) {
                pflichtig = this.compSettings.getSettings().getAssessable();
            }
        } else {
            pflichtig = this.plantSettings.getSettings().getAssessable();
        }
        return pflichtig;
    }

    @Override
    public PensionschemeSettingsEnum verarbeitungBAV() throws BusinessDomainException {
        PensionschemeSettingsEnum settingsEnum = this.getPlantSettings() == null ? this.getCompanySettings().getSettings().getPensionshemeSettingsEnum() : this.getPlantSettings().getSettings().getPensionshemeSettingsEnum();
        if (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2016, 0, 1).getDate()) && this.mEELib.abweichendeBAVEinstellung()) {
            settingsEnum = settingsEnum == PensionschemeSettingsEnum.PSE_ABBAU_JAEHRLICH ? PensionschemeSettingsEnum.PSE_ABBAU_PRO_RATA : PensionschemeSettingsEnum.PSE_ABBAU_JAEHRLICH;
        }
        return settingsEnum;
    }

    @Override
    public ZvkSettingsEnum verarbeitungZVK(boolean isZusatzbeitrag) throws BusinessDomainException {
        ZvkSettingsEnum settingsEnum = ZvkSettingsEnum.ZSE_ABBAU_MONATLICH;
        if (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2018, 0, 1).getDate()) && isZusatzbeitrag) {
            settingsEnum = this.getPlantSettings() == null ? this.getCompanySettings().getSettings().getZvkSettings() : this.getPlantSettings().getSettings().getZvkSettings();
        }
        return settingsEnum;
    }

    @Override
    public boolean vertraglicheEinrechnungBAV() throws BusinessDomainException {
        return this.getCompanySettings().getStipulationToEvaluatePensionshemeInAgePartTime();
    }

    @Override
    public BigDecimal vHSatzPfandfreierAnteilDritteUnterhaltspflichtigePerson() throws BusinessDomainException {
        return BigDecimal.TEN;
    }

    @Override
    public BigDecimal vHSatzPfandfreierAnteilErsteUnterhaltspflichtigePerson() throws BusinessDomainException {
        return BD20;
    }

    @Override
    public BigDecimal vHSatzPfandfreierAnteilFuenfteUnterhaltspflichtigePerson() throws BusinessDomainException {
        return BigDecimal.TEN;
    }

    @Override
    public BigDecimal vHSatzPfandfreierAnteilSchuldner() throws BusinessDomainException {
        return BD30;
    }

    @Override
    public BigDecimal vHSatzPfandfreierAnteilVierteUnterhaltspflichtigePerson() throws BusinessDomainException {
        return BigDecimal.TEN;
    }

    @Override
    public BigDecimal vHSatzPfandfreierAnteilZweiteUnterhaltspflichtigePerson() throws BusinessDomainException {
        return BigDecimal.TEN;
    }

    @Override
    public BigDecimal vhSatzTariferhoehung() throws BusinessDomainException {
        return this.getTariferhoehungsDatensatz().getPercentOfIncrease();
    }

    @Override
    public BigDecimal vollpfaendbarOberhalb() throws BusinessDomainException {
        BigDecimal vollPfaendbarBis = DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2022, 6, 1).getDate()) ? BigDecimal.valueOf(407772L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2021, 6, 1).getDate()) ? BigDecimal.valueOf(384008L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2019, 6, 1).getDate()) ? BigDecimal.valueOf(361308L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2017, 6, 1).getDate()) ? BigDecimal.valueOf(347579L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2015, 6, 1).getDate()) ? BigDecimal.valueOf(329209L, 2) : (DateHelper.afterOrEqual((Date)this.cCase.getValidFrom(), (Date)new VDate(2013, 6, 1).getDate()) ? BigDecimal.valueOf(320367L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2011, 6, 1).getDate()) ? BigDecimal.valueOf(315415L, 2) : (DateHelper.afterOrEqual((Date)this.vPosition.getValidFrom(), (Date)new VDate(2005, 6, 1).getDate()) ? BigDecimal.valueOf(302006L, 2) : BigDecimal.valueOf(2850L))))))));
        return vollPfaendbarBis;
    }

    @Override
    public ValueType werartFuerEinfuehrungsdifferenz() throws BusinessDomainException {
        return this.getERAModellTP().getValueType1();
    }

    @Override
    public ValueType werartFuerUeberschreiterAusgleichsBetrag() throws BusinessDomainException {
        return this.getERAModellTP().getValueType4();
    }

    @Override
    public ValueType werartFuerUeberschreiterZulage() throws BusinessDomainException {
        return this.getERAModellTP().getValueType5();
    }

    @Override
    public ValueType werartFuerUnterschreiterAusgleichsBetrag() throws BusinessDomainException {
        return this.getERAModellTP().getValueType2();
    }

    @Override
    public ValueType werartFuerUnterschreiterHeranfuehrungsBetrag() throws BusinessDomainException {
        return this.getERAModellTP().getValueType3();
    }

    @Override
    public ValueType werartFuerUnterschreiterVerrechneteUeTZulage() throws BusinessDomainException {
        return this.getERAModellTP().getValueType7();
    }

    @Override
    public BigDecimal wochenstundenERAModel() throws BusinessDomainException {
        return this.getERAModellTP().getBasicHours();
    }

    private ZVK getRecipientZvk() throws BusinessDomainException {
        block4: {
            if (!this.mZvkRecipientLoaded) {
                this.mZvkRecipientLoaded = true;
                try {
                    this.mZvkRecipientTP = this.mEELib.zvKasse().getRecipientTP(this.vPosition.getEffectiveFrom(), this.vPosition.getValidFrom());
                    if (!DateHelper.equal((Date)this.mZvkRecipientTP.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mZvkRecipientTP.getValidUntil()), this.mZvkRecipientTP.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
        }
        return this.mZvkRecipientTP.getZVK();
    }

    @Override
    public BigDecimal zvkGrenzeEroehungsUmlage() throws BusinessDomainException {
        if (!this.grenzeErhoehungsUmlageLoaded) {
            this.grenzeErhoehungsUmlageLoaded = true;
            ZVK steuerungZVK = this.getRecipientZvk();
            this.grenzeErhoehungsUmlage = steuerungZVK.getMarginalValueAddAssessmentEr();
            if (new VDate(this.cCase.getValidFrom()).getMonth() == steuerungZVK.getDuplicationMonth() - 1 && this.isEGAVorhandenImVerdoppelungsmonat()) {
                this.grenzeErhoehungsUmlage = steuerungZVK.getDuplicationDuesAddAssessmentER();
            }
        }
        return this.grenzeErhoehungsUmlage;
    }

    @Override
    public BigDecimal zvkMaximalGrenze() throws BusinessDomainException {
        if (!this.maximalGrenzeLoaded) {
            this.maximalGrenzeLoaded = true;
            ZVK steuerungZVK = this.getRecipientZvk();
            this.maximalGrenze = steuerungZVK.getMaximumAmount();
            if (new VDate(this.cCase.getValidFrom()).getMonth() == steuerungZVK.getDuplicationMonth() - 1 && this.isEGAVorhandenImVerdoppelungsmonat()) {
                this.maximalGrenze = steuerungZVK.getMaximumAmount().multiply(BD2);
            }
        }
        return this.maximalGrenze;
    }

    private boolean isEGAVorhandenImVerdoppelungsmonat() {
        ValuePosition[] vpArray;
        BigDecimal betragEGA = BigDecimal.ZERO;
        for (ValuePosition vPos : vpArray = this.cCase.getValuePositionHistory().getItems(100903, this.cCase.getEffectiveFrom(), this.cCase.getValidFrom())) {
            betragEGA = betragEGA.add(vPos.getResult());
        }
        for (ValuePosition vPos : vpArray = this.cCase.getValuePositionHistory().getItems(100908, this.cCase.getEffectiveFrom(), this.cCase.getValidFrom())) {
            betragEGA = betragEGA.add(vPos.getResult());
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)betragEGA)) {
            this.egaVorhandenImVerdoppelungsmonat = true;
        }
        return this.egaVorhandenImVerdoppelungsmonat;
    }

    @Override
    public BigDecimal zvkMtlPauschalGrenze() throws BusinessDomainException {
        return this.getRecipientZvk().getMonthlyLumpSumLimit();
    }

    @Override
    public BigDecimal zvkMtlPauschalGrenzeGV() throws BusinessDomainException {
        return this.getRecipientZvk().getMonthlyLumpSumLimitGI();
    }

    @Override
    public boolean zvkSanierungsGeldAlsBetrag() throws BusinessDomainException {
        boolean result = false;
        Recipient zvk = this.mEELib.zvKasse();
        AssignmentPCompanyZVKTP assign = this.getAssesmentPCompanyZVK(zvk);
        if (assign != null && assign.getMonthlyrecapitalisationAmount().compareTo(BigDecimal.ZERO) != 0) {
            result = true;
        }
        return result;
    }

    @Override
    public TypeOfZvkEnum zvkInstitution() throws BusinessDomainException {
        return this.getRecipientZvk().getTypeOfZvk();
    }

    @Override
    public BigDecimal zvkSteuerfreiGrenzeUmlageAG() throws BusinessDomainException {
        return this.svBbgRvAvMonatlZVKUmlage();
    }

    @Override
    public BigDecimal zvkVhSatzAREV() throws BusinessDomainException {
        return this.getRecipientZvk().getPartLiableForSIPercentage();
    }

    @Override
    public BigDecimal zvkVHSatzSanierungsgeld() throws BusinessDomainException {
        return this.getRecipientZvk().getRecapitalisationPercentage();
    }

    @Override
    public BigDecimal zvkVhSatzUmlageAg() throws BusinessDomainException {
        return this.getRecipientZvk().getAssessmentErPercentage();
    }

    @Override
    public BigDecimal zvkVhSatzUmlageAn() throws BusinessDomainException {
        return this.getRecipientZvk().getAssessmentEePercentage();
    }

    @Override
    public BigDecimal zvkVhSatzZusatzbeitragAg() throws BusinessDomainException {
        return this.getRecipientZvk().getAddContErPercentage();
    }

    @Override
    public BigDecimal zvkVhSatzZusatzbeitragAn() throws BusinessDomainException {
        return this.getRecipientZvk().getAddContEePercentage();
    }

    @Override
    public BigDecimal zvkVhSatzZusatzUmlageAG() throws BusinessDomainException {
        return this.getRecipientZvk().getAddAssesmentErPercentage();
    }

    @Override
    public BigDecimal zvkVhSatzZusZusatzbeitragAG() throws BusinessDomainException {
        return this.getRecipientZvk().getExtraAddContributionEr();
    }

    @Override
    public BigDecimal marbVbluVHSatzAN() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        result = this.mEELib.marbVbluVHSatzAN();
        if (result.compareTo(BigDecimal.ZERO) == 0) {
            result = this.getRecipientVblu().getContPercEE();
        }
        return result;
    }

    @Override
    public BigDecimal marbVbluVHSatzAG() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        result = this.mEELib.marbVbluVHSatzAG();
        if (result.compareTo(BigDecimal.ZERO) == 0) {
            result = this.getRecipientVblu().getContPercER();
        }
        return result;
    }

    private VBLU getRecipientVblu() throws BusinessDomainException {
        block4: {
            if (!this.mVbluRecipientLoaded) {
                this.mVbluRecipientLoaded = true;
                try {
                    this.mVbluRecipientTP = this.mEELib.vblu().getRecipientTP(this.cCase.getEffectiveFrom(), this.cCase.getValidFrom());
                    if (!DateHelper.equal((Date)this.mVbluRecipientTP.getValidUntil(), (Date)VDate.getDateMax())) {
                        new CalculationBasic(this.cCase.getEmployee(), this.vPosition.getEffectiveFrom(), DateHelper.tomorrow((Date)this.mVbluRecipientTP.getValidUntil()), this.mVbluRecipientTP.getClassName());
                    }
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
        }
        return this.mVbluRecipientTP.getVBLU();
    }

    @Override
    public BigDecimal svBezugsgroesseAV() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        switch (this.marbRechtskreis()) {
            case 'W': 
            case 'w': {
                result = this.getSocialInsurance().getLawAreaWest().getCalculationBasisForContributionOfUnemploymentInsurance();
                break;
            }
            default: {
                result = this.getSocialInsurance().getLawAreaEast().getCalculationBasisForContributionOfUnemploymentInsurance();
            }
        }
        return result;
    }

    @Override
    public Date startDatumAAG() throws BusinessDomainException {
        DEUVSenderTP deuvSenderTP;
        DEUVSender deuvSender;
        Date startDatumAAG = this.firmaBerechnungsStart();
        CompanySettings companySettings = this.mEELib.marbFirma().getCompanySettings(this.cCase.getEffectiveFrom(), this.cCase.getValidFrom());
        if (companySettings != null && (deuvSender = companySettings.getDEUVSender()) != null && (deuvSenderTP = deuvSender.getDEUVSenderTP(this.cCase.getEffectiveFrom(), this.cCase.getValidFrom())) != null) {
            startDatumAAG = deuvSenderTP.getDateOfStartAAG();
        }
        return startDatumAAG;
    }

    @Override
    public BigDecimal bezugsgroesseRVAVBehinderteWest() throws BusinessDomainException {
        return this.getSocialInsurance().getLawAreaWest().getBasicAmountForPensionersAndUnemploymentInsurance();
    }

    @Override
    public BigDecimal bezugsgroesseRVAVBehinderteOst() throws BusinessDomainException {
        return this.getSocialInsurance().getLawAreaEast().getBasicAmountForPensionersAndUnemploymentInsurance();
    }

    @Override
    public BigDecimal mindestBemessGrundKVPVBehinderteWest() throws BusinessDomainException {
        return this.getSocialInsurance().getLawAreaWest().getMinimumCalculationBasisForContributionOfHealthAndNursingInsurance();
    }

    @Override
    public BigDecimal mindestBemessGrundKVPVBehinderteREHAWest() throws BusinessDomainException {
        return this.getSocialInsurance().getLawAreaWest().getCalculationBasisForContributionOfHealthAndNursingInsurance();
    }

    @Override
    public BigDecimal mindestBemessGrundRVBehinderteWest() throws BusinessDomainException {
        return this.getSocialInsurance().getLawAreaWest().getMinimumCalculationBasisForContributionOfPensionersInsurance();
    }

    @Override
    public BigDecimal mindestBemessGrundRVBehinderteOst() throws BusinessDomainException {
        return this.getSocialInsurance().getLawAreaEast().getMinimumCalculationBasisForContributionOfPensionersInsurance();
    }

    @Override
    public BigDecimal mindestBemessGrundRVAVBehinderteREHAWest() throws BusinessDomainException {
        return this.getSocialInsurance().getLawAreaWest().getCalculationBasisForContributionOfPensionersAndUnemploymentInsurance();
    }

    @Override
    public BigDecimal mindestBemessGrundRVAVBehinderteREHAOst() throws BusinessDomainException {
        return this.getSocialInsurance().getLawAreaEast().getCalculationBasisForContributionOfPensionersAndUnemploymentInsurance();
    }

    @Override
    public ChildAllowanceTP getChildAllowances(Date effectiveUntil, Date validUntil) throws BusinessDomainException {
        ChildAllowanceTP[] childAllowances = ChildAllowance.getChildAllowances((Date)validUntil);
        if (childAllowances.length > 0) {
            return childAllowances[0];
        }
        return null;
    }
}

