/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.libraryimpl;

import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.carriedforward.entry.EECarriedForwardOfEntry;
import com.varial.personnel.domain.employee.deuvdskk.KennzGlzEnum;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.ChoiseOfDuesHIEnum;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ICalculationCheck;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.federalstate.FederalState;
import com.varial.personnel.domain.global.federalstate.FederalStateTP;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.foundations.PlantFoundations;
import com.varial.personnel.domain.plant.place.PlantPlace;
import com.varial.personnel.domain.plant.place.PlantPlaceTP;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;

public final class CalculationCheckImpl
implements ICalculationCheck {
    private static final int STEUERTAGE = 110590;
    private static final int AUFST_VERTR = 695310;
    private static final int AUFST_GES = 695300;
    private static final int STEUERBEG_VBEZ_MKJ = 102520;
    private static final int STEUERBEG_VBEZ = 102500;
    private static final int LOHNERSATZLEIST = 103500;
    private static final int SUMME_KUG = 230500;
    private static final int SUMME_VERDIENSTAUSFALL = 152000;
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal DREI = BigDecimal.valueOf(3L);
    private static final BigDecimal VIER = BigDecimal.valueOf(4L);
    private static final BigDecimal FUENF = BigDecimal.valueOf(5L);
    private static final BigDecimal SECHS = BigDecimal.valueOf(6L);
    private static final BigDecimal SIEBEN = BigDecimal.valueOf(7L);
    private static final BigDecimal ACHT = BigDecimal.valueOf(8L);
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private final ValuePositionLibrary wplib;
    private ValuePosition[] mVpArray;
    private BigDecimal mGesBruttoLfd = BigDecimal.ZERO;
    private BigDecimal mGesBruttoEga = BigDecimal.ZERO;
    private BigDecimal mGesBruttoEgaKv = BigDecimal.ZERO;
    private BigDecimal mGesBruttoEgaRv = BigDecimal.ZERO;
    private BigDecimal mGesBruttoEgaInsG = BigDecimal.ZERO;
    private BigDecimal mAufgelKvBrutto = BigDecimal.ZERO;
    private BigDecimal mAufgelRvBrutto = BigDecimal.ZERO;
    private BigDecimal mAufgelInsGBrutto = BigDecimal.ZERO;
    private boolean mVortraegeGeladen = false;
    private EECarriedForwardOfEntry[] mVortraegeArray;

    public CalculationCheckImpl(CalculationLibrary iCallib, EmployeeLibrary iEelib, GlobalLibrary iGllib, ValuePositionLibrary iWplib) {
        this.callib = iCallib;
        this.eelib = iEelib;
        this.gllib = iGllib;
        this.wplib = iWplib;
    }

    public boolean checkGleitzoneKV() throws BusinessDomainException {
        if (this.callib.dbgzVorhanden()) {
            switch (this.callib.dbgzKennzGLZ().value()) {
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    this.checkGleitzone();
                    break;
                }
            }
        } else {
            this.checkGleitzone();
        }
        return this.callib.getCalculationCase().isGleitzoneKV();
    }

    public boolean checkGleitzoneRV() throws BusinessDomainException {
        if (this.callib.dbgzVorhanden()) {
            switch (this.callib.dbgzKennzGLZ().value()) {
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    this.checkGleitzone();
                    break;
                }
            }
        } else {
            this.checkGleitzone();
        }
        return this.callib.getCalculationCase().isGleitzoneRV();
    }

    public boolean checkGleitzoneAV() throws BusinessDomainException {
        if (this.callib.dbgzVorhanden()) {
            switch (this.callib.dbgzKennzGLZ().value()) {
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    this.checkGleitzone();
                    break;
                }
            }
        } else {
            this.checkGleitzone();
        }
        return this.callib.getCalculationCase().isGleitzoneAV();
    }

    public boolean checkGleitzonePV() throws BusinessDomainException {
        if (this.callib.dbgzVorhanden()) {
            switch (this.callib.dbgzKennzGLZ().value()) {
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    this.checkGleitzone();
                    break;
                }
            }
        } else {
            this.checkGleitzone();
        }
        return this.callib.getCalculationCase().isGleitzonePV();
    }

    public boolean checkGleitzoneInsG() throws BusinessDomainException {
        if (this.callib.dbgzVorhanden()) {
            switch (this.callib.dbgzKennzGLZ().value()) {
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    this.checkGleitzone();
                    break;
                }
            }
        } else {
            this.checkGleitzone();
        }
        return this.callib.getCalculationCase().isGleitzoneInsG();
    }

    public void checkGleitzone() throws BusinessDomainException {
        if (DateHelper.between((Date)this.wplib.gueltigAb(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                this.checkGleitzone2013();
            } else {
                if (!this.callib.getCalculationCase().isGleitzoneChecked() && DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2003, 3, 1).getDate())) {
                    this.mVpArray = this.findValueposition(130510, 130610, 130620, 129200, 129205, 129210, 129215, 129400);
                    BigDecimal lSvPflBruttoLfdAndererAG = BigDecimal.ZERO;
                    BigDecimal lSvPflBruttoEgaAndererAG = BigDecimal.ZERO;
                    BigDecimal lFiktivBrutto = BigDecimal.ZERO;
                    block7: for (ValuePosition vp : this.mVpArray) {
                        switch (vp.getValueType().getValueTypeKey()) {
                            case 130510: {
                                this.mGesBruttoLfd = this.mGesBruttoLfd.add(vp.getResult());
                                continue block7;
                            }
                            case 130610: 
                            case 130620: {
                                this.mGesBruttoEga = this.mGesBruttoEga.add(vp.getResult());
                                continue block7;
                            }
                            case 129200: 
                            case 129205: {
                                if (!this.eelib.isMehrfachbeschaeftigt()) continue block7;
                                lSvPflBruttoLfdAndererAG = lSvPflBruttoLfdAndererAG.add(vp.getResult());
                                continue block7;
                            }
                            case 129210: 
                            case 129215: {
                                if (!this.eelib.isMehrfachbeschaeftigt()) continue block7;
                                lSvPflBruttoEgaAndererAG = lSvPflBruttoEgaAndererAG.add(vp.getResult());
                                continue block7;
                            }
                            case 129400: {
                                lFiktivBrutto = lFiktivBrutto.add(vp.getResult());
                                continue block7;
                            }
                            default: {
                                EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), vp.getValueType().getValueTypeKey());
                            }
                        }
                    }
                    if (this.mGesBruttoEga.compareTo(BigDecimal.ZERO) > 0) {
                        this.abgrenzungEGA();
                    }
                    if (BigDecimalMapper.compareTo((BigDecimal)this.wplib.svTage(), (BigDecimal)DREISSIG) < 0 && !this.callib.getCalculationCase().isSignedAs23cSGBIV()) {
                        if (this.wplib.tageMitEFZ().compareTo(BigDecimal.ZERO) == 0) {
                            if (this.mGesBruttoEga.compareTo(BigDecimal.ZERO) != 0) {
                                if (lFiktivBrutto.compareTo(BigDecimal.ZERO) == 0) {
                                    throw EvaluationExceptionMapper.makeNoPaymentForGleitzone(this.callib.berchnungGueltigAb());
                                }
                                this.mGesBruttoLfd = lFiktivBrutto;
                                if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                                    lSvPflBruttoLfdAndererAG = BigDecimal.ZERO;
                                    lSvPflBruttoEgaAndererAG = BigDecimal.ZERO;
                                }
                            }
                        } else {
                            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && this.callib.dbgzVorhanden() && this.callib.dbgzSVTG() != 30) {
                                lSvPflBruttoLfdAndererAG = lSvPflBruttoLfdAndererAG.multiply(DREISSIG).divide(BigDecimal.valueOf(this.callib.dbgzSVTG()), 2, RoundingMode.HALF_UP);
                            }
                            this.mGesBruttoLfd = this.mGesBruttoLfd.multiply(DREISSIG).divide(this.wplib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
                        }
                    }
                    BigDecimal lGesBruttoKv = this.ermittleKVBrutto(lSvPflBruttoLfdAndererAG, lSvPflBruttoEgaAndererAG);
                    BigDecimal lGesBruttoRv = this.ermittleRVBrutto(lSvPflBruttoLfdAndererAG, lSvPflBruttoEgaAndererAG);
                    BigDecimal lGesBruttoAv = this.ermittleAVBrutto(lSvPflBruttoLfdAndererAG, lSvPflBruttoEgaAndererAG);
                    BigDecimal lGesBruttoPv = this.ermittlePVBrutto(lSvPflBruttoLfdAndererAG, lSvPflBruttoEgaAndererAG);
                    BigDecimal lGesBruttoInsG = this.ermittleInsGBruuto(lSvPflBruttoLfdAndererAG, lSvPflBruttoEgaAndererAG);
                    this.checkGleitzone(lGesBruttoKv, lGesBruttoRv, lGesBruttoAv, lGesBruttoPv, lGesBruttoInsG);
                } else {
                    new CalculationBasic(this.wplib.wertPosition().getEmployee(), this.wplib.wirksamAb(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), CalculationCheckImpl.class.getName());
                }
                new CalculationBasic(this.wplib.wertPosition().getEmployee(), this.callib.berchnungWirksamAb(), new VDate(2013, 0, 1).getDate(), CalculationCheckImpl.class.getName());
            }
        } else {
            new CalculationBasic(this.wplib.wertPosition().getEmployee(), this.wplib.wirksamAb(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), CalculationCheckImpl.class.getName());
        }
    }

    private void checkGleitzone(BigDecimal lGesBruttoKv, BigDecimal lGesBruttoRv, BigDecimal lGesBruttoAv, BigDecimal lGesBruttoPv, BigDecimal lGesBruttoInsG) throws BusinessDomainException {
        this.callib.getCalculationCase().setGleitzoneChecked(true);
        if (lGesBruttoKv.compareTo(this.gllib.svGleitzonenObergrenze(this.callib.berchnungGueltigAb())) <= 0 && !this.eelib.isMarbGleitzoneNurAV()) {
            this.callib.getCalculationCase().setGleitzoneKV(true);
        }
        if (lGesBruttoRv.compareTo(this.gllib.svGleitzonenObergrenze(this.callib.berchnungGueltigAb())) <= 0 && !this.eelib.isMarbGleitzoneNurAV()) {
            this.callib.getCalculationCase().setGleitzoneRV(true);
        }
        if (lGesBruttoAv.compareTo(this.gllib.svGleitzonenObergrenze(this.callib.berchnungGueltigAb())) <= 0) {
            this.callib.getCalculationCase().setGleitzoneAV(true);
        }
        if (lGesBruttoPv.compareTo(this.gllib.svGleitzonenObergrenze(this.callib.berchnungGueltigAb())) <= 0 && !this.eelib.isMarbGleitzoneNurAV()) {
            this.callib.getCalculationCase().setGleitzonePV(true);
        }
        if (lGesBruttoInsG.compareTo(this.gllib.svGleitzonenObergrenze(this.callib.berchnungGueltigAb())) <= 0 && !this.eelib.isMarbGleitzoneNurAV()) {
            this.callib.getCalculationCase().setGleitzoneInsG(true);
        }
    }

    private BigDecimal ermittleInsGBruuto(BigDecimal lSvPflBruttoLfdAndererAG, BigDecimal lSvPflBruttoEgaAndererAG) throws BusinessDomainException {
        BigDecimal lGesBruttoInsG = this.eelib.isMehrfachbeschaeftigt() && this.eelib.isMarbInsGPflAndererAG() || this.callib.dbgzVorhanden() || this.callib.dbbgVorhanden() ? this.mGesBruttoLfd.add(this.mGesBruttoEgaInsG).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG) : this.mGesBruttoLfd.add(this.mGesBruttoEgaInsG);
        return lGesBruttoInsG;
    }

    private BigDecimal ermittlePVBrutto(BigDecimal lSvPflBruttoLfdAndererAG, BigDecimal lSvPflBruttoEgaAndererAG) throws BusinessDomainException {
        BigDecimal lGesBruttoPv = this.eelib.isMehrfachbeschaeftigt() && (this.eelib.marbBgrKvAndererAG() != 0 || this.eelib.marbBgrPvAndererAG() != 0) || this.callib.dbgzVorhanden() || this.callib.dbbgVorhanden() ? this.mGesBruttoLfd.add(this.mGesBruttoEgaKv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG) : this.mGesBruttoLfd.add(this.mGesBruttoEgaKv);
        return lGesBruttoPv;
    }

    private BigDecimal ermittleAVBrutto(BigDecimal lSvPflBruttoLfdAndererAG, BigDecimal lSvPflBruttoEgaAndererAG) throws BusinessDomainException {
        BigDecimal lGesBruttoAv = this.eelib.isMehrfachbeschaeftigt() && this.eelib.marbBgrAvAndererAG() != 0 && !this.eelib.isMarbGleitzoneNurAV() || this.callib.dbgzVorhanden() && this.callib.dbgzKennzGLZ() != KennzGlzEnum.KGE_3_GLEITZONE_OHNE_AV || this.callib.dbbgVorhanden() ? this.mGesBruttoLfd.add(this.mGesBruttoEgaRv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG) : this.mGesBruttoLfd.add(this.mGesBruttoEgaRv);
        return lGesBruttoAv;
    }

    private BigDecimal ermittleRVBrutto(BigDecimal lSvPflBruttoLfdAndererAG, BigDecimal lSvPflBruttoEgaAndererAG) throws BusinessDomainException {
        BigDecimal lGesBruttoRv = this.eelib.isMehrfachbeschaeftigt() && this.eelib.marbBgrRvAndererAG() != 0 || this.callib.dbgzVorhanden() || this.callib.dbbgVorhanden() ? this.mGesBruttoLfd.add(this.mGesBruttoEgaRv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG) : this.mGesBruttoLfd.add(this.mGesBruttoEgaRv);
        return lGesBruttoRv;
    }

    private BigDecimal ermittleKVBrutto(BigDecimal lSvPflBruttoLfdAndererAG, BigDecimal lSvPflBruttoEgaAndererAG) throws BusinessDomainException {
        BigDecimal lGesBruttoKv = this.eelib.isMehrfachbeschaeftigt() && this.eelib.marbBgrKvAndererAG() != 0 || this.callib.dbgzVorhanden() || this.callib.dbbgVorhanden() ? this.mGesBruttoLfd.add(this.mGesBruttoEgaKv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG) : this.mGesBruttoLfd.add(this.mGesBruttoEgaKv);
        return lGesBruttoKv;
    }

    private void checkGleitzone2013() throws BusinessDomainException {
        if (!this.callib.getCalculationCase().isGleitzoneChecked()) {
            this.mVpArray = this.findValueposition(130510, 130560, 130610, 130620, 129200, 129205, 129210, 129215, 129400);
            BigDecimal lSvPflBruttoLfdAndererAG = BigDecimal.ZERO;
            BigDecimal lSvPflBruttoEgaAndererAG = BigDecimal.ZERO;
            BigDecimal lFiktivBrutto = BigDecimal.ZERO;
            block7: for (ValuePosition vp : this.mVpArray) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 130510: 
                    case 130560: {
                        this.mGesBruttoLfd = this.mGesBruttoLfd.add(vp.getResult());
                        continue block7;
                    }
                    case 130610: 
                    case 130620: {
                        this.mGesBruttoEga = this.mGesBruttoEga.add(vp.getResult());
                        continue block7;
                    }
                    case 129200: 
                    case 129205: {
                        if (!this.eelib.isMehrfachbeschaeftigt()) continue block7;
                        lSvPflBruttoLfdAndererAG = lSvPflBruttoLfdAndererAG.add(vp.getResult());
                        continue block7;
                    }
                    case 129210: 
                    case 129215: {
                        if (!this.eelib.isMehrfachbeschaeftigt()) continue block7;
                        lSvPflBruttoEgaAndererAG = lSvPflBruttoEgaAndererAG.add(vp.getResult());
                        continue block7;
                    }
                    case 129400: {
                        lFiktivBrutto = lFiktivBrutto.add(vp.getResult());
                        continue block7;
                    }
                    default: {
                        EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), vp.getValueType().getValueTypeKey());
                    }
                }
            }
            if (this.mGesBruttoEga.compareTo(BigDecimal.ZERO) > 0) {
                this.abgrenzungEGA();
            }
            if (BigDecimalMapper.compareTo((BigDecimal)this.wplib.svTage(), (BigDecimal)DREISSIG) < 0 && !this.callib.getCalculationCase().isSignedAs23cSGBIV()) {
                if (this.wplib.tageMitEFZ().compareTo(BigDecimal.ZERO) == 0) {
                    if (this.mGesBruttoEga.compareTo(BigDecimal.ZERO) != 0) {
                        if (lFiktivBrutto.compareTo(BigDecimal.ZERO) == 0) {
                            throw EvaluationExceptionMapper.makeNoPaymentForGleitzone(this.callib.berchnungGueltigAb());
                        }
                        this.mGesBruttoLfd = lFiktivBrutto;
                        lSvPflBruttoLfdAndererAG = BigDecimal.ZERO;
                        lSvPflBruttoEgaAndererAG = BigDecimal.ZERO;
                    }
                } else {
                    this.mGesBruttoLfd = this.mGesBruttoLfd.multiply(DREISSIG).divide(this.wplib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
                }
            }
            if (this.callib.dbgzVorhanden()) {
                if (this.callib.dbgzSVTG() == 0) {
                    lSvPflBruttoLfdAndererAG = BigDecimal.ZERO;
                } else if (this.callib.dbgzSVTG() < 30) {
                    lSvPflBruttoLfdAndererAG = lSvPflBruttoLfdAndererAG.multiply(DREISSIG).divide(BigDecimal.valueOf(this.callib.dbgzSVTG()), 2, RoundingMode.HALF_UP);
                }
            }
            BigDecimal lGesBruttoKv = this.ermittleKVBrutto2013(lSvPflBruttoLfdAndererAG, lSvPflBruttoEgaAndererAG);
            BigDecimal lGesBruttoRv = this.ermittleRVBrutto2013(lSvPflBruttoLfdAndererAG, lSvPflBruttoEgaAndererAG);
            BigDecimal lGesBruttoAv = this.ermittleAVBrutto2013(lSvPflBruttoLfdAndererAG, lSvPflBruttoEgaAndererAG);
            BigDecimal lGesBruttoPv = this.ermittlePVBrutto2013(lSvPflBruttoLfdAndererAG, lSvPflBruttoEgaAndererAG);
            BigDecimal lGesBruttoInsG = this.ermittleInsGBrutto2013(lSvPflBruttoLfdAndererAG, lSvPflBruttoEgaAndererAG);
            this.checkGleitzone2013(lGesBruttoKv, lGesBruttoRv, lGesBruttoAv, lGesBruttoPv, lGesBruttoInsG);
        } else {
            new CalculationBasic(this.wplib.wertPosition().getEmployee(), this.wplib.wirksamAb(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), CalculationCheckImpl.class.getName());
        }
    }

    private void checkGleitzone2013(BigDecimal lGesBruttoKv, BigDecimal lGesBruttoRv, BigDecimal lGesBruttoAv, BigDecimal lGesBruttoPv, BigDecimal lGesBruttoInsG) throws BusinessDomainException {
        BigDecimal lGleitzonenObergrenze = this.gllib.svGleitzonenObergrenze(this.callib.berchnungGueltigAb());
        if (this.eelib.kennzBestandGleitzone()) {
            lGleitzonenObergrenze = BigDecimal.valueOf(800L);
        }
        this.callib.getCalculationCase().setGleitzoneChecked(true);
        if (lGesBruttoKv.compareTo(lGleitzonenObergrenze) <= 0 && (!this.eelib.isMarbGleitzoneNurAV() || this.callib.dbgzVorhanden())) {
            this.callib.getCalculationCase().setGleitzoneKV(true);
        }
        if (lGesBruttoRv.compareTo(lGleitzonenObergrenze) <= 0 && (!this.eelib.isMarbGleitzoneNurAV() || this.callib.dbgzVorhanden())) {
            this.callib.getCalculationCase().setGleitzoneRV(true);
        }
        if (lGesBruttoAv.compareTo(lGleitzonenObergrenze) <= 0) {
            this.callib.getCalculationCase().setGleitzoneAV(true);
        }
        if (lGesBruttoPv.compareTo(lGleitzonenObergrenze) <= 0 && (!this.eelib.isMarbGleitzoneNurAV() || this.callib.dbgzVorhanden())) {
            this.callib.getCalculationCase().setGleitzonePV(true);
        }
        if (lGesBruttoInsG.compareTo(lGleitzonenObergrenze) <= 0 && (!this.eelib.isMarbGleitzoneNurAV() || this.callib.dbgzVorhanden())) {
            this.callib.getCalculationCase().setGleitzoneInsG(true);
        }
    }

    private BigDecimal ermittleInsGBrutto2013(BigDecimal lSvPflBruttoLfdAndererAG, BigDecimal lSvPflBruttoEgaAndererAG) throws BusinessDomainException {
        BigDecimal lGesBruttoInsG;
        if (this.callib.dbgzVorhanden()) {
            switch (this.callib.dbgzKennzGLZ().value()) {
                case 1: 
                case 3: {
                    lGesBruttoInsG = this.mGesBruttoLfd.add(this.mGesBruttoEgaInsG).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG);
                    break;
                }
                default: {
                    lGesBruttoInsG = this.mGesBruttoLfd.add(this.mGesBruttoEgaInsG);
                    break;
                }
            }
        } else {
            lGesBruttoInsG = this.eelib.isMehrfachbeschaeftigt() && this.eelib.isMarbInsGPflAndererAG() ? this.mGesBruttoLfd.add(this.mGesBruttoEgaInsG).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG) : this.mGesBruttoLfd.add(this.mGesBruttoEgaInsG);
        }
        return lGesBruttoInsG;
    }

    private BigDecimal ermittlePVBrutto2013(BigDecimal lSvPflBruttoLfdAndererAG, BigDecimal lSvPflBruttoEgaAndererAG) throws BusinessDomainException {
        BigDecimal lGesBruttoPv;
        if (this.callib.dbgzVorhanden()) {
            switch (this.callib.dbgzKennzGLZ().value()) {
                case 1: 
                case 3: {
                    lGesBruttoPv = this.mGesBruttoLfd.add(this.mGesBruttoEgaKv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG);
                    break;
                }
                default: {
                    lGesBruttoPv = this.mGesBruttoLfd.add(this.mGesBruttoEgaKv);
                    break;
                }
            }
        } else {
            lGesBruttoPv = this.eelib.isMehrfachbeschaeftigt() && (this.eelib.marbBgrKvAndererAG() != 0 && this.eelib.marbBgrKvAndererAG() != 6 || this.eelib.marbBgrPvAndererAG() != 0) ? this.mGesBruttoLfd.add(this.mGesBruttoEgaKv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG) : this.mGesBruttoLfd.add(this.mGesBruttoEgaKv);
        }
        return lGesBruttoPv;
    }

    private BigDecimal ermittleAVBrutto2013(BigDecimal lSvPflBruttoLfdAndererAG, BigDecimal lSvPflBruttoEgaAndererAG) throws BusinessDomainException {
        BigDecimal lGesBruttoAv = this.callib.dbgzVorhanden() ? (this.callib.dbgzKennzGLZ().value() == 1 ? this.mGesBruttoLfd.add(this.mGesBruttoEgaRv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG) : this.mGesBruttoLfd.add(this.mGesBruttoEgaRv)) : (this.eelib.isMehrfachbeschaeftigt() && this.eelib.marbBgrAvAndererAG() != 0 && !this.eelib.isMarbGleitzoneNurAV() ? this.mGesBruttoLfd.add(this.mGesBruttoEgaRv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG) : this.mGesBruttoLfd.add(this.mGesBruttoEgaRv));
        return lGesBruttoAv;
    }

    private BigDecimal ermittleRVBrutto2013(BigDecimal lSvPflBruttoLfdAndererAG, BigDecimal lSvPflBruttoEgaAndererAG) throws BusinessDomainException {
        BigDecimal lGesBruttoRv;
        if (this.callib.dbgzVorhanden()) {
            switch (this.callib.dbgzKennzGLZ().value()) {
                case 1: 
                case 3: {
                    lGesBruttoRv = this.mGesBruttoLfd.add(this.mGesBruttoEgaRv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG);
                    break;
                }
                default: {
                    lGesBruttoRv = this.mGesBruttoLfd.add(this.mGesBruttoEgaRv);
                    break;
                }
            }
        } else {
            lGesBruttoRv = this.eelib.isMehrfachbeschaeftigt() && this.eelib.marbBgrRvAndererAG() != 0 && this.eelib.marbBgrRvAndererAG() != 5 ? this.mGesBruttoLfd.add(this.mGesBruttoEgaRv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG) : this.mGesBruttoLfd.add(this.mGesBruttoEgaRv);
        }
        return lGesBruttoRv;
    }

    private BigDecimal ermittleKVBrutto2013(BigDecimal lSvPflBruttoLfdAndererAG, BigDecimal lSvPflBruttoEgaAndererAG) throws BusinessDomainException {
        BigDecimal lGesBruttoKv;
        if (this.callib.dbgzVorhanden()) {
            switch (this.callib.dbgzKennzGLZ().value()) {
                case 1: 
                case 3: {
                    lGesBruttoKv = this.mGesBruttoLfd.add(this.mGesBruttoEgaKv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG);
                    break;
                }
                default: {
                    lGesBruttoKv = this.mGesBruttoLfd.add(this.mGesBruttoEgaKv);
                    break;
                }
            }
        } else {
            lGesBruttoKv = this.eelib.isMehrfachbeschaeftigt() && this.eelib.marbBgrKvAndererAG() != 0 && this.eelib.marbBgrKvAndererAG() != 6 ? this.mGesBruttoLfd.add(this.mGesBruttoEgaKv).add(lSvPflBruttoLfdAndererAG).add(lSvPflBruttoEgaAndererAG) : this.mGesBruttoLfd.add(this.mGesBruttoEgaKv);
        }
        return lGesBruttoKv;
    }

    private ValuePosition[] findValueposition(int ... wertartenNummern) throws BusinessDomainException {
        ValueType[] vtArray = this.findValueType(wertartenNummern);
        return this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), vtArray);
    }

    private ValueType[] findValueType(int[] wertartenNummern) {
        ValueType[] vtArray = new ValueType[wertartenNummern.length];
        for (int i = 0; i < wertartenNummern.length; ++i) {
            vtArray[i] = ValueType.getValueType((int)wertartenNummern[i]);
        }
        return vtArray;
    }

    private void abgrenzungEGA() throws BusinessDomainException {
        this.aufgelaufenesSVPflichtigesAEBisVormonat();
        boolean beitragspflichtig = this.eelib.marb().isContributory(this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb());
        BigDecimal anteiligeBbgKv = this.wplib.aufgelBbgKv(beitragspflichtig).add(this.gllib.svBbgKvPv().multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP));
        BigDecimal anteiligeBbgRv = this.wplib.aufgelBbgRv(beitragspflichtig).add(this.gllib.svBbgRvAv().multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP));
        BigDecimal anteiligeBbgInsG = this.wplib.aufgelBbgInsG(beitragspflichtig).add(this.gllib.svBbgRvAv().multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP));
        BigDecimal svLuftKv = anteiligeBbgKv.subtract(this.mAufgelKvBrutto.add(this.mGesBruttoLfd));
        BigDecimal svLuftRv = anteiligeBbgRv.subtract(this.mAufgelRvBrutto.add(this.mGesBruttoLfd));
        BigDecimal svLuftInsG = anteiligeBbgInsG.subtract(this.mAufgelInsGBrutto.add(this.mGesBruttoLfd));
        BigDecimal lEgaMkFaehig = BigDecimal.ZERO;
        if (DateHelper.between((Date)this.callib.berchnungGueltigAb(), (Date)DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfQuartal((Date)DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb()))) && this.pruefeMKmoegl()) {
            block3: for (ValuePosition vp : this.mVpArray) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 130610: 
                    case 130620: {
                        if (vp.isPaymentAfterWithdrawal()) continue block3;
                        lEgaMkFaehig = lEgaMkFaehig.add(vp.getResult());
                        continue block3;
                    }
                }
            }
        }
        if (lEgaMkFaehig.compareTo(BigDecimal.ZERO) > 0 && this.mGesBruttoEga.compareTo(svLuftKv) > 0) {
            this.mGesBruttoEga = this.mGesBruttoEga.subtract(lEgaMkFaehig);
        }
        this.mGesBruttoEgaKv = this.mGesBruttoEga.compareTo(svLuftKv) > 0 ? svLuftKv : this.mGesBruttoEga;
        this.mGesBruttoEgaRv = this.mGesBruttoEga.compareTo(svLuftRv) > 0 ? svLuftRv : this.mGesBruttoEga;
        this.mGesBruttoEgaInsG = this.mGesBruttoEga.compareTo(svLuftInsG) > 0 ? svLuftInsG : this.mGesBruttoEga;
    }

    private boolean pruefeMKmoegl() throws BusinessDomainException {
        Date lLetzterTagDesVorjahres = DateHelper.yesterday((Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()));
        VDate gueltigAb = new VDate(DateHelper.getFirstDayOfMonth((Date)lLetzterTagDesVorjahres));
        Employee employee = this.wplib.wertPosition().getEmployee();
        ValueType[] vtArray = new ValueType[]{ValueType.getValueType((int)130590)};
        while (DateHelper.beforeOrEqual((Date)DateHelper.getFirstDayOfYear((Date)lLetzterTagDesVorjahres), (Date)gueltigAb.getDate())) {
            EEAbsentTimeTP[] fehlzeiten;
            try {
                Employment empl = employee.getEmployment(this.wplib.wirksamAb(), gueltigAb.getDate());
                if (empl.getDateOfWithDrawal() != null && DateHelper.before((Date)empl.getDateOfWithDrawal(), (Date)gueltigAb.getDate())) {
                    gueltigAb = gueltigAb.addMonths(-1);
                    continue;
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break;
                throw e;
            }
            if (!employee.isContributory(this.wplib.wirksamAb(), gueltigAb.getDate())) {
                gueltigAb = gueltigAb.addMonths(-1);
                continue;
            }
            ValuePosition[] valueArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), gueltigAb.getDate(), DateHelper.getLastDayOfMonth((Date)gueltigAb.getDate()), vtArray);
            BigDecimal svTage = BigDecimal.ZERO;
            for (ValuePosition lElement : valueArray) {
                svTage = svTage.add(lElement.getFactor1());
            }
            if (BigDecimalMapper.compareTo((BigDecimal)svTage, (BigDecimal)BigDecimal.ZERO) > 0) {
                if (this.callib.getCalculationCase().getCalculation() != null && !this.callib.isMaerzklausel()) {
                    this.callib.setMaerzklauselGueltigAb(gueltigAb.getDate());
                }
                return true;
            }
            for (EEAbsentTimeTP fehlzeit : fehlzeiten = employee.getEEAbsentTimesTP(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.wplib.wirksamAb())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.wplib.wirksamAb())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)gueltigAb.getDate()))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)gueltigAb.getDate())))}), true)) {
                String deuvSchluessel = fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey();
                if (StringMapper.compareTo((String)deuvSchluessel, (String)"") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"4.1") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"4.5") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"5.1") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"W6.1") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"Z6.2") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"W35.3") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"WA6.8") != 0 && StringMapper.compareTo((String)deuvSchluessel, (String)"ZA6.9") != 0) continue;
                if (!this.callib.isMaerzklausel()) {
                    this.callib.setMaerzklauselGueltigAb(gueltigAb.getDate());
                }
                return true;
            }
            gueltigAb = gueltigAb.addMonths(-1);
        }
        return false;
    }

    private void aufgelaufenesSVPflichtigesAEBisVormonat() throws BusinessDomainException {
        ValuePosition[] vpArray = null;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb());
        int[] wertArtenNr = null;
        wertArtenNr = DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate()) ? new int[]{321510, 321514, 321610, 321614, 327510, 327514, 327610, 327614, 365510, 365511, 365514, 365610, 365614} : new int[]{321510, 321514, 321610, 321614, 327510, 327514, 327610, 327614};
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()))) {
            BigDecimal monatlBruttoKV = BigDecimal.ZERO;
            BigDecimal monatlBruttoRV = BigDecimal.ZERO;
            BigDecimal monatlBruttoInsG = BigDecimal.ZERO;
            block6: for (ValuePosition vp : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)suchDatum), DateHelper.getLastDayOfMonth((Date)suchDatum), this.findValueType(wertArtenNr))) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 321510: 
                    case 321514: 
                    case 321610: 
                    case 321614: {
                        monatlBruttoKV = monatlBruttoKV.add(vp.getResult());
                        continue block6;
                    }
                    case 327510: 
                    case 327514: 
                    case 327610: 
                    case 327614: {
                        monatlBruttoRV = monatlBruttoRV.add(vp.getResult());
                        continue block6;
                    }
                    case 365510: 
                    case 365511: 
                    case 365514: 
                    case 365610: 
                    case 365614: {
                        monatlBruttoInsG = monatlBruttoInsG.add(vp.getResult());
                        continue block6;
                    }
                    default: {
                        EvaluationExceptionMapper.makeWrongValueTypeDomaineException("CalculationCheckImpl", vp.getValueType().getValueTypeKey());
                    }
                }
            }
            if (monatlBruttoKV.compareTo(BigDecimal.ZERO) > 0) {
                this.mAufgelKvBrutto = this.mAufgelKvBrutto.add(monatlBruttoKV);
            }
            if (monatlBruttoRV.compareTo(BigDecimal.ZERO) > 0) {
                this.mAufgelRvBrutto = this.mAufgelRvBrutto.add(monatlBruttoRV);
            }
            if (monatlBruttoInsG.compareTo(BigDecimal.ZERO) > 0) {
                this.mAufgelInsGBrutto = this.mAufgelInsGBrutto.add(monatlBruttoInsG);
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
    }

    public boolean checkErhoehterLeistungssatz() throws BusinessDomainException {
        boolean result = false;
        switch (this.eelib.abwLeistungsSatzKug().value()) {
            case 0: {
                if (this.eelib.zkf().compareTo(BigDecimal.ZERO) <= 0) break;
                result = true;
                break;
            }
            case 1: {
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean ausschlussLSTJA() throws BusinessDomainException {
        boolean ausschluss = false;
        Date suchdatum = DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb());
        Date endedatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfYear((Date)this.wplib.gueltigAb()));
        if (DateHelper.after((Date)this.eelib.marbEintritt(), (Date)suchdatum)) {
            ausschluss = true;
        }
        ValueType[] wertarten = ValueTypeHelper.getValueTypes(103510, 103515, 103500, 110595, 102500, 102520, 695300, 695310, 110590, 230500, 152000);
        BigDecimal mSteuertage = BigDecimal.ZERO;
        int lSteuerklasse = -1;
        int rechtskreisAlt = 0;
        String bundeslandAlt = "";
        BigDecimal zusatzbeitragssatzAlt = null;
        int bgsKVAlt = 10;
        boolean enterneigenschaftAlt = false;
        while (DateHelper.before((Date)suchdatum, (Date)endedatum) && !ausschluss) {
            Insurance insurance;
            block72: {
                int rechtskreis;
                FederalStateTP federalStateTP;
                block71: {
                    Tax steuerdaten;
                    Employment empl;
                    boolean value;
                    block70: {
                        this.mVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)suchdatum), DateHelper.getLastDayOfMonth((Date)suchdatum), wertarten);
                        Configuration configuration = (Configuration)UtilitiesManager.getApplicationContext().getBean("com.infor.igf.configuration", Configuration.class);
                        value = configuration.getBoolean("com.varial.calculation.tax.like160", false);
                        empl = null;
                        steuerdaten = null;
                        try {
                            steuerdaten = this.eelib.marb().getTax(this.callib.berchnungWirksamAb(), suchdatum);
                            empl = this.eelib.marb().getEmployment(this.callib.berchnungWirksamAb(), suchdatum);
                        }
                        catch (BusinessDomainException e) {
                            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block70;
                            throw e;
                        }
                    }
                    Date dateOfWithDrawal = null;
                    if (empl != null) {
                        dateOfWithDrawal = empl.getDateOfWithDrawal();
                    }
                    int steuerklasse = 0;
                    if (steuerdaten != null) {
                        steuerklasse = steuerdaten.getTaxBracket();
                    } else {
                        ValuePosition[] vortrag = this.getVortrag(suchdatum);
                        if (vortrag != null) {
                            steuerklasse = vortrag.getTaxBracket();
                            if (vortrag.getNumberOfU() > 0 || vortrag.getExclusionAnnualIncomeTaxReturn() || !BigDecimalMapper.isZeroOrNull((BigDecimal)vortrag.getWageReplacementBenefit())) {
                                ausschluss = true;
                            }
                        }
                    }
                    if (dateOfWithDrawal != null) {
                        if (DateHelper.beforeOrEqual((Date)suchdatum, (Date)dateOfWithDrawal)) {
                            if (lSteuerklasse == -1) {
                                lSteuerklasse = steuerklasse;
                            } else {
                                if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2016, 0, 1).getDate())) {
                                    if (steuerklasse != lSteuerklasse) {
                                        ausschluss = true;
                                        this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, SIEBEN, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                    }
                                } else if (steuerklasse != lSteuerklasse) {
                                    switch (steuerklasse) {
                                        case 2: {
                                            if (lSteuerklasse != 1) break;
                                            ausschluss = true;
                                            this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, SIEBEN, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                            break;
                                        }
                                        case 3: 
                                        case 4: 
                                        case 5: 
                                        case 6: {
                                            ausschluss = true;
                                            this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, SIEBEN, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                        }
                                    }
                                }
                                switch (lSteuerklasse) {
                                    case 5: 
                                    case 6: {
                                        ausschluss = true;
                                        this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, SIEBEN, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                    }
                                }
                                lSteuerklasse = steuerklasse;
                            }
                        }
                    } else if (lSteuerklasse == -1) {
                        lSteuerklasse = steuerklasse;
                    } else {
                        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2016, 0, 1).getDate())) {
                            if (steuerklasse != lSteuerklasse) {
                                ausschluss = true;
                                this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, SIEBEN, BigDecimal.ZERO, BigDecimal.ZERO, true);
                            }
                        } else if (steuerklasse != lSteuerklasse) {
                            switch (steuerklasse) {
                                case 2: {
                                    if (lSteuerklasse != 1) break;
                                    ausschluss = true;
                                    this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, SIEBEN, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: 
                                case 6: {
                                    ausschluss = true;
                                    this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, SIEBEN, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                }
                            }
                        }
                        switch (lSteuerklasse) {
                            case 5: 
                            case 6: {
                                ausschluss = true;
                                this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, SIEBEN, BigDecimal.ZERO, BigDecimal.ZERO, true);
                            }
                        }
                        lSteuerklasse = steuerklasse;
                    }
                    if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) {
                        mSteuertage = BigDecimal.ZERO;
                    } else if (!value) {
                        mSteuertage = BigDecimal.ZERO;
                    }
                    block33: for (ValuePosition vp : this.mVpArray) {
                        switch (vp.getValueType().getValueTypeKey()) {
                            case 103500: 
                            case 230500: {
                                if (BigDecimalMapper.isZeroOrNull((BigDecimal)vp.getResult())) continue block33;
                                this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ONE, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                ausschluss = true;
                                continue block33;
                            }
                            case 110595: {
                                if (BigDecimalMapper.isZeroOrNull((BigDecimal)vp.getFactor1())) continue block33;
                                this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, ZWEI, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                ausschluss = true;
                                continue block33;
                            }
                            case 102500: 
                            case 102520: {
                                if (BigDecimalMapper.isZeroOrNull((BigDecimal)vp.getResult())) continue block33;
                                this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, DREI, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                ausschluss = true;
                                continue block33;
                            }
                            case 103510: 
                            case 103515: {
                                if (BigDecimalMapper.isZeroOrNull((BigDecimal)vp.getResult())) continue block33;
                                this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, VIER, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                ausschluss = true;
                                continue block33;
                            }
                            case 695300: 
                            case 695310: {
                                if (BigDecimalMapper.isZeroOrNull((BigDecimal)vp.getResult())) continue block33;
                                this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, FUENF, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                ausschluss = true;
                                continue block33;
                            }
                            case 152000: {
                                if (BigDecimalMapper.isZeroOrNull((BigDecimal)vp.getResult())) continue block33;
                                this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, ACHT, BigDecimal.ZERO, BigDecimal.ZERO, true);
                                ausschluss = true;
                                continue block33;
                            }
                            case 110590: {
                                mSteuertage = vp.getFactor1();
                                continue block33;
                            }
                            default: {
                                throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException("CalculationCheckImpl", vp.getValueType().getValueTypeKey());
                            }
                        }
                    }
                    if (mSteuertage.compareTo(DREISSIG) != 0 && !ausschluss) {
                        ausschluss = this.checkVortragVorhanden(suchdatum);
                    }
                    FederalState federalState = this.marbBundesland(this.callib.berchnungWirksamAb(), suchdatum);
                    federalStateTP = null;
                    if (federalState != null) {
                        try {
                            federalStateTP = federalState.getFederalStateTP(this.callib.berchnungWirksamAb(), suchdatum);
                        }
                        catch (BusinessDomainException e) {
                            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block71;
                            throw e;
                        }
                    }
                }
                String bundesland = "";
                if (federalStateTP == null) {
                    rechtskreis = 87;
                } else {
                    rechtskreis = federalStateTP.getLawArea().charAt(0);
                    bundesland = federalStateTP.getShortDescSocialInsuranceLaw();
                }
                if (rechtskreisAlt != 0 && rechtskreisAlt != rechtskreis) {
                    ausschluss = true;
                }
                rechtskreisAlt = rechtskreis;
                if (!StringMapper.isNullString((String)bundeslandAlt) && (StringMapper.equal((String)bundesland, (String)"SN") || StringMapper.equal((String)bundeslandAlt, (String)"SN")) && !StringMapper.equal((String)bundesland, (String)bundeslandAlt)) {
                    ausschluss = true;
                }
                bundeslandAlt = bundesland;
                insurance = null;
                try {
                    insurance = this.eelib.marb().getInsurance(this.callib.berchnungWirksamAb(), suchdatum);
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block72;
                    throw e;
                }
            }
            if (insurance != null) {
                BigDecimal zusatzbeitragssatz = BigDecimal.ZERO;
                int bgsKV = 10;
                boolean enterneigenschaft = false;
                switch (insurance.getDuesGroupHI()) {
                    case 0: {
                        if (insurance.getChoiseOfDuesHI() == ChoiseOfDuesHIEnum.CODHIE_KEIN_BEITRAG) break;
                        zusatzbeitragssatz = this.getMarbZusatzbeitragKVdR(insurance, this.callib.berchnungWirksamAb(), suchdatum);
                        bgsKV = 10;
                        break;
                    }
                    default: {
                        zusatzbeitragssatz = this.getMarbZusatzbeitrag(insurance, this.callib.berchnungWirksamAb(), suchdatum);
                        bgsKV = insurance.getDuesGroupHI();
                    }
                }
                if (insurance.getDuesGroupNI() > 0) {
                    enterneigenschaft = insurance.getNIChildEducation();
                }
                if (zusatzbeitragssatzAlt != null) {
                    if (zusatzbeitragssatz.compareTo(zusatzbeitragssatzAlt) != 0) {
                        ausschluss = true;
                    }
                    if (enterneigenschaft != enterneigenschaftAlt) {
                        ausschluss = true;
                    }
                    if (bgsKV != bgsKVAlt) {
                        ausschluss = true;
                    }
                }
                zusatzbeitragssatzAlt = zusatzbeitragssatz;
                enterneigenschaftAlt = enterneigenschaft;
                bgsKVAlt = bgsKV;
            }
            suchdatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchdatum));
        }
        return ausschluss;
    }

    private FederalState marbBundesland(Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        Employment empl;
        FederalState federalState;
        block18: {
            federalState = null;
            empl = null;
            try {
                empl = this.eelib.marb().getEmployment(effectiveFrom, validFrom);
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block18;
                throw e;
            }
        }
        PlantPlace plantPlace = null;
        if (empl != null) {
            PlantPlaceTP plantPlaceTP;
            block19: {
                if (empl.getPlantPlace() != null) {
                    plantPlace = empl.getPlantPlace();
                }
                plantPlaceTP = null;
                if (plantPlace != null) {
                    try {
                        plantPlaceTP = plantPlace.getPlantPlaceTP(effectiveFrom, validFrom);
                    }
                    catch (BusinessDomainException e) {
                        if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block19;
                        throw e;
                    }
                }
            }
            if (plantPlaceTP != null && plantPlaceTP.getFederalState() != null) {
                federalState = plantPlaceTP.getFederalState();
            }
            if (federalState == null) {
                PlantFoundations plantFoundations;
                block20: {
                    plantFoundations = null;
                    Plant plant = empl.getPlant();
                    if (plant != null) {
                        try {
                            plantFoundations = plant.getPlantFoundations(effectiveFrom, validFrom);
                        }
                        catch (BusinessDomainException e) {
                            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block20;
                            throw e;
                        }
                    }
                }
                if (plantFoundations != null && plantFoundations.getFoundations().getFederalState() != null) {
                    federalState = plantFoundations.getFoundations().getFederalState();
                }
            }
        }
        if (federalState == null) {
            CompanyFoundations companyFoundations;
            block21: {
                companyFoundations = null;
                PCompany pCompany = this.eelib.marbFirma();
                if (pCompany != null) {
                    try {
                        companyFoundations = pCompany.getCompanyFoundations(effectiveFrom, validFrom);
                    }
                    catch (BusinessDomainException e) {
                        if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block21;
                        throw e;
                    }
                }
            }
            if (companyFoundations != null && companyFoundations.getFoundations().getFederalState() != null) {
                federalState = companyFoundations.getFoundations().getFederalState();
            }
        }
        return federalState;
    }

    private BigDecimal getMarbZusatzbeitrag(Insurance insurance, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        BigDecimal zusatzbeitrag = BigDecimal.ZERO;
        HealthFund healthFund = this.eelib.checkKrkFolgeOrganisation(insurance.getHealthFund(), effectiveFrom, validFrom);
        HealthFundTP healthFundTP = null;
        if (healthFund != null) {
            block4: {
                try {
                    healthFundTP = healthFund.getHealthFundTP(effectiveFrom, validFrom);
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block4;
                    throw e;
                }
            }
            if (healthFundTP != null && (zusatzbeitrag = healthFundTP.getAdditionalDues()) == null) {
                zusatzbeitrag = BigDecimal.ZERO;
            }
        }
        return zusatzbeitrag;
    }

    private BigDecimal getMarbZusatzbeitragKVdR(Insurance insurance, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        BigDecimal zusatzbeitrag = BigDecimal.ZERO;
        HealthFund healthFund = this.eelib.checkKrkFolgeOrganisation(insurance.getHealthFundKVdR(), effectiveFrom, validFrom);
        HealthFundTP healthFundTP = null;
        if (healthFund != null) {
            block5: {
                Date validFromKVdR = validFrom;
                if (DateHelper.afterOrEqual((Date)validFrom, (Date)new VDate(2015, 0, 1).getDate())) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(validFrom);
                    cal.add(2, -2);
                    validFromKVdR = cal.getTime();
                }
                try {
                    healthFundTP = healthFund.getHealthFundTP(effectiveFrom, validFromKVdR);
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block5;
                    throw e;
                }
            }
            if (healthFundTP != null && (zusatzbeitrag = healthFundTP.getAdditionalDues()) == null) {
                zusatzbeitrag = BigDecimal.ZERO;
            }
        }
        return zusatzbeitrag;
    }

    private boolean checkVortragVorhanden(Date suchdatum) throws BusinessDomainException {
        if (!this.mVortraegeGeladen) {
            this.mVortraegeArray = this.eelib.marb().getEECarriedForwardOfEntry();
            this.mVortraegeGeladen = true;
        }
        if (this.mVortraegeArray.length == 0) {
            this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, SECHS, BigDecimal.ZERO, BigDecimal.ZERO, true);
            return true;
        }
        boolean vortragVorhanden = false;
        for (EECarriedForwardOfEntry vortrag : this.mVortraegeArray) {
            if (!DateHelper.beforeOrEqual((Date)vortrag.getEmploymentFrom(), (Date)DateHelper.getLastDayOfMonth((Date)suchdatum)) || !DateHelper.afterOrEqual((Date)vortrag.getEmploymentUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)suchdatum))) continue;
            vortragVorhanden = true;
        }
        if (vortragVorhanden) {
            return false;
        }
        this.wplib.addNeueWertPosition(760010, BigDecimal.ZERO, BigDecimal.ZERO, SECHS, BigDecimal.ZERO, BigDecimal.ZERO, true);
        return true;
    }

    private EECarriedForwardOfEntry getVortrag(Date suchdatum) throws BusinessDomainException {
        EECarriedForwardOfEntry vortrag = null;
        if (!this.mVortraegeGeladen) {
            this.mVortraegeArray = this.eelib.marb().getEECarriedForwardOfEntry();
            this.mVortraegeGeladen = true;
        }
        if (this.mVortraegeArray.length > 0) {
            for (EECarriedForwardOfEntry cfOfEntry : this.mVortraegeArray) {
                if (!DateHelper.beforeOrEqual((Date)cfOfEntry.getEmploymentFrom(), (Date)DateHelper.getLastDayOfMonth((Date)suchdatum)) || !DateHelper.afterOrEqual((Date)cfOfEntry.getEmploymentUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)suchdatum))) continue;
                vortrag = cfOfEntry;
            }
        }
        return vortrag;
    }
}

