/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.attachment.EEAttachmentTP;
import com.varial.personnel.domain.employee.attachment.ModeOfAttachmentEnum;
import com.varial.personnel.domain.employee.attachment.mapper.ModeOfAttachmentEnumMapper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SteuerungPfaendungenMarbFormula {
    protected static Logger LOGGER = LoggerFactory.getLogger(SteuerungPfaendungenMarbFormula.class);
    private static final BigDecimal BD_25 = BigDecimal.valueOf(25L);
    protected static final BigDecimal BD_50 = BigDecimal.valueOf(50L);
    private static final BigDecimal BD_75 = BigDecimal.valueOf(75L);
    protected static final BigDecimal BD_100 = BigDecimal.valueOf(100L);
    private static final BigDecimal BD_250 = BigDecimal.valueOf(250L);
    private static final BigDecimal BD_500 = BigDecimal.valueOf(500L);
    protected final CalculationLibrary callib;
    protected final EmployeeLibrary eelib;
    protected final ValuePositionLibrary wplib;
    private final GlobalLibrary gllib;
    private BigDecimal monatlArbeitseinkommen = BigDecimal.ZERO;
    protected boolean wertpositionErzeugt = false;
    protected boolean fuerUnterhaltspfaendungErzeugt = false;
    protected boolean fuerPrivInsolvenzErzeugt = false;
    protected boolean fuerSachpfaendungErzeugt = false;
    protected boolean fuerVorpfaendungErzeugt = false;
    protected boolean fuerAbtretungErzeugt = false;
    private boolean monatlichesArbeitseinkommenErmittelt = false;
    private ValuePosition[] vpArray;

    public SteuerungPfaendungenMarbFormula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.callib = calculationLibrary;
        this.eelib = employeeLibrary;
        this.gllib = globalLibrary;
        this.wplib = valuePositionLibrary;
    }

    public void steuerung() throws BusinessDomainException {
        BigInteger tempBigI;
        BigDecimal tempBigD;
        if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) && (tempBigD = new BigDecimal(tempBigI = this.wplib.result().movePointRight(2).toBigInteger()).movePointLeft(2)).compareTo(this.wplib.result()) != 0) {
            this.gllib.erzeugeWiedervorlageBruchteileVonCent(this.wplib.genesisParent().getValueType().getValueTypeKey());
        }
        EEAttachmentTP[] atp = this.eelib.pfaendungenImMonat();
        this.callib.result(this.wplib.result());
        block7: for (int i = 0; i < atp.length; ++i) {
            switch (this.wplib.wertartenNummer()) {
                case 141000: {
                    this.erzeugeVollpfaendbar(atp[i].getModeOfAttachment());
                    continue block7;
                }
                case 141010: {
                    this.erzeugeMehrarbeit(atp[i].getModeOfAttachment());
                    continue block7;
                }
                case 141020: {
                    this.erzeugeWeihnachtsverguetung(atp[i].getModeOfAttachment());
                    continue block7;
                }
                case 141030: {
                    this.erzeugePfaendbarBeiUnterhalt(atp[i].getModeOfAttachment());
                    continue block7;
                }
                case 141040: {
                    this.erzeugeOhneZPO(atp[i].getModeOfAttachment());
                }
                default: {
                    LOGGER.debug("Neue Wertart f\u00fcr Pf\u00e4ndungsbrutto ??? {}", (Object)this.wplib.wertartenNummer());
                }
            }
        }
        if (!this.wertpositionErzeugt) {
            this.wplib.loescheWertPosition(this.wplib.wertPosition());
        }
    }

    protected void erzeugeVollpfaendbar(ModeOfAttachmentEnum lEnum) throws BusinessDomainException {
        switch (lEnum.value()) {
            case 3: {
                if (this.fuerUnterhaltspfaendungErzeugt) break;
                this.wplib.addNeueWertPosition(141100, BD_100, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                this.fuerUnterhaltspfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 4: {
                if (this.fuerPrivInsolvenzErzeugt || !DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate())) break;
                this.wplib.addNeueWertPosition(141150, BD_100, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                this.fuerPrivInsolvenzErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 2: {
                if (this.fuerSachpfaendungErzeugt) break;
                this.wplib.addNeueWertPosition(141200, BD_100, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                this.fuerSachpfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 1: {
                if (this.fuerVorpfaendungErzeugt) break;
                this.wplib.addNeueWertPosition(141400, BD_100, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                this.fuerVorpfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 0: {
                if (this.fuerAbtretungErzeugt) break;
                this.wplib.addNeueWertPosition(141300, BD_100, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                this.fuerAbtretungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            default: {
                LOGGER.debug("Neues Pf\u00e4ndungsEnum ? :[0} ", (Object)ModeOfAttachmentEnumMapper.toString((ModeOfAttachmentEnum)lEnum));
            }
        }
    }

    protected void erzeugeMehrarbeit(ModeOfAttachmentEnum lEnum) throws BusinessDomainException {
        switch (lEnum.value()) {
            case 3: {
                if (this.fuerUnterhaltspfaendungErzeugt) break;
                BigDecimal VHSatzPfaendbar = BD_75;
                BigDecimal Pfaendbar = this.wplib.result().multiply(VHSatzPfaendbar).divide(BD_100, 2, RoundingMode.DOWN);
                this.wplib.addNeueWertPosition(141110, VHSatzPfaendbar, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, Pfaendbar, false);
                this.fuerUnterhaltspfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 4: {
                if (this.fuerPrivInsolvenzErzeugt) break;
                BigDecimal VHSatzPfaendbar = BD_50;
                BigDecimal Pfaendbar = this.wplib.result().multiply(VHSatzPfaendbar).divide(BD_100, 2, RoundingMode.DOWN);
                this.wplib.addNeueWertPosition(141160, VHSatzPfaendbar, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, Pfaendbar, false);
                this.fuerPrivInsolvenzErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 2: {
                if (this.fuerSachpfaendungErzeugt) break;
                BigDecimal VHSatzPfaendbar = BD_50;
                BigDecimal Pfaendbar = this.wplib.result().multiply(VHSatzPfaendbar).divide(BD_100, 2, RoundingMode.DOWN);
                this.wplib.addNeueWertPosition(141210, VHSatzPfaendbar, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, Pfaendbar, false);
                this.fuerSachpfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 1: {
                if (this.fuerVorpfaendungErzeugt) break;
                BigDecimal VHSatzPfaendbar = BD_50;
                BigDecimal Pfaendbar = this.wplib.result().multiply(VHSatzPfaendbar).divide(BD_100, 2, RoundingMode.DOWN);
                this.wplib.addNeueWertPosition(141410, VHSatzPfaendbar, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, Pfaendbar, false);
                this.fuerVorpfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 0: {
                if (this.fuerAbtretungErzeugt) break;
                BigDecimal VHSatzPfaendbar = BD_50;
                BigDecimal Pfaendbar = this.wplib.result().multiply(VHSatzPfaendbar).divide(BD_100, 2, RoundingMode.DOWN);
                this.wplib.addNeueWertPosition(141310, VHSatzPfaendbar, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, Pfaendbar, false);
                this.fuerAbtretungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            default: {
                LOGGER.debug("Neues Pf\u00e4ndungsEnum ? : {}", (Object)ModeOfAttachmentEnumMapper.toString((ModeOfAttachmentEnum)lEnum));
            }
        }
    }

    protected void erzeugeWeihnachtsverguetung(ModeOfAttachmentEnum lEnum) throws BusinessDomainException {
        BigDecimal PfandfreiWeihnachtsgeld;
        if (!this.monatlichesArbeitseinkommenErmittelt) {
            ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), new ValueType[]{ValueType.getValueType((int)110510)});
            for (int i = 0; i < vpArray.length; ++i) {
                this.monatlArbeitseinkommen = this.monatlArbeitseinkommen.add(vpArray[i].getResult());
            }
            this.monatlichesArbeitseinkommenErmittelt = true;
        }
        if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2022, 0, 1).getDate())) {
            PfandfreiWeihnachtsgeld = this.gllib.pfandfreierBetragSchuldner();
            PfandfreiWeihnachtsgeld = PfandfreiWeihnachtsgeld.add(BigDecimal.valueOf(9.99));
            PfandfreiWeihnachtsgeld = PfandfreiWeihnachtsgeld.divide(BigDecimal.valueOf(10L), 0, RoundingMode.DOWN).multiply(BigDecimal.valueOf(10L));
            PfandfreiWeihnachtsgeld = PfandfreiWeihnachtsgeld.divide(BigDecimal.valueOf(2L));
        } else {
            PfandfreiWeihnachtsgeld = BD_500;
        }
        switch (lEnum.value()) {
            case 3: {
                if (this.fuerUnterhaltspfaendungErzeugt) break;
                BigDecimal Pfandfrei = this.monatlArbeitseinkommen.multiply(BD_25).divide(BD_100, 2, RoundingMode.DOWN);
                if (Pfandfrei.compareTo(BD_250) > 0) {
                    Pfandfrei = BD_250;
                }
                if (Pfandfrei.compareTo(this.wplib.result()) > 0) {
                    Pfandfrei = this.wplib.result();
                }
                for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), DateHelper.getLastDayOfMonth((Date)this.wplib.wirksamAb()), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(141120))) {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getFactor2())) continue;
                    Pfandfrei = Pfandfrei.subtract(vPos.getFactor2());
                }
                if (Pfandfrei.compareTo(BigDecimal.ZERO) < 0) {
                    Pfandfrei = BigDecimal.ZERO;
                }
                BigDecimal Pfaendbar = this.wplib.result().subtract(Pfandfrei);
                this.wplib.addNeueWertPosition(141120, BigDecimal.ZERO, BigDecimal.ZERO, this.monatlArbeitseinkommen, Pfandfrei, Pfaendbar, false);
                this.fuerUnterhaltspfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 4: {
                if (this.fuerPrivInsolvenzErzeugt) break;
                BigDecimal Pfandfrei = this.monatlArbeitseinkommen.multiply(BD_50).divide(BD_100, 2, RoundingMode.DOWN);
                if (Pfandfrei.compareTo(PfandfreiWeihnachtsgeld) > 0) {
                    Pfandfrei = PfandfreiWeihnachtsgeld;
                }
                if (Pfandfrei.compareTo(this.wplib.result()) > 0) {
                    Pfandfrei = this.wplib.result();
                }
                for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), DateHelper.getLastDayOfMonth((Date)this.wplib.wirksamAb()), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(141170))) {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getFactor2())) continue;
                    Pfandfrei = Pfandfrei.subtract(vPos.getFactor2());
                }
                if (Pfandfrei.compareTo(BigDecimal.ZERO) < 0) {
                    Pfandfrei = BigDecimal.ZERO;
                }
                BigDecimal Pfaendbar = this.wplib.result().subtract(Pfandfrei);
                this.wplib.addNeueWertPosition(141170, BigDecimal.ZERO, BigDecimal.ZERO, this.monatlArbeitseinkommen, Pfandfrei, Pfaendbar, false);
                this.fuerPrivInsolvenzErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 2: {
                if (this.fuerSachpfaendungErzeugt) break;
                BigDecimal Pfandfrei = this.monatlArbeitseinkommen.multiply(BD_50).divide(BD_100, 2, RoundingMode.DOWN);
                if (Pfandfrei.compareTo(PfandfreiWeihnachtsgeld) > 0) {
                    Pfandfrei = PfandfreiWeihnachtsgeld;
                }
                if (Pfandfrei.compareTo(this.wplib.result()) > 0) {
                    Pfandfrei = this.wplib.result();
                }
                for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), DateHelper.getLastDayOfMonth((Date)this.wplib.wirksamAb()), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(141220))) {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getFactor2())) continue;
                    Pfandfrei = Pfandfrei.subtract(vPos.getFactor2());
                }
                if (Pfandfrei.compareTo(BigDecimal.ZERO) < 0) {
                    Pfandfrei = BigDecimal.ZERO;
                }
                BigDecimal Pfaendbar = this.wplib.result().subtract(Pfandfrei);
                this.wplib.addNeueWertPosition(141220, BigDecimal.ZERO, BigDecimal.ZERO, this.monatlArbeitseinkommen, Pfandfrei, Pfaendbar, false);
                this.fuerSachpfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 1: {
                if (this.fuerVorpfaendungErzeugt) break;
                BigDecimal Pfandfrei = this.monatlArbeitseinkommen.multiply(BD_50).divide(BD_100, 2, RoundingMode.DOWN);
                if (Pfandfrei.compareTo(PfandfreiWeihnachtsgeld) > 0) {
                    Pfandfrei = PfandfreiWeihnachtsgeld;
                }
                if (Pfandfrei.compareTo(this.wplib.result()) > 0) {
                    Pfandfrei = this.wplib.result();
                }
                for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), DateHelper.getLastDayOfMonth((Date)this.wplib.wirksamAb()), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(141420))) {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getFactor2())) continue;
                    Pfandfrei = Pfandfrei.subtract(vPos.getFactor2());
                }
                if (Pfandfrei.compareTo(BigDecimal.ZERO) < 0) {
                    Pfandfrei = BigDecimal.ZERO;
                }
                BigDecimal Pfaendbar = this.wplib.result().subtract(Pfandfrei);
                this.wplib.addNeueWertPosition(141420, BigDecimal.ZERO, BigDecimal.ZERO, this.monatlArbeitseinkommen, Pfandfrei, Pfaendbar, false);
                this.fuerVorpfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 0: {
                BigDecimal Pfandfrei;
                if (!this.fuerAbtretungErzeugt) {
                    Pfandfrei = this.monatlArbeitseinkommen.multiply(BD_50).divide(BD_100, 2, RoundingMode.DOWN);
                    if (Pfandfrei.compareTo(PfandfreiWeihnachtsgeld) > 0) {
                        Pfandfrei = PfandfreiWeihnachtsgeld;
                    }
                    if (Pfandfrei.compareTo(this.wplib.result()) > 0) {
                        Pfandfrei = this.wplib.result();
                    }
                    for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), DateHelper.getLastDayOfMonth((Date)this.wplib.wirksamAb()), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(141320))) {
                        if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getFactor2())) continue;
                        Pfandfrei = Pfandfrei.subtract(vPos.getFactor2());
                    }
                    if (Pfandfrei.compareTo(BigDecimal.ZERO) < 0) {
                        Pfandfrei = BigDecimal.ZERO;
                    }
                    BigDecimal Pfaendbar = this.wplib.result().subtract(Pfandfrei);
                    this.wplib.addNeueWertPosition(141320, BigDecimal.ZERO, BigDecimal.ZERO, this.monatlArbeitseinkommen, Pfandfrei, Pfaendbar, false);
                    this.fuerAbtretungErzeugt = true;
                    this.wertpositionErzeugt = true;
                }
            }
            default: {
                LOGGER.debug("Neues Pf\u00e4ndungsEnum ? : {}", (Object)ModeOfAttachmentEnumMapper.toString((ModeOfAttachmentEnum)lEnum));
            }
        }
    }

    protected void erzeugeOhneZPO(ModeOfAttachmentEnum pEnum) throws BusinessDomainException {
        switch (pEnum.value()) {
            case 3: {
                if (this.fuerUnterhaltspfaendungErzeugt) break;
                this.wplib.addNeueWertPosition(141140, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                this.fuerUnterhaltspfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 2: {
                if (this.fuerSachpfaendungErzeugt) break;
                this.wplib.addNeueWertPosition(141230, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                this.fuerSachpfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 1: {
                if (this.fuerVorpfaendungErzeugt) break;
                this.wplib.addNeueWertPosition(141430, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                this.fuerVorpfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 0: {
                if (this.fuerAbtretungErzeugt) break;
                this.wplib.addNeueWertPosition(141330, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                this.fuerAbtretungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 4: {
                if (this.fuerPrivInsolvenzErzeugt) break;
                this.wplib.addNeueWertPosition(141180, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false);
                this.fuerPrivInsolvenzErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            default: {
                LOGGER.debug("Neues Pf\u00e4ndungsEnum ? : {}", (Object)ModeOfAttachmentEnumMapper.toString((ModeOfAttachmentEnum)pEnum));
            }
        }
    }

    protected void erzeugePfaendbarBeiUnterhalt(ModeOfAttachmentEnum lEnum) throws BusinessDomainException {
        switch (lEnum.value()) {
            case 3: {
                if (this.fuerUnterhaltspfaendungErzeugt) break;
                BigDecimal VHSatzPfaendbar = BD_50;
                BigDecimal Pfaendbar = this.wplib.result().multiply(VHSatzPfaendbar).divide(BD_100, 2, RoundingMode.DOWN);
                this.wplib.addNeueWertPosition(141130, VHSatzPfaendbar, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, Pfaendbar, false);
                this.fuerUnterhaltspfaendungErzeugt = true;
                this.wertpositionErzeugt = true;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                LOGGER.debug("Neues Pf\u00e4ndungsEnum ? : {}", (Object)ModeOfAttachmentEnumMapper.toString((ModeOfAttachmentEnum)lEnum));
            }
        }
    }
}

