/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.libraryimpl.CalculationCheckImpl;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.framework.basictypes.Interval;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class SteuerungMarbUmlageFormula {
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final ValuePositionLibrary mVpLib;
    private final GlobalLibrary mGlLib;

    public SteuerungMarbUmlageFormula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.mCalLib = calculationLibrary;
        this.mEeLib = employeeLibrary;
        this.mGlLib = globalLibrary;
        this.mVpLib = valuePositionLibrary;
    }

    public void steuerung() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2006, 0, 1).getDate())) {
            this.steuereWertartennummer();
        } else if (this.mGlLib.umlagepflichtFirma()) {
            this.steuereWertartennummer();
        } else {
            this.mVpLib.wertPosition().makeReadOnly();
        }
    }

    private void steuereWertartennummer() throws BusinessDomainException {
        if (this.mEeLib.marbUmlagePflichtig().value() != 0) {
            block0 : switch (this.mVpLib.wertartenNummer()) {
                case 135200: {
                    this.steuerungUmlageAbfuehrung();
                    break;
                }
                case 135250: {
                    this.steuerungUmlageFiktivAbfuehrung();
                    break;
                }
                case 135300: {
                    this.steuerungUmlageAbfuehrungEGA();
                    break;
                }
                case 135400: {
                    this.steuerungUmlageAbfuehrungEgaAusLfd();
                    break;
                }
                case 371150: 
                case 371160: {
                    switch (this.mEeLib.marbUmlagePflichtig().value()) {
                        case 1: 
                        case 2: {
                            if (!this.mGlLib.umlagepflichtFirma()) break;
                            this.steuerungU1ErstattungNeu();
                            break block0;
                        }
                    }
                    this.mVpLib.wertPosition().makeReadOnly();
                    this.mCalLib.result(BigDecimal.ZERO);
                    break;
                }
                case 371210: 
                case 371215: 
                case 371220: 
                case 371225: {
                    if (this.mVpLib.parent().getValueType().getValueTypeKey() < 100000) {
                        this.steuerungU1Erstattung();
                        break;
                    }
                    this.mCalLib.result(this.mVpLib.result());
                    break;
                }
                case 372150: 
                case 372160: {
                    switch (this.mEeLib.marbUmlagePflichtig().value()) {
                        case 2: 
                        case 3: {
                            this.steuerungU2ErstattungNeu();
                            break block0;
                        }
                    }
                    this.mVpLib.wertPosition().makeReadOnly();
                    this.mCalLib.result(BigDecimal.ZERO);
                    break;
                }
                case 372210: 
                case 372220: 
                case 372225: {
                    if (this.mVpLib.parent().getValueType().getValueTypeKey() < 100000) {
                        this.steuerungU2Erstattung();
                        break;
                    }
                    this.mCalLib.result(this.mVpLib.result());
                    break;
                }
                case 373210: {
                    this.steuerungU3Erstattung();
                    break;
                }
                default: {
                    throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException(SteuerungMarbUmlageFormula.class.getName(), this.mVpLib.wertartenNummer());
                }
            }
        }
    }

    private void steuerungU1ErstattungNeu() throws BusinessDomainException {
        this.mCalLib.result(this.mVpLib.result());
        EEAbsentTimeTP[] lEeAbsentTimeArray = this.mEeLib.fehlzeitenBerechnungsZeitraum();
        boolean keineFehlzeit = true;
        boolean nochKeinKerzeugt = true;
        boolean nochKeinUerzeugt = true;
        boolean nochKeinSerzeugt = true;
        block11: for (EEAbsentTimeTP lEeAbsentTimeTP : lEeAbsentTimeArray) {
            switch (lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey()) {
                case "10.3": 
                case "10.31": {
                    keineFehlzeit = false;
                    if (!nochKeinKerzeugt) continue block11;
                    this.mVpLib.addNeueWertPosition(371210, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result(), false, (PersistentObject)this.mVpLib.parent());
                    this.checkAGZuwendungen(371160, 371215, BigDecimal.ZERO, BigDecimal.ZERO);
                    nochKeinKerzeugt = false;
                    continue block11;
                }
                case "10.32": {
                    keineFehlzeit = false;
                    if (!nochKeinUerzeugt) continue block11;
                    this.mVpLib.addNeueWertPosition(371220, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result(), false, (PersistentObject)this.mVpLib.parent());
                    this.checkAGZuwendungen(371160, 371225, BigDecimal.ZERO, BigDecimal.ZERO);
                    nochKeinUerzeugt = false;
                    continue block11;
                }
                case "10.33": {
                    keineFehlzeit = false;
                    if (!nochKeinSerzeugt) continue block11;
                    this.mVpLib.addNeueWertPosition(371230, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result(), false, (PersistentObject)this.mVpLib.parent());
                    this.checkAGZuwendungen(371160, 371235, BigDecimal.ZERO, BigDecimal.ZERO);
                    nochKeinSerzeugt = false;
                }
            }
        }
        if (keineFehlzeit) {
            this.mVpLib.wertPosition().makeReadOnly();
        }
    }

    private void steuerungU2ErstattungNeu() throws BusinessDomainException {
        this.mCalLib.result(this.mVpLib.result());
        EEAbsentTimeTP[] lEeAbsentTimeArray = this.mEeLib.fehlzeitenBerechnungsZeitraum();
        boolean keineFehlzeit = true;
        boolean nochKeinMerzeugt = true;
        boolean nochKeinBTGerzeugt = true;
        boolean nochKeinBGTerzeugt = true;
        boolean nochKeinBTIerzeugt = true;
        boolean nochKeinBITerzeugt = true;
        block14: for (EEAbsentTimeTP lEeAbsentTimeTP : lEeAbsentTimeArray) {
            String absentTimeKey;
            switch (absentTimeKey = lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey()) {
                case "4.5": {
                    if (!StringMapper.equal((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"4.5") || !StringMapper.equal((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getAbsentTimeKey(), (String)"M")) continue block14;
                    keineFehlzeit = false;
                    if (!nochKeinMerzeugt) continue block14;
                    this.mVpLib.addNeueWertPosition(372210, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result(), false, (PersistentObject)this.mVpLib.parent());
                    nochKeinMerzeugt = false;
                    continue block14;
                }
                case "10.41": {
                    keineFehlzeit = false;
                    if (!nochKeinBTGerzeugt) continue block14;
                    this.erzeugeVPfuerG(BigDecimalMapper.toBigDecimal((String)absentTimeKey), lEeAbsentTimeTP.getNumberOfWorkingHours());
                    nochKeinBTGerzeugt = false;
                    continue block14;
                }
                case "10.43": {
                    keineFehlzeit = false;
                    if (!nochKeinBGTerzeugt) continue block14;
                    this.erzeugeVPfuerG(BigDecimalMapper.toBigDecimal((String)absentTimeKey), lEeAbsentTimeTP.getNumberOfWorkingHours());
                    nochKeinBGTerzeugt = false;
                    continue block14;
                }
                case "10.42": {
                    keineFehlzeit = false;
                    if (!nochKeinBTIerzeugt) continue block14;
                    this.erzeugeVPfuerI(BigDecimalMapper.toBigDecimal((String)absentTimeKey), lEeAbsentTimeTP.getNumberOfWorkingHours());
                    nochKeinBTIerzeugt = false;
                    continue block14;
                }
                case "10.44": {
                    keineFehlzeit = false;
                    if (!nochKeinBITerzeugt) continue block14;
                    this.erzeugeVPfuerI(BigDecimalMapper.toBigDecimal((String)absentTimeKey), lEeAbsentTimeTP.getNumberOfWorkingHours());
                    nochKeinBITerzeugt = false;
                }
            }
        }
        if (keineFehlzeit) {
            this.mVpLib.wertPosition().makeReadOnly();
        }
    }

    private void erzeugeVPfuerI(BigDecimal fehlzeitenschluessel, BigDecimal anzahlstunden) throws BusinessDomainException {
        this.addNeueWertPosition(372230, this.mVpLib.result(), fehlzeitenschluessel, anzahlstunden);
        this.checkAGZuwendungen(372160, 372235, fehlzeitenschluessel, anzahlstunden);
    }

    private void erzeugeVPfuerG(BigDecimal fehlzeitenschluessel, BigDecimal anzahlstunden) throws BusinessDomainException {
        this.addNeueWertPosition(372220, this.mVpLib.result(), fehlzeitenschluessel, anzahlstunden);
        this.checkAGZuwendungen(372160, 372225, fehlzeitenschluessel, anzahlstunden);
    }

    private void addNeueWertPosition(int valueTypeNumber, BigDecimal result, BigDecimal fehlzeitenschluessel, BigDecimal anzahlstunden) throws BusinessDomainException {
        ValuePosition vp = new ValuePosition(this.mEeLib.marb(), ValueType.getValueType((int)valueTypeNumber), null, null);
        vp.setEffectiveFrom(this.mVpLib.wirksamAb());
        vp.setEffectiveUntil(this.mVpLib.wirksamBis());
        vp.setValidFrom(this.mVpLib.gueltigAb());
        vp.setValidUntil(this.mVpLib.gueltigBis());
        vp.setFactor1(BigDecimal.ZERO);
        vp.setFactor2(BigDecimal.ZERO);
        vp.setResult(result);
        vp.setPersistentBuffer1(fehlzeitenschluessel);
        vp.setPersistentBuffer2(anzahlstunden);
        vp.setParentObject((PersistentObject)this.mVpLib.wertPosition());
        vp.setGenesisOfParentObjects((PersistentObject)this.mVpLib.genesisParent());
        this.mCalLib.getCalculationCase().getValuePositionHistory().addItem(vp);
    }

    private void steuerungUmlageAbfuehrung() throws BusinessDomainException {
        switch (this.mEeLib.marbUmlagePflichtig().value()) {
            case 0: {
                this.mVpLib.wertPosition().makeReadOnly();
                break;
            }
            default: {
                this.mCalLib.result(this.mVpLib.result());
                boolean gleitzoneZieht = false;
                if (this.mEeLib.isMarbGleitzoneAllgemein() && !this.mEeLib.marbVerzichtRvReduzierung() && !this.mEeLib.kennzBestandGleitzone2022()) {
                    CalculationCheckImpl cci = new CalculationCheckImpl(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib);
                    gleitzoneZieht = cci.checkGleitzoneRV();
                }
                if (gleitzoneZieht) {
                    this.mVpLib.addNeueWertPosition(360300, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result(), true);
                    break;
                }
                this.mVpLib.addNeueWertPosition(360100, this.mVpLib.result());
            }
        }
    }

    private void steuerungUmlageFiktivAbfuehrung() throws BusinessDomainException {
        switch (this.mEeLib.marbUmlagePflichtig().value()) {
            case 0: {
                this.mVpLib.wertPosition().makeReadOnly();
                break;
            }
            default: {
                this.mCalLib.result(this.mVpLib.result());
                this.mVpLib.addNeueWertPosition(360150, this.mVpLib.result());
            }
        }
    }

    private void steuerungUmlageAbfuehrungEGA() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2006, 0, 1).getDate())) {
            this.mVpLib.loescheWertPosition(this.mVpLib.wertPosition());
            return;
        }
        new CalculationBasic(this.mEeLib.marb(), this.mVpLib.wirksamAb(), new VDate(2006, 0, 1).getDate(), this.getClass().getName());
        if (this.mEeLib.marbUmlagePflichtig().value() != 0) {
            this.mCalLib.result(this.mVpLib.result());
            boolean gleitzoneZieht = false;
            if (this.mEeLib.isMarbGleitzoneAllgemein() && !this.mEeLib.marbVerzichtRvReduzierung() && !this.mEeLib.kennzBestandGleitzone2022()) {
                CalculationCheckImpl cci = new CalculationCheckImpl(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib);
                gleitzoneZieht = cci.checkGleitzoneRV();
            }
            if (gleitzoneZieht) {
                this.mVpLib.addNeueWertPosition(360300, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result(), true);
            } else {
                this.mVpLib.addNeueWertPosition(360200, this.mVpLib.result());
            }
        } else {
            this.mVpLib.wertPosition().makeReadOnly();
        }
    }

    private void steuerungUmlageAbfuehrungEgaAusLfd() throws BusinessDomainException {
        if (this.mEeLib.marbUmlagePflichtig().value() != 0) {
            this.mCalLib.result(this.mVpLib.result());
            boolean gleitzoneZieht = false;
            if (this.mEeLib.isMarbGleitzoneAllgemein() && !this.mEeLib.marbVerzichtRvReduzierung() && !this.mEeLib.kennzBestandGleitzone2022()) {
                CalculationCheckImpl cci = new CalculationCheckImpl(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib);
                gleitzoneZieht = cci.checkGleitzoneRV();
            }
            if (gleitzoneZieht) {
                this.mVpLib.addNeueWertPosition(360300, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result(), true);
            } else {
                this.mVpLib.addNeueWertPosition(360200, this.mVpLib.result());
            }
        } else {
            this.mVpLib.wertPosition().makeReadOnly();
        }
    }

    private void steuerungU1Erstattung() throws BusinessDomainException {
        this.mCalLib.result(this.mVpLib.result());
        block0 : switch (this.mEeLib.marbUmlagePflichtig().value()) {
            case 1: 
            case 2: {
                switch (this.mVpLib.wertartenNummer()) {
                    case 371210: {
                        this.mVpLib.addNeueWertPosition(371610, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result(), false);
                        break block0;
                    }
                }
                this.mVpLib.addNeueWertPosition(371620, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result(), false);
                break;
            }
            default: {
                this.mVpLib.wertPosition().makeReadOnly();
                this.mCalLib.result(BigDecimal.ZERO);
                return;
            }
        }
    }

    private void steuerungU2Erstattung() throws BusinessDomainException {
        this.mCalLib.result(this.mVpLib.result());
        switch (this.mEeLib.marbUmlagePflichtig().value()) {
            case 2: 
            case 3: {
                this.mVpLib.addNeueWertPosition(372610, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result(), false);
                break;
            }
            default: {
                this.mVpLib.wertPosition().makeReadOnly();
                this.mCalLib.result(BigDecimal.ZERO);
                return;
            }
        }
    }

    private void steuerungU3Erstattung() {
    }

    private void checkAGZuwendungen(int vtAgEntgeltZuwendung, int vtErstattungZuwendung, BigDecimal fehlzeitenschluessel, BigDecimal anzahlstunden) throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2016, 0, 1).getDate())) {
            ValuePosition[] vpArray;
            BigDecimal agZuwendungen = BigDecimal.ZERO;
            BigDecimal beitragspflichtig = BigDecimal.ZERO;
            for (ValuePosition vPos : vpArray = this.mVpLib.genesisUndFolgen()) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 100911: 
                    case 100931: 
                    case 100951: 
                    case 100961: 
                    case 100971: {
                        agZuwendungen = agZuwendungen.add(vPos.getResult());
                        beitragspflichtig = beitragspflichtig.add(vPos.getPersistentBuffer5());
                    }
                }
            }
            if (!this.isValuePositionExist(vtErstattungZuwendung, fehlzeitenschluessel)) {
                for (ValuePosition vPos : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), this.mVpLib.gueltigAb(), this.mVpLib.gueltigBis(), this.getVBLU_BAV_ValueTypes())) {
                    BigDecimal result = this.getMonatsbetrag(vPos);
                    agZuwendungen = agZuwendungen.add(result);
                    if (BigDecimalMapper.compareTo((BigDecimal)result, (BigDecimal)vPos.getResult()) != 0) continue;
                    beitragspflichtig = beitragspflichtig.add(vPos.getPersistentBuffer5());
                }
                agZuwendungen = agZuwendungen.add(this.getBetragAusAbweichendenZahlungsintervall());
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)agZuwendungen)) {
                if (!this.isValuePositionExist(vtAgEntgeltZuwendung)) {
                    ValuePosition vpAGEntgeltZuwendung = new ValuePosition(this.mEeLib.marb(), ValueType.getValueType((int)vtAgEntgeltZuwendung), null, null);
                    vpAGEntgeltZuwendung.setEffectiveFrom(this.mVpLib.wirksamAb());
                    vpAGEntgeltZuwendung.setEffectiveUntil(this.mVpLib.wirksamBis());
                    vpAGEntgeltZuwendung.setValidFrom(this.mVpLib.gueltigAb());
                    vpAGEntgeltZuwendung.setValidUntil(this.mVpLib.gueltigBis());
                    vpAGEntgeltZuwendung.setFactor1(BigDecimal.ZERO);
                    vpAGEntgeltZuwendung.setFactor2(BigDecimal.ZERO);
                    vpAGEntgeltZuwendung.setResult(agZuwendungen);
                    vpAGEntgeltZuwendung.setPersistentBuffer1(fehlzeitenschluessel);
                    vpAGEntgeltZuwendung.setPersistentBuffer2(anzahlstunden);
                    vpAGEntgeltZuwendung.setParentObject((PersistentObject)this.mVpLib.parent());
                    vpAGEntgeltZuwendung.setGenesisOfParentObjects((PersistentObject)this.mVpLib.genesisParent());
                    this.mCalLib.getCalculationCase().getValuePositionHistory().addItem(vpAGEntgeltZuwendung);
                }
                ValuePosition vpAGErstattungZuwendung = new ValuePosition(this.mEeLib.marb(), ValueType.getValueType((int)vtErstattungZuwendung), null, null);
                vpAGErstattungZuwendung.setEffectiveFrom(this.mVpLib.wirksamAb());
                vpAGErstattungZuwendung.setEffectiveUntil(this.mVpLib.wirksamBis());
                vpAGErstattungZuwendung.setValidFrom(this.mVpLib.gueltigAb());
                vpAGErstattungZuwendung.setValidUntil(this.mVpLib.gueltigBis());
                vpAGErstattungZuwendung.setFactor1(BigDecimal.ZERO);
                vpAGErstattungZuwendung.setFactor2(BigDecimal.ZERO);
                vpAGErstattungZuwendung.setResult(agZuwendungen);
                vpAGErstattungZuwendung.setPersistentBuffer1(fehlzeitenschluessel);
                vpAGErstattungZuwendung.setPersistentBuffer2(anzahlstunden);
                vpAGErstattungZuwendung.setPersistentBuffer5(beitragspflichtig);
                vpAGErstattungZuwendung.setParentObject((PersistentObject)this.mVpLib.wertPosition());
                vpAGErstattungZuwendung.setGenesisOfParentObjects((PersistentObject)this.mVpLib.genesisParent());
                this.mCalLib.getCalculationCase().getValuePositionHistory().addItem(vpAGErstattungZuwendung);
            }
        }
    }

    private BigDecimal getBetragAusAbweichendenZahlungsintervall() throws BusinessDomainException {
        EEPensionSchemeTP[] eePensionSchemeTPs;
        BigDecimal result = BigDecimal.ZERO;
        for (EEPensionSchemeTP eePensionSchemeTP : eePensionSchemeTPs = this.mEeLib.marb().getEffectivePensionSchemes(this.mVpLib.wirksamAb(), this.mVpLib.gueltigAb())) {
            Interval interval;
            Date austrittsDatumBAV;
            Date eintrittsDatumBAV = eePensionSchemeTP.getDateOfEntry() != null ? eePensionSchemeTP.getDateOfEntry() : VDate.getDateMin();
            Date date = austrittsDatumBAV = eePensionSchemeTP.getDateOfWithDrawal() != null ? eePensionSchemeTP.getDateOfWithDrawal() : VDate.getDateMax();
            if (!DateHelper.beforeOrEqual((Date)eintrittsDatumBAV, (Date)DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb())) || !DateHelper.afterOrEqual((Date)austrittsDatumBAV, (Date)DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb())) || (interval = eePensionSchemeTP.getERExpensesPays()).isWholeYearValid() || this.zahlungBAVImAktuellenMonat(interval)) continue;
            int monate = this.getAnzahlMonateBAV(interval);
            BigDecimal jahresbetrag = eePensionSchemeTP.getDuesERpaysAsCtPay().multiply(BigDecimal.valueOf(monate));
            BigDecimal monatbetrag = jahresbetrag.divide(BigDecimal.valueOf(12L), 2, RoundingMode.HALF_UP);
            result = result.add(monatbetrag);
        }
        return result;
    }

    private boolean isValuePositionExist(int vt, BigDecimal fehlzeitenschluessel) throws BusinessDomainException {
        boolean exist;
        block3: {
            exist = false;
            try {
                ValuePosition[] vpArray;
                for (ValuePosition vp : vpArray = this.mCalLib.getCalculationCase().getValuePositionHistory().getItems(DateHelper.getFirstDayOfMonth((Date)this.mVpLib.wirksamAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.wirksamAb()), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()))) {
                    if (vt != vp.getValueType().getValueTypeKey() || BigDecimalMapper.compareTo((BigDecimal)vp.getPersistentBuffer1(), (BigDecimal)fehlzeitenschluessel) != 0) continue;
                    exist = true;
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block3;
                throw e;
            }
        }
        return exist;
    }

    private boolean isValuePositionExist(int vt) throws BusinessDomainException {
        boolean exist;
        block3: {
            exist = false;
            try {
                ValuePosition vp = this.mVpLib.folgeWertartVomGenesis(vt);
                if (vp != null) {
                    exist = true;
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block3;
                throw e;
            }
        }
        return exist;
    }

    private ValueType[] getVBLU_BAV_ValueTypes() {
        return ValueTypeHelper.getValueTypes(106210, 106230, 145110, 145160, 145210, 145215, 145260, 145310, 145360);
    }

    private BigDecimal getMonatsbetrag(ValuePosition vPos) {
        BigDecimal monatbetrag = vPos.getResult();
        switch (vPos.getValueType().getValueTypeKey()) {
            case 145110: 
            case 145160: 
            case 145210: 
            case 145215: 
            case 145260: 
            case 145310: 
            case 145360: {
                EEPensionSchemeTP eePensionSchemeTP;
                Interval interval;
                ValuePosition rootVp = (ValuePosition)vPos.getGenesisOfParentObjects();
                PersistentObject rootTP = rootVp.getGenesisOfParentObjects();
                if (!(rootTP instanceof EEPensionSchemeTP) || (interval = (eePensionSchemeTP = (EEPensionSchemeTP)rootVp.getGenesisOfParentObjects()).getERExpensesPays()).isWholeYearValid()) break;
                int monate = this.getAnzahlMonateBAV(interval);
                BigDecimal jahresbetrag = eePensionSchemeTP.getDuesERpaysAsCtPay().multiply(BigDecimal.valueOf(monate));
                monatbetrag = jahresbetrag.divide(BigDecimal.valueOf(12L), 2, RoundingMode.HALF_UP);
            }
        }
        return monatbetrag;
    }

    private int getAnzahlMonateBAV(Interval interval) {
        int monate = 0;
        if (interval.getJanuary()) {
            ++monate;
        }
        if (interval.getFebruary()) {
            ++monate;
        }
        if (interval.getMarch()) {
            ++monate;
        }
        if (interval.getApril()) {
            ++monate;
        }
        if (interval.getMay()) {
            ++monate;
        }
        if (interval.getJune()) {
            ++monate;
        }
        if (interval.getJuly()) {
            ++monate;
        }
        if (interval.getAugust()) {
            ++monate;
        }
        if (interval.getSeptember()) {
            ++monate;
        }
        if (interval.getOctober()) {
            ++monate;
        }
        if (interval.getNovember()) {
            ++monate;
        }
        if (interval.getDecember()) {
            ++monate;
        }
        return monate;
    }

    private boolean zahlungBAVImAktuellenMonat(Interval interval) throws BusinessDomainException {
        switch (DateHelper.getMonth((Date)this.mVpLib.gueltigAb())) {
            case 0: {
                return interval.getJanuary();
            }
            case 1: {
                return interval.getFebruary();
            }
            case 2: {
                return interval.getMarch();
            }
            case 3: {
                return interval.getApril();
            }
            case 4: {
                return interval.getMay();
            }
            case 5: {
                return interval.getJune();
            }
            case 6: {
                return interval.getJuly();
            }
            case 7: {
                return interval.getAugust();
            }
            case 8: {
                return interval.getSeptember();
            }
            case 9: {
                return interval.getOctober();
            }
            case 10: {
                return interval.getNovember();
            }
            case 11: {
                return interval.getDecember();
            }
        }
        return false;
    }
}

