/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ICalculationCheck;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.library.ValueTypeLibrary;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Date;

public class SteuerungMarbKammerbeitragFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final ValuePositionLibrary wplib;
    private final ValueTypeLibrary walib;
    private final GlobalLibrary gllib;
    private final ICalculationCheck cclib;
    private BigDecimal mFiktivesEntgelt = BigDecimal.ZERO;
    private BigDecimal mEntgeltLfdAbwAG = BigDecimal.ZERO;
    private BigDecimal mEntgeltEGAAbwAG = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltLfd = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltEGA = BigDecimal.ZERO;
    private BigDecimal mF = BigDecimal.ZERO;
    private BigDecimal mGU = BigDecimal.ZERO;
    private BigDecimal mGO = BigDecimal.ZERO;
    private BigDecimal mZwSVEntgelt = BigDecimal.ZERO;
    private BigDecimal mZwRVBBG = BigDecimal.ZERO;

    public SteuerungMarbKammerbeitragFormula(CalculationLibrary calLib, EmployeeLibrary eeLib, GlobalLibrary glLib, ValuePositionLibrary wpLib, ValueTypeLibrary waLib, ICalculationCheck ccLib) {
        this.callib = calLib;
        this.eelib = eeLib;
        this.gllib = glLib;
        this.wplib = wpLib;
        this.walib = waLib;
        this.cclib = ccLib;
    }

    public void steuerung() throws BusinessDomainException {
        BigInteger tempBigI;
        BigDecimal tempBigD;
        if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) && (tempBigD = new BigDecimal(tempBigI = this.wplib.result().movePointRight(2).toBigInteger()).movePointLeft(2)).compareTo(this.wplib.result()) != 0) {
            this.gllib.erzeugeWiedervorlageBruchteileVonCent(this.wplib.genesisParent().getValueType().getValueTypeKey());
        }
        if (this.eelib.isMarbKammerBeitragsPflichtig()) {
            switch (this.gllib.bundeslandSchluesselBeschaeftigungsort()) {
                case 4: {
                    this.steuerungBremen();
                    break;
                }
                case 10: {
                    this.steuerungSaarland();
                    break;
                }
                default: {
                    this.wplib.wertPosition().makeReadOnly();
                    break;
                }
            }
        } else {
            this.wplib.wertPosition().makeReadOnly();
        }
    }

    private BigDecimal steuerfreiLautWertart() throws BusinessDomainException {
        BigDecimal beitragspflichtig = this.wplib.result();
        BigDecimal steuerfreiLautWertartenbeschreibung = BigDecimal.ZERO;
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.walib.steuerfreiNachWABetrag())) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.walib.steuerfreiNachWAProzentsatz())) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.walib.basiswertProzentsatzSteuerfreiheit())) {
                    steuerfreiLautWertartenbeschreibung = beitragspflichtig.multiply(this.walib.steuerfreiNachWAProzentsatz()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                    beitragspflichtig = beitragspflichtig.subtract(steuerfreiLautWertartenbeschreibung);
                } else {
                    steuerfreiLautWertartenbeschreibung = beitragspflichtig.multiply(this.walib.steuerfreiNachWAProzentsatz()).divide(this.walib.basiswertProzentsatzSteuerfreiheit(), 2, RoundingMode.HALF_UP);
                    beitragspflichtig = beitragspflichtig.subtract(steuerfreiLautWertartenbeschreibung);
                }
            }
        } else if (BigDecimalMapper.compareTo((BigDecimal)this.walib.steuerfreiNachWABetrag(), (BigDecimal)beitragspflichtig) > 0) {
            steuerfreiLautWertartenbeschreibung = beitragspflichtig;
            beitragspflichtig = beitragspflichtig.subtract(steuerfreiLautWertartenbeschreibung);
        } else {
            steuerfreiLautWertartenbeschreibung = this.walib.steuerfreiNachWABetrag();
            beitragspflichtig = beitragspflichtig.subtract(steuerfreiLautWertartenbeschreibung);
        }
        return beitragspflichtig;
    }

    private void steuerungBremen() throws BusinessDomainException {
        BigDecimal beitragspflichtig = this.steuerfreiLautWertart();
        BigDecimal aufgelKammerbeitragspflichtigesBrutto = this.holeAufgelKammerpflichtigesBrutto();
        if (this.wplib.steuerTage() != DREISSIG) {
            if (this.wplib.steuerTage().compareTo(BigDecimal.ZERO) != 0) {
                this.callib.result(beitragspflichtig);
            } else {
                this.callib.result(BigDecimal.ZERO);
            }
        } else {
            this.callib.result(beitragspflichtig);
        }
        if (BigDecimalMapper.compareTo((BigDecimal)aufgelKammerbeitragspflichtigesBrutto, (BigDecimal)this.gllib.kammerBruttoUntergrenze()) <= 0) {
            BigDecimal zuVerbeitragendesBrutto = aufgelKammerbeitragspflichtigesBrutto.add(beitragspflichtig);
            if (BigDecimalMapper.compareTo((BigDecimal)zuVerbeitragendesBrutto, (BigDecimal)this.gllib.kammerBruttoUntergrenze()) > 0) {
                this.wplib.addNeueWertPosition(250510, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, zuVerbeitragendesBrutto, false);
            }
        } else {
            this.wplib.addNeueWertPosition(250510, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitragspflichtig, false);
        }
    }

    private void steuerungSaarland() throws BusinessDomainException {
        if (this.eelib.taxacation() == 4 || this.eelib.taxacation() == 5 || this.eelib.taxacation() == 3) {
            this.wplib.wertPosition().makeReadOnly();
        } else {
            BigDecimal beitragspflichtig = this.steuerfreiLautWertart();
            BigDecimal aufgelKammerbeitragspflichtigesBrutto = this.holeAufgelKammerpflichtigesBrutto();
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2008, 0, 1).getDate()) && this.eelib.marbGleitzoneregelung().value() == 2 && !this.eelib.marbVerzichtRvReduzierung() && this.cclib.checkGleitzoneRV()) {
                this.ermittleGleitzonenEntgeltRV();
                if (aufgelKammerbeitragspflichtigesBrutto.compareTo(this.mFiktivesEntgelt) == 0) {
                    this.callib.result(BigDecimal.ZERO);
                    this.wplib.wertPosition().makeReadOnly();
                } else {
                    this.callib.result(this.mFiktivesEntgelt);
                    this.wplib.addNeueWertPosition(250610, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mFiktivesEntgelt, false);
                }
            } else {
                BigDecimal kammerBruttoObergrenze = this.gllib.kammerBruttoObergrenze();
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)kammerBruttoObergrenze)) {
                    kammerBruttoObergrenze = this.gllib.svBbgRvAv().multiply(BigDecimal.valueOf(75L).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
                }
                if (BigDecimalMapper.compareTo((BigDecimal)aufgelKammerbeitragspflichtigesBrutto, (BigDecimal)kammerBruttoObergrenze) > 0) {
                    this.callib.result(BigDecimal.ZERO);
                } else {
                    BigDecimal nochAusschoepfbaresLimit = kammerBruttoObergrenze.subtract(aufgelKammerbeitragspflichtigesBrutto);
                    if (BigDecimalMapper.compareTo((BigDecimal)nochAusschoepfbaresLimit, (BigDecimal)beitragspflichtig) < 0) {
                        BigDecimal ueberDiff = beitragspflichtig.subtract(nochAusschoepfbaresLimit);
                        this.callib.result(nochAusschoepfbaresLimit);
                        this.callib.result1(ueberDiff);
                        this.wplib.addNeueWertPosition(250610, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, nochAusschoepfbaresLimit, false);
                    } else {
                        if (beitragspflichtig.compareTo(BigDecimal.ZERO) < 0) {
                            BigDecimal ueberBBG = this.leseUeberBBG();
                            if (beitragspflichtig.negate().compareTo(ueberBBG) > 0) {
                                beitragspflichtig = ueberBBG.add(beitragspflichtig);
                                this.callib.result1(ueberBBG.negate());
                            } else {
                                this.callib.result1(beitragspflichtig);
                                beitragspflichtig = BigDecimal.ZERO;
                            }
                        }
                        this.callib.result(beitragspflichtig);
                        this.wplib.addNeueWertPosition(250610, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitragspflichtig, false);
                    }
                }
            }
        }
    }

    private BigDecimal leseUeberBBG() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal ueberBBG = BigDecimal.ZERO;
        for (ValuePosition lElement : vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), this.wplib.wertPosition(), new ValueType[]{ValueType.getValueType((int)this.wplib.wertartenNummer())})) {
            ueberBBG = ueberBBG.add(lElement.getBufferResult());
        }
        return ueberBBG;
    }

    private void ermittleGleitzonenEntgeltRV() throws BusinessDomainException {
        ValuePosition[] vpArray;
        block6: for (ValuePosition lElement : vpArray = this.sammleValuePosition(new int[]{129200, 129210, 130510, 130610, 130620})) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 129200: {
                    if (this.eelib.marbBgrRvAndererAG() == 0) continue block6;
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.add(lElement.getResult());
                    continue block6;
                }
                case 129210: {
                    if (this.eelib.marbBgrRvAndererAG() == 0) continue block6;
                    this.mEntgeltEGAAbwAG = this.mEntgeltEGAAbwAG.add(lElement.getResult());
                    continue block6;
                }
                case 130510: {
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.add(lElement.getResult());
                    continue block6;
                }
                case 130610: 
                case 130620: {
                    this.mGesEntgeltEGA = this.mGesEntgeltEGA.add(lElement.getResult());
                    continue block6;
                }
            }
        }
        BigDecimal rvTage = this.wplib.rvTageMarb();
        if (this.mGesEntgeltEGA.compareTo(BigDecimal.ZERO) != 0) {
            this.abgrenzungEGA(rvTage);
        }
        if (this.eelib.isTeilLZZVorhanden() && !this.callib.getCalculationCase().isSignedAs23cSGBIV()) {
            if (DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate())) {
                if (rvTage.compareTo(BigDecimal.ZERO) != 0) {
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(rvTage, 2, RoundingMode.HALF_UP);
                }
            } else if (this.wplib.tageMitEFZ().compareTo(BigDecimal.ZERO) != 0) {
                this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(this.wplib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
            }
        }
        BigDecimal entgeltAbwAG = BigDecimal.ZERO;
        if (this.eelib.isMehrfachbeschaeftigt() && this.eelib.marbBgrRvAndererAG() != 0) {
            entgeltAbwAG = this.mEntgeltLfdAbwAG.add(this.mEntgeltEGAAbwAG);
        }
        Date validDateGleitzone = this.callib.berchnungGueltigAb();
        if (this.eelib.kennzBestandGleitzone2022()) {
            validDateGleitzone = new VDate(2022, 8, 1).getDate();
        }
        this.mF = this.gllib.svFaktorGleitzonenregelung(validDateGleitzone);
        BigDecimal svGleitzonenUntergrenze = this.gllib.svGleitzonenUntergrenze(validDateGleitzone);
        this.mGU = svGleitzonenUntergrenze.subtract(BigDecimal.valueOf(1L, 2));
        this.mGO = this.gllib.svGleitzonenObergrenze(validDateGleitzone).subtract(BigDecimal.valueOf(1L, 2));
        BigDecimal gesEntgelt = this.mGesEntgeltLfd.add(this.mGesEntgeltEGA);
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
            if (entgeltAbwAG.compareTo(BigDecimal.ZERO) == 0) {
                if (gesEntgelt.compareTo(svGleitzonenUntergrenze) < 0) {
                    if (this.eelib.kennzBestandGleitzone()) {
                        this.mGU = BigDecimal.valueOf(400L);
                        if (gesEntgelt.compareTo(this.mGU) > 0) {
                            this.normaleGleitzone(gesEntgelt, rvTage);
                        } else {
                            this.unterGleitzone2013(gesEntgelt, rvTage);
                        }
                    } else {
                        this.unterGleitzone2013(gesEntgelt, rvTage);
                    }
                } else {
                    this.normaleGleitzone2013(gesEntgelt, rvTage);
                }
            } else if (gesEntgelt.add(entgeltAbwAG).compareTo(svGleitzonenUntergrenze) < 0) {
                if (this.eelib.kennzBestandGleitzone()) {
                    this.mGU = BigDecimal.valueOf(400L);
                    this.mehrfachBeschaeftigung(gesEntgelt, gesEntgelt.add(entgeltAbwAG), rvTage);
                } else {
                    this.mehrfachBeschaeftigung2013(gesEntgelt, entgeltAbwAG.add(gesEntgelt), rvTage);
                }
            } else {
                this.mehrfachBeschaeftigung2013(gesEntgelt, entgeltAbwAG.add(gesEntgelt), rvTage);
            }
        } else if (entgeltAbwAG.compareTo(BigDecimal.ZERO) == 0) {
            if (gesEntgelt.compareTo(svGleitzonenUntergrenze) < 0) {
                this.unterGleitzone(gesEntgelt, rvTage);
            } else {
                this.normaleGleitzone(gesEntgelt, rvTage);
            }
        } else {
            this.mehrfachBeschaeftigung(gesEntgelt, entgeltAbwAG.add(gesEntgelt), rvTage);
        }
    }

    private void normaleGleitzone(BigDecimal svPflEntgelt, BigDecimal rvTage) throws BusinessDomainException {
        this.mFiktivesEntgelt = DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate()) ? this.mF.multiply(this.mGU).add(ZWEI.subtract(this.mF).multiply(svPflEntgelt.subtract(this.mGU))).setScale(2, RoundingMode.HALF_UP) : this.mF.multiply(this.mGU).add(ZWEI.subtract(this.mF).multiply(svPflEntgelt.subtract(this.mGU)));
        if (this.eelib.isTeilLZZVorhanden() && !this.callib.getCalculationCase().isSignedAs23cSGBIV()) {
            this.mFiktivesEntgelt = DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) ? this.mFiktivesEntgelt.multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : this.mFiktivesEntgelt.multiply(this.wplib.tageMitEFZ()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        }
    }

    private void normaleGleitzone2013(BigDecimal svPflEntgelt, BigDecimal rvTage) throws BusinessDomainException {
        this.mFiktivesEntgelt = this.mF.multiply(this.mGU).add(this.mGO.divide(this.mGO.subtract(this.mGU), 6, RoundingMode.HALF_UP).subtract(this.mGU.divide(this.mGO.subtract(this.mGU), 6, RoundingMode.HALF_UP).multiply(this.mF)).multiply(svPflEntgelt.subtract(this.mGU)));
        if (this.eelib.isTeilLZZVorhanden() && !this.callib.getCalculationCase().isSignedAs23cSGBIV()) {
            this.mFiktivesEntgelt = DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) ? this.mFiktivesEntgelt.multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : this.mFiktivesEntgelt.multiply(this.wplib.tageMitEFZ()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        }
    }

    private void unterGleitzone(BigDecimal svPflEntgelt, BigDecimal rvTage) throws BusinessDomainException {
        this.mFiktivesEntgelt = this.mF.multiply(svPflEntgelt);
        if (this.eelib.isTeilLZZVorhanden() && !this.callib.getCalculationCase().isSignedAs23cSGBIV()) {
            this.mFiktivesEntgelt = DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) ? this.mFiktivesEntgelt.multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : this.mFiktivesEntgelt.multiply(this.wplib.tageMitEFZ()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        }
    }

    private void unterGleitzone2013(BigDecimal svPflEntgelt, BigDecimal rvTage) throws BusinessDomainException {
        this.mFiktivesEntgelt = this.mF.multiply(svPflEntgelt).setScale(2, RoundingMode.HALF_UP);
        if (this.eelib.isTeilLZZVorhanden() && !this.callib.getCalculationCase().isSignedAs23cSGBIV()) {
            this.mFiktivesEntgelt = DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) ? this.mFiktivesEntgelt.multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : this.mFiktivesEntgelt.multiply(this.wplib.tageMitEFZ()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        }
    }

    private void mehrfachBeschaeftigung(BigDecimal EAE, BigDecimal GAE, BigDecimal rvTage) throws BusinessDomainException {
        this.mFiktivesEntgelt = this.mF.multiply(this.mGU).add(ZWEI.subtract(this.mF).multiply(GAE.subtract(this.mGU))).multiply(EAE).divide(EAE, 2, RoundingMode.HALF_UP);
        if (this.eelib.isTeilLZZVorhanden() && !this.callib.getCalculationCase().isSignedAs23cSGBIV()) {
            this.mFiktivesEntgelt = DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) ? this.mFiktivesEntgelt.multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : this.mFiktivesEntgelt.multiply(this.wplib.tageMitEFZ()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        }
    }

    private void mehrfachBeschaeftigung2013(BigDecimal EAE, BigDecimal GAE, BigDecimal rvTage) throws BusinessDomainException {
        this.mFiktivesEntgelt = this.mF.multiply(this.mGU).add(this.mGO.divide(this.mGO.subtract(this.mGU), 6, RoundingMode.HALF_UP).subtract(this.mGU.divide(this.mGO.subtract(this.mGU), 6, RoundingMode.HALF_UP).multiply(this.mF)).multiply(GAE.subtract(this.mGU))).multiply(EAE).divide(GAE, 2, RoundingMode.HALF_UP);
        if (this.eelib.isTeilLZZVorhanden() && !this.callib.getCalculationCase().isSignedAs23cSGBIV()) {
            this.mFiktivesEntgelt = DateHelper.before((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) ? this.mFiktivesEntgelt.multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : this.mFiktivesEntgelt.multiply(this.wplib.tageMitEFZ()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        }
    }

    private ValuePosition[] sammleValuePosition(int[] vtNumbers) throws BusinessDomainException {
        return this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), this.getValueTypes(vtNumbers));
    }

    private ValueType[] getValueTypes(int[] vtNumbers) {
        ValueType[] vtArray = new ValueType[vtNumbers.length];
        for (int i = 0; i < vtNumbers.length; ++i) {
            vtArray[i] = ValueType.getValueType((int)vtNumbers[i]);
        }
        return vtArray;
    }

    private void abgrenzungEGA(BigDecimal rvTage) throws BusinessDomainException {
        this.mZwRVBBG = this.gllib.svBbgRvAv().multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        this.mZwSVEntgelt = BigDecimal.ZERO;
        switch (this.eelib.marbGleitzoneregelung().value()) {
            case 2: {
                this.mZwSVEntgelt = this.mGesEntgeltLfd.add(this.mEntgeltLfdAbwAG).add(this.mEntgeltEGAAbwAG);
                break;
            }
            default: {
                this.mZwSVEntgelt = this.mGesEntgeltLfd;
            }
        }
        if (this.mZwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.mZwRVBBG) > 0) {
            this.holeJahresWerte();
            if (this.mZwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.mZwRVBBG) > 0) {
                this.mGesEntgeltEGA = this.mZwSVEntgelt.compareTo(this.mZwRVBBG) < 0 ? this.mZwRVBBG.subtract(this.mZwSVEntgelt) : BigDecimal.ZERO;
            }
        }
    }

    private void holeJahresWerte() throws BusinessDomainException {
        ValuePosition[] zwVPArray = null;
        Date sucheBeginnDatum = DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb());
        Date sucheEndeDatum = DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb());
        ValueType[] vtArray = this.getValueTypes(new int[]{327590, 327510, 327514, 327610, 327614});
        while (DateHelper.before((Date)sucheBeginnDatum, (Date)sucheEndeDatum)) {
            block5: for (ValuePosition lElement : zwVPArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), sucheBeginnDatum, DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum), vtArray)) {
                switch (lElement.getValueType().getValueTypeKey()) {
                    case 327590: {
                        this.mZwRVBBG = this.mZwRVBBG.add(lElement.getResult());
                        continue block5;
                    }
                    case 327510: 
                    case 327514: 
                    case 327610: 
                    case 327614: {
                        this.mZwSVEntgelt = this.mZwSVEntgelt.add(lElement.getResult());
                        continue block5;
                    }
                }
            }
            sucheBeginnDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum));
        }
    }

    public BigDecimal holeAufgelKammerpflichtigesBrutto() throws BusinessDomainException {
        BigDecimal aufgelKammerbeitragspflichtigesBrutto = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) {
            ValuePosition[] vpArray;
            for (ValuePosition lElement : vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), this.wplib.wertPosition(), new ValueType[]{ValueType.getValueType((int)this.wplib.wertartenNummer())})) {
                aufgelKammerbeitragspflichtigesBrutto = aufgelKammerbeitragspflichtigesBrutto.add(lElement.getResult());
            }
        } else {
            ValuePosition[] vpArray;
            for (ValuePosition lElement : vpArray = this.wplib.wpAusWPListeBisParentUebergebenerWP(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), this.wplib.wertPosition(), new ValueType[]{ValueType.getValueType((int)this.wplib.wertartenNummer())})) {
                aufgelKammerbeitragspflichtigesBrutto = aufgelKammerbeitragspflichtigesBrutto.add(lElement.getResult());
            }
        }
        return aufgelKammerbeitragspflichtigesBrutto;
    }
}

