/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class SteuerungBvAgzFormula {
    private static final BigDecimal BD2 = BigDecimal.valueOf(2L);
    private static final BigDecimal BD100 = BigDecimal.valueOf(100L);
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private final ValuePositionLibrary wplib;
    private BigDecimal mEingangswert;
    private BigDecimal mProzentsatz;
    private BigDecimal mResult;

    public SteuerungBvAgzFormula(CalculationLibrary calLib, EmployeeLibrary eeLib, GlobalLibrary glLib, ValuePositionLibrary wpLib) {
        this.callib = calLib;
        this.eelib = eeLib;
        this.gllib = glLib;
        this.wplib = wpLib;
    }

    public void steuerung() throws BusinessDomainException {
        this.mEingangswert = this.callib.rvEntgelt();
        switch (this.wplib.wertartenNummer()) {
            case 775512: {
                this.agzGfB();
                if (this.eelib.marbVerzichtRvReduzierung()) break;
                this.wplib.addNeueWertPosition(774511, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mEingangswert, false);
                break;
            }
            case 775514: {
                this.agzGleitzone();
                break;
            }
            case 775550: {
                this.agzAtzGesetzlich();
                this.wplib.addNeueWertPosition(774560, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mEingangswert, false);
                break;
            }
            case 775555: {
                this.agzAtzVertraglich();
                this.wplib.addNeueWertPosition(774565, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mEingangswert, false);
                break;
            }
            case 775720: {
                this.vollerBeitragssatz();
                this.wplib.addNeueWertPosition(774710, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mEingangswert, false);
                break;
            }
            case 775725: {
                this.wplib.addNeueWertPosition(774720, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mEingangswert, false);
                break;
            }
            case 775740: {
                this.wplib.wertPosition().makeReadOnly();
                this.mResult = BigDecimal.ZERO;
                break;
            }
            default: {
                this.halberBeitragssatz();
            }
        }
        this.callib.rvAGZBefreiendeLV(this.mResult);
        this.callib.percentage(this.mProzentsatz);
    }

    private void agzGfB() throws BusinessDomainException {
        this.mProzentsatz = this.gllib.svBsPauschGfbRv();
        this.mResult = this.mEingangswert.multiply(this.mProzentsatz).divide(BD100, 2, RoundingMode.HALF_UP);
    }

    private void agzAtzVertraglich() throws BusinessDomainException {
        this.agzAtzGesetzlich();
        BigDecimal mGrundlageGesetzlich = this.mEingangswert;
        BigDecimal agzGesetzl = this.mResult;
        ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes(773550, 773555, 773655, 773665, 773675));
        this.mEingangswert = BigDecimal.ZERO;
        for (ValuePosition vPos : vpArray) {
            this.mEingangswert = this.mEingangswert.add(vPos.getResult());
        }
        this.vollerBeitragssatz();
        this.mEingangswert = this.mEingangswert.subtract(mGrundlageGesetzlich);
        this.mResult = this.mResult.subtract(agzGesetzl);
    }

    private void agzAtzGesetzlich() throws BusinessDomainException {
        ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes(773550));
        this.mEingangswert = BigDecimal.ZERO;
        for (ValuePosition vPos : vpArray) {
            this.mEingangswert = this.mEingangswert.add(vPos.getResult());
        }
        this.vollerBeitragssatz();
    }

    private void agzGleitzone() throws BusinessDomainException {
        ValueType[] valueTypes = DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2022, 9, 1).getDate()) ? ValueTypeHelper.getValueTypes(773616) : ValueTypeHelper.getValueTypes(773514, 773614);
        ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), valueTypes);
        this.mEingangswert = BigDecimal.ZERO;
        for (ValuePosition vPos : vpArray) {
            this.mEingangswert = this.mEingangswert.add(vPos.getResult());
        }
        this.halberBeitragssatz();
    }

    private void vollerBeitragssatz() throws BusinessDomainException {
        this.mProzentsatz = this.gllib.svBsGesamtRv();
        this.mResult = this.mEingangswert.multiply(this.mProzentsatz).divide(BD100, 2, RoundingMode.HALF_UP);
    }

    private void halberBeitragssatz() throws BusinessDomainException {
        this.mProzentsatz = this.gllib.svBsGesamtRv().divide(BD2, 3, RoundingMode.HALF_UP);
        this.mResult = this.mEingangswert.multiply(this.mProzentsatz).divide(BD100, 2, RoundingMode.HALF_UP);
    }
}

