/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.RVBeitragsermittlungGleitzone2022Formula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class RVBeitragsermittlungGleitzoneFormula {
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private BigDecimal mAufgelaufenesGesamtEntgelt = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenesFiktivesEntgelt = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenerBeitrag = BigDecimal.ZERO;
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;

    public RVBeitragsermittlungGleitzoneFormula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.mCalLib = calculationLibrary;
        this.mEeLib = employeeLibrary;
        this.mGlLib = globalLibrary;
        this.mVpLib = valuePositionLibrary;
    }

    public void rvbeitraege() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2022, 9, 1).getDate()) && !this.mEeLib.kennzBestandGleitzone2022()) {
            new RVBeitragsermittlungGleitzone2022Formula(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib).rvbeitraege();
        } else {
            ValuePosition vp = this.mVpLib.wertPosition();
            boolean AGA100Prozent = BigDecimalMapper.compareTo((BigDecimal)vp.getPerformanceFactor(), (BigDecimal)BigDecimal.valueOf(100L)) == 0;
            BigDecimal gesBeitrPflEntgelt = this.mVpLib.prozentsatz();
            BigDecimal fiktivesBeitrPflEntgelt = this.mVpLib.result();
            this.ermittleRVEntgeltImMonat(this.mVpLib.wertartenNummer());
            vp.setSumOfBasicResult(gesBeitrPflEntgelt);
            vp.setSumOfResult(fiktivesBeitrPflEntgelt);
            gesBeitrPflEntgelt = gesBeitrPflEntgelt.add(this.mAufgelaufenesGesamtEntgelt);
            fiktivesBeitrPflEntgelt = fiktivesBeitrPflEntgelt.add(this.mAufgelaufenesFiktivesEntgelt);
            BigDecimal vHSatzAGA = BigDecimal.ZERO;
            BigDecimal vHSatzANA = BigDecimal.ZERO;
            BigDecimal rvAGA = BigDecimal.ZERO;
            BigDecimal rvANA = BigDecimal.ZERO;
            if (AGA100Prozent) {
                vHSatzAGA = this.mGlLib.svBsGesamtRv();
                rvAGA = rvAGA.add(this.mVpLib.prozentsatz().multiply(vHSatzAGA).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
                rvAGA = rvAGA.add(this.mAufgelaufenerBeitrag);
                vp.setPerformanceFactor(BigDecimal.ZERO);
            } else {
                vHSatzAGA = this.mGlLib.krkTyp() == 6 && this.mEeLib.marbErhBeitrErmKnappschRV() ? this.mGlLib.svBsKnappschaftGesamt().subtract(this.mGlLib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP)) : this.mGlLib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                rvAGA = gesBeitrPflEntgelt.multiply(vHSatzAGA).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate())) {
                    vHSatzANA = this.mGlLib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                    rvANA = fiktivesBeitrPflEntgelt.multiply(vHSatzANA).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                    rvANA = rvANA.multiply(ZWEI).setScale(2, RoundingMode.HALF_UP);
                } else {
                    vHSatzANA = this.mGlLib.svBsGesamtRv();
                    rvANA = fiktivesBeitrPflEntgelt.multiply(vHSatzANA).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                }
                rvANA = rvANA.subtract(rvAGA).setScale(2);
            }
            boolean rvAgaGekuerzt = false;
            if (rvANA.compareTo(BigDecimal.ZERO) < 0) {
                rvAGA = rvAGA.add(rvANA);
                rvANA = BigDecimal.ZERO;
                rvAgaGekuerzt = true;
            }
            switch (this.mVpLib.wertartenNummer()) {
                case 328514: {
                    rvANA = rvANA.subtract(this.mAufgelaufenerBeitrag);
                    break;
                }
                case 329514: {
                    rvAGA = rvAGA.subtract(this.mAufgelaufenerBeitrag);
                    break;
                }
            }
            vHSatzANA = vHSatzANA.divide(ZWEI, 2, RoundingMode.HALF_UP);
            if (gesBeitrPflEntgelt.compareTo(BigDecimal.ZERO) == 0) {
                vHSatzANA = BigDecimal.ZERO;
                vHSatzAGA = BigDecimal.ZERO;
            } else {
                if (rvAgaGekuerzt && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.prozentsatz())) {
                    vHSatzAGA = rvAGA.multiply(EINHUNDERT).divide(this.mVpLib.prozentsatz(), 3, RoundingMode.HALF_UP);
                }
                if (DateHelper.before((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate())) {
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.prozentsatz())) {
                        vHSatzANA = rvANA.multiply(EINHUNDERT).divide(this.mVpLib.prozentsatz(), 3, RoundingMode.HALF_UP);
                    }
                } else {
                    vHSatzANA = BigDecimal.ZERO;
                }
            }
            this.mCalLib.rvANBeitrag(rvANA);
            this.mCalLib.rvANProzentsatz(vHSatzANA);
            this.mCalLib.rvAGBeitrag(rvAGA);
            this.mCalLib.rvAGProzentsatz(vHSatzAGA);
        }
    }

    private void ermittleRVEntgeltImMonat(int valueType) throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition lElement : vpArray = this.sammleValuePosition(ValueTypeHelper.getValueTypes(valueType))) {
            if (lElement.getSumOfBasicResult() != null) {
                this.mAufgelaufenesGesamtEntgelt = this.mAufgelaufenesGesamtEntgelt.add(lElement.getSumOfBasicResult());
            }
            if (lElement.getSumOfResult() == null) continue;
            this.mAufgelaufenesFiktivesEntgelt = this.mAufgelaufenesFiktivesEntgelt.add(lElement.getSumOfResult());
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) continue;
            this.mAufgelaufenerBeitrag = this.mAufgelaufenerBeitrag.add(lElement.getResult());
        }
    }

    private ValuePosition[] sammleValuePosition(ValueType ... vts) throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vts);
    }
}

