/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class RVBeitragsermittlungGleitzone2022Formula {
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mAufgelaufenesGesamtEntgeltAG = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenesGesamtEntgeltAN = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenerBeitrag = BigDecimal.ZERO;

    public RVBeitragsermittlungGleitzone2022Formula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.mCalLib = calculationLibrary;
        this.mEeLib = employeeLibrary;
        this.mGlLib = globalLibrary;
        this.mVpLib = valuePositionLibrary;
    }

    public void rvbeitraege() throws BusinessDomainException {
        ValuePosition vp = this.mVpLib.wertPosition();
        boolean AGA100Prozent = BigDecimalMapper.compareTo((BigDecimal)vp.getPerformanceFactor(), (BigDecimal)BigDecimal.valueOf(100L)) == 0;
        BigDecimal gesBeitrPflEntgeltAG = this.mVpLib.prozentsatz();
        BigDecimal gesBeitrPflEntgeltAN = this.mVpLib.result();
        this.ermittleRVEntgeltImMonat(this.mVpLib.wertartenNummer());
        vp.setSumOfBasicResult(gesBeitrPflEntgeltAG);
        vp.setSumOfResult(gesBeitrPflEntgeltAN);
        gesBeitrPflEntgeltAG = gesBeitrPflEntgeltAG.add(this.mAufgelaufenesGesamtEntgeltAG);
        gesBeitrPflEntgeltAN = gesBeitrPflEntgeltAN.add(this.mAufgelaufenesGesamtEntgeltAN);
        BigDecimal vHSatzANA = BigDecimal.ZERO;
        BigDecimal rvAGA = BigDecimal.ZERO;
        BigDecimal rvANA = BigDecimal.ZERO;
        if (AGA100Prozent) {
            rvAGA = this.mAufgelaufenesGesamtEntgeltAG.multiply(this.mGlLib.svBsGesamtRv()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            rvAGA = rvAGA.add(this.mAufgelaufenerBeitrag);
            this.mCalLib.rvAGProzentsatz(this.mGlLib.svBsGesamtRv());
            vp.setPerformanceFactor(BigDecimal.ZERO);
        } else {
            BigDecimal vHSatzAG = this.mGlLib.krkTyp() == 6 && this.mEeLib.marbErhBeitrErmKnappschRV() ? this.mGlLib.svBsKnappschaftGesamt().subtract(this.mGlLib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP)) : this.mGlLib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
            if (this.mEeLib.marbBgrRv() == 1) {
                vHSatzANA = this.mGlLib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                this.mCalLib.rvANProzentsatz(vHSatzANA);
            }
            BigDecimal rvGesamtAG = gesBeitrPflEntgeltAG.multiply(vHSatzAG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            BigDecimal rvGesamtAN = gesBeitrPflEntgeltAG.multiply(vHSatzANA).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            rvANA = gesBeitrPflEntgeltAN.multiply(vHSatzANA).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            rvAGA = rvGesamtAG.add(rvGesamtAN).subtract(rvANA);
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)rvANA)) {
                this.mCalLib.rvAGProzentsatz(this.mGlLib.svBsGesamtRv());
            }
        }
        switch (this.mVpLib.wertartenNummer()) {
            case 328514: {
                rvANA = rvANA.subtract(this.mAufgelaufenerBeitrag);
                break;
            }
            case 329514: {
                rvAGA = rvAGA.subtract(this.mAufgelaufenerBeitrag);
                break;
            }
        }
        this.mCalLib.rvANBeitrag(rvANA);
        this.mCalLib.rvAGBeitrag(rvAGA);
    }

    private void ermittleRVEntgeltImMonat(int valueType) throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition lElement : vpArray = this.sammleValuePosition(ValueTypeHelper.getValueTypes(valueType))) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfBasicResult())) {
                this.mAufgelaufenesGesamtEntgeltAG = this.mAufgelaufenesGesamtEntgeltAG.add(lElement.getSumOfBasicResult());
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) {
                this.mAufgelaufenesGesamtEntgeltAN = this.mAufgelaufenesGesamtEntgeltAN.add(lElement.getSumOfResult());
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfBasicResult()) && BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) continue;
            this.mAufgelaufenerBeitrag = this.mAufgelaufenerBeitrag.add(lElement.getResult());
        }
    }

    private ValuePosition[] sammleValuePosition(ValueType ... vts) throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vts);
    }
}

