/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.employee.insurance.MultiplyEmploymentEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class RVBeitragsermittlungFormula {
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private static final BigDecimal FUENFZIG = BigDecimal.valueOf(50L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private final ValuePositionLibrary wplib;
    private BigDecimal beitragssatz_aga = BigDecimal.ZERO;
    private BigDecimal beitragssatz_ana = BigDecimal.ZERO;
    private BigDecimal mMBBGL = BigDecimal.ZERO;
    private BigDecimal sv_tage = BigDecimal.ZERO;

    public RVBeitragsermittlungFormula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.callib = calculationLibrary;
        this.eelib = employeeLibrary;
        this.gllib = globalLibrary;
        this.wplib = valuePositionLibrary;
    }

    public void rvbeitraege() throws BusinessDomainException {
        block0 : switch (this.eelib.marbBgrRv()) {
            case 0: {
                switch (this.eelib.marbVersorgungsart().value()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        if (!DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) break block0;
                        this.a5();
                        break block0;
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                if (this.eelib.marbPgs() == 109 || this.eelib.kennzBestandGleitzone2022()) {
                    if (this.wplib.wertartenNummer() == 329740) {
                        this.a_1();
                        break;
                    }
                    this.a_4();
                    break;
                }
                this.a_1();
                break;
            }
            case 3: 
            case 4: {
                this.a_2();
                break;
            }
            case 5: 
            case 6: {
                this.a_3();
            }
        }
    }

    private void a_1() throws BusinessDomainException {
        block0 : switch (this.wplib.wertartenNummer()) {
            case 329520: 
            case 329620: 
            case 329740: {
                switch (this.gllib.krkTyp()) {
                    case 6: {
                        if (!this.eelib.marbErhBeitrErmKnappschRV()) break;
                        this.beitragssatz_ana = BigDecimal.ZERO;
                        this.beitragssatz_aga = this.gllib.svBsKnappschaftGesamt();
                        break block0;
                    }
                }
                this.beitragssatz_ana = BigDecimal.ZERO;
                this.beitragssatz_aga = this.gllib.svBsGesamtRv();
                break;
            }
            default: {
                switch (this.gllib.krkTyp()) {
                    case 6: {
                        if (!this.eelib.marbErhBeitrErmKnappschRV()) break;
                        this.beitragssatz_ana = this.gllib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                        this.beitragssatz_aga = this.gllib.svBsKnappschaftGesamt().subtract(this.beitragssatz_ana);
                        break block0;
                    }
                }
                this.beitragssatz_ana = this.gllib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                this.beitragssatz_aga = this.gllib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
            }
        }
        this.callib.rvAGBeitrag(this.callib.rvEntgelt().multiply(this.beitragssatz_aga).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.callib.rvAGProzentsatz(this.beitragssatz_aga);
        this.callib.rvANBeitrag(this.callib.rvEntgelt().multiply(this.beitragssatz_ana).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.callib.rvANProzentsatz(this.beitragssatz_ana);
    }

    private void a_2() throws BusinessDomainException {
        switch (this.gllib.krkTyp()) {
            case 6: {
                if (this.eelib.marbErhBeitrErmKnappschRV()) {
                    this.beitragssatz_ana = this.gllib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                    this.beitragssatz_aga = this.gllib.svBsKnappschaftGesamt().subtract(this.beitragssatz_ana);
                    this.beitragssatz_ana = BigDecimal.ZERO;
                    break;
                }
            }
            default: {
                this.beitragssatz_ana = BigDecimal.ZERO;
                this.beitragssatz_aga = this.gllib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
            }
        }
        this.callib.rvAGBeitrag(this.callib.rvEntgelt().multiply(this.beitragssatz_aga).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.callib.rvAGProzentsatz(this.beitragssatz_aga);
        this.callib.rvANBeitrag(this.callib.rvEntgelt().multiply(this.beitragssatz_ana).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.callib.rvANProzentsatz(this.beitragssatz_ana);
    }

    private void a_3() throws BusinessDomainException {
        this.beitragssatz_ana = BigDecimal.ZERO;
        this.beitragssatz_aga = this.gllib.svBsPauschGfbRv();
        this.callib.rvAGBeitrag(this.callib.rvEntgelt().multiply(this.beitragssatz_aga).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.callib.rvAGProzentsatz(this.beitragssatz_aga);
        this.callib.rvANBeitrag(this.callib.rvEntgelt().multiply(this.beitragssatz_ana).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.callib.rvANProzentsatz(this.beitragssatz_ana);
    }

    private void a_4() throws BusinessDomainException {
        this.beitragssatz_aga = this.gllib.svBsPauschGfbRv();
        BigDecimal rv_ag_beitrag = BigDecimal.ZERO;
        BigDecimal rv_an_beitrag = BigDecimal.ZERO;
        this.beitragssatz_ana = this.gllib.svBsGesamtRv();
        this.sv_tage = this.wplib.svTage();
        this.mMBBGL = BigDecimalMapper.compareTo((BigDecimal)this.sv_tage, (BigDecimal)DREISSIG) != 0 ? this.gllib.svMbmgGfbRV().multiply(this.sv_tage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : this.gllib.svMbmgGfbRV();
        BigDecimal summeLaufendesEntgelt = this.wplib.summeWPErgebnisVonWertarten(ValueTypeHelper.getValueTypes(327512));
        BigDecimal summeEinmalgezaltesEntgelt = this.wplib.summeWPErgebnisVonWertarten(ValueTypeHelper.getValueTypes(327612));
        BigDecimal entgeltAndererAG = BigDecimal.ZERO;
        boolean mfb = false;
        boolean isMfBUndVersorgung = false;
        if (this.eelib.isMehrfachbeschaeftigt()) {
            switch (this.eelib.marbVersorgungsart().value()) {
                case 1: 
                case 2: 
                case 3: {
                    if (this.eelib.marbBgrRvAndererAG() != 0 || this.eelib.marbBgrRv() != 0 || this.eelib.marbMehrfachBeschaeftigung() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_OHNE_BV || this.eelib.marbMehrfachBeschaeftigung() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_UND_ANDERER_RECHTSKREIS_OHNE_BV) break;
                    isMfBUndVersorgung = true;
                }
            }
            mfb = true;
        }
        if (this.eelib.marbBgrRvAndererAG() == 1 && this.eelib.marbBgrRv() == 1 && mfb || isMfBUndVersorgung) {
            ValuePosition[] vpArray;
            for (ValuePosition valuePosition : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes(129200, 129205))) {
                entgeltAndererAG = entgeltAndererAG.add(valuePosition.getResult());
            }
            this.mMBBGL = this.eelib.marbBgrKvAndererAG() == 6 && this.eelib.marbBgrKv() == 6 ? (summeLaufendesEntgelt.add(entgeltAndererAG).compareTo(this.mMBBGL) > 0 ? this.callib.rvEntgelt() : summeLaufendesEntgelt.multiply(this.mMBBGL).divide(summeLaufendesEntgelt.add(entgeltAndererAG), 2, RoundingMode.HALF_UP)) : this.callib.rvEntgelt();
        }
        if (BigDecimalMapper.compareTo((BigDecimal)summeLaufendesEntgelt.add(summeEinmalgezaltesEntgelt), (BigDecimal)this.mMBBGL) < 0) {
            if (BigDecimalMapper.compareTo((BigDecimal)this.callib.rvEntgelt(), (BigDecimal)BigDecimal.ZERO) != 0) {
                rv_ag_beitrag = this.callib.rvEntgelt().movePointLeft(2);
                rv_ag_beitrag = rv_ag_beitrag.multiply(this.beitragssatz_aga).setScale(2, RoundingMode.HALF_UP);
                rv_an_beitrag = this.mMBBGL.movePointLeft(2);
                rv_an_beitrag = rv_an_beitrag.multiply(this.beitragssatz_ana).setScale(2, RoundingMode.HALF_UP);
                rv_an_beitrag = rv_an_beitrag.subtract(rv_ag_beitrag);
                this.wplib.addNeueWertPosition(328513, BigDecimal.ZERO, BigDecimal.ZERO, this.sv_tage, BigDecimal.ZERO, this.mMBBGL, true);
            } else {
                rv_an_beitrag = BigDecimal.ZERO;
                rv_ag_beitrag = BigDecimal.ZERO;
                this.beitragssatz_ana = BigDecimal.ZERO;
                this.beitragssatz_aga = BigDecimal.ZERO;
            }
        } else {
            if (BigDecimalMapper.compareTo((BigDecimal)summeLaufendesEntgelt.add(entgeltAndererAG), (BigDecimal)this.mMBBGL) < 0) {
                new CalculationBasic(this.wplib.wertPosition().getEmployee(), this.wplib.wirksamAb(), DateHelper.getFirstDayOfMonth((Date)new VDate(this.wplib.gueltigAb()).addMonths(1).getDate()), this.getClass().getName());
            }
            rv_ag_beitrag = this.callib.rvEntgelt().movePointLeft(2);
            rv_ag_beitrag = rv_ag_beitrag.multiply(this.beitragssatz_aga).setScale(2, RoundingMode.HALF_UP);
            rv_an_beitrag = this.callib.rvEntgelt().movePointLeft(2);
            rv_an_beitrag = rv_an_beitrag.multiply(this.beitragssatz_ana).setScale(2, RoundingMode.HALF_UP);
            rv_an_beitrag = rv_an_beitrag.subtract(rv_ag_beitrag);
        }
        this.callib.rvAGBeitrag(rv_ag_beitrag);
        this.callib.rvANBeitrag(rv_an_beitrag);
        this.beitragssatz_ana = this.beitragssatz_ana.subtract(this.beitragssatz_aga);
        this.callib.rvANProzentsatz(this.beitragssatz_ana);
        this.callib.rvAGProzentsatz(this.beitragssatz_aga);
    }

    private void a5() throws BusinessDomainException {
        switch (this.eelib.marbBerechnungsArtBefreiendeLV().value()) {
            case 0: {
                this.a5a();
                break;
            }
            case 1: {
                this.a5b();
            }
        }
    }

    private void a5a() throws BusinessDomainException {
        BigDecimal rvBBG = this.gllib.svBbgRvAv();
        BigDecimal svEntgelt = this.wplib.result();
        if (svEntgelt.compareTo(rvBBG) >= 0) {
            svEntgelt = rvBBG;
        }
        BigDecimal mRV_Gesamtbeitrag = svEntgelt.multiply(this.gllib.svBsGesamtRv()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        BigDecimal rv_Beitragssatz_AG = this.gllib.svBsGesamtRv().divide(ZWEI, 3, RoundingMode.HALF_UP);
        BigDecimal mRV_AGZ = svEntgelt.multiply(rv_Beitragssatz_AG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        switch (this.eelib.marbZahlungsArtBefreiendeLV().value()) {
            case 0: {
                this.wplib.addNeueWertPosition(772020, mRV_Gesamtbeitrag);
                break;
            }
            case 1: {
                this.wplib.addNeueWertPosition(772010, mRV_Gesamtbeitrag);
            }
        }
        this.callib.rvAGZBefreiendeLV(mRV_AGZ);
    }

    private void a5b() throws BusinessDomainException {
        BigDecimal mRV_Gesamtbeitrag = this.eelib.marbGesamtbeitragBefreiendeLV();
        BigDecimal mRV_AGZ = BigDecimal.ZERO;
        mRV_AGZ = BigDecimalMapper.isZeroOrNull((BigDecimal)this.eelib.marbAGZBefrLV()) ? mRV_Gesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP) : this.eelib.marbAGZBefrLV();
        switch (this.eelib.marbZahlungsArtBefreiendeLV().value()) {
            case 0: {
                this.wplib.addNeueWertPosition(772020, mRV_Gesamtbeitrag);
                break;
            }
            case 1: {
                this.wplib.addNeueWertPosition(772010, mRV_Gesamtbeitrag);
            }
        }
        this.callib.rvAGZBefreiendeLV(mRV_AGZ);
    }
}

