/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.PVBeitragsermittlungGleitzone2022Formula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class PVBeitragsermittlungGleitzoneFormula {
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private BigDecimal mAufgelaufenesGesamtEntgelt = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenesFiktivesEntgelt = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenerBeitrag = BigDecimal.ZERO;
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;

    public PVBeitragsermittlungGleitzoneFormula(EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, CalculationLibrary calculationLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.mCalLib = calculationLibrary;
        this.mGlLib = globalLibrary;
        this.mEeLib = employeeLibrary;
        this.mVpLib = valuePositionLibrary;
    }

    public void pvbeitraege() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2022, 9, 1).getDate()) && !this.mEeLib.kennzBestandGleitzone2022()) {
            new PVBeitragsermittlungGleitzone2022Formula(this.mEeLib, this.mGlLib, this.mCalLib, this.mVpLib).pvbeitraege();
        } else {
            BigDecimal gesBeitrPflEntgelt = this.mVpLib.prozentsatz();
            BigDecimal fiktivesBeitrPflEntgelt = this.mVpLib.result();
            this.ermittlePVEntgeltImMonat(this.mVpLib.wertartenNummer());
            ValuePosition vp = this.mVpLib.wertPosition();
            boolean AGA100Prozent = BigDecimalMapper.compareTo((BigDecimal)vp.getPerformanceFactor(), (BigDecimal)BigDecimal.valueOf(100L)) == 0;
            vp.setSumOfBasicResult(gesBeitrPflEntgelt);
            vp.setSumOfResult(fiktivesBeitrPflEntgelt);
            gesBeitrPflEntgelt = gesBeitrPflEntgelt.add(this.mAufgelaufenesGesamtEntgelt);
            fiktivesBeitrPflEntgelt = fiktivesBeitrPflEntgelt.add(this.mAufgelaufenesFiktivesEntgelt);
            BigDecimal vHSatzAna = BigDecimal.ZERO;
            BigDecimal vhSatzPvAnaZusatz = BigDecimal.ZERO;
            if (this.mEeLib.marbAelterDreiUndZwanzig() && !this.mEeLib.isMarbKindErz()) {
                vhSatzPvAnaZusatz = this.mGlLib.svBsKinderlosPV();
            }
            BigDecimal vHSatzAga = BigDecimal.ZERO;
            vHSatzAga = this.mGlLib.bundeslandSchluesselBeschaeftigungsort() == 15 ? this.mGlLib.bulaPvAga() : this.mGlLib.svBsGesamtPV().divide(ZWEI, 4, RoundingMode.HALF_UP);
            BigDecimal pvAGA = BigDecimal.ZERO;
            BigDecimal pvANA = BigDecimal.ZERO;
            BigDecimal pvANZusatz = BigDecimal.ZERO;
            if (AGA100Prozent) {
                vHSatzAga = this.mGlLib.svBsGesamtPV();
                pvAGA = pvAGA.add(this.mVpLib.prozentsatz().multiply(vHSatzAga).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
                pvAGA = pvAGA.add(this.mAufgelaufenerBeitrag);
                vp.setPerformanceFactor(BigDecimal.ZERO);
            } else {
                vHSatzAna = this.mGlLib.svBsGesamtPV().divide(ZWEI, 4, RoundingMode.HALF_UP);
                if (this.mEeLib.marbBgrPv() == 2) {
                    vHSatzAna = vHSatzAna.divide(ZWEI, 4, RoundingMode.HALF_UP);
                    vHSatzAga = vHSatzAga.divide(ZWEI, 4, RoundingMode.HALF_UP);
                }
                pvAGA = gesBeitrPflEntgelt.multiply(vHSatzAga).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                pvANA = fiktivesBeitrPflEntgelt.multiply(vHSatzAna).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                pvANA = pvANA.multiply(ZWEI).subtract(pvAGA).setScale(2);
                pvANZusatz = fiktivesBeitrPflEntgelt.multiply(vhSatzPvAnaZusatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            }
            boolean aGAgekuerzt = false;
            if (pvANA.compareTo(BigDecimal.ZERO) < 0) {
                aGAgekuerzt = true;
                pvAGA = pvAGA.add(pvANA);
                pvANA = BigDecimal.ZERO;
            }
            switch (this.mVpLib.wertartenNummer()) {
                case 340514: {
                    pvANA = pvANA.subtract(this.mAufgelaufenerBeitrag);
                    break;
                }
                case 340518: {
                    pvANZusatz = pvANZusatz.subtract(this.mAufgelaufenerBeitrag);
                    break;
                }
                case 341514: {
                    pvAGA = pvAGA.subtract(this.mAufgelaufenerBeitrag);
                    break;
                }
            }
            if (gesBeitrPflEntgelt.compareTo(BigDecimal.ZERO) == 0) {
                vHSatzAna = BigDecimal.ZERO;
                vHSatzAga = BigDecimal.ZERO;
            } else {
                if (aGAgekuerzt && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.prozentsatz())) {
                    vHSatzAga = pvAGA.multiply(EINHUNDERT).divide(this.mVpLib.prozentsatz(), 4, RoundingMode.HALF_UP);
                }
                if (DateHelper.before((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate())) {
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.prozentsatz())) {
                        vHSatzAna = pvANA.multiply(EINHUNDERT).divide(this.mVpLib.prozentsatz(), 4, RoundingMode.HALF_UP);
                    }
                } else {
                    vHSatzAna = BigDecimal.ZERO;
                }
            }
            this.mCalLib.pvANProzentsatz(vHSatzAna);
            this.mCalLib.pvANZusatzProzentsatz(vhSatzPvAnaZusatz);
            this.mCalLib.pvANBeitrag(pvANA);
            this.mCalLib.pvANZusatzBeitrag(pvANZusatz);
            this.mCalLib.pvAGProzentsatz(vHSatzAga);
            this.mCalLib.pvAGBeitrag(pvAGA);
        }
    }

    private void ermittlePVEntgeltImMonat(int valueType) throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition lElement : vpArray = this.sammleValuePosition(ValueTypeHelper.getValueTypes(valueType))) {
            if (lElement.getSumOfBasicResult() != null) {
                this.mAufgelaufenesGesamtEntgelt = this.mAufgelaufenesGesamtEntgelt.add(lElement.getSumOfBasicResult());
            }
            if (lElement.getSumOfResult() == null) continue;
            this.mAufgelaufenesFiktivesEntgelt = this.mAufgelaufenesFiktivesEntgelt.add(lElement.getSumOfResult());
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) continue;
            this.mAufgelaufenerBeitrag = this.mAufgelaufenerBeitrag.add(lElement.getResult());
        }
    }

    private ValuePosition[] sammleValuePosition(ValueType ... vts) throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vts);
    }
}

