/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class PVBeitragsermittlungGleitzone2022Formula {
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mAufgelaufenesGesamtEntgeltAG = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenesGesamtEntgeltAN = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenerBeitrag = BigDecimal.ZERO;

    public PVBeitragsermittlungGleitzone2022Formula(EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, CalculationLibrary calculationLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.mCalLib = calculationLibrary;
        this.mGlLib = globalLibrary;
        this.mEeLib = employeeLibrary;
        this.mVpLib = valuePositionLibrary;
    }

    public void pvbeitraege() throws BusinessDomainException {
        BigDecimal gesBeitrPflEntgeltAG = this.mVpLib.prozentsatz();
        BigDecimal gesBeitrPflEntgeltAN = this.mVpLib.result();
        this.ermittlePVEntgeltImMonat(this.mVpLib.wertartenNummer());
        ValuePosition vp = this.mVpLib.wertPosition();
        boolean AGA100Prozent = BigDecimalMapper.compareTo((BigDecimal)vp.getPerformanceFactor(), (BigDecimal)BigDecimal.valueOf(100L)) == 0;
        vp.setSumOfBasicResult(gesBeitrPflEntgeltAG);
        vp.setSumOfResult(gesBeitrPflEntgeltAN);
        gesBeitrPflEntgeltAG = gesBeitrPflEntgeltAG.add(this.mAufgelaufenesGesamtEntgeltAG);
        gesBeitrPflEntgeltAN = gesBeitrPflEntgeltAN.add(this.mAufgelaufenesGesamtEntgeltAN);
        BigDecimal pvAGA = BigDecimal.ZERO;
        BigDecimal pvANA = BigDecimal.ZERO;
        BigDecimal pvANZusatz = BigDecimal.ZERO;
        if (AGA100Prozent) {
            pvAGA = this.mAufgelaufenesGesamtEntgeltAG.multiply(this.mGlLib.svBsGesamtPV()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            pvAGA = pvAGA.add(this.mAufgelaufenerBeitrag);
            this.mCalLib.pvAGProzentsatz(this.mGlLib.svBsGesamtPV());
            vp.setPerformanceFactor(BigDecimal.ZERO);
        } else {
            BigDecimal vHSatzAna = this.mGlLib.svBsGesamtPV().divide(ZWEI, 4, RoundingMode.HALF_UP);
            BigDecimal vHSatzAga = BigDecimal.ZERO;
            if (this.mGlLib.bundeslandSchluesselBeschaeftigungsort() == 15) {
                vHSatzAga = this.mGlLib.bulaPvAga();
                vHSatzAna = this.mGlLib.svBsGesamtPV().subtract(vHSatzAga);
            } else {
                vHSatzAga = this.mGlLib.svBsGesamtPV().divide(ZWEI, 4, RoundingMode.HALF_UP);
            }
            if (this.mEeLib.marbBgrPv() == 2) {
                vHSatzAna = vHSatzAna.divide(ZWEI, 4, RoundingMode.HALF_UP);
                vHSatzAga = vHSatzAga.divide(ZWEI, 4, RoundingMode.HALF_UP);
            }
            this.mCalLib.pvANProzentsatz(vHSatzAna);
            BigDecimal pvGesamtAN = gesBeitrPflEntgeltAG.multiply(vHSatzAna).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            BigDecimal pvGesamtAG = gesBeitrPflEntgeltAG.multiply(vHSatzAga).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            pvANA = gesBeitrPflEntgeltAN.multiply(vHSatzAna).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            BigDecimal vhSatzPvAnaZusatz = BigDecimal.ZERO;
            if (this.mEeLib.marbAelterDreiUndZwanzig() && !this.mEeLib.isMarbKindErz()) {
                vhSatzPvAnaZusatz = this.mGlLib.svBsKinderlosPV();
            }
            this.mCalLib.pvANZusatzProzentsatz(vhSatzPvAnaZusatz);
            pvANZusatz = gesBeitrPflEntgeltAG.multiply(vhSatzPvAnaZusatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            pvAGA = pvGesamtAN.add(pvGesamtAG).subtract(pvANA);
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)pvANA)) {
                this.mCalLib.pvAGProzentsatz(vHSatzAna.add(vHSatzAga));
            }
        }
        switch (this.mVpLib.wertartenNummer()) {
            case 340514: {
                pvANA = pvANA.subtract(this.mAufgelaufenerBeitrag);
                break;
            }
            case 340518: {
                pvANZusatz = pvANZusatz.subtract(this.mAufgelaufenerBeitrag);
                break;
            }
            case 341514: {
                pvAGA = pvAGA.subtract(this.mAufgelaufenerBeitrag);
                break;
            }
        }
        this.mCalLib.pvANBeitrag(pvANA);
        this.mCalLib.pvANZusatzBeitrag(pvANZusatz);
        this.mCalLib.pvAGBeitrag(pvAGA);
    }

    private void ermittlePVEntgeltImMonat(int valueType) throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition lElement : vpArray = this.sammleValuePosition(ValueTypeHelper.getValueTypes(valueType))) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfBasicResult())) {
                this.mAufgelaufenesGesamtEntgeltAG = this.mAufgelaufenesGesamtEntgeltAG.add(lElement.getSumOfBasicResult());
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) {
                this.mAufgelaufenesGesamtEntgeltAN = this.mAufgelaufenesGesamtEntgeltAN.add(lElement.getSumOfResult());
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfBasicResult()) && BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) continue;
            this.mAufgelaufenerBeitrag = this.mAufgelaufenerBeitrag.add(lElement.getResult());
        }
    }

    private ValuePosition[] sammleValuePosition(ValueType ... vts) throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vts);
    }
}

