/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.evaluation.formula.LohnsteuerErmittlung2022Formula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.serverbase.basictypes.VDate;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class LohnsteuerErmittlung2021Formula {
    protected static final BigDecimal BD5 = BigDecimal.valueOf(5L);
    protected static final BigDecimal BD7 = BigDecimal.valueOf(7L);
    protected static final BigDecimal BD12 = BigDecimal.valueOf(12L);
    protected static final BigDecimal BD100 = BigDecimal.valueOf(100L);
    protected static final BigDecimal BD360 = BigDecimal.valueOf(360L);
    private static final BigDecimal BD500 = BigDecimal.valueOf(500L);
    private static final BigDecimal BD10000 = BigDecimal.valueOf(10000L);
    private static final BigDecimal[][] TABS = new BigDecimal[][]{{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO}, {BigDecimal.ZERO, BigDecimal.valueOf(400L, 3), BigDecimal.valueOf(3000L), BigDecimal.valueOf(900L), BigDecimal.valueOf(400L, 3), BigDecimal.valueOf(1900L)}, {BigDecimal.ZERO, BigDecimal.valueOf(384L, 3), BigDecimal.valueOf(2880L), BigDecimal.valueOf(864L), BigDecimal.valueOf(384L, 3), BigDecimal.valueOf(1824L)}, {BigDecimal.ZERO, BigDecimal.valueOf(368L, 3), BigDecimal.valueOf(2760L), BigDecimal.valueOf(828L), BigDecimal.valueOf(368L, 3), BigDecimal.valueOf(1748L)}, {BigDecimal.ZERO, BigDecimal.valueOf(352L, 3), BigDecimal.valueOf(2640L), BigDecimal.valueOf(792L), BigDecimal.valueOf(352L, 3), BigDecimal.valueOf(1672L)}, {BigDecimal.ZERO, BigDecimal.valueOf(336L, 3), BigDecimal.valueOf(2520L), BigDecimal.valueOf(756L), BigDecimal.valueOf(336L, 3), BigDecimal.valueOf(1596L)}, {BigDecimal.ZERO, BigDecimal.valueOf(320L, 3), BigDecimal.valueOf(2400L), BigDecimal.valueOf(720L), BigDecimal.valueOf(320L, 3), BigDecimal.valueOf(1520L)}, {BigDecimal.ZERO, BigDecimal.valueOf(304L, 3), BigDecimal.valueOf(2280L), BigDecimal.valueOf(684L), BigDecimal.valueOf(304L, 3), BigDecimal.valueOf(1444L)}, {BigDecimal.ZERO, BigDecimal.valueOf(288L, 3), BigDecimal.valueOf(2160L), BigDecimal.valueOf(648L), BigDecimal.valueOf(288L, 3), BigDecimal.valueOf(1368L)}, {BigDecimal.ZERO, BigDecimal.valueOf(272L, 3), BigDecimal.valueOf(2040L), BigDecimal.valueOf(612L), BigDecimal.valueOf(272L, 3), BigDecimal.valueOf(1292L)}, {BigDecimal.ZERO, BigDecimal.valueOf(256L, 3), BigDecimal.valueOf(1920L), BigDecimal.valueOf(576L), BigDecimal.valueOf(256L, 3), BigDecimal.valueOf(1216L)}, {BigDecimal.ZERO, BigDecimal.valueOf(240L, 3), BigDecimal.valueOf(1800L), BigDecimal.valueOf(540L), BigDecimal.valueOf(240L, 3), BigDecimal.valueOf(1140L)}, {BigDecimal.ZERO, BigDecimal.valueOf(224L, 3), BigDecimal.valueOf(1680L), BigDecimal.valueOf(504L), BigDecimal.valueOf(224L, 3), BigDecimal.valueOf(1064L)}, {BigDecimal.ZERO, BigDecimal.valueOf(208L, 3), BigDecimal.valueOf(1560L), BigDecimal.valueOf(468L), BigDecimal.valueOf(208L, 3), BigDecimal.valueOf(988L)}, {BigDecimal.ZERO, BigDecimal.valueOf(192L, 3), BigDecimal.valueOf(1440L), BigDecimal.valueOf(432L), BigDecimal.valueOf(192L, 3), BigDecimal.valueOf(912L)}, {BigDecimal.ZERO, BigDecimal.valueOf(176L, 3), BigDecimal.valueOf(1320L), BigDecimal.valueOf(396L), BigDecimal.valueOf(176L, 3), BigDecimal.valueOf(836L)}, {BigDecimal.ZERO, BigDecimal.valueOf(160L, 3), BigDecimal.valueOf(1200L), BigDecimal.valueOf(360L), BigDecimal.valueOf(160L, 3), BigDecimal.valueOf(760L)}, {BigDecimal.ZERO, BigDecimal.valueOf(152L, 3), BigDecimal.valueOf(1140L), BigDecimal.valueOf(342L), BigDecimal.valueOf(152L, 3), BigDecimal.valueOf(722L)}, {BigDecimal.ZERO, BigDecimal.valueOf(144L, 3), BigDecimal.valueOf(1080L), BigDecimal.valueOf(324L), BigDecimal.valueOf(144L, 3), BigDecimal.valueOf(684L)}, {BigDecimal.ZERO, BigDecimal.valueOf(136L, 3), BigDecimal.valueOf(1020L), BigDecimal.valueOf(306L), BigDecimal.valueOf(136L, 3), BigDecimal.valueOf(646L)}, {BigDecimal.ZERO, BigDecimal.valueOf(128L, 3), BigDecimal.valueOf(960L), BigDecimal.valueOf(288L), BigDecimal.valueOf(128L, 3), BigDecimal.valueOf(608L)}, {BigDecimal.ZERO, BigDecimal.valueOf(120L, 3), BigDecimal.valueOf(900L), BigDecimal.valueOf(270L), BigDecimal.valueOf(120L, 3), BigDecimal.valueOf(570L)}, {BigDecimal.ZERO, BigDecimal.valueOf(112L, 3), BigDecimal.valueOf(840L), BigDecimal.valueOf(252L), BigDecimal.valueOf(112L, 3), BigDecimal.valueOf(532L)}, {BigDecimal.ZERO, BigDecimal.valueOf(104L, 3), BigDecimal.valueOf(780L), BigDecimal.valueOf(234L), BigDecimal.valueOf(104L, 3), BigDecimal.valueOf(494L)}, {BigDecimal.ZERO, BigDecimal.valueOf(96L, 3), BigDecimal.valueOf(720L), BigDecimal.valueOf(216L), BigDecimal.valueOf(96L, 3), BigDecimal.valueOf(456L)}, {BigDecimal.ZERO, BigDecimal.valueOf(88L, 3), BigDecimal.valueOf(660L), BigDecimal.valueOf(198L), BigDecimal.valueOf(88L, 3), BigDecimal.valueOf(418L)}, {BigDecimal.ZERO, BigDecimal.valueOf(80L, 3), BigDecimal.valueOf(600L), BigDecimal.valueOf(180L), BigDecimal.valueOf(80L, 3), BigDecimal.valueOf(380L)}, {BigDecimal.ZERO, BigDecimal.valueOf(72L, 3), BigDecimal.valueOf(540L), BigDecimal.valueOf(162L), BigDecimal.valueOf(72L, 3), BigDecimal.valueOf(342L)}, {BigDecimal.ZERO, BigDecimal.valueOf(64L, 3), BigDecimal.valueOf(480L), BigDecimal.valueOf(144L), BigDecimal.valueOf(64L, 3), BigDecimal.valueOf(304L)}, {BigDecimal.ZERO, BigDecimal.valueOf(56L, 3), BigDecimal.valueOf(420L), BigDecimal.valueOf(126L), BigDecimal.valueOf(56L, 3), BigDecimal.valueOf(266L)}, {BigDecimal.ZERO, BigDecimal.valueOf(48L, 3), BigDecimal.valueOf(360L), BigDecimal.valueOf(108L), BigDecimal.valueOf(48L, 3), BigDecimal.valueOf(228L)}, {BigDecimal.ZERO, BigDecimal.valueOf(40L, 3), BigDecimal.valueOf(300L), BigDecimal.valueOf(90L), BigDecimal.valueOf(40L, 3), BigDecimal.valueOf(190L)}, {BigDecimal.ZERO, BigDecimal.valueOf(32L, 3), BigDecimal.valueOf(240L), BigDecimal.valueOf(72L), BigDecimal.valueOf(32L, 3), BigDecimal.valueOf(152L)}, {BigDecimal.ZERO, BigDecimal.valueOf(24L, 3), BigDecimal.valueOf(180L), BigDecimal.valueOf(54L), BigDecimal.valueOf(24L, 3), BigDecimal.valueOf(114L)}, {BigDecimal.ZERO, BigDecimal.valueOf(16L, 3), BigDecimal.valueOf(120L), BigDecimal.valueOf(36L), BigDecimal.valueOf(16L, 3), BigDecimal.valueOf(76L)}, {BigDecimal.ZERO, BigDecimal.valueOf(8L, 3), BigDecimal.valueOf(60L), BigDecimal.valueOf(18L), BigDecimal.valueOf(8L, 3), BigDecimal.valueOf(38L)}, {BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO}};
    protected final CalculationLibrary callib;
    protected final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private boolean mPauschaleSteuerermittlungATZ_KUG = false;
    private BigDecimal alte_EURO_2NK;
    private BigDecimal anp_EURO_0NK = BigDecimal.ZERO;
    protected BigDecimal anteil1_CENT_0NK = BigDecimal.ZERO;
    private BigDecimal bmg_EURO_2NK;
    private BigDecimal bbgkvpv_EURO_0NK;
    private BigDecimal bbgrv_EURO_0NK;
    private BigDecimal diff_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal efa_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal fvb_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal fvbso_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal fvbz_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal fvbzso_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal gfb_EURO_0NK;
    private BigDecimal hbalte_EURO_0NK;
    private BigDecimal hfvb_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal hfvbz_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal hfvbzso_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal hoch_EURO_0NK = BigDecimal.ZERO;
    private int indexJ = 0;
    private BigDecimal jbmg_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal jlfreib_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal jlhinzu_EURO_2NK = BigDecimal.ZERO;
    protected BigDecimal jw_CENT_0NK = BigDecimal.ZERO;
    private int indexK = 0;
    private int kennvmt = 0;
    private BigDecimal kfb_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal kvsatzag_VHSATZ_5NK = BigDecimal.ZERO;
    private BigDecimal kvsatzan_VHSATZ_5NK = BigDecimal.ZERO;
    private int kztab;
    private BigDecimal lstjahr_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal lst1_CENT_0NK;
    private BigDecimal lst2_CENT_0NK;
    private BigDecimal lst3_CENT_0NK;
    private BigDecimal lstso_CENT_0NK;
    private BigDecimal lstoso_CENT_0NK = BigDecimal.ZERO;
    private BigDecimal mist_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal pvsatzag_VHSATZ_5NK = BigDecimal.ZERO;
    private BigDecimal pvsatzan_VHSATZ_5NK = BigDecimal.ZERO;
    private BigDecimal rvsatzan_VHSATZ_5NK = BigDecimal.ZERO;
    private double rw_double;
    private BigDecimal sap_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal solzfrei_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal solzj_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal solzmin_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal solzsbmg_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal solzszve_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal solzvbmg_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal st_EURO_0NK = BigDecimal.ZERO;
    protected BigDecimal st1_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal st2_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal stovmt_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal tbsvorv_VHSATZ_2NK = BigDecimal.ZERO;
    private BigDecimal vbezb_CENT_0NK;
    private BigDecimal vbezbso_CENT_0NK;
    private BigDecimal vergl_EURO_0NK = BigDecimal.ZERO;
    protected BigDecimal vfrb_CENT_0NK = BigDecimal.ZERO;
    protected BigDecimal vfrbs1_CENT_0NK = BigDecimal.ZERO;
    protected BigDecimal vfrbs2_CENT_0NK = BigDecimal.ZERO;
    private BigDecimal vhb_EURO_2NK;
    private BigDecimal vkv_CENT_0NK;
    private BigDecimal vsp_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal vspn_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal vsp1_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal vsp2_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal vsp3_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal w1stkl5_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal w2stkl5_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal w3stkl5_EURO_0NK = BigDecimal.ZERO;
    protected BigDecimal wvfrb_CENT_0NK = BigDecimal.ZERO;
    protected BigDecimal wvfrbo_CENT_0NK = BigDecimal.ZERO;
    protected BigDecimal wvfrbm_CENT_0NK = BigDecimal.ZERO;
    private BigDecimal x_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal y_6NK = BigDecimal.ZERO;
    private BigDecimal zre4_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal zre4j_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal zre4vp_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal ztabfb_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal zvbez_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal zvbezj_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal zve_EURO_2NK = BigDecimal.ZERO;
    private BigDecimal zx_EURO_0NK = BigDecimal.ZERO;
    private BigDecimal zzx_EURO_0NK = BigDecimal.ZERO;

    public LohnsteuerErmittlung2021Formula(CalculationLibrary calcLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary glLibrary, boolean pauschaleSteuerermittlungATZ_KUG) {
        this.callib = calcLibrary;
        this.eelib = employeeLibrary;
        this.gllib = glLibrary;
        this.mPauschaleSteuerermittlungATZ_KUG = pauschaleSteuerermittlungATZ_KUG;
    }

    public void lst2021() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2022, 0, 1).getDate())) {
            new LohnsteuerErmittlung2022Formula(this.callib, this.eelib, this.gllib, this.mPauschaleSteuerermittlungATZ_KUG).lst2022();
        } else if (this.eelib.stkl() != 0) {
            this.mpara();
            this.mre4jl();
            this.vbezbso_CENT_0NK = BigDecimal.ZERO;
            this.kennvmt = 0;
            this.mre4();
            this.mre4abz();
            this.mberech();
            this.msonst();
            this.mvmt();
        }
    }

    private void mberech() throws BusinessDomainException {
        this.mztabfb();
        this.vfrb_CENT_0NK = this.anp_EURO_0NK.add(this.fvb_EURO_2NK).add(this.fvbz_EURO_0NK).multiply(BD100);
        this.mlstjahr();
        this.wvfrb_CENT_0NK = this.zve_EURO_2NK.subtract(this.gfb_EURO_0NK).multiply(BD100);
        if (this.wvfrb_CENT_0NK.compareTo(BigDecimal.ZERO) < 0) {
            this.wvfrb_CENT_0NK = BigDecimal.ZERO;
        }
        this.lstjahr_EURO_0NK = this.st_EURO_0NK.multiply(this.eelib.faktorF()).setScale(0, RoundingMode.DOWN);
        this.uplstlzz();
        this.upvkvlzz();
        if (this.eelib.zkf().compareTo(BigDecimal.ZERO) > 0) {
            this.ztabfb_EURO_2NK = this.ztabfb_EURO_2NK.add(this.kfb_EURO_0NK);
            this.mre4abz();
            this.mlstjahr();
            this.jbmg_EURO_0NK = this.st_EURO_0NK.multiply(this.eelib.faktorF()).setScale(0, RoundingMode.DOWN);
        } else {
            this.jbmg_EURO_0NK = this.lstjahr_EURO_0NK;
        }
        this.msolz();
    }

    private void mpara() throws BusinessDomainException {
        if (this.gllib.krv() < 2) {
            this.bbgrv_EURO_0NK = this.gllib.krv() == 0 ? BigDecimal.valueOf(85200L, 0) : BigDecimal.valueOf(80400L, 0);
            this.rvsatzan_VHSATZ_5NK = BigDecimal.valueOf(930L, 4);
            this.tbsvorv_VHSATZ_2NK = BigDecimal.valueOf(84L, 2);
        }
        this.bbgkvpv_EURO_0NK = BigDecimal.valueOf(58050L, 0);
        this.kvsatzan_VHSATZ_5NK = this.getKVZ().divide(BigDecimal.valueOf(2L), 5, RoundingMode.DOWN).divide(BD100, 5, RoundingMode.DOWN).add(BigDecimal.valueOf(7L, 2));
        this.kvsatzag_VHSATZ_5NK = BigDecimal.valueOf(65L, 4).add(BigDecimal.valueOf(7L, 2));
        if (this.getPVS() == 1) {
            this.pvsatzan_VHSATZ_5NK = BigDecimal.valueOf(2025L, 5);
            this.pvsatzag_VHSATZ_5NK = BigDecimal.valueOf(1025L, 5);
        } else {
            this.pvsatzan_VHSATZ_5NK = BigDecimal.valueOf(1525L, 5);
            this.pvsatzag_VHSATZ_5NK = BigDecimal.valueOf(1525L, 5);
        }
        if (this.getPVZ() == 1) {
            this.pvsatzan_VHSATZ_5NK = this.pvsatzan_VHSATZ_5NK.add(BigDecimal.valueOf(25L, 4));
        }
        this.w1stkl5_EURO_0NK = BigDecimal.valueOf(11237L, 0);
        this.w2stkl5_EURO_0NK = BigDecimal.valueOf(28959L, 0);
        this.w3stkl5_EURO_0NK = BigDecimal.valueOf(219690L, 0);
        this.gfb_EURO_0NK = BigDecimal.valueOf(9744L, 0);
        this.solzfrei_EURO_0NK = BigDecimal.valueOf(16956L, 0);
    }

    private BigDecimal getKVZ() throws BusinessDomainException {
        if (this.mPauschaleSteuerermittlungATZ_KUG) {
            return this.gllib.getKVBSZusatzversicherung(true);
        }
        return this.eelib.kvz();
    }

    private int getPVZ() throws BusinessDomainException {
        if (this.mPauschaleSteuerermittlungATZ_KUG) {
            return 0;
        }
        return this.eelib.pvz();
    }

    private int getPVS() throws BusinessDomainException {
        if (this.mPauschaleSteuerermittlungATZ_KUG) {
            return 0;
        }
        return this.gllib.pvs();
    }

    private void mre4jl() throws BusinessDomainException {
        if (this.eelib.lzz() == 1) {
            this.zre4j_EURO_2NK = this.callib.re4().divide(BD100, 2, RoundingMode.DOWN);
            this.zvbezj_EURO_2NK = this.callib.vbez().divide(BD100, 2, RoundingMode.DOWN);
            this.jlfreib_EURO_2NK = this.eelib.lzzfreib().divide(BD100, 2, RoundingMode.DOWN);
            this.jlhinzu_EURO_2NK = this.eelib.lzzhinzu().divide(BD100, 2, RoundingMode.DOWN);
        } else if (this.eelib.lzz() == 2) {
            this.zre4j_EURO_2NK = this.callib.re4().multiply(BD12).divide(BD100, 2, RoundingMode.DOWN);
            this.zvbezj_EURO_2NK = this.callib.vbez().multiply(BD12).divide(BD100, 2, RoundingMode.DOWN);
            this.jlfreib_EURO_2NK = this.eelib.lzzfreib().multiply(BD12).divide(BD100, 2, RoundingMode.DOWN);
            this.jlhinzu_EURO_2NK = this.eelib.lzzhinzu().multiply(BD12).divide(BD100, 2, RoundingMode.DOWN);
        } else if (this.eelib.lzz() == 3) {
            this.zre4j_EURO_2NK = this.callib.re4().multiply(BD360).divide(BD7).divide(BD100, 2, RoundingMode.DOWN);
            this.zvbezj_EURO_2NK = this.callib.vbez().multiply(BD360).divide(BD7).divide(BD100, 2, RoundingMode.DOWN);
            this.jlfreib_EURO_2NK = this.eelib.lzzfreib().multiply(BD360).divide(BD7).divide(BD100, 2, RoundingMode.DOWN);
            this.jlhinzu_EURO_2NK = this.eelib.lzzhinzu().multiply(BD360).divide(BD7).divide(BD100, 2, RoundingMode.DOWN);
        } else {
            this.zre4j_EURO_2NK = this.callib.re4().multiply(BD360).divide(BD100, 2, RoundingMode.DOWN);
            this.zvbezj_EURO_2NK = this.callib.vbez().multiply(BD360).divide(BD100, 2, RoundingMode.DOWN);
            this.jlfreib_EURO_2NK = this.eelib.lzzfreib().multiply(BD360).divide(BD100, 2, RoundingMode.DOWN);
            this.jlhinzu_EURO_2NK = this.eelib.lzzhinzu().multiply(BD360).divide(BD100, 2, RoundingMode.DOWN);
        }
        if (this.eelib.af() == 0) {
            this.eelib.faktorF_3NK(BigDecimal.ONE);
        }
    }

    private void mre4() throws BusinessDomainException {
        if (this.zvbezj_EURO_2NK.compareTo(BigDecimal.ZERO) == 0) {
            this.fvbz_EURO_0NK = BigDecimal.ZERO;
            this.fvb_EURO_2NK = BigDecimal.ZERO;
            this.fvbzso_EURO_0NK = BigDecimal.ZERO;
            this.fvbso_EURO_2NK = BigDecimal.ZERO;
        } else {
            this.indexJ = this.eelib.vjahr() < 2006 ? 1 : (this.eelib.vjahr() < 2040 ? this.eelib.vjahr() - 2004 : 36);
            if (this.eelib.lzz() == 1) {
                this.vbezb_CENT_0NK = this.eelib.vbezm().multiply(this.eelib.zmvb()).add(this.eelib.vbezs()).setScale(0, RoundingMode.DOWN);
                this.hfvb_EURO_0NK = TABS[this.indexJ][2].divide(BD12).multiply(this.eelib.zmvb()).setScale(0, RoundingMode.DOWN);
                this.fvbz_EURO_0NK = TABS[this.indexJ][3].divide(BD12).multiply(this.eelib.zmvb()).setScale(0, RoundingMode.UP);
            } else {
                this.vbezb_CENT_0NK = this.eelib.vbezm().multiply(BD12).add(this.eelib.vbezs()).setScale(0, RoundingMode.DOWN);
                this.hfvb_EURO_0NK = TABS[this.indexJ][2].setScale(0, RoundingMode.DOWN);
                this.fvbz_EURO_0NK = TABS[this.indexJ][3].setScale(0, RoundingMode.DOWN);
            }
            this.fvb_EURO_2NK = this.vbezb_CENT_0NK.multiply(TABS[this.indexJ][1]).divide(BD100, 2, RoundingMode.UP);
            if (this.fvb_EURO_2NK.compareTo(this.hfvb_EURO_0NK) > 0) {
                this.fvb_EURO_2NK = this.hfvb_EURO_0NK;
            }
            if (this.fvb_EURO_2NK.compareTo(this.zvbezj_EURO_2NK) > 0) {
                this.fvb_EURO_2NK = this.zvbezj_EURO_2NK;
            }
            this.fvbso_EURO_2NK = this.fvb_EURO_2NK.add(this.vbezbso_CENT_0NK.multiply(TABS[this.indexJ][1]).divide(BD100, 2, RoundingMode.UP));
            if (this.fvbso_EURO_2NK.compareTo(TABS[this.indexJ][2]) > 0) {
                this.fvbso_EURO_2NK = TABS[this.indexJ][2];
            }
            this.hfvbzso_EURO_2NK = this.vbezb_CENT_0NK.add(this.vbezbso_CENT_0NK).divide(BD100, 2, RoundingMode.DOWN).subtract(this.fvbso_EURO_2NK);
            this.fvbzso_EURO_0NK = this.fvbz_EURO_0NK.add(this.vbezbso_CENT_0NK.divide(BD100, 0, RoundingMode.UP));
            if (this.fvbzso_EURO_0NK.compareTo(this.hfvbzso_EURO_2NK) > 0) {
                this.fvbzso_EURO_0NK = this.hfvbzso_EURO_2NK.setScale(0, RoundingMode.UP);
            }
            if (this.fvbzso_EURO_0NK.compareTo(TABS[this.indexJ][3]) > 0) {
                this.fvbzso_EURO_0NK = TABS[this.indexJ][3];
            }
            this.hfvbz_EURO_2NK = this.vbezb_CENT_0NK.divide(BD100, 2, RoundingMode.DOWN).subtract(this.fvb_EURO_2NK);
            if (this.fvbz_EURO_0NK.compareTo(this.hfvbz_EURO_2NK) > 0) {
                this.fvbz_EURO_0NK = this.hfvbz_EURO_2NK.setScale(0, RoundingMode.UP);
            }
        }
        this.mre4alte();
    }

    private void mre4alte() throws BusinessDomainException {
        if (this.eelib.alter1() == 0) {
            this.alte_EURO_2NK = BigDecimal.ZERO;
        } else {
            this.indexK = this.eelib.ajahr() < 2006 ? 1 : (this.eelib.ajahr() < 2040 ? this.eelib.ajahr() - 2004 : 36);
            this.bmg_EURO_2NK = this.zre4j_EURO_2NK.subtract(this.zvbezj_EURO_2NK);
            this.alte_EURO_2NK = this.bmg_EURO_2NK.multiply(TABS[this.indexK][4]).setScale(0, RoundingMode.UP);
            this.hbalte_EURO_0NK = TABS[this.indexK][5].setScale(0, RoundingMode.DOWN);
            if (this.alte_EURO_2NK.compareTo(this.hbalte_EURO_0NK) > 0) {
                this.alte_EURO_2NK = this.hbalte_EURO_0NK;
            }
        }
    }

    private void mre4abz() throws BusinessDomainException {
        this.zre4_EURO_2NK = this.zre4j_EURO_2NK.subtract(this.fvb_EURO_2NK).subtract(this.alte_EURO_2NK).subtract(this.jlfreib_EURO_2NK).add(this.jlhinzu_EURO_2NK);
        if (this.zre4_EURO_2NK.compareTo(BigDecimal.ZERO) < 0) {
            this.zre4_EURO_2NK = BigDecimal.ZERO;
        }
        this.zre4vp_EURO_2NK = this.zre4j_EURO_2NK;
        if (this.kennvmt == 2) {
            this.zre4vp_EURO_2NK = this.zre4vp_EURO_2NK.subtract(this.callib.entsch().divide(BD100, 2, RoundingMode.DOWN));
        }
        this.zvbez_EURO_2NK = this.zvbezj_EURO_2NK.subtract(this.fvb_EURO_2NK);
        if (this.zvbez_EURO_2NK.compareTo(BigDecimal.ZERO) < 0) {
            this.zvbez_EURO_2NK = BigDecimal.ZERO;
        }
    }

    private void mztabfb() throws BusinessDomainException {
        this.anp_EURO_0NK = BigDecimal.ZERO;
        if (this.zvbez_EURO_2NK.compareTo(BigDecimal.ZERO) >= 0 && this.zvbez_EURO_2NK.compareTo(this.fvbz_EURO_0NK) < 0) {
            this.fvbz_EURO_0NK = this.zvbez_EURO_2NK.setScale(0, RoundingMode.DOWN);
        }
        if (this.eelib.stkl() < 6) {
            if (this.zvbez_EURO_2NK.compareTo(BigDecimal.ZERO) > 0) {
                this.anp_EURO_0NK = this.zvbez_EURO_2NK.subtract(this.fvbz_EURO_0NK).compareTo(BigDecimal.valueOf(102L)) < 0 ? this.zvbez_EURO_2NK.subtract(this.fvbz_EURO_0NK).setScale(0, RoundingMode.UP) : BigDecimal.valueOf(102L);
            }
        } else {
            this.fvbz_EURO_0NK = BigDecimal.ZERO;
            this.fvbzso_EURO_0NK = BigDecimal.ZERO;
        }
        if (this.eelib.stkl() < 6 && this.zre4_EURO_2NK.compareTo(this.zvbez_EURO_2NK) > 0) {
            this.anp_EURO_0NK = this.zre4_EURO_2NK.subtract(this.zvbez_EURO_2NK).compareTo(BigDecimal.valueOf(1000L)) < 0 ? this.anp_EURO_0NK.add(this.zre4_EURO_2NK).subtract(this.zvbez_EURO_2NK).setScale(0, RoundingMode.UP) : this.anp_EURO_0NK.add(BigDecimal.valueOf(1000L));
        }
        this.kztab = 1;
        switch (this.eelib.stkl()) {
            case 1: {
                this.sap_EURO_0NK = BigDecimal.valueOf(36L);
                this.kfb_EURO_0NK = this.eelib.zkf().multiply(BigDecimal.valueOf(8388L)).setScale(0, RoundingMode.DOWN);
                break;
            }
            case 2: {
                this.efa_EURO_0NK = BigDecimal.valueOf(1908L);
                this.sap_EURO_0NK = BigDecimal.valueOf(36L);
                this.kfb_EURO_0NK = this.eelib.zkf().multiply(BigDecimal.valueOf(8388L)).setScale(0, RoundingMode.DOWN);
                break;
            }
            case 3: {
                this.kztab = 2;
                this.sap_EURO_0NK = BigDecimal.valueOf(36L);
                this.kfb_EURO_0NK = this.eelib.zkf().multiply(BigDecimal.valueOf(8388L)).setScale(0, RoundingMode.DOWN);
                break;
            }
            case 4: {
                this.sap_EURO_0NK = BigDecimal.valueOf(36L);
                this.kfb_EURO_0NK = this.eelib.zkf().multiply(BigDecimal.valueOf(4194L)).setScale(0, RoundingMode.DOWN);
                break;
            }
            case 5: {
                this.sap_EURO_0NK = BigDecimal.valueOf(36L);
                this.kfb_EURO_0NK = BigDecimal.ZERO;
                break;
            }
            default: {
                this.kfb_EURO_0NK = BigDecimal.ZERO;
            }
        }
        this.ztabfb_EURO_2NK = this.efa_EURO_0NK.add(this.anp_EURO_0NK).add(this.sap_EURO_0NK).add(this.fvbz_EURO_0NK);
    }

    private void mlstjahr() throws BusinessDomainException {
        this.upevp();
        if (this.kennvmt != 1) {
            this.zve_EURO_2NK = this.zre4_EURO_2NK.subtract(this.ztabfb_EURO_2NK).subtract(this.vsp_EURO_2NK);
            this.upmlst();
        } else {
            this.zve_EURO_2NK = this.zre4_EURO_2NK.subtract(this.ztabfb_EURO_2NK).subtract(this.vsp_EURO_2NK).subtract(this.callib.vmt().divide(BD100, 2, RoundingMode.DOWN)).subtract(this.callib.vkapa().divide(BD100, 2, RoundingMode.DOWN));
            if (this.zve_EURO_2NK.compareTo(BigDecimal.ZERO) < 0) {
                this.zve_EURO_2NK = this.zve_EURO_2NK.add(this.callib.vmt().divide(BD100, 2, RoundingMode.DOWN)).add(this.callib.vkapa().divide(BD100, 2, RoundingMode.DOWN)).divide(BD5, 2, RoundingMode.DOWN);
                this.upmlst();
                this.st_EURO_0NK = this.st_EURO_0NK.multiply(BD5).setScale(0, RoundingMode.DOWN);
            } else {
                this.upmlst();
                this.stovmt_EURO_0NK = this.st_EURO_0NK;
                this.zve_EURO_2NK = this.zve_EURO_2NK.add(this.callib.vmt().add(this.callib.vkapa()).divide(BD500, 2, RoundingMode.DOWN));
                this.upmlst();
                this.st_EURO_0NK = this.st_EURO_0NK.subtract(this.stovmt_EURO_0NK).multiply(BD5).add(this.stovmt_EURO_0NK).setScale(0, RoundingMode.DOWN);
            }
        }
    }

    private void upvkvlzz() throws BusinessDomainException {
        this.upvkv();
        this.jw_CENT_0NK = this.vkv_CENT_0NK;
        this.upanteil();
        this.callib.vkvlzz(this.anteil1_CENT_0NK);
    }

    private void upvkv() throws BusinessDomainException {
        this.vkv_CENT_0NK = this.eelib.pkv() > 0 ? (this.vsp2_EURO_2NK.compareTo(this.vsp3_EURO_2NK) > 0 ? this.vsp2_EURO_2NK.multiply(BD100).setScale(0, RoundingMode.DOWN) : this.vsp3_EURO_2NK.multiply(BD100).setScale(0, RoundingMode.DOWN)) : BigDecimal.ZERO;
    }

    private void uplstlzz() {
        this.jw_CENT_0NK = this.lstjahr_EURO_0NK.multiply(BD100).setScale(0, RoundingMode.DOWN);
        this.upanteil();
        this.callib.lstlzz(this.anteil1_CENT_0NK);
    }

    private void upmlst() throws BusinessDomainException {
        if (this.zve_EURO_2NK.compareTo(BigDecimal.ONE) < 0) {
            this.zve_EURO_2NK = BigDecimal.ZERO;
            this.x_EURO_2NK = BigDecimal.ZERO;
        } else {
            this.x_EURO_2NK = this.zve_EURO_2NK.divide(BigDecimal.valueOf(this.kztab), 0, RoundingMode.DOWN);
        }
        if (this.eelib.stkl() < 5) {
            this.uptab21();
        } else {
            this.mst56();
        }
    }

    private void upevp() throws BusinessDomainException {
        if (this.gllib.krv() > 1) {
            this.vsp1_EURO_2NK = BigDecimal.ZERO;
        } else {
            if (this.zre4vp_EURO_2NK.compareTo(this.bbgrv_EURO_0NK) > 0) {
                this.zre4vp_EURO_2NK = this.bbgrv_EURO_0NK;
            }
            this.vsp1_EURO_2NK = this.tbsvorv_VHSATZ_2NK.multiply(this.zre4vp_EURO_2NK).setScale(2, RoundingMode.DOWN);
            this.vsp1_EURO_2NK = this.vsp1_EURO_2NK.multiply(this.rvsatzan_VHSATZ_5NK).setScale(2, RoundingMode.DOWN);
        }
        this.vsp2_EURO_2NK = BigDecimal.valueOf(12L, 2).multiply(this.zre4vp_EURO_2NK).setScale(2, RoundingMode.DOWN);
        this.vhb_EURO_2NK = this.eelib.stkl() == 3 ? BigDecimal.valueOf(3000L) : BigDecimal.valueOf(1900L);
        if (this.vsp2_EURO_2NK.compareTo(this.vhb_EURO_2NK) > 0) {
            this.vsp2_EURO_2NK = this.vhb_EURO_2NK;
        }
        this.vspn_EURO_2NK = this.vsp1_EURO_2NK.add(this.vsp2_EURO_2NK).setScale(0, RoundingMode.UP);
        this.mvsp();
        if (this.vspn_EURO_2NK.compareTo(this.vsp_EURO_2NK) > 0) {
            this.vsp_EURO_2NK = this.vspn_EURO_2NK;
        }
    }

    private void mvsp() throws BusinessDomainException {
        if (this.zre4vp_EURO_2NK.compareTo(this.bbgkvpv_EURO_0NK) > 0) {
            this.zre4vp_EURO_2NK = this.bbgkvpv_EURO_0NK;
        }
        if (this.mPauschaleSteuerermittlungATZ_KUG) {
            this.vsp3_EURO_2NK = this.zre4vp_EURO_2NK.multiply(this.kvsatzan_VHSATZ_5NK.add(this.pvsatzan_VHSATZ_5NK)).setScale(2, RoundingMode.DOWN);
        } else if (this.eelib.pkv() > 0) {
            if (this.eelib.stkl() == 6) {
                this.vsp3_EURO_2NK = BigDecimal.ZERO;
            } else {
                this.vsp3_EURO_2NK = this.eelib.pkpv().multiply(BD12).divide(BD100, 2, RoundingMode.DOWN);
                if (this.eelib.pkv() == 2) {
                    this.vsp3_EURO_2NK = this.vsp3_EURO_2NK.subtract(this.zre4vp_EURO_2NK.multiply(this.kvsatzag_VHSATZ_5NK.add(this.pvsatzag_VHSATZ_5NK)).setScale(2, RoundingMode.DOWN));
                }
            }
        } else {
            this.vsp3_EURO_2NK = this.zre4vp_EURO_2NK.multiply(this.kvsatzan_VHSATZ_5NK.add(this.pvsatzan_VHSATZ_5NK)).setScale(2, RoundingMode.DOWN);
        }
        this.vsp_EURO_2NK = this.vsp3_EURO_2NK.add(this.vsp1_EURO_2NK).setScale(0, RoundingMode.UP);
    }

    private void mst56() {
        this.zzx_EURO_0NK = this.x_EURO_2NK.setScale(0, RoundingMode.DOWN);
        if (this.zzx_EURO_0NK.compareTo(this.w2stkl5_EURO_0NK) > 0) {
            this.zx_EURO_0NK = this.w2stkl5_EURO_0NK;
            this.up56();
            if (this.zzx_EURO_0NK.compareTo(this.w3stkl5_EURO_0NK) > 0) {
                this.st_EURO_0NK = this.st_EURO_0NK.add(this.w3stkl5_EURO_0NK.subtract(this.w2stkl5_EURO_0NK).multiply(BigDecimal.valueOf(42L, 2)).setScale(0, RoundingMode.DOWN));
                this.st_EURO_0NK = this.st_EURO_0NK.add(this.zzx_EURO_0NK.subtract(this.w3stkl5_EURO_0NK).multiply(BigDecimal.valueOf(45L, 2))).setScale(0, RoundingMode.DOWN);
            } else {
                this.st_EURO_0NK = this.st_EURO_0NK.add(this.zzx_EURO_0NK.subtract(this.w2stkl5_EURO_0NK).multiply(BigDecimal.valueOf(42L, 2))).setScale(0, RoundingMode.DOWN);
            }
        } else {
            this.zx_EURO_0NK = this.zzx_EURO_0NK;
            this.up56();
            if (this.zzx_EURO_0NK.compareTo(this.w1stkl5_EURO_0NK) > 0) {
                this.vergl_EURO_0NK = this.st_EURO_0NK;
                this.zx_EURO_0NK = this.w1stkl5_EURO_0NK;
                this.up56();
                this.hoch_EURO_0NK = this.st_EURO_0NK.add(this.zzx_EURO_0NK.subtract(this.w1stkl5_EURO_0NK).multiply(BigDecimal.valueOf(42L, 2))).setScale(0, RoundingMode.DOWN);
                this.st_EURO_0NK = this.hoch_EURO_0NK.compareTo(this.vergl_EURO_0NK) < 0 ? this.hoch_EURO_0NK : this.vergl_EURO_0NK;
            }
        }
    }

    private void up56() {
        this.x_EURO_2NK = this.zx_EURO_0NK.multiply(BigDecimal.valueOf(125L, 2)).setScale(2, RoundingMode.DOWN);
        this.uptab21();
        this.st1_EURO_0NK = this.st_EURO_0NK;
        this.x_EURO_2NK = this.zx_EURO_0NK.multiply(BigDecimal.valueOf(75L, 2)).setScale(2, RoundingMode.DOWN);
        this.uptab21();
        this.st2_EURO_0NK = this.st_EURO_0NK;
        this.diff_EURO_0NK = this.st1_EURO_0NK.subtract(this.st2_EURO_0NK).multiply(BigDecimal.valueOf(2L)).setScale(0, RoundingMode.DOWN);
        this.mist_EURO_0NK = this.zx_EURO_0NK.multiply(BigDecimal.valueOf(14L, 2)).setScale(0, RoundingMode.DOWN);
        this.st_EURO_0NK = this.mist_EURO_0NK.compareTo(this.diff_EURO_0NK) > 0 ? this.mist_EURO_0NK : this.diff_EURO_0NK;
    }

    private void msolz() throws BusinessDomainException {
        this.solzfrei_EURO_0NK = this.solzfrei_EURO_0NK.multiply(BigDecimal.valueOf(this.kztab));
        if (this.jbmg_EURO_0NK.compareTo(this.solzfrei_EURO_0NK) > 0) {
            this.solzj_EURO_2NK = this.jbmg_EURO_0NK.multiply(BigDecimal.valueOf(55L, 1)).divide(BD100, 2, RoundingMode.DOWN);
            this.solzmin_EURO_2NK = this.jbmg_EURO_0NK.subtract(this.solzfrei_EURO_0NK).multiply(BigDecimal.valueOf(119L, 1)).divide(BD100, 2, RoundingMode.DOWN);
            if (this.solzmin_EURO_2NK.compareTo(this.solzj_EURO_2NK) < 0) {
                this.solzj_EURO_2NK = this.solzmin_EURO_2NK;
            }
            this.jw_CENT_0NK = this.solzj_EURO_2NK.multiply(BD100).setScale(0, RoundingMode.DOWN);
            this.upanteil();
            this.callib.solzlzz(this.anteil1_CENT_0NK);
        } else {
            this.callib.solzlzz(BigDecimal.ZERO);
        }
        if (this.eelib.r() > 0) {
            this.jw_CENT_0NK = this.jbmg_EURO_0NK.multiply(BD100);
            this.upanteil();
            this.callib.bk(this.anteil1_CENT_0NK);
        } else {
            this.callib.bk(BigDecimal.ZERO);
        }
    }

    private void upanteil() {
        switch (this.eelib.lzz()) {
            case 1: {
                this.anteil1_CENT_0NK = this.jw_CENT_0NK;
                break;
            }
            case 2: {
                this.anteil1_CENT_0NK = this.jw_CENT_0NK.divide(BD12, 0, RoundingMode.DOWN);
                break;
            }
            case 3: {
                this.anteil1_CENT_0NK = this.jw_CENT_0NK.multiply(BD7).divide(BD360, 0, RoundingMode.DOWN);
                break;
            }
            default: {
                this.anteil1_CENT_0NK = this.jw_CENT_0NK.divide(BD360, 0, RoundingMode.DOWN);
            }
        }
    }

    private void msonst() throws BusinessDomainException {
        this.eelib.lzz(1);
        if (this.eelib.zmvb().compareTo(BigDecimal.ZERO) == 0) {
            this.eelib.zmvb(BD12);
        }
        if (this.callib.sonstb().compareTo(BigDecimal.ZERO) == 0) {
            this.callib.vkvsonst(BigDecimal.ZERO);
            this.lstso_CENT_0NK = BigDecimal.ZERO;
            this.callib.sts(BigDecimal.ZERO);
            this.callib.solzs(BigDecimal.ZERO);
            this.callib.bks(BigDecimal.ZERO);
        } else {
            this.mosonst();
            this.upvkv();
            this.callib.vkvsonst(this.vkv_CENT_0NK);
            this.zre4j_EURO_2NK = this.callib.jre4().add(this.callib.sonstb()).divide(BD100, 2, RoundingMode.DOWN);
            this.zvbezj_EURO_2NK = this.callib.jvbez().add(this.callib.vbs()).divide(BD100, 2, RoundingMode.DOWN);
            this.vbezbso_CENT_0NK = this.callib.sterbe();
            this.mre4sonst();
            this.mlstjahr();
            this.wvfrbm_CENT_0NK = this.zve_EURO_2NK.subtract(this.gfb_EURO_0NK).multiply(BD100);
            if (this.wvfrbm_CENT_0NK.compareTo(BigDecimal.ZERO) < 0) {
                this.wvfrbm_CENT_0NK = BigDecimal.ZERO;
            }
            this.upvkv();
            this.callib.vkvsonst(this.vkv_CENT_0NK.subtract(this.callib.vkvsonst()));
            this.lstso_CENT_0NK = this.st_EURO_0NK.multiply(BD100);
            this.callib.sts(this.lstso_CENT_0NK.subtract(this.lstoso_CENT_0NK).multiply(this.eelib.faktorF()).divide(BD100, 0, RoundingMode.DOWN).multiply(BD100));
            if (this.callib.sts().compareTo(BigDecimal.ZERO) < 0 && !this.eelib.negativeSteuerMoeglich()) {
                this.callib.sts(BigDecimal.ZERO);
            }
            this.msolzsts();
            if (this.eelib.r() > 0) {
                this.callib.bks(this.callib.sts());
            } else {
                this.callib.bks(BigDecimal.ZERO);
            }
        }
    }

    private void msolzsts() throws BusinessDomainException {
        this.solzszve_EURO_2NK = this.eelib.zkf().compareTo(BigDecimal.ZERO) > 0 ? this.zve_EURO_2NK.subtract(this.kfb_EURO_0NK) : this.zve_EURO_2NK;
        if (this.solzszve_EURO_2NK.compareTo(BigDecimal.ONE) < 0) {
            this.solzszve_EURO_2NK = BigDecimal.ZERO;
            this.x_EURO_2NK = BigDecimal.ZERO;
        } else {
            this.x_EURO_2NK = this.solzszve_EURO_2NK.divide(BigDecimal.valueOf(this.kztab), 0, RoundingMode.DOWN);
        }
        if (this.eelib.stkl() < 5) {
            this.uptab21();
        } else {
            this.mst56();
        }
        this.solzsbmg_EURO_0NK = this.st_EURO_0NK.multiply(this.eelib.faktorF()).setScale(0, RoundingMode.DOWN);
        if (this.solzsbmg_EURO_0NK.compareTo(this.solzfrei_EURO_0NK) > 0) {
            this.callib.solzs(this.callib.sts().multiply(BigDecimal.valueOf(55L, 1)).divide(BD100, 0, RoundingMode.DOWN));
        } else {
            this.callib.solzs(BigDecimal.ZERO);
        }
    }

    private void mvmt() throws BusinessDomainException {
        if (this.callib.vkapa().compareTo(BigDecimal.ZERO) < 0) {
            this.callib.vkapa(BigDecimal.ZERO);
        }
        if (this.callib.vmt().add(this.callib.vkapa()).compareTo(BigDecimal.ZERO) > 0) {
            if (this.lstso_CENT_0NK.compareTo(BigDecimal.ZERO) == 0) {
                this.mosonst();
                this.lst1_CENT_0NK = this.lstoso_CENT_0NK;
            } else {
                this.lst1_CENT_0NK = this.lstso_CENT_0NK;
            }
            this.vbezbso_CENT_0NK = this.callib.sterbe().add(this.callib.vkapa());
            this.zre4j_EURO_2NK = this.callib.jre4().add(this.callib.sonstb()).add(this.callib.vmt()).add(this.callib.vkapa()).divide(BD100, 2, RoundingMode.DOWN);
            this.zvbezj_EURO_2NK = this.callib.jvbez().add(this.callib.vbs()).add(this.callib.vkapa()).divide(BD100, 2, RoundingMode.DOWN);
            this.kennvmt = 2;
            this.mre4sonst();
            this.mlstjahr();
            this.lst3_CENT_0NK = this.st_EURO_0NK.multiply(BD100);
            this.mre4abz();
            this.zre4vp_EURO_2NK = this.zre4vp_EURO_2NK.subtract(this.callib.jre4ent().divide(BD100, 2, RoundingMode.DOWN)).subtract(this.callib.sonstent().divide(BD100, 2, RoundingMode.DOWN));
            this.kennvmt = 1;
            this.mlstjahr();
            this.lst2_CENT_0NK = this.st_EURO_0NK.multiply(BD100);
            this.callib.stv(this.lst2_CENT_0NK.subtract(this.lst1_CENT_0NK));
            this.lst3_CENT_0NK = this.lst3_CENT_0NK.subtract(this.lst1_CENT_0NK);
            if (this.lst3_CENT_0NK.compareTo(this.callib.stv()) < 0) {
                this.callib.nichtErmaessigt(true);
                this.callib.stv(this.lst3_CENT_0NK);
            }
            if (this.callib.stv().compareTo(BigDecimal.ZERO) < 0) {
                this.callib.stv(BigDecimal.ZERO);
            } else {
                this.callib.stv(this.callib.stv().multiply(this.eelib.faktorF()).divide(BD100, 0, RoundingMode.DOWN).multiply(BD100));
            }
            this.solzvbmg_EURO_0NK = this.callib.stv().divide(BD100, 0, RoundingMode.DOWN).add(this.jbmg_EURO_0NK);
            if (this.solzvbmg_EURO_0NK.compareTo(this.solzfrei_EURO_0NK) > 0) {
                this.callib.solzv(this.callib.stv().multiply(BigDecimal.valueOf(55L, 1)).divide(BD100, 0, RoundingMode.DOWN));
            } else {
                this.callib.solzv(BigDecimal.ZERO);
            }
            if (this.eelib.r() > 0) {
                this.callib.bkv(this.callib.stv());
            } else {
                this.callib.bkv(BigDecimal.ZERO);
            }
        } else {
            this.callib.stv(BigDecimal.ZERO);
            this.callib.solzv(BigDecimal.ZERO);
            this.callib.bkv(BigDecimal.ZERO);
        }
    }

    private void mosonst() throws BusinessDomainException {
        this.zre4j_EURO_2NK = this.callib.jre4().divide(BD100, 2, RoundingMode.DOWN);
        this.zvbezj_EURO_2NK = this.callib.jvbez().divide(BD100, 2, RoundingMode.DOWN);
        this.jlfreib_EURO_2NK = this.eelib.jfreib().divide(BD100, 2, RoundingMode.DOWN);
        this.jlhinzu_EURO_2NK = this.eelib.jhinzu().divide(BD100, 2, RoundingMode.DOWN);
        this.mre4();
        this.mre4abz();
        this.zre4vp_EURO_2NK = this.zre4vp_EURO_2NK.subtract(this.callib.jre4ent().divide(BD100, 2, RoundingMode.DOWN));
        this.mztabfb();
        this.vfrbs1_CENT_0NK = this.anp_EURO_0NK.add(this.fvb_EURO_2NK).add(this.fvbz_EURO_0NK).multiply(BD100);
        this.mlstjahr();
        this.wvfrbo_CENT_0NK = this.zve_EURO_2NK.subtract(this.gfb_EURO_0NK).multiply(BD100);
        if (this.wvfrbo_CENT_0NK.compareTo(BigDecimal.ZERO) < 0) {
            this.wvfrbo_CENT_0NK = BigDecimal.ZERO;
        }
        this.lstoso_CENT_0NK = this.st_EURO_0NK.multiply(BD100);
    }

    private void mre4sonst() throws BusinessDomainException {
        this.mre4();
        this.fvb_EURO_2NK = this.fvbso_EURO_2NK;
        this.mre4abz();
        this.zre4vp_EURO_2NK = this.zre4vp_EURO_2NK.subtract(this.callib.jre4ent().divide(BD100, 2, RoundingMode.DOWN)).subtract(this.callib.sonstent().divide(BD100, 2, RoundingMode.DOWN));
        this.fvbz_EURO_0NK = this.fvbzso_EURO_0NK;
        this.mztabfb();
        this.vfrbs2_CENT_0NK = this.anp_EURO_0NK.add(this.fvb_EURO_2NK).add(this.fvbz_EURO_0NK).multiply(BD100).subtract(this.vfrbs1_CENT_0NK);
    }

    private void uptab21() {
        if (this.x_EURO_2NK.compareTo(this.gfb_EURO_0NK.add(BigDecimal.ONE)) < 0) {
            this.st_EURO_0NK = BigDecimal.ZERO;
        } else if (this.x_EURO_2NK.compareTo(BigDecimal.valueOf(14754L)) < 0) {
            this.y_6NK = this.x_EURO_2NK.subtract(this.gfb_EURO_0NK).divide(BD10000, 6, RoundingMode.DOWN);
            this.rw_double = this.y_6NK.multiply(BigDecimal.valueOf(99521L, 2)).doubleValue();
            this.rw_double += 1400.0;
            this.st_EURO_0NK = new BigDecimal(this.rw_double).multiply(this.y_6NK).setScale(0, RoundingMode.DOWN);
        } else if (this.x_EURO_2NK.compareTo(BigDecimal.valueOf(57919L)) < 0) {
            this.y_6NK = this.x_EURO_2NK.subtract(BigDecimal.valueOf(14753L)).divide(BD10000, 6, RoundingMode.DOWN);
            this.rw_double = this.y_6NK.multiply(BigDecimal.valueOf(20885L, 2)).doubleValue();
            this.rw_double += 2397.0;
            this.rw_double *= this.y_6NK.doubleValue();
            this.st_EURO_0NK = new BigDecimal(this.rw_double).add(BigDecimal.valueOf(95096L, 2)).setScale(0, RoundingMode.DOWN);
        } else {
            this.st_EURO_0NK = this.x_EURO_2NK.compareTo(BigDecimal.valueOf(274613L)) < 0 ? this.x_EURO_2NK.multiply(BigDecimal.valueOf(42L, 2)).subtract(BigDecimal.valueOf(913663L, 2)).setScale(0, RoundingMode.DOWN) : this.x_EURO_2NK.multiply(BigDecimal.valueOf(45L, 2)).subtract(BigDecimal.valueOf(1737499L, 2)).setScale(0, RoundingMode.DOWN);
        }
        this.st_EURO_0NK = this.st_EURO_0NK.multiply(BigDecimal.valueOf(this.kztab));
    }
}

