/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.KVBeitragsermittlungGleitzone2022Formula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class KVBeitragsermittlungGleitzoneFormula {
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private BigDecimal mAufgelaufenesGesamtEntgelt = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenesFiktivesEntgelt = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenerBeitrag = BigDecimal.ZERO;
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;

    public KVBeitragsermittlungGleitzoneFormula(EmployeeLibrary eelib, GlobalLibrary gllib, CalculationLibrary callib, ValuePositionLibrary vplib) {
        this.mCalLib = callib;
        this.mGlLib = gllib;
        this.mEeLib = eelib;
        this.mVpLib = vplib;
    }

    public void kvbeitraege() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2022, 9, 1).getDate()) && !this.mEeLib.kennzBestandGleitzone2022()) {
            new KVBeitragsermittlungGleitzone2022Formula(this.mEeLib, this.mGlLib, this.mCalLib, this.mVpLib).kvbeitraege();
        } else {
            BigDecimal gesBeitrPflEntgelt = this.mVpLib.prozentsatz();
            BigDecimal fiktivesBeitrPflEntgelt = this.mVpLib.result();
            this.ermittleKVEntgeltImMonat(this.mVpLib.wertartenNummer());
            ValuePosition vp = this.mVpLib.wertPosition();
            boolean AGA100Prozent = BigDecimalMapper.compareTo((BigDecimal)vp.getPerformanceFactor(), (BigDecimal)BigDecimal.valueOf(100L)) == 0;
            vp.setSumOfBasicResult(gesBeitrPflEntgelt);
            vp.setSumOfResult(fiktivesBeitrPflEntgelt);
            gesBeitrPflEntgelt = gesBeitrPflEntgelt.add(this.mAufgelaufenesGesamtEntgelt);
            fiktivesBeitrPflEntgelt = fiktivesBeitrPflEntgelt.add(this.mAufgelaufenesFiktivesEntgelt);
            BigDecimal kvBeitragssatz = this.mGlLib.krkBsNachBGSKV(this.mEeLib.marbBgrKv());
            BigDecimal kvVHSatz = BigDecimal.ZERO;
            BigDecimal kvAnaZusatzVHSatz = BigDecimal.ZERO;
            BigDecimal kvAgaZusatzVHSatz = BigDecimal.ZERO;
            if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                kvAnaZusatzVHSatz = this.mGlLib.getKVANABSZusatzversicherung(false);
                kvAgaZusatzVHSatz = this.mGlLib.getKVAGABSZusatzversicherung(false);
            } else {
                kvAnaZusatzVHSatz = this.mGlLib.getKVBSZusatzversicherung(false);
            }
            BigDecimal kvANZusatz = BigDecimal.ZERO;
            BigDecimal kvAGZusatz = BigDecimal.ZERO;
            BigDecimal kvAGA = BigDecimal.ZERO;
            BigDecimal kvANA = BigDecimal.ZERO;
            if (AGA100Prozent) {
                switch (this.mVpLib.wertartenNummer()) {
                    case 323514: {
                        kvVHSatz = kvBeitragssatz;
                        kvAGA = kvAGA.add(this.mVpLib.prozentsatz().multiply(kvVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
                        kvAGA = kvAGA.add(this.mAufgelaufenerBeitrag);
                        break;
                    }
                    case 323516: {
                        kvAgaZusatzVHSatz = kvAgaZusatzVHSatz.add(kvAnaZusatzVHSatz);
                        kvAGZusatz = kvAGZusatz.add(this.mVpLib.prozentsatz().multiply(kvAgaZusatzVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
                        kvAGZusatz = kvAGZusatz.add(this.mAufgelaufenerBeitrag);
                        break;
                    }
                }
                vp.setPerformanceFactor(BigDecimal.ZERO);
            } else {
                kvVHSatz = kvBeitragssatz.divide(ZWEI, 3, RoundingMode.HALF_UP);
                kvAGA = gesBeitrPflEntgelt.multiply(kvVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)kvAgaZusatzVHSatz)) {
                    kvAGZusatz = gesBeitrPflEntgelt.multiply(kvAgaZusatzVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                }
                if (DateHelper.between((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate(), (Date)new VDate(2014, 11, 31).getDate())) {
                    BigDecimal kvGesamtbeitrag = fiktivesBeitrPflEntgelt.multiply(kvBeitragssatz.add(kvAnaZusatzVHSatz)).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                    kvANA = kvGesamtbeitrag.subtract(kvAGA);
                } else {
                    kvANA = fiktivesBeitrPflEntgelt.multiply(kvVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                    kvANA = kvANA.multiply(ZWEI).subtract(kvAGA).setScale(2);
                    kvANZusatz = fiktivesBeitrPflEntgelt.multiply(kvAnaZusatzVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                    if (!BigDecimalMapper.isZero((BigDecimal)kvAGZusatz)) {
                        kvANZusatz = kvANZusatz.multiply(ZWEI).subtract(kvAGZusatz).setScale(2);
                    }
                }
            }
            boolean isKvAGAgekuerzt = false;
            if (kvANA.compareTo(BigDecimal.ZERO) < 0) {
                kvAGA = kvAGA.add(kvANA);
                kvANA = BigDecimal.ZERO;
                kvAGZusatz = kvAGZusatz.add(kvANZusatz);
                kvANZusatz = BigDecimal.ZERO;
                isKvAGAgekuerzt = true;
            }
            switch (this.mVpLib.wertartenNummer()) {
                case 322514: {
                    kvANA = kvANA.subtract(this.mAufgelaufenerBeitrag);
                    break;
                }
                case 322518: {
                    kvANZusatz = kvANZusatz.subtract(this.mAufgelaufenerBeitrag);
                    break;
                }
                case 323514: {
                    kvAGA = kvAGA.subtract(this.mAufgelaufenerBeitrag);
                    break;
                }
                case 323516: {
                    kvAGZusatz = kvAGZusatz.subtract(this.mAufgelaufenerBeitrag);
                    break;
                }
            }
            if (gesBeitrPflEntgelt.compareTo(BigDecimal.ZERO) == 0) {
                this.mCalLib.kvAGPercentage(BigDecimal.ZERO);
                this.mCalLib.kvANPercentage(BigDecimal.ZERO);
                this.mCalLib.kvANZusatzPercentage(BigDecimal.ZERO);
                this.mCalLib.kvAGZusatzPercentage(BigDecimal.ZERO);
            } else {
                if (isKvAGAgekuerzt) {
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.prozentsatz())) {
                        this.mCalLib.kvAGPercentage(kvAGA.multiply(EINHUNDERT).divide(this.mVpLib.prozentsatz(), 3, RoundingMode.HALF_UP));
                    }
                } else {
                    this.mCalLib.kvAGPercentage(kvVHSatz);
                }
                if (DateHelper.between((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate(), (Date)new VDate(2014, 11, 31).getDate())) {
                    this.mCalLib.kvANZusatzPercentage(BigDecimal.ZERO);
                } else if (DateHelper.before((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate())) {
                    this.mCalLib.kvANZusatzPercentage(kvAnaZusatzVHSatz);
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)kvAgaZusatzVHSatz)) {
                        this.mCalLib.kvAGZusatzPercentage(kvAgaZusatzVHSatz);
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.prozentsatz())) {
                            this.mCalLib.kvANZusatzPercentage(kvANZusatz.multiply(EINHUNDERT).divide(this.mVpLib.prozentsatz(), 3, RoundingMode.HALF_UP));
                        }
                    }
                } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)kvAgaZusatzVHSatz)) {
                    this.mCalLib.kvAGZusatzPercentage(kvAgaZusatzVHSatz);
                }
                if (DateHelper.before((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate()) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.prozentsatz())) {
                    this.mCalLib.kvANPercentage(kvANA.multiply(EINHUNDERT).divide(this.mVpLib.prozentsatz(), 3, RoundingMode.HALF_UP));
                }
            }
            this.mCalLib.kvAGBeitrag(kvAGA);
            this.mCalLib.kvANBeitrag(kvANA);
            this.mCalLib.kvANZusatzBeitrag(kvANZusatz);
            this.mCalLib.kvAGZusatzBeitrag(kvAGZusatz);
        }
    }

    private void ermittleKVEntgeltImMonat(int valueType) throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition lElement : vpArray = this.sammleValuePosition(ValueTypeHelper.getValueTypes(valueType))) {
            if (lElement.getSumOfBasicResult() != null) {
                this.mAufgelaufenesGesamtEntgelt = this.mAufgelaufenesGesamtEntgelt.add(lElement.getSumOfBasicResult());
            }
            if (lElement.getSumOfResult() == null) continue;
            this.mAufgelaufenesFiktivesEntgelt = this.mAufgelaufenesFiktivesEntgelt.add(lElement.getSumOfResult());
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) continue;
            this.mAufgelaufenerBeitrag = this.mAufgelaufenerBeitrag.add(lElement.getResult());
        }
    }

    private ValuePosition[] sammleValuePosition(ValueType ... vts) throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vts);
    }
}

