/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class KVBeitragsermittlungGleitzone2022Formula {
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mAufgelaufenesEntgeltAG = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenesEntgeltAN = BigDecimal.ZERO;
    private BigDecimal mAufgelaufenerBeitrag = BigDecimal.ZERO;

    public KVBeitragsermittlungGleitzone2022Formula(EmployeeLibrary eelib, GlobalLibrary gllib, CalculationLibrary callib, ValuePositionLibrary vplib) {
        this.mCalLib = callib;
        this.mGlLib = gllib;
        this.mEeLib = eelib;
        this.mVpLib = vplib;
    }

    public void kvbeitraege() throws BusinessDomainException {
        BigDecimal gesBeitrPflEntgeltAG = this.mVpLib.prozentsatz();
        BigDecimal gesBeitrPflEntgeltAN = this.mVpLib.result();
        this.ermittleKVEntgeltImMonat(this.mVpLib.wertartenNummer());
        ValuePosition vp = this.mVpLib.wertPosition();
        boolean AGA100Prozent = BigDecimalMapper.compareTo((BigDecimal)vp.getPerformanceFactor(), (BigDecimal)BigDecimal.valueOf(100L)) == 0;
        vp.setSumOfBasicResult(gesBeitrPflEntgeltAG);
        vp.setSumOfResult(gesBeitrPflEntgeltAN);
        gesBeitrPflEntgeltAG = gesBeitrPflEntgeltAG.add(this.mAufgelaufenesEntgeltAG);
        gesBeitrPflEntgeltAN = gesBeitrPflEntgeltAN.add(this.mAufgelaufenesEntgeltAN);
        BigDecimal kvBeitragssatz = this.mGlLib.krkBsNachBGSKV(this.mEeLib.marbBgrKv());
        BigDecimal kvAnaZusatzVHSatz = BigDecimal.ZERO;
        BigDecimal kvAgaZusatzVHSatz = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
            kvAnaZusatzVHSatz = this.mGlLib.getKVANABSZusatzversicherung(false);
            kvAgaZusatzVHSatz = this.mGlLib.getKVAGABSZusatzversicherung(false);
        } else {
            kvAnaZusatzVHSatz = this.mGlLib.getKVBSZusatzversicherung(false);
        }
        BigDecimal kvANZusatz = BigDecimal.ZERO;
        BigDecimal kvAGZusatz = BigDecimal.ZERO;
        BigDecimal kvAGA = BigDecimal.ZERO;
        BigDecimal kvANA = BigDecimal.ZERO;
        if (AGA100Prozent) {
            switch (this.mVpLib.wertartenNummer()) {
                case 323514: {
                    kvAGA = gesBeitrPflEntgeltAG.multiply(kvBeitragssatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                    kvAGA = kvAGA.add(this.mAufgelaufenerBeitrag);
                    break;
                }
                case 323516: {
                    kvAGZusatz = gesBeitrPflEntgeltAG.multiply(kvAgaZusatzVHSatz.add(kvAnaZusatzVHSatz)).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                    kvAGZusatz = kvAGZusatz.add(this.mAufgelaufenerBeitrag);
                    break;
                }
            }
            this.mCalLib.kvAGPercentage(kvBeitragssatz);
            this.mCalLib.kvAGZusatzPercentage(kvAgaZusatzVHSatz.add(kvAnaZusatzVHSatz));
            vp.setPerformanceFactor(BigDecimal.ZERO);
        } else {
            BigDecimal kvVHSatz = kvBeitragssatz.divide(ZWEI, 3, RoundingMode.HALF_UP);
            this.mCalLib.kvANPercentage(kvVHSatz);
            BigDecimal kvGesamt = gesBeitrPflEntgeltAG.multiply(kvVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            kvGesamt = kvGesamt.multiply(ZWEI);
            kvANA = gesBeitrPflEntgeltAN.multiply(kvVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            kvAGA = kvGesamt.subtract(kvANA).setScale(2);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)kvAgaZusatzVHSatz) || !BigDecimalMapper.isZeroOrNull((BigDecimal)kvAnaZusatzVHSatz)) {
                this.mCalLib.kvANZusatzPercentage(kvAnaZusatzVHSatz);
                BigDecimal kvZusatzGesamtAN = gesBeitrPflEntgeltAG.multiply(kvAnaZusatzVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                BigDecimal kvZusatzGesamtAG = gesBeitrPflEntgeltAG.multiply(kvAgaZusatzVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                kvANZusatz = gesBeitrPflEntgeltAN.multiply(kvAnaZusatzVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                kvAGZusatz = kvZusatzGesamtAN.add(kvZusatzGesamtAG).subtract(kvANZusatz);
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)kvANA)) {
                this.mCalLib.kvAGPercentage(kvBeitragssatz);
                this.mCalLib.kvAGZusatzPercentage(kvAgaZusatzVHSatz.add(kvAnaZusatzVHSatz));
            }
        }
        switch (this.mVpLib.wertartenNummer()) {
            case 322514: {
                kvANA = kvANA.subtract(this.mAufgelaufenerBeitrag);
                break;
            }
            case 322518: {
                kvANZusatz = kvANZusatz.subtract(this.mAufgelaufenerBeitrag);
                break;
            }
            case 323514: {
                kvAGA = kvAGA.subtract(this.mAufgelaufenerBeitrag);
                break;
            }
            case 323516: {
                kvAGZusatz = kvAGZusatz.subtract(this.mAufgelaufenerBeitrag);
                break;
            }
        }
        this.mCalLib.kvAGBeitrag(kvAGA);
        this.mCalLib.kvANBeitrag(kvANA);
        this.mCalLib.kvANZusatzBeitrag(kvANZusatz);
        this.mCalLib.kvAGZusatzBeitrag(kvAGZusatz);
    }

    private void ermittleKVEntgeltImMonat(int valueType) throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition lElement : vpArray = this.sammleValuePosition(ValueTypeHelper.getValueTypes(valueType))) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfBasicResult())) {
                this.mAufgelaufenesEntgeltAG = this.mAufgelaufenesEntgeltAG.add(lElement.getSumOfBasicResult());
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) {
                this.mAufgelaufenesEntgeltAN = this.mAufgelaufenesEntgeltAN.add(lElement.getSumOfResult());
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfBasicResult()) && BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getSumOfResult())) continue;
            this.mAufgelaufenerBeitrag = this.mAufgelaufenerBeitrag.add(lElement.getResult());
        }
    }

    private ValuePosition[] sammleValuePosition(ValueType ... vts) throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vts);
    }
}

