/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.ErmittlungSVEntgeltMfBFormula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class KVBeitragsermittlungFreiwillig2013Formula {
    private static final BigDecimal _2 = BigDecimal.valueOf(2L);
    private static final BigDecimal _30 = BigDecimal.valueOf(30L);
    private static final BigDecimal _100 = BigDecimal.valueOf(100L);
    private static final BigDecimal _360 = BigDecimal.valueOf(360L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mKVGesamtbeitragAN = BigDecimal.ZERO;
    private BigDecimal mKVGesamtbeitragAG = BigDecimal.ZERO;
    private BigDecimal mDifferenzAN = BigDecimal.ZERO;
    private BigDecimal mDifferenzAG = BigDecimal.ZERO;
    private BigDecimal mAufgelEntgeltFKV = BigDecimal.ZERO;
    private BigDecimal mAufgelANAFKV = BigDecimal.ZERO;
    private BigDecimal mAufgelSVTage = BigDecimal.ZERO;
    private boolean mIsLKK = false;
    private boolean mIsFirmenzahler = true;

    public KVBeitragsermittlungFreiwillig2013Formula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.mCalLib = calculationLibrary;
        this.mEeLib = employeeLibrary;
        this.mGlLib = globalLibrary;
        this.mVpLib = valuePositionLibrary;
    }

    public void kvBeitragsermittlung() throws BusinessDomainException {
        if (this.mEeLib.marbBgrKv() == 0) {
            this.mIsFirmenzahler = false;
        }
        this.mIsLKK = this.mEeLib.isMarbKrkLKK();
        BigDecimal svTage = this.mVpLib.svTage();
        if (this.mCalLib.dbbgVorhanden() && BigDecimal.valueOf(this.mCalLib.dbbgSVTG()).compareTo(svTage) > 0) {
            svTage = BigDecimal.valueOf(this.mCalLib.dbbgSVTG());
        }
        BigDecimal kvBBG = this.ermittleBBG(svTage);
        switch (this.mVpLib.wertartenNummer()) {
            case 770020: {
                this.zuschussErmittlungLfd(kvBBG, svTage);
                break;
            }
            case 770030: {
                if (this.mIsLKK) break;
                this.zuschussErmittlungEGA();
                break;
            }
            case 770040: {
                if (this.mIsLKK) break;
                this.zuschussErmittlungKug(kvBBG);
                break;
            }
            case 770050: {
                if (!this.mIsLKK && this.mIsFirmenzahler) {
                    this.zuschussErmittlung100AG(kvBBG);
                } else {
                    this.mVpLib.wertPosition().makeReadOnly();
                }
            }
            default: {
                EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), this.mVpLib.wertartenNummer());
            }
        }
    }

    private void zuschussErmittlungLfd(BigDecimal kvBBG, BigDecimal svTage) throws BusinessDomainException {
        if (this.mIsLKK) {
            Insurance insurance = this.mEeLib.marbVersicherungsdaten();
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)insurance.getERallowanceHIFarm())) {
                this.mKVGesamtbeitragAG = insurance.getERallowanceHIFarm();
                this.mKVGesamtbeitragAN = this.mKVGesamtbeitragAG.multiply(_2).setScale(2, RoundingMode.HALF_UP);
                this.mVpLib.addNeueWertPosition(770010, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mKVGesamtbeitragAN, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
                if (svTage.compareTo(_30) != 0) {
                    this.mKVGesamtbeitragAG = this.mKVGesamtbeitragAG.multiply(svTage).divide(_30, 2, RoundingMode.HALF_UP);
                }
            }
            this.mCalLib.kvAGZ(this.mKVGesamtbeitragAG);
            this.mCalLib.percentage(BigDecimal.ZERO);
        } else {
            BigDecimal anGesamtBeitrag;
            ValuePosition[] vpArray;
            boolean isKUG;
            BigDecimal kVBeitragsVHSatz;
            switch (this.mEeLib.marbBklFKv().value()) {
                case 3: {
                    kVBeitragsVHSatz = this.mGlLib.krkBsErmaessigt();
                    this.mKVGesamtbeitragAN = this.mGlLib.krkGesBeitragBklErmaessigt();
                    this.mKVGesamtbeitragAG = this.mGlLib.krkGesBeitragBklErmaessigtAGZ();
                    break;
                }
                case 1: {
                    kVBeitragsVHSatz = this.mGlLib.krkBsAllgemein();
                    this.mKVGesamtbeitragAN = this.mGlLib.krkGesBeitragBklAllgemein();
                    this.mKVGesamtbeitragAG = this.mGlLib.krkGesBeitragBklAllgemeinAGZ();
                    break;
                }
                default: {
                    throw EvaluationExceptionMapper.makeIncreaseDuesGroupVHIAfter2008NotAllowedDomainException();
                }
            }
            BigDecimal kvHalberVHSatz = kVBeitragsVHSatz.divide(_2, 2, RoundingMode.HALF_UP);
            if (svTage.compareTo(_30) != 0) {
                this.mKVGesamtbeitragAN = kvBBG.multiply(kVBeitragsVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
                this.mKVGesamtbeitragAN = DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate()) ? this.mKVGesamtbeitragAN.add(kvBBG.multiply(this.mGlLib.getKVAGABSZusatzversicherung(false).add(this.mGlLib.getKVANABSZusatzversicherung(false))).divide(_100, 2, RoundingMode.HALF_UP)) : this.mKVGesamtbeitragAN.add(kvBBG.multiply(this.mGlLib.getKVBSZusatzversicherung(false)).divide(_100, 2, RoundingMode.HALF_UP));
                this.mKVGesamtbeitragAG = this.mKVGesamtbeitragAG.multiply(svTage).divide(_30, 2, RoundingMode.HALF_UP);
            }
            boolean bl = isKUG = this.checkKugImMonat() && this.mEeLib.marbBeitragsabsenkungBeiKuG();
            if (isKUG) {
                BigDecimal kvEntgelt = BigDecimal.ZERO;
                for (ValuePosition vPos : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), ValueTypeHelper.getValueTypes(770090, 770100, 230110))) {
                    kvEntgelt = kvEntgelt.add(vPos.getResult());
                }
                if (kvEntgelt.compareTo(this.mGlLib.svBbgKvPv()) > 0) {
                    kvEntgelt = this.mGlLib.svBbgKvPv();
                }
                BigDecimal zusatzbeitrag = this.mGlLib.getKVANABSZusatzversicherung(false);
                if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                    zusatzbeitrag = zusatzbeitrag.add(this.mGlLib.getKVAGABSZusatzversicherung(false));
                }
                BigDecimal kvGesamtbeitrag = BigDecimal.ZERO;
                if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2020, 9, 1).getDate())) {
                    kvGesamtbeitrag = kvEntgelt.multiply(kVBeitragsVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
                    kvGesamtbeitrag = kvGesamtbeitrag.add(kvEntgelt.multiply(zusatzbeitrag).divide(_100, 2, RoundingMode.HALF_UP));
                } else {
                    kvGesamtbeitrag = kvEntgelt.multiply(kVBeitragsVHSatz.add(zusatzbeitrag)).divide(_100, 2, RoundingMode.HALF_UP);
                }
                if (kvGesamtbeitrag.compareTo(this.mKVGesamtbeitragAN) < 0) {
                    this.mDifferenzAN = this.mKVGesamtbeitragAN.subtract(kvGesamtbeitrag);
                    this.mKVGesamtbeitragAN = kvGesamtbeitrag;
                }
            }
            boolean is23c = this.check23c();
            vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), ValueTypeHelper.getValueTypes(770090, 770100));
            BigDecimal beitragsZuschGL = BigDecimal.ZERO;
            BigDecimal beitragsZuschGL100AG = BigDecimal.ZERO;
            for (ValuePosition vp : vpArray) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 770090: {
                        beitragsZuschGL = beitragsZuschGL.add(vp.getResult());
                        break;
                    }
                    case 770100: {
                        beitragsZuschGL100AG = beitragsZuschGL100AG.add(vp.getResult());
                    }
                }
                vp.setPersistentBuffer1(BigDecimal.ONE);
            }
            BigDecimal aGZFaehigEntgelt = kvBBG;
            switch (this.mEeLib.marbAGZFKv()) {
                case 1: 
                case 11: {
                    if (is23c || this.checkKugImJahr()) {
                        aGZFaehigEntgelt = this.kvAgzEntgeltLfd(is23c, kvHalberVHSatz, kVBeitragsVHSatz, kvBBG, svTage, beitragsZuschGL, beitragsZuschGL100AG);
                        break;
                    }
                    aGZFaehigEntgelt = this.kvAgzBbg(kvHalberVHSatz, kVBeitragsVHSatz, kvBBG);
                    break;
                }
                case 21: {
                    aGZFaehigEntgelt = this.kvAgzEntgeltLfd(is23c, kvHalberVHSatz, kVBeitragsVHSatz, kvBBG, svTage, beitragsZuschGL, beitragsZuschGL100AG);
                    break;
                }
                default: {
                    this.setFKVEntgelt(beitragsZuschGL, kvBBG);
                }
            }
            BigDecimal aGZFaehigVHSatz = kVBeitragsVHSatz;
            if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                aGZFaehigVHSatz = aGZFaehigVHSatz.add(this.mGlLib.getKVAGABSZusatzversicherung(false)).add(this.mGlLib.getKVANABSZusatzversicherung(false));
            }
            BigDecimal aGZFaehigBetrag = kvBBG.multiply(aGZFaehigVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
            if (isKUG) {
                anGesamtBeitrag = this.mKVGesamtbeitragAN;
            } else {
                BigDecimal zusatzbeitrag = this.mGlLib.getKVANABSZusatzversicherung(false);
                if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                    zusatzbeitrag = zusatzbeitrag.add(this.mGlLib.getKVAGABSZusatzversicherung(false));
                }
                anGesamtBeitrag = aGZFaehigEntgelt.multiply(kVBeitragsVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
                anGesamtBeitrag = anGesamtBeitrag.add(aGZFaehigEntgelt.multiply(zusatzbeitrag).divide(_100, 2, RoundingMode.HALF_UP));
            }
            if (this.mIsFirmenzahler) {
                this.setKVFreiwBeitragFirmenzahler770000(anGesamtBeitrag, kVBeitragsVHSatz);
                this.mVpLib.addNeueWertPosition(770080, aGZFaehigVHSatz, BigDecimal.ZERO, this.mVpLib.svTage(), BigDecimal.ZERO, aGZFaehigBetrag, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAG, BigDecimal.ZERO, BigDecimal.ZERO);
            } else {
                this.setKVFreiwBeitragSelbstzahler770010(anGesamtBeitrag, kVBeitragsVHSatz);
                this.mVpLib.addNeueWertPosition(770080, aGZFaehigVHSatz, BigDecimal.ZERO, this.mVpLib.svTage(), BigDecimal.ZERO, aGZFaehigBetrag, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAG, BigDecimal.ZERO, BigDecimal.ZERO);
            }
        }
    }

    private BigDecimal kvAgzBbg(BigDecimal kvHalberVHSatz, BigDecimal kVBeitragsVHSatz, BigDecimal kvBBG) throws BusinessDomainException {
        this.setFKVEntgelt(kvBBG, kvBBG);
        BigDecimal beitragsZuschGL = kvBBG;
        if (BigDecimalMapper.compareTo((BigDecimal)beitragsZuschGL, (BigDecimal)this.mGlLib.svBbgKvPv()) != 0) {
            this.mKVGesamtbeitragAN = this.getGesamtbeitragAN(beitragsZuschGL, kVBeitragsVHSatz);
        }
        BigDecimal kvAGZ = beitragsZuschGL.multiply(kvHalberVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
        BigDecimal kvAGAZVHSatz = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
            kvAGAZVHSatz = this.mGlLib.getKVAGABSZusatzversicherung(false);
            kvAGZ = kvAGZ.add(beitragsZuschGL.multiply(kvAGAZVHSatz).divide(_100, 2, RoundingMode.HALF_UP));
        }
        kvAGZ = this.vergleicheMitKVAGZMax(kvAGZ);
        this.mCalLib.percentage(kvHalberVHSatz.add(kvAGAZVHSatz));
        this.mCalLib.kvAGZ(kvAGZ);
        return beitragsZuschGL;
    }

    private BigDecimal kvAgzEntgeltLfd(boolean is23c, BigDecimal kvHalberVHSatz, BigDecimal kVBeitragsVHSatz, BigDecimal kvBBG, BigDecimal svTage, BigDecimal beitragsZuschGL, BigDecimal beitragsZuschGL100AG) throws BusinessDomainException {
        this.setFKVEntgelt(beitragsZuschGL, kvBBG);
        BigDecimal gesamtesEntgelt = beitragsZuschGL.add(beitragsZuschGL100AG);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)beitragsZuschGL100AG)) {
            if (gesamtesEntgelt.compareTo(kvBBG) > 0) {
                beitragsZuschGL = beitragsZuschGL.multiply(kvBBG).divide(gesamtesEntgelt, 2, RoundingMode.HALF_UP);
            }
        } else if (beitragsZuschGL.compareTo(kvBBG) > 0) {
            beitragsZuschGL = kvBBG;
        }
        BigDecimal kvAGZ = beitragsZuschGL.multiply(kvHalberVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
        BigDecimal kvAGAZVHSatz = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
            kvAGAZVHSatz = this.mGlLib.getKVAGABSZusatzversicherung(false);
            kvAGZ = kvAGZ.add(beitragsZuschGL.multiply(kvAGAZVHSatz).divide(_100, 2, RoundingMode.HALF_UP));
        }
        if (is23c) {
            ValuePosition[] vpArray;
            BigDecimal normalerGesamtBeitrag = BigDecimal.valueOf(this.mKVGesamtbeitragAN.doubleValue());
            BigDecimal svFreibetrag = BigDecimal.ZERO;
            BigDecimal sachbezug = BigDecimal.ZERO;
            BigDecimal tempSVTage = _30;
            block4: for (ValuePosition vp : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), ValueTypeHelper.getValueTypes(129530, 129525))) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 129525: {
                        svFreibetrag = svFreibetrag.add(vp.getResult());
                        continue block4;
                    }
                    case 129530: {
                        sachbezug = sachbezug.add(vp.getResult());
                        tempSVTage = vp.getFactor1();
                    }
                }
            }
            BigDecimal ueberschreitung = BigDecimal.ZERO;
            if (BigDecimalMapper.compareTo((BigDecimal)svFreibetrag, (BigDecimal)sachbezug) < 0) {
                ueberschreitung = sachbezug.subtract(svFreibetrag);
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)tempSVTage) && BigDecimalMapper.compareTo((BigDecimal)tempSVTage, (BigDecimal)_30) != 0) {
                    ueberschreitung = ueberschreitung.multiply(tempSVTage).divide(_30, 2, RoundingMode.HALF_UP);
                }
            }
            BigDecimal tempBBG = kvBBG;
            if (BigDecimalMapper.compareTo((BigDecimal)tempSVTage, (BigDecimal)_30) != 0 && BigDecimalMapper.compareTo((BigDecimal)svTage, (BigDecimal)_30) == 0) {
                tempBBG = kvBBG.multiply(tempSVTage).divide(_30, 2, RoundingMode.HALF_UP);
            }
            BigDecimal zusatzbeitragVHSatz = DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate()) ? this.mGlLib.getKVAGABSZusatzversicherung(false).add(this.mGlLib.getKVANABSZusatzversicherung(false)) : this.mGlLib.kvZusatzVHSatz();
            BigDecimal kvArbeitsphase = tempBBG.multiply(kVBeitragsVHSatz.add(zusatzbeitragVHSatz)).divide(_100, 2, RoundingMode.HALF_UP);
            BigDecimal kvKrankheitsphase = ueberschreitung.multiply(kVBeitragsVHSatz.add(zusatzbeitragVHSatz)).divide(_100, 2, RoundingMode.HALF_UP);
            this.mKVGesamtbeitragAN = this.vergleicheMitKVANMax(kvArbeitsphase.add(kvKrankheitsphase), kVBeitragsVHSatz);
            this.mDifferenzAN = normalerGesamtBeitrag.subtract(this.mKVGesamtbeitragAN);
            normalerGesamtBeitrag = BigDecimal.valueOf(this.mKVGesamtbeitragAG.doubleValue());
            this.mDifferenzAG = normalerGesamtBeitrag.subtract(this.mKVGesamtbeitragAG);
        }
        kvAGZ = this.vergleicheMitKVAGZMax(kvAGZ);
        this.mCalLib.percentage(kvHalberVHSatz.add(kvAGAZVHSatz));
        this.mCalLib.kvAGZ(kvAGZ);
        if (gesamtesEntgelt.compareTo(kvBBG) > 0) {
            gesamtesEntgelt = kvBBG;
        }
        return is23c ? gesamtesEntgelt : kvBBG;
    }

    private BigDecimal ermittleBBG(BigDecimal kvTage) throws BusinessDomainException {
        BigDecimal result = this.mGlLib.svBbgKvPv();
        if (this.mEeLib.isMehrfachbeschaeftigt() && this.mEeLib.marbBgrKvAndererAG() != 6) {
            BigDecimal dbbgKVEntgelt = BigDecimal.ZERO;
            if (this.mCalLib.dbbgVorhanden()) {
                if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
                    if (StringMapper.compareTo((String)this.mCalLib.dbbgKVLBBG(), (String)"J") == 0) {
                        dbbgKVEntgelt = this.mCalLib.dbbgGAEGKV();
                    }
                } else {
                    dbbgKVEntgelt = this.mCalLib.dbbgGAEGKV();
                }
            }
            result = this.kvBBGBeiBeitragsteilung(result, kvTage, dbbgKVEntgelt);
        } else if (BigDecimalMapper.compareTo((BigDecimal)kvTage, (BigDecimal)_30) != 0) {
            result = result.multiply(kvTage).divide(_30, 2, RoundingMode.HALF_UP);
        }
        return result;
    }

    private BigDecimal kvBBGBeiBeitragsteilung(BigDecimal kvBBG, BigDecimal kvTage, BigDecimal dbbgKVEntgelt) throws BusinessDomainException {
        ErmittlungSVEntgeltMfBFormula formula = new ErmittlungSVEntgeltMfBFormula(this.mCalLib, this.mVpLib);
        ErmittlungSVEntgeltMfBFormula.SVEntgeltMfBDatas sVEntgeltMfBDatas = formula.getBBGBeiBeitragsteilungEigenerRK(kvBBG, kvTage, dbbgKVEntgelt);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)sVEntgeltMfBDatas.getEntgeltLfdAndererAG())) {
            this.mVpLib.addNeueWertPosition(321595, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, sVEntgeltMfBDatas.getEntgeltLfdAndererAG(), true);
        }
        return sVEntgeltMfBDatas.getAnteiligeBBGAktuellerAG();
    }

    private boolean check23c() throws BusinessDomainException {
        return this.mCalLib.getCalculationCase().isSignedAs23cSGBIV() || this.mVpLib.summeWPErgebnisVonWertarten(new ValueType[]{ValueType.getValueType((int)129610)}).compareTo(BigDecimal.ZERO) != 0;
    }

    private boolean checkKugImJahr() throws BusinessDomainException {
        Date suchdatum = DateHelper.getFirstDayOfYear((Date)this.mCalLib.berchnungGueltigAb());
        boolean kugGefunden = false;
        while (DateHelper.beforeOrEqual((Date)suchdatum, (Date)this.mCalLib.berchnungGueltigAb()) && !kugGefunden) {
            ValuePosition[] vpArray;
            for (ValuePosition vPos : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mCalLib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungWirksamAb()), suchdatum, DateHelper.getLastDayOfMonth((Date)suchdatum), ValueTypeHelper.getValueTypes(230110))) {
                if (vPos.getResult().compareTo(BigDecimal.ZERO) <= 0) continue;
                kugGefunden = true;
            }
            suchdatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchdatum));
        }
        return kugGefunden;
    }

    private boolean checkKugImMonat() throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mCalLib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungWirksamAb()), this.mCalLib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes(230510)).length != 0;
    }

    private void zuschussErmittlungKug(BigDecimal kvBBG) throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal kVBeitragsVHSatz;
        switch (this.mEeLib.marbBklFKv().value()) {
            case 3: {
                if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
                    kVBeitragsVHSatz = this.mGlLib.krkBsErmaessigt().divide(_2, 3, RoundingMode.HALF_UP);
                    break;
                }
                if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                    kVBeitragsVHSatz = this.mGlLib.krkBsErmaessigt();
                    kVBeitragsVHSatz = kVBeitragsVHSatz.add(this.mGlLib.getKVBSZusatzversicherung(false));
                    break;
                }
                kVBeitragsVHSatz = this.mGlLib.krkBsErmaessigt();
                break;
            }
            case 1: {
                if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
                    kVBeitragsVHSatz = this.mGlLib.krkBsAllgemein().divide(_2, 3, RoundingMode.HALF_UP);
                    break;
                }
                if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                    kVBeitragsVHSatz = this.mGlLib.krkBsAllgemein();
                    kVBeitragsVHSatz = kVBeitragsVHSatz.add(this.mGlLib.getKVBSZusatzversicherung(false));
                    break;
                }
                kVBeitragsVHSatz = this.mGlLib.krkBsAllgemein();
                break;
            }
            default: {
                throw EvaluationExceptionMapper.makeIncreaseDuesGroupVHIAfter2008NotAllowedDomainException();
            }
        }
        BigDecimal kugEntgeltImMonat = BigDecimal.ZERO;
        BigDecimal aufgelEntgeltFKV = BigDecimal.ZERO;
        block8: for (ValuePosition vp : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), ValueTypeHelper.getValueTypes(770090, 770100, 230110))) {
            switch (vp.getValueType().getValueTypeKey()) {
                case 230110: {
                    kugEntgeltImMonat = kugEntgeltImMonat.add(vp.getResult());
                    continue block8;
                }
                case 770090: 
                case 770100: {
                    aufgelEntgeltFKV = aufgelEntgeltFKV.add(vp.getResult());
                }
            }
        }
        if (aufgelEntgeltFKV.add(kugEntgeltImMonat).compareTo(kvBBG) > 0) {
            kugEntgeltImMonat = kvBBG.subtract(aufgelEntgeltFKV);
        }
        if (kugEntgeltImMonat.compareTo(BigDecimal.ZERO) < 0) {
            kugEntgeltImMonat = BigDecimal.ZERO;
        }
        this.modifiziereFKVEntgelt(kugEntgeltImMonat, true);
        BigDecimal kvAGZ = kugEntgeltImMonat.multiply(kVBeitragsVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
        BigDecimal zusatzbeitragVHSatz = DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate()) ? this.mGlLib.getKVAGABSZusatzversicherung(false).add(this.mGlLib.getKVANABSZusatzversicherung(false)) : this.mGlLib.kvZusatzVHSatz();
        kvAGZ = kvAGZ.add(kugEntgeltImMonat.multiply(zusatzbeitragVHSatz).divide(_100, 2, RoundingMode.HALF_UP));
        if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
            kvAGZ = kvAGZ.multiply(_2);
        }
        this.mCalLib.kvAGZ(kvAGZ);
        this.mCalLib.percentage(kVBeitragsVHSatz.add(zusatzbeitragVHSatz));
    }

    private void zuschussErmittlung100AG(BigDecimal kvBBG) throws BusinessDomainException {
        BigDecimal zusatzbeitragVHSatz;
        ValuePosition genesis;
        ValuePosition[] vpArray;
        BigDecimal kVBeitragsVHSatz;
        switch (this.mEeLib.marbBklFKv().value()) {
            case 3: {
                if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
                    kVBeitragsVHSatz = this.mGlLib.krkBsErmaessigt().divide(_2, 3, RoundingMode.HALF_UP);
                    break;
                }
                if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                    kVBeitragsVHSatz = this.mGlLib.krkBsErmaessigt();
                    kVBeitragsVHSatz = kVBeitragsVHSatz.add(this.mGlLib.getKVBSZusatzversicherung(false));
                    break;
                }
                kVBeitragsVHSatz = this.mGlLib.krkBsErmaessigt();
                break;
            }
            case 1: {
                if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
                    kVBeitragsVHSatz = this.mGlLib.krkBsAllgemein().divide(_2, 3, RoundingMode.HALF_UP);
                    break;
                }
                if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                    kVBeitragsVHSatz = this.mGlLib.krkBsAllgemein();
                    kVBeitragsVHSatz = kVBeitragsVHSatz.add(this.mGlLib.getKVBSZusatzversicherung(false));
                    break;
                }
                kVBeitragsVHSatz = this.mGlLib.krkBsAllgemein();
                break;
            }
            default: {
                throw EvaluationExceptionMapper.makeIncreaseDuesGroupVHIAfter2008NotAllowedDomainException();
            }
        }
        BigDecimal entgelt100AGImMonat = BigDecimal.ZERO;
        BigDecimal aufgelEntgeltFKV = BigDecimal.ZERO;
        block8: for (ValuePosition vp : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), new ValueType[]{ValueType.getValueType((int)770090), ValueType.getValueType((int)770100)})) {
            switch (vp.getValueType().getValueTypeKey()) {
                case 770100: {
                    entgelt100AGImMonat = entgelt100AGImMonat.add(vp.getResult());
                    continue block8;
                }
                case 770090: {
                    aufgelEntgeltFKV = aufgelEntgeltFKV.add(vp.getResult());
                }
            }
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)aufgelEntgeltFKV)) {
            BigDecimal gesamtesEntgelt = aufgelEntgeltFKV.add(entgelt100AGImMonat);
            if (gesamtesEntgelt.compareTo(kvBBG) > 0) {
                entgelt100AGImMonat = entgelt100AGImMonat.multiply(kvBBG).divide(gesamtesEntgelt, 2, RoundingMode.HALF_UP);
            }
        } else if (entgelt100AGImMonat.compareTo(kvBBG) > 0) {
            entgelt100AGImMonat = kvBBG;
        }
        BigDecimal kvHalberVHSatz = kVBeitragsVHSatz.divide(_2, 2, RoundingMode.HALF_UP);
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2022, 0, 1).getDate()) && (genesis = this.mVpLib.genesisParent()).getValueType().getValueTypeKey() == 99973) {
            kvHalberVHSatz = kVBeitragsVHSatz;
        }
        BigDecimal kvAGZ = entgelt100AGImMonat.multiply(kvHalberVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
            ValuePosition genesis2;
            zusatzbeitragVHSatz = this.mGlLib.getKVAGABSZusatzversicherung(false);
            if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2022, 0, 1).getDate()) && (genesis2 = this.mVpLib.genesisParent()).getValueType().getValueTypeKey() == 99973) {
                zusatzbeitragVHSatz = this.mGlLib.getKVAGABSZusatzversicherung(false).add(this.mGlLib.getKVANABSZusatzversicherung(false));
            }
        } else {
            zusatzbeitragVHSatz = this.mGlLib.kvZusatzVHSatz();
        }
        kvAGZ = kvAGZ.add(entgelt100AGImMonat.multiply(zusatzbeitragVHSatz).divide(_100, 2, RoundingMode.HALF_UP));
        if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
            kvAGZ = kvAGZ.multiply(_2);
        }
        this.mCalLib.kvAGZ(kvAGZ);
        this.mCalLib.percentage(kvHalberVHSatz.add(zusatzbeitragVHSatz));
    }

    private void zuschussErmittlungEGA() throws BusinessDomainException {
        BigDecimal aktuellesEGA;
        BigDecimal kVBeitragsVHSatz;
        if (!this.checkKugImJahr()) {
            switch (this.mEeLib.marbAGZFKv()) {
                case 1: 
                case 11: {
                    this.mVpLib.wertPosition().makeReadOnly();
                    return;
                }
            }
            if (this.mEeLib.isMehrfachbeschaeftigt()) {
                this.mVpLib.wertPosition().makeReadOnly();
                return;
            }
        }
        switch (this.mEeLib.marbBklFKv().value()) {
            case 3: {
                kVBeitragsVHSatz = this.mGlLib.krkBsErmaessigt();
                break;
            }
            case 1: {
                kVBeitragsVHSatz = this.mGlLib.krkBsAllgemein();
                break;
            }
            default: {
                throw EvaluationExceptionMapper.makeIncreaseDuesGroupVHIAfter2008NotAllowedDomainException();
            }
        }
        BigDecimal kvHalberVHSatz = kVBeitragsVHSatz.divide(_2, 2, RoundingMode.HALF_UP);
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
            kvHalberVHSatz = kvHalberVHSatz.add(this.mEeLib.marbKrkAgaBsZusatzbeitrag());
        }
        this.sammleJahreswerte(kVBeitragsVHSatz);
        BigDecimal kvBBG = this.mGlLib.svBbgKvPvJaehrl().multiply(this.mAufgelSVTage).divide(_360, 2, RoundingMode.HALF_UP);
        BigDecimal svLuft = kvBBG.subtract(this.mAufgelEntgeltFKV);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mEeLib.vortragSozialVersicherungKVLuft(this.mVpLib.gueltigAb()))) {
            svLuft = svLuft.add(this.mEeLib.vortragSozialVersicherungKVLuft(this.mVpLib.gueltigAb()));
        }
        if (svLuft.compareTo(BigDecimal.ZERO) < 0) {
            svLuft = BigDecimal.ZERO;
        }
        if (svLuft.compareTo(aktuellesEGA = this.holeEGAImMonat()) < 0) {
            aktuellesEGA = svLuft;
        }
        if (DateHelper.between((Date)this.mVpLib.gueltigAb(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
            this.modifiziereFKVEntgelt(aktuellesEGA, true);
        }
        if (this.mEeLib.marbBeitragsabsenkungBeiKuG()) {
            this.modifiziereGesamtbeitragKuG(aktuellesEGA, kvBBG, kVBeitragsVHSatz);
        }
        BigDecimal kvAGZ = BigDecimal.ZERO;
        if (aktuellesEGA.compareTo(BigDecimal.ZERO) > 0) {
            kvAGZ = aktuellesEGA.multiply(kvHalberVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
        }
        this.mCalLib.kvAGZ(kvAGZ);
        this.mCalLib.percentage(kvHalberVHSatz);
    }

    private void modifiziereGesamtbeitragKuG(BigDecimal aktuellesEGA, BigDecimal kvBBG, BigDecimal kVBeitragsVHSatz) throws BusinessDomainException {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)aktuellesEGA)) {
            BigDecimal tempEGA = aktuellesEGA;
            BigDecimal beitragssatz = DateHelper.before((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate()) ? kVBeitragsVHSatz.add(this.mGlLib.kvZusatzVHSatz()) : kVBeitragsVHSatz.add(this.mEeLib.marbKrkAgaBsZusatzbeitrag()).add(this.mEeLib.marbKrkAnaBsZusatzbeitrag());
            BigDecimal tempResult = tempEGA.multiply(kVBeitragsVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
            BigDecimal maxBeitrag = kvBBG.multiply(kVBeitragsVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
            if (BigDecimalMapper.compareTo((BigDecimal)maxBeitrag, (BigDecimal)tempResult.add(this.mAufgelANAFKV)) < 0) {
                tempResult = maxBeitrag.subtract(this.mAufgelANAFKV);
                tempEGA = BigDecimalMapper.compareTo((BigDecimal)tempResult, (BigDecimal)BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : tempResult.multiply(_100).divide(kVBeitragsVHSatz, 2, RoundingMode.HALF_UP);
            }
            BigDecimal result = tempEGA.multiply(beitragssatz).divide(_100, 2, RoundingMode.HALF_UP);
            switch (this.mEeLib.marbBgrKv()) {
                case 0: {
                    this.setKVFreiwBeitragSelbstzahler770010(result, kVBeitragsVHSatz);
                    break;
                }
                default: {
                    this.setKVFreiwBeitragFirmenzahler770000(result, kVBeitragsVHSatz);
                }
            }
        }
    }

    private BigDecimal holeEGAImMonat() throws BusinessDomainException {
        return this.mVpLib.summeWPErgebnisVonWertarten(ValueTypeHelper.getValueTypes(130610, 130620));
    }

    /*
     * WARNING - void declaration
     */
    private void sammleJahreswerte(BigDecimal kVBeitragsVHSatz) throws BusinessDomainException {
        ValuePosition[] vpArray;
        ValueType[] vtArray = ValueTypeHelper.getValueTypes(770090, 770100, 770080, 129200, 770010, 770000);
        Date suchdatum = PDateHelper.maxIgnoringNulls((Date[])new Date[]{DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb()), this.mEeLib.marbEintritt()});
        while (DateHelper.before((Date)suchdatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()))) {
            void var6_7;
            vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)suchdatum), DateHelper.getLastDayOfMonth((Date)suchdatum), vtArray);
            BigDecimal zwSVTage = BigDecimal.ZERO;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            BigDecimal zwANAFKV = BigDecimal.ZERO;
            boolean isLfdErmittelt = false;
            block15: for (ValuePosition vp : vpArray) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 770080: {
                        zwSVTage = zwSVTage.add(vp.getFactor1());
                        continue block15;
                    }
                    case 770090: 
                    case 770100: {
                        isLfdErmittelt = vp.getPersistentBuffer1().compareTo(BigDecimal.ONE) == 0;
                    }
                    case 129200: {
                        BigDecimal bigDecimal2 = var6_7.add(vp.getResult());
                        continue block15;
                    }
                    case 770000: 
                    case 770010: {
                        zwANAFKV = zwANAFKV.add(vp.getResult());
                    }
                }
            }
            if (isLfdErmittelt) {
                this.mAufgelSVTage = this.mAufgelSVTage.add(zwSVTage);
                this.mAufgelEntgeltFKV = this.mAufgelEntgeltFKV.add((BigDecimal)var6_7);
                this.mAufgelANAFKV = this.mAufgelANAFKV.add(zwANAFKV);
            }
            suchdatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchdatum));
        }
        vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vtArray);
        boolean nichtsEnthalten = true;
        block16: for (ValuePosition vp : vpArray) {
            switch (vp.getValueType().getValueTypeKey()) {
                case 770080: {
                    nichtsEnthalten = false;
                    this.mAufgelSVTage = this.mAufgelSVTage.add(vp.getFactor1());
                    continue block16;
                }
                case 770090: 
                case 770100: {
                    nichtsEnthalten = false;
                    this.mAufgelEntgeltFKV = this.mAufgelEntgeltFKV.add(vp.getResult());
                    continue block16;
                }
                case 770000: 
                case 770010: {
                    this.mAufgelANAFKV = this.mAufgelANAFKV.add(vp.getResult());
                }
            }
        }
        if (nichtsEnthalten && this.mVpLib.svTage().compareTo(BigDecimal.ZERO) != 0) {
            this.mAufgelSVTage = this.mAufgelSVTage.add(this.mVpLib.svTage());
            BigDecimal bigDecimal = this.mGlLib.krkGesBeitragBklAllgemeinAGZ();
            this.mKVGesamtbeitragAN = this.mGlLib.krkGesBeitragBklAllgemein();
            if (this.mVpLib.svTage().compareTo(_30) != 0) {
                BigDecimal bigDecimal3 = bigDecimal.multiply(this.mVpLib.svTage()).divide(_30, 2, RoundingMode.HALF_UP);
                this.mKVGesamtbeitragAN = this.mKVGesamtbeitragAN.multiply(this.mVpLib.svTage()).divide(_30, 2, RoundingMode.HALF_UP);
            }
            switch (this.mEeLib.marbBgrKv()) {
                case 0: {
                    void var6_13;
                    this.setKVFreiwBeitragSelbstzahler770010(this.mKVGesamtbeitragAN, kVBeitragsVHSatz);
                    this.mVpLib.addNeueWertPosition(770080, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.svTage(), BigDecimal.ZERO, (BigDecimal)var6_13, true);
                    break;
                }
                default: {
                    void var6_13;
                    this.setKVFreiwBeitragFirmenzahler770000(this.mKVGesamtbeitragAN, kVBeitragsVHSatz);
                    this.mVpLib.addNeueWertPosition(770080, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.svTage(), BigDecimal.ZERO, (BigDecimal)var6_13, true);
                }
            }
        }
    }

    private void modifiziereFKVEntgelt(BigDecimal differenz, boolean tatsaechlichesEntgelt) throws BusinessDomainException {
        ValuePosition[] vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), new ValueType[]{ValueType.getValueType((int)770090)});
        vpArray[0].setResult(vpArray[0].getResult().add(differenz));
        vpArray[0].setPersistentBuffer2(vpArray[0].getPersistentBuffer2().add(differenz));
    }

    private void setFKVEntgelt(BigDecimal entgelt, BigDecimal kvBBG) throws BusinessDomainException {
        if (BigDecimalMapper.compareTo((BigDecimal)entgelt, (BigDecimal)kvBBG) > 0) {
            entgelt = kvBBG;
        }
        ValuePosition[] vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), new ValueType[]{ValueType.getValueType((int)770090)});
        vpArray[0].setResult(entgelt);
        vpArray[0].setPersistentBuffer2(entgelt);
    }

    private void setKVFreiwBeitragFirmenzahler770000(BigDecimal result, BigDecimal kVBeitragsVHSatz) throws BusinessDomainException {
        if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
            this.mVpLib.addNeueWertPosition(770000, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, result, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
        } else if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
            BigDecimal zusatzbeitragVHSatz = this.mGlLib.getKVBSZusatzversicherung(false);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)zusatzbeitragVHSatz)) {
                BigDecimal zusatzbeitrag = result.multiply(zusatzbeitragVHSatz).divide(kVBeitragsVHSatz.add(zusatzbeitragVHSatz), 2, RoundingMode.HALF_UP);
                this.mVpLib.addNeueWertPosition(770005, zusatzbeitragVHSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, zusatzbeitrag, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
                this.mVpLib.addNeueWertPosition(770000, kVBeitragsVHSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, result.subtract(zusatzbeitrag), true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
            } else {
                this.mVpLib.addNeueWertPosition(770000, kVBeitragsVHSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, result, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
            }
        } else {
            BigDecimal zusatzbeitragVHSatz = this.mEeLib.marbKrkAgaBsZusatzbeitrag().add(this.mEeLib.marbKrkAnaBsZusatzbeitrag());
            BigDecimal beitragVHSatzGesamt = kVBeitragsVHSatz.add(zusatzbeitragVHSatz);
            BigDecimal zusatzbeitrag = result.multiply(zusatzbeitragVHSatz).divide(beitragVHSatzGesamt, 2, RoundingMode.HALF_UP);
            BigDecimal beitrag = result.subtract(zusatzbeitrag);
            this.mVpLib.addNeueWertPosition(770000, kVBeitragsVHSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrag, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)zusatzbeitrag)) {
                this.mVpLib.addNeueWertPosition(770005, zusatzbeitragVHSatz, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, zusatzbeitrag, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
            }
        }
    }

    private void setKVFreiwBeitragSelbstzahler770010(BigDecimal result, BigDecimal kVBeitragsVHSatz) throws BusinessDomainException {
        if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
            this.mVpLib.addNeueWertPosition(770010, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, result, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
        } else {
            BigDecimal beitrag = BigDecimal.ZERO;
            BigDecimal zusatzbeitragVHSatz = BigDecimal.ZERO;
            if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                zusatzbeitragVHSatz = this.mGlLib.getKVAGABSZusatzversicherung(false).add(this.mGlLib.getKVANABSZusatzversicherung(false));
                beitrag = result;
            } else {
                zusatzbeitragVHSatz = this.mGlLib.getKVBSZusatzversicherung(false);
                beitrag = result;
            }
            this.mVpLib.addNeueWertPosition(770010, kVBeitragsVHSatz.add(zusatzbeitragVHSatz), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrag, true, BigDecimal.ZERO, BigDecimal.ZERO, this.mDifferenzAN, BigDecimal.ZERO, BigDecimal.ZERO);
        }
    }

    private BigDecimal getGesamtbeitragAN(BigDecimal kvEntgelt, BigDecimal kVBeitragsVHSatz) throws BusinessDomainException {
        BigDecimal kvGesamtbeitragAN = kvEntgelt.multiply(kVBeitragsVHSatz).divide(_100, 2, RoundingMode.HALF_UP);
        BigDecimal kvGesamtbeitragANZusatz = DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate()) ? kvEntgelt.multiply(this.mGlLib.getKVAGABSZusatzversicherung(false).add(this.mGlLib.getKVANABSZusatzversicherung(false))).divide(_100, 2, RoundingMode.HALF_UP) : kvEntgelt.multiply(this.mGlLib.getKVBSZusatzversicherung(false)).divide(_100, 2, RoundingMode.HALF_UP);
        return kvGesamtbeitragAN.add(kvGesamtbeitragANZusatz);
    }

    private BigDecimal vergleicheMitKVAGZMax(BigDecimal kvAGZ) {
        BigDecimal kvMaxAGZ = this.mKVGesamtbeitragAG.divide(_2, 2, RoundingMode.HALF_UP);
        if (kvAGZ.compareTo(kvMaxAGZ) > 0) {
            kvAGZ = kvMaxAGZ;
        }
        return kvAGZ;
    }

    private BigDecimal vergleicheMitKVANMax(BigDecimal kvAnA, BigDecimal kVBeitragsVHSatz) throws BusinessDomainException {
        BigDecimal kvAnMax = this.getGesamtbeitragAN(this.mGlLib.svBbgKvPv(), kVBeitragsVHSatz);
        return kvAnMax.compareTo(kvAnA) < 0 ? kvAnMax : kvAnA;
    }
}

