/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.ZvkSettingsEnum;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.zvk.ZvkTypeOfCalcAddContEnum;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.lumpsumitax.ConsolidationIntoALumpSumEnum;
import com.varial.personnel.domain.global.lumpsumitax.LumpSumIncomeTax;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.LinkedList;

public class ErmittlungZVKZusatzbeitragAN2016Formula {
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private final ValuePositionLibrary wplib;
    private BigDecimal mBglNeu = BigDecimal.ZERO;
    private BigDecimal mBglAlt = BigDecimal.ZERO;
    private BigDecimal mResultNeu = BigDecimal.ZERO;
    private BigDecimal mResultatAlt = BigDecimal.ZERO;
    private BigDecimal mResultDiff = BigDecimal.ZERO;
    private BigDecimal mSteuerFreiGrenze = BigDecimal.ZERO;
    private BigDecimal mSvFreiGrenze = BigDecimal.ZERO;
    private BigDecimal mSteuerFreiAlt = BigDecimal.ZERO;
    private BigDecimal mSteuerFreiDiff = BigDecimal.ZERO;
    private BigDecimal mSteuerPflDiff = BigDecimal.ZERO;
    private BigDecimal mSteuerPflAlt = BigDecimal.ZERO;
    private BigDecimal mSVFreiDiff = BigDecimal.ZERO;
    private BigDecimal mSvPflDiff = BigDecimal.ZERO;
    private BigDecimal mSVFreiAlt = BigDecimal.ZERO;
    private BigDecimal mSvPflAlt = BigDecimal.ZERO;
    private BigDecimal mPauschSteuerPflAlt = BigDecimal.ZERO;
    private BigDecimal mPauschSteuerPflDiff = BigDecimal.ZERO;
    private BigDecimal mAufgelSteuerfrei3Nr63 = BigDecimal.ZERO;
    private BigDecimal mAufgelPauschSteuerPfl = BigDecimal.ZERO;
    private BigDecimal mAufgelSVfrei3Nr63 = BigDecimal.ZERO;

    public ErmittlungZVKZusatzbeitragAN2016Formula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.callib = calculationLibrary;
        this.eelib = employeeLibrary;
        this.gllib = globalLibrary;
        this.wplib = valuePositionLibrary;
    }

    public void ermittle() throws BusinessDomainException {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkVhSatzZusatzbeitragAn())) {
            this.wplib.wertPosition().makeReadOnly();
        } else {
            this.ermittleAufgelaufeneWerte();
            this.mBglNeu = this.mBglAlt.add(this.wplib.result());
            ValuePosition genesis = this.wplib.genesisParent();
            if (genesis.getValueType().getValueTypeKey() != 99992 && this.mBglNeu.compareTo(this.gllib.zvkMaximalGrenze()) > 0) {
                this.mBglNeu = this.gllib.zvkMaximalGrenze();
            }
            this.mResultNeu = this.mBglNeu.multiply(this.gllib.zvkVhSatzZusatzbeitragAn()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
            this.mResultDiff = this.mResultNeu.subtract(this.mResultatAlt);
            this.wplib.addNeueWertPosition(864110, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mResultDiff, false);
            this.weitergabeDerBerechnungsWerte();
            this.abgrenzungSteuerUndSVFrei();
            this.callib.result(this.mResultDiff);
            this.callib.percentage(this.gllib.zvkVhSatzZusatzbeitragAn());
        }
    }

    private void abgrenzungSteuerUndSVFrei() throws BusinessDomainException {
        BigDecimal differenz;
        BigDecimal jaehrlicheSteuerFreiGrenze3Nr63ESt;
        BigDecimal jaehrlicheSVFreiGrenze3Nr63ESt;
        this.ermittleAufgelWerte();
        if (!this.eelib.isZVKWeiteresVersicherungsverhaeltnis() && this.eelib.stkl() != 6 && this.eelib.isZVKZusatzbeitragAN3Nr63EStG()) {
            this.mSteuerFreiGrenze = this.gllib.svBbgRvAvMonatlBAV(this.eelib.zvkBerechnungZusatzbeitrag());
            this.mSvFreiGrenze = this.gllib.svBbgRvAvMonatlBAV();
        }
        if (this.gllib.verarbeitungZVK(true) == ZvkSettingsEnum.ZSE_ABBAU_JAEHRLICH) {
            this.mSteuerFreiGrenze = this.mSteuerFreiGrenze.multiply(BigDecimal.valueOf(12L));
            this.mSvFreiGrenze = this.mSvFreiGrenze.multiply(BigDecimal.valueOf(12L));
        }
        this.abgrenzungNeuvertrag();
        this.aufgelaufen3Nr63ESt();
        if (this.gllib.verarbeitungZVK(true) == ZvkSettingsEnum.ZSE_ABBAU_JAEHRLICH) {
            jaehrlicheSVFreiGrenze3Nr63ESt = this.mSvFreiGrenze;
            jaehrlicheSteuerFreiGrenze3Nr63ESt = this.mSteuerFreiGrenze;
        } else {
            jaehrlicheSVFreiGrenze3Nr63ESt = this.mSvFreiGrenze.multiply(BigDecimal.valueOf(12L));
            jaehrlicheSteuerFreiGrenze3Nr63ESt = this.mSteuerFreiGrenze.multiply(BigDecimal.valueOf(12L));
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.mSteuerFreiDiff) && this.mSteuerFreiDiff.add(this.mAufgelSteuerfrei3Nr63).compareTo(jaehrlicheSteuerFreiGrenze3Nr63ESt) > 0) {
            differenz = this.mSteuerFreiDiff.add(this.mAufgelSteuerfrei3Nr63).subtract(jaehrlicheSteuerFreiGrenze3Nr63ESt);
            this.mSteuerFreiDiff = this.mSteuerFreiDiff.subtract(differenz);
            this.mSteuerPflDiff = this.mSteuerPflDiff.add(differenz);
        }
        if ((this.eelib.zvkBerechnungZusatzbeitrag() == ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag || this.eelib.zvkBerechnungZusatzbeitrag() == ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag_Gruppenvers) && this.eelib.isZVKZusatzbeitragAN3Nr63EStG() && this.mSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal pauschalGrenzeJaehrlich;
            LumpSumIncomeTax lit;
            if (this.eelib.zvkBerechnungZusatzbeitrag() == ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag_Gruppenvers) {
                lit = LumpSumIncomeTax.getLumpSumIncomeTax((ConsolidationIntoALumpSumEnum)ConsolidationIntoALumpSumEnum.CIALSE_Pauschalierungsgrenze_Gruppenversicherung);
                pauschalGrenzeJaehrlich = lit.getLumpSumIncomeTaxTP(this.wplib.wirksamAb(), this.wplib.gueltigAb()).getAmount();
            } else {
                lit = LumpSumIncomeTax.getLumpSumIncomeTax((ConsolidationIntoALumpSumEnum)ConsolidationIntoALumpSumEnum.CIALSE_jaehrliche_Pauschalierungsgrenze);
                pauschalGrenzeJaehrlich = lit.getLumpSumIncomeTaxTP(this.wplib.wirksamAb(), this.wplib.gueltigAb()).getAmount();
            }
            if (this.mAufgelPauschSteuerPfl.compareTo(pauschalGrenzeJaehrlich) < 0) {
                BigDecimal differenz2 = pauschalGrenzeJaehrlich.subtract(this.mAufgelPauschSteuerPfl);
                BigDecimal pauschalGrenzeMonatlich = BigDecimal.ZERO;
                pauschalGrenzeMonatlich = this.gllib.verarbeitungZVK(true) == ZvkSettingsEnum.ZSE_ABBAU_MONATLICH ? pauschalGrenzeJaehrlich.divide(BigDecimal.valueOf(12L), RoundingMode.HALF_UP) : pauschalGrenzeJaehrlich;
                if (differenz2.compareTo(pauschalGrenzeMonatlich) > 0) {
                    differenz2 = pauschalGrenzeMonatlich.subtract(this.mPauschSteuerPflAlt);
                }
                if (this.mSteuerPflDiff.compareTo(differenz2) < 0) {
                    this.mPauschSteuerPflDiff = this.mSteuerPflDiff;
                    this.mSteuerPflDiff = BigDecimal.ZERO;
                } else {
                    this.mPauschSteuerPflDiff = differenz2;
                    this.mSteuerPflDiff = this.mSteuerPflDiff.subtract(differenz2);
                }
            }
        }
        if (!BigDecimalMapper.isZero((BigDecimal)this.mSVFreiDiff) && this.mSVFreiDiff.add(this.mAufgelSVfrei3Nr63).compareTo(jaehrlicheSVFreiGrenze3Nr63ESt) > 0) {
            differenz = this.mSVFreiDiff.add(this.mAufgelSVfrei3Nr63).subtract(jaehrlicheSVFreiGrenze3Nr63ESt);
            if (this.mSVFreiDiff.compareTo(differenz) < 0) {
                this.mSvPflDiff = this.mSvPflDiff.add(this.mSVFreiDiff);
                this.mSVFreiDiff = BigDecimal.ZERO;
            } else {
                this.mSVFreiDiff = this.mSVFreiDiff.subtract(differenz);
                this.mSvPflDiff = this.mSvPflDiff.add(differenz);
            }
        }
        if (this.mSteuerFreiDiff.compareTo(BigDecimal.ZERO) != 0) {
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2012, 0, 1).getDate())) {
                this.wplib.addNeueWertPosition(111160, this.mSteuerFreiDiff);
            }
            this.wplib.persistentBuffer1(this.mSteuerFreiDiff);
        }
        if (this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2012, 0, 1).getDate())) {
                this.wplib.addNeueWertPosition(111260, this.mPauschSteuerPflDiff);
            }
            this.wplib.persistentBuffer2(this.mPauschSteuerPflDiff);
        }
        if (this.mSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2012, 0, 1).getDate())) {
                this.wplib.addNeueWertPosition(111360, this.mSteuerPflDiff);
            }
            this.wplib.persistentBuffer3(this.mSteuerPflDiff);
        }
        if (this.mSVFreiDiff.compareTo(BigDecimal.ZERO) != 0) {
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2012, 0, 1).getDate())) {
                this.wplib.addNeueWertPosition(111460, this.mSVFreiDiff);
            }
            this.wplib.persistentBuffer4(this.mSVFreiDiff);
        }
        if (this.mSvPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2012, 0, 1).getDate())) {
                this.wplib.addNeueWertPosition(111560, this.mSvPflDiff);
            }
            this.wplib.persistentBuffer5(this.mSvPflDiff);
        }
        if (this.wplib.wertPosition().getValueType().getValueTypeKey() == 100922) {
            this.erzeugeSteuerUndBeitragspflicht();
        } else {
            this.modifiziereSteuerUndBeitragspflicht();
        }
    }

    private void erzeugeSteuerUndBeitragspflicht() throws BusinessDomainException {
        if (this.mSteuerFreiDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(110510, this.mSteuerFreiDiff.negate());
        }
        if (this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(101790, this.mPauschSteuerPflDiff);
            if (this.eelib.zvkAbwaelzungPauschalLstAn()) {
                this.wplib.addNeueWertPosition(737800, this.mPauschSteuerPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737300, this.mPauschSteuerPflDiff);
            }
            if (this.eelib.zvkAbwaelzungPauschalSolZAn()) {
                this.wplib.addNeueWertPosition(737840, this.mPauschSteuerPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737340, this.mPauschSteuerPflDiff);
            }
            if (this.eelib.zvkAbwaelzungPauschalKiStAn()) {
                this.wplib.addNeueWertPosition(737880, this.mPauschSteuerPflDiff);
                this.wplib.addNeueWertPosition(737890, this.mPauschSteuerPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737380, this.mPauschSteuerPflDiff);
                this.wplib.addNeueWertPosition(737390, this.mPauschSteuerPflDiff);
            }
        }
        if (this.mSVFreiDiff.compareTo(BigDecimal.ZERO) != 0 && this.wplib.svTageLfd().compareTo(BigDecimal.ZERO) > 0) {
            this.wplib.addNeueWertPosition(130510, this.mSVFreiDiff.negate());
            this.wplib.addNeueWertPosition(135200, this.mSVFreiDiff.negate());
        }
    }

    private void modifiziereSteuerUndBeitragspflicht() throws BusinessDomainException {
        ValuePosition[] vpArray;
        boolean pauschalPflichtModifiziert = false;
        block11: for (ValuePosition vPos : vpArray = this.wplib.genesisUndFolgen()) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 110510: 
                case 110610: 
                case 110620: {
                    if (this.mSteuerFreiDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().subtract(this.mSteuerFreiDiff));
                    continue block11;
                }
                case 109150: 
                case 109170: 
                case 109510: 
                case 109530: 
                case 129610: 
                case 130510: 
                case 130560: 
                case 130610: 
                case 135200: 
                case 135400: {
                    if (this.mSVFreiDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().subtract(this.mSVFreiDiff));
                    vPos.setBufferField04(this.mSVFreiDiff);
                    continue block11;
                }
                case 101790: {
                    pauschalPflichtModifiziert = true;
                    if (this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737800: {
                    if (!this.eelib.zvkAbwaelzungPauschalLstAn() || this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737300: {
                    if (this.eelib.zvkAbwaelzungPauschalLstAn() || this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737840: {
                    if (!this.eelib.zvkAbwaelzungPauschalSolZAn() || this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737340: {
                    if (this.eelib.zvkAbwaelzungPauschalSolZAn() || this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737880: 
                case 737890: {
                    if (!this.eelib.zvkAbwaelzungPauschalKiStAn() || this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737380: 
                case 737390: {
                    if (this.eelib.zvkAbwaelzungPauschalKiStAn() || this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
            }
        }
        if (!pauschalPflichtModifiziert && this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(101790, this.mPauschSteuerPflDiff);
            if (this.eelib.zvkAbwaelzungPauschalLstAn()) {
                this.wplib.addNeueWertPosition(737800, this.mPauschSteuerPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737300, this.mPauschSteuerPflDiff);
            }
            if (this.eelib.zvkAbwaelzungPauschalSolZAn()) {
                this.wplib.addNeueWertPosition(737840, this.mPauschSteuerPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737340, this.mPauschSteuerPflDiff);
            }
            if (this.eelib.zvkAbwaelzungPauschalKiStAn()) {
                this.wplib.addNeueWertPosition(737880, this.mPauschSteuerPflDiff);
                this.wplib.addNeueWertPosition(737890, this.mPauschSteuerPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737380, this.mPauschSteuerPflDiff);
                this.wplib.addNeueWertPosition(737390, this.mPauschSteuerPflDiff);
            }
        }
    }

    private void ermittleAufgelWerte() throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), ValueTypeHelper.getValueTypes(100931, 100932, 100933, 100934, 100971, 100972, 100973, 100974, 100921, 100922, 100923, 100924))) {
            this.mSteuerFreiAlt = this.mSteuerFreiAlt.add(vPos.getPersistentBuffer1());
            this.mPauschSteuerPflAlt = this.mPauschSteuerPflAlt.add(vPos.getPersistentBuffer2());
            this.mSteuerPflAlt = this.mSteuerPflAlt.add(vPos.getPersistentBuffer3());
            this.mSVFreiAlt = this.mSVFreiAlt.add(vPos.getPersistentBuffer4());
            this.mSvPflAlt = this.mSvPflAlt.add(vPos.getPersistentBuffer5());
        }
    }

    private void abgrenzungNeuvertrag() throws BusinessDomainException {
        if (this.wplib.wertartenNummer() == 100933) {
            if (this.mResultDiff.compareTo(this.mSteuerFreiGrenze.subtract(this.mSteuerFreiAlt)) > 0) {
                this.holeAufgelaufeneJahreswerte();
                this.mSteuerFreiDiff = this.mResultDiff.compareTo(this.mSteuerFreiGrenze.subtract(this.mSteuerFreiAlt)) > 0 ? this.mSteuerFreiGrenze.subtract(this.mSteuerFreiAlt) : this.mResultDiff;
            } else {
                this.mSteuerFreiDiff = this.mResultDiff;
            }
            this.mSteuerPflDiff = this.mResultDiff.subtract(this.mSteuerFreiDiff);
            this.mSVFreiDiff = this.mResultDiff.compareTo(this.mSvFreiGrenze.subtract(this.mSVFreiAlt)) > 0 ? (this.mResultDiff.compareTo(this.mSvFreiGrenze.subtract(this.mSVFreiAlt)) > 0 ? this.mSvFreiGrenze.subtract(this.mSVFreiAlt) : this.mResultDiff) : this.mResultDiff;
            this.mSvPflDiff = this.mResultDiff.subtract(this.mSVFreiDiff);
        } else {
            if (BigDecimalMapper.isZero((BigDecimal)this.mSteuerFreiGrenze)) {
                this.mSteuerFreiDiff = BigDecimal.ZERO;
                this.mSteuerPflDiff = this.mResultDiff;
            } else {
                this.mSteuerFreiDiff = this.mResultDiff.compareTo(this.mSteuerFreiGrenze.subtract(this.mSteuerFreiAlt)) > 0 ? this.mSteuerFreiGrenze.subtract(this.mSteuerFreiAlt) : this.mResultDiff;
                this.mSteuerPflDiff = this.mResultDiff.subtract(this.mSteuerFreiDiff);
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.mSvFreiGrenze)) {
                this.mSVFreiDiff = BigDecimal.ZERO;
                this.mSvPflDiff = this.mResultDiff;
            } else {
                this.mSVFreiDiff = this.mResultDiff.compareTo(this.mSvFreiGrenze.subtract(this.mSVFreiAlt)) > 0 ? this.mSvFreiGrenze.subtract(this.mSVFreiAlt) : this.mResultDiff;
                this.mSvPflDiff = this.mResultDiff.subtract(this.mSVFreiDiff);
            }
        }
    }

    private void holeAufgelaufeneJahreswerte() throws BusinessDomainException {
        Date suchdatum = DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb());
        this.mSteuerFreiGrenze = BigDecimal.ZERO;
        this.mSvFreiGrenze = BigDecimal.ZERO;
        this.mSVFreiAlt = BigDecimal.ZERO;
        this.mSteuerFreiAlt = BigDecimal.ZERO;
        this.mPauschSteuerPflAlt = BigDecimal.ZERO;
        while (DateHelper.before((Date)suchdatum, (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            ValuePosition[] vpArray;
            this.mSteuerFreiGrenze = this.mSteuerFreiGrenze.add(this.gllib.svBbgRvAvMonatlBAV());
            this.mSvFreiGrenze = this.mSvFreiGrenze.add(this.gllib.svBbgRvAvMonatlBAV());
            block6: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), suchdatum, DateHelper.getLastDayOfMonth((Date)suchdatum), ValueTypeHelper.getValueTypes(111130, 111135, 111160, 111430, 111435, 111460, 111230, 111235, 111260))) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 111130: 
                    case 111135: 
                    case 111160: {
                        this.mSteuerFreiAlt = this.mSteuerFreiAlt.add(vPos.getResult());
                        continue block6;
                    }
                    case 111430: 
                    case 111435: 
                    case 111460: {
                        this.mSVFreiAlt = this.mSVFreiAlt.add(vPos.getResult());
                        continue block6;
                    }
                    case 111230: 
                    case 111235: 
                    case 111260: {
                        this.mPauschSteuerPflAlt = this.mPauschSteuerPflAlt.add(vPos.getResult());
                        continue block6;
                    }
                }
            }
            suchdatum = new VDate(suchdatum).addMonths(1).getDate();
        }
    }

    private void ermittleAufgelaufeneWerte() throws BusinessDomainException {
        if (this.wplib.wertPosition().getBufferFactor1() != null) {
            this.mBglAlt = this.wplib.wertPosition().getBufferFactor1();
        }
        if (this.wplib.wertPosition().getBufferResult() != null) {
            this.mResultatAlt = this.wplib.wertPosition().getBufferResult();
        }
    }

    private void weitergabeDerBerechnungsWerte() {
        ValuePosition nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100921));
        if (nextVP == null && (nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100922))) == null && (nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100923))) == null) {
            nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100924));
        }
        if (nextVP != null) {
            nextVP.setBufferFactor1(this.mBglNeu);
            nextVP.setBufferResult(this.mResultNeu);
        }
    }

    private ValueType[] getWerteNach3Nr63EStG() {
        return ValueTypeHelper.getValueTypes(111130, 111135, 111230, 111235, 111430, 111435, 111160, 111260, 111460);
    }

    private void aufgelaufen3Nr63ESt() throws BusinessDomainException {
        ValuePosition[] vpArray;
        this.mAufgelSteuerfrei3Nr63 = BigDecimal.ZERO;
        this.mAufgelPauschSteuerPfl = BigDecimal.ZERO;
        this.mAufgelSVfrei3Nr63 = BigDecimal.ZERO;
        block12: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.getWerteNach3Nr63EStG())) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 111130: 
                case 111135: 
                case 111160: {
                    this.mAufgelSteuerfrei3Nr63 = this.mAufgelSteuerfrei3Nr63.add(vPos.getResult());
                    continue block12;
                }
                case 111230: 
                case 111235: 
                case 111260: {
                    this.mAufgelPauschSteuerPfl = this.mAufgelPauschSteuerPfl.add(vPos.getResult());
                    continue block12;
                }
                case 111430: 
                case 111435: 
                case 111460: {
                    this.mAufgelSVfrei3Nr63 = this.mAufgelSVfrei3Nr63.add(vPos.getResult());
                }
            }
        }
        if (this.eelib.hasCFZVK(this.callib.berchnungGueltigAb())) {
            this.mAufgelSteuerfrei3Nr63 = this.mAufgelSteuerfrei3Nr63.add(this.eelib.getCFZVK3Nr63(this.callib.berchnungGueltigAb()));
            this.mAufgelPauschSteuerPfl = this.mAufgelPauschSteuerPfl.add(this.eelib.getCFZVKZusatzPauschalsteuer(this.callib.berchnungGueltigAb()));
            this.mAufgelSVfrei3Nr63 = this.mAufgelSVfrei3Nr63.add(this.eelib.getCFZVKSVfreiAusZusatzbeitrag(this.callib.berchnungGueltigAb()));
        }
        LinkedList<String> eePensionSchemeList = new LinkedList<String>();
        BigDecimal vortrag = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            ValuePosition[] aufgel;
            block14: for (ValuePosition vPos : aufgel = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes(145210, 145215, 145220, 145225, 145230, 145235, 145240, 145245, 145310, 145320, 145335, 145345, 145360, 145370, 145385, 145395, 100931, 100932, 100933, 100934, 100971, 100972, 100973, 100974, 100951, 100952, 100953, 100954))) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 145210: 
                    case 145215: 
                    case 145220: 
                    case 145225: 
                    case 145230: 
                    case 145235: 
                    case 145240: 
                    case 145245: 
                    case 145310: 
                    case 145320: 
                    case 145335: 
                    case 145345: 
                    case 145360: 
                    case 145370: 
                    case 145385: 
                    case 145395: {
                        try {
                            EEPensionSchemeTP eetp = this.wplib.getGenesisEEPensionSchemeTP(vPos);
                            if (!eePensionSchemeList.contains(eetp.getEEPensionScheme().getObjectid())) {
                                if (eetp.getCarriedForwardYear() == new VDate(this.callib.berchnungGueltigAb()).getYear() && !BigDecimalMapper.isZeroOrNull((BigDecimal)eetp.getCarriedForwardSIPaymentNew())) {
                                    vortrag = vortrag.add(eetp.getCarriedForwardSIPaymentNew());
                                }
                                eePensionSchemeList.add(eetp.getEEPensionScheme().getObjectid());
                            }
                        }
                        catch (ClassCastException e) {
                            throw EvaluationExceptionMapper.makeFalseBAVRegistrationDomainException();
                        }
                    }
                    case 100931: 
                    case 100932: 
                    case 100933: 
                    case 100934: 
                    case 100971: 
                    case 100972: 
                    case 100973: 
                    case 100974: {
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer4())) {
                            this.mAufgelSVfrei3Nr63 = this.mAufgelSVfrei3Nr63.add(vPos.getPersistentBuffer4());
                        }
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer2())) {
                            this.mAufgelPauschSteuerPfl = this.mAufgelPauschSteuerPfl.add(vPos.getPersistentBuffer2());
                        }
                    }
                    case 100951: 
                    case 100952: 
                    case 100953: 
                    case 100954: {
                        if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer1())) continue block14;
                        this.mAufgelSteuerfrei3Nr63 = this.mAufgelSteuerfrei3Nr63.add(vPos.getPersistentBuffer1());
                        continue block14;
                    }
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)vortrag)) {
            this.mAufgelSVfrei3Nr63 = vortrag.compareTo(this.mSvFreiGrenze.subtract(this.mAufgelSVfrei3Nr63)) > 0 ? this.mSvFreiGrenze : this.mAufgelSVfrei3Nr63.add(vortrag);
            this.mAufgelSteuerfrei3Nr63 = vortrag.compareTo(this.mSteuerFreiGrenze.subtract(this.mAufgelSteuerfrei3Nr63)) > 0 ? this.mSteuerFreiGrenze : this.mAufgelSteuerfrei3Nr63.add(vortrag);
        }
    }
}

