/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.ZvkSettingsEnum;
import com.varial.personnel.domain.employee.pensionscheme.AdvancementTypeEnum;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.zvk.CalcOfAddContEnum;
import com.varial.personnel.domain.employee.zvk.ZvkTypeOfCalcAddContEnum;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.lumpsumitax.ConsolidationIntoALumpSumEnum;
import com.varial.personnel.domain.global.lumpsumitax.LumpSumIncomeTax;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.LinkedList;

public class ErmittlungZVKZusatzbeitragAG2018Formula {
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private final ValuePositionLibrary wplib;
    private BigDecimal mBglAlt = BigDecimal.ZERO;
    private BigDecimal mBglNeu = BigDecimal.ZERO;
    private BigDecimal mBglZusatzAlt = BigDecimal.ZERO;
    private BigDecimal mBglZusatzNeu = BigDecimal.ZERO;
    private BigDecimal mBglZusatzDiff = BigDecimal.ZERO;
    private BigDecimal mResultatAlt = BigDecimal.ZERO;
    private BigDecimal mResultatDiff = BigDecimal.ZERO;
    private BigDecimal mResultNeu = BigDecimal.ZERO;
    private BigDecimal mSteuerFreiAlt = BigDecimal.ZERO;
    private BigDecimal mSteuerFreiDiff = BigDecimal.ZERO;
    private BigDecimal mSteuerFreiGrenze = BigDecimal.ZERO;
    private BigDecimal mSteuerPflAlt = BigDecimal.ZERO;
    private BigDecimal mSteuerPflDiff = BigDecimal.ZERO;
    private BigDecimal mPauschSteuerPflDiff = BigDecimal.ZERO;
    private BigDecimal mPauschSteuerPflAlt = BigDecimal.ZERO;
    private BigDecimal mPauschalGrenze = BigDecimal.ZERO;
    private BigDecimal mSVFreiAlt = BigDecimal.ZERO;
    private BigDecimal mSVFreiDiff = BigDecimal.ZERO;
    private BigDecimal mSvFreiGrenze = BigDecimal.ZERO;
    private BigDecimal mSvPflAlt = BigDecimal.ZERO;
    private BigDecimal mSvPflDiff = BigDecimal.ZERO;
    private BigDecimal mAufgelSteuerfrei3Nr63 = BigDecimal.ZERO;
    private BigDecimal mAufgelSteuerfrei100 = BigDecimal.ZERO;
    private BigDecimal mAufgelPauschSteuerPfl = BigDecimal.ZERO;
    private BigDecimal mAufgelSVfrei3Nr63 = BigDecimal.ZERO;
    private ValuePosition[] vpArray;

    public ErmittlungZVKZusatzbeitragAG2018Formula(CalculationLibrary calLib, EmployeeLibrary eeLib, GlobalLibrary glLib, ValuePositionLibrary wpLib) {
        this.callib = calLib;
        this.eelib = eeLib;
        this.gllib = glLib;
        this.wplib = wpLib;
    }

    public void ermittle() throws BusinessDomainException {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkVhSatzZusatzbeitragAg())) {
            this.wplib.wertPosition().makeReadOnly();
        } else {
            this.ermittleAufgelaufeneWerte();
            this.mBglNeu = this.mBglAlt.add(this.wplib.result());
            ValuePosition genesis = this.wplib.genesisParent();
            if (genesis.getValueType().getValueTypeKey() != 99992 && this.mBglNeu.compareTo(this.gllib.zvkMaximalGrenze()) > 0) {
                this.mBglNeu = this.gllib.zvkMaximalGrenze();
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkGrenzeEroehungsUmlage()) && this.mBglNeu.compareTo(this.gllib.zvkGrenzeEroehungsUmlage()) > 0) {
                this.mBglZusatzNeu = this.mBglNeu.subtract(this.gllib.zvkGrenzeEroehungsUmlage());
            }
            this.mBglZusatzDiff = this.mBglZusatzNeu.subtract(this.mBglZusatzAlt);
            this.mResultNeu = this.mBglNeu.multiply(this.gllib.zvkVhSatzZusatzbeitragAg()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
            this.mResultatDiff = this.mResultNeu.subtract(this.mResultatAlt);
            this.weitergabeDerBerechnungsWerte();
            this.abgrenzungSteuerUndSVFrei();
            this.callib.result(this.mResultatDiff);
            this.callib.percentage(this.gllib.zvkVhSatzZusatzbeitragAg());
        }
    }

    private void ermittlungSteuerpflicht() throws BusinessDomainException {
        BigDecimal differenz;
        BigDecimal aufgelaufenSteuerRelevant = this.mSteuerFreiAlt.add(this.mPauschSteuerPflAlt);
        if (this.wplib.wertartenNummer() == 100933) {
            BigDecimal steuerFreiGrenzeJahr = this.gllib.verarbeitungZVK(true) != ZvkSettingsEnum.ZSE_ABBAU_JAEHRLICH ? this.mSteuerFreiGrenze.multiply(BigDecimal.valueOf(12L)) : this.mSteuerFreiGrenze;
            if (this.mResultatDiff.compareTo(steuerFreiGrenzeJahr.subtract(aufgelaufenSteuerRelevant)) > 0) {
                this.holeAufgelaufeneJahreswerte();
                this.mSteuerFreiDiff = this.mResultatDiff.compareTo(steuerFreiGrenzeJahr.subtract(aufgelaufenSteuerRelevant)) > 0 ? steuerFreiGrenzeJahr.subtract(aufgelaufenSteuerRelevant) : this.mResultatDiff;
            } else {
                this.mSteuerFreiDiff = this.mResultatDiff;
            }
            this.mSteuerPflDiff = this.mResultatDiff.subtract(this.mSteuerFreiDiff);
        } else {
            this.mSteuerFreiDiff = this.mResultatDiff.compareTo(this.mSteuerFreiGrenze.subtract(aufgelaufenSteuerRelevant)) > 0 ? this.mSteuerFreiGrenze.subtract(aufgelaufenSteuerRelevant) : this.mResultatDiff;
            this.mSteuerPflDiff = this.mResultatDiff.subtract(this.mSteuerFreiDiff);
        }
        BigDecimal jaehrlicheSteuerFreiGrenze3Nr63ESt = this.gllib.verarbeitungZVK(true) == ZvkSettingsEnum.ZSE_ABBAU_JAEHRLICH ? this.mSteuerFreiGrenze : this.mSteuerFreiGrenze.multiply(BigDecimal.valueOf(12L));
        aufgelaufenSteuerRelevant = this.mAufgelSteuerfrei3Nr63.add(this.mAufgelPauschSteuerPfl);
        if (aufgelaufenSteuerRelevant.compareTo(jaehrlicheSteuerFreiGrenze3Nr63ESt) < 0) {
            if (this.mSteuerFreiDiff.add(aufgelaufenSteuerRelevant).compareTo(jaehrlicheSteuerFreiGrenze3Nr63ESt) > 0) {
                differenz = this.mSteuerFreiDiff.add(aufgelaufenSteuerRelevant).subtract(jaehrlicheSteuerFreiGrenze3Nr63ESt);
                if (this.mSteuerFreiDiff.compareTo(differenz) < 0) {
                    this.mSteuerPflDiff = this.mSteuerPflDiff.add(this.mSteuerFreiDiff);
                    this.mSteuerFreiDiff = BigDecimal.ZERO;
                } else {
                    this.mSteuerFreiDiff = this.mSteuerFreiDiff.subtract(differenz);
                    this.mSteuerPflDiff = this.mSteuerPflDiff.add(differenz);
                }
            }
        } else {
            this.mSteuerPflDiff = this.mSteuerPflDiff.add(this.mSteuerFreiDiff);
            this.mSteuerFreiDiff = BigDecimal.ZERO;
        }
        if (!(this.eelib.zvkBerechnungZusatzbeitrag() != ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag && this.eelib.zvkBerechnungZusatzbeitrag() != ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag_Gruppenvers || this.eelib.zvkBerechnungZusatzbeitragUeberFreigrenze() != CalcOfAddContEnum.COACE_PASCHALIERT_AN && this.eelib.zvkBerechnungZusatzbeitragUeberFreigrenze() != CalcOfAddContEnum.COACE_PAUSCHALIERT_AG || this.eelib.isZVKWeiteresVersicherungsverhaeltnis() || this.eelib.stkl() == 6 || this.mSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0 || this.mAufgelPauschSteuerPfl.compareTo(this.mPauschalGrenze) >= 0)) {
            differenz = this.mPauschalGrenze.subtract(this.mAufgelPauschSteuerPfl);
            BigDecimal pauschalGrenzeMonatlich = BigDecimal.ZERO;
            pauschalGrenzeMonatlich = this.gllib.verarbeitungZVK(true) == ZvkSettingsEnum.ZSE_ABBAU_MONATLICH ? this.mPauschalGrenze.divide(BigDecimal.valueOf(12L), RoundingMode.HALF_UP) : this.mPauschalGrenze;
            if (differenz.compareTo(pauschalGrenzeMonatlich) > 0) {
                differenz = pauschalGrenzeMonatlich.subtract(this.mPauschSteuerPflAlt);
            }
            if (this.mSteuerPflDiff.compareTo(differenz) < 0) {
                this.mPauschSteuerPflDiff = this.mSteuerPflDiff;
                this.mSteuerPflDiff = BigDecimal.ZERO;
            } else {
                this.mPauschSteuerPflDiff = differenz;
                this.mSteuerPflDiff = this.mSteuerPflDiff.subtract(differenz);
            }
        }
    }

    private void ermittlungSVPflicht() throws BusinessDomainException {
        if (this.wplib.wertartenNummer() == 100933) {
            BigDecimal svFreiGrenzeJahr = this.gllib.verarbeitungZVK(true) != ZvkSettingsEnum.ZSE_ABBAU_JAEHRLICH ? this.mSvFreiGrenze.multiply(BigDecimal.valueOf(12L)) : this.mSvFreiGrenze;
            this.mSVFreiDiff = this.mResultatDiff.compareTo(svFreiGrenzeJahr.subtract(this.mSVFreiAlt)) > 0 ? svFreiGrenzeJahr.subtract(this.mSVFreiAlt) : this.mResultatDiff;
            this.mSvPflDiff = this.mResultatDiff.subtract(this.mSVFreiDiff);
        } else {
            this.mSVFreiDiff = this.mResultatDiff.compareTo(this.mSvFreiGrenze.subtract(this.mSVFreiAlt)) > 0 ? this.mSvFreiGrenze.subtract(this.mSVFreiAlt) : this.mResultatDiff;
            this.mSvPflDiff = this.mResultatDiff.subtract(this.mSVFreiDiff);
        }
        BigDecimal jaehrlicheSVFreiGrenze3Nr63ESt = this.gllib.verarbeitungZVK(true) == ZvkSettingsEnum.ZSE_ABBAU_JAEHRLICH ? this.mSvFreiGrenze : this.mSvFreiGrenze.multiply(BigDecimal.valueOf(12L));
        if (this.mAufgelSVfrei3Nr63.compareTo(jaehrlicheSVFreiGrenze3Nr63ESt) < 0) {
            if (this.mSVFreiDiff.add(this.mAufgelSVfrei3Nr63).compareTo(jaehrlicheSVFreiGrenze3Nr63ESt) > 0) {
                BigDecimal differenz = this.mSVFreiDiff.add(this.mAufgelSVfrei3Nr63).subtract(jaehrlicheSVFreiGrenze3Nr63ESt);
                if (this.mSVFreiDiff.compareTo(differenz) < 0) {
                    this.mSvPflDiff = this.mSvPflDiff.add(this.mSVFreiDiff);
                    this.mSVFreiDiff = BigDecimal.ZERO;
                } else {
                    this.mSVFreiDiff = this.mSVFreiDiff.subtract(differenz);
                    this.mSvPflDiff = this.mSvPflDiff.add(differenz);
                }
            }
        } else {
            this.mSvPflDiff = this.mSvPflDiff.add(this.mSVFreiDiff);
            this.mSVFreiDiff = BigDecimal.ZERO;
        }
    }

    private void holeAufgelaufeneJahreswerte() throws BusinessDomainException {
        Date suchdatum = DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb());
        this.mSteuerFreiGrenze = BigDecimal.ZERO;
        this.mSvFreiGrenze = BigDecimal.ZERO;
        this.mSVFreiAlt = BigDecimal.ZERO;
        this.mSteuerFreiAlt = BigDecimal.ZERO;
        this.mPauschSteuerPflAlt = BigDecimal.ZERO;
        while (DateHelper.before((Date)suchdatum, (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            if (!this.eelib.isZVKWeiteresVersicherungsverhaeltnis() && this.eelib.stkl() != 6) {
                this.mSteuerFreiGrenze = this.mSteuerFreiGrenze.add(this.gllib.svBbgRvAvMonatlBAV());
                this.mSvFreiGrenze = this.mSvFreiGrenze.add(this.gllib.svBbgRvAvMonatlBAV());
            }
            block6: for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), suchdatum, DateHelper.getLastDayOfMonth((Date)suchdatum), ValueTypeHelper.getValueTypes(111130, 111135, 111160, 111230, 111235, 111260, 111430, 111435, 111460))) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 111130: 
                    case 111135: 
                    case 111160: {
                        this.mSteuerFreiAlt = this.mSteuerFreiAlt.add(vPos.getResult());
                        continue block6;
                    }
                    case 111430: 
                    case 111435: 
                    case 111460: {
                        this.mSVFreiAlt = this.mSVFreiAlt.add(vPos.getResult());
                        continue block6;
                    }
                    case 111230: 
                    case 111235: 
                    case 111260: {
                        this.mPauschSteuerPflAlt = this.mPauschSteuerPflAlt.add(vPos.getResult());
                        continue block6;
                    }
                }
            }
            suchdatum = new VDate(suchdatum).addMonths(1).getDate();
        }
    }

    private void abgrenzungSteuerUndSVFrei() throws BusinessDomainException {
        this.ermittleAufgelWerte();
        if (!this.eelib.isZVKWeiteresVersicherungsverhaeltnis() && this.eelib.stkl() != 6) {
            this.mSteuerFreiGrenze = this.gllib.svBbgRvAvMonatlBAV(this.eelib.zvkBerechnungZusatzbeitrag());
            this.mSvFreiGrenze = this.gllib.svBbgRvAvMonatlBAV();
        }
        if (!(this.eelib.zvkBerechnungZusatzbeitrag() != ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag && this.eelib.zvkBerechnungZusatzbeitrag() != ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag_Gruppenvers || this.eelib.zvkBerechnungZusatzbeitragUeberFreigrenze() != CalcOfAddContEnum.COACE_PASCHALIERT_AN && this.eelib.zvkBerechnungZusatzbeitragUeberFreigrenze() != CalcOfAddContEnum.COACE_PAUSCHALIERT_AG)) {
            LumpSumIncomeTax lit;
            if (this.eelib.zvkBerechnungZusatzbeitrag() == ZvkTypeOfCalcAddContEnum.ZTOCACE_Altvertrag_Gruppenvers) {
                lit = LumpSumIncomeTax.getLumpSumIncomeTax((ConsolidationIntoALumpSumEnum)ConsolidationIntoALumpSumEnum.CIALSE_Pauschalierungsgrenze_Gruppenversicherung);
                this.mPauschalGrenze = lit.getLumpSumIncomeTaxTP(this.wplib.wirksamAb(), this.wplib.gueltigAb()).getAmount();
            } else {
                lit = LumpSumIncomeTax.getLumpSumIncomeTax((ConsolidationIntoALumpSumEnum)ConsolidationIntoALumpSumEnum.CIALSE_jaehrliche_Pauschalierungsgrenze);
                this.mPauschalGrenze = lit.getLumpSumIncomeTaxTP(this.wplib.wirksamAb(), this.wplib.gueltigAb()).getAmount();
            }
            this.mSvFreiGrenze = this.mSvFreiGrenze.add(this.mPauschalGrenze.divide(BigDecimal.valueOf(12L), 2, RoundingMode.HALF_UP));
        }
        if (this.gllib.verarbeitungZVK(true) == ZvkSettingsEnum.ZSE_ABBAU_JAEHRLICH) {
            this.mSteuerFreiGrenze = this.mSteuerFreiGrenze.multiply(BigDecimal.valueOf(12L));
            this.mSvFreiGrenze = this.mSvFreiGrenze.multiply(BigDecimal.valueOf(12L));
        }
        this.ermittleFoederbetragP100();
        this.aufgelaufen3Nr63ESt();
        this.ermittlungSteuerpflicht();
        this.ermittlungSVPflicht();
        if (this.mSteuerFreiDiff.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal zvkFoerderbetrag = this.callib.getCalculationCase().getZVKFoerderbetrag();
            if (BigDecimalMapper.compareTo((BigDecimal)zvkFoerderbetrag, (BigDecimal)BigDecimal.ZERO) > 0) {
                if (BigDecimalMapper.compareTo((BigDecimal)zvkFoerderbetrag, (BigDecimal)this.mSteuerFreiDiff) >= 0) {
                    this.wplib.addNeueWertPosition(111125, this.mSteuerFreiDiff);
                    this.callib.getCalculationCase().setZVKFoerderbetrag(zvkFoerderbetrag.subtract(this.mSteuerFreiDiff));
                } else {
                    BigDecimal diff = this.mSteuerFreiDiff.subtract(zvkFoerderbetrag);
                    this.wplib.addNeueWertPosition(111125, zvkFoerderbetrag);
                    this.wplib.addNeueWertPosition(111130, diff);
                    this.callib.getCalculationCase().setZVKFoerderbetrag(BigDecimal.ZERO);
                }
            } else {
                this.wplib.addNeueWertPosition(111130, this.mSteuerFreiDiff);
            }
        }
        this.wplib.persistentBuffer1(this.mSteuerFreiDiff.subtract(this.mPauschSteuerPflDiff));
        if (this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(111230, this.mPauschSteuerPflDiff);
            this.wplib.persistentBuffer2(this.mPauschSteuerPflDiff);
            this.wplib.addNeueWertPosition(111130, this.mPauschSteuerPflDiff.negate());
        }
        if (this.mSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(111330, this.mSteuerPflDiff);
            this.wplib.persistentBuffer3(this.mSteuerPflDiff);
        }
        if (this.mSVFreiDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(111430, this.mSVFreiDiff);
            this.wplib.persistentBuffer4(this.mSVFreiDiff);
        }
        if (this.mSvPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(111530, this.mSvPflDiff);
            this.wplib.persistentBuffer5(this.mSvPflDiff);
        }
        this.mSteuerPflDiff = this.mSteuerPflDiff.add(this.mPauschSteuerPflDiff);
        if (this.wplib.wertPosition().getValueType().getValueTypeKey() == 100932) {
            this.erzeugeSteuerUndBeitragspflicht();
        } else {
            this.modifiziereSteuerUndBeitragspflicht();
        }
    }

    private void ermittleFoederbetragP100() throws BusinessDomainException {
        if (this.eelib.getEinrechnungFoerderbetrag100EStG() != AdvancementTypeEnum.NEIN && !this.callib.getCalculationCase().isZVKFoerderbetragChecked()) {
            this.callib.getCalculationCase().setZVKFoerderbetragChecked(true);
            BigDecimal zusatzbeitragVor2017 = BigDecimal.ZERO;
            BigDecimal zusatzbeitragAb2017 = BigDecimal.ZERO;
            BigDecimal aGGesamtBeitrag = this.ermittleAGGesamtBeitrag();
            if (this.eelib.getEinrechnungFoerderbetrag100EStG() == AdvancementTypeEnum.JA_VOR_2017) {
                BigDecimal VergleichswertAGZusatzbeitrag = this.eelib.getVergleichswertAGZusatzbeitrag();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)VergleichswertAGZusatzbeitrag)) {
                    if (BigDecimalMapper.compareTo((BigDecimal)VergleichswertAGZusatzbeitrag, (BigDecimal)aGGesamtBeitrag) < 0) {
                        zusatzbeitragVor2017 = VergleichswertAGZusatzbeitrag;
                        zusatzbeitragAb2017 = aGGesamtBeitrag.subtract(VergleichswertAGZusatzbeitrag);
                    }
                } else {
                    zusatzbeitragVor2017 = aGGesamtBeitrag;
                }
            } else {
                zusatzbeitragAb2017 = aGGesamtBeitrag;
            }
            BigDecimal deckelungsbetrag = zusatzbeitragAb2017;
            BigDecimal foerderbetragVor2017 = this.wplib.checkBAVAGLeistungen(zusatzbeitragVor2017);
            this.wplib.addNeueWertPosition(145515, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, zusatzbeitragVor2017, false, deckelungsbetrag, foerderbetragVor2017, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            BigDecimal foerderbetragAb2017 = this.wplib.checkBAVAGLeistungen(zusatzbeitragAb2017);
            this.wplib.addNeueWertPosition(145516, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, zusatzbeitragAb2017, false, deckelungsbetrag, foerderbetragAb2017, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            BigDecimal zvkFoerderbetrag = foerderbetragVor2017.add(foerderbetragAb2017);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)zvkFoerderbetrag)) {
                this.callib.getCalculationCase().setHasZVKFoerderbetrag(true);
                this.callib.getCalculationCase().setZVKFoerderbetrag(zvkFoerderbetrag);
            }
        }
    }

    private BigDecimal ermittleAGGesamtBeitrag() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal aGGesamtBeitrag = BigDecimal.ZERO;
        for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes(100931, 100932, 100933, 100934))) {
            aGGesamtBeitrag = aGGesamtBeitrag.add(vPos.getResult());
        }
        aGGesamtBeitrag = aGGesamtBeitrag.multiply(this.gllib.zvkVhSatzZusatzbeitragAg()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        return aGGesamtBeitrag;
    }

    private void erzeugeSteuerUndBeitragspflicht() throws BusinessDomainException {
        if (this.mSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(110510, this.mSteuerPflDiff);
        }
        if (this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(101790, this.mPauschSteuerPflDiff);
            if (this.eelib.zvkAbwaelzungPauschalLstAnZusatzbeitrag()) {
                this.wplib.addNeueWertPosition(737800, this.mPauschSteuerPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737300, this.mPauschSteuerPflDiff);
            }
            if (this.eelib.zvkAbwaelzungPauschalSolZAnZusatzbeitrag()) {
                this.wplib.addNeueWertPosition(737840, this.mPauschSteuerPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737340, this.mPauschSteuerPflDiff);
            }
            if (this.eelib.zvkAbwaelzungPauschalKiStAnZusatzbeitrag()) {
                this.wplib.addNeueWertPosition(737880, this.mPauschSteuerPflDiff);
                this.wplib.addNeueWertPosition(737890, this.mPauschSteuerPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737380, this.mPauschSteuerPflDiff);
                this.wplib.addNeueWertPosition(737390, this.mPauschSteuerPflDiff);
            }
        }
        if (this.mSvPflDiff.compareTo(BigDecimal.ZERO) != 0 && this.wplib.svTageLfd().compareTo(BigDecimal.ZERO) > 0) {
            this.wplib.addNeueWertPosition(130510, this.mSvPflDiff);
        }
    }

    private void ermittleAufgelaufeneWerte() throws BusinessDomainException {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferFactor1())) {
            this.mBglAlt = this.wplib.wertPosition().getBufferFactor1();
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferFactor2())) {
            this.mBglZusatzAlt = this.wplib.wertPosition().getBufferFactor2();
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferResult())) {
            this.mResultatAlt = this.wplib.wertPosition().getBufferResult();
        }
    }

    private void ermittleAufgelWerte() throws BusinessDomainException {
        ValuePosition[] vpArray;
        for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), this.getWertarten())) {
            this.mSteuerFreiAlt = this.mSteuerFreiAlt.add(vPos.getPersistentBuffer1());
            this.mPauschSteuerPflAlt = this.mPauschSteuerPflAlt.add(vPos.getPersistentBuffer2());
            this.mSteuerPflAlt = this.mSteuerPflAlt.add(vPos.getPersistentBuffer3());
            this.mSVFreiAlt = this.mSVFreiAlt.add(vPos.getPersistentBuffer4());
            this.mSvPflAlt = this.mSvPflAlt.add(vPos.getPersistentBuffer5());
        }
    }

    private ValueType[] getWertarten() {
        return ValueTypeHelper.getValueTypes(100931, 100932, 100933, 100934, 100921, 100922, 100923, 100924, 100971, 100972, 100973, 100974);
    }

    private void modifiziereSteuerUndBeitragspflicht() throws BusinessDomainException {
        boolean pauschalBruttoModifiziert = false;
        boolean pauschalSteuernModifiziert = false;
        block11: for (ValuePosition vPos : this.vpArray = this.wplib.genesisUndFolgen()) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 110510: 
                case 110610: 
                case 110620: {
                    if (this.mSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mSteuerPflDiff));
                    continue block11;
                }
                case 109150: 
                case 109170: 
                case 109510: 
                case 109530: 
                case 129610: 
                case 130510: 
                case 130560: 
                case 130610: 
                case 135200: 
                case 135300: 
                case 135400: {
                    if (this.mSvPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mSvPflDiff));
                    continue block11;
                }
                case 101790: {
                    pauschalBruttoModifiziert = true;
                    if (this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737800: {
                    if (!this.eelib.zvkAbwaelzungPauschalLstAnZusatzbeitrag()) continue block11;
                    pauschalSteuernModifiziert = true;
                    if (this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737300: {
                    if (this.eelib.zvkAbwaelzungPauschalLstAnZusatzbeitrag()) continue block11;
                    pauschalSteuernModifiziert = true;
                    if (this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737840: {
                    if (!this.eelib.zvkAbwaelzungPauschalSolZAnZusatzbeitrag() || this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737340: {
                    if (this.eelib.zvkAbwaelzungPauschalSolZAnZusatzbeitrag() || this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737880: 
                case 737890: {
                    if (!this.eelib.zvkAbwaelzungPauschalKiStAnZusatzbeitrag() || this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
                case 737380: 
                case 737390: {
                    if (this.eelib.zvkAbwaelzungPauschalKiStAnZusatzbeitrag() || this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block11;
                    vPos.setResult(vPos.getResult().add(this.mPauschSteuerPflDiff));
                    continue block11;
                }
            }
        }
        if (this.mPauschSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            if (!pauschalBruttoModifiziert) {
                this.wplib.addNeueWertPosition(101790, this.mPauschSteuerPflDiff);
            }
            if (!pauschalSteuernModifiziert) {
                if (this.eelib.zvkAbwaelzungPauschalLstAnZusatzbeitrag()) {
                    this.wplib.addNeueWertPosition(737800, this.mPauschSteuerPflDiff);
                } else {
                    this.wplib.addNeueWertPosition(737300, this.mPauschSteuerPflDiff);
                }
                if (this.eelib.zvkAbwaelzungPauschalSolZAnZusatzbeitrag()) {
                    this.wplib.addNeueWertPosition(737840, this.mPauschSteuerPflDiff);
                } else {
                    this.wplib.addNeueWertPosition(737340, this.mPauschSteuerPflDiff);
                }
                if (this.eelib.zvkAbwaelzungPauschalKiStAnZusatzbeitrag()) {
                    this.wplib.addNeueWertPosition(737880, this.mPauschSteuerPflDiff);
                    this.wplib.addNeueWertPosition(737890, this.mPauschSteuerPflDiff);
                } else {
                    this.wplib.addNeueWertPosition(737380, this.mPauschSteuerPflDiff);
                    this.wplib.addNeueWertPosition(737390, this.mPauschSteuerPflDiff);
                }
            }
        }
    }

    private void weitergabeDerBerechnungsWerte() throws BusinessDomainException {
        ValuePosition nextVP = this.wplib.naechsteWP(ValueTypeHelper.getValueType(100931));
        if (nextVP == null && (nextVP = this.wplib.naechsteWP(ValueTypeHelper.getValueType(100932))) == null && (nextVP = this.wplib.naechsteWP(ValueTypeHelper.getValueType(100933))) == null) {
            nextVP = this.wplib.naechsteWP(ValueTypeHelper.getValueType(100934));
        }
        if (nextVP != null) {
            nextVP.setBufferFactor1(this.mBglNeu);
            nextVP.setBufferFactor2(this.mBglZusatzNeu);
            nextVP.setBufferResult(this.mResultNeu);
        }
        if (this.mBglZusatzDiff.compareTo(BigDecimal.ZERO) > 0) {
            switch (this.wplib.wertartenNummer()) {
                case 100931: {
                    this.wplib.addNeueWertPosition(100971, BigDecimalMapper.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mBglZusatzDiff, false);
                    break;
                }
                case 100932: {
                    this.wplib.addNeueWertPosition(100972, BigDecimalMapper.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mBglZusatzDiff, false);
                    break;
                }
                case 100933: {
                    this.wplib.addNeueWertPosition(100973, BigDecimalMapper.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mBglZusatzDiff, false);
                    break;
                }
                case 100934: {
                    this.wplib.addNeueWertPosition(100974, BigDecimalMapper.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mBglZusatzDiff, false);
                }
            }
        }
    }

    private ValueType[] getWerteNach3Nr63EStG() {
        return ValueTypeHelper.getValueTypes(111125, 111130, 111135, 111230, 111235, 111430, 111435, 111160, 111260, 111460);
    }

    private void aufgelaufen3Nr63ESt() throws BusinessDomainException {
        this.mAufgelSteuerfrei3Nr63 = BigDecimal.ZERO;
        this.mAufgelSteuerfrei100 = BigDecimal.ZERO;
        this.mAufgelPauschSteuerPfl = BigDecimal.ZERO;
        this.mAufgelSVfrei3Nr63 = BigDecimal.ZERO;
        block16: for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.getWerteNach3Nr63EStG())) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 111125: {
                    this.mAufgelSteuerfrei100 = this.mAufgelSteuerfrei100.add(vPos.getResult());
                    continue block16;
                }
                case 111130: 
                case 111135: 
                case 111160: {
                    this.mAufgelSteuerfrei3Nr63 = this.mAufgelSteuerfrei3Nr63.add(vPos.getResult());
                    continue block16;
                }
                case 111230: 
                case 111235: 
                case 111260: {
                    this.mAufgelPauschSteuerPfl = this.mAufgelPauschSteuerPfl.add(vPos.getResult());
                    continue block16;
                }
                case 111430: 
                case 111435: 
                case 111460: {
                    this.mAufgelSVfrei3Nr63 = this.mAufgelSVfrei3Nr63.add(vPos.getResult());
                }
            }
        }
        if (this.eelib.hasCFZVK(this.callib.berchnungGueltigAb())) {
            this.mAufgelSteuerfrei3Nr63 = this.mAufgelSteuerfrei3Nr63.add(this.eelib.getCFZVK3Nr63(this.callib.berchnungGueltigAb()));
            this.mAufgelPauschSteuerPfl = this.mAufgelPauschSteuerPfl.add(this.eelib.getCFZVKZusatzPauschalsteuer(this.callib.berchnungGueltigAb()));
            this.mAufgelSVfrei3Nr63 = this.mAufgelSVfrei3Nr63.add(this.eelib.getCFZVKSVfreiAusZusatzbeitrag(this.callib.berchnungGueltigAb()));
        }
        LinkedList<String> eePensionSchemeList = new LinkedList<String>();
        BigDecimal vortrag = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            ValuePosition[] aufgel;
            block18: for (ValuePosition vPos : aufgel = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes(145210, 145215, 145220, 145225, 145230, 145235, 145240, 145245, 145310, 145320, 145335, 145345, 145360, 145370, 145385, 145395, 100931, 100932, 100933, 100934, 100971, 100972, 100973, 100974, 100951, 100952, 100953, 100954))) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 145210: 
                    case 145215: 
                    case 145220: 
                    case 145225: 
                    case 145230: 
                    case 145235: 
                    case 145240: 
                    case 145245: 
                    case 145310: 
                    case 145320: 
                    case 145335: 
                    case 145345: 
                    case 145360: 
                    case 145370: 
                    case 145385: 
                    case 145395: {
                        boolean altvertrag = false;
                        try {
                            EEPensionSchemeTP eetp = this.wplib.getGenesisEEPensionSchemeTP(vPos);
                            switch (eetp.getContractType().value()) {
                                case 0: {
                                    altvertrag = true;
                                    break;
                                }
                                default: {
                                    if (!eePensionSchemeList.contains(eetp.getEEPensionScheme().getObjectid())) {
                                        if (eetp.getCarriedForwardYear() == new VDate(this.callib.berchnungGueltigAb()).getYear() && !BigDecimalMapper.isZeroOrNull((BigDecimal)eetp.getCarriedForwardSIPaymentNew())) {
                                            vortrag = vortrag.add(eetp.getCarriedForwardSIPaymentNew());
                                        }
                                        eePensionSchemeList.add(eetp.getEEPensionScheme().getObjectid());
                                    }
                                    break;
                                }
                            }
                        }
                        catch (ClassCastException e) {
                            throw EvaluationExceptionMapper.makeFalseBAVRegistrationDomainException();
                        }
                        if (altvertrag) continue block18;
                    }
                    case 100931: 
                    case 100932: 
                    case 100933: 
                    case 100934: 
                    case 100971: 
                    case 100972: 
                    case 100973: 
                    case 100974: {
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer4())) {
                            this.mAufgelSVfrei3Nr63 = this.mAufgelSVfrei3Nr63.add(vPos.getPersistentBuffer4());
                        }
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer2())) {
                            this.mAufgelPauschSteuerPfl = this.mAufgelPauschSteuerPfl.add(vPos.getPersistentBuffer2());
                        }
                    }
                    case 100951: 
                    case 100952: 
                    case 100953: 
                    case 100954: {
                        if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer1())) continue block18;
                        this.mAufgelSteuerfrei3Nr63 = this.mAufgelSteuerfrei3Nr63.add(vPos.getPersistentBuffer1());
                        continue block18;
                    }
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)vortrag)) {
            this.mAufgelSVfrei3Nr63 = vortrag.compareTo(this.mSvFreiGrenze.subtract(this.mAufgelSVfrei3Nr63)) > 0 ? this.mSvFreiGrenze : this.mAufgelSVfrei3Nr63.add(vortrag);
            this.mAufgelSteuerfrei3Nr63 = vortrag.compareTo(this.mSteuerFreiGrenze.subtract(this.mAufgelSteuerfrei3Nr63)) > 0 ? this.mSteuerFreiGrenze : this.mAufgelSteuerfrei3Nr63.add(vortrag);
        }
    }
}

