/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungZVKZusatzUmlageAGFormula {
    private final CalculationLibrary callib;
    private final GlobalLibrary gllib;
    private BigDecimal mBglAlt = BigDecimal.ZERO;
    private BigDecimal mBglNeu = BigDecimal.ZERO;
    private BigDecimal mResultatAlt = BigDecimal.ZERO;
    private BigDecimal mResultDiff = BigDecimal.ZERO;
    private BigDecimal mResultNeu = BigDecimal.ZERO;
    private BigDecimal mSteuerPfl = BigDecimal.ZERO;
    private BigDecimal mSvPfl = BigDecimal.ZERO;
    private ValuePosition[] vpArray;
    private final ValuePositionLibrary wplib;
    private final EmployeeLibrary eelib;

    public ErmittlungZVKZusatzUmlageAGFormula(CalculationLibrary calLibrary, EmployeeLibrary eeLibrary, GlobalLibrary glLibrary, ValuePositionLibrary wpLibrary) {
        this.callib = calLibrary;
        this.eelib = eeLibrary;
        this.gllib = glLibrary;
        this.wplib = wpLibrary;
    }

    public void ermittle() throws BusinessDomainException {
        if (this.eelib.isZVKZusatzumlage()) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkVhSatzZusatzUmlageAG())) {
                this.ermittleAufgelaufeneWerte();
                this.mBglNeu = this.mBglAlt.add(this.wplib.result());
                ValuePosition genesis = this.wplib.genesisParent();
                if (genesis.getValueType().getValueTypeKey() != 99992 && this.mBglNeu.compareTo(this.gllib.zvkMaximalGrenze().subtract(this.gllib.zvkGrenzeEroehungsUmlage())) > 0) {
                    this.mBglNeu = this.gllib.zvkMaximalGrenze().subtract(this.gllib.zvkGrenzeEroehungsUmlage());
                }
                this.mResultNeu = this.mBglNeu.multiply(this.gllib.zvkVhSatzZusatzUmlageAG()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
                this.mSteuerPfl = this.mResultDiff = this.mResultNeu.subtract(this.mResultatAlt);
                this.mSvPfl = this.mResultDiff;
                if (this.mSteuerPfl.compareTo(BigDecimal.ZERO) != 0) {
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2012, 0, 1).getDate())) {
                        this.wplib.addNeueWertPosition(111350, this.mSteuerPfl);
                    }
                    this.wplib.persistentBuffer3(this.mSteuerPfl);
                }
                if (this.mSvPfl.compareTo(BigDecimal.ZERO) != 0) {
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2012, 0, 1).getDate())) {
                        this.wplib.addNeueWertPosition(111550, this.mSvPfl);
                    }
                    this.wplib.persistentBuffer5(this.mSvPfl);
                }
            }
            this.modifiziereSteuerUndBeitragspflicht();
            this.weitergabeDerBerechnungsWerte();
            this.callib.result(this.mResultDiff);
            this.callib.percentage(this.gllib.zvkVhSatzZusatzUmlageAG());
        } else {
            this.wplib.wertPosition().makeReadOnly();
        }
    }

    private void ermittleAufgelaufeneWerte() throws BusinessDomainException {
        this.mBglAlt = BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferFactor1()) ? BigDecimal.ZERO : this.wplib.wertPosition().getBufferFactor1();
        this.mResultatAlt = BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferResult()) ? BigDecimal.ZERO : this.wplib.wertPosition().getBufferResult();
    }

    private void modifiziereSteuerUndBeitragspflicht() throws BusinessDomainException {
        block5: for (ValuePosition vPos : this.vpArray = this.wplib.genesisUndFolgen()) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 110510: 
                case 110610: 
                case 110620: {
                    if (this.mSteuerPfl.compareTo(BigDecimal.ZERO) <= 0) continue block5;
                    vPos.setResult(vPos.getResult().add(this.mSteuerPfl));
                    continue block5;
                }
                case 115200: {
                    if (this.gllib.bundeslandSchluesselBeschaeftigungsort() != 10 || this.mSvPfl.compareTo(BigDecimal.ZERO) == 0) continue block5;
                    vPos.setResult(vPos.getResult().add(this.mSvPfl));
                    continue block5;
                }
                case 109150: 
                case 109170: 
                case 109510: 
                case 109530: 
                case 129610: 
                case 130510: 
                case 130560: 
                case 130610: {
                    if (this.mSvPfl.compareTo(BigDecimal.ZERO) <= 0) continue block5;
                    vPos.setResult(vPos.getResult().add(this.mSvPfl));
                    continue block5;
                }
            }
        }
    }

    private void weitergabeDerBerechnungsWerte() {
        ValuePosition nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100961));
        if (nextVP == null && (nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100962))) == null && (nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100963))) == null) {
            nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100964));
        }
        if (nextVP != null) {
            nextVP.setBufferFactor1(this.mBglNeu);
            nextVP.setBufferResult(this.mResultNeu);
        }
    }
}

