/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.ZvkSettingsEnum;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.LinkedList;

public class ErmittlungZVKUmlageAG2016Formula {
    private static final BigDecimal ZWOELF = BigDecimal.valueOf(12L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private final ValuePositionLibrary wplib;
    private BigDecimal arevBetrag = BigDecimal.ZERO;
    private BigDecimal mBglAlt = BigDecimal.ZERO;
    private BigDecimal mBglNeu = BigDecimal.ZERO;
    private BigDecimal mBglZusatzAlt = BigDecimal.ZERO;
    private BigDecimal mBglZusatzNeu = BigDecimal.ZERO;
    private BigDecimal mBglZusatzDiff = BigDecimal.ZERO;
    private BigDecimal mPauschalPflNeu = BigDecimal.ZERO;
    private BigDecimal mPauschalPflDiff = BigDecimal.ZERO;
    private BigDecimal mResultatAlt = BigDecimal.ZERO;
    private BigDecimal mResultNeu = BigDecimal.ZERO;
    private BigDecimal mResultatDiff = BigDecimal.ZERO;
    private BigDecimal mSteuerfreiNeu = BigDecimal.ZERO;
    private BigDecimal mSteuerfreiDiff = BigDecimal.ZERO;
    private BigDecimal mSteuerPflDiff = BigDecimal.ZERO;
    private BigDecimal mSteuerPflNeu = BigDecimal.ZERO;
    private BigDecimal mSteuerPflausAufrechnung = BigDecimal.ZERO;
    private BigDecimal mSvPflDiff = BigDecimal.ZERO;
    private BigDecimal mSvPflNeu = BigDecimal.ZERO;
    private BigDecimal mAufgelPauschalPflUmlageMonat = BigDecimal.ZERO;
    private BigDecimal mAufgelSteuerfreiUmlageMonat = BigDecimal.ZERO;
    private BigDecimal mAufgelSteuerPflUmlageMonat = BigDecimal.ZERO;
    private BigDecimal mAufgelSvfreiUmlageMonat = BigDecimal.ZERO;
    private BigDecimal mAufgelSvPflUmlageMonat = BigDecimal.ZERO;
    private BigDecimal mAufgelPauschalPflUmlageJahr = BigDecimal.ZERO;
    private BigDecimal mAufgelSteuerfreiUmlageJahr = BigDecimal.ZERO;
    private BigDecimal mAufgelSteuerPflUmlageJahr = BigDecimal.ZERO;
    private BigDecimal mAufgelSvfreiUmlageJahr = BigDecimal.ZERO;
    private BigDecimal mAufgelSvPflUmlageJahr = BigDecimal.ZERO;
    private BigDecimal mAufgelSteuerFreibetrag3Nr63Monat = BigDecimal.ZERO;
    private BigDecimal mAufgelSteuerFreibetrag3Nr63Jahr = BigDecimal.ZERO;
    private BigDecimal mAufgelPauschalbetrag3Nr63Jahr = BigDecimal.ZERO;
    private ValuePosition[] vpArray;
    private BigDecimal mSvfreiNeu = BigDecimal.ZERO;
    private BigDecimal mSvfreiDiff = BigDecimal.ZERO;
    private BigDecimal mMassgeblicheSteuerfreigrenze = BigDecimal.ZERO;

    public ErmittlungZVKUmlageAG2016Formula(CalculationLibrary calLibrary, EmployeeLibrary eeLibrary, GlobalLibrary glLibrary, ValuePositionLibrary wpLibrary) {
        this.callib = calLibrary;
        this.eelib = eeLibrary;
        this.gllib = glLibrary;
        this.wplib = wpLibrary;
    }

    public void ermittle() throws BusinessDomainException {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkVhSatzUmlageAg())) {
            this.wplib.wertPosition().makeReadOnly();
        } else {
            ValuePosition genesis;
            this.ermittleAufgelAGUmlage();
            this.mBglNeu = this.mBglAlt.add(this.wplib.result());
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkMaximalGrenze()) && (genesis = this.wplib.genesisParent()).getValueType().getValueTypeKey() != 99992 && this.mBglNeu.compareTo(this.gllib.zvkMaximalGrenze()) > 0) {
                this.mBglNeu = this.gllib.zvkMaximalGrenze();
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkGrenzeEroehungsUmlage()) && this.mBglNeu.compareTo(this.gllib.zvkGrenzeEroehungsUmlage()) > 0) {
                this.mBglZusatzNeu = this.mBglNeu.subtract(this.gllib.zvkGrenzeEroehungsUmlage());
            }
            this.mBglZusatzDiff = this.mBglZusatzNeu.subtract(this.mBglZusatzAlt);
            this.mResultNeu = this.mBglNeu.multiply(this.gllib.zvkVhSatzUmlageAg()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            this.mResultatDiff = this.mResultNeu.subtract(this.mResultatAlt);
            this.weitergabeDerBerechnungsWerte();
            this.steuerlicheBetrachtung();
            if (this.wplib.wertPosition().getValueType().getValueTypeKey() == 100952) {
                this.erzeugeSteuerUndBeitragspflicht(false);
            } else {
                genesis = this.wplib.genesisParent();
                if (genesis.getValueType().getValueTypeKey() == 99991) {
                    this.erzeugeSteuerUndBeitragspflicht(false);
                } else {
                    this.modifiziereSteuerUndBeitragspflicht();
                }
            }
            this.callib.result(this.mResultatDiff);
            this.callib.percentage(this.gllib.zvkVhSatzUmlageAg());
        }
    }

    private void weitergabeDerBerechnungsWerte() throws BusinessDomainException {
        ValuePosition nextVP = this.wplib.naechsteWP(ValueTypeHelper.getValueType(100951));
        if (nextVP == null && (nextVP = this.wplib.naechsteWP(ValueTypeHelper.getValueType(100952))) == null && (nextVP = this.wplib.naechsteWP(ValueTypeHelper.getValueType(100953))) == null) {
            nextVP = this.wplib.naechsteWP(ValueTypeHelper.getValueType(100954));
        }
        if (nextVP != null) {
            nextVP.setBufferFactor1(this.mBglNeu);
            nextVP.setBufferFactor2(this.mBglZusatzNeu);
            nextVP.setBufferResult(this.mResultNeu);
        }
        if (this.mBglZusatzDiff.compareTo(BigDecimal.ZERO) > 0) {
            switch (this.wplib.wertartenNummer()) {
                case 100951: {
                    this.wplib.addNeueWertPosition(100961, BigDecimalMapper.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mBglZusatzDiff, false);
                    break;
                }
                case 100952: {
                    this.wplib.addNeueWertPosition(100962, BigDecimalMapper.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mBglZusatzDiff, false);
                    break;
                }
                case 100953: {
                    this.wplib.addNeueWertPosition(100963, BigDecimalMapper.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mBglZusatzDiff, false);
                    break;
                }
                case 100954: {
                    this.wplib.addNeueWertPosition(100964, BigDecimalMapper.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mBglZusatzDiff, false);
                }
            }
        }
    }

    private void ermittleAufgelAGUmlage() throws BusinessDomainException {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferFactor1())) {
            this.mBglAlt = this.wplib.wertPosition().getBufferFactor1();
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferFactor2())) {
            this.mBglZusatzAlt = this.wplib.wertPosition().getBufferFactor2();
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getBufferResult())) {
            this.mResultatAlt = this.wplib.wertPosition().getBufferResult();
        }
    }

    private void steuerlicheBetrachtung() throws BusinessDomainException {
        this.aufgelNach3Nr63Und3Nr56EStGImMonat();
        this.aufgelNach3Nr63Und3Nr56EStGImJahr();
        this.abgrenzungSteuerFrei3Nr56();
        this.abgrenzungPauschPflichtNach40b();
        if (this.mSteuerfreiNeu.compareTo(BigDecimal.ZERO) < 0) {
            this.mSteuerPflNeu = this.mSteuerPflNeu.add(this.mSteuerfreiNeu.negate());
            this.mSteuerfreiNeu = BigDecimal.ZERO;
        }
        this.ermittleSteuerpfl();
        this.svBetrachtung();
        if ((DateHelper.equal((Date)DateHelper.getLastDayOfYear((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb())) || this.marbAustritt()) && this.eelib.zvkAufrechnungJahresendeAustritt() && this.gllib.verarbeitungZVK(false) == ZvkSettingsEnum.ZSE_ABBAU_MONATLICH) {
            this.bewerte3Nr56EStGAustrittJahresende();
            this.ermittleSteuerpfl();
        }
        this.mSteuerfreiDiff = this.mSteuerfreiNeu.subtract(this.mAufgelSteuerfreiUmlageMonat);
        this.mPauschalPflDiff = this.mPauschalPflNeu.subtract(this.mAufgelPauschalPflUmlageMonat);
        this.mSteuerPflDiff = this.mSteuerPflNeu.subtract(this.mAufgelSteuerPflUmlageMonat);
        if (this.mSteuerfreiDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(111140, this.mSteuerfreiDiff);
            this.wplib.persistentBuffer1(this.mSteuerfreiDiff);
        }
        if (this.mPauschalPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(111240, this.mPauschalPflDiff);
            this.wplib.persistentBuffer2(this.mPauschalPflDiff);
        }
        if (this.mSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(111340, this.mSteuerPflDiff);
            this.wplib.persistentBuffer3(this.mSteuerPflDiff);
        }
    }

    private boolean marbAustritt() throws BusinessDomainException {
        boolean marbAustritt = false;
        Date aktuellerMonat = DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb());
        if (this.eelib.marbAustritt() != null && DateHelper.equal((Date)DateHelper.getLastDayOfMonth((Date)this.eelib.marbAustritt()), (Date)aktuellerMonat)) {
            marbAustritt = true;
        } else if (DateHelper.equal((Date)DateHelper.getLastDayOfMonth((Date)this.eelib.marbZVKAustritt()), (Date)aktuellerMonat)) {
            marbAustritt = true;
        }
        return marbAustritt;
    }

    private void abgrenzungSteuerFrei3Nr56() throws BusinessDomainException {
        BigDecimal jaehrlicheSteuerFreiGrenze3Nr56ESt;
        BigDecimal zvkSteuerfreiGrenzeUmlageAG;
        if (this.gllib.verarbeitungZVK(false) == ZvkSettingsEnum.ZSE_ABBAU_JAEHRLICH) {
            jaehrlicheSteuerFreiGrenze3Nr56ESt = zvkSteuerfreiGrenzeUmlageAG = this.gllib.zvkSteuerfreiGrenzeUmlageAG().multiply(ZWOELF);
        } else {
            zvkSteuerfreiGrenzeUmlageAG = this.gllib.zvkSteuerfreiGrenzeUmlageAG();
            jaehrlicheSteuerFreiGrenze3Nr56ESt = zvkSteuerfreiGrenzeUmlageAG.multiply(ZWOELF);
        }
        if (!this.eelib.isZVKWeiteresVersicherungsverhaeltnis() && this.eelib.stkl() != 6) {
            this.mMassgeblicheSteuerfreigrenze = zvkSteuerfreiGrenzeUmlageAG.subtract(this.mAufgelSteuerFreibetrag3Nr63Monat);
        }
        if (this.mMassgeblicheSteuerfreigrenze.compareTo(BigDecimal.ZERO) < 0) {
            this.mMassgeblicheSteuerfreigrenze = BigDecimal.ZERO;
        }
        this.mSteuerfreiNeu = this.mResultNeu;
        if (this.mSteuerfreiNeu.compareTo(this.mMassgeblicheSteuerfreigrenze) > 0) {
            this.mSteuerfreiNeu = this.mMassgeblicheSteuerfreigrenze;
        }
        if (this.mSteuerfreiNeu.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal aufgelSteuerFreibetragGesamt = this.mAufgelSteuerFreibetrag3Nr63Jahr.add(this.mAufgelSteuerfreiUmlageJahr);
            if (aufgelSteuerFreibetragGesamt.compareTo(jaehrlicheSteuerFreiGrenze3Nr56ESt) < 0) {
                if (this.mSteuerfreiNeu.add(aufgelSteuerFreibetragGesamt).compareTo(jaehrlicheSteuerFreiGrenze3Nr56ESt) > 0) {
                    BigDecimal differenz = this.mSteuerfreiNeu.add(aufgelSteuerFreibetragGesamt).subtract(jaehrlicheSteuerFreiGrenze3Nr56ESt);
                    this.mSteuerfreiNeu = this.mSteuerfreiNeu.compareTo(differenz) < 0 ? BigDecimal.ZERO : this.mSteuerfreiNeu.subtract(differenz);
                }
            } else {
                this.mSteuerfreiNeu = BigDecimal.ZERO;
            }
        }
    }

    private void aufgelNach3Nr63Und3Nr56EStGImMonat() throws BusinessDomainException {
        ValueType[] wertarten = ValueTypeHelper.getValueTypes(145210, 145215, 145220, 145225, 145230, 145235, 145240, 145245, 145310, 145320, 145335, 145345, 145360, 145370, 145385, 145395, 100931, 100932, 100934, 100933, 100971, 100972, 100973, 100974, 100921, 100922, 100924, 100923, 100951, 100952, 100953, 100954, 100941, 100942, 100943, 100944);
        block3: for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), wertarten)) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 100921: 
                case 100922: 
                case 100923: 
                case 100924: 
                case 100931: 
                case 100932: 
                case 100933: 
                case 100934: 
                case 100971: 
                case 100972: 
                case 100973: 
                case 100974: 
                case 145210: 
                case 145215: 
                case 145220: 
                case 145225: 
                case 145230: 
                case 145235: 
                case 145240: 
                case 145245: 
                case 145310: 
                case 145320: 
                case 145335: 
                case 145345: 
                case 145360: 
                case 145370: 
                case 145385: 
                case 145395: {
                    this.mAufgelSteuerFreibetrag3Nr63Monat = this.mAufgelSteuerFreibetrag3Nr63Monat.add(vPos.getPersistentBuffer1());
                    continue block3;
                }
                default: {
                    this.mAufgelSteuerfreiUmlageMonat = this.mAufgelSteuerfreiUmlageMonat.add(vPos.getPersistentBuffer1());
                    this.mAufgelPauschalPflUmlageMonat = this.mAufgelPauschalPflUmlageMonat.add(vPos.getPersistentBuffer2());
                    this.mAufgelSteuerPflUmlageMonat = this.mAufgelSteuerPflUmlageMonat.add(vPos.getPersistentBuffer3());
                    this.mAufgelSvfreiUmlageMonat = this.mAufgelSvfreiUmlageMonat.add(vPos.getPersistentBuffer4());
                    this.mAufgelSvPflUmlageMonat = this.mAufgelSvPflUmlageMonat.add(vPos.getPersistentBuffer5());
                }
            }
        }
    }

    private void aufgelNach3Nr63Und3Nr56EStGImJahr() throws BusinessDomainException {
        this.mAufgelSteuerFreibetrag3Nr63Jahr = BigDecimal.ZERO;
        this.mAufgelPauschalbetrag3Nr63Jahr = BigDecimal.ZERO;
        if (this.eelib.hasCFZVK(this.callib.berchnungGueltigAb())) {
            this.mAufgelSteuerFreibetrag3Nr63Jahr = this.mAufgelSteuerFreibetrag3Nr63Jahr.add(this.eelib.getCFZVK3Nr63(this.callib.berchnungGueltigAb()));
            this.mAufgelPauschalbetrag3Nr63Jahr = this.mAufgelPauschalbetrag3Nr63Jahr.add(this.eelib.getCFZVKPauschalsteuer(this.callib.berchnungGueltigAb()));
        }
        LinkedList<String> eePensionSchemeList = new LinkedList<String>();
        BigDecimal vortrag = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            ValuePosition[] aufgel;
            block7: for (ValuePosition vPos : aufgel = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes(145210, 145215, 145220, 145225, 145230, 145235, 145240, 145245, 145310, 145320, 145335, 145345, 145360, 145370, 145385, 145395, 100931, 100932, 100933, 100934, 100971, 100972, 100973, 100974, 100951, 100952, 100953, 100954, 100941, 100942, 100943, 100944))) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 145210: 
                    case 145215: 
                    case 145220: 
                    case 145225: 
                    case 145230: 
                    case 145235: 
                    case 145240: 
                    case 145245: 
                    case 145310: 
                    case 145320: 
                    case 145335: 
                    case 145345: 
                    case 145360: 
                    case 145370: 
                    case 145385: 
                    case 145395: {
                        try {
                            EEPensionSchemeTP eetp = this.wplib.getGenesisEEPensionSchemeTP(vPos);
                            if (!eePensionSchemeList.contains(eetp.getObjectid())) {
                                if (eetp.getCarriedForwardYear() == new VDate(this.callib.berchnungGueltigAb()).getYear() && !BigDecimalMapper.isZeroOrNull((BigDecimal)eetp.getCarriedForwardSIPaymentNew())) {
                                    vortrag = vortrag.add(eetp.getCarriedForwardSIPaymentNew());
                                }
                                eePensionSchemeList.add(eetp.getObjectid());
                            }
                        }
                        catch (ClassCastException e) {
                            throw EvaluationExceptionMapper.makeFalseBAVRegistrationDomainException();
                        }
                    }
                    case 100931: 
                    case 100932: 
                    case 100933: 
                    case 100934: 
                    case 100971: 
                    case 100972: 
                    case 100973: 
                    case 100974: {
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer1())) {
                            this.mAufgelSteuerFreibetrag3Nr63Jahr = this.mAufgelSteuerFreibetrag3Nr63Jahr.add(vPos.getPersistentBuffer1());
                        }
                        if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer2())) continue block7;
                        this.mAufgelPauschalbetrag3Nr63Jahr = this.mAufgelPauschalbetrag3Nr63Jahr.add(vPos.getPersistentBuffer2());
                        continue block7;
                    }
                    default: {
                        this.mAufgelSteuerfreiUmlageJahr = this.mAufgelSteuerfreiUmlageJahr.add(vPos.getPersistentBuffer1());
                        this.mAufgelPauschalPflUmlageJahr = this.mAufgelPauschalPflUmlageJahr.add(vPos.getPersistentBuffer2());
                        this.mAufgelSteuerPflUmlageJahr = this.mAufgelSteuerPflUmlageJahr.add(vPos.getPersistentBuffer3());
                        this.mAufgelSvfreiUmlageJahr = this.mAufgelSvfreiUmlageJahr.add(vPos.getPersistentBuffer4());
                        this.mAufgelSvPflUmlageJahr = this.mAufgelSvPflUmlageJahr.add(vPos.getPersistentBuffer5());
                    }
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)vortrag)) {
            BigDecimal steuerFreibetrag = this.gllib.svBbgRvAvJaehrlBAV();
            this.mAufgelSteuerFreibetrag3Nr63Jahr = vortrag.compareTo(steuerFreibetrag.subtract(this.mAufgelSteuerFreibetrag3Nr63Jahr)) > 0 ? steuerFreibetrag : this.mAufgelSteuerFreibetrag3Nr63Jahr.add(vortrag);
        }
    }

    private void svBetrachtung() throws BusinessDomainException {
        if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2014, 0, 1).getDate())) {
            if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)this.callib.berchnungWirksamAb())) {
                if (this.callib.isUnchangedZVKBrutto()) {
                    this.ermittleSVFreiAusSichtVormonat();
                } else {
                    this.ermittleSVFrei();
                }
            } else {
                this.ermittleSVFrei();
            }
        } else {
            this.ermittleSVFrei();
        }
        if (this.mSvfreiNeu.compareTo(BigDecimal.ZERO) < 0) {
            this.mSvPflNeu = this.mSvPflNeu.add(this.mSvfreiNeu.negate());
            this.mSvfreiNeu = BigDecimal.ZERO;
        }
        if (this.mSvPflNeu.compareTo(BigDecimal.ZERO) < 0) {
            this.mSvfreiNeu = this.mSvfreiNeu.add(this.mSvPflNeu.negate());
            this.mSvPflNeu = BigDecimal.ZERO;
        }
        this.mSvPflDiff = this.mSvPflNeu.subtract(this.mAufgelSvPflUmlageMonat);
        this.mSvfreiDiff = this.mSvfreiNeu.subtract(this.mAufgelSvfreiUmlageMonat);
        if (this.mSvPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(111540, this.mSvPflDiff);
            this.wplib.persistentBuffer5(this.mSvPflDiff);
        }
        if (this.mSvfreiDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(111440, this.mSvfreiDiff);
            this.wplib.persistentBuffer4(this.mSvfreiDiff);
        }
    }

    private void abgrenzungPauschPflichtNach40b() throws BusinessDomainException {
        BigDecimal massgeblichePauschgrenze = BigDecimal.ZERO;
        BigDecimal jaehrlichePauschalGrenze = BigDecimal.ZERO;
        if (!this.eelib.isZVKWeiteresVersicherungsverhaeltnis() && this.eelib.stkl() != 6) {
            if (this.gllib.verarbeitungZVK(false) == ZvkSettingsEnum.ZSE_ABBAU_JAEHRLICH) {
                switch (this.eelib.zvkBerechnungUmlage().value()) {
                    case 2: {
                        massgeblichePauschgrenze = this.gllib.zvkMtlPauschalGrenzeGV().multiply(ZWOELF);
                        break;
                    }
                    default: {
                        massgeblichePauschgrenze = this.gllib.zvkMtlPauschalGrenze().multiply(ZWOELF);
                    }
                }
                jaehrlichePauschalGrenze = massgeblichePauschgrenze;
            } else {
                switch (this.eelib.zvkBerechnungUmlage().value()) {
                    case 2: {
                        massgeblichePauschgrenze = this.gllib.zvkMtlPauschalGrenzeGV();
                        break;
                    }
                    default: {
                        massgeblichePauschgrenze = this.gllib.zvkMtlPauschalGrenze();
                    }
                }
                jaehrlichePauschalGrenze = massgeblichePauschgrenze.multiply(ZWOELF);
            }
        }
        this.mPauschalPflNeu = this.mResultNeu.subtract(this.mSteuerfreiNeu);
        if (this.mPauschalPflNeu.compareTo(massgeblichePauschgrenze) > 0) {
            this.mPauschalPflNeu = massgeblichePauschgrenze;
        }
        if (this.mPauschalPflNeu.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal aufgelPauschalbetragGesamt = this.mAufgelPauschalPflUmlageJahr;
            if (aufgelPauschalbetragGesamt.compareTo(jaehrlichePauschalGrenze) < 0) {
                if (this.mPauschalPflNeu.add(aufgelPauschalbetragGesamt).compareTo(jaehrlichePauschalGrenze) > 0) {
                    BigDecimal differenz = this.mPauschalPflNeu.add(aufgelPauschalbetragGesamt).subtract(jaehrlichePauschalGrenze);
                    this.mPauschalPflNeu = this.mPauschalPflNeu.compareTo(differenz) < 0 ? BigDecimal.ZERO : this.mPauschalPflNeu.subtract(differenz);
                }
            } else {
                this.mPauschalPflNeu = BigDecimal.ZERO;
            }
        }
    }

    private void bewerte3Nr56EStGAustrittJahresende() throws BusinessDomainException {
        BigDecimal differenzBeiSteuerfrei;
        BigDecimal steuerlicheLuft;
        BigDecimal steuerFreibetrag;
        BigDecimal steuerpflAktuellerMonat;
        BigDecimal steuerfreiJaehrlich = this.gllib.zvkSteuerfreiGrenzeUmlageAG().multiply(ZWOELF);
        BigDecimal pauschalJaehrlich = BigDecimal.ZERO;
        switch (this.eelib.zvkBerechnungUmlage().value()) {
            case 1: {
                pauschalJaehrlich = this.gllib.zvkMtlPauschalGrenze().multiply(ZWOELF);
                break;
            }
            case 2: {
                pauschalJaehrlich = this.gllib.zvkMtlPauschalGrenzeGV().multiply(ZWOELF);
            }
        }
        BigDecimal aufgelSteuerfrei3Nr63 = this.mAufgelSteuerFreibetrag3Nr63Monat;
        BigDecimal aufgelSteuerfrei3Nr56 = this.mSteuerfreiNeu;
        BigDecimal aufgelPauschalpfl = this.mPauschalPflNeu;
        BigDecimal aufgelSteuerpfl = steuerpflAktuellerMonat = this.mResultNeu.subtract(this.mSteuerfreiNeu).subtract(this.mPauschalPflNeu);
        if (aufgelSteuerpfl.compareTo(BigDecimal.ZERO) < 0) {
            aufgelSteuerpfl = BigDecimal.ZERO;
        }
        if (this.eelib.hasCFZVK(this.callib.berchnungGueltigAb())) {
            aufgelSteuerfrei3Nr63 = aufgelSteuerfrei3Nr63.add(this.eelib.getCFZVK3Nr63(this.callib.berchnungGueltigAb()));
            aufgelSteuerfrei3Nr56 = aufgelSteuerfrei3Nr56.add(this.eelib.getCFZVK3Nr56(this.callib.berchnungGueltigAb()));
            aufgelPauschalpfl = aufgelPauschalpfl.add(this.eelib.getCFZVKPauschalsteuer(this.callib.berchnungGueltigAb()));
            aufgelSteuerpfl = aufgelSteuerpfl.add(this.eelib.getCFZVKSteuerpflichtig(this.callib.berchnungGueltigAb()));
        }
        LinkedList<String> eePensionSchemeList = new LinkedList<String>();
        BigDecimal vortragBAV = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.callib.berchnungGueltigAb());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            ValuePosition[] aufgel;
            block16: for (ValuePosition vPos : aufgel = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes(145210, 145215, 145220, 145225, 145230, 145235, 145240, 145245, 145310, 145320, 145335, 145345, 145360, 145370, 145385, 145395, 100931, 100932, 100933, 100934, 100971, 100972, 100973, 100974, 100921, 100922, 100924, 100923, 100951, 100952, 100953, 100954, 100941, 100942, 100943, 100944, 111310))) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 145210: 
                    case 145215: 
                    case 145220: 
                    case 145225: 
                    case 145230: 
                    case 145235: 
                    case 145240: 
                    case 145245: 
                    case 145310: 
                    case 145320: 
                    case 145335: 
                    case 145345: 
                    case 145360: 
                    case 145370: 
                    case 145385: 
                    case 145395: {
                        try {
                            EEPensionSchemeTP eetp = this.wplib.getGenesisEEPensionSchemeTP(vPos);
                            if (!eePensionSchemeList.contains(eetp.getEEPensionScheme().getObjectid())) {
                                switch (eetp.getContractType().value()) {
                                    case 1: 
                                    case 2: 
                                    case 3: {
                                        if (eetp.getCarriedForwardYear() != new VDate(this.callib.berchnungGueltigAb()).getYear() || BigDecimalMapper.isZeroOrNull((BigDecimal)eetp.getCarriedForwardSIPaymentNew())) break;
                                        vortragBAV = vortragBAV.add(eetp.getCarriedForwardSIPaymentNew());
                                    }
                                }
                                eePensionSchemeList.add(eetp.getEEPensionScheme().getObjectid());
                            }
                        }
                        catch (ClassCastException e) {
                            throw EvaluationExceptionMapper.makeFalseBAVRegistrationDomainException();
                        }
                    }
                    case 100921: 
                    case 100922: 
                    case 100923: 
                    case 100924: 
                    case 100931: 
                    case 100932: 
                    case 100933: 
                    case 100934: 
                    case 100971: 
                    case 100972: 
                    case 100973: 
                    case 100974: {
                        if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer1())) continue block16;
                        aufgelSteuerfrei3Nr63 = aufgelSteuerfrei3Nr63.add(vPos.getPersistentBuffer1());
                        continue block16;
                    }
                    case 100941: 
                    case 100942: 
                    case 100943: 
                    case 100944: 
                    case 100951: 
                    case 100952: 
                    case 100953: 
                    case 100954: {
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer1())) {
                            aufgelSteuerfrei3Nr56 = aufgelSteuerfrei3Nr56.add(vPos.getPersistentBuffer1());
                        }
                        if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getPersistentBuffer2())) continue block16;
                        aufgelPauschalpfl = aufgelPauschalpfl.add(vPos.getPersistentBuffer2());
                        continue block16;
                    }
                    case 111310: {
                        aufgelSteuerpfl = aufgelSteuerpfl.add(vPos.getResult());
                    }
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)vortragBAV) && (steuerFreibetrag = steuerfreiJaehrlich).compareTo(aufgelSteuerfrei3Nr63) > 0) {
            aufgelSteuerfrei3Nr63 = vortragBAV.compareTo(steuerFreibetrag.subtract(aufgelSteuerfrei3Nr63)) > 0 ? aufgelSteuerfrei3Nr63.add(steuerFreibetrag.subtract(aufgelSteuerfrei3Nr63)) : aufgelSteuerfrei3Nr63.add(vortragBAV);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)(steuerlicheLuft = aufgelPauschalpfl.add(aufgelSteuerpfl))) && !BigDecimalMapper.isZeroOrNull((BigDecimal)(differenzBeiSteuerfrei = (steuerfreiJaehrlich = aufgelSteuerfrei3Nr63.compareTo(steuerfreiJaehrlich) <= 0 ? steuerfreiJaehrlich.subtract(aufgelSteuerfrei3Nr63) : BigDecimal.ZERO).subtract(aufgelSteuerfrei3Nr56)))) {
            if (steuerlicheLuft.compareTo(differenzBeiSteuerfrei) <= 0) {
                differenzBeiSteuerfrei = steuerlicheLuft;
                steuerlicheLuft = BigDecimal.ZERO;
            } else {
                steuerlicheLuft = steuerlicheLuft.subtract(differenzBeiSteuerfrei);
            }
            this.mSteuerfreiNeu = this.mSteuerfreiNeu.add(differenzBeiSteuerfrei);
            if (aufgelPauschalpfl.subtract(differenzBeiSteuerfrei).compareTo(pauschalJaehrlich) != 0) {
                BigDecimal differenzBeiPauschalsteuer = pauschalJaehrlich.subtract(aufgelPauschalpfl);
                if (aufgelPauschalpfl.add(differenzBeiPauschalsteuer).compareTo(pauschalJaehrlich) <= 0) {
                    if (steuerlicheLuft.compareTo(differenzBeiPauschalsteuer.add(aufgelPauschalpfl)) < 0) {
                        differenzBeiPauschalsteuer = steuerlicheLuft.subtract(aufgelPauschalpfl);
                        steuerlicheLuft = BigDecimal.ZERO;
                    } else {
                        steuerlicheLuft = steuerlicheLuft.subtract(differenzBeiPauschalsteuer).subtract(aufgelPauschalpfl);
                    }
                    this.mPauschalPflNeu = this.mPauschalPflNeu.add(differenzBeiPauschalsteuer);
                } else {
                    this.mPauschalPflNeu = this.mPauschalPflNeu.add(pauschalJaehrlich).subtract(aufgelPauschalpfl);
                    steuerlicheLuft = steuerlicheLuft.subtract(pauschalJaehrlich.subtract(aufgelPauschalpfl)).subtract(aufgelPauschalpfl);
                }
            } else {
                steuerlicheLuft = steuerlicheLuft.subtract(aufgelPauschalpfl);
            }
            if (steuerlicheLuft.compareTo(aufgelSteuerpfl) != 0) {
                this.mSteuerPflausAufrechnung = steuerlicheLuft.subtract(aufgelSteuerpfl.subtract(steuerpflAktuellerMonat));
            }
        }
    }

    private void ermittleSVFreiAusSichtVormonat() throws BusinessDomainException {
        for (ValuePosition vPos : this.vpArray = this.wplib.wpAusWPListeOderDB(DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.callib.berchnungWirksamAb())), DateHelper.yesterday((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.getWertartenVormonat())) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 100951: 
                case 100952: 
                case 100953: 
                case 100954: {
                    this.mSvPflNeu = this.mSvPflNeu.add(vPos.getPersistentBuffer5());
                }
            }
        }
    }

    private ValueType[] getWertartenVormonat() throws BusinessDomainException {
        ValueType[] result;
        switch (this.wplib.wertartenNummer()) {
            case 100951: {
                result = ValueTypeHelper.getValueTypes(100951);
                break;
            }
            case 100952: {
                result = ValueTypeHelper.getValueTypes(100951, 100952);
                break;
            }
            case 100953: {
                result = ValueTypeHelper.getValueTypes(100951, 100952, 100953);
                break;
            }
            default: {
                result = ValueTypeHelper.getValueTypes(100951, 100952, 100953, 100954);
            }
        }
        return result;
    }

    private void ermittleSVFrei() throws BusinessDomainException {
        this.arevBetrag = this.mSteuerfreiNeu.add(this.mPauschalPflNeu).compareTo(EINHUNDERT) > 0 ? EINHUNDERT : this.mSteuerfreiNeu.add(this.mPauschalPflNeu);
        this.arevBetrag = this.arevBetrag.multiply(EINHUNDERT).divide(this.gllib.zvkVhSatzUmlageAg(), 2, RoundingMode.HALF_UP);
        this.arevBetrag = this.arevBetrag.multiply(this.gllib.zvkVhSatzAREV()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP).subtract(BigDecimal.valueOf(133L, 1));
        if (this.arevBetrag.compareTo(BigDecimal.ZERO) < 0) {
            this.arevBetrag = BigDecimal.ZERO;
        }
        BigDecimal hinzur1 = this.mSteuerfreiNeu.add(this.mPauschalPflNeu).compareTo(EINHUNDERT) < 0 ? BigDecimal.ZERO : this.mSteuerfreiNeu.add(this.mPauschalPflNeu).subtract(EINHUNDERT);
        this.mSvPflNeu = this.mSteuerPflNeu.add(hinzur1).add(this.arevBetrag);
        this.mSvfreiNeu = this.mSteuerfreiNeu.add(this.mPauschalPflNeu).add(this.mSteuerPflNeu).subtract(this.mSvPflNeu);
    }

    private void erzeugeSteuerUndBeitragspflicht(boolean vorzeichenumkehr) throws BusinessDomainException {
        if (this.mSteuerPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(110510, vorzeichenumkehr ? this.mSteuerPflDiff.negate() : this.mSteuerPflDiff);
        }
        if (this.mPauschalPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            this.wplib.addNeueWertPosition(101790, vorzeichenumkehr ? this.mPauschalPflDiff.negate() : this.mPauschalPflDiff);
            if (this.eelib.zvkAbwaelzungPauschalLstAn()) {
                this.wplib.addNeueWertPosition(737800, vorzeichenumkehr ? this.mPauschalPflDiff.negate() : this.mPauschalPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737300, vorzeichenumkehr ? this.mPauschalPflDiff.negate() : this.mPauschalPflDiff);
            }
            if (this.eelib.zvkAbwaelzungPauschalSolZAn()) {
                this.wplib.addNeueWertPosition(737840, vorzeichenumkehr ? this.mPauschalPflDiff.negate() : this.mPauschalPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737340, vorzeichenumkehr ? this.mPauschalPflDiff.negate() : this.mPauschalPflDiff);
            }
            if (this.eelib.zvkAbwaelzungPauschalKiStAn()) {
                this.wplib.addNeueWertPosition(737880, vorzeichenumkehr ? this.mPauschalPflDiff.negate() : this.mPauschalPflDiff);
                this.wplib.addNeueWertPosition(737890, vorzeichenumkehr ? this.mPauschalPflDiff.negate() : this.mPauschalPflDiff);
            } else {
                this.wplib.addNeueWertPosition(737380, vorzeichenumkehr ? this.mPauschalPflDiff.negate() : this.mPauschalPflDiff);
                this.wplib.addNeueWertPosition(737390, vorzeichenumkehr ? this.mPauschalPflDiff.negate() : this.mPauschalPflDiff);
            }
        }
        if (this.mSvPflDiff.compareTo(BigDecimal.ZERO) != 0 && this.wplib.svTageLfd().compareTo(BigDecimal.ZERO) > 0) {
            this.wplib.addNeueWertPosition(130510, vorzeichenumkehr ? this.mSvPflDiff.negate() : this.mSvPflDiff);
            this.wplib.addNeueWertPosition(135200, vorzeichenumkehr ? this.mSvPflDiff.negate() : this.mSvPflDiff);
        }
    }

    private void modifiziereSteuerUndBeitragspflicht() throws BusinessDomainException {
        boolean pauschalBruttoModifiziert = false;
        boolean pauschalLStModifiziert = false;
        boolean pauschalSolzModifiziert = false;
        boolean pauschalKiStModifiziert = false;
        block15: for (ValuePosition vPos : this.vpArray = this.wplib.genesisUndFolgen()) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 110510: {
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2017, 0, 1).getDate())) {
                        if (this.wplib.wertPosition().getValueType().getValueTypeKey() == 100953) continue block15;
                        vPos.setResult(vPos.getResult().add(this.mSteuerPflDiff));
                        continue block15;
                    }
                    vPos.setResult(vPos.getResult().add(this.mSteuerPflDiff));
                    continue block15;
                }
                case 110610: 
                case 110620: {
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2017, 0, 1).getDate())) {
                        if (this.wplib.wertPosition().getValueType().getValueTypeKey() != 100953) continue block15;
                        vPos.setResult(vPos.getResult().add(this.mSteuerPflDiff));
                        continue block15;
                    }
                    vPos.setResult(vPos.getResult().add(this.mSteuerPflDiff));
                    continue block15;
                }
                case 109150: 
                case 109170: 
                case 109510: {
                    if (this.mSvPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block15;
                    vPos.setResult(vPos.getResult().add(this.mSvPflDiff));
                    vPos.setBufferField05(this.mSvPflDiff);
                    continue block15;
                }
                case 115200: {
                    if (this.gllib.bundeslandSchluesselBeschaeftigungsort() != 10 || this.mSvPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block15;
                    vPos.setResult(vPos.getResult().add(this.mSvPflDiff));
                    continue block15;
                }
                case 129510: 
                case 130510: 
                case 130560: 
                case 135200: {
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2017, 0, 1).getDate())) {
                        if (this.wplib.wertPosition().getValueType().getValueTypeKey() == 100953) continue block15;
                        vPos.setResult(vPos.getResult().add(this.mSvPflDiff));
                        continue block15;
                    }
                    vPos.setResult(vPos.getResult().add(this.mSvPflDiff));
                    continue block15;
                }
                case 130610: {
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2017, 0, 1).getDate())) {
                        if (this.wplib.wertPosition().getValueType().getValueTypeKey() != 100953) continue block15;
                        vPos.setResult(vPos.getResult().add(this.mSvPflDiff));
                        continue block15;
                    }
                    vPos.setResult(vPos.getResult().add(this.mSvPflDiff));
                    continue block15;
                }
                case 101790: {
                    pauschalBruttoModifiziert = true;
                    if (this.mPauschalPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block15;
                    vPos.setResult(vPos.getResult().add(this.mPauschalPflDiff));
                    continue block15;
                }
                case 737800: {
                    if (!this.eelib.zvkAbwaelzungPauschalLstAn()) continue block15;
                    pauschalLStModifiziert = true;
                    if (this.mPauschalPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block15;
                    vPos.setResult(vPos.getResult().add(this.mPauschalPflDiff));
                    continue block15;
                }
                case 737300: {
                    if (this.eelib.zvkAbwaelzungPauschalLstAn()) continue block15;
                    pauschalLStModifiziert = true;
                    if (this.mPauschalPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block15;
                    vPos.setResult(vPos.getResult().add(this.mPauschalPflDiff));
                    continue block15;
                }
                case 737840: {
                    if (!this.eelib.zvkAbwaelzungPauschalSolZAn()) continue block15;
                    pauschalSolzModifiziert = true;
                    if (this.mPauschalPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block15;
                    vPos.setResult(vPos.getResult().add(this.mPauschalPflDiff));
                    continue block15;
                }
                case 737340: {
                    if (this.eelib.zvkAbwaelzungPauschalSolZAn()) continue block15;
                    pauschalSolzModifiziert = true;
                    if (this.mPauschalPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block15;
                    vPos.setResult(vPos.getResult().add(this.mPauschalPflDiff));
                    continue block15;
                }
                case 737880: 
                case 737890: {
                    if (!this.eelib.zvkAbwaelzungPauschalKiStAn()) continue block15;
                    pauschalKiStModifiziert = true;
                    if (this.mPauschalPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block15;
                    vPos.setResult(vPos.getResult().add(this.mPauschalPflDiff));
                    continue block15;
                }
                case 737380: 
                case 737390: {
                    if (this.eelib.zvkAbwaelzungPauschalKiStAn()) continue block15;
                    pauschalKiStModifiziert = true;
                    if (this.mPauschalPflDiff.compareTo(BigDecimal.ZERO) == 0) continue block15;
                    vPos.setResult(vPos.getResult().add(this.mPauschalPflDiff));
                    continue block15;
                }
            }
        }
        if (this.mPauschalPflDiff.compareTo(BigDecimal.ZERO) != 0) {
            if (!pauschalBruttoModifiziert) {
                this.wplib.addNeueWertPosition(101790, this.mPauschalPflDiff);
            }
            if (!pauschalLStModifiziert) {
                if (this.eelib.zvkAbwaelzungPauschalLstAn()) {
                    this.wplib.addNeueWertPosition(737800, this.mPauschalPflDiff);
                } else {
                    this.wplib.addNeueWertPosition(737300, this.mPauschalPflDiff);
                }
            }
            if (!pauschalSolzModifiziert) {
                if (this.eelib.zvkAbwaelzungPauschalSolZAn()) {
                    this.wplib.addNeueWertPosition(737840, this.mPauschalPflDiff);
                } else {
                    this.wplib.addNeueWertPosition(737340, this.mPauschalPflDiff);
                }
            }
            if (!pauschalKiStModifiziert) {
                if (this.eelib.zvkAbwaelzungPauschalKiStAn()) {
                    this.wplib.addNeueWertPosition(737880, this.mPauschalPflDiff);
                    this.wplib.addNeueWertPosition(737890, this.mPauschalPflDiff);
                } else {
                    this.wplib.addNeueWertPosition(737380, this.mPauschalPflDiff);
                    this.wplib.addNeueWertPosition(737390, this.mPauschalPflDiff);
                }
            }
        }
    }

    private void ermittleSteuerpfl() throws BusinessDomainException {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mSteuerPflausAufrechnung)) {
            this.mSteuerPflNeu = this.mSteuerPflausAufrechnung;
        } else {
            this.mSteuerPflNeu = this.mResultNeu.subtract(this.mSteuerfreiNeu).subtract(this.mPauschalPflNeu);
            if (this.mSteuerPflNeu.compareTo(BigDecimal.ZERO) < 0) {
                this.mSteuerPflNeu = BigDecimal.ZERO;
            }
        }
    }
}

