/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ErmittlungZVKSanierungsgeldFormula {
    private final CalculationLibrary callib;
    private final GlobalLibrary gllib;
    private BigDecimal mBglAlt = BigDecimal.ZERO;
    private BigDecimal mBglNeu = BigDecimal.ZERO;
    private BigDecimal mResultatAlt = BigDecimal.ZERO;
    private BigDecimal mResultDiff = BigDecimal.ZERO;
    private BigDecimal mResultNeu = BigDecimal.ZERO;
    private final ValuePositionLibrary wplib;

    public ErmittlungZVKSanierungsgeldFormula(CalculationLibrary calLibrary, GlobalLibrary glLibrary, ValuePositionLibrary wpLibrary) {
        this.callib = calLibrary;
        this.gllib = glLibrary;
        this.wplib = wpLibrary;
    }

    public void ermittle() throws BusinessDomainException {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.gllib.zvkVHSatzSanierungsgeld())) {
            this.wplib.wertPosition().makeReadOnly();
        } else {
            this.ermittleAufgelaufeneWerte();
            this.mBglNeu = this.mBglAlt.add(this.wplib.result());
            ValuePosition genesis = this.wplib.genesisParent();
            if (genesis.getValueType().getValueTypeKey() != 99992 && this.mBglNeu.compareTo(this.gllib.zvkMaximalGrenze()) > 0) {
                this.mBglNeu = this.gllib.zvkMaximalGrenze();
            }
            this.mResultNeu = this.mBglNeu.multiply(this.gllib.zvkVHSatzSanierungsgeld()).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
            this.mResultDiff = this.mResultNeu.subtract(this.mResultatAlt);
            this.weitergabeDerBerechnungsWerte();
            this.callib.result(this.mResultDiff);
            this.callib.percentage(this.gllib.zvkVHSatzSanierungsgeld());
        }
    }

    private void ermittleAufgelaufeneWerte() throws BusinessDomainException {
        if (this.wplib.wertPosition().getBufferFactor1() != null) {
            this.mBglAlt = this.wplib.wertPosition().getBufferFactor1();
        }
        if (this.wplib.wertPosition().getBufferResult() != null) {
            this.mResultatAlt = this.wplib.wertPosition().getBufferResult();
        }
    }

    private void weitergabeDerBerechnungsWerte() {
        ValuePosition nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100911));
        if (nextVP == null && (nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100912))) == null && (nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100913))) == null) {
            nextVP = this.wplib.naechsteWP(ValueType.getValueType((int)100914));
        }
        if (nextVP != null) {
            nextVP.setBufferFactor1(this.mBglNeu);
            nextVP.setBufferResult(this.mResultNeu);
        }
    }
}

