/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.carriedforward.varpayment.EECarriedForwardVarPayment;
import com.varial.personnel.domain.employee.employment.TypeOfTimeOffEnum;
import com.varial.personnel.domain.employee.insurance.ModeOfPensionEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.libraryimpl.MultipleUsedMethodsImpl;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.RefundSIEREnum;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.domain.workingtime.WorkingTimeTP;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungUmlageerstattungU2Formula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private static final BigDecimal DREI = BigDecimal.valueOf(3L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    protected final MultipleUsedMethodsImpl mMumLib;
    protected final ValuePositionLibrary mVpLib;
    private TypeOfTimeOffEnum mArtDerErstattungdberechnung;
    private RefundSIEREnum mErstattungAGA;
    private int mFehltageMuG = 0;
    private boolean mKuerzungDurchBbgRv = false;
    private BigDecimal mMonatsbrutto = BigDecimal.ZERO;
    private BigDecimal mMonatsnetto = BigDecimal.ZERO;
    private BigDecimal mTagesnetto = BigDecimal.ZERO;
    private HealthFund mUmlagekasse;
    private BigDecimal mPauschalAGAVHSatz = BigDecimal.ZERO;
    private BigDecimal mIstZeit = BigDecimal.ZERO;
    private BigDecimal mSollzeit = BigDecimal.ZERO;

    public ErmittlungUmlageerstattungU2Formula(CalculationLibrary calLib, EmployeeLibrary eeLib, GlobalLibrary glLib, ValuePositionLibrary wpLib) {
        this.mCalLib = calLib;
        this.mEeLib = eeLib;
        this.mGlLib = glLib;
        this.mVpLib = wpLib;
        this.mMumLib = new MultipleUsedMethodsImpl(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib);
    }

    public void ermittel() throws BusinessDomainException {
        switch (this.mVpLib.wertartenNummer()) {
            case 372210: {
                this.ermittlungMugEntgelte();
                break;
            }
            case 372220: 
            case 372225: {
                if (this.mVpLib.parent().getValueType().getValueTypeKey() > 100000) {
                    this.ermittlungEntgelt_G();
                    break;
                }
                this.mCalLib.result(this.mVpLib.result());
                break;
            }
            case 372230: 
            case 372235: {
                this.ermittlungEntgelt_I();
                break;
            }
            case 372320: {
                this.ermittlungAGA_G();
                break;
            }
            case 372330: {
                this.ermittlungAGA_I();
                break;
            }
            case 372610: {
                this.ermittlungErstattung_M();
                break;
            }
            case 372620: {
                this.ermittlungErstattung_G();
                break;
            }
            case 372630: {
                this.ermittlungErstattung_I();
            }
        }
    }

    private void ermittleAGAErstattung() throws BusinessDomainException {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mSollzeit)) {
            this.mCalLib.result(BigDecimal.ZERO);
        } else {
            BigDecimal grundlage = this.mCalLib.umlageEntgelt();
            SVAGAValues svAGAValues = new SVAGAValues(BigDecimal.ZERO, BigDecimal.ZERO);
            switch (this.mErstattungAGA.value()) {
                case 3: {
                    BigDecimal svBbg = this.mGlLib.svBbgRvAv().multiply(this.mIstZeit).divide(this.mSollzeit, 2, RoundingMode.HALF_UP);
                    grundlage = grundlage.compareTo(svBbg) > 0 ? svBbg : grundlage;
                }
                case 2: {
                    svAGAValues = this.pauschalerZuschlag(grundlage);
                    break;
                }
                case 1: {
                    svAGAValues = this.ermittleTatsaechlicheBeitraege();
                    break;
                }
                case 4: {
                    SVAGAValues svAGAValuesPauchal = this.pauschalerZuschlag(grundlage);
                    SVAGAValues svAGAValuesTatsaechlich = this.ermittleTatsaechlicheBeitraege();
                    svAGAValues = BigDecimalMapper.compareTo((BigDecimal)svAGAValuesPauchal.svAga, (BigDecimal)svAGAValuesTatsaechlich.svAga) > 0 ? svAGAValuesTatsaechlich : svAGAValuesPauchal;
                }
            }
            this.mCalLib.result(svAGAValues.svAga);
            this.mCalLib.percentage(svAGAValues.percentage);
            this.mCalLib.factor2(this.mVpLib.result());
        }
    }

    private void ermittleArbeitsstundenG() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        this.mSollzeit = this.getMonatlicheIstStundenMitarbeiter();
        String fehlzeitschluessel = this.mVpLib.wertPosition().getPersistentBuffer1().toString();
        for (EEAbsentTimeTP lEeAbsentTimeTP : absentTimeTPs = this.mEeLib.aktuelleFehlzeitenfuerMonat(this.mCalLib.berchnungGueltigAb())) {
            if (!StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)fehlzeitschluessel)) continue;
            Date from = this.mCalLib.berchnungGueltigAb();
            if (DateHelper.after((Date)lEeAbsentTimeTP.getValidFrom(), (Date)from)) {
                from = lEeAbsentTimeTP.getValidFrom();
            }
            Date until = DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb());
            if (DateHelper.before((Date)lEeAbsentTimeTP.getValidUntil(), (Date)until)) {
                until = lEeAbsentTimeTP.getValidUntil();
            }
            this.mIstZeit = this.mIstZeit.add(this.getConcreteTargetHoursOfAbsence(this.mEeLib.marb(), this.mCalLib.berchnungWirksamAb(), from, until, lEeAbsentTimeTP));
        }
    }

    private void ermittleArbeitsstundenI() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        this.mSollzeit = this.getMonatlicheIstStundenMitarbeiter();
        String fehlzeitschluessel = this.mVpLib.wertPosition().getPersistentBuffer1().toString();
        for (EEAbsentTimeTP lEeAbsentTimeTP : absentTimeTPs = this.mEeLib.aktuelleFehlzeitenfuerMonat(this.mCalLib.berchnungGueltigAb())) {
            if (!StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)fehlzeitschluessel)) continue;
            Date from = this.mCalLib.berchnungGueltigAb();
            if (DateHelper.after((Date)lEeAbsentTimeTP.getValidFrom(), (Date)from)) {
                from = lEeAbsentTimeTP.getValidFrom();
            }
            Date until = DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb());
            if (DateHelper.before((Date)lEeAbsentTimeTP.getValidUntil(), (Date)until)) {
                until = lEeAbsentTimeTP.getValidUntil();
            }
            this.mIstZeit = this.mIstZeit.add(this.getConcreteTargetHoursOfAbsence(this.mEeLib.marb(), this.mCalLib.berchnungWirksamAb(), from, until, lEeAbsentTimeTP));
        }
    }

    private void ermittleArbeitstageG() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        this.mSollzeit = this.mMumLib.monatlicheIsttageMitarbeiter();
        String fehlzeitschluessel = this.mVpLib.wertPosition().getPersistentBuffer1().toString();
        for (EEAbsentTimeTP lEeAbsentTimeTP : absentTimeTPs = this.mEeLib.aktuelleFehlzeitenfuerMonat(this.mCalLib.berchnungGueltigAb())) {
            if (!StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)fehlzeitschluessel)) continue;
            Date from = this.mCalLib.berchnungGueltigAb();
            if (DateHelper.after((Date)lEeAbsentTimeTP.getValidFrom(), (Date)from)) {
                from = lEeAbsentTimeTP.getValidFrom();
            }
            Date until = DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb());
            if (DateHelper.before((Date)lEeAbsentTimeTP.getValidUntil(), (Date)until)) {
                until = lEeAbsentTimeTP.getValidUntil();
            }
            this.mIstZeit = this.mIstZeit.add(this.getConcreteTargetDaysOfAbsence(this.mEeLib.marb(), this.mCalLib.berchnungWirksamAb(), from, until, lEeAbsentTimeTP));
        }
    }

    private void ermittleArbeitstageI() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        this.mSollzeit = this.mMumLib.monatlicheIsttageMitarbeiter();
        String fehlzeitschluessel = this.mVpLib.wertPosition().getPersistentBuffer1().toString();
        for (EEAbsentTimeTP lEeAbsentTimeTP : absentTimeTPs = this.mEeLib.aktuelleFehlzeitenfuerMonat(this.mCalLib.berchnungGueltigAb())) {
            if (!StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)fehlzeitschluessel)) continue;
            Date from = this.mCalLib.berchnungGueltigAb();
            if (DateHelper.after((Date)lEeAbsentTimeTP.getValidFrom(), (Date)from)) {
                from = lEeAbsentTimeTP.getValidFrom();
            }
            Date until = DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb());
            if (DateHelper.before((Date)lEeAbsentTimeTP.getValidUntil(), (Date)until)) {
                until = lEeAbsentTimeTP.getValidUntil();
            }
            this.mIstZeit = this.mIstZeit.add(this.getConcreteTargetDaysOfAbsence(this.mEeLib.marb(), this.mCalLib.berchnungWirksamAb(), from, until, lEeAbsentTimeTP));
        }
    }

    private BigDecimal ermittleKvAgaVhSatz() throws BusinessDomainException {
        BigDecimal kvAgaVhSatz = BigDecimal.ZERO;
        block0 : switch (this.mEeLib.marbBgrKv()) {
            case 1: {
                kvAgaVhSatz = this.mGlLib.krkBsAllgemein();
                if (!DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) break;
                kvAgaVhSatz = kvAgaVhSatz.add(this.mEeLib.marbKrkAgaBsZusatzbeitrag().multiply(BigDecimal.valueOf(2L)));
                break;
            }
            case 2: {
                if (DateHelper.before((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate())) {
                    kvAgaVhSatz = this.mGlLib.krkBsErhoeht();
                    if (!DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) break;
                    kvAgaVhSatz = kvAgaVhSatz.add(this.mEeLib.marbKrkAgaBsZusatzbeitrag().multiply(BigDecimal.valueOf(2L)));
                    break;
                }
                throw EvaluationExceptionMapper.makeIncreaseDuesGroupHIAfter2008NotAllowedDomainException();
            }
            case 3: {
                kvAgaVhSatz = this.mGlLib.krkBsErmaessigt();
                if (!DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) break;
                kvAgaVhSatz = kvAgaVhSatz.add(this.mEeLib.marbKrkAgaBsZusatzbeitrag().multiply(BigDecimal.valueOf(2L)));
                break;
            }
            case 5: {
                kvAgaVhSatz = this.mGlLib.svBsDurchschnittlich();
                if (!DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) break;
                kvAgaVhSatz = kvAgaVhSatz.add(this.mGlLib.kvZusatzDurchVHSatz());
                break;
            }
            case 6: {
                kvAgaVhSatz = this.mGlLib.svBsPauschGfbKV();
                break;
            }
            case 0: {
                kvAgaVhSatz = BigDecimal.ZERO;
                if (!this.mEeLib.marbPKv()) break;
            }
            case 9: {
                switch (this.mEeLib.marbBklFKv().value()) {
                    case 3: {
                        kvAgaVhSatz = this.mGlLib.krkBsErmaessigt().add(this.mEeLib.marbKrkAgaBsZusatzbeitrag().multiply(BigDecimal.valueOf(2L)));
                        break block0;
                    }
                    case 1: {
                        kvAgaVhSatz = this.mGlLib.krkBsAllgemein().add(this.mEeLib.marbKrkAgaBsZusatzbeitrag().multiply(BigDecimal.valueOf(2L)));
                    }
                }
            }
        }
        if (this.mEeLib.marbBgrKv() != 6 && !this.vollerBeitragssatzKV()) {
            kvAgaVhSatz = kvAgaVhSatz.divide(ZWEI, 3, RoundingMode.HALF_UP);
        }
        return kvAgaVhSatz;
    }

    private BigDecimal ermittlePvAgaVhSatz() throws BusinessDomainException {
        BigDecimal pvAgaVhSatz = BigDecimal.ZERO;
        block0 : switch (this.mEeLib.marbBgrPv()) {
            case 0: {
                switch (this.mEeLib.marbBklFPv().value()) {
                    case 1: {
                        if (this.mGlLib.bundeslandSchluesselBeschaeftigungsort() != 15) {
                            pvAgaVhSatz = this.mGlLib.svBsGesamtPV().divide(ZWEI, 4, RoundingMode.HALF_UP);
                            break block0;
                        }
                        pvAgaVhSatz = this.mGlLib.bulaPvAga();
                        break block0;
                    }
                }
                pvAgaVhSatz = BigDecimal.ZERO;
                break;
            }
            default: {
                if (this.mEeLib.marbPPVv()) break;
                pvAgaVhSatz = this.mGlLib.bundeslandSchluesselBeschaeftigungsort() != 15 ? this.mGlLib.svBsGesamtPV().divide(ZWEI, 4, RoundingMode.HALF_UP) : this.mGlLib.bulaPvAga();
            }
        }
        if (this.vollerBeitragssatzPV() && this.mEeLib.marbAelterDreiUndZwanzig() && !this.mEeLib.isMarbKindErz()) {
            pvAgaVhSatz = pvAgaVhSatz.add(this.mGlLib.svBsKinderlosPV());
        }
        return pvAgaVhSatz;
    }

    private BigDecimal ermittleRvAgaVhSatz() throws BusinessDomainException {
        BigDecimal rvAgaVhSatz = BigDecimal.ZERO;
        block0 : switch (this.mEeLib.marbBgrRv()) {
            case 0: {
                if (this.mEeLib.marbVersorgungsart() == ModeOfPensionEnum.MOPE_KEINE) break;
                rvAgaVhSatz = this.mGlLib.svBsGesamtRv();
                rvAgaVhSatz = rvAgaVhSatz.subtract(this.mGlLib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.UP));
                break;
            }
            case 1: 
            case 2: {
                switch (this.mEeLib.marbPgs()) {
                    case 109: {
                        rvAgaVhSatz = this.mGlLib.svBsPauschGfbRv();
                        break block0;
                    }
                }
                switch (this.mGlLib.krkTyp()) {
                    case 6: {
                        if (this.mEeLib.marbErhBeitrErmKnappschRV()) {
                            rvAgaVhSatz = this.mGlLib.svBsKnappschaftGesamt();
                            break;
                        }
                    }
                    default: {
                        rvAgaVhSatz = this.mGlLib.svBsGesamtRv();
                    }
                }
                if (this.vollerBeitragssatzRV()) break;
                rvAgaVhSatz = rvAgaVhSatz.subtract(this.mGlLib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.UP));
                break;
            }
            case 3: 
            case 4: {
                switch (this.mGlLib.krkTyp()) {
                    case 6: {
                        if (!this.mEeLib.marbErhBeitrErmKnappschRV()) break;
                        BigDecimal beitragssatz_ana = this.mGlLib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                        rvAgaVhSatz = this.mGlLib.svBsKnappschaftGesamt().subtract(beitragssatz_ana);
                        break block0;
                    }
                }
                rvAgaVhSatz = this.mGlLib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                break;
            }
            case 5: 
            case 6: {
                rvAgaVhSatz = this.mGlLib.svBsPauschGfbRv();
            }
        }
        return rvAgaVhSatz;
    }

    private BigDecimal ermittleAvAgaVhSatz() throws BusinessDomainException {
        BigDecimal avAgaVhSatz = BigDecimal.ZERO;
        switch (this.mEeLib.marbBgrAv()) {
            case 1: 
            case 2: {
                avAgaVhSatz = this.mGlLib.svBsGesamtAv();
                break;
            }
            default: {
                avAgaVhSatz = BigDecimal.ZERO;
            }
        }
        if (!this.vollerBeitragssatzAV()) {
            avAgaVhSatz = avAgaVhSatz.divide(ZWEI, 3, RoundingMode.HALF_UP);
        }
        return avAgaVhSatz;
    }

    private void ermittleKalendertageG() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        int[] days = new int[new VDate(DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb())).getDay()];
        for (int i = 0; i < days.length; ++i) {
            days[i] = 0;
        }
        int begin = 0;
        if (DateHelper.between((Date)this.mEeLib.marbEintritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
            begin = new VDate(this.mEeLib.marbEintritt()).getDay() - 1;
        }
        int end = days.length;
        if (this.mEeLib.marbAustritt() != null && DateHelper.between((Date)this.mEeLib.marbAustritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
            end = new VDate(this.mEeLib.marbAustritt()).getDay();
        }
        while (begin < end) {
            days[begin] = 1;
            ++begin;
        }
        String fehlzeitschluessel = this.mVpLib.wertPosition().getPersistentBuffer1().toString();
        String ausschlussFehlzeit = StringMapper.equal((String)fehlzeitschluessel, (String)"10.41") ? "10.43" : "10.41";
        for (EEAbsentTimeTP fehlzeit : absentTimeTPs = this.mEeLib.aktuelleFehlzeitenfuerMonat(this.mCalLib.berchnungGueltigAb())) {
            int zaehler = 0;
            if (StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)fehlzeitschluessel)) {
                zaehler = 2;
            }
            if (StringMapper.isNullString((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey()) || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.3") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.31") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.32") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.33") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.42") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.44") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)ausschlussFehlzeit)) continue;
            begin = 0;
            if (DateHelper.between((Date)fehlzeit.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
                begin = new VDate(fehlzeit.getValidFrom()).getDay() - 1;
            }
            end = days.length;
            if (DateHelper.between((Date)fehlzeit.getValidUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
                end = new VDate(fehlzeit.getValidUntil()).getDay();
            }
            while (begin < end) {
                days[begin] = zaehler;
                ++begin;
            }
        }
        for (int lI : days) {
            if (lI == 1) {
                this.mSollzeit = this.mSollzeit.add(BigDecimal.ONE);
                continue;
            }
            if (lI != 2) continue;
            this.mSollzeit = this.mSollzeit.add(BigDecimal.ONE);
            this.mIstZeit = this.mIstZeit.add(BigDecimal.ONE);
        }
    }

    private void ermittleKalendertageI() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        int[] days = new int[new VDate(DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb())).getDay()];
        for (int i = 0; i < days.length; ++i) {
            days[i] = 0;
        }
        int begin = 0;
        if (DateHelper.between((Date)this.mEeLib.marbEintritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
            begin = new VDate(this.mEeLib.marbEintritt()).getDay() - 1;
        }
        int end = days.length;
        if (this.mEeLib.marbAustritt() != null && DateHelper.between((Date)this.mEeLib.marbAustritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
            end = new VDate(this.mEeLib.marbAustritt()).getDay();
        }
        while (begin < end) {
            days[begin] = 1;
            ++begin;
        }
        String fehlzeitschluessel = this.mVpLib.wertPosition().getPersistentBuffer1().toString();
        String ausschlussFehlzeit = StringMapper.equal((String)fehlzeitschluessel, (String)"10.42") ? "10.44" : "10.42";
        for (EEAbsentTimeTP fehlzeit : absentTimeTPs = this.mEeLib.aktuelleFehlzeitenfuerMonat(this.mCalLib.berchnungGueltigAb())) {
            int zaehler = 0;
            if (StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)fehlzeitschluessel)) {
                zaehler = 2;
            } else if (StringMapper.isNullString((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey()) || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.3") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.31") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.32") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.33") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.41") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.43") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)ausschlussFehlzeit)) continue;
            begin = 0;
            if (DateHelper.between((Date)fehlzeit.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
                begin = new VDate(fehlzeit.getValidFrom()).getDay() - 1;
            }
            end = days.length;
            if (DateHelper.between((Date)fehlzeit.getValidUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
                end = new VDate(fehlzeit.getValidUntil()).getDay();
            }
            while (begin < end) {
                days[begin] = zaehler;
                ++begin;
            }
        }
        for (int lI : days) {
            if (lI == 1) {
                this.mSollzeit = this.mSollzeit.add(BigDecimal.ONE);
                continue;
            }
            if (lI != 2) continue;
            this.mSollzeit = this.mSollzeit.add(BigDecimal.ONE);
            this.mIstZeit = this.mIstZeit.add(BigDecimal.ONE);
        }
    }

    private void ermittleKalendertageM() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        int[] days = new int[new VDate(DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb())).getDay()];
        for (int i = 0; i < days.length; ++i) {
            days[i] = 0;
        }
        int begin = 0;
        if (DateHelper.between((Date)this.mEeLib.marbEintritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
            begin = new VDate(this.mEeLib.marbEintritt()).getDay() - 1;
        }
        int end = days.length;
        if (this.mEeLib.marbAustritt() != null && DateHelper.between((Date)this.mEeLib.marbAustritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
            end = new VDate(this.mEeLib.marbAustritt()).getDay();
        }
        while (begin < end) {
            days[begin] = 1;
            ++begin;
        }
        for (EEAbsentTimeTP fehlzeit : absentTimeTPs = this.mEeLib.aktuelleFehlzeitenfuerMonat(this.mCalLib.berchnungGueltigAb())) {
            int zaehler = 0;
            if (StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"4.5")) {
                zaehler = 2;
            }
            if (StringMapper.isNullString((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey()) || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.3") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.31") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.32") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.33") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.41") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.42") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.43") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.44")) continue;
            begin = 0;
            if (DateHelper.between((Date)fehlzeit.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
                begin = new VDate(fehlzeit.getValidFrom()).getDay() - 1;
            }
            end = days.length;
            if (DateHelper.between((Date)fehlzeit.getValidUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()))) {
                end = new VDate(fehlzeit.getValidUntil()).getDay();
            }
            while (begin < end) {
                if (days[begin] != 0) {
                    days[begin] = zaehler;
                }
                ++begin;
            }
        }
        for (int lI : days) {
            if (lI == 1) {
                this.mSollzeit = this.mSollzeit.add(BigDecimal.ONE);
                continue;
            }
            if (lI != 2) continue;
            this.mSollzeit = this.mSollzeit.add(BigDecimal.ONE);
            this.mIstZeit = this.mIstZeit.add(BigDecimal.ONE);
        }
        this.mFehltageMuG = this.mIstZeit.intValue();
    }

    private void ermittleTagesUndMonatswerte() throws BusinessDomainException {
        Date startDatumAAG = this.mGlLib.startDatumAAG();
        if (startDatumAAG == null) {
            throw EvaluationExceptionMapper.makeNoAAGStartDateDomainException();
        }
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)startDatumAAG)) {
            if (this.mEeLib.marbAAGBerechnungsrelevant()) {
                this.mMonatsbrutto = this.mEeLib.marbMugAagBruttoMonatlich();
                this.mMonatsnetto = this.mEeLib.marbMugAagNettoMonatlich();
                this.mTagesnetto = this.mEeLib.marbMugAagNettoTaeglich();
            } else if (this.keineParameterVormonat(startDatumAAG)) {
                this.ermittleTagesUndMonatswerteDreiMonatsdurchschnitt();
            }
            this.ermittleKalendertageM();
        }
    }

    private void ermittleTagesUndMonatswerteDreiMonatsdurchschnitt() throws BusinessDomainException {
        Date suchDatum = DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb())));
        int anzMonate = 0;
        Date verglDatum = DateHelper.beforeOrEqual((Date)this.mEeLib.marbEintritt(), (Date)this.mGlLib.firmaBerechnungsStart()) ? this.mGlLib.firmaBerechnungsStart() : this.mEeLib.marbEintritt();
        BigDecimal lGesBrutto = BigDecimal.ZERO;
        BigDecimal lGesNetto = BigDecimal.ZERO;
        int lGesTage = 0;
        while (anzMonate < 3 && DateHelper.afterOrEqual((Date)suchDatum, (Date)verglDatum)) {
            ValuePosition[] vpArray;
            boolean gueltigerMonat = false;
            int lMonTage = 0;
            BigDecimal lMonBrutto = BigDecimal.ZERO;
            BigDecimal lMonNetto = BigDecimal.ZERO;
            block9: for (ValuePosition vPos : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungWirksamAb(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes(130590, 700400, 770020, 770025, 770000, 770005, 770010, 771020, 771000, 771010, 774510, 774511, 774512, 774514, 774550, 774730, 774760, 774761, 774762, 774764, 774800, 774980, 775510, 775512, 775514, 775520, 775550, 775555, 775560, 775650, 775655, 775720, 775725, 775730))) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 130590: {
                        if (BigDecimalMapper.compareTo((BigDecimal)vPos.getFactor1(), (BigDecimal)DREISSIG) != 0) {
                            lMonTage = this.ermittelKalendertageMitarbeiter(suchDatum);
                            continue block9;
                        }
                        gueltigerMonat = true;
                        if (this.mEeLib.marbArtDerEntgeltErmittlung().value() == 0) {
                            lMonTage = new VDate(DateHelper.getLastDayOfMonth((Date)suchDatum)).getDay();
                            continue block9;
                        }
                        lMonTage = 30;
                        continue block9;
                    }
                    case 700400: {
                        ValuePosition[] vpArray2;
                        lMonNetto = lMonNetto.add(vPos.getResult());
                        for (ValuePosition vPos2 : vpArray2 = ValuePositionPersistencyManager.getValuePositions(null, (Criterion)new Conjunction(new Criterion[]{Restrictions.eq((String)"oidgenesisparent", (String)vPos.getGenesisOfParentObjects().getObjectid())}))) {
                            switch (vPos2.getValueType().getValueTypeKey()) {
                                case 100200: {
                                    lMonBrutto = lMonBrutto.add(vPos2.getResult());
                                    continue block9;
                                }
                            }
                        }
                        continue block9;
                    }
                    case 770020: 
                    case 770025: 
                    case 771020: 
                    case 775510: 
                    case 775512: 
                    case 775514: 
                    case 775520: 
                    case 775550: 
                    case 775555: 
                    case 775560: 
                    case 775650: 
                    case 775655: 
                    case 775720: 
                    case 775725: 
                    case 775730: {
                        lMonNetto = lMonNetto.add(vPos.getResult());
                        continue block9;
                    }
                    default: {
                        lMonNetto = lMonNetto.subtract(vPos.getResult());
                    }
                }
            }
            if (gueltigerMonat) {
                ++anzMonate;
                lGesBrutto = lGesBrutto.add(lMonBrutto);
                lGesNetto = lGesNetto.add(lMonNetto);
                lGesTage += lMonTage;
            }
            suchDatum = DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)suchDatum));
        }
        if (anzMonate == 3) {
            this.mMonatsbrutto = lGesBrutto.divide(DREI, 2, RoundingMode.HALF_UP);
            this.mMonatsnetto = lGesNetto.divide(DREI, 2, RoundingMode.HALF_UP);
            this.mTagesnetto = lGesNetto.divide(BigDecimal.valueOf(lGesTage), 2, RoundingMode.HALF_UP);
        } else {
            this.mMonatsbrutto = this.mEeLib.marbMugAagBruttoMonatlich();
            this.mMonatsnetto = this.mEeLib.marbMugAagNettoMonatlich();
            this.mTagesnetto = this.mEeLib.marbMugAagNettoTaeglich();
        }
    }

    private int ermittelKalendertageMitarbeiter(Date suchDatum) throws BusinessDomainException {
        int i;
        int[] mDays = new int[new VDate(DateHelper.getLastDayOfMonth((Date)suchDatum)).getDay()];
        for (int i2 = 0; i2 < mDays.length; ++i2) {
            mDays[i2] = 1;
        }
        Date ersterDesMonats = DateHelper.getFirstDayOfMonth((Date)suchDatum);
        Date letzterDesMonats = DateHelper.getLastDayOfMonth((Date)suchDatum);
        if (this.mEeLib.marbAustritt() != null && DateHelper.between((Date)this.mEeLib.marbAustritt(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
            for (int i3 = new VDate(this.mEeLib.marbAustritt()).getDay(); i3 < mDays.length; ++i3) {
                mDays[i3] = 0;
            }
        }
        if (DateHelper.between((Date)this.mEeLib.marbEintritt(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
            int eintrittsTag = new VDate(this.mEeLib.marbEintritt()).getDay();
            for (i = 0; i < eintrittsTag - 1; ++i) {
                mDays[i] = 0;
            }
        }
        EEAbsentTimeTP[] fehlzeiten = this.mEeLib.aktuelleFehlzeitenfuerMonat(suchDatum);
        for (i = 0; i < fehlzeiten.length; ++i) {
            if (!fehlzeiten[i].getEEAbsentTime().getAbsentTime().getAbsentTimeTP(this.mCalLib.berchnungWirksamAb(), suchDatum).getCutByPartTimePayPeriod() || StringMapper.equal((String)fehlzeiten[i].getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"9.9") && !this.vortagGekuerzt(fehlzeiten[i])) continue;
            int start = 0;
            int ende = mDays.length - 1;
            if (DateHelper.before((Date)fehlzeiten[i].getValidUntil(), (Date)ersterDesMonats) || DateHelper.after((Date)fehlzeiten[i].getValidFrom(), (Date)letzterDesMonats)) continue;
            if (DateHelper.between((Date)fehlzeiten[i].getValidFrom(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
                start = new VDate(fehlzeiten[i].getValidFrom()).getDay() - 1;
            }
            if (DateHelper.between((Date)fehlzeiten[i].getValidUntil(), (Date)ersterDesMonats, (Date)letzterDesMonats)) {
                ende = new VDate(fehlzeiten[i].getValidUntil()).getDay() - 1;
            }
            for (int j = start; j <= ende; ++j) {
                mDays[j] = 0;
            }
        }
        int tage = 0;
        for (int day : mDays) {
            tage += day;
        }
        return tage;
    }

    private boolean vortagGekuerzt(EEAbsentTimeTP fehlzeit) throws BusinessDomainException {
        EEAbsentTimeTP[] vorFehlzeit;
        Date todesTag = fehlzeit.getValidFrom();
        for (EEAbsentTimeTP absentTimeTP : vorFehlzeit = this.mEeLib.marb().getEEAbsentTimesTP(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEeLib.marb().getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)this.mVpLib.wirksamAb())), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)this.mVpLib.wirksamAb())), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.yesterday((Date)todesTag))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.yesterday((Date)todesTag)))}), true)) {
            if (!absentTimeTP.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(this.mVpLib.wirksamAb(), absentTimeTP.getValidUntil()).getCutByPartTimePayPeriod()) continue;
            return true;
        }
        return false;
    }

    private SVAGAValues ermittleTatsaechlicheBeitraege() throws BusinessDomainException {
        BigDecimal pvAgaVhSatz;
        BigDecimal avAgaVhSatz;
        BigDecimal rvAgaVhSatz;
        BigDecimal bbgKvPv = this.mGlLib.svBbgKvPv().multiply(this.mIstZeit).divide(this.mSollzeit, 2, RoundingMode.HALF_UP);
        BigDecimal bbgRvAv = this.mGlLib.svBbgRvAv().multiply(this.mIstZeit).divide(this.mSollzeit, 2, RoundingMode.HALF_UP);
        BigDecimal umlageEntgeltKVPV = BigDecimalMapper.compareTo((BigDecimal)this.mCalLib.umlageEntgelt(), (BigDecimal)bbgKvPv) > 0 ? bbgKvPv : this.mCalLib.umlageEntgelt();
        BigDecimal umlageEntgeltRVAV = BigDecimalMapper.compareTo((BigDecimal)this.mCalLib.umlageEntgelt(), (BigDecimal)bbgRvAv) > 0 ? bbgRvAv : this.mCalLib.umlageEntgelt();
        BigDecimal lAgaSV = BigDecimal.ZERO;
        BigDecimal lAgVhSatzGesamt = BigDecimal.ZERO;
        BigDecimal kvAgaVhSatz = this.ermittleKvAgaVhSatz();
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)kvAgaVhSatz)) {
            lAgaSV = lAgaSV.add(umlageEntgeltKVPV.multiply(kvAgaVhSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            lAgVhSatzGesamt = lAgVhSatzGesamt.add(kvAgaVhSatz);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)(rvAgaVhSatz = this.ermittleRvAgaVhSatz()))) {
            lAgaSV = lAgaSV.add(umlageEntgeltRVAV.multiply(rvAgaVhSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            lAgVhSatzGesamt = lAgVhSatzGesamt.add(rvAgaVhSatz);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)(avAgaVhSatz = this.ermittleAvAgaVhSatz()))) {
            lAgaSV = lAgaSV.add(umlageEntgeltRVAV.multiply(avAgaVhSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            lAgVhSatzGesamt = lAgVhSatzGesamt.add(avAgaVhSatz);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)(pvAgaVhSatz = this.ermittlePvAgaVhSatz()))) {
            lAgaSV = lAgaSV.add(umlageEntgeltKVPV.multiply(pvAgaVhSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            lAgVhSatzGesamt = lAgVhSatzGesamt.add(pvAgaVhSatz);
        }
        return new SVAGAValues(lAgaSV, lAgVhSatzGesamt);
    }

    private void ermittlungAGA_G() throws BusinessDomainException {
        this.initializeG();
        switch (this.mArtDerErstattungdberechnung.value()) {
            case 0: {
                this.ermittleKalendertageG();
                break;
            }
            case 1: {
                this.ermittleArbeitstageG();
                break;
            }
            case 2: {
                this.ermittleArbeitsstundenG();
            }
        }
        this.ermittleAGAErstattung();
    }

    private void ermittlungAGA_I() throws BusinessDomainException {
        this.initializeI();
        switch (this.mArtDerErstattungdberechnung.value()) {
            case 0: {
                this.ermittleKalendertageI();
                break;
            }
            case 1: {
                this.ermittleArbeitstageI();
                break;
            }
            case 2: {
                this.ermittleArbeitsstundenI();
            }
        }
        this.ermittleAGAErstattung();
    }

    private void ermittlungEntgelt_G() throws BusinessDomainException {
        this.initializeG();
        switch (this.mArtDerErstattungdberechnung.value()) {
            case 0: {
                this.ermittleKalendertageG();
                break;
            }
            case 1: {
                this.ermittleArbeitstageG();
                break;
            }
            case 2: {
                this.ermittleArbeitsstundenG();
            }
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mSollzeit)) {
            this.mCalLib.result(BigDecimal.ZERO);
        } else {
            if (this.mKuerzungDurchBbgRv) {
                BigDecimal svBbg = this.getRVAVBBG();
                if (this.mCalLib.umlageEntgelt().compareTo(svBbg) > 0) {
                    this.mCalLib.umlageEntgelt(svBbg);
                }
            }
            this.mCalLib.result(this.mCalLib.umlageEntgelt().multiply(this.mIstZeit).divide(this.mSollzeit, 2, RoundingMode.HALF_UP));
            if (this.mVpLib.wertPosition().getValueType().getValueTypeKey() != 372225) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.wertPosition().getPersistentBuffer5())) {
                    this.mVpLib.wertPosition().setPersistentBuffer5(this.mCalLib.result().subtract(this.mCalLib.result1()));
                }
            } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.wertPosition().getPersistentBuffer5())) {
                this.mVpLib.wertPosition().setPersistentBuffer5(this.mCalLib.getValuePosition().getPersistentBuffer5().multiply(this.mIstZeit).divide(this.mSollzeit, 2, RoundingMode.HALF_UP));
            }
            this.mVpLib.addNeueWertPosition(372620, BigDecimal.ZERO, BigDecimal.ZERO, this.mIstZeit, BigDecimal.ZERO, this.mCalLib.result().subtract(this.mCalLib.result1()), false, this.mCalLib.getValuePosition().getPersistentBuffer1(), this.mCalLib.getValuePosition().getPersistentBuffer2(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            if (this.mErstattungAGA.value() != 0) {
                this.mVpLib.addNeueWertPosition(372320, BigDecimal.ZERO, BigDecimal.ZERO, this.mIstZeit, BigDecimal.ZERO, this.mCalLib.getValuePosition().getPersistentBuffer5(), false, this.mCalLib.getValuePosition().getPersistentBuffer1(), this.mCalLib.getValuePosition().getPersistentBuffer2(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            }
        }
    }

    private void ermittlungEntgelt_I() throws BusinessDomainException {
        this.initializeI();
        switch (this.mArtDerErstattungdberechnung.value()) {
            case 0: {
                this.ermittleKalendertageI();
                break;
            }
            case 1: {
                this.ermittleArbeitstageI();
                break;
            }
            case 2: {
                this.ermittleArbeitsstundenI();
            }
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mSollzeit)) {
            this.mCalLib.result(BigDecimal.ZERO);
        } else {
            if (this.mKuerzungDurchBbgRv) {
                BigDecimal svBbg = this.getRVAVBBG();
                if (this.mCalLib.umlageEntgelt().compareTo(svBbg) > 0) {
                    this.mCalLib.umlageEntgelt(svBbg);
                }
            }
            this.mCalLib.result(this.mCalLib.umlageEntgelt().multiply(this.mIstZeit).divide(this.mSollzeit, 2, RoundingMode.HALF_UP));
            if (this.mVpLib.wertPosition().getValueType().getValueTypeKey() != 372235) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.wertPosition().getPersistentBuffer5())) {
                    this.mVpLib.wertPosition().setPersistentBuffer5(this.mCalLib.result().subtract(this.mCalLib.result1()));
                } else {
                    this.mVpLib.wertPosition().setPersistentBuffer5(this.mCalLib.getValuePosition().getPersistentBuffer5().multiply(this.mIstZeit).divide(this.mSollzeit, 2, RoundingMode.HALF_UP));
                }
            } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.wertPosition().getPersistentBuffer5())) {
                this.mVpLib.wertPosition().setPersistentBuffer5(this.mCalLib.getValuePosition().getPersistentBuffer5().multiply(this.mIstZeit).divide(this.mSollzeit, 2, RoundingMode.HALF_UP));
            }
            this.mVpLib.addNeueWertPosition(372630, BigDecimal.ZERO, BigDecimal.ZERO, this.mIstZeit, BigDecimal.ZERO, this.mCalLib.result().subtract(this.mCalLib.result1()), false, this.mCalLib.getValuePosition().getPersistentBuffer1(), this.mCalLib.getValuePosition().getPersistentBuffer2(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            if (this.mErstattungAGA.value() != 0) {
                this.mVpLib.addNeueWertPosition(372330, BigDecimal.ZERO, BigDecimal.ZERO, this.mIstZeit, BigDecimal.ZERO, this.mCalLib.getValuePosition().getPersistentBuffer5(), false, this.mCalLib.getValuePosition().getPersistentBuffer1(), this.mCalLib.getValuePosition().getPersistentBuffer2(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            }
        }
    }

    private void ermittlungErstattung_G() throws BusinessDomainException {
        this.initializeG();
        BigDecimal erstattungAGAnteil = BigDecimal.ZERO;
        for (ValuePosition vPos : this.mVpLib.getFolgen(this.mVpLib.parent())) {
            if (vPos.getValueType().getValueTypeKey() != 372320) continue;
            erstattungAGAnteil = erstattungAGAnteil.add(vPos.getResult());
        }
        BigDecimal grundlage = this.mVpLib.parent().getResult();
        BigDecimal umlageErstattungsU2Prozentsatz = this.mGlLib.umlageErstattungU2(this.mUmlagekasse);
        this.mCalLib.result(grundlage.add(erstattungAGAnteil).multiply(umlageErstattungsU2Prozentsatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.mCalLib.percentage(umlageErstattungsU2Prozentsatz);
    }

    private void ermittlungErstattung_I() throws BusinessDomainException {
        this.initializeI();
        BigDecimal erstattungAGAnteil = BigDecimal.ZERO;
        for (ValuePosition vPos : this.mVpLib.getFolgen(this.mVpLib.parent())) {
            if (vPos.getValueType().getValueTypeKey() != 372330) continue;
            erstattungAGAnteil = erstattungAGAnteil.add(vPos.getResult());
        }
        BigDecimal grundlage = this.mVpLib.parent().getResult();
        BigDecimal umlageErstattungsU2Prozentsatz = this.mGlLib.umlageErstattungU2(this.mUmlagekasse);
        this.mCalLib.result(grundlage.add(erstattungAGAnteil).multiply(umlageErstattungsU2Prozentsatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.mCalLib.percentage(umlageErstattungsU2Prozentsatz);
    }

    private void ermittlungErstattung_M() throws BusinessDomainException {
        this.initializeM();
        BigDecimal grundlage = this.mVpLib.parent().getResult();
        BigDecimal umlageErstattungsU2Prozentsatz = this.mGlLib.umlageErstattungU2(this.mUmlagekasse);
        this.mCalLib.result(grundlage.multiply(umlageErstattungsU2Prozentsatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.mCalLib.percentage(umlageErstattungsU2Prozentsatz);
    }

    private void ermittlungMugEntgelte() throws BusinessDomainException {
        BigDecimal betragAlt;
        this.ermittleTagesUndMonatswerte();
        this.mVpLib.addNeueWertPosition(372310, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(this.mFehltageMuG), BigDecimal.ZERO, this.mMonatsbrutto, true);
        this.mVpLib.addNeueWertPosition(372312, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(this.mFehltageMuG), BigDecimal.ZERO, this.mTagesnetto, true);
        this.mVpLib.addNeueWertPosition(372314, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.valueOf(this.mFehltageMuG), BigDecimal.ZERO, this.mMonatsnetto, true);
        this.mCalLib.factor1(BigDecimal.valueOf(this.mFehltageMuG));
        BigDecimal lZuschussKrk = this.mEeLib.marbMuGAagZuschussKrk();
        if (this.mTagesnetto.subtract(lZuschussKrk).compareTo(BigDecimal.ZERO) > 0) {
            this.mCalLib.result(this.mTagesnetto.subtract(lZuschussKrk).multiply(BigDecimal.valueOf(this.mFehltageMuG)));
        }
        if (BigDecimalMapper.compareTo((BigDecimal)(betragAlt = this.mCalLib.result1()), (BigDecimal)this.mCalLib.result()) != 0) {
            this.mVpLib.addNeueWertPosition(372610, BigDecimal.ZERO, BigDecimal.ZERO, this.mCalLib.factor1(), lZuschussKrk, this.mCalLib.result(), false);
        }
    }

    private BigDecimal getConcreteTargetDaysOfAbsence(Employee employee, Date effectiveTimePoint, Date from, Date until, EEAbsentTimeTP attp) throws BusinessDomainException {
        BigDecimal concreteTargetDaysOfAbsence;
        WorkingTime workingTime = employee.getAppurtenantWorkingTime(effectiveTimePoint, from);
        if (workingTime == null) {
            return BigDecimal.ZERO;
        }
        WorkingTimeTP wttp = workingTime.getWorkingTimeTP(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb());
        Date begin = from;
        if (DateHelper.between((Date)attp.getValidFrom(), (Date)from, (Date)until)) {
            begin = attp.getValidFrom();
        }
        Date end = until;
        if (DateHelper.between((Date)attp.getValidUntil(), (Date)from, (Date)until)) {
            end = attp.getValidUntil();
        }
        if (BigDecimalMapper.compareTo((BigDecimal)(concreteTargetDaysOfAbsence = workingTime.getConcreteTargetDays(begin, end, employee, effectiveTimePoint, from, wttp.getPaidPublicHoliday())), (BigDecimal)BigDecimal.ONE) == 0 && attp.getHalfLeaveDay()) {
            concreteTargetDaysOfAbsence = concreteTargetDaysOfAbsence.setScale(2);
            return concreteTargetDaysOfAbsence.divide(BigDecimal.valueOf(2L), RoundingMode.HALF_DOWN).setScale(2);
        }
        return concreteTargetDaysOfAbsence;
    }

    private BigDecimal getConcreteTargetHoursOfAbsence(Employee employee, Date effectiveTimePoint, Date from, Date until, EEAbsentTimeTP attp) throws BusinessDomainException {
        WorkingTime workingTime = employee.getAppurtenantWorkingTime(effectiveTimePoint, from);
        if (workingTime == null) {
            return BigDecimal.ZERO;
        }
        WorkingTimeTP wttp = workingTime.getWorkingTimeTP(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb());
        Date begin = from;
        if (DateHelper.between((Date)attp.getValidFrom(), (Date)from, (Date)until)) {
            begin = attp.getValidFrom();
        }
        Date end = until;
        if (DateHelper.between((Date)attp.getValidUntil(), (Date)from, (Date)until)) {
            end = attp.getValidUntil();
        }
        BigDecimal arbeitsstundenProTag = BigDecimalMapper.isZeroOrNull((BigDecimal)attp.getNumberOfWorkingHours()) ? BigDecimal.ZERO : attp.getNumberOfWorkingHours().setScale(2);
        BigDecimal fehlstundenProTag = BigDecimalMapper.isZeroOrNull((BigDecimal)attp.getNumberOfHours()) ? BigDecimal.ZERO : attp.getNumberOfHours().setScale(2);
        BigDecimal hourOfAbsence = workingTime.getConcreteTargetHours(begin, end, employee, effectiveTimePoint, from, wttp.getPaidPublicHoliday(), fehlstundenProTag, arbeitsstundenProTag);
        return hourOfAbsence;
    }

    private void initializeG() throws BusinessDomainException {
        this.mUmlagekasse = this.mEeLib.marbUmlagekasse();
        if (this.mUmlagekasse == null) {
            this.mUmlagekasse = this.mGlLib.umlageKasseFirma();
        }
        if (this.mUmlagekasse == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentHealthFundFoundDomainException(this.mCalLib.berchnungGueltigAb());
        }
        this.mArtDerErstattungdberechnung = BigDecimalMapper.compareTo((BigDecimal)this.mVpLib.wertPosition().getPersistentBuffer1(), (BigDecimal)BigDecimalMapper.toBigDecimal((String)"10.43")) == 0 && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.wertPosition().getPersistentBuffer2()) ? TypeOfTimeOffEnum.TOTOE_ARBEITSSTUNDEN : this.mEeLib.marbUmlageErstattungsberechnung();
        HealthFundTP umlagekasseTP = this.mUmlagekasse.getHealthFundTP(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb());
        this.mKuerzungDurchBbgRv = umlagekasseTP.getU2LimitationProhibitionToEmploy();
        this.mErstattungAGA = umlagekasseTP.getU2RefundSocialInsuranceER();
        this.mPauschalAGAVHSatz = umlagekasseTP.getU2RefundPercentageFact();
    }

    private void initializeI() throws BusinessDomainException {
        this.mUmlagekasse = this.mEeLib.marbUmlagekasse();
        if (this.mUmlagekasse == null) {
            this.mUmlagekasse = this.mGlLib.umlageKasseFirma();
        }
        if (this.mUmlagekasse == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentHealthFundFoundDomainException(this.mCalLib.berchnungGueltigAb());
        }
        this.mArtDerErstattungdberechnung = BigDecimalMapper.compareTo((BigDecimal)this.mVpLib.wertPosition().getPersistentBuffer1(), (BigDecimal)BigDecimalMapper.toBigDecimal((String)"10.44")) == 0 && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mVpLib.wertPosition().getPersistentBuffer2()) ? TypeOfTimeOffEnum.TOTOE_ARBEITSSTUNDEN : this.mEeLib.marbUmlageErstattungsberechnung();
        HealthFundTP umlagekasseTP = this.mUmlagekasse.getHealthFundTP(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb());
        this.mKuerzungDurchBbgRv = umlagekasseTP.getU2LimitationProhibitionToEmploy();
        this.mErstattungAGA = umlagekasseTP.getU2RefundSocialInsuranceER();
        this.mPauschalAGAVHSatz = umlagekasseTP.getU2RefundPercentageFact();
    }

    private void initializeM() throws BusinessDomainException {
        this.mUmlagekasse = this.mEeLib.marbUmlagekasse();
        if (this.mUmlagekasse == null) {
            this.mUmlagekasse = this.mGlLib.umlageKasseFirma();
        }
        if (this.mUmlagekasse == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentHealthFundFoundDomainException(this.mCalLib.berchnungGueltigAb());
        }
        this.mArtDerErstattungdberechnung = this.mEeLib.marbUmlageErstattungsberechnung();
        HealthFundTP umlagekasseTP = this.mUmlagekasse.getHealthFundTP(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb());
        this.mKuerzungDurchBbgRv = umlagekasseTP.getU2LimittationMother();
    }

    private boolean keineParameterVormonat(Date startDatumAAG) throws BusinessDomainException {
        block13: {
            Date ersterVormonat;
            block12: {
                EECarriedForwardVarPayment[] cfVP;
                ersterVormonat = DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb())));
                if (!DateHelper.before((Date)ersterVormonat, (Date)startDatumAAG)) break block12;
                block10: for (EECarriedForwardVarPayment varPayment : cfVP = EECarriedForwardVarPayment.getEECarriedForwardVarPayments((Employee)this.mEeLib.marb(), (Date)ersterVormonat, (Date)DateHelper.getLastDayOfMonth((Date)ersterVormonat))) {
                    switch (varPayment.getValueType().getValueTypeKey()) {
                        case 372310: {
                            this.mMonatsbrutto = varPayment.getResult();
                            continue block10;
                        }
                        case 372312: {
                            this.mTagesnetto = varPayment.getResult();
                            continue block10;
                        }
                        case 372314: {
                            this.mMonatsnetto = varPayment.getResult();
                        }
                    }
                }
                break block13;
            }
            ValuePosition[] vpArray = this.mVpLib.wpAusWPListeOderDB(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungWirksamAb(), ersterVormonat, DateHelper.getLastDayOfMonth((Date)ersterVormonat), ValueTypeHelper.getValueTypes(372310, 372314, 372312));
            if (vpArray.length == 0) break block13;
            block11: for (ValuePosition vPos : vpArray) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 372310: {
                        this.mMonatsbrutto = vPos.getResult();
                        continue block11;
                    }
                    case 372312: {
                        this.mTagesnetto = vPos.getResult();
                        continue block11;
                    }
                    case 372314: {
                        this.mMonatsnetto = vPos.getResult();
                    }
                }
            }
        }
        return BigDecimalMapper.isZero((BigDecimal)this.mMonatsbrutto.add(this.mTagesnetto).add(this.mMonatsnetto));
    }

    private SVAGAValues pauschalerZuschlag(BigDecimal grundlage) {
        BigDecimal svAGA = grundlage.multiply(this.mPauschalAGAVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        return new SVAGAValues(svAGA, this.mPauschalAGAVHSatz);
    }

    private boolean vollerBeitragssatzAV() throws BusinessDomainException {
        boolean result = false;
        ValuePosition[] vpArray = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes(335520));
        if (vpArray.length != 0) {
            result = true;
        }
        return result;
    }

    private boolean vollerBeitragssatzKV() throws BusinessDomainException {
        ValuePosition[] vpArray = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes(323520, 323620));
        boolean result = false;
        if (vpArray.length != 0) {
            result = true;
        }
        return result;
    }

    private boolean vollerBeitragssatzPV() throws BusinessDomainException {
        boolean result = false;
        ValuePosition[] vpArray = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes(341520));
        if (vpArray.length != 0) {
            result = true;
        }
        return result;
    }

    private boolean vollerBeitragssatzRV() throws BusinessDomainException {
        boolean result = false;
        ValuePosition[] vpArray = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes(329520));
        if (vpArray.length != 0) {
            result = true;
        }
        return result;
    }

    protected BigDecimal getMonatlicheIstStundenMitarbeiter() throws BusinessDomainException {
        return this.mMumLib.monatlicheIstStundenMitarbeiter(false);
    }

    private BigDecimal getRVAVBBG() throws BusinessDomainException {
        BigDecimal svTage = this.mVpLib.svTage();
        BigDecimal rVAVBBG = BigDecimal.ZERO;
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)svTage)) {
            rVAVBBG = this.mGlLib.svBbgRvAv().multiply(svTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        }
        return rVAVBBG;
    }

    private class SVAGAValues {
        private final BigDecimal svAga;
        private final BigDecimal percentage;

        private SVAGAValues(BigDecimal svAga, BigDecimal percentage) {
            this.svAga = svAga;
            this.percentage = percentage;
        }
    }
}

