/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.employment.TypeOfTimeOffEnum;
import com.varial.personnel.domain.employee.insurance.ModeOfPensionEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.libraryimpl.MultipleUsedMethodsImpl;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.RefundSIEREnum;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.domain.workingtime.WorkingTimeTP;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungUmlageerstattungU1Formula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private TypeOfTimeOffEnum artDerErstattungdberechnung;
    private BigDecimal avAgaVhSatz = BigDecimal.ZERO;
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private RefundSIEREnum erstattungAGA;
    private BigDecimal erstattungAGAnteil = BigDecimal.ZERO;
    private final GlobalLibrary gllib;
    private BigDecimal istZeit = BigDecimal.ZERO;
    private boolean kuerzungDurchBbgRv = false;
    private BigDecimal kvAgaVhSatz = BigDecimal.ZERO;
    private BigDecimal mGrundlage = BigDecimal.ZERO;
    private BigDecimal mUmlageErstattungsU1Prozentsatz = BigDecimal.ZERO;
    private HealthFund mUmlagekasse;
    private HealthFundTP mUmlagekasseTP;
    private final MultipleUsedMethodsImpl mumlib;
    private BigDecimal pauschalAGAVHSatz = BigDecimal.ZERO;
    private BigDecimal pvAgaVhSatz = BigDecimal.ZERO;
    private BigDecimal rvAgaVhSatz = BigDecimal.ZERO;
    private BigDecimal sollzeit = BigDecimal.ZERO;
    private BigDecimal svBbg = BigDecimal.ZERO;
    private final ValuePositionLibrary wplib;

    public ErmittlungUmlageerstattungU1Formula(CalculationLibrary calLib, EmployeeLibrary eeLib, GlobalLibrary glLib, ValuePositionLibrary wpLib) {
        this.callib = calLib;
        this.eelib = eeLib;
        this.gllib = glLib;
        this.wplib = wpLib;
        this.mumlib = new MultipleUsedMethodsImpl(this.callib, this.eelib, this.gllib, this.wplib);
    }

    public void ermittel() throws BusinessDomainException {
        switch (this.wplib.wertartenNummer()) {
            case 371210: 
            case 371215: {
                if (this.wplib.parent().getValueType().getValueTypeKey() > 100000) {
                    this.ermittlungEntgelt_K();
                    break;
                }
                this.callib.result(this.wplib.result());
                break;
            }
            case 371220: 
            case 371225: {
                if (this.wplib.parent().getValueType().getValueTypeKey() > 100000) {
                    this.ermittlungEntgelt_U();
                    break;
                }
                this.callib.result(this.wplib.result());
                break;
            }
            case 371230: 
            case 371235: {
                this.ermittlungEntgelt_S();
                break;
            }
            case 371310: {
                this.ermittlungAGA_K();
                break;
            }
            case 371320: {
                this.ermittlungAGA_U();
                break;
            }
            case 371330: {
                this.ermittlungAGA_S();
                break;
            }
            case 371610: {
                this.ermittlungErstattung_K();
                break;
            }
            case 371620: {
                this.ermittlungErstattung_U();
                break;
            }
            case 371630: {
                this.ermittlungErstattung_S();
            }
        }
    }

    private void ermittleAGAErstattung() throws BusinessDomainException {
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.sollzeit)) {
            this.callib.result(BigDecimal.ZERO);
        } else {
            this.mGrundlage = this.wplib.parent().getPersistentBuffer5();
            this.mGrundlage = this.mGrundlage.add(this.wplib.wertPosition().getPersistentBuffer5());
            SVAGAValues svAGAValues = new SVAGAValues(BigDecimal.ZERO, BigDecimal.ZERO);
            switch (this.erstattungAGA.value()) {
                case 3: {
                    this.svBbg = this.gllib.svBbgRvAv();
                    if (this.mGrundlage.compareTo(this.svBbg) > 0) {
                        this.mGrundlage = this.svBbg;
                    }
                }
                case 2: {
                    this.mGrundlage = this.mGrundlage.multiply(this.istZeit).divide(this.sollzeit, 2, RoundingMode.HALF_UP);
                    svAGAValues = this.pauschalerZuschlag();
                    break;
                }
                case 1: {
                    this.mGrundlage = this.mGrundlage.multiply(this.istZeit).divide(this.sollzeit, 2, RoundingMode.HALF_UP);
                    svAGAValues = this.ermittleTatsaechlicheBeitraege();
                    break;
                }
                case 4: {
                    SVAGAValues svAGAValuesPauchal = this.pauschalerZuschlag();
                    SVAGAValues svAGAValuesTatsaechlich = this.ermittleTatsaechlicheBeitraege();
                    svAGAValues = BigDecimalMapper.compareTo((BigDecimal)svAGAValuesPauchal.svAga, (BigDecimal)svAGAValuesTatsaechlich.svAga) > 0 ? svAGAValuesTatsaechlich : svAGAValuesPauchal;
                    break;
                }
                default: {
                    this.mGrundlage = this.mGrundlage.multiply(this.istZeit).divide(this.sollzeit, 2, RoundingMode.HALF_UP);
                }
            }
            this.callib.result(svAGAValues.svAga);
            this.callib.percentage(svAGAValues.percentage);
            this.callib.factor2(this.mGrundlage.subtract(this.wplib.wertPosition().getSumOfBasicResult()));
            this.wplib.wertPosition().setSumOfBasicResult(this.mGrundlage);
        }
    }

    private void ermittleArbeitsstundenK() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        this.sollzeit = this.mumlib.monatlicheIstStundenMitarbeiter();
        for (EEAbsentTimeTP lEeAbsentTimeTP : absentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(this.callib.berchnungGueltigAb())) {
            if (!StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.3") && !StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.31")) continue;
            Date from = this.callib.berchnungGueltigAb();
            if (DateHelper.after((Date)lEeAbsentTimeTP.getValidFrom(), (Date)from)) {
                from = lEeAbsentTimeTP.getValidFrom();
            }
            Date until = DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb());
            if (DateHelper.before((Date)lEeAbsentTimeTP.getValidUntil(), (Date)until)) {
                until = lEeAbsentTimeTP.getValidUntil();
            }
            this.istZeit = this.istZeit.add(this.getConcreteTargetHoursOfAbsence(this.eelib.marb(), this.callib.berchnungWirksamAb(), from, until, lEeAbsentTimeTP));
        }
    }

    private void ermittleArbeitsstundenS() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        this.sollzeit = this.mumlib.monatlicheIstStundenMitarbeiter();
        for (EEAbsentTimeTP lEeAbsentTimeTP : absentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(this.callib.berchnungGueltigAb())) {
            if (!StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.33")) continue;
            Date from = this.callib.berchnungGueltigAb();
            if (DateHelper.after((Date)lEeAbsentTimeTP.getValidFrom(), (Date)from)) {
                from = lEeAbsentTimeTP.getValidFrom();
            }
            Date until = DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb());
            if (DateHelper.before((Date)lEeAbsentTimeTP.getValidUntil(), (Date)until)) {
                until = lEeAbsentTimeTP.getValidUntil();
            }
            this.istZeit = this.istZeit.add(this.getConcreteTargetHoursOfAbsence(this.eelib.marb(), this.callib.berchnungWirksamAb(), from, until, lEeAbsentTimeTP));
        }
    }

    private void ermittleArbeitsstundenU() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        this.sollzeit = this.mumlib.monatlicheIstStundenMitarbeiter();
        for (EEAbsentTimeTP lEeAbsentTimeTP : absentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(this.callib.berchnungGueltigAb())) {
            if (!StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.32")) continue;
            Date from = this.callib.berchnungGueltigAb();
            if (DateHelper.after((Date)lEeAbsentTimeTP.getValidFrom(), (Date)from)) {
                from = lEeAbsentTimeTP.getValidFrom();
            }
            Date until = DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb());
            if (DateHelper.before((Date)lEeAbsentTimeTP.getValidUntil(), (Date)until)) {
                until = lEeAbsentTimeTP.getValidUntil();
            }
            this.istZeit = this.istZeit.add(this.getConcreteTargetHoursOfAbsence(this.eelib.marb(), this.callib.berchnungWirksamAb(), from, until, lEeAbsentTimeTP));
        }
    }

    private void ermittleArbeitstageK() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        this.sollzeit = this.mumlib.monatlicheIsttageMitarbeiter();
        for (EEAbsentTimeTP lEeAbsentTimeTP : absentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(this.callib.berchnungGueltigAb())) {
            if (!StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.3") && !StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.31")) continue;
            Date from = this.callib.berchnungGueltigAb();
            if (DateHelper.after((Date)lEeAbsentTimeTP.getValidFrom(), (Date)from)) {
                from = lEeAbsentTimeTP.getValidFrom();
            }
            Date until = DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb());
            if (DateHelper.before((Date)lEeAbsentTimeTP.getValidUntil(), (Date)until)) {
                until = lEeAbsentTimeTP.getValidUntil();
            }
            this.istZeit = this.istZeit.add(this.getConcreteTargetDaysOfAbsence(this.eelib.marb(), this.callib.berchnungWirksamAb(), from, until, lEeAbsentTimeTP));
        }
    }

    private void ermittleArbeitstageS() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        this.sollzeit = this.mumlib.monatlicheIsttageMitarbeiter();
        for (EEAbsentTimeTP lEeAbsentTimeTP : absentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(this.callib.berchnungGueltigAb())) {
            if (!StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.33")) continue;
            Date from = this.callib.berchnungGueltigAb();
            if (DateHelper.after((Date)lEeAbsentTimeTP.getValidFrom(), (Date)from)) {
                from = lEeAbsentTimeTP.getValidFrom();
            }
            Date until = DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb());
            if (DateHelper.before((Date)lEeAbsentTimeTP.getValidUntil(), (Date)until)) {
                until = lEeAbsentTimeTP.getValidUntil();
            }
            this.istZeit = this.istZeit.add(this.getConcreteTargetDaysOfAbsence(this.eelib.marb(), this.callib.berchnungWirksamAb(), from, until, lEeAbsentTimeTP));
        }
    }

    private void ermittleArbeitstageU() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        this.sollzeit = this.mumlib.monatlicheIsttageMitarbeiter();
        for (EEAbsentTimeTP lEeAbsentTimeTP : absentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(this.callib.berchnungGueltigAb())) {
            if (!StringMapper.equalWithTrim((String)lEeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.32")) continue;
            Date from = this.callib.berchnungGueltigAb();
            if (DateHelper.after((Date)lEeAbsentTimeTP.getValidFrom(), (Date)from)) {
                from = lEeAbsentTimeTP.getValidFrom();
            }
            Date until = DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb());
            if (DateHelper.before((Date)lEeAbsentTimeTP.getValidUntil(), (Date)until)) {
                until = lEeAbsentTimeTP.getValidUntil();
            }
            this.istZeit = this.istZeit.add(this.getConcreteTargetDaysOfAbsence(this.eelib.marb(), this.callib.berchnungWirksamAb(), from, until, lEeAbsentTimeTP));
        }
    }

    private void ermittleAvAgaVhSatz() throws BusinessDomainException {
        switch (this.eelib.marbBgrAv()) {
            case 1: 
            case 2: {
                this.avAgaVhSatz = this.gllib.svBsGesamtAv();
                break;
            }
            default: {
                this.avAgaVhSatz = BigDecimal.ZERO;
                return;
            }
        }
        if (!this.vollerBeitragssatzAV()) {
            this.avAgaVhSatz = this.avAgaVhSatz.divide(ZWEI, 3, RoundingMode.HALF_UP);
        }
    }

    private void ermittleKalendertageK() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        int[] days = new int[new VDate(DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb())).getDay()];
        for (int i = 0; i < days.length; ++i) {
            days[i] = 0;
        }
        int begin = 0;
        if (DateHelper.between((Date)this.eelib.marbEintritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            begin = new VDate(this.eelib.marbEintritt()).getDay() - 1;
        }
        int end = days.length;
        if (this.eelib.marbAustritt() != null && DateHelper.between((Date)this.eelib.marbAustritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            end = new VDate(this.eelib.marbAustritt()).getDay();
        }
        while (begin < end) {
            days[begin] = 1;
            ++begin;
        }
        for (EEAbsentTimeTP fehlzeit : absentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(this.callib.berchnungGueltigAb())) {
            int zaehler = 0;
            if (StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.3") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.31")) {
                zaehler = 2;
            }
            if (StringMapper.isNullString((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey()) || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.32") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.33") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.41") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.42") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.43") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.44")) continue;
            begin = 0;
            if (DateHelper.between((Date)fehlzeit.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
                begin = new VDate(fehlzeit.getValidFrom()).getDay() - 1;
            }
            end = days.length;
            if (DateHelper.between((Date)fehlzeit.getValidUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
                end = new VDate(fehlzeit.getValidUntil()).getDay();
            }
            while (begin < end) {
                days[begin] = zaehler;
                ++begin;
            }
        }
        for (int lI : days) {
            if (lI == 1) {
                this.sollzeit = this.sollzeit.add(BigDecimal.ONE);
                continue;
            }
            if (lI != 2) continue;
            this.sollzeit = this.sollzeit.add(BigDecimal.ONE);
            this.istZeit = this.istZeit.add(BigDecimal.ONE);
        }
    }

    private void ermittleKalendertageS() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        int[] days = new int[new VDate(DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb())).getDay()];
        for (int i = 0; i < days.length; ++i) {
            days[i] = 0;
        }
        int begin = 0;
        if (DateHelper.between((Date)this.eelib.marbEintritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            begin = new VDate(this.eelib.marbEintritt()).getDay() - 1;
        }
        int end = days.length;
        if (this.eelib.marbAustritt() != null && DateHelper.between((Date)this.eelib.marbAustritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            end = new VDate(this.eelib.marbAustritt()).getDay();
        }
        while (begin < end) {
            days[begin] = 1;
            ++begin;
        }
        for (EEAbsentTimeTP fehlzeit : absentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(this.callib.berchnungGueltigAb())) {
            int zaehler = 0;
            if (StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.33")) {
                zaehler = 2;
            }
            if (StringMapper.isNullString((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey()) || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.3") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.31") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.32") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.41") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.42") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.43") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.44")) continue;
            begin = 0;
            if (DateHelper.between((Date)fehlzeit.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
                begin = new VDate(fehlzeit.getValidFrom()).getDay() - 1;
            }
            end = days.length;
            if (DateHelper.between((Date)fehlzeit.getValidUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
                end = new VDate(fehlzeit.getValidUntil()).getDay();
            }
            while (begin < end) {
                days[begin] = zaehler;
                ++begin;
            }
        }
        for (int lI : days) {
            if (lI == 1) {
                this.sollzeit = this.sollzeit.add(BigDecimal.ONE);
                continue;
            }
            if (lI != 2) continue;
            this.sollzeit = this.sollzeit.add(BigDecimal.ONE);
            this.istZeit = this.istZeit.add(BigDecimal.ONE);
        }
    }

    private void ermittleKalendertageU() throws BusinessDomainException {
        EEAbsentTimeTP[] absentTimeTPs;
        int[] days = new int[new VDate(DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb())).getDay()];
        for (int i = 0; i < days.length; ++i) {
            days[i] = 0;
        }
        int begin = 0;
        if (DateHelper.between((Date)this.eelib.marbEintritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            begin = new VDate(this.eelib.marbEintritt()).getDay() - 1;
        }
        int end = days.length;
        if (this.eelib.marbAustritt() != null && DateHelper.between((Date)this.eelib.marbAustritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            end = new VDate(this.eelib.marbAustritt()).getDay();
        }
        while (begin < end) {
            days[begin] = 1;
            ++begin;
        }
        for (EEAbsentTimeTP fehlzeit : absentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(this.callib.berchnungGueltigAb())) {
            int zaehler = 0;
            if (StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.32")) {
                zaehler = 2;
            }
            if (StringMapper.isNullString((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey()) || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.3") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.31") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.33") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.41") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.42") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.43") || StringMapper.equalWithTrim((String)fehlzeit.getEEAbsentTime().getAbsentTime().getDEUVAbsentTimeKey(), (String)"10.44")) continue;
            begin = 0;
            if (DateHelper.between((Date)fehlzeit.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
                begin = new VDate(fehlzeit.getValidFrom()).getDay() - 1;
            }
            end = days.length;
            if (DateHelper.between((Date)fehlzeit.getValidUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
                end = new VDate(fehlzeit.getValidUntil()).getDay();
            }
            while (begin < end) {
                days[begin] = zaehler;
                ++begin;
            }
        }
        for (int lI : days) {
            if (lI == 1) {
                this.sollzeit = this.sollzeit.add(BigDecimal.ONE);
                continue;
            }
            if (lI != 2) continue;
            this.sollzeit = this.sollzeit.add(BigDecimal.ONE);
            this.istZeit = this.istZeit.add(BigDecimal.ONE);
        }
    }

    private void ermittleKvAgaVhSatz() throws BusinessDomainException {
        block0 : switch (this.eelib.marbBgrKv()) {
            case 1: {
                this.kvAgaVhSatz = this.gllib.krkBsAllgemein();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) break;
                this.kvAgaVhSatz = this.kvAgaVhSatz.add(this.eelib.marbKrkAgaBsZusatzbeitrag().multiply(BigDecimal.valueOf(2L)));
                break;
            }
            case 2: {
                if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate())) {
                    this.kvAgaVhSatz = this.gllib.krkBsErhoeht();
                    if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) break;
                    this.kvAgaVhSatz = this.kvAgaVhSatz.add(this.eelib.marbKrkAgaBsZusatzbeitrag().multiply(BigDecimal.valueOf(2L)));
                    break;
                }
                throw EvaluationExceptionMapper.makeIncreaseDuesGroupHIAfter2008NotAllowedDomainException();
            }
            case 3: {
                this.kvAgaVhSatz = this.gllib.krkBsErmaessigt();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) break;
                this.kvAgaVhSatz = this.kvAgaVhSatz.add(this.eelib.marbKrkAgaBsZusatzbeitrag().multiply(BigDecimal.valueOf(2L)));
                break;
            }
            case 5: {
                this.kvAgaVhSatz = this.gllib.svBsDurchschnittlich();
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) break;
                this.kvAgaVhSatz = this.kvAgaVhSatz.add(this.gllib.kvZusatzDurchVHSatz());
                break;
            }
            case 6: {
                this.kvAgaVhSatz = this.gllib.svBsPauschGfbKV();
                break;
            }
            case 0: {
                this.kvAgaVhSatz = BigDecimal.ZERO;
                if (!this.eelib.marbPKv()) break;
            }
            case 9: {
                switch (this.eelib.marbBklFKv().value()) {
                    case 3: {
                        this.kvAgaVhSatz = this.gllib.krkBsErmaessigt();
                        break block0;
                    }
                    case 1: {
                        this.kvAgaVhSatz = this.gllib.krkBsAllgemein();
                    }
                }
            }
        }
        if (this.eelib.marbBgrKv() != 6 && !this.vollerBeitragssatzKV()) {
            this.kvAgaVhSatz = this.kvAgaVhSatz.divide(ZWEI, 3, RoundingMode.HALF_UP);
        }
    }

    private void ermittlePvAgaVhSatz() throws BusinessDomainException {
        block0 : switch (this.eelib.marbBgrPv()) {
            case 0: {
                switch (this.eelib.marbBklFPv().value()) {
                    case 1: {
                        if (this.gllib.bundeslandSchluesselBeschaeftigungsort() != 15) {
                            this.pvAgaVhSatz = this.gllib.svBsGesamtPV().divide(ZWEI, 4, RoundingMode.HALF_UP);
                            break block0;
                        }
                        this.pvAgaVhSatz = this.gllib.bulaPvAga();
                        break block0;
                    }
                }
                this.pvAgaVhSatz = BigDecimal.ZERO;
                break;
            }
            default: {
                if (this.eelib.marbPPVv()) break;
                this.pvAgaVhSatz = this.gllib.bundeslandSchluesselBeschaeftigungsort() != 15 ? this.gllib.svBsGesamtPV().divide(ZWEI, 4, RoundingMode.HALF_UP) : this.gllib.bulaPvAga();
            }
        }
        if (this.vollerBeitragssatzPV() && this.eelib.marbAelterDreiUndZwanzig() && !this.eelib.isMarbKindErz()) {
            this.pvAgaVhSatz = this.pvAgaVhSatz.add(this.gllib.svBsKinderlosPV());
        }
    }

    private void ermittleRvAgaVhSatz() throws BusinessDomainException {
        block0 : switch (this.eelib.marbBgrRv()) {
            case 0: {
                if (this.eelib.marbVersorgungsart() == ModeOfPensionEnum.MOPE_KEINE) break;
                this.rvAgaVhSatz = this.gllib.svBsGesamtRv();
                this.rvAgaVhSatz = this.rvAgaVhSatz.subtract(this.gllib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.UP));
                break;
            }
            case 1: 
            case 2: {
                switch (this.eelib.marbPgs()) {
                    case 109: {
                        this.rvAgaVhSatz = this.gllib.svBsPauschGfbRv();
                        break block0;
                    }
                }
                switch (this.gllib.krkTyp()) {
                    case 6: {
                        if (this.eelib.marbErhBeitrErmKnappschRV()) {
                            this.rvAgaVhSatz = this.gllib.svBsKnappschaftGesamt();
                            break;
                        }
                    }
                    default: {
                        this.rvAgaVhSatz = this.gllib.svBsGesamtRv();
                    }
                }
                if (this.vollerBeitragssatzRV()) break;
                this.rvAgaVhSatz = this.rvAgaVhSatz.subtract(this.gllib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.UP));
                break;
            }
            case 3: 
            case 4: {
                switch (this.gllib.krkTyp()) {
                    case 6: {
                        if (!this.eelib.marbErhBeitrErmKnappschRV()) break;
                        BigDecimal beitragssatz_ana = this.gllib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                        this.rvAgaVhSatz = this.gllib.svBsKnappschaftGesamt().subtract(beitragssatz_ana);
                        break block0;
                    }
                }
                this.rvAgaVhSatz = this.gllib.svBsGesamtRv().divide(ZWEI, 2, RoundingMode.HALF_UP);
                break;
            }
            case 5: 
            case 6: {
                this.rvAgaVhSatz = this.gllib.svBsPauschGfbRv();
            }
        }
    }

    private SVAGAValues ermittleTatsaechlicheBeitraege() throws BusinessDomainException {
        this.ermittleKvAgaVhSatz();
        this.ermittleRvAgaVhSatz();
        this.ermittleAvAgaVhSatz();
        this.ermittlePvAgaVhSatz();
        BigDecimal lAgaSV = BigDecimal.ZERO;
        BigDecimal lAgVhSatzGesamt = BigDecimal.ZERO;
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.kvAgaVhSatz)) {
            lAgaSV = lAgaSV.add(this.mGrundlage.multiply(this.kvAgaVhSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            lAgVhSatzGesamt = lAgVhSatzGesamt.add(this.kvAgaVhSatz);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.rvAgaVhSatz)) {
            lAgaSV = lAgaSV.add(this.mGrundlage.multiply(this.rvAgaVhSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            lAgVhSatzGesamt = lAgVhSatzGesamt.add(this.rvAgaVhSatz);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.avAgaVhSatz)) {
            lAgaSV = lAgaSV.add(this.mGrundlage.multiply(this.avAgaVhSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            lAgVhSatzGesamt = lAgVhSatzGesamt.add(this.avAgaVhSatz);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.pvAgaVhSatz)) {
            lAgaSV = lAgaSV.add(this.mGrundlage.multiply(this.pvAgaVhSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            lAgVhSatzGesamt = lAgVhSatzGesamt.add(this.pvAgaVhSatz);
        }
        return new SVAGAValues(lAgaSV, lAgVhSatzGesamt);
    }

    private void ermittlungAGA_K() throws BusinessDomainException {
        this.initializeK();
        switch (this.artDerErstattungdberechnung.value()) {
            case 0: {
                this.ermittleKalendertageK();
                break;
            }
            case 1: {
                this.ermittleArbeitstageK();
                break;
            }
            case 2: {
                this.ermittleArbeitsstundenK();
            }
        }
        this.ermittleAGAErstattung();
    }

    private void ermittlungAGA_S() throws BusinessDomainException {
        this.initializeS();
        switch (this.artDerErstattungdberechnung.value()) {
            case 0: {
                this.ermittleKalendertageS();
                break;
            }
            case 1: {
                this.ermittleArbeitstageS();
                break;
            }
            case 2: {
                this.ermittleArbeitsstundenS();
            }
        }
        this.ermittleAGAErstattung();
    }

    private void ermittlungAGA_U() throws BusinessDomainException {
        this.initializeU();
        switch (this.artDerErstattungdberechnung.value()) {
            case 0: {
                this.ermittleKalendertageU();
                break;
            }
            case 1: {
                this.ermittleArbeitstageU();
                break;
            }
            case 2: {
                this.ermittleArbeitsstundenU();
            }
        }
        this.ermittleAGAErstattung();
    }

    private void ermittlungEntgelt_K() throws BusinessDomainException {
        this.initializeK();
        switch (this.artDerErstattungdberechnung.value()) {
            case 0: {
                this.ermittleKalendertageK();
                break;
            }
            case 1: {
                this.ermittleArbeitstageK();
                break;
            }
            case 2: {
                this.ermittleArbeitsstundenK();
            }
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.sollzeit)) {
            this.callib.result(BigDecimal.ZERO);
        } else {
            BigDecimal betragAlt;
            if (this.kuerzungDurchBbgRv) {
                this.svBbg = this.wplib.svTageLfd().compareTo(DREISSIG) != 0 ? (this.wplib.svTageLfd().compareTo(BigDecimal.ZERO) != 0 ? this.gllib.svBbgRvAv().multiply(this.wplib.svTageLfd()).divide(DREISSIG, 2, RoundingMode.UP) : BigDecimal.ZERO) : this.gllib.svBbgRvAv();
                if (this.callib.umlageEntgelt().compareTo(this.svBbg) > 0) {
                    this.callib.umlageEntgelt(this.svBbg);
                }
            }
            this.callib.result(this.callib.umlageEntgelt().multiply(this.istZeit).divide(this.sollzeit, 2, RoundingMode.HALF_UP));
            this.wplib.wertPosition().setPersistentBuffer4(this.wplib.wertPosition().getResult().multiply(this.istZeit).divide(this.sollzeit, 2, RoundingMode.HALF_UP));
            if (this.wplib.wertPosition().getValueType().getValueTypeKey() != 371215 && BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getPersistentBuffer5())) {
                this.wplib.wertPosition().setPersistentBuffer5(this.wplib.wertPosition().getResult());
            }
            if (BigDecimalMapper.compareTo((BigDecimal)(betragAlt = this.wplib.wertPosition().getSumOfResult()), (BigDecimal)this.callib.result()) != 0) {
                this.wplib.addNeueWertPosition(371610, BigDecimal.ZERO, BigDecimal.ZERO, this.istZeit, BigDecimal.ZERO, this.callib.result(), false, (PersistentObject)this.wplib.wertPosition());
                if (this.mUmlagekasseTP.getU1RefundSocialInsuranceER().value() != 0) {
                    this.wplib.addNeueWertPosition(371310, BigDecimal.ZERO, BigDecimal.ZERO, this.istZeit, BigDecimal.ZERO, this.callib.result(), false, (PersistentObject)this.wplib.wertPosition());
                }
            }
        }
    }

    private void ermittlungEntgelt_S() throws BusinessDomainException {
        this.initializeS();
        switch (this.artDerErstattungdberechnung.value()) {
            case 0: {
                this.ermittleKalendertageS();
                break;
            }
            case 1: {
                this.ermittleArbeitstageS();
                break;
            }
            case 2: {
                this.ermittleArbeitsstundenS();
            }
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.sollzeit)) {
            this.callib.result(BigDecimal.ZERO);
        } else {
            if (this.kuerzungDurchBbgRv) {
                this.svBbg = this.wplib.svTageLfd().compareTo(DREISSIG) != 0 ? (this.wplib.svTageLfd().compareTo(BigDecimal.ZERO) != 0 ? this.gllib.svBbgRvAv().multiply(this.wplib.svTageLfd()).divide(DREISSIG, 2, RoundingMode.UP) : BigDecimal.ZERO) : this.gllib.svBbgRvAv();
                if (this.callib.umlageEntgelt().compareTo(this.svBbg) > 0) {
                    this.callib.umlageEntgelt(this.svBbg);
                }
            }
            this.callib.result(this.callib.umlageEntgelt().multiply(this.istZeit).divide(this.sollzeit, 2, RoundingMode.HALF_UP));
            this.wplib.wertPosition().setPersistentBuffer4(this.wplib.wertPosition().getResult().multiply(this.istZeit).divide(this.sollzeit, 2, RoundingMode.HALF_UP));
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getPersistentBuffer5())) {
                this.wplib.wertPosition().setPersistentBuffer5(this.wplib.wertPosition().getResult());
            }
            this.wplib.addNeueWertPosition(371630, BigDecimal.ZERO, BigDecimal.ZERO, this.istZeit, BigDecimal.ZERO, this.callib.result().subtract(this.callib.umlageEntgelt()), false, (PersistentObject)this.wplib.wertPosition());
            if (this.mUmlagekasseTP.getU1RefundSocialInsuranceER().value() != 0) {
                this.wplib.addNeueWertPosition(371330, BigDecimal.ZERO, BigDecimal.ZERO, this.istZeit, BigDecimal.ZERO, this.callib.result().subtract(this.callib.umlageEntgelt()), false, (PersistentObject)this.wplib.wertPosition());
            }
        }
    }

    private void ermittlungEntgelt_U() throws BusinessDomainException {
        this.initializeU();
        switch (this.artDerErstattungdberechnung.value()) {
            case 0: {
                this.ermittleKalendertageU();
                break;
            }
            case 1: {
                this.ermittleArbeitstageU();
                break;
            }
            case 2: {
                this.ermittleArbeitsstundenU();
            }
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.sollzeit)) {
            this.callib.result(BigDecimal.ZERO);
        } else {
            if (this.kuerzungDurchBbgRv) {
                this.svBbg = this.wplib.svTageLfd().compareTo(DREISSIG) != 0 ? (this.wplib.svTageLfd().compareTo(BigDecimal.ZERO) != 0 ? this.gllib.svBbgRvAv().multiply(this.wplib.svTageLfd()).divide(DREISSIG, 2, RoundingMode.UP) : BigDecimal.ZERO) : this.gllib.svBbgRvAv();
                if (this.callib.umlageEntgelt().compareTo(this.svBbg) > 0) {
                    this.callib.umlageEntgelt(this.svBbg);
                }
            }
            this.callib.result(this.callib.umlageEntgelt().multiply(this.istZeit).divide(this.sollzeit, 2, RoundingMode.HALF_UP));
            this.wplib.wertPosition().setPersistentBuffer4(this.wplib.wertPosition().getResult().multiply(this.istZeit).divide(this.sollzeit, 2, RoundingMode.HALF_UP));
            if (this.wplib.wertPosition().getValueType().getValueTypeKey() != 371225 && BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.wertPosition().getPersistentBuffer5())) {
                this.wplib.wertPosition().setPersistentBuffer5(this.wplib.wertPosition().getResult());
            }
            this.wplib.addNeueWertPosition(371620, BigDecimal.ZERO, BigDecimal.ZERO, this.istZeit, BigDecimal.ZERO, this.callib.result(), false, (PersistentObject)this.wplib.wertPosition());
            if (this.mUmlagekasseTP.getU1RefundSocialInsuranceER().value() != 0) {
                this.wplib.addNeueWertPosition(371320, BigDecimal.ZERO, BigDecimal.ZERO, this.istZeit, BigDecimal.ZERO, this.callib.result(), false, (PersistentObject)this.wplib.wertPosition());
            }
        }
    }

    private void ermittlungErstattung_K() throws BusinessDomainException {
        this.initializeK();
        this.mGrundlage = this.wplib.parent().getResult();
        this.mUmlageErstattungsU1Prozentsatz = this.gllib.umlageErstattungU1(this.mUmlagekasse);
        for (ValuePosition vPos : this.wplib.parentUndFolgen(this.wplib.wertPosition())) {
            if (vPos.getValueType().getValueTypeKey() != 371310) continue;
            this.erstattungAGAnteil = vPos.getResult().subtract(vPos.getSumOfResult());
        }
        this.callib.result(this.mGrundlage.add(this.erstattungAGAnteil).multiply(this.mUmlageErstattungsU1Prozentsatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.callib.percentage(this.mUmlageErstattungsU1Prozentsatz);
    }

    private void ermittlungErstattung_S() throws BusinessDomainException {
        this.initializeS();
        this.mGrundlage = this.wplib.parent().getResult();
        this.mUmlageErstattungsU1Prozentsatz = this.gllib.umlageErstattungU1(this.mUmlagekasse);
        for (ValuePosition vPos : this.wplib.parentUndFolgen(this.wplib.wertPosition())) {
            if (vPos.getValueType().getValueTypeKey() != 371330) continue;
            this.erstattungAGAnteil = vPos.getResult().subtract(vPos.getSumOfResult());
        }
        this.callib.result(this.mGrundlage.add(this.erstattungAGAnteil).multiply(this.mUmlageErstattungsU1Prozentsatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.callib.percentage(this.mUmlageErstattungsU1Prozentsatz);
    }

    private void ermittlungErstattung_U() throws BusinessDomainException {
        this.initializeU();
        this.mGrundlage = this.wplib.parent().getResult();
        this.mUmlageErstattungsU1Prozentsatz = this.gllib.umlageErstattungU1(this.mUmlagekasse);
        for (ValuePosition vPos : this.wplib.parentUndFolgen(this.wplib.wertPosition())) {
            if (vPos.getValueType().getValueTypeKey() != 371320) continue;
            this.erstattungAGAnteil = vPos.getResult().subtract(vPos.getSumOfResult());
        }
        this.callib.result(this.mGrundlage.add(this.erstattungAGAnteil).multiply(this.mUmlageErstattungsU1Prozentsatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
        this.callib.percentage(this.mUmlageErstattungsU1Prozentsatz);
    }

    private BigDecimal getConcreteTargetDaysOfAbsence(Employee employee, Date effectiveTimePoint, Date from, Date until, EEAbsentTimeTP attp) throws BusinessDomainException {
        BigDecimal concreteTargetDaysOfAbsence;
        WorkingTime workingTime = employee.getAppurtenantWorkingTime(effectiveTimePoint, from);
        if (workingTime == null) {
            return BigDecimal.ZERO;
        }
        WorkingTimeTP wttp = workingTime.getWorkingTimeTP(this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb());
        Date begin = from;
        if (DateHelper.between((Date)attp.getValidFrom(), (Date)from, (Date)until)) {
            begin = attp.getValidFrom();
        }
        Date end = until;
        if (DateHelper.between((Date)attp.getValidUntil(), (Date)from, (Date)until)) {
            end = attp.getValidUntil();
        }
        if (BigDecimalMapper.compareTo((BigDecimal)(concreteTargetDaysOfAbsence = workingTime.getConcreteTargetDays(begin, end, employee, effectiveTimePoint, from, wttp.getPaidPublicHoliday())), (BigDecimal)BigDecimal.ONE) == 0 && attp.getHalfLeaveDay()) {
            concreteTargetDaysOfAbsence = concreteTargetDaysOfAbsence.setScale(2);
            return concreteTargetDaysOfAbsence.divide(BigDecimal.valueOf(2L), RoundingMode.HALF_DOWN).setScale(2);
        }
        return concreteTargetDaysOfAbsence;
    }

    private BigDecimal getConcreteTargetHoursOfAbsence(Employee employee, Date effectiveTimePoint, Date from, Date until, EEAbsentTimeTP attp) throws BusinessDomainException {
        WorkingTime workingTime = employee.getAppurtenantWorkingTime(effectiveTimePoint, from);
        if (workingTime == null) {
            return BigDecimal.ZERO;
        }
        WorkingTimeTP wttp = workingTime.getWorkingTimeTP(this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb());
        int countOfDays = DateHelper.compareDate((Date)until, (Date)from) + 1;
        Date begin = from;
        if (DateHelper.between((Date)attp.getValidFrom(), (Date)from, (Date)until)) {
            begin = attp.getValidFrom();
        }
        Date end = until;
        if (DateHelper.between((Date)attp.getValidUntil(), (Date)from, (Date)until)) {
            end = attp.getValidUntil();
        }
        BigDecimal hourOfAbsence = workingTime.getConcreteTargetHours(begin, end, employee, effectiveTimePoint, from, wttp.getPaidPublicHoliday());
        if (countOfDays == 1 && !BigDecimalMapper.isZeroOrNull((BigDecimal)attp.getNumberOfHours())) {
            hourOfAbsence = attp.getNumberOfHours().setScale(2);
        }
        return hourOfAbsence;
    }

    private void initializeK() throws BusinessDomainException {
        this.mUmlagekasse = this.eelib.marbUmlagekasse();
        if (this.mUmlagekasse == null) {
            this.mUmlagekasse = this.gllib.umlageKasseFirma();
        }
        if (this.mUmlagekasse == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentHealthFundFoundDomainException(this.callib.berchnungGueltigAb());
        }
        this.artDerErstattungdberechnung = this.eelib.marbUmlageErstattungsberechnung();
        this.mUmlagekasseTP = this.mUmlagekasse.getHealthFundTP(this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb());
        this.kuerzungDurchBbgRv = this.mUmlagekasseTP.getU1Limitation();
        this.erstattungAGA = this.mUmlagekasseTP.getU1RefundSocialInsuranceER();
        this.pauschalAGAVHSatz = this.mUmlagekasseTP.getU1RefundPercentageFact();
    }

    private void initializeS() throws BusinessDomainException {
        this.mUmlagekasse = this.eelib.marbUmlagekasse();
        if (this.mUmlagekasse == null) {
            this.mUmlagekasse = this.gllib.umlageKasseFirma();
        }
        if (this.mUmlagekasse == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentHealthFundFoundDomainException(this.callib.berchnungGueltigAb());
        }
        this.artDerErstattungdberechnung = this.eelib.marbUmlageErstattungsberechnung();
        this.mUmlagekasseTP = this.mUmlagekasse.getHealthFundTP(this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb());
        this.kuerzungDurchBbgRv = this.mUmlagekasseTP.getU1Limitation();
        this.erstattungAGA = this.mUmlagekasseTP.getU1RefundSocialInsuranceER();
        this.pauschalAGAVHSatz = this.mUmlagekasseTP.getU1RefundPercentageFact();
    }

    private void initializeU() throws BusinessDomainException {
        this.mUmlagekasse = this.eelib.marbUmlagekasse();
        if (this.mUmlagekasse == null) {
            this.mUmlagekasse = this.gllib.umlageKasseFirma();
        }
        if (this.mUmlagekasse == null) {
            throw EvaluationExceptionMapper.makeNoAssessmentHealthFundFoundDomainException(this.callib.berchnungGueltigAb());
        }
        this.artDerErstattungdberechnung = this.eelib.marbUmlageErstattungsberechnung();
        this.mUmlagekasseTP = this.mUmlagekasse.getHealthFundTP(this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb());
        this.kuerzungDurchBbgRv = this.mUmlagekasseTP.getU1Limitation();
        this.erstattungAGA = this.mUmlagekasseTP.getU1RefundSocialInsuranceER();
        this.pauschalAGAVHSatz = this.mUmlagekasseTP.getU1RefundPercentageFact();
    }

    private SVAGAValues pauschalerZuschlag() {
        BigDecimal svAGA = this.mGrundlage.multiply(this.pauschalAGAVHSatz).divide(EINHUNDERT, 2, RoundingMode.UP);
        return new SVAGAValues(svAGA, this.pauschalAGAVHSatz);
    }

    private boolean vollerBeitragssatzAV() throws BusinessDomainException {
        boolean result = false;
        ValuePosition[] vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), ValueTypeHelper.getValueTypes(335520));
        if (vpArray.length != 0) {
            result = true;
        }
        return result;
    }

    private boolean vollerBeitragssatzKV() throws BusinessDomainException {
        ValuePosition[] vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), ValueTypeHelper.getValueTypes(323520, 323620));
        boolean result = false;
        if (vpArray.length != 0) {
            result = true;
        }
        return result;
    }

    private boolean vollerBeitragssatzRV() throws BusinessDomainException {
        boolean result = false;
        ValuePosition[] vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), ValueTypeHelper.getValueTypes(329520));
        if (vpArray.length != 0) {
            result = true;
        }
        return result;
    }

    private boolean vollerBeitragssatzPV() throws BusinessDomainException {
        boolean result = false;
        ValuePosition[] vpArray = this.wplib.wpAusWPListeBisUebergebeneWP(this.callib.berchnungWirksamAb(), this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), this.wplib.wertPosition(), ValueTypeHelper.getValueTypes(341520));
        if (vpArray.length != 0) {
            result = true;
        }
        return result;
    }

    private class SVAGAValues {
        private final BigDecimal svAga;
        private final BigDecimal percentage;

        private SVAGAValues(BigDecimal svAga, BigDecimal percentage) {
            this.svAga = svAga;
            this.percentage = percentage;
        }
    }
}

