/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.libraryimpl.CalculationCheckImpl;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;

public class ErmittlungSVEntgeltLfdFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private final ValuePositionLibrary wplib;
    private CalculationCheckImpl cci;
    private BigDecimal gesamtesBruttoLfd = BigDecimal.ZERO;
    private BigDecimal svEntgeltLfd = BigDecimal.ZERO;
    private ValuePosition[] vpArray;
    private BigDecimal tempSVEntgelt = BigDecimal.ZERO;
    private boolean bemessungsgrundlagenAngelegt = false;
    private boolean mIsLKK = false;
    private boolean mIs100AG = false;

    public ErmittlungSVEntgeltLfdFormula(CalculationLibrary callib, EmployeeLibrary eelib, GlobalLibrary gllib, ValuePositionLibrary wplib) {
        this.callib = callib;
        this.eelib = eelib;
        this.gllib = gllib;
        this.wplib = wplib;
    }

    public void steuereSVEntgeltLfd() throws BusinessDomainException {
        this.cci = new CalculationCheckImpl(this.callib, this.eelib, this.gllib, this.wplib);
        this.vorabCheck();
        this.svEntgeltLfd = this.wplib.result();
        if (this.wplib.wertartenNummer() == 130540) {
            this.mIs100AG = true;
        }
        if (this.svEntgeltLfd.compareTo(BigDecimal.ZERO) < 0 && this.wplib.genesisParent().getGenesisOfParentObjects() instanceof EEPensionSchemeTP) {
            BigDecimal steuerpflichtigLFD = BigDecimal.ZERO;
            for (ValuePosition lElement : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(130510))) {
                this.tempSVEntgelt = this.tempSVEntgelt.add(lElement.getResult());
            }
            if (this.tempSVEntgelt.compareTo(BigDecimal.ZERO) < 0) {
                for (ValuePosition lElement : this.vpArray = this.wplib.genesisUndFolgen()) {
                    int vtKey = lElement.getValueType().getValueTypeKey();
                    switch (vtKey) {
                        case 110510: {
                            steuerpflichtigLFD = steuerpflichtigLFD.add(lElement.getResult());
                        }
                    }
                    if (!(vtKey >= 100000 && vtKey < 145000 || vtKey >= 149000 && vtKey < 860000) && vtKey <= 863166) continue;
                    lElement.setResult(BigDecimal.ZERO);
                    lElement.makeReadOnly();
                }
                this.svEntgeltLfd = BigDecimal.ZERO;
                this.wplib.wertPosition().makeReadOnly();
                if (!BigDecimalMapper.isZero((BigDecimal)steuerpflichtigLFD)) {
                    for (ValuePosition lElement : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(99997))) {
                        ValuePosition[] tempVPArray;
                        block11: for (ValuePosition tempVP : tempVPArray = this.wplib.genesisUndFolgen(lElement)) {
                            switch (tempVP.getValueType().getValueTypeKey()) {
                                case 99997: {
                                    tempVP.setResult(tempVP.getResult().add(steuerpflichtigLFD));
                                    continue block11;
                                }
                                case 110510: {
                                    tempVP.setResult(tempVP.getResult().add(steuerpflichtigLFD));
                                    continue block11;
                                }
                                case 110540: {
                                    tempVP.setResult(tempVP.getResult().subtract(steuerpflichtigLFD));
                                }
                            }
                        }
                    }
                }
            }
        }
        this.callib.result(this.svEntgeltLfd);
        this.gesamtesBruttoLfd = this.gesamtesSVEntgeltLfdImMonat();
        if (this.callib.getCalculationCase().getTypeOfCalculationCase() != TypeOfCalculationCase.FiktiveBeitragsermittlung) {
            this.checkLfdEntgeltAusserhalbLFZ();
        }
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate()) && (this.eelib.marbBgrKv() != 0 && this.eelib.marbBgrKv() != 6 || this.eelib.marbBgrRv() != 0 && this.eelib.marbBgrRv() != 5 || this.eelib.marbBgrAv() != 0 || this.eelib.marbBgrPv() != 0)) {
            this.wplib.addNeueWertPosition(130590, this.wplib.svTageLfd());
        }
        if (this.eelib.isBehinderterMA()) {
            this.erzeugeMindesbemessungsgrundlagenFuerDieBehindertenabrechnung();
        } else if (this.eelib.marbPgs() == 102 && BigDecimalMapper.isZeroOrNull((BigDecimal)this.wplib.result()) && this.eelib.marbBgrKv() == 0 && this.eelib.marbBgrRv() == 1 && this.eelib.marbBgrAv() == 1 && this.eelib.marbBgrPv() == 0) {
            BigDecimal bezugsgroesse = this.gllib.marbRechtskreis() == 'O' ? this.gllib.bezugsgroesseRVAVBehinderteOst() : this.gllib.bezugsgroesseRVAVBehinderteWest();
            this.svEntgeltLfd = bezugsgroesse.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
            this.erzeugeRVEntgeltFiktiv();
            this.erzeugeAVEntgeltFiktiv();
        } else {
            this.mIsLKK = this.eelib.isMarbKrkLKK();
            this.erzeugeKVEntgelt();
            this.erzeugeRVEntgelt();
            this.erzeugeAVEntgelt();
            if (this.eelib.marbPgs() != 112) {
                this.erzeugePVEntgelt();
            }
        }
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate())) {
            this.erzeugeInsGEntgelt();
        } else {
            new CalculationBasic(this.eelib.marb(), this.callib.berchnungWirksamAb(), new VDate(2009, 0, 1).getDate(), this.getClass().getName());
        }
        if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate()) && this.eelib.taxacation() == 5) {
            if (this.eelib.ueberwaelzungLstAN() && !this.wplib.aus37b()) {
                this.wplib.addNeueWertPosition(new int[]{101680, 736800}, this.svEntgeltLfd);
            } else {
                this.wplib.addNeueWertPosition(new int[]{101680, 736300}, this.svEntgeltLfd);
            }
        }
    }

    protected void checkLfdEntgeltAusserhalbLFZ() throws BusinessDomainException {
        if (DateHelper.between((Date)this.wplib.gueltigAb(), (Date)this.callib.berchnungGueltigAb(), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            if (this.wplib.svTageLfd().compareTo(BigDecimal.ZERO) == 0 && this.gesamtesBruttoLfd.compareTo(BigDecimal.ZERO) > 0) {
                for (ValuePosition lElement : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(130510, 130560))) {
                    ValuePosition[] vpArrayOfFiktivEntgeltInsolvenz;
                    int valueTypeKey;
                    ValuePosition genesisVP;
                    PersistentObject genesis;
                    if (lElement.getResult().compareTo(BigDecimal.ZERO) <= 0 || (genesis = (genesisVP = (ValuePosition)lElement.getGenesisOfParentObjects()).getGenesisOfParentObjects()) instanceof EEPensionSchemeTP || (valueTypeKey = genesisVP.getValueType().getValueTypeKey()) == 99980 || valueTypeKey == 99983 || valueTypeKey == 99990 || (vpArrayOfFiktivEntgeltInsolvenz = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(130530))).length != 0) continue;
                    throw EvaluationExceptionMapper.makePermanentPaymentInNonContributoryTimeDomainException(this.wplib.gueltigAb(), ((ValuePosition)lElement.getGenesisOfParentObjects()).getValueType().getValueTypeKey());
                }
            }
        } else {
            new CalculationBasic(this.eelib.marb(), this.callib.berchnungWirksamAb(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), "ErmittlungSVEntgeltLfd");
        }
    }

    private void vorabCheck() throws BusinessDomainException {
        this.pruefeaufBruchteilevonCent();
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2007, 0, 1).getDate())) {
            this.checkMehrfachbeschaeftigung();
        }
    }

    protected void checkMehrfachbeschaeftigung() throws BusinessDomainException {
        if (DateHelper.equal((Date)DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), (Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb())) && DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2015, 0, 1).getDate()) && DateHelper.beforeOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)this.callib.berchnungGueltigAb()), (Date)DateHelper.tomorrow((Date)this.eelib.marbJournalisiertBis()))) {
            this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(129200, 129205, 129215, 129210));
            if (this.vpArray.length > 0 && !this.eelib.isMehrfachbeschaeftigt()) {
                throw EvaluationExceptionMapper.makeNoMultipleEmploymentForCalculateOfValuePositionDomainException(this.callib.berchnungGueltigAb(), ((ValuePosition)this.vpArray[0].getGenesisOfParentObjects()).getValueType().getValueTypeKey());
            }
        }
    }

    private void pruefeaufBruchteilevonCent() throws BusinessDomainException {
        BigInteger tempBigI;
        BigDecimal tempBigD;
        if (DateHelper.afterOrEqual((Date)this.wplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) && (tempBigD = new BigDecimal(tempBigI = this.wplib.result().movePointRight(2).toBigInteger()).movePointLeft(2)).compareTo(this.wplib.result()) != 0) {
            this.gllib.erzeugeWiedervorlageBruchteileVonCent(this.wplib.genesisParent().getValueType().getValueTypeKey());
        }
    }

    private void erzeugeInsGEntgelt() throws BusinessDomainException {
        if (this.gllib.isInsGPflBetrieb()) {
            if (this.eelib.isMarbGleitzoneAllgemein() && !this.callib.dbbgVorhanden() || this.callib.dbgzVorhanden() && (this.callib.dbgzKennzGLZ().value() == 1 || this.callib.dbgzKennzGLZ().value() == 3)) {
                if (this.eelib.isMarbInsGPflichtig()) {
                    if (this.mIs100AG && DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2021, 0, 1).getDate())) {
                        this.wplib.addNeueWertPosition(365511, this.svEntgeltLfd);
                    } else {
                        if (this.cci.checkGleitzoneInsG()) {
                            if (!this.eelib.marbVerzichtRvReduzierung()) {
                                this.wplib.addNeueWertPosition(365514, this.svEntgeltLfd);
                            } else {
                                this.wplib.addNeueWertPosition(365510, this.svEntgeltLfd);
                            }
                            return;
                        }
                        this.wplib.addNeueWertPosition(365510, this.svEntgeltLfd);
                    }
                }
            } else if (this.eelib.isMarbInsGPflichtig()) {
                if (this.mIs100AG && DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2021, 0, 1).getDate())) {
                    this.wplib.addNeueWertPosition(365511, this.svEntgeltLfd);
                } else {
                    this.wplib.addNeueWertPosition(365510, this.svEntgeltLfd);
                }
            }
        }
    }

    private void erzeugePVEntgelt() throws BusinessDomainException {
        if ((this.eelib.isMarbGleitzoneAllgemein() && !this.callib.dbbgVorhanden() || this.callib.dbgzVorhanden() && (this.callib.dbgzKennzGLZ().value() == 1 || this.callib.dbgzKennzGLZ().value() == 3)) && this.cci.checkGleitzonePV()) {
            switch (this.eelib.marbBgrPv()) {
                case 1: 
                case 2: {
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(339740, this.svEntgeltLfd);
                    } else {
                        this.wplib.addNeueWertPosition(339514, this.svEntgeltLfd);
                    }
                    return;
                }
            }
        }
        block3 : switch (this.eelib.marbBgrPv()) {
            case 1: 
            case 2: {
                switch (this.eelib.marbBklFPv().value()) {
                    case 0: {
                        if (this.mIs100AG) {
                            this.wplib.addNeueWertPosition(339740, this.svEntgeltLfd);
                        } else {
                            this.wplib.addNeueWertPosition(339510, this.svEntgeltLfd);
                        }
                        if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                            this.wplib.addNeueWertPosition(130590, this.wplib.svTageLfd());
                        }
                        this.callib.result1(this.wplib.svTageLfd());
                        break block3;
                    }
                }
                if (this.mIs100AG) {
                    this.wplib.addNeueWertPosition(771050, this.svEntgeltLfd);
                    this.wplib.addNeueWertPosition(771100, this.svEntgeltLfd);
                } else {
                    this.wplib.addNeueWertPosition(771020, this.svEntgeltLfd);
                    this.wplib.addNeueWertPosition(771090, this.svEntgeltLfd);
                }
                this.callib.result1(BigDecimal.ZERO);
                break;
            }
            default: {
                if (this.mIsLKK) {
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(771050, this.svEntgeltLfd);
                        this.wplib.addNeueWertPosition(771100, this.svEntgeltLfd);
                    } else {
                        this.wplib.addNeueWertPosition(771020, this.svEntgeltLfd);
                        this.wplib.addNeueWertPosition(771090, this.svEntgeltLfd);
                    }
                    this.callib.result1(BigDecimal.ZERO);
                    break;
                }
                if (this.eelib.marbPPVv()) {
                    if (this.eelib.marbAGZPPv() == 9) break;
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(771150, this.svEntgeltLfd);
                        break;
                    }
                    this.wplib.addNeueWertPosition(771120, this.svEntgeltLfd);
                    break;
                }
                if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2007, 3, 1).getDate())) break;
                switch (this.eelib.marbBesonderesSvMerkmal().value()) {
                    case 5: {
                        if (this.mIs100AG) {
                            this.wplib.addNeueWertPosition(771050, this.svEntgeltLfd);
                            this.wplib.addNeueWertPosition(771100, this.svEntgeltLfd);
                        } else {
                            this.wplib.addNeueWertPosition(771020, this.svEntgeltLfd);
                            this.wplib.addNeueWertPosition(771090, this.svEntgeltLfd);
                        }
                        this.callib.result1(this.wplib.svTageLfd());
                        break block3;
                    }
                }
            }
        }
    }

    private void erzeugeAVEntgelt() throws BusinessDomainException {
        if ((this.eelib.isMarbGleitzoneAllgemein() && !this.callib.dbbgVorhanden() || this.callib.dbgzVorhanden() && (this.callib.dbgzKennzGLZ().value() == 1 || this.callib.dbgzKennzGLZ().value() == 4)) && this.cci.checkGleitzoneAV()) {
            switch (this.eelib.marbBgrAv()) {
                case 1: {
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(333540, this.svEntgeltLfd);
                    } else {
                        this.wplib.addNeueWertPosition(333514, this.svEntgeltLfd);
                    }
                    return;
                }
                case 2: {
                    if (!this.eelib.marbAVBefreiungAG()) {
                        if (this.mIs100AG) {
                            this.wplib.addNeueWertPosition(333540, this.svEntgeltLfd);
                        } else {
                            this.wplib.addNeueWertPosition(333514, this.svEntgeltLfd);
                        }
                    }
                    return;
                }
            }
        }
        switch (this.eelib.marbBgrAv()) {
            case 1: 
            case 2: {
                if (this.mIs100AG) {
                    this.wplib.addNeueWertPosition(333540, this.svEntgeltLfd);
                } else {
                    this.wplib.addNeueWertPosition(333510, this.svEntgeltLfd);
                }
                this.callib.result1(this.wplib.svTageLfd());
                break;
            }
        }
    }

    private void erzeugeAVEntgeltFiktiv() throws BusinessDomainException {
        this.wplib.addNeueWertPosition(333510, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltLfd, false);
    }

    private void erzeugeRVEntgelt() throws BusinessDomainException {
        if ((this.eelib.isMarbGleitzoneAllgemein() && !this.eelib.marbVerzichtRvReduzierung() && !this.callib.dbbgVorhanden() || this.callib.dbgzVorhanden() && (this.callib.dbgzKennzGLZ().value() == 1 || this.callib.dbgzKennzGLZ().value() == 3)) && this.cci.checkGleitzoneRV() && !this.eelib.kennzBestandGleitzone2022()) {
            switch (this.eelib.marbBgrRv()) {
                case 1: 
                case 2: {
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(327740, this.svEntgeltLfd);
                    } else if (!this.eelib.marbVerzichtRvReduzierung()) {
                        this.wplib.addNeueWertPosition(327514, this.svEntgeltLfd);
                    } else {
                        this.wplib.addNeueWertPosition(327510, this.svEntgeltLfd);
                    }
                    return;
                }
                case 3: {
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(327740, this.svEntgeltLfd);
                    } else {
                        this.wplib.addNeueWertPosition(327514, this.svEntgeltLfd);
                    }
                    return;
                }
                case 0: {
                    if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate()) || this.eelib.marbVersorgungsart().value() == 0) break;
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(327740, this.svEntgeltLfd);
                        break;
                    }
                    if (!this.eelib.marbVerzichtRvReduzierung()) {
                        this.wplib.addNeueWertPosition(327514, this.svEntgeltLfd);
                        return;
                    }
                    this.wplib.addNeueWertPosition(327510, this.svEntgeltLfd);
                    return;
                }
            }
        }
        switch (this.eelib.marbBgrRv()) {
            case 0: {
                if (this.eelib.marbVersorgungsart().value() == 0) break;
                if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                    this.wplib.addNeueWertPosition(772110, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltLfd, true);
                    break;
                }
                if (this.eelib.marbPgs() != 109) {
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(327740, this.svEntgeltLfd);
                        break;
                    }
                    this.wplib.addNeueWertPosition(327510, this.svEntgeltLfd);
                    break;
                }
                if (this.mIs100AG) {
                    this.wplib.addNeueWertPosition(327740, this.svEntgeltLfd);
                    break;
                }
                this.wplib.addNeueWertPosition(327512, this.svEntgeltLfd);
                break;
            }
            case 1: 
            case 2: {
                if (this.eelib.marbPgs() != 109 && !this.eelib.kennzBestandGleitzone2022()) {
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(327740, this.svEntgeltLfd);
                    } else {
                        this.wplib.addNeueWertPosition(327510, this.svEntgeltLfd);
                    }
                } else if (this.mIs100AG) {
                    this.wplib.addNeueWertPosition(327740, this.svEntgeltLfd);
                } else {
                    this.wplib.addNeueWertPosition(327512, this.svEntgeltLfd);
                }
                this.callib.factor1(this.wplib.svTageLfd());
                break;
            }
            case 3: 
            case 4: {
                if (this.wplib.svTageLfd().compareTo(DREISSIG) != 0) {
                    if (this.wplib.svTageLfd().compareTo(BigDecimal.ZERO) != 0) {
                        if (this.mIs100AG) {
                            this.wplib.addNeueWertPosition(327740, this.svEntgeltLfd);
                        } else {
                            this.wplib.addNeueWertPosition(327510, this.svEntgeltLfd);
                        }
                    }
                } else if (this.mIs100AG) {
                    this.wplib.addNeueWertPosition(327740, this.svEntgeltLfd);
                } else {
                    this.wplib.addNeueWertPosition(327510, this.svEntgeltLfd);
                }
                this.callib.factor1(this.wplib.svTageLfd());
                break;
            }
            case 5: 
            case 6: {
                if (this.mIs100AG) {
                    this.wplib.addNeueWertPosition(327740, this.svEntgeltLfd);
                } else {
                    this.wplib.addNeueWertPosition(327512, this.svEntgeltLfd);
                }
                this.callib.result1(BigDecimal.ZERO);
                break;
            }
        }
    }

    private void erzeugeRVEntgeltFiktiv() throws BusinessDomainException {
        this.wplib.addNeueWertPosition(327510, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltLfd, false);
    }

    private void erzeugeKVEntgelt() throws BusinessDomainException {
        if ((this.eelib.isMarbGleitzoneAllgemein() && !this.callib.dbbgVorhanden() || this.callib.dbgzVorhanden() && (this.callib.dbgzKennzGLZ().value() == 1 || this.callib.dbgzKennzGLZ().value() == 3)) && this.cci.checkGleitzoneKV()) {
            switch (this.eelib.marbBgrKv()) {
                case 1: 
                case 2: 
                case 3: {
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(321740, this.svEntgeltLfd);
                    } else {
                        this.wplib.addNeueWertPosition(321514, this.svEntgeltLfd);
                    }
                    return;
                }
            }
        }
        block3 : switch (this.eelib.marbBgrKv()) {
            case 0: {
                if (this.mIsLKK) {
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(770050, this.svEntgeltLfd);
                        this.wplib.addNeueWertPosition(770100, this.svEntgeltLfd);
                    } else {
                        this.wplib.addNeueWertPosition(770020, this.svEntgeltLfd);
                        this.wplib.addNeueWertPosition(770090, this.svEntgeltLfd);
                    }
                    this.callib.result1(BigDecimal.ZERO);
                    break;
                }
                switch (this.eelib.marbBklFKv().value()) {
                    case 0: {
                        break;
                    }
                    default: {
                        if (!this.eelib.marbPKv()) {
                            if (this.mIs100AG) {
                                this.wplib.addNeueWertPosition(770050, this.svEntgeltLfd);
                                this.wplib.addNeueWertPosition(770100, this.svEntgeltLfd);
                            } else {
                                this.wplib.addNeueWertPosition(770020, this.svEntgeltLfd);
                                this.wplib.addNeueWertPosition(770090, this.svEntgeltLfd);
                            }
                        }
                        this.callib.result1(BigDecimal.ZERO);
                    }
                }
                if (!this.eelib.marbPKv()) break;
                if (this.eelib.marbAGZPKv() != 9) {
                    if (this.mIs100AG) {
                        this.wplib.addNeueWertPosition(770150, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltLfd, true);
                    } else {
                        this.wplib.addNeueWertPosition(770120, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltLfd, true);
                    }
                }
                this.callib.result1(BigDecimal.ZERO);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                if (this.mIs100AG) {
                    this.wplib.addNeueWertPosition(321740, this.svEntgeltLfd);
                } else {
                    this.wplib.addNeueWertPosition(321510, this.svEntgeltLfd);
                }
                this.callib.result1(this.wplib.svTageLfd());
                break;
            }
            case 6: {
                if (this.mIs100AG) {
                    this.wplib.addNeueWertPosition(321740, this.svEntgeltLfd);
                } else {
                    this.wplib.addNeueWertPosition(321512, this.svEntgeltLfd);
                }
                this.callib.result1(BigDecimal.ZERO);
                break;
            }
            default: {
                switch (this.eelib.marbBklFKv().value()) {
                    case 0: {
                        break block3;
                    }
                }
                if (this.mIs100AG) {
                    this.wplib.addNeueWertPosition(770050, this.svEntgeltLfd);
                    this.wplib.addNeueWertPosition(770100, this.svEntgeltLfd);
                } else {
                    this.wplib.addNeueWertPosition(770020, this.svEntgeltLfd);
                    this.wplib.addNeueWertPosition(770090, this.svEntgeltLfd);
                }
                this.callib.result1(BigDecimal.ZERO);
            }
        }
    }

    private void erzeugeMindesbemessungsgrundlagenFuerDieBehindertenabrechnung() throws BusinessDomainException {
        BigDecimal prozentsatzRV;
        BigDecimal prozentsatzAV;
        BigDecimal prozentsatzKVPV;
        ValuePosition[] vpArray;
        BigDecimal svEntgelt = BigDecimal.ZERO;
        BigDecimal svEntLfd = BigDecimal.ZERO;
        BigDecimal svEntEGA = BigDecimal.ZERO;
        block29: for (ValuePosition lElement : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(130570, 130575, 130580, 130585, 130610, 130620, 130510))) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 130510: {
                    svEntLfd = svEntLfd.add(lElement.getResult());
                    continue block29;
                }
                case 130610: 
                case 130620: {
                    svEntEGA = svEntEGA.add(lElement.getResult());
                    continue block29;
                }
                case 130570: 
                case 130575: 
                case 130580: 
                case 130585: {
                    this.bemessungsgrundlagenAngelegt = true;
                }
            }
        }
        svEntgelt = svEntLfd.add(svEntEGA);
        int pgs = this.eelib.marbPgs();
        BigDecimal svTage = this.getSVTageUnterBeruecksichtigungFehlzeiten(pgs);
        BigDecimal mindestbemessungsgrundlageKVPVWest = this.gllib.mindestBemessGrundKVPVBehinderteWest().multiply(svTage).divide(BigDecimal.valueOf(30L), RoundingMode.HALF_UP);
        BigDecimal mindestbemessungsgrundlageRVWest = this.gllib.mindestBemessGrundRVBehinderteWest().multiply(svTage).divide(BigDecimal.valueOf(30L), RoundingMode.HALF_UP);
        BigDecimal mindestbemessungsgrundlageRVOst = this.gllib.mindestBemessGrundRVBehinderteOst().multiply(svTage).divide(BigDecimal.valueOf(30L), RoundingMode.HALF_UP);
        BigDecimal beitragsbemessungsgrundlageKVPVWest = this.gllib.mindestBemessGrundKVPVBehinderteREHAWest().multiply(svTage).divide(BigDecimal.valueOf(30L), RoundingMode.HALF_UP);
        BigDecimal beitragsbemessungsgrundlageRVWest = this.gllib.mindestBemessGrundRVAVBehinderteREHAWest().multiply(svTage).divide(BigDecimal.valueOf(30L), RoundingMode.HALF_UP);
        BigDecimal beitragsbemessungsgrundlageRVOst = this.gllib.mindestBemessGrundRVAVBehinderteREHAOst().multiply(svTage).divide(BigDecimal.valueOf(30L), RoundingMode.HALF_UP);
        if (pgs == 127) {
            prozentsatzKVPV = BigDecimal.valueOf(50L);
            prozentsatzAV = BigDecimal.valueOf(50L);
            prozentsatzRV = BigDecimal.valueOf(50L);
        } else if (pgs == 111) {
            prozentsatzKVPV = svEntLfd.compareTo(beitragsbemessungsgrundlageKVPVWest) <= 0 ? BigDecimal.valueOf(100L) : BigDecimal.valueOf(50L);
            if (this.gllib.marbRechtskreis() == 'O') {
                if (svEntLfd.compareTo(beitragsbemessungsgrundlageRVOst) <= 0) {
                    prozentsatzRV = BigDecimal.valueOf(100L);
                    prozentsatzAV = BigDecimal.valueOf(100L);
                } else {
                    prozentsatzRV = BigDecimal.valueOf(50L);
                    prozentsatzAV = BigDecimal.valueOf(50L);
                }
            } else if (svEntLfd.compareTo(beitragsbemessungsgrundlageRVWest) <= 0) {
                prozentsatzRV = BigDecimal.valueOf(100L);
                prozentsatzAV = BigDecimal.valueOf(100L);
            } else {
                prozentsatzRV = BigDecimal.valueOf(50L);
                prozentsatzAV = BigDecimal.valueOf(50L);
            }
        } else {
            prozentsatzKVPV = svEntLfd.compareTo(beitragsbemessungsgrundlageKVPVWest) <= 0 ? BigDecimal.valueOf(100L) : BigDecimal.valueOf(50L);
            if (this.gllib.marbRechtskreis() == 'O') {
                if (svEntLfd.compareTo(beitragsbemessungsgrundlageRVOst) <= 0) {
                    prozentsatzRV = BigDecimal.valueOf(100L);
                    prozentsatzAV = BigDecimal.valueOf(100L);
                } else {
                    prozentsatzRV = BigDecimal.valueOf(50L);
                    prozentsatzAV = BigDecimal.valueOf(50L);
                }
            } else if (svEntLfd.compareTo(beitragsbemessungsgrundlageRVWest) <= 0) {
                prozentsatzRV = BigDecimal.valueOf(100L);
                prozentsatzAV = BigDecimal.valueOf(100L);
            } else {
                prozentsatzRV = BigDecimal.valueOf(50L);
                prozentsatzAV = BigDecimal.valueOf(50L);
            }
        }
        switch (this.eelib.marbBgrKv()) {
            case 1: 
            case 2: 
            case 3: {
                this.wplib.addNeueWertPosition(321510, prozentsatzKVPV, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltLfd, false);
                this.callib.result1(this.wplib.svTageLfd());
            }
        }
        switch (this.eelib.marbBgrRv()) {
            case 1: 
            case 2: {
                this.wplib.addNeueWertPosition(327510, prozentsatzRV, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltLfd, false);
                this.callib.factor1(this.wplib.svTageLfd());
            }
        }
        switch (this.eelib.marbBgrAv()) {
            case 1: {
                this.wplib.addNeueWertPosition(333510, prozentsatzAV, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltLfd, false);
                this.callib.result1(this.wplib.svTageLfd());
                break;
            }
        }
        switch (this.eelib.marbBgrPv()) {
            case 1: 
            case 2: {
                this.wplib.addNeueWertPosition(339510, prozentsatzKVPV, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.svEntgeltLfd, false);
                this.callib.result1(this.wplib.svTageLfd());
            }
        }
        if (!this.bemessungsgrundlagenAngelegt) {
            switch (this.eelib.marbBgrRv()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (this.eelib.marbPgs() != 111) {
                        if (this.gllib.marbRechtskreis() == 'O') {
                            this.wplib.addNeueWertPosition(130575, mindestbemessungsgrundlageRVOst);
                            if (svEntgelt.compareTo(mindestbemessungsgrundlageRVOst) >= 0) break;
                            this.wplib.addNeueWertPosition(327700, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, mindestbemessungsgrundlageRVOst.subtract(svEntgelt), false);
                            break;
                        }
                        this.wplib.addNeueWertPosition(130575, mindestbemessungsgrundlageRVWest);
                        if (svEntgelt.compareTo(mindestbemessungsgrundlageRVWest) >= 0) break;
                        this.wplib.addNeueWertPosition(327700, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, mindestbemessungsgrundlageRVWest.subtract(svEntgelt), false);
                        break;
                    }
                    if (this.gllib.marbRechtskreis() == 'O') {
                        this.wplib.addNeueWertPosition(130575, beitragsbemessungsgrundlageRVOst);
                        if (svEntgelt.compareTo(beitragsbemessungsgrundlageRVOst) >= 0) break;
                        this.wplib.addNeueWertPosition(327700, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitragsbemessungsgrundlageRVOst.subtract(svEntgelt), false);
                        break;
                    }
                    this.wplib.addNeueWertPosition(130575, beitragsbemessungsgrundlageRVWest);
                    if (svEntgelt.compareTo(beitragsbemessungsgrundlageRVWest) >= 0) break;
                    this.wplib.addNeueWertPosition(327700, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitragsbemessungsgrundlageRVWest.subtract(svEntgelt), false);
                    break;
                }
            }
            if (pgs != 127) {
                switch (this.eelib.marbBgrKv()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.wplib.addNeueWertPosition(130570, mindestbemessungsgrundlageKVPVWest);
                        if (this.gllib.marbRechtskreis() == 'O') {
                            this.wplib.addNeueWertPosition(130571, beitragsbemessungsgrundlageRVOst);
                        }
                        if (svEntgelt.compareTo(mindestbemessungsgrundlageKVPVWest) >= 0) break;
                        this.wplib.addNeueWertPosition(321700, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, mindestbemessungsgrundlageKVPVWest.subtract(svEntgelt), false);
                        break;
                    }
                }
                switch (this.eelib.marbBgrAv()) {
                    case 1: {
                        if (this.eelib.marbPgs() == 111 && this.eelib.marbBesonderesSvMerkmal().value() == 7) {
                            this.wplib.addNeueWertPosition(130580, beitragsbemessungsgrundlageRVWest);
                            BigDecimal svBezugsgroesseAV = this.gllib.svBezugsgroesseAV();
                            svBezugsgroesseAV = svBezugsgroesseAV.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP);
                            svBezugsgroesseAV = svBezugsgroesseAV.multiply(svTage).divide(BigDecimal.valueOf(30L), RoundingMode.HALF_UP);
                            if (svEntgelt.compareTo(svBezugsgroesseAV) >= 0) break;
                            this.wplib.addNeueWertPosition(333700, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, svBezugsgroesseAV, false);
                            break;
                        }
                        if (this.gllib.marbRechtskreis() == 'O') {
                            this.wplib.addNeueWertPosition(130580, beitragsbemessungsgrundlageRVOst);
                            if (svEntgelt.compareTo(beitragsbemessungsgrundlageRVOst) >= 0) break;
                            this.wplib.addNeueWertPosition(333700, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitragsbemessungsgrundlageRVOst.subtract(svEntgelt), false);
                            break;
                        }
                        this.wplib.addNeueWertPosition(130580, beitragsbemessungsgrundlageRVWest);
                        if (svEntgelt.compareTo(beitragsbemessungsgrundlageRVWest) >= 0) break;
                        this.wplib.addNeueWertPosition(333700, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitragsbemessungsgrundlageRVWest.subtract(svEntgelt), false);
                        break;
                    }
                }
                switch (this.eelib.marbBgrPv()) {
                    case 1: 
                    case 2: {
                        this.wplib.addNeueWertPosition(130585, mindestbemessungsgrundlageKVPVWest);
                        if (svEntgelt.compareTo(mindestbemessungsgrundlageKVPVWest) >= 0) break;
                        this.wplib.addNeueWertPosition(339700, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, mindestbemessungsgrundlageKVPVWest.subtract(svEntgelt), false);
                        break;
                    }
                }
            }
        }
    }

    private BigDecimal getSVTageUnterBeruecksichtigungFehlzeiten(int pgs) throws BusinessDomainException {
        BigDecimal svtage = this.wplib.svTageLfd();
        BigDecimal tempFehltage = this.getFehltage(this.wplib.gueltigAb());
        if (BigDecimalMapper.compareTo((BigDecimal)svtage, (BigDecimal)BigDecimal.valueOf(30L)) == 0 && !BigDecimalMapper.isZeroOrNull((BigDecimal)tempFehltage)) {
            svtage = svtage.subtract(tempFehltage);
        }
        if (BigDecimalMapper.compareTo((BigDecimal)svtage, (BigDecimal)BigDecimal.ZERO) < 0) {
            svtage = BigDecimal.ZERO;
        }
        return svtage;
    }

    private BigDecimal getFehltage(Date validDate) throws BusinessDomainException {
        BigDecimal fehltage = BigDecimal.ZERO;
        String fehlzeitSchluessel = "";
        String[] fehlzeiten = new String[]{"UU", "F", "AU", "AR"};
        EEAbsentTimeTP[] eeAbsentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(validDate);
        if (eeAbsentTimeTPs != null) {
            for (EEAbsentTimeTP eeAbsentTimeTP : eeAbsentTimeTPs) {
                fehlzeitSchluessel = eeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getAbsentTimeKey();
                for (String fehlzeit : fehlzeiten) {
                    Date fehlzeitBis;
                    if (!StringMapper.equal((String)fehlzeitSchluessel, (String)fehlzeit) || StringMapper.equal((String)fehlzeitSchluessel, (String)"AR") && (!StringMapper.equal((String)fehlzeitSchluessel, (String)"AR") || this.eelib.marbRentenart() != 3 && this.eelib.marbRentenart() != 4)) continue;
                    Date fehlzeitAb = DateHelper.before((Date)eeAbsentTimeTP.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)validDate)) ? DateHelper.getFirstDayOfMonth((Date)validDate) : eeAbsentTimeTP.getValidFrom();
                    Date beginnDatumFuerSVTageKuerzung = this.getBeginnDatumFuerSVTageKuerzung(eeAbsentTimeTP.getValidFrom());
                    Date date = fehlzeitBis = DateHelper.before((Date)beginnDatumFuerSVTageKuerzung, (Date)eeAbsentTimeTP.getValidUntil()) ? beginnDatumFuerSVTageKuerzung : eeAbsentTimeTP.getValidUntil();
                    if (!DateHelper.afterOrEqual((Date)beginnDatumFuerSVTageKuerzung, (Date)DateHelper.getFirstDayOfMonth((Date)validDate))) continue;
                    if (DateHelper.after((Date)fehlzeitBis, (Date)DateHelper.getLastDayOfMonth((Date)validDate))) {
                        fehlzeitBis = DateHelper.getLastDayOfMonth((Date)validDate);
                    }
                    fehltage = fehltage.add(BigDecimal.valueOf(DateHelper.getDiffInDays((Date)fehlzeitBis, (Date)fehlzeitAb)).add(BigDecimal.ONE).setScale(0));
                }
            }
        }
        return fehltage;
    }

    private Date getBeginnDatumFuerSVTageKuerzung(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.get(5) - 1);
        cal.set(2, cal.get(2) + 1);
        return cal.getTime();
    }

    private BigDecimal gesamtesSVEntgeltLfdImMonat() throws BusinessDomainException {
        return this.wplib.summeWPErgebnisVonWertarten(ValueTypeHelper.getValueTypes(130510, 130560));
    }
}

