/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.insurance.MultiplyEmploymentEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.ErmittlungSVEntgeltMfBFormula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungRVEntgeltLfdFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mGesRvEntgeltBeideAG = BigDecimal.ZERO;
    private BigDecimal mRvBBGOhneMfB = BigDecimal.ZERO;
    private boolean mIs100ProzentAG = false;

    public ErmittlungRVEntgeltLfdFormula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.mCalLib = calculationLibrary;
        this.mEeLib = employeeLibrary;
        this.mGlLib = globalLibrary;
        this.mVpLib = valuePositionLibrary;
    }

    public void ermittel() throws BusinessDomainException {
        boolean tempDbbgVorhanden;
        BigDecimal rvEntgeltLfd = BigDecimal.ZERO;
        BigDecimal rvEntgeltLfdBVAG = BigDecimal.ZERO;
        BigDecimal rvBbg = BigDecimal.ZERO;
        BigDecimal rvBbgBVAG = BigDecimal.ZERO;
        BigDecimal tempRvBBG = BigDecimal.ZERO;
        BigDecimal rvTage = this.mVpLib.rvTageMarbLfd();
        boolean mfb = false;
        boolean isMfBUndVersorgung = false;
        if (this.mVpLib.wertartenNummer() == 327740) {
            this.mIs100ProzentAG = true;
        }
        if (this.mEeLib.isMehrfachbeschaeftigt()) {
            switch (this.mEeLib.marbVersorgungsart().value()) {
                case 1: 
                case 2: 
                case 3: {
                    if (this.mEeLib.marbBgrRvAndererAG() != 0 || this.mEeLib.marbBgrRv() != 0 || this.mEeLib.marbMehrfachBeschaeftigung() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_OHNE_BV || this.mEeLib.marbMehrfachBeschaeftigung() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_UND_ANDERER_RECHTSKREIS_OHNE_BV) break;
                    isMfBUndVersorgung = true;
                }
            }
            mfb = true;
        }
        if ((this.mEeLib.marbBgrRvAndererAG() == 1 && this.mEeLib.marbBgrRv() == 1 || this.mEeLib.marbBgrRvAndererAG() == 3 && this.mEeLib.marbBgrRv() == 3) && (this.mEeLib.marbBgrKvAndererAG() != 6 || this.mEeLib.marbBgrKv() != 6) && mfb || isMfBUndVersorgung) {
            tempDbbgVorhanden = this.mCalLib.dbbgVorhanden();
            if (isMfBUndVersorgung && DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2020, 0, 1).getDate())) {
                this.mCalLib.setDbbgVorhanden(false);
            }
            BigDecimal dbbgRVEntgelt = BigDecimal.ZERO;
            if (this.mCalLib.dbbgVorhanden()) {
                if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
                    if (StringMapper.compareTo((String)this.mCalLib.dbbgRVLBBG(), (String)"J") == 0) {
                        dbbgRVEntgelt = this.mCalLib.dbbgGAEGRV();
                    }
                } else {
                    dbbgRVEntgelt = this.mCalLib.dbbgGAEGRV();
                }
            }
            rvBbg = this.getRVBBGMitBeitragsteilung(rvTage, dbbgRVEntgelt);
            this.mVpLib.addNeueWertPosition(327590, BigDecimal.ZERO, BigDecimal.ZERO, rvTage, BigDecimal.ZERO, rvBbg, true, this.mRvBBGOhneMfB, this.mGesRvEntgeltBeideAG, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            if (DateHelper.between((Date)this.mVpLib.gueltigAb(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb())) && this.mCalLib.getCalculationCase().isSVTageUnterbrechungEvaluated()) {
                tempRvBBG = this.getRVRestBBGMitBeitragsteilung(rvTage, dbbgRVEntgelt);
                this.mVpLib.addNeueWertPosition(327591, BigDecimal.ZERO, BigDecimal.ZERO, this.mCalLib.getCalculationCase().getSVTageUnterbrechung(), BigDecimal.ZERO, tempRvBBG, true);
            }
            this.mCalLib.setDbbgVorhanden(tempDbbgVorhanden);
        } else {
            rvBbg = this.getRVBBGOhneBeitragsteilung(rvTage);
            this.mVpLib.addNeueWertPosition(327590, BigDecimal.ZERO, BigDecimal.ZERO, rvTage, BigDecimal.ZERO, rvBbg, true, rvBbg, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            if ((this.mEeLib.marbMehrfachBeschaeftigung() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_OHNE_BV || this.mEeLib.marbMehrfachBeschaeftigung() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_UND_ANDERER_RECHTSKREIS_OHNE_BV) && DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2020, 0, 1).getDate())) {
                tempDbbgVorhanden = this.mCalLib.dbbgVorhanden();
                this.mCalLib.setDbbgVorhanden(false);
                rvBbgBVAG = this.getRVBBGMitBeitragsteilung(rvTage, BigDecimal.ZERO);
                this.mCalLib.setDbbgVorhanden(tempDbbgVorhanden);
            }
            if (DateHelper.between((Date)this.mVpLib.gueltigAb(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb())) && this.mCalLib.getCalculationCase().isSVTageUnterbrechungEvaluated()) {
                tempRvBBG = this.getRVRestBBGOhneBeitragsteilung(rvTage);
                this.mVpLib.addNeueWertPosition(327591, BigDecimal.ZERO, BigDecimal.ZERO, this.mCalLib.getCalculationCase().getSVTageUnterbrechung(), BigDecimal.ZERO, tempRvBBG, true);
            }
        }
        if (rvBbg.compareTo(BigDecimal.ZERO) == 0) {
            rvEntgeltLfd = BigDecimal.ZERO;
            this.mCalLib.result(rvEntgeltLfd);
            this.mCalLib.factor1(rvTage);
            this.mCalLib.summeErgebnisseAlsBasisFuerDifferenzbildung(BigDecimal.ZERO);
            if (this.mVpLib.wertPosition().getValueType().getValueTypeKey() != 327740) {
                this.modifiziereUmlage(rvEntgeltLfd, rvTage);
            }
            return;
        }
        ValuePosition[] vpArray = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes(327510, 327740, 327700, 130510, 130540));
        boolean hatEntgeltFiktiv100AG = false;
        BigDecimal gesamtesEntgelt = BigDecimal.ZERO;
        for (ValuePosition valuePosition : vpArray) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 130540: {
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getResult())) {
                        hatEntgeltFiktiv100AG = true;
                    }
                }
                case 130510: {
                    gesamtesEntgelt = gesamtesEntgelt.add(valuePosition.getResult());
                }
            }
        }
        if (hatEntgeltFiktiv100AG && gesamtesEntgelt.compareTo(rvBbg) > 0) {
            rvEntgeltLfd = this.getEntgeltAufBasisGesamtEntgelt(vpArray, rvBbg);
            rvEntgeltLfdBVAG = !BigDecimalMapper.isZeroOrNull((BigDecimal)rvBbgBVAG) ? this.getEntgeltBVAGAufBasisGesamtEntgelt(vpArray, rvBbgBVAG) : rvEntgeltLfd;
        } else {
            rvEntgeltLfd = this.getEntgeltAufBasisRVEntgelt(vpArray, rvBbg);
            rvEntgeltLfdBVAG = !BigDecimalMapper.isZeroOrNull((BigDecimal)rvBbgBVAG) ? this.getEntgeltBVAGAufBasisRVEntgelt(vpArray, rvBbgBVAG) : rvEntgeltLfd;
        }
        this.mCalLib.result(rvEntgeltLfd);
        this.mCalLib.factor1(rvTage);
        if (this.mVpLib.wertPosition().getValueType().getValueTypeKey() != 327700) {
            this.modifiziereUmlage(rvEntgeltLfdBVAG, rvTage);
        }
        this.erzeugeWertpositionenLautBGS(rvEntgeltLfd, rvEntgeltLfdBVAG);
    }

    private BigDecimal getEntgeltAufBasisRVEntgelt(ValuePosition[] vpArray, BigDecimal rvBbg) throws BusinessDomainException {
        BigDecimal rvEntgeltLfd;
        BigDecimal bisherErmitteltesRVEntgeltLfd = BigDecimal.ZERO;
        for (ValuePosition valuePosition : vpArray) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 327510: 
                case 327700: 
                case 327740: {
                    bisherErmitteltesRVEntgeltLfd = bisherErmitteltesRVEntgeltLfd.add(valuePosition.getResult());
                }
            }
        }
        if (this.mVpLib.result().compareTo(BigDecimal.ZERO) < 0) {
            BigDecimal ueberBBG = BigDecimal.ZERO;
            for (ValuePosition lElement : vpArray) {
                if (lElement.getBufferResult() == null) continue;
                ueberBBG = ueberBBG.add(lElement.getBufferResult());
            }
            if (ueberBBG.compareTo(this.mVpLib.result().negate()) > 0) {
                this.mVpLib.wertPosition().setBufferResult(this.mVpLib.result());
                this.mVpLib.result(BigDecimal.ZERO);
            } else {
                this.mVpLib.wertPosition().setBufferResult(ueberBBG.negate());
                this.mVpLib.result(this.mVpLib.result().add(ueberBBG));
            }
        }
        if ((bisherErmitteltesRVEntgeltLfd = bisherErmitteltesRVEntgeltLfd.add(this.mVpLib.result())).compareTo(rvBbg) <= 0) {
            rvEntgeltLfd = this.mVpLib.result();
        } else {
            BigDecimal differenz = bisherErmitteltesRVEntgeltLfd.subtract(rvBbg);
            if (differenz.compareTo(this.mVpLib.result()) < 0) {
                rvEntgeltLfd = this.mVpLib.result().subtract(differenz);
                this.mVpLib.wertPosition().setBufferResult(this.mVpLib.result().subtract(rvEntgeltLfd));
            } else {
                rvEntgeltLfd = BigDecimal.ZERO;
                this.mVpLib.wertPosition().setBufferResult(this.mVpLib.result());
            }
        }
        this.mCalLib.summeErgebnisseAlsBasisFuerDifferenzbildung(bisherErmitteltesRVEntgeltLfd);
        return rvEntgeltLfd;
    }

    private BigDecimal getEntgeltBVAGAufBasisRVEntgelt(ValuePosition[] vpArray, BigDecimal rvBbg) throws BusinessDomainException {
        BigDecimal rvEntgeltLfd;
        BigDecimal bisherErmitteltesRVEntgeltLfd = BigDecimal.ZERO;
        for (ValuePosition valuePosition : vpArray) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 327510: 
                case 327700: 
                case 327740: {
                    bisherErmitteltesRVEntgeltLfd = bisherErmitteltesRVEntgeltLfd.add(valuePosition.getResult());
                }
            }
        }
        if (this.mVpLib.result().compareTo(BigDecimal.ZERO) < 0) {
            BigDecimal ueberBBG = BigDecimal.ZERO;
            for (ValuePosition lElement : vpArray) {
                if (lElement.getBufferResult() == null) continue;
                ueberBBG = ueberBBG.add(lElement.getBufferResult());
            }
            if (ueberBBG.compareTo(this.mVpLib.result().negate()) > 0) {
                this.mVpLib.wertPosition().setBufferResult(this.mVpLib.result());
                this.mVpLib.result(BigDecimal.ZERO);
            } else {
                this.mVpLib.wertPosition().setBufferResult(ueberBBG.negate());
                this.mVpLib.result(this.mVpLib.result().add(ueberBBG));
            }
        }
        if ((bisherErmitteltesRVEntgeltLfd = bisherErmitteltesRVEntgeltLfd.add(this.mVpLib.result())).compareTo(rvBbg) <= 0) {
            rvEntgeltLfd = this.mVpLib.result();
        } else {
            BigDecimal differenz = bisherErmitteltesRVEntgeltLfd.subtract(rvBbg);
            if (differenz.compareTo(this.mVpLib.result()) < 0) {
                rvEntgeltLfd = this.mVpLib.result().subtract(differenz);
                this.mVpLib.wertPosition().setBufferResult(this.mVpLib.result().subtract(rvEntgeltLfd));
            } else {
                rvEntgeltLfd = BigDecimal.ZERO;
                this.mVpLib.wertPosition().setBufferResult(this.mVpLib.result());
            }
        }
        return rvEntgeltLfd;
    }

    private BigDecimal getEntgeltAufBasisGesamtEntgelt(ValuePosition[] vpArray, BigDecimal rvBbg) throws BusinessDomainException {
        BigDecimal bisherErmitteltesEntgeltLfd = BigDecimal.ZERO;
        BigDecimal bisherErmitteltesEntgeltLfd100AG = BigDecimal.ZERO;
        block4: for (ValuePosition valuePosition : vpArray) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 130510: {
                    bisherErmitteltesEntgeltLfd = bisherErmitteltesEntgeltLfd.add(valuePosition.getResult());
                    continue block4;
                }
                case 130540: {
                    bisherErmitteltesEntgeltLfd100AG = bisherErmitteltesEntgeltLfd100AG.add(valuePosition.getResult());
                }
            }
        }
        BigDecimal gesamtEntgelt = bisherErmitteltesEntgeltLfd.add(bisherErmitteltesEntgeltLfd100AG);
        BigDecimal aufgelaufenesGesEntgelt = this.mVpLib.result().add(this.mVpLib.wertPosition().getBufferField01());
        BigDecimal rvEntgeltLfd = aufgelaufenesGesEntgelt.multiply(rvBbg).divide(gesamtEntgelt, 2, RoundingMode.HALF_UP);
        BigDecimal aufgelaufenesAnteilEntgelt = this.mVpLib.wertPosition().getBufferField02();
        this.uebergabeWerte(aufgelaufenesGesEntgelt, rvEntgeltLfd);
        rvEntgeltLfd = rvEntgeltLfd.subtract(aufgelaufenesAnteilEntgelt);
        return rvEntgeltLfd;
    }

    private BigDecimal getEntgeltBVAGAufBasisGesamtEntgelt(ValuePosition[] vpArray, BigDecimal rvBbg) throws BusinessDomainException {
        BigDecimal bisherErmitteltesEntgeltLfd = BigDecimal.ZERO;
        BigDecimal bisherErmitteltesEntgeltLfd100AG = BigDecimal.ZERO;
        block4: for (ValuePosition valuePosition : vpArray) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 130510: {
                    bisherErmitteltesEntgeltLfd = bisherErmitteltesEntgeltLfd.add(valuePosition.getResult());
                    continue block4;
                }
                case 130540: {
                    bisherErmitteltesEntgeltLfd100AG = bisherErmitteltesEntgeltLfd100AG.add(valuePosition.getResult());
                }
            }
        }
        BigDecimal gesamtEntgelt = bisherErmitteltesEntgeltLfd.add(bisherErmitteltesEntgeltLfd100AG);
        BigDecimal rvEntgeltLfd = this.mVpLib.result().multiply(rvBbg).divide(gesamtEntgelt, 2, RoundingMode.HALF_UP);
        return rvEntgeltLfd;
    }

    private void uebergabeWerte(BigDecimal aufgelaufenesGesEntgelt, BigDecimal aufgelaufenesAnteilEntgelt) throws BusinessDomainException {
        ValuePosition nextVp = this.mVpLib.naechsteWP();
        if (nextVp != null) {
            nextVp.setBufferField01(aufgelaufenesGesEntgelt);
            nextVp.setBufferField02(aufgelaufenesAnteilEntgelt);
        }
    }

    private void erzeugeWertpositionenLautBGS(BigDecimal rvEntgeltLfd, BigDecimal rvEntgeltLfdBVAG) throws BusinessDomainException {
        boolean geringVerdienerImLimit = this.checkGRVImLimit();
        if (this.mEeLib.isBehinderterMA()) {
            switch (this.mEeLib.marbBgrRv()) {
                case 1: 
                case 2: {
                    if (BigDecimalMapper.compareTo((BigDecimal)this.mVpLib.prozentsatz(), (BigDecimal)BigDecimal.valueOf(100L)) == 0) {
                        this.mVpLib.addNeueWertPosition(329520, rvEntgeltLfd);
                        break;
                    }
                    this.mVpLib.addNeueWertPosition(328510, rvEntgeltLfd);
                    this.mVpLib.addNeueWertPosition(329510, rvEntgeltLfd);
                }
            }
        } else if (this.mIs100ProzentAG) {
            switch (this.mEeLib.marbBgrRv()) {
                case 0: {
                    switch (this.mEeLib.marbVersorgungsart().value()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            this.mVpLib.addNeueWertPosition(328510, rvEntgeltLfd);
                            this.mVpLib.addNeueWertPosition(329740, rvEntgeltLfd);
                        }
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.mVpLib.addNeueWertPosition(329740, rvEntgeltLfd);
                }
            }
        } else {
            block10 : switch (this.mEeLib.marbBgrRv()) {
                case 1: 
                case 2: {
                    switch (this.mEeLib.marbPgs()) {
                        case 102: 
                        case 105: {
                            if (BigDecimalMapper.compareTo((BigDecimal)this.mVpLib.prozentsatz(), (BigDecimal)BigDecimal.valueOf(100L)) == 0) {
                                this.mVpLib.addNeueWertPosition(329520, rvEntgeltLfd);
                                break block10;
                            }
                            if (!geringVerdienerImLimit) {
                                this.mVpLib.addNeueWertPosition(328510, rvEntgeltLfd);
                                this.mVpLib.addNeueWertPosition(329510, rvEntgeltLfd);
                                break block10;
                            }
                            this.mVpLib.addNeueWertPosition(329520, rvEntgeltLfd);
                            break block10;
                        }
                        case 109: {
                            this.mVpLib.addNeueWertPosition(328512, rvEntgeltLfd);
                            this.mVpLib.addNeueWertPosition(329512, rvEntgeltLfd);
                            break block10;
                        }
                        case 121: {
                            if (!geringVerdienerImLimit) {
                                throw EvaluationExceptionMapper.makePersonGroupe121PermanentPaymentOverGeneralMarginalValueOfLowIncomeEarners(rvEntgeltLfd, this.mGlLib.svGeringverdienerGrenze());
                            }
                            this.mVpLib.addNeueWertPosition(329520, rvEntgeltLfd);
                            break block10;
                        }
                        case 122: {
                            if (this.mEeLib.isPGS122Geringverdiener()) {
                                this.mVpLib.addNeueWertPosition(329520, rvEntgeltLfd);
                                break block10;
                            }
                            this.mVpLib.addNeueWertPosition(328510, rvEntgeltLfd);
                            this.mVpLib.addNeueWertPosition(329510, rvEntgeltLfd);
                            break block10;
                        }
                        case 123: {
                            this.mVpLib.addNeueWertPosition(329520, rvEntgeltLfd);
                            break block10;
                        }
                    }
                    if (this.mEeLib.kennzBestandGleitzone2022()) {
                        this.mVpLib.addNeueWertPosition(328512, rvEntgeltLfd);
                        this.mVpLib.addNeueWertPosition(329512, rvEntgeltLfd);
                        break;
                    }
                    this.mVpLib.addNeueWertPosition(328510, rvEntgeltLfd);
                    this.mVpLib.addNeueWertPosition(329510, rvEntgeltLfd);
                    break;
                }
                case 3: 
                case 4: {
                    this.mVpLib.addNeueWertPosition(329510, rvEntgeltLfd);
                    break;
                }
                case 5: 
                case 6: {
                    switch (this.mEeLib.marbPgs()) {
                        case 109: {
                            this.mVpLib.addNeueWertPosition(329512, rvEntgeltLfd);
                            break block10;
                        }
                    }
                    this.mVpLib.addNeueWertPosition(329510, rvEntgeltLfd);
                    break;
                }
                case 0: {
                    if (!DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) break;
                    switch (this.mEeLib.marbVersorgungsart().value()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            switch (this.mEeLib.marbBgrKv()) {
                                case 6: {
                                    switch (this.mEeLib.marbPgs()) {
                                        case 109: {
                                            if (this.mEeLib.marbVerzichtRvReduzierung()) {
                                                this.mVpLib.addNeueWertPosition(328512, rvEntgeltLfd);
                                            }
                                            this.mVpLib.addNeueWertPosition(329512, rvEntgeltLfd);
                                            break block10;
                                        }
                                    }
                                    this.mVpLib.addNeueWertPosition(329510, rvEntgeltLfd);
                                    break block10;
                                }
                            }
                            this.mVpLib.addNeueWertPosition(328510, rvEntgeltLfd);
                            this.mVpLib.addNeueWertPosition(329510, rvEntgeltLfdBVAG);
                        }
                    }
                }
            }
        }
    }

    private boolean checkGRVImLimit() throws BusinessDomainException {
        boolean geringVerdienerImLimit = false;
        if (this.mEeLib.isMarbGeringverdiener() || this.mEeLib.marbPgs() == 121) {
            ValuePosition[] vPArray;
            geringVerdienerImLimit = true;
            BigDecimal lfdRVEntgeltImMonat = BigDecimal.ZERO;
            for (ValuePosition valuePosition : vPArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()))) {
                if (this.mVpLib.wertartenNummer() != valuePosition.getValueType().getValueTypeKey() || (lfdRVEntgeltImMonat = lfdRVEntgeltImMonat.add(valuePosition.getResult())).compareTo(this.mGlLib.svGeringverdienerGrenze()) <= 0) continue;
                geringVerdienerImLimit = false;
            }
        }
        return geringVerdienerImLimit;
    }

    private void modifiziereUmlage(BigDecimal rvEntgeltLfd, BigDecimal rvTage) throws BusinessDomainException {
        ValuePosition vp = this.mVpLib.folgeWertartVomGenesis(360100);
        if (vp != null) {
            vp.setResult(rvEntgeltLfd);
            vp.setFactor1(rvTage);
        }
    }

    private BigDecimal rvRestBBGBeiBeitragsteilung(BigDecimal rvTage, BigDecimal dbbgRVEntgelt) throws BusinessDomainException {
        BigDecimal tempRvBBG = BigDecimal.ZERO;
        tempRvBBG = DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate()) ? (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) ? (this.isBeitragsteilung() ? this.rvRestBbgBeiBeitragsteilungEigenerRK2013(rvTage, dbbgRVEntgelt) : this.rvRestBbgBeiBeitragsteilungAbwRK2013(rvTage, dbbgRVEntgelt)) : (this.isBeitragsteilung() ? this.rvBbgBeiBeitragsteilungEigenerRK(rvTage, dbbgRVEntgelt) : this.rvBbgBeiBeitragsteilungAbwRK(rvTage, dbbgRVEntgelt))) : this.rvBbgBeiBeitragsteilungEigenerRK(rvTage, dbbgRVEntgelt);
        return tempRvBBG;
    }

    private BigDecimal rvBBGBeiBeitragsteilung(BigDecimal rvTage, BigDecimal dbbgRVEntgelt) throws BusinessDomainException {
        BigDecimal rvBbg = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
            if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                if (this.isBeitragsteilung()) {
                    switch (this.mGlLib.marbRechtskreis()) {
                        case 'W': 
                        case 'w': {
                            rvBbg = this.rvBbgBeiBeitragsteilungEigenerRK2013(rvTage, dbbgRVEntgelt);
                            break;
                        }
                        default: {
                            if (this.mCalLib.dbgzVorhanden() && !StringMapper.equal((String)Character.toString(this.mGlLib.marbRechtskreis()), (String)this.mCalLib.dbgzRK()) || this.mCalLib.dbbgVorhanden() && !StringMapper.equal((String)Character.toString(this.mGlLib.marbRechtskreis()), (String)this.mCalLib.dbbgKennzRK())) {
                                rvBbg = this.rvBbgBeiBeitragsteilungAbwRK2013(rvTage, dbbgRVEntgelt);
                                break;
                            }
                            rvBbg = this.rvBbgBeiBeitragsteilungEigenerRK2013(rvTage, dbbgRVEntgelt);
                            break;
                        }
                    }
                } else {
                    rvBbg = this.rvBbgBeiBeitragsteilungAbwRK2013(rvTage, dbbgRVEntgelt);
                }
            } else {
                rvBbg = this.isBeitragsteilung() ? this.rvBbgBeiBeitragsteilungEigenerRK(rvTage, dbbgRVEntgelt) : this.rvBbgBeiBeitragsteilungAbwRK(rvTage, dbbgRVEntgelt);
            }
        } else {
            rvBbg = this.rvBbgBeiBeitragsteilungEigenerRK(rvTage, dbbgRVEntgelt);
        }
        return rvBbg;
    }

    private BigDecimal rvBbgBeiBeitragsteilungEigenerRK2013(BigDecimal rvTage, BigDecimal dbbgRVEntgelt) throws BusinessDomainException {
        return this.rvBbgBeiBeitragsteilungEigenerRK(rvTage, dbbgRVEntgelt);
    }

    private BigDecimal rvBbgBeiBeitragsteilungEigenerRK(BigDecimal rvTage, BigDecimal dbbgRVEntgelt) throws BusinessDomainException {
        BigDecimal svBBG = this.mGlLib.svBbgRvAv();
        this.mRvBBGOhneMfB = svBBG.multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        ErmittlungSVEntgeltMfBFormula formula = new ErmittlungSVEntgeltMfBFormula(this.mCalLib, this.mVpLib);
        ErmittlungSVEntgeltMfBFormula.SVEntgeltMfBDatas sVEntgeltMfBDatas = formula.getBBGBeiBeitragsteilungEigenerRK(svBBG, rvTage, dbbgRVEntgelt);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)sVEntgeltMfBDatas.getEntgeltLfdAndererAG())) {
            this.mVpLib.addNeueWertPosition(327595, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, sVEntgeltMfBDatas.getEntgeltLfdAndererAG(), true);
        }
        this.mGesRvEntgeltBeideAG = sVEntgeltMfBDatas.getGesEntgeltBeideAG();
        return sVEntgeltMfBDatas.getAnteiligeBBGAktuellerAG();
    }

    private BigDecimal rvBbgBeiBeitragsteilungAbwRK2013(BigDecimal rvTage, BigDecimal dbbgRVEntgelt) throws BusinessDomainException {
        return this.rvBbgBeiBeitragsteilungAbwRK(rvTage, dbbgRVEntgelt);
    }

    private BigDecimal rvBbgBeiBeitragsteilungAbwRK(BigDecimal rvTage, BigDecimal dbbgRVEntgelt) throws BusinessDomainException {
        BigDecimal rvBbgEigenerAG = BigDecimal.ZERO;
        BigDecimal rvBbgAndererAG = BigDecimal.ZERO;
        switch (this.mGlLib.marbRechtskreis()) {
            case 'W': 
            case 'w': {
                rvBbgEigenerAG = this.mGlLib.svBbgRvAvWest();
                rvBbgAndererAG = this.mGlLib.svBbgRvAvOst();
                break;
            }
            default: {
                rvBbgEigenerAG = this.mGlLib.svBbgRvAvOst();
                rvBbgAndererAG = this.mGlLib.svBbgRvAvWest();
            }
        }
        BigDecimal svBBG = this.mGlLib.svBbgRvAvWest();
        this.mRvBBGOhneMfB = svBBG.multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        ErmittlungSVEntgeltMfBFormula formula = new ErmittlungSVEntgeltMfBFormula(this.mCalLib, this.mVpLib);
        ErmittlungSVEntgeltMfBFormula.SVEntgeltMfBDatas sVEntgeltMfBDatas = formula.getBBGBeiBeitragsteilungAbwRK(svBBG, rvBbgEigenerAG, rvBbgAndererAG, rvTage, dbbgRVEntgelt);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)sVEntgeltMfBDatas.getEntgeltLfdAndererAG())) {
            this.mVpLib.addNeueWertPosition(327595, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, sVEntgeltMfBDatas.getEntgeltLfdAndererAG(), true);
        }
        this.mGesRvEntgeltBeideAG = sVEntgeltMfBDatas.getGesEntgeltBeideAG();
        return sVEntgeltMfBDatas.getAnteiligeBBGAktuellerAG();
    }

    private BigDecimal rvRestBbgBeiBeitragsteilungEigenerRK2013(BigDecimal rvTage, BigDecimal dbbgRVEntgelt) throws BusinessDomainException {
        ErmittlungSVEntgeltMfBFormula formula = new ErmittlungSVEntgeltMfBFormula(this.mCalLib, this.mVpLib);
        BigDecimal rvBBG = this.mGlLib.svBbgRvAv();
        ErmittlungSVEntgeltMfBFormula.SVEntgeltMfBDatas sVEntgeltMfBDatas = formula.getRestBBGBeiBeitragsteilungEigenerRK2013(rvBBG, rvTage, dbbgRVEntgelt);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)sVEntgeltMfBDatas.getEntgeltLfdAndererAG())) {
            this.mVpLib.addNeueWertPosition(327595, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, sVEntgeltMfBDatas.getEntgeltLfdAndererAG(), true);
        }
        return sVEntgeltMfBDatas.getAnteiligeBBGAktuellerAG();
    }

    private BigDecimal rvRestBbgBeiBeitragsteilungAbwRK2013(BigDecimal rvTage, BigDecimal dbbgRVEntgelt) throws BusinessDomainException {
        BigDecimal rvBbgEigenerAG = BigDecimal.ZERO;
        BigDecimal svBBG = BigDecimal.ZERO;
        BigDecimal rvBbgAndererAG = BigDecimal.ZERO;
        switch (this.mGlLib.marbRechtskreis()) {
            case 'W': 
            case 'w': {
                rvBbgEigenerAG = this.mGlLib.svBbgRvAvWest();
                rvBbgAndererAG = this.mGlLib.svBbgRvAvOst();
                break;
            }
            default: {
                rvBbgEigenerAG = this.mGlLib.svBbgRvAvOst();
                rvBbgAndererAG = this.mGlLib.svBbgRvAvWest();
            }
        }
        svBBG = this.mGlLib.svBbgRvAvWest();
        ErmittlungSVEntgeltMfBFormula formula = new ErmittlungSVEntgeltMfBFormula(this.mCalLib, this.mVpLib);
        ErmittlungSVEntgeltMfBFormula.SVEntgeltMfBDatas sVEntgeltMfBDatas = formula.getRestBBGBeiBeitragsteilungAbwRK2013(svBBG, rvBbgEigenerAG, rvBbgAndererAG, rvTage, dbbgRVEntgelt);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)sVEntgeltMfBDatas.getEntgeltLfdAndererAG())) {
            this.mVpLib.addNeueWertPosition(327595, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, sVEntgeltMfBDatas.getEntgeltLfdAndererAG(), true);
        }
        return sVEntgeltMfBDatas.getAnteiligeBBGAktuellerAG();
    }

    private boolean isBeitragsteilung() throws BusinessDomainException {
        return this.mEeLib.marbMehrfachBeschaeftigung() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG || this.mEeLib.marbMehrfachBeschaeftigung() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_OHNE_BV;
    }

    private BigDecimal getRVBBGMitBeitragsteilung(BigDecimal rvTage, BigDecimal dbbgRVEntgelt) throws BusinessDomainException {
        return this.rvBBGBeiBeitragsteilung(rvTage, dbbgRVEntgelt);
    }

    private BigDecimal getRVRestBBGMitBeitragsteilung(BigDecimal rvTage, BigDecimal dbbgRVEntgelt) throws BusinessDomainException {
        return this.rvRestBBGBeiBeitragsteilung(rvTage, dbbgRVEntgelt);
    }

    private BigDecimal getRVBBGOhneBeitragsteilung(BigDecimal rvTage) throws BusinessDomainException {
        BigDecimal rvBbg = BigDecimal.ZERO;
        block0 : switch (this.mEeLib.marbBgrRv()) {
            case 0: {
                if (!DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) break;
                switch (this.mEeLib.marbVersorgungsart().value()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        rvBbg = this.mGlLib.svBbgRvAv().multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                        this.mVpLib.addNeueWertPosition(327590, BigDecimal.ZERO, BigDecimal.ZERO, rvTage, BigDecimal.ZERO, rvBbg, true, rvBbg, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
                    }
                }
                break;
            }
            default: {
                switch (this.mGlLib.krkTyp()) {
                    case 6: {
                        if (!this.mEeLib.marbErhBeitrErmKnappschRV()) break;
                        rvBbg = this.mGlLib.svBbgKnappschaft().multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                        this.mVpLib.addNeueWertPosition(327590, BigDecimal.ZERO, BigDecimal.ZERO, rvTage, BigDecimal.ZERO, rvBbg, true, rvBbg, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
                        break block0;
                    }
                }
                rvBbg = this.mGlLib.svBbgRvAv().multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                this.mVpLib.addNeueWertPosition(327590, BigDecimal.ZERO, BigDecimal.ZERO, rvTage, BigDecimal.ZERO, rvBbg, true, rvBbg, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            }
        }
        return rvBbg;
    }

    private BigDecimal getRVRestBBGOhneBeitragsteilung(BigDecimal rvTage) throws BusinessDomainException {
        BigDecimal rvBbg = BigDecimal.ZERO;
        block0 : switch (this.mEeLib.marbBgrRv()) {
            case 0: {
                if (!DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) break;
                switch (this.mEeLib.marbVersorgungsart().value()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        rvBbg = this.mGlLib.svBbgRvAv().multiply(this.mCalLib.getCalculationCase().getSVTageUnterbrechung()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                        this.mVpLib.addNeueWertPosition(327591, BigDecimal.ZERO, BigDecimal.ZERO, this.mCalLib.getCalculationCase().getSVTageUnterbrechung(), BigDecimal.ZERO, rvBbg, true);
                    }
                }
                break;
            }
            default: {
                switch (this.mGlLib.krkTyp()) {
                    case 6: {
                        if (!this.mEeLib.marbErhBeitrErmKnappschRV()) break;
                        rvBbg = this.mGlLib.svBbgKnappschaft().multiply(this.mCalLib.getCalculationCase().getSVTageUnterbrechung()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                        this.mVpLib.addNeueWertPosition(327591, BigDecimal.ZERO, BigDecimal.ZERO, this.mCalLib.getCalculationCase().getSVTageUnterbrechung(), BigDecimal.ZERO, rvBbg, true);
                        break block0;
                    }
                }
                rvBbg = this.mGlLib.svBbgRvAv().multiply(this.mCalLib.getCalculationCase().getSVTageUnterbrechung()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                this.mVpLib.addNeueWertPosition(327591, BigDecimal.ZERO, BigDecimal.ZERO, this.mCalLib.getCalculationCase().getSVTageUnterbrechung(), BigDecimal.ZERO, rvBbg, true);
            }
        }
        return rvBbg;
    }
}

