/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.ErmittlungGleitzonenEntgeltFormula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungRVEntgeltGleitzone2022Formula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mEntgeltAbwAG = BigDecimal.ZERO;
    private BigDecimal mEntgeltEGAAbwAG = BigDecimal.ZERO;
    private BigDecimal mEntgeltLfdAbwAG = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltEGA = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltLfd = BigDecimal.ZERO;
    private BigDecimal mRVBBG = BigDecimal.ZERO;
    private BigDecimal zwRVBBG = BigDecimal.ZERO;
    private BigDecimal zwSVEntgelt = BigDecimal.ZERO;
    private BigDecimal mRVBemessungsEntgeltAG = BigDecimal.ZERO;
    private BigDecimal mRVBemessungsEntgeltAN = BigDecimal.ZERO;

    public ErmittlungRVEntgeltGleitzone2022Formula(CalculationLibrary caLibrary, EmployeeLibrary eeLibrary, GlobalLibrary glLibrary, ValuePositionLibrary vpLibrary) {
        this.mCalLib = caLibrary;
        this.mEeLib = eeLibrary;
        this.mGlLib = glLibrary;
        this.mVpLib = vpLibrary;
    }

    public void ermittel() throws BusinessDomainException {
        ValuePosition genesis;
        BigDecimal result = this.mVpLib.result();
        BigDecimal rvTage = this.mVpLib.rvTageMarb();
        this.ermittleRVEntgeltImMonat();
        switch (this.mVpLib.wertartenNummer()) {
            case 327514: {
                this.mGesEntgeltLfd = this.mGesEntgeltLfd.add(result);
                break;
            }
            case 327614: {
                this.mGesEntgeltEGA = this.mGesEntgeltEGA.add(result);
            }
        }
        this.mRVBBG = this.mGlLib.svBbgRvAv().multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        if (this.mGesEntgeltEGA.compareTo(BigDecimal.ZERO) != 0) {
            this.abgrenzungEGA();
        }
        this.mVpLib.addNeueWertPosition(327590, BigDecimal.ZERO, BigDecimal.ZERO, rvTage, BigDecimal.ZERO, this.mRVBBG, true);
        this.modifikationTeilLZZ(rvTage);
        BigDecimal gesEntgelt = this.mGesEntgeltLfd.add(this.mGesEntgeltEGA);
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && this.mCalLib.dbgzVorhanden()) {
            if (this.mCalLib.dbgzSVTG() == 0) {
                throw EvaluationExceptionMapper.makeZeroDaysInDbgzNotAllowedDomainException(this.mCalLib.berchnungGueltigAb());
            }
            if (this.mCalLib.dbgzSVTG() != 30) {
                this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(BigDecimal.valueOf(this.mCalLib.dbgzSVTG()), 2, RoundingMode.HALF_UP);
            }
        }
        if (this.mCalLib.dbgzVorhanden()) {
            if (this.mCalLib.dbgzKennzGLZ().value() == 1 || this.mCalLib.dbgzKennzGLZ().value() == 3) {
                this.mEntgeltAbwAG = this.mEntgeltLfdAbwAG.add(this.mEntgeltEGAAbwAG);
            }
        } else if (this.mEeLib.isMehrfachbeschaeftigt() && this.mEeLib.marbBgrRvAndererAG() != 0) {
            this.mEntgeltAbwAG = this.mEntgeltLfdAbwAG.add(this.mEntgeltEGAAbwAG);
        }
        BigDecimal tempRvTage = rvTage;
        if (BigDecimalMapper.isZero((BigDecimal)rvTage) && (genesis = this.mVpLib.genesisParent()) != null) {
            ValuePosition[] vpos;
            for (ValuePosition vp : vpos = this.mVpLib.genesisUndFolgen()) {
                if (vp.getValueType().getValueTypeKey() != 130610) continue;
                tempRvTage = BigDecimal.valueOf(30L);
            }
        }
        ErmittlungGleitzonenEntgeltFormula gleitzonenEntgeltFormula = new ErmittlungGleitzonenEntgeltFormula(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib);
        BigDecimal beitrPflEinnahmeGesamtAG = gleitzonenEntgeltFormula.getEntgeltGleitzone(gesEntgelt, this.mEntgeltAbwAG, tempRvTage);
        BigDecimal beitrPflEinnahmeGesamtAN = gleitzonenEntgeltFormula.getEntgeltGleitzoneAN(gesEntgelt, this.mEntgeltAbwAG, tempRvTage);
        BigDecimal beitrPflEinnahmeAG = beitrPflEinnahmeGesamtAG.subtract(this.mRVBemessungsEntgeltAG);
        BigDecimal beitrPflEinnahmeAN = beitrPflEinnahmeGesamtAN.subtract(this.mRVBemessungsEntgeltAN);
        this.erzeugeWertpositionen(beitrPflEinnahmeAG, beitrPflEinnahmeAN, rvTage);
        this.mCalLib.result(result);
    }

    private void abgrenzungEGA() throws BusinessDomainException {
        this.zwRVBBG = this.mRVBBG;
        this.zwSVEntgelt = BigDecimal.ZERO;
        this.zwSVEntgelt = this.mCalLib.dbgzVorhanden() ? (this.mCalLib.dbgzKennzGLZ().value() == 1 || this.mCalLib.dbgzKennzGLZ().value() == 3 ? this.mGesEntgeltLfd.add(this.mEntgeltLfdAbwAG).add(this.mEntgeltEGAAbwAG) : this.mGesEntgeltLfd) : (this.mEeLib.isMehrfachbeschaeftigt() && this.mEeLib.marbBgrRvAndererAG() != 0 && this.mEeLib.marbBgrRvAndererAG() != 5 ? this.mGesEntgeltLfd.add(this.mEntgeltLfdAbwAG).add(this.mEntgeltEGAAbwAG) : this.mGesEntgeltLfd);
        if (this.zwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.zwRVBBG) > 0) {
            this.holeJahresWerte();
            if (this.zwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.zwRVBBG) > 0) {
                this.mGesEntgeltEGA = this.zwSVEntgelt.compareTo(this.zwRVBBG) < 0 ? this.zwRVBBG.subtract(this.zwSVEntgelt) : BigDecimal.ZERO;
            }
        }
    }

    private void modifikationTeilLZZ(BigDecimal rvTage) throws BusinessDomainException {
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                if (rvTage.compareTo(BigDecimal.ZERO) != 0) {
                    this.mGesEntgeltLfd = this.mVpLib.hochrechnungGleitzonenEntgeltBeiLZZ(this.mGesEntgeltLfd, rvTage);
                    this.mEntgeltLfdAbwAG = this.mVpLib.hochrechnungGleitzonenEntgeltBeiLZZ(this.mEntgeltLfdAbwAG, rvTage);
                } else if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                    this.mGesEntgeltLfd = BigDecimal.ZERO;
                    this.mEntgeltLfdAbwAG = BigDecimal.ZERO;
                }
            } else if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate())) {
                if (rvTage.compareTo(BigDecimal.ZERO) != 0) {
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(rvTage, 2, RoundingMode.HALF_UP);
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(rvTage, 2, RoundingMode.HALF_UP);
                }
            } else if (this.mVpLib.tageMitEFZ().compareTo(BigDecimal.ZERO) != 0) {
                this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(this.mVpLib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
                this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(this.mVpLib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
            }
        }
    }

    private void ermittleRVEntgeltImMonat() throws BusinessDomainException {
        ValuePosition[] vpArray;
        block8: for (ValuePosition lElement : vpArray = this.sammleValuePosition(ValueTypeHelper.getValueTypes(129200, 129205, 129210, 129215, 327514, 327614, 327616, 773616, 773595, 773695, 773514, 773614, 327565))) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 129200: 
                case 129205: 
                case 773595: {
                    if ((this.mEeLib.marbBgrRvAndererAG() == 0 || this.mEeLib.marbBgrRvAndererAG() == 5) && !this.mCalLib.dbgzVorhanden()) continue block8;
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.add(lElement.getResult());
                    continue block8;
                }
                case 129210: 
                case 129215: 
                case 773695: {
                    if ((this.mEeLib.marbBgrRvAndererAG() == 0 || this.mEeLib.marbBgrRvAndererAG() == 5) && !this.mCalLib.dbgzVorhanden()) continue block8;
                    this.mEntgeltEGAAbwAG = this.mEntgeltEGAAbwAG.add(lElement.getResult());
                    continue block8;
                }
                case 327514: 
                case 773514: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getBufferResult())) continue block8;
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.add(lElement.getBufferResult());
                    continue block8;
                }
                case 327614: 
                case 773614: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getBufferResult())) continue block8;
                    this.mGesEntgeltEGA = this.mGesEntgeltEGA.add(lElement.getBufferResult());
                    continue block8;
                }
                case 327616: 
                case 773616: {
                    this.mRVBemessungsEntgeltAG = this.mRVBemessungsEntgeltAG.add(lElement.getResult());
                    continue block8;
                }
                case 327565: {
                    this.mRVBemessungsEntgeltAN = this.mRVBemessungsEntgeltAN.add(lElement.getResult());
                    continue block8;
                }
            }
        }
    }

    private void erzeugeWertpositionen(BigDecimal beitrPflEinnahmeAG, BigDecimal beitrPflEinnahmeAN, BigDecimal rvTage) throws BusinessDomainException {
        boolean kugFeiertagsentgelt = false;
        ValuePosition genesisVP = this.mVpLib.genesisParent();
        if (genesisVP.getValueType().getValueTypeKey() == 99973) {
            kugFeiertagsentgelt = true;
        }
        if (kugFeiertagsentgelt) {
            this.mVpLib.addNeueWertPosition(329514, beitrPflEinnahmeAG, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahmeAN, false);
        } else {
            if (this.mEeLib.marbBgrRv() != 3) {
                if (this.mEeLib.marbBgrRv() == 0) {
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)beitrPflEinnahmeAG)) {
                        this.mVpLib.addNeueWertPosition(328514, beitrPflEinnahmeAN, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahmeAG, false);
                    }
                } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)beitrPflEinnahmeAN)) {
                    this.mVpLib.addNeueWertPosition(328514, beitrPflEinnahmeAG, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahmeAN, false);
                }
            }
            if (this.mEeLib.marbBgrRv() == 0) {
                this.mVpLib.addNeueWertPosition(329514, beitrPflEinnahmeAN, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahmeAG, false);
            } else {
                this.mVpLib.addNeueWertPosition(329514, beitrPflEinnahmeAG, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahmeAN, false);
            }
        }
        this.mVpLib.addNeueWertPosition(327616, BigDecimal.ZERO, BigDecimal.ZERO, rvTage, BigDecimal.ZERO, beitrPflEinnahmeAG, false, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result());
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)beitrPflEinnahmeAN) && this.mEeLib.marbBgrRv() == 1) {
            this.mVpLib.addNeueWertPosition(327565, BigDecimal.ZERO, BigDecimal.ZERO, rvTage, BigDecimal.ZERO, beitrPflEinnahmeAN, false, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.result());
        }
    }

    private void holeJahresWerte() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
            this.holeJahresWerte2011();
        } else {
            ValuePosition[] zwVPArray = null;
            Date sucheBeginnDatum = DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb());
            Date sucheEndeDatum = DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb());
            ValueType[] vtArray = ValueTypeHelper.getValueTypes(327590, 327510, 327514, 327610, 327614);
            while (DateHelper.before((Date)sucheBeginnDatum, (Date)sucheEndeDatum)) {
                block5: for (ValuePosition lElement : zwVPArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), sucheBeginnDatum, DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum), vtArray)) {
                    switch (lElement.getValueType().getValueTypeKey()) {
                        case 327590: {
                            this.zwRVBBG = this.zwRVBBG.add(lElement.getResult());
                            continue block5;
                        }
                        case 327510: 
                        case 327514: 
                        case 327610: 
                        case 327614: {
                            this.zwSVEntgelt = this.zwSVEntgelt.add(lElement.getResult());
                            continue block5;
                        }
                    }
                }
                sucheBeginnDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum));
            }
        }
    }

    private void holeJahresWerte2011() throws BusinessDomainException {
        ValuePosition[] zwVPArray = null;
        Date sucheBeginnDatum = DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb());
        Date sucheEndeDatum = DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb());
        ValueType[] vtArray = ValueTypeHelper.getValueTypes(327590, 327510, 327514, 327610, 327614, 773590, 773510, 773514, 773610, 773614);
        while (DateHelper.before((Date)sucheBeginnDatum, (Date)sucheEndeDatum)) {
            block5: for (ValuePosition lElement : zwVPArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), sucheBeginnDatum, DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum), vtArray)) {
                switch (lElement.getValueType().getValueTypeKey()) {
                    case 327590: 
                    case 773590: {
                        this.zwRVBBG = this.zwRVBBG.add(lElement.getResult());
                        continue block5;
                    }
                    case 327510: 
                    case 327514: 
                    case 327610: 
                    case 327614: 
                    case 773510: 
                    case 773514: 
                    case 773610: 
                    case 773614: {
                        this.zwSVEntgelt = this.zwSVEntgelt.add(lElement.getResult());
                        continue block5;
                    }
                }
            }
            sucheBeginnDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum));
        }
    }

    private ValuePosition[] sammleValuePosition(ValueType ... vts) throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vts);
    }
}

