/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.ErmittlungGleitzonenEntgeltFormula;
import com.varial.personnel.domain.evaluation.formula.ErmittlungPVEntgeltGleitzone2022Formula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungPVEntgeltGleitzoneFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mEntgeltAbwAG = BigDecimal.ZERO;
    private BigDecimal mEntgeltEGAAbwAG = BigDecimal.ZERO;
    private BigDecimal mEntgeltLfdAbwAG = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltEGA = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltLfd = BigDecimal.ZERO;
    private BigDecimal mPVBBG = BigDecimal.ZERO;
    private BigDecimal mPVBemessungsentgelt = BigDecimal.ZERO;
    private BigDecimal zwPVBBG = BigDecimal.ZERO;
    private BigDecimal zwSVEntgelt = BigDecimal.ZERO;

    public ErmittlungPVEntgeltGleitzoneFormula(CalculationLibrary caLibrary, EmployeeLibrary eeLibrary, GlobalLibrary glLibrary, ValuePositionLibrary vpLibrary) {
        this.mCalLib = caLibrary;
        this.mEeLib = eeLibrary;
        this.mGlLib = glLibrary;
        this.mVpLib = vpLibrary;
    }

    public void ermittel() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2022, 9, 1).getDate()) && !this.mEeLib.kennzBestandGleitzone2022()) {
            new ErmittlungPVEntgeltGleitzone2022Formula(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib).ermittel();
        } else {
            ValuePosition genesis;
            BigDecimal result = this.mVpLib.result();
            BigDecimal pvTage = this.mVpLib.pvTageMarb();
            this.ermittlePVEntgeltImMonat();
            BigDecimal entgeltAufgelaufen = this.mGesEntgeltLfd.add(this.mGesEntgeltEGA);
            switch (this.mVpLib.wertartenNummer()) {
                case 339514: {
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.add(result);
                    break;
                }
                case 339614: {
                    this.mGesEntgeltEGA = this.mGesEntgeltEGA.add(result);
                }
            }
            this.mPVBBG = this.mGlLib.svBbgKvPv().multiply(pvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
            if (this.mGesEntgeltEGA.compareTo(BigDecimal.ZERO) != 0) {
                this.abgrenzungEGA();
            }
            this.mVpLib.addNeueWertPosition(339590, BigDecimal.ZERO, BigDecimal.ZERO, pvTage, BigDecimal.ZERO, this.mPVBBG, true);
            this.modifikationTeilLZZ(pvTage);
            BigDecimal gesEntgelt = this.mGesEntgeltLfd.add(this.mGesEntgeltEGA);
            if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && this.mCalLib.dbgzVorhanden()) {
                if (this.mCalLib.dbgzSVTG() == 0) {
                    throw EvaluationExceptionMapper.makeZeroDaysInDbgzNotAllowedDomainException(this.mCalLib.berchnungGueltigAb());
                }
                if (this.mCalLib.dbgzSVTG() != 30) {
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(BigDecimal.valueOf(this.mCalLib.dbgzSVTG()), 2, RoundingMode.HALF_UP);
                }
            }
            if (this.mCalLib.dbgzVorhanden()) {
                if (this.mCalLib.dbgzKennzGLZ().value() == 1 || this.mCalLib.dbgzKennzGLZ().value() == 3) {
                    this.mEntgeltAbwAG = this.mEntgeltLfdAbwAG.add(this.mEntgeltEGAAbwAG);
                }
            } else if (this.mEeLib.isMehrfachbeschaeftigt() && this.mEeLib.marbBgrPvAndererAG() != 0) {
                this.mEntgeltAbwAG = this.mEntgeltLfdAbwAG.add(this.mEntgeltEGAAbwAG);
            }
            BigDecimal tempPvTage = pvTage;
            if (BigDecimalMapper.isZero((BigDecimal)pvTage) && (genesis = this.mVpLib.genesisParent()) != null) {
                ValuePosition[] vpos;
                for (ValuePosition vp : vpos = this.mVpLib.genesisUndFolgen()) {
                    if (vp.getValueType().getValueTypeKey() != 130610) continue;
                    tempPvTage = BigDecimal.valueOf(30L);
                }
            }
            ErmittlungGleitzonenEntgeltFormula gleitzonenEntgeltFormula = new ErmittlungGleitzonenEntgeltFormula(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib);
            BigDecimal beitrPflEinnahmeGesamt = gleitzonenEntgeltFormula.getEntgeltGleitzone(gesEntgelt, this.mEntgeltAbwAG, tempPvTage);
            if (pvTage.compareTo(BigDecimal.ZERO) != 0) {
                if (this.mVpLib.wertartenNummer() == 339614) {
                    gesEntgelt = gesEntgelt.subtract(result);
                    gesEntgelt = gesEntgelt.multiply(pvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                    gesEntgelt = gesEntgelt.add(result);
                } else {
                    gesEntgelt = gesEntgelt.multiply(pvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                }
            }
            BigDecimal beitrPflEinnahme = beitrPflEinnahmeGesamt.subtract(this.mPVBemessungsentgelt);
            BigDecimal beitrPflGesamt = gesEntgelt.subtract(entgeltAufgelaufen);
            this.erzeugeWertpositionen(beitrPflEinnahme, beitrPflGesamt, pvTage);
            this.mCalLib.result(result);
        }
    }

    private void abgrenzungEGA() throws BusinessDomainException {
        this.zwPVBBG = this.mPVBBG;
        this.zwSVEntgelt = BigDecimal.ZERO;
        this.zwSVEntgelt = this.mCalLib.dbgzVorhanden() ? (this.mCalLib.dbgzKennzGLZ().value() == 1 || this.mCalLib.dbgzKennzGLZ().value() == 3 ? this.mGesEntgeltLfd.add(this.mEntgeltLfdAbwAG).add(this.mEntgeltEGAAbwAG) : this.mGesEntgeltLfd) : (this.mEeLib.isMehrfachbeschaeftigt() && this.mEeLib.marbBgrPvAndererAG() != 0 ? this.mGesEntgeltLfd.add(this.mEntgeltLfdAbwAG).add(this.mEntgeltEGAAbwAG) : this.mGesEntgeltLfd);
        if (this.zwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.zwPVBBG) > 0) {
            this.holeJahresWerte();
            if (this.zwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.zwPVBBG) > 0) {
                this.mGesEntgeltEGA = this.zwSVEntgelt.compareTo(this.zwPVBBG) < 0 ? this.zwPVBBG.subtract(this.zwSVEntgelt) : BigDecimal.ZERO;
            }
        }
    }

    private void modifikationTeilLZZ(BigDecimal pvTage) throws BusinessDomainException {
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                if (pvTage.compareTo(BigDecimal.ZERO) != 0) {
                    this.mGesEntgeltLfd = this.mVpLib.hochrechnungGleitzonenEntgeltBeiLZZ(this.mGesEntgeltLfd, pvTage);
                    this.mEntgeltLfdAbwAG = this.mVpLib.hochrechnungGleitzonenEntgeltBeiLZZ(this.mEntgeltLfdAbwAG, pvTage);
                } else {
                    this.mGesEntgeltLfd = BigDecimal.ZERO;
                    this.mEntgeltLfdAbwAG = BigDecimal.ZERO;
                }
            } else if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate())) {
                if (pvTage.compareTo(BigDecimal.ZERO) != 0) {
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(pvTage, 2, RoundingMode.HALF_UP);
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(pvTage, 2, RoundingMode.HALF_UP);
                }
            } else if (this.mVpLib.tageMitEFZ().compareTo(BigDecimal.ZERO) != 0) {
                this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(this.mVpLib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
                this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(this.mVpLib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
            }
        }
    }

    private void ermittlePVEntgeltImMonat() throws BusinessDomainException {
        ValuePosition[] vpArray;
        block7: for (ValuePosition lElement : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), ValueTypeHelper.getValueTypes(129200, 129205, 129210, 129215, 339514, 339614, 339616))) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 129200: 
                case 129205: {
                    if (this.mEeLib.marbBgrPvAndererAG() == 0 && !this.mCalLib.dbgzVorhanden()) continue block7;
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.add(lElement.getResult());
                    continue block7;
                }
                case 129210: 
                case 129215: {
                    if (this.mEeLib.marbBgrPvAndererAG() == 0 && !this.mCalLib.dbgzVorhanden()) continue block7;
                    this.mEntgeltEGAAbwAG = this.mEntgeltEGAAbwAG.add(lElement.getResult());
                    continue block7;
                }
                case 339514: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getBufferResult())) continue block7;
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.add(lElement.getBufferResult());
                    continue block7;
                }
                case 339614: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getBufferResult())) continue block7;
                    this.mGesEntgeltEGA = this.mGesEntgeltEGA.add(lElement.getBufferResult());
                    continue block7;
                }
                case 339616: {
                    this.mPVBemessungsentgelt = this.mPVBemessungsentgelt.add(lElement.getResult());
                    continue block7;
                }
            }
        }
    }

    private void erzeugeWertpositionen(BigDecimal beitrPflEinnahme, BigDecimal gesEntgelt, BigDecimal pvTage) throws BusinessDomainException {
        boolean kugFeiertagsentgelt = false;
        ValuePosition genesisVP = this.mVpLib.genesisParent();
        if (genesisVP.getValueType().getValueTypeKey() == 99973) {
            kugFeiertagsentgelt = true;
        }
        if (kugFeiertagsentgelt) {
            this.mVpLib.addNeueWertPosition(341514, gesEntgelt, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
        } else {
            this.mVpLib.addNeueWertPosition(340514, gesEntgelt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
            this.mVpLib.addNeueWertPosition(341514, gesEntgelt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
            this.erzeugeZusatzbeitrag(beitrPflEinnahme, gesEntgelt);
        }
        this.mVpLib.addNeueWertPosition(339616, BigDecimal.ZERO, BigDecimal.ZERO, pvTage, BigDecimal.ZERO, beitrPflEinnahme, false);
    }

    private void erzeugeZusatzbeitrag(BigDecimal beitrPflEinnahme, BigDecimal gesEntgelt) throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2005, 0, 1).getDate())) {
            if (this.mEeLib.marbAelterDreiUndZwanzig() && DateHelper.afterOrEqual((Date)this.mEeLib.marbGeburtstag(), (Date)new VDate(1940, 0, 1).getDate())) {
                if (!this.mEeLib.isMarbKindErz()) {
                    this.mVpLib.addNeueWertPosition(340518, gesEntgelt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
                }
            } else if (!this.mEeLib.marbAelterDreiUndZwanzig()) {
                new CalculationBasic(this.mEeLib.marb(), this.mVpLib.wirksamAb(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)new VDate(this.mEeLib.marbGeburtstag()).addYears(23).getDate())), "erreichen des 23. Lebensjahres PV Zusatzbeitrag");
            }
        } else {
            new CalculationBasic(this.mEeLib.marb(), this.mVpLib.wirksamAb(), new VDate(2005, 0, 1).getDate(), "Zusatzbeitrag PV");
        }
    }

    private void holeJahresWerte() throws BusinessDomainException {
        ValuePosition[] zwVPArray = null;
        Date sucheBeginnDatum = DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb());
        Date sucheEndeDatum = DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb());
        ValueType[] vtArray = ValueTypeHelper.getValueTypes(339590, 339510, 339514, 339610, 339614);
        while (DateHelper.before((Date)sucheBeginnDatum, (Date)sucheEndeDatum)) {
            block5: for (ValuePosition lElement : zwVPArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), sucheBeginnDatum, DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum), vtArray)) {
                switch (lElement.getValueType().getValueTypeKey()) {
                    case 339590: {
                        this.zwPVBBG = this.zwPVBBG.add(lElement.getResult());
                        continue block5;
                    }
                    case 339510: 
                    case 339514: 
                    case 339610: 
                    case 339614: {
                        this.zwSVEntgelt = this.zwSVEntgelt.add(lElement.getResult());
                        continue block5;
                    }
                }
            }
            sucheBeginnDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum));
        }
    }
}

