/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungKurzarbeitergeldFormula {
    private static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    private static final BigDecimal BD_100 = BigDecimal.valueOf(100L);
    private static final BigDecimal BD_80 = BigDecimal.valueOf(80L);
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private final ValuePositionLibrary wplib;
    private BigDecimal mResult = ZERO;
    private ValuePosition[] vpArray;
    private BigDecimal mAusfallstunden = ZERO;
    private BigDecimal mKrankstunden = ZERO;
    private BigDecimal mKug_Brutto_Sollentgelt = ZERO;
    private BigDecimal mKug_Netto_Sollentgelt = ZERO;
    private BigDecimal mKug_Brutto_Istentgelt = ZERO;
    private BigDecimal mKug_Netto_Istentgelt = ZERO;
    private BigDecimal mAusfallProzentsatz = ZERO;
    private BigDecimal mZResult = ZERO;
    private BigDecimal mProzentsatz = ZERO;

    public ErmittlungKurzarbeitergeldFormula(CalculationLibrary calculationLibrary, EmployeeLibrary eeLibrary, GlobalLibrary glLibrary, ValuePositionLibrary valuepositionLibary) {
        this.callib = calculationLibrary;
        this.eelib = eeLibrary;
        this.gllib = glLibrary;
        this.wplib = valuepositionLibary;
    }

    public void ermittlung() throws BusinessDomainException {
        switch (this.wplib.wertartenNummer()) {
            case 230510: {
                this.ermittleKurzarbeitergeld();
                break;
            }
            case 230520: {
                if (this.eelib.marbBgrKv() != 0) {
                    this.ermittleKrankengeld();
                    break;
                }
                this.mResult = BigDecimal.ZERO;
            }
        }
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate()) && this.mResult.compareTo(ZERO) > 0) {
            this.wplib.addNeueWertPosition(99970, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mResult, true);
        }
        this.callib.percentage(this.mProzentsatz);
        this.callib.result(this.mResult);
    }

    private void ermittleKurzarbeitergeld() throws BusinessDomainException {
        this.initialisiereParamter();
        this.mResult = BigDecimal.ZERO;
        if (BigDecimalMapper.compareTo((BigDecimal)this.mKug_Brutto_Sollentgelt, (BigDecimal)this.mKug_Brutto_Istentgelt) > 0) {
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2020, 2, 1).getDate()) && DateHelper.beforeOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2022, 5, 30).getDate())) {
                BigDecimal bezugsmonate = this.ermittlungBezugsmonate();
                if (BigDecimalMapper.compareTo((BigDecimal)this.mKug_Brutto_Sollentgelt, (BigDecimal)this.mKug_Brutto_Istentgelt.multiply(BigDecimal.valueOf(2L))) >= 0 && BigDecimalMapper.compareTo((BigDecimal)bezugsmonate, (BigDecimal)BigDecimal.valueOf(4L)) >= 0) {
                    this.anpassungDerLeistungssaetze(bezugsmonate);
                }
            }
            this.mResult = this.mKug_Netto_Sollentgelt.subtract(this.mKug_Netto_Istentgelt);
            if (this.mResult.compareTo(BigDecimal.ZERO) > 0 && this.mKrankstunden.compareTo(ZERO) != 0) {
                this.mAusfallProzentsatz = this.mAusfallstunden.multiply(BD_100).divide(this.mAusfallstunden.add(this.mKrankstunden), 2, RoundingMode.HALF_UP);
                this.mResult = this.mResult.multiply(this.mAusfallProzentsatz).divide(BD_100, 2, RoundingMode.HALF_UP);
            }
        }
    }

    private void ermittleKrankengeld() throws BusinessDomainException {
        this.initialisiereParamter();
        this.mResult = this.mKug_Netto_Sollentgelt.subtract(this.mKug_Netto_Istentgelt);
        if (this.mResult.compareTo(BigDecimal.ZERO) > 0) {
            if (this.mAusfallstunden.compareTo(ZERO) != 0) {
                this.mAusfallProzentsatz = this.mAusfallstunden.multiply(BD_100).divide(this.mAusfallstunden.add(this.mKrankstunden), 2, RoundingMode.HALF_UP);
                this.mZResult = this.mResult.multiply(this.mAusfallProzentsatz).divide(BD_100, 2, RoundingMode.HALF_UP);
                this.mResult = this.mResult.subtract(this.mZResult);
            }
            if (this.eelib.marbAelterDreiUndZwanzig() && !this.eelib.isMarbKindErz()) {
                this.vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes(151010, 151110));
                BigDecimal bruttoSoll = BigDecimal.ZERO;
                BigDecimal bruttoIst = BigDecimal.ZERO;
                block4: for (ValuePosition vPos : this.vpArray) {
                    switch (vPos.getValueType().getValueTypeKey()) {
                        case 151010: {
                            bruttoSoll = bruttoSoll.add(vPos.getResult());
                            continue block4;
                        }
                        case 151110: {
                            bruttoIst = bruttoIst.add(vPos.getResult());
                            continue block4;
                        }
                    }
                }
                BigDecimal pvZuschlag = bruttoSoll.subtract(bruttoIst).multiply(this.mKrankstunden).divide(this.mAusfallstunden.add(this.mKrankstunden), 2, RoundingMode.HALF_UP).multiply(BD_80).divide(BD_100, 2, RoundingMode.HALF_UP).multiply(this.gllib.svBsKinderlosPV()).divide(BD_100, 2, RoundingMode.HALF_UP);
                this.wplib.persistentBuffer1(pvZuschlag);
                this.mResult = this.mResult.subtract(pvZuschlag);
            }
        } else {
            this.mResult = BigDecimal.ZERO;
        }
    }

    private void initialisiereParamter() throws BusinessDomainException {
        block8: for (ValuePosition lElement : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes(150110, 150115, 150120, 151020, 151120, 151010, 151110))) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 150110: 
                case 150115: {
                    if (this.eelib.marbBgrAv() == 0) {
                        throw EvaluationExceptionMapper.makeShorttimeworkWithAVBGS0DomainException();
                    }
                    if (this.eelib.kennzBestandGleitzone2022() && this.eelib.taxacation() == 5) {
                        throw EvaluationExceptionMapper.makeShorttimeworkWithFLATTAXDomainException();
                    }
                    this.mAusfallstunden = this.mAusfallstunden.add(lElement.getResult());
                    continue block8;
                }
                case 150120: {
                    if (this.eelib.marbBgrAv() == 0) {
                        throw EvaluationExceptionMapper.makeShorttimeworkWithAVBGS0DomainException();
                    }
                    if (this.eelib.kennzBestandGleitzone2022() && this.eelib.taxacation() == 5) {
                        throw EvaluationExceptionMapper.makeShorttimeworkWithFLATTAXDomainException();
                    }
                    this.mKrankstunden = this.mKrankstunden.add(lElement.getResult());
                    continue block8;
                }
                case 151020: {
                    this.mKug_Netto_Sollentgelt = this.mKug_Netto_Sollentgelt.add(lElement.getResult());
                    continue block8;
                }
                case 151120: {
                    this.mKug_Netto_Istentgelt = this.mKug_Netto_Istentgelt.add(lElement.getResult());
                    this.mProzentsatz = lElement.getPercentage();
                    continue block8;
                }
                case 151010: {
                    this.mKug_Brutto_Sollentgelt = this.mKug_Brutto_Sollentgelt.add(lElement.getResult());
                    continue block8;
                }
                case 151110: {
                    this.mKug_Brutto_Istentgelt = this.mKug_Brutto_Istentgelt.add(lElement.getResult());
                }
            }
        }
    }

    private BigDecimal ermittlungBezugsmonate() throws BusinessDomainException {
        BigDecimal bezugsmonate = BigDecimal.ZERO;
        boolean isRelevant = false;
        Date pruefMonat = DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb());
        while (DateHelper.afterOrEqual((Date)pruefMonat, (Date)new VDate(2020, 2, 1).getDate())) {
            boolean hatEntgelt = false;
            block5: for (ValuePosition lElement : this.vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)pruefMonat), DateHelper.getLastDayOfMonth((Date)pruefMonat), ValueTypeHelper.getValueTypes(230510, 150190))) {
                switch (lElement.getValueType().getValueTypeKey()) {
                    case 230510: {
                        if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getResult())) continue block5;
                        hatEntgelt = true;
                        if (!DateHelper.before((Date)pruefMonat, (Date)new VDate(2021, 3, 1).getDate())) continue block5;
                        isRelevant = true;
                        continue block5;
                    }
                    case 150190: {
                        bezugsmonate = bezugsmonate.add(lElement.getResult());
                        if (BigDecimalMapper.isZero((BigDecimal)lElement.getResult()) || !DateHelper.afterOrEqual((Date)pruefMonat, (Date)new VDate(2021, 3, 1).getDate())) continue block5;
                        isRelevant = true;
                    }
                }
            }
            if (hatEntgelt) {
                bezugsmonate = bezugsmonate.add(BigDecimal.ONE);
            }
            pruefMonat = DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)pruefMonat));
        }
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2022, 0, 1).getDate()) && BigDecimalMapper.compareTo((BigDecimal)bezugsmonate, (BigDecimal)BigDecimal.valueOf(4L)) >= 0) {
            isRelevant = true;
        }
        this.wplib.factor1(bezugsmonate);
        return isRelevant ? bezugsmonate : BigDecimal.ZERO;
    }

    private void anpassungDerLeistungssaetze(BigDecimal bezugsmonate) throws BusinessDomainException {
        BigDecimal erhoehterleistungssatz;
        BigDecimal leistungssatz;
        if (BigDecimalMapper.compareTo((BigDecimal)bezugsmonate, (BigDecimal)BigDecimal.valueOf(7L)) >= 0) {
            leistungssatz = BigDecimal.valueOf(80L);
            erhoehterleistungssatz = BigDecimal.valueOf(87L);
        } else {
            leistungssatz = BigDecimal.valueOf(70L);
            erhoehterleistungssatz = BigDecimal.valueOf(77L);
        }
        block3: for (ValuePosition lElement : this.vpArray = this.wplib.genesisUndFolgen()) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 151020: 
                case 151120: {
                    this.mProzentsatz = BigDecimalMapper.compareTo((BigDecimal)lElement.getPercentage(), (BigDecimal)BigDecimal.valueOf(60L)) == 0 ? leistungssatz : erhoehterleistungssatz;
                    lElement.setResult(lElement.getPersistentBuffer1().multiply(this.mProzentsatz).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP));
                    lElement.setPercentage(this.mProzentsatz);
                    lElement.setFactor1(bezugsmonate);
                    if (lElement.getValueType().getValueTypeKey() == 151020) {
                        this.mKug_Netto_Sollentgelt = lElement.getResult();
                        continue block3;
                    }
                    this.mKug_Netto_Istentgelt = lElement.getResult();
                }
            }
        }
    }
}

