/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.ErmittlungGleitzonenEntgeltFormula;
import com.varial.personnel.domain.evaluation.formula.ErmittlungKVEntgeltGleitzone2022Formula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungKVEntgeltGleitzoneFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mEntgeltAbwAG = BigDecimal.ZERO;
    private BigDecimal mEntgeltEGAAbwAG = BigDecimal.ZERO;
    private BigDecimal mEntgeltLfdAbwAG = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltEGA = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltLfd = BigDecimal.ZERO;
    private BigDecimal mKVBBG = BigDecimal.ZERO;
    private BigDecimal zwKVBBG = BigDecimal.ZERO;
    private BigDecimal zwSVEntgelt = BigDecimal.ZERO;
    private BigDecimal mKVBemessungsentgelt = BigDecimal.ZERO;

    public ErmittlungKVEntgeltGleitzoneFormula(CalculationLibrary caLibrary, EmployeeLibrary eeLibrary, GlobalLibrary glLibrary, ValuePositionLibrary vpLibrary) {
        this.mCalLib = caLibrary;
        this.mEeLib = eeLibrary;
        this.mGlLib = glLibrary;
        this.mVpLib = vpLibrary;
    }

    public void ermittel() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2022, 9, 1).getDate()) && !this.mEeLib.kennzBestandGleitzone2022()) {
            new ErmittlungKVEntgeltGleitzone2022Formula(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib).ermittel();
        } else {
            ValuePosition genesis;
            BigDecimal result = this.mVpLib.result();
            BigDecimal kvTage = this.mVpLib.kvTageMarb();
            this.ermittleKVEntgeltImMonat();
            BigDecimal entgeltAufgelaufen = this.mGesEntgeltLfd.add(this.mGesEntgeltEGA);
            switch (this.mVpLib.wertartenNummer()) {
                case 321514: {
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.add(result);
                    break;
                }
                case 321614: {
                    this.mGesEntgeltEGA = this.mGesEntgeltEGA.add(result);
                }
            }
            this.mKVBBG = this.mGlLib.svBbgKvPv().multiply(kvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
            if (this.mGesEntgeltEGA.compareTo(BigDecimal.ZERO) != 0) {
                this.abgrenzungEGA();
            }
            this.mVpLib.addNeueWertPosition(321590, BigDecimal.ZERO, BigDecimal.ZERO, kvTage, BigDecimal.ZERO, this.mKVBBG, true);
            this.modifikationTeilLZZ(kvTage);
            BigDecimal gesEntgelt = this.mGesEntgeltLfd.add(this.mGesEntgeltEGA);
            if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && this.mCalLib.dbgzVorhanden()) {
                if (this.mCalLib.dbgzSVTG() == 0) {
                    throw EvaluationExceptionMapper.makeZeroDaysInDbgzNotAllowedDomainException(this.mCalLib.berchnungGueltigAb());
                }
                if (this.mCalLib.dbgzSVTG() != 30) {
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(BigDecimal.valueOf(this.mCalLib.dbgzSVTG()), 2, RoundingMode.HALF_UP);
                }
            }
            if (this.mCalLib.dbgzVorhanden()) {
                if (this.mCalLib.dbgzKennzGLZ().value() == 1 || this.mCalLib.dbgzKennzGLZ().value() == 3) {
                    this.mEntgeltAbwAG = this.mEntgeltLfdAbwAG.add(this.mEntgeltEGAAbwAG);
                }
            } else if (this.mEeLib.isMehrfachbeschaeftigt() && this.mEeLib.marbBgrKvAndererAG() != 0 && this.mEeLib.marbBgrKvAndererAG() != 9) {
                this.mEntgeltAbwAG = this.mEntgeltLfdAbwAG.add(this.mEntgeltEGAAbwAG);
            }
            BigDecimal tempKvTage = kvTage;
            if (BigDecimalMapper.isZero((BigDecimal)kvTage) && (genesis = this.mVpLib.genesisParent()) != null) {
                ValuePosition[] vpos;
                for (ValuePosition vp : vpos = this.mVpLib.genesisUndFolgen()) {
                    if (vp.getValueType().getValueTypeKey() != 130610) continue;
                    tempKvTage = BigDecimal.valueOf(30L);
                }
            }
            ErmittlungGleitzonenEntgeltFormula gleitzonenEntgeltFormula = new ErmittlungGleitzonenEntgeltFormula(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib);
            BigDecimal beitrPflEinnahmeGesamt = gleitzonenEntgeltFormula.getEntgeltGleitzone(gesEntgelt, this.mEntgeltAbwAG, tempKvTage);
            if (kvTage.compareTo(BigDecimal.ZERO) != 0) {
                if (this.mVpLib.wertartenNummer() == 321614) {
                    gesEntgelt = gesEntgelt.subtract(result);
                    gesEntgelt = gesEntgelt.multiply(kvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                    gesEntgelt = gesEntgelt.add(result);
                } else {
                    gesEntgelt = gesEntgelt.multiply(kvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                }
            }
            BigDecimal beitrPflEinnahme = beitrPflEinnahmeGesamt.subtract(this.mKVBemessungsentgelt);
            BigDecimal beitrPflGesamt = gesEntgelt.subtract(entgeltAufgelaufen);
            this.erzeugeWertpositionen(beitrPflEinnahme, beitrPflGesamt, kvTage);
            this.mCalLib.result(result);
        }
    }

    private void abgrenzungEGA() throws BusinessDomainException {
        this.zwKVBBG = this.mKVBBG;
        this.zwSVEntgelt = BigDecimal.ZERO;
        this.zwSVEntgelt = this.mCalLib.dbgzVorhanden() ? (this.mCalLib.dbgzKennzGLZ().value() == 1 || this.mCalLib.dbgzKennzGLZ().value() == 3 ? this.mGesEntgeltLfd.add(this.mEntgeltLfdAbwAG).add(this.mEntgeltEGAAbwAG) : this.mGesEntgeltLfd) : (this.mEeLib.isMehrfachbeschaeftigt() && this.mEeLib.marbBgrKvAndererAG() != 0 ? this.mGesEntgeltLfd.add(this.mEntgeltLfdAbwAG).add(this.mEntgeltEGAAbwAG) : this.mGesEntgeltLfd);
        if (this.zwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.zwKVBBG) > 0) {
            this.holeJahresWerte();
            if (this.zwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.zwKVBBG) > 0) {
                this.mGesEntgeltEGA = this.zwSVEntgelt.compareTo(this.zwKVBBG) < 0 ? this.zwKVBBG.subtract(this.zwSVEntgelt) : BigDecimal.ZERO;
            }
        }
    }

    private void modifikationTeilLZZ(BigDecimal kvTage) throws BusinessDomainException {
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                if (kvTage.compareTo(BigDecimal.ZERO) != 0) {
                    this.mGesEntgeltLfd = this.mVpLib.hochrechnungGleitzonenEntgeltBeiLZZ(this.mGesEntgeltLfd, kvTage);
                    this.mEntgeltLfdAbwAG = this.mVpLib.hochrechnungGleitzonenEntgeltBeiLZZ(this.mEntgeltLfdAbwAG, kvTage);
                } else if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                    this.mGesEntgeltLfd = BigDecimal.ZERO;
                    this.mEntgeltLfdAbwAG = BigDecimal.ZERO;
                }
            } else if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate())) {
                if (kvTage.compareTo(BigDecimal.ZERO) != 0) {
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(kvTage, 2, RoundingMode.HALF_UP);
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(kvTage, 2, RoundingMode.HALF_UP);
                }
            } else if (this.mVpLib.tageMitEFZ().compareTo(BigDecimal.ZERO) != 0) {
                this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(this.mVpLib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
                this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(this.mVpLib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
            }
        }
    }

    private void ermittleKVEntgeltImMonat() throws BusinessDomainException {
        ValuePosition[] vpArray;
        block7: for (ValuePosition lElement : vpArray = this.sammleValuePosition(new int[]{129200, 129205, 129210, 129215, 321514, 321614, 321616})) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 129200: 
                case 129205: {
                    if ((this.mEeLib.marbBgrKvAndererAG() == 0 || this.mEeLib.marbBgrKvAndererAG() == 6 || this.mEeLib.marbBgrKvAndererAG() == 9) && !this.mCalLib.dbgzVorhanden()) continue block7;
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.add(lElement.getResult());
                    continue block7;
                }
                case 129210: 
                case 129215: {
                    if ((this.mEeLib.marbBgrKvAndererAG() == 0 || this.mEeLib.marbBgrKvAndererAG() == 6 || this.mEeLib.marbBgrKvAndererAG() == 9) && !this.mCalLib.dbgzVorhanden()) continue block7;
                    this.mEntgeltEGAAbwAG = this.mEntgeltEGAAbwAG.add(lElement.getResult());
                    continue block7;
                }
                case 321514: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getBufferResult())) continue block7;
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.add(lElement.getBufferResult());
                    continue block7;
                }
                case 321614: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getBufferResult())) continue block7;
                    this.mGesEntgeltEGA = this.mGesEntgeltEGA.add(lElement.getBufferResult());
                    continue block7;
                }
                case 321616: {
                    this.mKVBemessungsentgelt = this.mKVBemessungsentgelt.add(lElement.getResult());
                    continue block7;
                }
            }
        }
    }

    private void erzeugeWertpositionen(BigDecimal beitrPflEinnahme, BigDecimal gesEntgelt, BigDecimal kvTage) throws BusinessDomainException {
        boolean kugFeiertagsentgelt = false;
        ValuePosition genesisVP = this.mVpLib.genesisParent();
        if (genesisVP.getValueType().getValueTypeKey() == 99973) {
            kugFeiertagsentgelt = true;
        }
        if (kugFeiertagsentgelt) {
            this.mVpLib.addNeueWertPosition(323514, gesEntgelt, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
            this.mVpLib.addNeueWertPosition(323516, gesEntgelt, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
        } else {
            this.mVpLib.addNeueWertPosition(322514, gesEntgelt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
            this.mVpLib.addNeueWertPosition(323514, gesEntgelt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
            if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2005, 6, 1).getDate())) {
                this.mVpLib.addNeueWertPosition(322518, gesEntgelt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
                if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                    this.mVpLib.addNeueWertPosition(323516, gesEntgelt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
                }
            } else {
                new CalculationBasic(this.mEeLib.marb(), this.mVpLib.wirksamAb(), new VDate(2005, 6, 1).getDate(), this.getClass().getName());
            }
        }
        this.mVpLib.addNeueWertPosition(321616, BigDecimal.ZERO, BigDecimal.ZERO, kvTage, BigDecimal.ZERO, beitrPflEinnahme, false);
    }

    private ValueType[] getValueTypes(int[] vtNumbers) {
        ValueType[] vtArray = new ValueType[vtNumbers.length];
        for (int i = 0; i < vtNumbers.length; ++i) {
            vtArray[i] = ValueType.getValueType((int)vtNumbers[i]);
        }
        return vtArray;
    }

    private void holeJahresWerte() throws BusinessDomainException {
        ValuePosition[] zwVPArray = null;
        Date sucheBeginnDatum = DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb());
        Date sucheEndeDatum = DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb());
        ValueType[] vtArray = this.getValueTypes(new int[]{321590, 321510, 321514, 321610, 321614});
        while (DateHelper.before((Date)sucheBeginnDatum, (Date)sucheEndeDatum)) {
            block5: for (ValuePosition lElement : zwVPArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), sucheBeginnDatum, DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum), vtArray)) {
                switch (lElement.getValueType().getValueTypeKey()) {
                    case 321590: {
                        this.zwKVBBG = this.zwKVBBG.add(lElement.getResult());
                        continue block5;
                    }
                    case 321510: 
                    case 321514: 
                    case 321610: 
                    case 321614: {
                        this.zwSVEntgelt = this.zwSVEntgelt.add(lElement.getResult());
                        continue block5;
                    }
                }
            }
            sucheBeginnDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum));
        }
    }

    private ValuePosition[] sammleValuePosition(int[] vtNumbers) throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), this.getValueTypes(vtNumbers));
    }
}

