/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.evaluation.formula.LohnsteuerErmittlung2016Formula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.serverbase.basictypes.VDate;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungKUGWAG2016Formula {
    private static final BigDecimal BD_1000 = BigDecimal.valueOf(1000L);
    private static final BigDecimal BD_2000 = BigDecimal.valueOf(2000L);
    private static final BigDecimal BD_100 = BigDecimal.valueOf(100L);
    private static CalculationLibrary callib;
    private static EmployeeLibrary eelib;
    private static GlobalLibrary gllib;
    private BigDecimal bbgr;
    private BigDecimal solzp;
    private BigDecimal glohn;
    private BigDecimal abz;

    public ErmittlungKUGWAG2016Formula(CalculationLibrary calLib, EmployeeLibrary eeLib, GlobalLibrary glLib) {
        callib = calLib;
        eelib = eeLib;
        gllib = glLib;
    }

    public void start(BigDecimal bent, BigDecimal glohnSoll, boolean sollberechnung, boolean kommtAusVerdienstausfall) throws BusinessDomainException {
        if (bent.compareTo(BigDecimal.ZERO) <= 0) {
            callib.kugNetEnt(BigDecimal.ZERO);
            return;
        }
        this.solzp = DateHelper.afterOrEqual((Date)callib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate()) ? BigDecimal.valueOf(20L) : BigDecimal.valueOf(21L);
        this.glohn = bent.add(BD_1000);
        this.glohn = this.glohn.divide(BD_2000, 0, RoundingMode.DOWN).multiply(BD_2000);
        this.bbgr = gllib.svBbgRvAv().movePointRight(2);
        this.bbgr = this.bbgr.add(BD_1000);
        this.bbgr = this.bbgr.divide(BD_2000, 0, RoundingMode.DOWN).multiply(BD_2000);
        if (!kommtAusVerdienstausfall && this.glohn.compareTo(this.bbgr) > 0) {
            this.glohn = this.bbgr;
        }
        eelib.lzz(2);
        callib.re4(this.glohn);
        new LohnsteuerErmittlung2016Formula(callib, eelib, gllib, true).lst2016();
        this.abz = callib.lstlzz();
        this.abz = this.abz.add(callib.solzlzz());
        switch (eelib.marbPgs()) {
            case 102: 
            case 105: 
            case 121: 
            case 122: {
                if (this.glohn.compareTo(gllib.svGeringverdienerGrenze()) <= 0 && (sollberechnung || glohnSoll.compareTo(gllib.svGeringverdienerGrenze()) <= 0)) break;
            }
            default: {
                this.abz = this.glohn.compareTo(this.bbgr) > 0 ? this.abz.add(this.solzp.multiply(this.bbgr).divide(BD_100, 0, RoundingMode.HALF_UP)) : this.abz.add(this.solzp.multiply(this.glohn).divide(BD_100, 0, RoundingMode.HALF_UP));
            }
        }
        callib.kugNetEnt(this.glohn.subtract(this.abz));
    }
}

