/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.ErmittlungGleitzonenEntgeltFormula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungInsGEntgeltGleitzoneFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mEntgeltAbwAG = BigDecimal.ZERO;
    private BigDecimal mEntgeltEGAAbwAG = BigDecimal.ZERO;
    private BigDecimal mEntgeltLfdAbwAG = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltEGA = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltLfd = BigDecimal.ZERO;
    private BigDecimal mInsGBBG = BigDecimal.ZERO;
    private BigDecimal zwInsGBBG = BigDecimal.ZERO;
    private BigDecimal zwSVEntgelt = BigDecimal.ZERO;

    public ErmittlungInsGEntgeltGleitzoneFormula(CalculationLibrary caLibrary, EmployeeLibrary eeLibrary, GlobalLibrary glLibrary, ValuePositionLibrary vpLibrary) {
        this.mCalLib = caLibrary;
        this.mEeLib = eeLibrary;
        this.mGlLib = glLibrary;
        this.mVpLib = vpLibrary;
    }

    public void ermittel() throws BusinessDomainException {
        BigDecimal result = this.mVpLib.result();
        BigDecimal insGTage = this.mVpLib.insGTageMarb();
        BigDecimal mINSGBemessungsEntgelt = this.ermittleInsGEntgeltImMonat();
        this.mInsGBBG = this.mGlLib.svBbgRvAv().multiply(insGTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        if (this.mGesEntgeltEGA.compareTo(BigDecimal.ZERO) != 0) {
            this.abgrenzungEGA();
        }
        this.mVpLib.addNeueWertPosition(365590, BigDecimal.ZERO, BigDecimal.ZERO, insGTage, BigDecimal.ZERO, this.mInsGBBG, true);
        this.modifikationTeilLZZ(insGTage);
        if (mINSGBemessungsEntgelt.compareTo(BigDecimal.ZERO) == 0) {
            ValuePosition genesis;
            BigDecimal gesEntgelt = this.mGesEntgeltLfd.add(this.mGesEntgeltEGA);
            if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && this.mCalLib.dbgzVorhanden()) {
                if (this.mCalLib.dbgzSVTG() == 0) {
                    throw EvaluationExceptionMapper.makeZeroDaysInDbgzNotAllowedDomainException(this.mCalLib.berchnungGueltigAb());
                }
                if (this.mCalLib.dbgzSVTG() != 30) {
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(BigDecimal.valueOf(this.mCalLib.dbgzSVTG()), 2, RoundingMode.HALF_UP);
                }
            }
            if (this.mCalLib.dbgzVorhanden()) {
                if (this.mCalLib.dbgzKennzGLZ().value() == 1 || this.mCalLib.dbgzKennzGLZ().value() == 3) {
                    this.mEntgeltAbwAG = this.mEntgeltLfdAbwAG.add(this.mEntgeltEGAAbwAG);
                }
            } else if (this.mEeLib.isMehrfachbeschaeftigt() && this.mEeLib.marbBgrRvAndererAG() != 0) {
                this.mEntgeltAbwAG = this.mEntgeltLfdAbwAG.add(this.mEntgeltEGAAbwAG);
            }
            BigDecimal tempInsGTage = insGTage;
            if (BigDecimalMapper.isZero((BigDecimal)insGTage) && (genesis = this.mVpLib.genesisParent()) != null) {
                ValuePosition[] vpos;
                for (ValuePosition vp : vpos = this.mVpLib.genesisUndFolgen()) {
                    if (vp.getValueType().getValueTypeKey() != 130610) continue;
                    tempInsGTage = BigDecimal.valueOf(30L);
                }
            }
            BigDecimal beitrPflEinnahme = gesEntgelt;
            if (!this.mEeLib.kennzBestandGleitzone2022()) {
                ErmittlungGleitzonenEntgeltFormula gleitzonenEntgeltFormula = new ErmittlungGleitzonenEntgeltFormula(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib);
                beitrPflEinnahme = gleitzonenEntgeltFormula.getEntgeltGleitzone(gesEntgelt, this.mEntgeltAbwAG, tempInsGTage);
            }
            this.erzeugeWertpositionen(beitrPflEinnahme, insGTage);
        }
        this.mCalLib.result(result);
    }

    private void abgrenzungEGA() throws BusinessDomainException {
        this.zwInsGBBG = this.mInsGBBG;
        this.zwSVEntgelt = BigDecimal.ZERO;
        this.zwSVEntgelt = this.mCalLib.dbgzVorhanden() ? (this.mCalLib.dbgzKennzGLZ().value() == 1 || this.mCalLib.dbgzKennzGLZ().value() == 3 ? this.mGesEntgeltLfd.add(this.mEntgeltLfdAbwAG).add(this.mEntgeltEGAAbwAG) : this.mGesEntgeltLfd) : (this.mEeLib.isMehrfachbeschaeftigt() && this.mEeLib.isMarbInsGPflAndererAG() ? this.mGesEntgeltLfd.add(this.mEntgeltLfdAbwAG).add(this.mEntgeltEGAAbwAG) : this.mGesEntgeltLfd);
        if (this.zwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.zwInsGBBG) > 0) {
            this.holeJahresWerte();
            if (this.zwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.zwInsGBBG) > 0) {
                this.mGesEntgeltEGA = this.zwSVEntgelt.compareTo(this.zwInsGBBG) < 0 ? this.zwInsGBBG.subtract(this.zwSVEntgelt) : BigDecimal.ZERO;
            }
        }
    }

    private void modifikationTeilLZZ(BigDecimal insGTage) throws BusinessDomainException {
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                if (insGTage.compareTo(BigDecimal.ZERO) != 0) {
                    this.mGesEntgeltLfd = this.mVpLib.hochrechnungGleitzonenEntgeltBeiLZZ(this.mGesEntgeltLfd, insGTage);
                    this.mEntgeltLfdAbwAG = this.mVpLib.hochrechnungGleitzonenEntgeltBeiLZZ(this.mEntgeltLfdAbwAG, insGTage);
                } else if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                    this.mGesEntgeltLfd = BigDecimal.ZERO;
                    this.mEntgeltLfdAbwAG = BigDecimal.ZERO;
                }
            } else if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate())) {
                if (insGTage.compareTo(BigDecimal.ZERO) != 0) {
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(insGTage, 2, RoundingMode.HALF_UP);
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(insGTage, 2, RoundingMode.HALF_UP);
                }
            } else if (this.mVpLib.tageMitEFZ().compareTo(BigDecimal.ZERO) != 0) {
                this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(this.mVpLib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
                this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(this.mVpLib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
            }
        }
    }

    private BigDecimal ermittleInsGEntgeltImMonat() throws BusinessDomainException {
        ValuePosition[] vpArray = this.sammleValuePosition(ValueTypeHelper.getValueTypes(129200, 129205, 129210, 129215, 365514, 365614, 365616));
        BigDecimal mINSGBemessungsEntgelt = BigDecimal.ZERO;
        block7: for (ValuePosition lElement : vpArray) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 129200: 
                case 129205: {
                    if ((this.mEeLib.marbBgrRvAndererAG() == 0 || this.mEeLib.marbBgrRvAndererAG() == 5) && !this.mCalLib.dbgzVorhanden()) continue block7;
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.add(lElement.getResult());
                    continue block7;
                }
                case 129210: 
                case 129215: {
                    if ((this.mEeLib.marbBgrRvAndererAG() == 0 || this.mEeLib.marbBgrRvAndererAG() == 5) && !this.mCalLib.dbgzVorhanden()) continue block7;
                    this.mEntgeltEGAAbwAG = this.mEntgeltEGAAbwAG.add(lElement.getResult());
                    continue block7;
                }
                case 365514: {
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.add(lElement.getResult());
                    continue block7;
                }
                case 365614: {
                    this.mGesEntgeltEGA = this.mGesEntgeltEGA.add(lElement.getResult());
                    continue block7;
                }
                case 365616: {
                    mINSGBemessungsEntgelt = mINSGBemessungsEntgelt.add(lElement.getResult());
                    continue block7;
                }
            }
        }
        return mINSGBemessungsEntgelt;
    }

    private void erzeugeWertpositionen(BigDecimal beitrPflEinnahme, BigDecimal insGTage) throws BusinessDomainException {
        this.mVpLib.addNeueWertPosition(365616, BigDecimal.ZERO, BigDecimal.ZERO, insGTage, BigDecimal.ZERO, beitrPflEinnahme, true);
        this.mVpLib.addNeueWertPosition(366510, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, true);
    }

    private void holeJahresWerte() throws BusinessDomainException {
        ValuePosition[] zwVPArray = null;
        Date sucheBeginnDatum = DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb());
        Date sucheEndeDatum = DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb());
        ValueType[] vtArray = ValueTypeHelper.getValueTypes(365590, 365591, 365510, 365511, 365514, 365610, 365614);
        while (DateHelper.before((Date)sucheBeginnDatum, (Date)sucheEndeDatum)) {
            block5: for (ValuePosition lElement : zwVPArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), sucheBeginnDatum, DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum), vtArray)) {
                switch (lElement.getValueType().getValueTypeKey()) {
                    case 365590: 
                    case 365591: {
                        this.zwInsGBBG = this.zwInsGBBG.add(lElement.getResult());
                        continue block5;
                    }
                    case 365510: 
                    case 365511: 
                    case 365514: 
                    case 365610: 
                    case 365614: {
                        this.zwSVEntgelt = this.zwSVEntgelt.add(lElement.getResult());
                        continue block5;
                    }
                }
            }
            sucheBeginnDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum));
        }
    }

    private ValuePosition[] sammleValuePosition(ValueType ... vts) throws BusinessDomainException {
        return this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), vts);
    }
}

