/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.serverbase.basictypes.VDate;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungGleitzonenEntgeltFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private static final BigDecimal ZWEI = BigDecimal.valueOf(2L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVplib;
    private BigDecimal mF;
    private BigDecimal mGU;
    private BigDecimal mGO;

    public ErmittlungGleitzonenEntgeltFormula(CalculationLibrary caLibrary, EmployeeLibrary eeLibrary, GlobalLibrary glLibrary, ValuePositionLibrary wpLibrary) throws BusinessDomainException {
        this.mCalLib = caLibrary;
        this.mEeLib = eeLibrary;
        this.mGlLib = glLibrary;
        this.mVplib = wpLibrary;
    }

    public BigDecimal getEntgeltGleitzone(BigDecimal gesEntgelt, BigDecimal entgeltAbwAG, BigDecimal svTage) throws BusinessDomainException {
        boolean kennzBestandGleitzone = this.mEeLib.kennzBestandGleitzone();
        Date validDateGleitzone = this.mCalLib.berchnungGueltigAb();
        if (this.mEeLib.kennzBestandGleitzone2022()) {
            validDateGleitzone = new VDate(2022, 8, 1).getDate();
        }
        this.mF = this.mGlLib.svFaktorGleitzonenregelung(validDateGleitzone);
        BigDecimal svGleitzonenUntergrenze = this.mGlLib.svGleitzonenUntergrenze(validDateGleitzone);
        this.mGU = svGleitzonenUntergrenze.subtract(BigDecimal.valueOf(1L, 2));
        this.mGO = this.mGlLib.svGleitzonenObergrenze(validDateGleitzone);
        BigDecimal gleitzonenEntgelt = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
            if (entgeltAbwAG.compareTo(BigDecimal.ZERO) == 0) {
                if (gesEntgelt.compareTo(svGleitzonenUntergrenze) < 0) {
                    if (kennzBestandGleitzone) {
                        this.mGU = BigDecimal.valueOf(400L);
                        gleitzonenEntgelt = gesEntgelt.compareTo(this.mGU) > 0 ? this.getEntgeltGleitzoneBis2012(gesEntgelt, svTage) : this.getEntgeltUnterhalbGleitzone(gesEntgelt, svTage);
                    } else {
                        gleitzonenEntgelt = this.getEntgeltUnterhalbGleitzone(gesEntgelt, svTage);
                    }
                } else {
                    gleitzonenEntgelt = this.getEntgeltGleitzoneAb2013(gesEntgelt, svTage);
                }
            } else if (gesEntgelt.add(entgeltAbwAG).compareTo(svGleitzonenUntergrenze) < 0) {
                if (kennzBestandGleitzone) {
                    this.mGU = BigDecimal.valueOf(400L);
                    gleitzonenEntgelt = gesEntgelt.compareTo(this.mGU) > 0 ? this.getEntgeltGleitzoneBis2012MfB(gesEntgelt, entgeltAbwAG, svTage) : this.getEntgeltUnterhalbGleitzoneMfB(gesEntgelt, entgeltAbwAG, svTage);
                } else {
                    gleitzonenEntgelt = this.getEntgeltUnterhalbGleitzoneMfB(gesEntgelt, entgeltAbwAG, svTage);
                }
            } else {
                gleitzonenEntgelt = this.getEntgeltGleitzoneAb2013MfB(gesEntgelt, entgeltAbwAG, svTage);
            }
        } else {
            gleitzonenEntgelt = entgeltAbwAG.compareTo(BigDecimal.ZERO) == 0 ? (gesEntgelt.compareTo(svGleitzonenUntergrenze) < 0 ? this.getEntgeltUnterhalbGleitzone(gesEntgelt, svTage) : this.getEntgeltGleitzoneBis2012(gesEntgelt, svTage)) : (gesEntgelt.add(entgeltAbwAG).compareTo(svGleitzonenUntergrenze) < 0 ? this.getEntgeltUnterhalbGleitzoneMfB(gesEntgelt, entgeltAbwAG, svTage) : this.getEntgeltGleitzoneBis2012MfB(gesEntgelt, entgeltAbwAG, svTage));
        }
        return gleitzonenEntgelt;
    }

    public BigDecimal getEntgeltGleitzoneAN(BigDecimal gesEntgelt, BigDecimal entgeltAbwAG, BigDecimal svTage) throws BusinessDomainException {
        BigDecimal svGleitzonenUntergrenze = this.mGlLib.svGleitzonenUntergrenze(this.mCalLib.berchnungGueltigAb());
        this.mGU = svGleitzonenUntergrenze.subtract(BigDecimal.valueOf(1L, 2));
        this.mGO = this.mGlLib.svGleitzonenObergrenze(this.mCalLib.berchnungGueltigAb());
        BigDecimal gleitzonenEntgelt = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2022, 9, 1).getDate())) {
            if (entgeltAbwAG.compareTo(BigDecimal.ZERO) == 0) {
                if (gesEntgelt.compareTo(svGleitzonenUntergrenze) >= 0) {
                    gleitzonenEntgelt = this.getEntgeltGleitzoneAN(gesEntgelt, svTage);
                }
            } else if (gesEntgelt.add(entgeltAbwAG).compareTo(svGleitzonenUntergrenze) >= 0) {
                gleitzonenEntgelt = this.getEntgeltGleitzoneANMfB(gesEntgelt, entgeltAbwAG, svTage);
            }
        }
        return gleitzonenEntgelt;
    }

    private BigDecimal getEntgeltGleitzoneBis2012MfB(BigDecimal arbeitsentgelt, BigDecimal entgeltAbwAG, BigDecimal svTage) throws BusinessDomainException {
        BigDecimal beitrPflEinnahme = BigDecimal.ZERO;
        BigDecimal F = this.mF;
        BigDecimal GU = this.mGU;
        BigDecimal AE = arbeitsentgelt;
        BigDecimal GAE = arbeitsentgelt.add(entgeltAbwAG);
        beitrPflEinnahme = F.multiply(GU).add(ZWEI.subtract(F).multiply(GAE.subtract(GU))).multiply(AE).divide(GAE, 2, RoundingMode.HALF_UP);
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            if (DateHelper.afterOrEqual((Date)this.mVplib.gueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                if (svTage.compareTo(BigDecimal.ZERO) != 0) {
                    beitrPflEinnahme = beitrPflEinnahme.multiply(svTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                }
            } else {
                beitrPflEinnahme = DateHelper.before((Date)this.mVplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) ? beitrPflEinnahme.multiply(svTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : beitrPflEinnahme.multiply(this.mVplib.tageMitEFZ()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
            }
        }
        return beitrPflEinnahme;
    }

    private BigDecimal getEntgeltGleitzoneAb2013MfB(BigDecimal arbeitsentgelt, BigDecimal entgeltAbwAG, BigDecimal svTage) throws BusinessDomainException {
        BigDecimal beitrPflEinnahme = BigDecimal.ZERO;
        BigDecimal F = this.mF;
        BigDecimal GU = this.mGU;
        BigDecimal GO = this.mGO;
        BigDecimal AE = arbeitsentgelt;
        BigDecimal GAE = arbeitsentgelt.add(entgeltAbwAG);
        beitrPflEinnahme = F.multiply(GU).add(GO.divide(GO.subtract(GU), 6, RoundingMode.HALF_UP).subtract(GU.divide(GO.subtract(GU), 6, RoundingMode.HALF_UP).multiply(F)).multiply(GAE.subtract(GU))).multiply(AE).divide(GAE, 2, RoundingMode.HALF_UP);
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            beitrPflEinnahme = svTage.compareTo(BigDecimal.ZERO) != 0 ? this.mVplib.kuerzungGleitzonenEntgeltBeiLZZ(beitrPflEinnahme, svTage) : BigDecimal.ZERO;
        }
        return beitrPflEinnahme;
    }

    private BigDecimal getEntgeltGleitzoneANMfB(BigDecimal arbeitsentgelt, BigDecimal entgeltAbwAG, BigDecimal svTage) throws BusinessDomainException {
        BigDecimal beitrPflEinnahme = BigDecimal.ZERO;
        BigDecimal F = this.mF;
        BigDecimal GU = this.mGU;
        BigDecimal GO = this.mGO;
        BigDecimal AE = arbeitsentgelt;
        BigDecimal GAE = arbeitsentgelt.add(entgeltAbwAG);
        beitrPflEinnahme = GO.divide(GO.subtract(GU), 6, RoundingMode.HALF_UP).multiply(GAE.subtract(GU)).multiply(AE).divide(GAE, 2, RoundingMode.HALF_UP);
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            beitrPflEinnahme = svTage.compareTo(BigDecimal.ZERO) != 0 ? this.mVplib.kuerzungGleitzonenEntgeltBeiLZZ(beitrPflEinnahme, svTage) : BigDecimal.ZERO;
        }
        return beitrPflEinnahme;
    }

    private BigDecimal getEntgeltGleitzoneBis2012(BigDecimal arbeitsentgelt, BigDecimal svTage) throws BusinessDomainException {
        BigDecimal beitrPflEinnahme = BigDecimal.ZERO;
        BigDecimal F = this.mF;
        BigDecimal GU = this.mGU;
        BigDecimal AE = arbeitsentgelt;
        beitrPflEinnahme = DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate()) ? F.multiply(GU).add(ZWEI.subtract(F).multiply(AE.subtract(GU))).setScale(2, RoundingMode.HALF_UP) : F.multiply(GU).add(ZWEI.subtract(F).multiply(AE.subtract(GU)));
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            if (DateHelper.afterOrEqual((Date)this.mVplib.gueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                if (svTage.compareTo(BigDecimal.ZERO) != 0) {
                    beitrPflEinnahme = beitrPflEinnahme.multiply(svTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                }
            } else {
                beitrPflEinnahme = DateHelper.before((Date)this.mVplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) ? beitrPflEinnahme.multiply(svTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : beitrPflEinnahme.multiply(this.mVplib.tageMitEFZ()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
            }
        }
        return beitrPflEinnahme;
    }

    private BigDecimal getEntgeltGleitzoneAb2013(BigDecimal arbeitsentgelt, BigDecimal svTage) throws BusinessDomainException {
        BigDecimal beitrPflEinnahme = BigDecimal.ZERO;
        BigDecimal F = this.mF;
        BigDecimal GU = this.mGU;
        BigDecimal GO = this.mGO;
        BigDecimal AE = arbeitsentgelt;
        beitrPflEinnahme = F.multiply(GU).add(GO.divide(GO.subtract(GU), 6, RoundingMode.HALF_UP).subtract(GU.divide(GO.subtract(GU), 6, RoundingMode.HALF_UP).multiply(F)).multiply(AE.subtract(GU))).setScale(2, RoundingMode.HALF_UP);
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            beitrPflEinnahme = svTage.compareTo(BigDecimal.ZERO) != 0 ? this.mVplib.kuerzungGleitzonenEntgeltBeiLZZ(beitrPflEinnahme, svTage) : BigDecimal.ZERO;
        }
        return beitrPflEinnahme;
    }

    private BigDecimal getEntgeltGleitzoneAN(BigDecimal arbeitsentgelt, BigDecimal svTage) throws BusinessDomainException {
        BigDecimal beitrPflEinnahme = BigDecimal.ZERO;
        BigDecimal GU = this.mGU;
        BigDecimal GO = this.mGO;
        BigDecimal AE = arbeitsentgelt;
        beitrPflEinnahme = GO.divide(GO.subtract(GU), 6, RoundingMode.HALF_UP).multiply(AE.subtract(GU)).setScale(2, RoundingMode.HALF_UP);
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            beitrPflEinnahme = svTage.compareTo(BigDecimal.ZERO) != 0 ? this.mVplib.kuerzungGleitzonenEntgeltBeiLZZ(beitrPflEinnahme, svTage) : BigDecimal.ZERO;
        }
        return beitrPflEinnahme;
    }

    private BigDecimal getEntgeltUnterhalbGleitzone(BigDecimal arbeitsentgelt, BigDecimal svTage) throws BusinessDomainException {
        BigDecimal beitrPflEinnahme = BigDecimal.ZERO;
        BigDecimal F = this.mF;
        BigDecimal AE = arbeitsentgelt;
        beitrPflEinnahme = DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate()) ? F.multiply(AE).setScale(2, RoundingMode.HALF_UP) : F.multiply(AE);
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            if (DateHelper.afterOrEqual((Date)this.mVplib.gueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                if (svTage.compareTo(BigDecimal.ZERO) != 0) {
                    beitrPflEinnahme = beitrPflEinnahme.multiply(svTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                }
            } else {
                beitrPflEinnahme = DateHelper.before((Date)this.mVplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) ? beitrPflEinnahme.multiply(svTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : beitrPflEinnahme.multiply(this.mVplib.tageMitEFZ()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
            }
        }
        return beitrPflEinnahme;
    }

    private BigDecimal getEntgeltUnterhalbGleitzoneMfB(BigDecimal arbeitsentgelt, BigDecimal entgeltAbwAG, BigDecimal svTage) throws BusinessDomainException {
        BigDecimal beitrPflEinnahme = BigDecimal.ZERO;
        BigDecimal F = this.mF;
        BigDecimal AE = arbeitsentgelt;
        BigDecimal GAE = arbeitsentgelt.add(entgeltAbwAG);
        beitrPflEinnahme = DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2009, 0, 1).getDate()) ? F.multiply(GAE).multiply(AE).divide(GAE, 2, RoundingMode.HALF_UP) : F.multiply(GAE).multiply(AE).divide(GAE);
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            if (DateHelper.afterOrEqual((Date)this.mVplib.gueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                if (svTage.compareTo(BigDecimal.ZERO) != 0) {
                    beitrPflEinnahme = beitrPflEinnahme.multiply(svTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                }
            } else {
                beitrPflEinnahme = DateHelper.before((Date)this.mVplib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate()) ? beitrPflEinnahme.multiply(svTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : beitrPflEinnahme.multiply(this.mVplib.tageMitEFZ()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
            }
        }
        return beitrPflEinnahme;
    }
}

