/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.ErmittlungAVEntgeltGleitzone2022Formula;
import com.varial.personnel.domain.evaluation.formula.ErmittlungGleitzonenEntgeltFormula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungAVEntgeltGleitzoneFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mAVBBG = BigDecimal.ZERO;
    private BigDecimal mAVBemessungsentgelt = BigDecimal.ZERO;
    private BigDecimal mEntgeltAbwAG = BigDecimal.ZERO;
    private BigDecimal mEntgeltEGAAbwAG = BigDecimal.ZERO;
    private BigDecimal mEntgeltLfdAbwAG = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltEGA = BigDecimal.ZERO;
    private BigDecimal mGesEntgeltLfd = BigDecimal.ZERO;
    private BigDecimal zwAVBBG = BigDecimal.ZERO;
    private BigDecimal zwSVEntgelt = BigDecimal.ZERO;

    public ErmittlungAVEntgeltGleitzoneFormula(CalculationLibrary caLibrary, EmployeeLibrary eeLibrary, GlobalLibrary glLibrary, ValuePositionLibrary vpLibrary) {
        this.mCalLib = caLibrary;
        this.mEeLib = eeLibrary;
        this.mGlLib = glLibrary;
        this.mVpLib = vpLibrary;
    }

    public void ermittel() throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2022, 9, 1).getDate()) && !this.mEeLib.kennzBestandGleitzone2022()) {
            new ErmittlungAVEntgeltGleitzone2022Formula(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib).ermittel();
        } else {
            ValuePosition genesis;
            BigDecimal result = this.mVpLib.result();
            BigDecimal avTage = this.mVpLib.avTageMarb();
            this.ermittleAVEntgeltImMonat();
            BigDecimal entgeltAufgelaufen = this.mGesEntgeltLfd.add(this.mGesEntgeltEGA);
            switch (this.mVpLib.wertartenNummer()) {
                case 333514: {
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.add(result);
                    break;
                }
                case 333614: {
                    this.mGesEntgeltEGA = this.mGesEntgeltEGA.add(result);
                }
            }
            this.mAVBBG = this.mGlLib.svBbgRvAv().multiply(avTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
            if (this.mGesEntgeltEGA.compareTo(BigDecimal.ZERO) != 0) {
                this.abgrenzungEGA();
            }
            this.mVpLib.addNeueWertPosition(333590, BigDecimal.ZERO, BigDecimal.ZERO, avTage, BigDecimal.ZERO, this.mAVBBG, true);
            this.modifikationTeilLZZ(avTage);
            BigDecimal gesEntgelt = this.mGesEntgeltLfd.add(this.mGesEntgeltEGA);
            if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && this.mCalLib.dbgzVorhanden()) {
                if (this.mCalLib.dbgzSVTG() == 0) {
                    throw EvaluationExceptionMapper.makeZeroDaysInDbgzNotAllowedDomainException(this.mCalLib.berchnungGueltigAb());
                }
                if (this.mCalLib.dbgzSVTG() != 30) {
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(BigDecimal.valueOf(this.mCalLib.dbgzSVTG()), 2, RoundingMode.HALF_UP);
                }
            }
            if (this.mCalLib.dbgzVorhanden()) {
                if (this.mCalLib.dbgzKennzGLZ().value() == 1) {
                    this.mEntgeltAbwAG = this.mEntgeltLfdAbwAG.add(this.mEntgeltEGAAbwAG);
                }
            } else if (this.mEeLib.isMehrfachbeschaeftigt() && !this.mEeLib.isMarbGleitzoneNurAV() && this.mEeLib.marbBgrAvAndererAG() != 0) {
                this.mEntgeltAbwAG = this.mEntgeltLfdAbwAG.add(this.mEntgeltEGAAbwAG);
            }
            BigDecimal tempAvTage = avTage;
            if (BigDecimalMapper.isZero((BigDecimal)avTage) && (genesis = this.mVpLib.genesisParent()) != null) {
                ValuePosition[] vpos;
                for (ValuePosition vp : vpos = this.mVpLib.genesisUndFolgen()) {
                    if (vp.getValueType().getValueTypeKey() != 130610) continue;
                    tempAvTage = BigDecimal.valueOf(30L);
                }
            }
            ErmittlungGleitzonenEntgeltFormula gleitzonenEntgeltFormula = new ErmittlungGleitzonenEntgeltFormula(this.mCalLib, this.mEeLib, this.mGlLib, this.mVpLib);
            BigDecimal beitrPflEinnahmeGesamt = gleitzonenEntgeltFormula.getEntgeltGleitzone(gesEntgelt, this.mEntgeltAbwAG, tempAvTage);
            if (avTage.compareTo(BigDecimal.ZERO) != 0) {
                if (this.mVpLib.wertartenNummer() == 333614) {
                    gesEntgelt = gesEntgelt.subtract(result);
                    gesEntgelt = gesEntgelt.multiply(avTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                    gesEntgelt = gesEntgelt.add(result);
                } else {
                    gesEntgelt = gesEntgelt.multiply(avTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                }
            }
            BigDecimal beitrPflEinnahme = beitrPflEinnahmeGesamt.subtract(this.mAVBemessungsentgelt);
            BigDecimal beitrPflGesamt = gesEntgelt.subtract(entgeltAufgelaufen);
            this.erzeugeWertpositionen(beitrPflEinnahme, beitrPflGesamt, avTage);
            this.mCalLib.result(result);
        }
    }

    private void ermittleAVEntgeltImMonat() throws BusinessDomainException {
        ValuePosition[] vpArray;
        block7: for (ValuePosition vPos : vpArray = this.mVpLib.wpAusWPListeOderDB(this.mCalLib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungWirksamAb()), this.mCalLib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes(129200, 129205, 129210, 129215, 333514, 333614, 333616))) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 129200: 
                case 129205: {
                    if (this.mEeLib.marbBgrAvAndererAG() == 0 && !this.mCalLib.dbgzVorhanden()) continue block7;
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.add(vPos.getResult());
                    continue block7;
                }
                case 129210: 
                case 129215: {
                    if (this.mEeLib.marbBgrAvAndererAG() == 0 && !this.mCalLib.dbgzVorhanden()) continue block7;
                    this.mEntgeltEGAAbwAG = this.mEntgeltEGAAbwAG.add(vPos.getResult());
                    continue block7;
                }
                case 333514: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getBufferResult())) continue block7;
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.add(vPos.getBufferResult());
                    continue block7;
                }
                case 333614: {
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)vPos.getBufferResult())) continue block7;
                    this.mGesEntgeltEGA = this.mGesEntgeltEGA.add(vPos.getBufferResult());
                    continue block7;
                }
                case 333616: {
                    this.mAVBemessungsentgelt = this.mAVBemessungsentgelt.add(vPos.getResult());
                    continue block7;
                }
            }
        }
    }

    private void abgrenzungEGA() throws BusinessDomainException {
        this.zwAVBBG = this.mAVBBG;
        this.zwSVEntgelt = BigDecimal.ZERO;
        this.zwSVEntgelt = this.mCalLib.dbgzVorhanden() ? (this.mCalLib.dbgzKennzGLZ().value() == 1 ? this.mGesEntgeltLfd.add(this.mEntgeltLfdAbwAG).add(this.mEntgeltEGAAbwAG) : this.mGesEntgeltLfd) : (this.mEeLib.isMehrfachbeschaeftigt() ? this.mGesEntgeltLfd.add(this.mEntgeltLfdAbwAG).add(this.mEntgeltEGAAbwAG) : this.mGesEntgeltLfd);
        if (this.zwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.zwAVBBG) > 0) {
            this.holeJahresWerte();
            if (this.zwSVEntgelt.add(this.mGesEntgeltEGA).compareTo(this.zwAVBBG) > 0) {
                this.mGesEntgeltEGA = this.zwSVEntgelt.compareTo(this.zwAVBBG) < 0 ? this.zwAVBBG.subtract(this.zwSVEntgelt) : BigDecimal.ZERO;
            }
        }
    }

    private void modifikationTeilLZZ(BigDecimal avTage) throws BusinessDomainException {
        if (this.mEeLib.isTeilLZZVorhanden() && !this.mCalLib.getCalculationCase().isSignedAs23cSGBIV()) {
            if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2011, 0, 1).getDate())) {
                if (avTage.compareTo(BigDecimal.ZERO) != 0) {
                    this.mGesEntgeltLfd = this.mVpLib.hochrechnungGleitzonenEntgeltBeiLZZ(this.mGesEntgeltLfd, avTage);
                    this.mEntgeltLfdAbwAG = this.mVpLib.hochrechnungGleitzonenEntgeltBeiLZZ(this.mEntgeltLfdAbwAG, avTage);
                } else {
                    this.mGesEntgeltLfd = BigDecimal.ZERO;
                    this.mEntgeltLfdAbwAG = BigDecimal.ZERO;
                }
            } else if (DateHelper.before((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2007, 0, 1).getDate())) {
                if (avTage.compareTo(BigDecimal.ZERO) != 0) {
                    this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(avTage, 2, RoundingMode.HALF_UP);
                    this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(avTage, 2, RoundingMode.HALF_UP);
                }
            } else if (this.mVpLib.tageMitEFZ().compareTo(BigDecimal.ZERO) != 0) {
                this.mGesEntgeltLfd = this.mGesEntgeltLfd.multiply(DREISSIG).divide(this.mVpLib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
                this.mEntgeltLfdAbwAG = this.mEntgeltLfdAbwAG.multiply(DREISSIG).divide(this.mVpLib.tageMitEFZ(), 2, RoundingMode.HALF_UP);
            }
        }
    }

    private void erzeugeWertpositionen(BigDecimal beitrPflEinnahme, BigDecimal gesEntgelt, BigDecimal avTage) throws BusinessDomainException {
        boolean kugFeiertagsentgelt = false;
        ValuePosition genesisVP = this.mVpLib.genesisParent();
        if (genesisVP.getValueType().getValueTypeKey() == 99973) {
            kugFeiertagsentgelt = true;
        }
        if (kugFeiertagsentgelt) {
            this.mVpLib.addNeueWertPosition(335514, gesEntgelt, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
        } else if (this.mEeLib.marbBgrAv() == 1) {
            if (this.mEeLib.isMarbAltersRentner()) {
                this.mEeLib.checkAVBGSBeiAltersvollrentner(this.mCalLib.berchnungGueltigAb());
            }
            this.mVpLib.addNeueWertPosition(334514, gesEntgelt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
            this.mVpLib.addNeueWertPosition(335514, gesEntgelt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
        } else if (this.mEeLib.marbBgrAv() == 2) {
            if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2017, 0, 1).getDate()) && DateHelper.beforeOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2021, 11, 31).getDate()) && this.mEeLib.isMarbAltersRentner()) {
                this.mEeLib.checkAVBGSBeiAltersvollrentner(this.mCalLib.berchnungGueltigAb());
            }
            if (this.mEeLib.marbAVBefreiungAG()) {
                this.mVpLib.addNeueWertPosition(334514, gesEntgelt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
            } else {
                this.mVpLib.addNeueWertPosition(335514, gesEntgelt, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, beitrPflEinnahme, false);
            }
        }
        this.mVpLib.addNeueWertPosition(333616, BigDecimal.ZERO, BigDecimal.ZERO, avTage, BigDecimal.ZERO, beitrPflEinnahme, false);
    }

    private void holeJahresWerte() throws BusinessDomainException {
        ValuePosition[] zwVPArray = null;
        Date sucheBeginnDatum = DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb());
        Date sucheEndeDatum = DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb());
        while (DateHelper.before((Date)sucheBeginnDatum, (Date)sucheEndeDatum)) {
            block5: for (ValuePosition vPos : zwVPArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), sucheBeginnDatum, DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum), ValueTypeHelper.getValueTypes(333590, 333510, 333514, 333610, 333614))) {
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 333590: {
                        this.zwAVBBG = this.zwAVBBG.add(vPos.getResult());
                        continue block5;
                    }
                    case 333510: 
                    case 333514: 
                    case 333610: 
                    case 333614: {
                        this.zwSVEntgelt = this.zwSVEntgelt.add(vPos.getResult());
                        continue block5;
                    }
                }
            }
            sucheBeginnDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)sucheBeginnDatum));
        }
    }
}

